/*Ҫע

imgOrigArr  imgRanfArrֱȷ˳кеƬϢ
ṹarr[Ƭڵ±] = Ƭʾλ

 */

/**
 * [puzzleGame puzzleGame]
 * @param  {[jsonʽ]} param [ͼƬ ·+]
 * @return       []
 */
var puzzleGame = function(param){
/*************  ******************/
	this.img = param.img || '';//ͼƬ

/************* ڵ ******************/
	this.btnStart = $('#start');//ʼϷť
	this.btnLevel = $('#level');//Ѷѡť
	this.imgArea = $('#imgArea');//ͼƬʾ

	this.imgCells = '';//ڼ¼Ƭڵı

/*************  ******************/	
	this.imgOrigArr = [];//ͼƬֺ󣬴洢ȷ
	this.imgRandArr = [];//ͼƬ˳󣬴洢ǰ

	this.levelArr = [[3,3],[4,4],[6,6]];//洢Ѷȵȼ
	this.levelNow = 0;//ʾǰѶȵȼıѶʹ

	//ͼƬĿ
	this.imgWidth = parseInt(this.imgArea.css('width'));
	this.imgHeight = parseInt(this.imgArea.css('height'));
	//ΪƬÿһƬĿ
	this.cellWidth = this.imgWidth/this.levelArr[this.levelNow][1];
	this.cellHeight = this.imgHeight/this.levelArr[this.levelNow][0];

	this.hasStart = 0;//¼ǷʼıĬfasleδʼ
	this.moveTime = 400;//¼animate˶ʱ䣬Ĭ400
	
	//óʼͼƬ,󶨰ť
	this.init();
}


/**
 * [prototype puzzleGameӷjsonʽʾ]
 * @type {Object}
 */
puzzleGame.prototype = {
	/**
	 * [init ʼЧ]
	 * @return []
	 */
	init:function(){
		this.imgSplit();
		this.levelSelect();
		this.gameState();
	},

	/**
	 * [imgSplit ͼƬΪƬ]
	 * @param  obj    [ͼƬ,·+]
	 * @param  cellW  [Ƭ]
	 * @param  cellH  [Ƭ߶]
	 * @return        [¼ȷ]
	 */
	imgSplit:function(){
		this.imgOrigArr = [];//ȷ

		//ͼƬƬ룬ÿһβͼƬ֮ǰֵۻ
		//һβ3x3,9divûգڶβ4x4ʱǰ9div֮ٲ14div9+16div
		this.imgArea.html("");

		var cell = '';//¼ͼƬƬı
		for(var i=0;i<this.levelArr[this.levelNow][0];i++){
			for(var j=0;j<this.levelArr[this.levelNow][1];j++){
				//Ƭdiv±飬УǷ
				this.imgOrigArr.push(i*this.levelArr[this.levelNow][1]+j);

				cell = document.createElement("div");
				cell.className = "imgCell";
				$(cell).css({
					'width':(this.cellWidth - 2) + 'px',
					'height':(this.cellHeight - 2) + 'px',
					'left':j * this.cellWidth + 'px',
					'top':i * this.cellHeight + 'px',
					"background":"url('"+this.img+"')",
					'backgroundPosition':(-j)*this.cellWidth + 'px ' + (-i)*this.cellHeight + 'px'
				});
				this.imgArea.append(cell);
			}
		}
		this.imgCells = $('#imgArea div.imgCell');//Ƭڵ
	},

	levelSelect:function(){
		var len = this.levelArr.length;
		var self = this;
		this.btnLevel.bind('mousedown',function(){
			$(this).addClass('mouseOn');
		}).bind('mouseup',function(){
			$(this).removeClass('mouseOn');
		}).bind('click',function(){
			//жǷϷ
			if(self.hasStart){
				//if(!confirm('ѾϷУȷҪıϷѶô')){
				//	return false;
				//}else{
					self.hasStart = false;
					self.btnStart.text('ʼ');
				//}
			}
			//ݸı
			self.levelNow ++;
			if(self.levelNow >= len){
				self.levelNow = 0;
			}
			//ʾѶȸı
			$(this).text(self.levelArr[self.levelNow][0] + 'x' + self.levelArr[self.levelNow][1]);
			//ͼƬ²(¼)
			self.cellWidth = self.imgWidth/self.levelArr[self.levelNow][1];
			self.cellHeight = self.imgHeight/self.levelArr[self.levelNow][0];
			self.imgSplit();
		});
	},

	/**
	 * [gameStart ʼ/ظ Ϸĺ]
	 * @return []
	 */
	gameState:function(){
		var self = this;

		this.btnStart.bind('mousedown',function(){
			$(this).addClass('mouseOn');
		}).bind('mouseup',function(){
			$(this).removeClass('mouseOn');
		}).bind('click',function(){
			if(self.hasStart == 0){//Ϸ
				//ʼϷ󲿷ֵʽ
				$(this).text('ԭ');
				self.hasStart = 1;

				//ͼƬ
				self.randomArr();
				self.cellOrder(self.imgRandArr);

				//ͼƬ¼
				self.imgCells.css({
					'cursor':'pointer'
				}).bind('mouseover',function(){
					$(this).addClass('hover');
				}).bind('mouseout',function(){
					$(this).removeClass('hover');
				}).bind('mousedown',function(e){
					/*˴ͼƬƶ*/
					$(this).css('cursor','move');

					//ѡͼƬƬ±ԼԸƬλ
					var cellIndex_1 = $(this).index();
					var cell_mouse_x = e.pageX - self.imgCells.eq(cellIndex_1).offset().left;
					var cell_mouse_y = e.pageY - self.imgCells.eq(cellIndex_1).offset().top;

					$(document).bind('mousemove',function(e2){
						self.imgCells.eq(cellIndex_1).css({
							'z-index':'40',
							'left':(e2.pageX - cell_mouse_x - self.imgArea.offset().left) + 'px',
							'top':(e2.pageY - cell_mouse_y - self.imgArea.offset().top) + 'px'
						});
					}).bind('mouseup',function(e3){
						//Ƭ±
						var cellIndex_2 = self.cellChangeIndex((e3.pageX-self.imgArea.offset().left),(e3.pageY-self.imgArea.offset().top),cellIndex_1);
						
						//Ƭ
						if(cellIndex_1 == cellIndex_2){
							self.cellReturn(cellIndex_1);
						}else{
							self.cellExchange(cellIndex_1,cellIndex_2);
						}

						//Ƴ
						$(document).unbind('mousemove').unbind('mouseup');
					});
				}).bind('mouseup',function(){
					$(this).css('cursor','pointer');
				});
			}else if(self.hasStart == 1){
				//if(!confirm('ѾϷУȷҪظԭͼ')){
				//	return false;
				//}
				//ʽָ
				$(this).text('ʼ');
				self.hasStart = 0;

				//ԭͼƬ
				self.cellOrder(self.imgOrigArr);

				//ȡ¼
				self.imgCells.css('cursor','default').unbind('mouseover').unbind('mouseout').unbind('mousedown');				
			}
		});		
	},

	/**
	 * [randomArr ɲظĺ]
	 * @return []
	 */
	randomArr:function(){
		//
		this.imgRandArr = [];

		var order;//¼¼ͼƬʲôλ
		for(var i=0,len=this.imgOrigArr.length;i<len;i++){
			order = Math.floor(Math.random()*len);
			if(this.imgRandArr.length > 0){
				while(jQuery.inArray(order,this.imgRandArr) > -1){
					order = Math.floor(Math.random()*len);
				}
			}
			this.imgRandArr.push(order);
		}
		return;
	},

	/**
	 * [cellOrder ͼƬĺ]
	 * @param  arr [飬]
	 * @return     []
	 */
	cellOrder:function(arr){
		for(var i=0,len=arr.length;i<len;i++){
			this.imgCells.eq(i).animate({
				'left': arr[i]%this.levelArr[this.levelNow][1]*this.cellWidth + 'px',
				'top': Math.floor(arr[i]/this.levelArr[this.levelNow][0])*this.cellHeight + 'px'
			},this.moveTime);
		}
	},

	/**
	 * [cellChangeIndex ͨ꣬㱻Ƭ±]
	 * @param  x    [x]
	 * @param  y    [y]
	 * @param  orig [϶Ƭ±ֹ꣬ƬʱԭƬ]
	 * @return      [ڵڽڵбе±]
	 */
	cellChangeIndex:function(x,y,orig){
		//϶ƬͼƬ
		if(x<0 || x>this.imgWidth || y<0 || y>this.imgHeight){
			return orig;
		}
		//϶ƬڴͼΧƶ
		var row = Math.floor(y/this.cellHeight),col = Math.floor(x/this.cellWidth),location=row*this.levelArr[this.levelNow][1]+col;
		var i=0,len=this.imgRandArr.length;
		while((i<len) && (this.imgRandArr[i] != location)){
			i++;
		}
		return i;
	},

	/**
	 * [cellExchange ͼƬƬн]
	 * @param  from [϶Ƭ]
	 * @param  to   [Ƭ]
	 * @return      [ɹΪtrue,ʧΪfalse]
	 */
	cellExchange:function(from,to){
		var self = this;
		//϶ͼƬͼƬС
		var rowFrom = Math.floor(this.imgRandArr[from]/this.levelArr[this.levelNow][1]);
		var colFrom = this.imgRandArr[from]%this.levelArr[this.levelNow][1];
		var rowTo = Math.floor(this.imgRandArr[to]/this.levelArr[this.levelNow][1]);
		var colTo = this.imgRandArr[to]%this.levelArr[this.levelNow][1];

		var temp = this.imgRandArr[from];//϶ͼƬ±꣬ʱ洢

		//϶ͼƬ任λ
		this.imgCells.eq(from).animate({
			'top':rowTo*this.cellHeight + 'px',
			'left':colTo*this.cellWidth + 'px'
		},this.moveTime,function(){
			$(this).css('z-index','10');
		});
		//ͼƬ任λ
		this.imgCells.eq(to).css('z-index','30').animate({
			'top':rowFrom*this.cellHeight + 'px',
			'left':colFrom*this.cellWidth + 'px'
		},this.moveTime,function(){
			$(this).css('z-index','10');

			//ͼƬ洢
			self.imgRandArr[from] = self.imgRandArr[to];
			self.imgRandArr[to] = temp;

			//жǷȫƶԽϷ
			if(self.checkPass(self.imgOrigArr,self.imgRandArr)){
				self.success();
			}
		});
	},

	/**
	 * [cellReturn ϶ͼƬԭλõĺ]
	 * @param  index [϶ͼƬ±]
	 * @return       []
	 */
	cellReturn:function(index){
		var row = Math.floor(this.imgRandArr[index]/this.levelArr[this.levelNow][1]);
		var col = this.imgRandArr[index]%this.levelArr[this.levelNow][1];

		this.imgCells.eq(index).animate({
			'top':row*this.cellHeight + 'px',
			'left':col*this.cellWidth + 'px'
		},this.moveTime,function(){
			$(this).css('z-index','10');
		});
	},

	/**
	 * [checkPass жϷǷɹĺ]
	 * @param  rightArr  [ȷ]
	 * @param  puzzleArr [ƴͼƶ]
	 * @return           [ǷϷıǣǷtrue񷵻false]
	 */
	checkPass:function(rightArr,puzzleArr){
		if(rightArr.toString() == puzzleArr.toString()){
			return true;
		}
		return false;
	},

	/**
	 * [success ɹϷĴ]
	 * @return [description]
	 */
	success:function(){
		//ȡʽ¼
		for(var i=0,len=this.imgOrigArr.length;i<len;i++){
			if(this.imgCells.eq(i).has('mouseOn')){
				this.imgCells.eq(i).removeClass('mouseOn');
			}
		}
		this.imgCells.unbind('mousedown').unbind('mouseover').unbind('mouseout');
		this.btnStart.text('ʼ');
		this.hasStart = 0;
		//alert('ϲɹɱϷ');
		src_i=$("#src_hide").val();//ȡʼֵ
		var ajaxform_pintu=$.post("/givepitu.php",{src_i:src_i},function(result){	
			alert(result);
		})
	}
}

/* ͼƬд */
function pintu(){
	$("#imgArea").hide();//Ч
	src=$("#src_hide").val();//ȡʼֵ
	
	if (src>6){//һжͼ
		src=1;//ʼͼp_1.jpg
	}
	src_str='/images/pintu/p_'+src+'.jpg';
	var pg = new puzzleGame({'img':src_str});
	src++;
	$("#src_hide").val(src);
	$("#imgArea").fadeIn(500)
};

