<?php
/*
	[JBLOG] (C) 2008-2009 JBLOG TEAM.
	$QQ : 22823459 
	$Email : lisijie86@gmail.com
	$Url : http://www.lisijie.org
*/

!defined('IN_JBLOG') && exit('Access Denied!');

//刷新缓存
function recache($cachestr = '') {
	if (!$cachestr) {
		$cachelist = array('config','category','usergroup','archive','lastest_article','commend_article','lastest_comment','link','linkgroup','tag','plugin','page');
	} else {
		$cachelist = explode(',',$cachestr);
	}
	foreach ($cachelist as $cache) {
		$cachename = $cache.'_recache';
		if (function_exists($cachename)) {
			$cachename();
		}
	}
}

//将字符串写进文件
function write_to_file($cachename,$content = '') {
	if (is_array($content)) {
		$content = "\$_CACHE['$cachename'] = ".var_export($content,True).';';
	}
	$content = "<?php\n//该文件是系统自动生成的缓存文件，请勿修改\n//创建时间：".get_date('Y-m-d H:i:s',time())."\n\nif (!defined('IN_JBLOG')) {exit('Access Denied!');}\n\n".$content."\n\n?>";
	$filename = CACHE_ROOT.'cache_'.$cachename.'.php';
	$len = file_put_contents($filename, $content);
	@chmod($filename, 0777);
	return $len;
}

//缓存配置信息
function config_recache() {
	global $db;
	$content = array();
	$sql = "SELECT * FROM ".DB_TABLEPRE."config";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$content[$row['type']][$row['name']] = $row['value'];
	}
	//写入文件
	write_to_file('config',$content);
}

//缓存博客分类
function category_recache() {
	global $db,$_CACHE;
	$content = array();
	$sql = "SELECT * FROM ".DB_TABLEPRE."category ORDER BY orderid";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$count = $db->result("SELECT COUNT(*) AS num FROM ".DB_TABLEPRE."article WHERE `status` < 4 AND cid = ".$row['id']);
		$db->query("UPDATE ".DB_TABLEPRE."category SET `count` = '$count' WHERE id = ".$row['id']);
		$row['count'] = $count;
		if ( $_CACHE['config']['seo']['rewrite'] == 1 ) {
			$row['url'] = 'category/';
			$row['url'] .= empty($row['urlname']) ? $row['id'].'/' : rawurlencode($row['urlname']).'/';
		} else {
			$row['url'] = './index.php?cid='.$row['id'];
		}
		if ( !empty($row['redirect']) ) {
			$row['url'] = $row['redirect'];
		}
		$content[$row['id']] = $row;
	}
	write_to_file('category',$content);
}

//缓存用户组
function usergroup_recache() {
	global $db;
	$sql = "SELECT * FROM ".DB_TABLEPRE."usergroup";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$content = "<?php\n//该文件是系统自动生成的缓存文件，请勿修改\n//创建时间：".get_date('Y-m-d H:i:s',time())."\n\nif (!defined('IN_JBLOG')) {exit('Access Denied!');}\n\n";
		$content .= "\$groupname = '$row[groupname]';\n";
		$content .= "\$purview = ".var_export(unserialize($row['purview']), true);
		$content .= "\n?>";
		$filename = CACHE_ROOT.'cache_usergroup_'.$row['id'].'.php';
		file_put_contents($filename, $content);
		@chmod($filename, 0777);
	}
}

//缓存日志归档
function archive_recache() {
	global $db,$_CACHE;
	$content = array();
	$limit = intval($_CACHE['config']['display']['archive_num']) ? ' LIMIT 0,'.intval($_CACHE['config']['display']['archive_num']) : '';
	$sql = "SELECT yearmonth,COUNT(*) AS num FROM ".DB_TABLEPRE."calendar GROUP BY yearmonth ORDER BY yearmonth DESC {$limit}";
	$result = $db->query($sql);
	while ($row = $db->fetch_array($result)) {
		$archive = array('yearmonth' => $row['yearmonth'],'year' => substr($row['yearmonth'],0,4),'month' => substr($row['yearmonth'],4),'count' => $row['num']);
		if ( $_CACHE['config']['seo']['rewrite'] == 1 ) {
			$archive['url'] = "archive/{$row[yearmonth]}/";
		} else {
			$archive['url'] = "./index.php?archive={$row[yearmonth]}";
		}
		$content[] = $archive;
	}
	write_to_file('archive',$content);
}

//缓存最新文章
function lastest_article_recache() {
	global $db,$_CACHE;
	$content = array();
	$limit = ' LIMIT 0,'.intval($_CACHE['config']['display']['sidebar_num']);
	$sql = "SELECT a.id,a.username,a.title,a.urlname,a.dateline,b.urlname AS catename,b.id AS cid FROM ".DB_TABLEPRE."article a JOIN ".DB_TABLEPRE."category b ON a.cid = b.id WHERE a.status < 3 AND a.ischeck = 1 AND b.ishide = 0 ORDER BY a.dateline DESC $limit";
	$query = $db->query($sql);
	while ( $row = $db->fetch_array($query) ) {
		if ( $_CACHE['config']['seo']['rewrite'] == 1 ) {
			$row['url'] = 'article/';
			$row['url'] .= empty($row['urlname']) ? $row['id'] : rawurlencode($row['urlname']);
			$row['url'] .= '/';
		} elseif ( $_CACHE['config']['seo']['rewrite'] == 2 ) {
			!$row['catename'] && $row['catename'] = $row['cid'];
			$row['url'] = get_html_dir($row['dateline'],$row['catename']).'/'.(empty($row['urlname']) ? $row['id'] : rawurlencode($row['urlname'])).'.html';
		} else {
			$row['url'] = './?aid='.$row['id'];
		}
		unset($row['urlname'],$row['catename'],$row['cid']);
		$content[] = $row;
	}
	write_to_file('lastest_article',$content);
}

//缓存推荐文章
function commend_article_recache() {
	global $db,$_CACHE;
	$content = array();
	$limit = ' LIMIT 0,'.intval($_CACHE['config']['display']['sidebar_num']);
	$sql = "SELECT a.id,a.username,a.title,a.urlname,a.dateline,b.urlname AS catename,b.id AS cid FROM ".DB_TABLEPRE."article a  JOIN ".DB_TABLEPRE."category b ON a.cid = b.id WHERE a.status < 3 AND a.ischeck = 1 AND a.iscommend = 1 AND b.ishide = 0 ORDER BY a.dateline DESC $limit";
	$query = $db->query($sql);
	while ( $row = $db->fetch_array($query) ) {
		if ( $_CACHE['config']['seo']['rewrite'] == 1 ) {
			$row['url'] = 'article/';
			$row['url'] .= empty($row['urlname']) ? $row['id'] : rawurlencode($row['urlname']);
			$row['url'] .= '/';
		} elseif ( $_CACHE['config']['seo']['rewrite'] == 2 ) {
			!$row['catename'] && $row['catename'] = $row['cid'];
			$row['url'] = get_html_dir($row['dateline'],$row['catename']).'/'.(empty($row['urlname']) ? $row['id'] : rawurlencode($row['urlname'])).'.html';
		} else {
			$row['url'] = './?aid='.$row['id'];
		}
		unset($row['urlname'],$row['catename'],$row['cid']);
		$content[] = $row;
	}
	write_to_file('commend_article',$content);
}

//缓存最新评论
function lastest_comment_recache() {
	global $db,$_CACHE;
	$content = array();
	$limit = ' LIMIT 0,'.intval($_CACHE['config']['display']['sidebar_num']);
	$sql = "SELECT a.id,a.aid,a.uid,a.username,a.content,a.dateline,b.dateline AS posttime,a.ishide,b.title,b.urlname,c.urlname AS catename,c.id AS cid FROM ".DB_TABLEPRE."comment a JOIN ".DB_TABLEPRE."article b ON a.aid = b.id JOIN ".DB_TABLEPRE."category c ON b.cid = c.id WHERE c.ishide = 0 AND a.ischeck = 1 ORDER BY a.id DESC $limit";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		if ( $_CACHE['config']['seo']['rewrite'] ==1 ) {
			$row['url'] = 'article/';
			$row['url'] .= empty($row['urlname']) ? $row['aid'] : rawurlencode($row['urlname']);
			$row['url'] .= '/#comment-'.$row['id'];
		} elseif ( $_CACHE['config']['seo']['rewrite'] ==2 ) {
			!$row['catename'] && $row['catename'] = $row['cid'];
			$row['url'] = get_html_dir($row['posttime'],$row['catename']).'/'.(empty($row['urlname']) ? $row['aid'] : rawurlencode($row['urlname'])).'.html#comment-'.$row['id'];
		} else {
			$row['url'] = './?aid='.$row['aid'].'#comment-'.$row['id'];
		}
		if ($row['ishide']) $row['content'] = '这是一条隐藏评论';
		$row['content'] = cut_str(strip_tags($row['content']), $_CACHE['config']['display']['sidebar_charnum']);
		unset($row['urlname'], $row['ishide'], $row['catename'], $row['cid'], $row['posttime']);
		$content[] = $row;
	}
	write_to_file('lastest_comment',$content);
}

//缓存友情链接
function link_recache() {
	global $db;
	$content = array();
	$sql = "SELECT a.id AS groupid,a.status,a.groupname,b.name,b.url,b.logo,b.description FROM ".DB_TABLEPRE."linkgroup a JOIN ".DB_TABLEPRE."link b ON a.id = b.groupid WHERE a.status <> 3 AND b.visible = 1 ORDER BY a.orderid ASC, b.orderid ASC";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		if ( !array_key_exists($row['groupid'], $content) ) {
			$content[$row['groupid']] = array(
				'groupname' => $row['groupname'],
				'status' => $row['status'],
				'links' => array()
			);
		}
		$content[$row['groupid']]['links'][] = array(
			'name' => $row['name'],
			'url' => $row['url'],
			'logo' => $row['logo'],
			'description' => $row['description'],
		);
	}
	write_to_file('link',$content);
}

//缓存链接分组
function linkgroup_recache() {
	global $db;
	$content = array();
	$query = $db->query("SELECT * FROM ".DB_TABLEPRE."linkgroup ORDER BY orderid");
	while ($row = $db->fetch_array($query)) {
		$content[$row['id']] = array(
			'groupname' => $row['groupname'],
			'status' => $row['status']
		);
	}
	write_to_file('linkgroup',$content);
}

//缓存Tag标签
function tag_recache() {
	global $db;
	$content = array();
	$sql = "SELECT id,tagname,`count` FROM ".DB_TABLEPRE."tag WHERE `count` > 0 ORDER BY id ASC";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$content[$row['id']] = array('tagname' => $row['tagname'],'count' => $row['count']);
	}
	write_to_file('tag',$content);
}

//缓存插件信息
function plugin_recache() {
	global $db;
	$content = array();
	$sql = "SELECT * FROM ".DB_TABLEPRE."plugin";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$content[$row['identifier']] = array('id' => $row['id'],'name' => $row['name'],'directory' => $row['directory'],'enabled' => $row['enabled'], 'runmode' => $row['runmode']);
		write_to_file('plugin_'.$row['id'], $row);
	}
	write_to_file('plugin',$content);
}

//缓存自定义页面信息
function page_recache() {
	global $db;
	$content = array();
	$sql = "SELECT id,pagename,filepath FROM ".DB_TABLEPRE."page WHERE ishide = 0 ORDER BY orderid";
	$content = $db->fetch_all($sql);
	write_to_file('page',$content);
}
?>