<?php
/*
	[JBLOG] (C) 2008-2009 JBLOG TEAM.
	$QQ : 22823459 
	$Email : lisijie86@gmail.com
	$Url : http://www.lisijie.org
*/

!defined('IN_JBLOG') && exit('Access Denied!');

require_once(JBLOG_ROOT.'./include/template_article.php');
require_once(JBLOG_ROOT.'./include/template_sidebar.php');
require_once(JBLOG_ROOT.'./include/template_comment.php');

//页面标题
function get_title() {
	global $_CACHE;
	if (isset($_ENV['title'])) {
		echo $_ENV['title'].' - '.$_CACHE['config']['blog']['name'];
	} else {
		echo $_CACHE['config']['blog']['name'].' - '.$_CACHE['config']['blog']['subtitle'];
	}
}

//keyword标签
function get_keyword() {
	global $_CACHE;
	echo isset($_ENV['keywords']) ? $_ENV['keywords'] : $_CACHE['config']['blog']['keywords'];
}

//description标签
function get_description() {
	global $_CACHE;
	echo isset($_ENV['description']) ? $_ENV['description'] : $_CACHE['config']['blog']['description'];
}

//js
function get_javascript() {
	global $_CACHE;
	$output .= "<script language=\"javascript\" type=\"text/javascript\" src=\"script/jquery.js\"></script>
	<script language=\"javascript\" type=\"text/javascript\" src=\"script/common.js\"></script>
	";
	$output .= "<script language=\"javascript\" type=\"text/javascript\">
		var blog_url = '".$_CACHE['config']['blog']['url']."';
		var image_resize_width = ".$_CACHE['config']['display']['image_resize_width'].";
	</script>
	";
	echo $output;
}

//博客信息
function get_blog_info($key) {
	global $_CACHE;
	$value = '';
	$others = array();
	$others['version'] = JBLOG_VERSION;
	$others['release'] = JBLOG_RELEASE;
	if (array_key_exists($key, $_CACHE['config']['blog'])) {
		$value = $_CACHE['config']['blog'][$key];
	} elseif (array_key_exists($key, $others)) {
		$value = $others[$key];
	}
	echo $value;
}

//主题
function get_theme() {
	global $_CACHE;
	$theme = 'themes/'.$_CACHE['config']['blog']['theme'];
	echo $theme;
}

//运行信息
function get_run_info() {
	global $db,$starttime,$_CACHE;
	if ($_CACHE['config']['blog']['debug']) {
		$time = explode(' ',microtime());
		$stoptime = $time[0] + $time[1];
		$runtime = number_format($stoptime - $starttime, 6);
		echo 'Processed in '.$runtime.' second(s), '.$db->querynum.' queries, Gzip '.($_CACHE['config']['blog']['obstart'] ? 'enabled' : 'disabled');
	}
}

//分页
function get_pagebar() {
	global $db,$page,$pagesize,$url,$wheresql,$num;
	$num = $db->result("SELECT COUNT(*) AS num FROM ".DB_TABLEPRE."article a WHERE a.ischeck = 1 AND a.status <> 4 $wheresql");
	$output = showpage($num, $pagesize, $page, $url, true);
	if (defined('MODULE') && MODULE != 'search') {
		echo rewrite_url($output, MODULE);
	} else {
		echo $output;
	}
}

function user_islogin() {
	global $_USER;
	return $_USER->id > 0 && !defined('IN_ADMIN') && !defined('CREATE_HTML') ? true : false;
}

function user_isadmin() {
	global $_USER;
	return intval($_USER->get_pv('manage_login')) ? true : false;
}

function get_user_info($key) {
	global $_USER;
	if ( property_exists('user', $key) ) {
		echo $_USER->$key;
	}
}

function get_other_url($ac, $echo = true) {
	$rewrite = get_config('seo','rewrite');
	$output = get_config('blog','url');
	switch ($ac) {
		case 'tag' :
			$output .= $rewrite==1 ? '/tag/' : ($rewrite == 2 ? '/tag.html' : '/?tag');
			break;
		case 'archive' :
			if ( func_num_args() > 2 ) {
				$output .= $rewrite==1 ? '/archive/'.func_get_arg(2).'/' : ($rewrite == 2 ? '/index.php?archive='.func_get_arg(2): '/?archive='.func_get_arg(2));
			} else {
				$output .= $rewrite==1 ? '/archive/' : ($rewrite == 2 ? '/archive.html' : '/?archive');
			}
			break;
		case 'link' :
			$output .= $rewrite==1 ? '/link/' : ($rewrite == 2 ? '/link.html' : '/?link');
			break;
		case 'search' :
			$output .= $rewrite==1 ? '/search/' : ($rewrite == 2 ? '/index.php?search' : '/?search');
			break;
	}
	if ($echo) {
		echo  $output;
	} else {
		return $output;
	}
}
//输出自定义页面列表
function get_custom_page_list($a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE;
	get_cache('page');
	$output = '';
	foreach ($_CACHE['page'] as $page) {
		$output .= $a_tag.'<a href="'.$page['filepath'].'" title="'.$page['pagename'].'">'.$page['pagename'].'</a>'.$b_tag;
	}
	echo $output;
}
//调用gravatar头像
function get_gravatar($size = 32, $rating = 'G', $email='', $output = true) {
	global $_CACHE;
	empty($email) && $email = $_ENV['comment']['email'];
	$grav_rating = array("G", "PG", "R", "X");
	!in_array($rating, $grav_rating) && $rating = 'G';
	$default = $_CACHE['config']['blog']['url'].'/images/avatar.gif';
	$grav_url = "http://www.gravatar.com/avatar.php?gravatar_id=".md5($email)."&amp;raging=".$rating."&amp;default=".urlencode($default)."&amp;size=".$size;
	$str = '<img src="'.$grav_url.'" width="'.$size.'" alt="avatar" />';
	if ($output) {
		echo $str;
	} else {
		return $str;
	}
}
//输出标签
function get_tags($maxsize=22, $step=3, $max = 0) {
	global $_CACHE;
	get_cache('tag');
	$output = '';
	$count = 0;
	foreach ( $_CACHE['tag'] as $tag ) {
		$link = './index.php?tag='.rawurlencode($tag['tagname']);
		if ( get_config('seo','rewrite') == 1 ) {
			$link = './tag/'.rawurlencode($tag['tagname']).'/';
		}
		$size = $maxsize;
		for ($i=0; $i<=10; $i++) {
			if ($tag['count'] < ($i+1) * $step) {
				$size = 12 + $i;
				break;
			}
		}
		$output .= "<a href=\"{$link}\" title=\"共{$tag[count]}篇文章\"><span style=\"font-size:{$size}px\">{$tag[tagname]}</span></a> ";
		if ($max && ++$count>=$max) break;
	}
	echo $output;
}
//输出自定义变量
function get_myvar($var) {
	global $_CACHE;
	if ( isset($_CACHE['config']['myvar'][$var]) ) {
		echo del_slashes($_CACHE['config']['myvar'][$var]);
	}
}
?>