<?php
/*
	[JBLOG] (C) 2008-2009 JBLOG TEAM.
	$QQ : 22823459 
	$Email : lisijie86@gmail.com
	$Url : http://www.lisijie.org
*/

!defined('IN_JBLOG') && exit('Access Denied!');

function get_calendar() {
	global $get,$db,$_CACHE;
	if ($get[0] == 'archive' && isset($get[1])) {
		$date = trim($get[1]);
		if (strlen($date) == 6) {
			$year  = substr($date,0,4);
			$month = substr($date,4,2);
			$day = 1;
		} elseif (strlen($date) == 8) {
			$year  = substr($date,0,4);
			$month = substr($date,4,2);
			$day   = substr($date,6,2);
		}
	} else {
		$year  = get_date('Y', PHP_TIME);
		$month = get_date('m', PHP_TIME);
		$day   = get_date('d', PHP_TIME);
	}
	if (!checkdate($month,$day,$year)) {
		$year  = get_date('Y', PHP_TIME);
		$month = get_date('m', PHP_TIME);
		$day   = get_date('d', PHP_TIME);
	}
	$s_w = get_date('w',mktime(0,0,0,$month,1,$year));
	$s_t = get_date('t',mktime(0,0,0,$month,1,$year));
	if ($month > 1) {
		$m = $month - 1;
		$m = $m < 10 ? '0'.$m : $m;
		$pre_month = $year.$m;
	} else {
		$pre_month = ($year-1).'12';
	}
	if ($month < 12) {
		$m = $month + 1;
		$m = $m < 10 ? '0'.$m : $m;
		$next_month = $year.$m;
	} else {
		$next_month = ($year+1).'01';
	}
	$data = array();
	$yearmonth = intval($year.$month);
	$sql = "SELECT `day` FROM `".DB_TABLEPRE."calendar` WHERE `yearmonth` = $yearmonth";
	$result = $db->query($sql);
	while ($row = $db->fetch_array($result)) {
		$data[] = $row['day']; 
	}
	$data = array_count_values($data);
	$html .= '<table cellpadding="2" id="calendar" class="month'.(int)$month.'">';
	$html .= '<caption><a href="./index.php?archive='.$pre_month.'">&laquo;</a> '.get_date('Y年m月',mktime(0,0,0,$month,$day,$year)).' <a href="./index.php?archive='.$next_month.'">&raquo;</a></caption>';
	$html .= '<tr><th>日</th><th>一</th><th>二</th><th>三</th><th>四</th><th>五</th><th>六</th></tr>';
	$html .= '<tr>';
	$n = 0;
	for ($i=0; $i<$s_w; $i++) {
		$html .= '<td></td>';
		$n ++;
	}
	for ($i=1; $i<=$s_t; $i++) {
		$href_s = $href_e = '';
		if ($data[$i] > 0) {
			$href_s = '<a href="./index.php?archive='.$yearmonth.($i<10 ? '0'.$i : $i).'" title="'.$i.'日共有篇'.$data[$i].'日志">';
			$href_e = '</a>';
		}
		if ($n && $n%7 == 0) $html .= '</tr><tr>';
		if ($year.$month.$i == get_date('Ymj', PHP_TIME)) {
			$html .= '<td class="today">'.$href_s.$i.$href_e.'</td>';
		} else {
			$html .= '<td>'.$href_s.$i.$href_e.'</td>';
		}
		$n ++;	
	}
	$html .= '</tr></table>';
	echo rewrite_url($html,'archive');
}

//日志分类
function get_category($showrss = false, $cur_cate = 'class="cur_cate"', $a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE,$get;
	get_cache('category');
	$cur_cid = $output = '';
	if ($get[0] == 'category') {
		if ( is_numeric($get[1]) ) {
			$cur_cid = $get[1];
		} else {
			foreach ( $_CACHE['category'] as $row ) {
				if ( $row['urlname'] == $get[1] ) {
					$cur_cid = $row['id'];
					break;
				}
			}
		}	
	} elseif ($get[0] == 'article') {
		$cur_cid = $_ENV['article']['cid'];
	}
	foreach ( $_CACHE['category'] as $row ) {
		if ( (!check_purview('view_hidden_category') || defined('IN_ADMIN')) && $row['ishide'] ) continue;
		$cur_str = $cur_cid == $row['id'] ? $cur_cate : '';
		$rssicon = empty($row['redirect']) && $showrss ? ' <a href="./rss.php?cate='.$row['id'].'"><img src="./images/rss.png" alt="订阅该分类的文章" /></a>' : '';
		$output .= $a_tag.'<a href="'.$row['url'].'" title="'.$row['catename'].'" '.$cur_str.'>'.$row['catename'].'</a>'.$rssicon.$b_tag;
	}
	echo $output;
}

//最新评论
function get_lastest_comment($a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE;
	get_cache('lastest_comment');
	$output = '';
	foreach ($_CACHE['lastest_comment'] as $row) {
		$output .= $a_tag.'<a href="'.$row['url'].'" title="'.$row['username'].' 于 '.get_date('Y-n-j H:i', $row['dateline']).' 发表在 '."\n".strip_tags($row['title']).'">'.$row['content'].'</a>'.$b_tag;
	}
	echo $output;
}

//最新文章
function get_lastest_article($a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE;
	get_cache('lastest_article');
	$output = '';
	$len = $_CACHE['config']['display']['sidebar_charnum'];
	foreach ($_CACHE['lastest_article'] as $row) {
		$output .= $a_tag.'<a href="'.$row['url'].'" title="'.strip_tags($row['title']).'">'.cut_str($row['title'],$len).'</a>'.$b_tag;
	}
	echo $output;
}

//最新推荐文章
function get_commend_article($a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE;
	get_cache('commend_article');
	$output = '';
	$len = $_CACHE['config']['display']['sidebar_charnum'];
	foreach ($_CACHE['commend_article'] as $row) {
		$output .= $a_tag.'<a href="'.$row['url'].'" title="'.strip_tags($row['title']).'">'.cut_str($row['title'],$len).'</a>'.$b_tag;
	}
	echo $output;
}

//文章归档
function get_archive($a_tag = '<li>', $b_tag = '</li>', $format = 'Y年m月') {
	global $_CACHE;
	get_cache('archive');
	$output = '';
	foreach ($_CACHE['archive'] as $row) {
		$datestr = get_date($format, str_to_time("{$row[year]}-{$row[month]}-1"));
		$output .= "{$a_tag}<a href=\"{$row[url]}\">{$datestr}</a><span>({$row[count]})</span>{$b_tag}\n";
	}
	echo $output;
}

//友情链接
function get_friendlink($groupid = 0, $showicon = true) {
	global $_CACHE;
	get_cache('link');
	if ( !$groupid ) {
		foreach ($_CACHE['link'] as $gid => $group) {
			if ( MODULE == 'index' && $group['status'] != 1) continue;
			$output .= "<li class=\"groupname\"><h4>{$group[groupname]}</h4></li>\n";
			if ( !empty($group['links']) ) {
				foreach ($group['links'] as $row) {
					$text = (empty($row['logo']) && $showicon) ? $row['name'] : "<img src=\"{$row[logo]}\" alt=\"{$row[name]}\" />";
					$output .= "<li><a href=\"{$row[url]}\" title=\"{$row[description]}\" target=\"_blank\">{$text}</a></li>\n";
				}
			}
		}
	} elseif ( intval($groupid) ) {
		foreach ($_CACHE['link'][$groupid]['links'] as $row) {
			$text = (empty($row['logo']) && $showicon) ? $row['name'] : "<img src=\"{$row[logo]}\" alt=\"{$row[name]}\" />";
			$output .= "<li><a href=\"{$row[url]}\" title=\"{$row[description]}\" target=\"_blank\">{$text}</a></li>\n";
		}
	}
	echo $output;
}
?>