DROP TABLE IF EXISTS jblog_article;

CREATE TABLE jblog_article (
  id int(10) unsigned NOT NULL auto_increment,
  cid smallint(5) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  title varchar(255) NOT NULL,
  urlname varchar(100) NOT NULL default '',
  `status` tinyint(1) NOT NULL default '1',
  `password` varchar(30) NOT NULL default '',
  `from` varchar(20) NOT NULL default '',
  fromurl varchar(200) NOT NULL default '',
  description varchar(150) NOT NULL default '',
  excerpt text NOT NULL,
  content mediumtext NOT NULL,
  comments mediumint(8) unsigned NOT NULL default '0',
  views mediumint(8) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  istop tinyint(1) NOT NULL default '0',
  iscommend tinyint(1) unsigned NOT NULL default '0',
  ischeck tinyint(1) NOT NULL default '0',
  tags varchar(255) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY cid (cid),
  KEY dateline (dateline)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_calendar;

CREATE TABLE jblog_calendar (
  yearmonth mediumint(6) unsigned NOT NULL default '0',
  `day` tinyint(2) unsigned NOT NULL default '1',
  aid int(10) unsigned NOT NULL default '0',
  KEY aid (aid),
  KEY yearmonth (yearmonth)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_category;

CREATE TABLE jblog_category (
  id smallint(5) unsigned NOT NULL auto_increment,
  catename varchar(50) NOT NULL,
  keywords varchar(255) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  urlname varchar(50) NOT NULL default '',
  redirect varchar(200) NOT NULL default '',
  ishide tinyint(1) NOT NULL default '0',
  orderid smallint(5) unsigned NOT NULL default '0',
  count mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_comment;

CREATE TABLE jblog_comment (
  id int(10) unsigned NOT NULL auto_increment,
  aid int(10) unsigned NOT NULL default '0',
  rid int(10) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  email varchar(50) NOT NULL default '',
  homepage varchar(100) NOT NULL default '',
  content text NOT NULL,
  dateline int(10) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  ischeck tinyint(1) NOT NULL default '0',
  ishide tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY aid (aid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_config;

CREATE TABLE jblog_config (
  `name` varchar(50) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(20) NOT NULL default '',
  `desc` varchar(50) NOT NULL default '',
  PRIMARY KEY (name)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_link;

CREATE TABLE jblog_link (
  id mediumint(8) unsigned NOT NULL auto_increment,
  groupid smallint(5) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL,
  url varchar(100) NOT NULL default '',
  logo varchar(100) NOT NULL default '',
  description varchar(200) NOT NULL default '',
  visible tinyint(1) unsigned NOT NULL default '1',
  orderid smallint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_linkgroup;

CREATE TABLE jblog_linkgroup (
  id smallint(5) unsigned NOT NULL auto_increment,
  groupname varchar(20) NOT NULL,
  `status` tinyint(1) NOT NULL default '1',
  orderid smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_page;

CREATE TABLE jblog_page (
  id mediumint(8) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL,
  title varchar(100) NOT NULL,
  pagename varchar(50) NOT NULL default '',
  urlname varchar(100) NOT NULL default '',
  filepath varchar(255) NOT NULL default '',
  keywords varchar(200) NOT NULL default '',
  description varchar(200) NOT NULL default '',
  content mediumtext NOT NULL,
  orderid smallint(5) unsigned NOT NULL default '0',
  ishide tinyint(1) unsigned NOT NULL default '0',
  dateline int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_plugin;

CREATE TABLE jblog_plugin (
  id mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  identifier varchar(50) NOT NULL,
  `directory` varchar(100) NOT NULL default '',
  enabled tinyint(1) unsigned NOT NULL default '0',
  runmode tinyint(1) unsigned NOT NULL default '0',
  author varchar(20) NOT NULL default '',
  version varchar(20) NOT NULL default '',
  homepage varchar(50) NOT NULL default '',
  `data` text NOT NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY identifier (identifier)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_session;

CREATE TABLE jblog_session (
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL default '',
  groupid smallint(5) unsigned NOT NULL default '3',
  ip int(11) NOT NULL default '0',
  PRIMARY KEY  (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_tag;

CREATE TABLE jblog_tag (
  id mediumint(8) unsigned NOT NULL auto_increment,
  tagname varchar(20) NOT NULL default '',
  count mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_upload;

CREATE TABLE jblog_upload (
  id int(10) unsigned NOT NULL auto_increment,
  aid int(10) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  originalname varchar(100) NOT NULL default '',
  filepath varchar(255) NOT NULL default '',
  thumb varchar(255) NOT NULL default '',
  filesize int(10) unsigned NOT NULL default '0',
  filetype varchar(50) NOT NULL default '',
  fileext char(10) NOT NULL default '',
  dateline int(10) unsigned NOT NULL default '0',
  downloads mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY aid (aid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_user;

CREATE TABLE jblog_user (
  id mediumint(8) unsigned NOT NULL auto_increment,
  username varchar(20) NOT NULL,
  `password` char(32) NOT NULL,
  sex tinyint(1) unsigned NOT NULL default '0',
  homepage varchar(100) NOT NULL default '',
  email varchar(50) NOT NULL default '',
  qq varchar(15) NOT NULL default '',
  msn varchar(50) NOT NULL default '',
  groupid smallint(5) unsigned NOT NULL default '0',
  userkey char(10) NOT NULL default '',
  lastlogin int(10) unsigned NOT NULL default '0',
  regtime int(10) unsigned NOT NULL default '0',
  logincount int(10) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '0',
  ischeck tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY username (username)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS jblog_usergroup;

CREATE TABLE jblog_usergroup (
  id smallint(5) unsigned NOT NULL auto_increment,
  groupname varchar(10) NOT NULL,
  purview text NOT NULL,
  `type` enum('system','user') NOT NULL default 'user',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;