<?php
/******************************************
 * @package: Jblog
 * @file: login.php
 * @link: http://www.lisijie.org
 * @copyright: Jblog (C) 2008 Jblog team.
 * @author: Jesse Lee (lisijie86@gmail.com)
 * @update: 2008-12-28
******************************************/
define('IN_ADMIN',True);
require('include/common.php');

$do = getGP('do','G');

if ( check_submit('dosubmit') ) {
	
	$errmsg = array();
	initGP(array('username', 'password', 'vdcode','remember'), 'P');
	
	if ( strlen($username) < 3 || strlen($username) > 20 ) {
		$errmsg[] = '用户名长度必须在3-20字节之间。';
	} elseif ( !is_username($username) ) {
		$errmsg[] = '用户名中含有非法字符。';
	}
	
	if ( strlen($password) < 6 ) $errmsg[] = '密码长度不能小于6个字节。';
	if ( get_config('user','login_vdcode') ) {
		session_start();
		if ( strtolower($vdcode) != $_SESSION['vdcode'] ) $errmsg[] = '验证码不正确。';
		unset($_SESSION['vdcode']);
	}
	
	if (count($errmsg)) show_msg($errmsg, 'login.php');
	$flag = $_USER->login($username, $password, $remember);
	if ( $flag == 1) {
		goto_page('admin.php');
	} elseif ( $flag == -3 ) {
		show_msg('登录失败，你的帐号尚未通过审核。', 'login.php');
	} else {
		show_msg('登录失败，用户名或密码错误。', 'login.php');
	}

}

if ($do == "logout") {

	$_USER->logout();
	show_msg('你已经安全退出登录，现在转到首页...','./');

} else {

	if ( $_USER->id ) {
	goto_page('admin.php');

}
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>JBLOG 用户登录</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<meta name="author" content="Jesse @ www.lisijie.org" />
		<style type="text/css" rel="stylesheet" >
		body {background:#F8F8F8;margin-top:150px;font-family:'Verdana','宋体';}
		a {color:#175796;text-decoration:none;}
		a:hover {color:red;text-decoration:none;}
		label {font-size:12px;}
		table {background:#fff;border:3px solid #f0f0f0;width:450px;}
		td,th {font-size:14px;color:#000;}
		th {background:#1A5A8D;height:50px;color:#fff;}
		td {padding:0;height:30px;}
		.input {width:150px;border:1px solid;border-color:#666 #ccc #ccc #666;font-size:14px;padding:4px;margin-top:5px;}
		.button {padding:5px 10px;}
		.copyright {border-top:1px solid #ccc;color:#666;background:#fbfbfb;font-size:11px;text-align:center;padding:10px 0;}
		</style>
	</head>
	<body>
	<form name="login" method="post" target="_top" action="login.php">
	<input type="hidden" name="dosubmit" value="yes" />
		<table cellspacing="0" align="center">
			<tr><th colspan="2">JBLOG 用户登录</th></tr>
			<tr>
				<td align="right" width="120">用户名：</td>
				<td><input type="text" id="username" name="username" class="input" /></td>
			</tr>
				<td align="right">密　码：</td>
				<td><input type="password" id="password" name="password" class="input" /></td>
			</tr>
			<?php if ( get_config('user','login_vdcode') ) {?>
			</tr>
				<td align="right">验证码：</td>
				<td><img src="vdcode.php" onclick="this.src='vdcode.php?u='+ Math.random()" style="cursor:pointer;vertical-align:bottom;" alt="点击换一张验证码" /> <input type="text" id="vdcode" name="vdcode" class="input" style="width:40px" /></td>
			</tr>
			<?php }?>
			</tr>
				<td align="right">记住我：</td>
				<td><input type="checkbox" id="remember" name="remember" style="border:none;border-color:#666 #ccc #ccc #666;" /> <label for="remember">保存我的登录信息</label></td>
			</tr>
			<tr>
				<td></td>
				<td>
				<input type="submit" value="提 交" class="button" />
				<?php if ( get_config('user','allow_reg') ) { ?>
				 (<a href="register.php">还没注册？</a> <a href="./">返回首页</a>)
				<?php }?>
				</td>
			</tr>
			<tr><td colspan="2" class="copyright">Powered by <a href="http://www.lisijie.org">JBLOG <?=JBLOG_VERSION?></a> &copy 2008, Jesse Studio.</td></tr>
		</table>
	</form>
	</body>
</html>
