<?php
//热门文章调用
//type = 1  本月热门文章  type = 2  本年热门文章
//orderby = 'views' 按点击量排序  
//orderby = 'comments' 按评论数量排序
//num  显示条数
if ( !function_exists('get_hot_articles') ) {
	function get_hot_articles($type = 1, $orderby = 'views', $num = 10) {
		global $db,$_CACHE;
		$type != 1 && $type = 2;
		$orderby != 'views' && $orderby = 'comments';
		$wheresql = 'dateline >= '.( $type == 1 ? mktime(0,0,0,date('n',PHP_TIME),1,date('Y',PHP_TIME)) : mktime(0,0,0,1,1,date('Y',PHP_TIME)) );
		$sql = "SELECT id, title, dateline, $orderby FROM ".DB_TABLEPRE."article WHERE $wheresql ORDER BY $orderby DESC LIMIT $num";
		$query = $db->query($sql);
		$output = '';
		while ( $row = $db->fetch_array($query) ) {
			$output .= '<li><a href="?aid='.$row['id'].'" title="'.$row['title'].' ('.($orderby == 'views' ? $row['views'].'次点击' : $row['comments'].'条评论').')">'.$row['title'].'</a></li>';
		}

		echo rewrite_url($output,'article');
	}
}

/*******************************
侧栏标签调用
参数说明：
	$num		最多显示标签数，默认50个
	$maxsize	最大字体大小，单位pt，默认24
	$minsize	最小字体大小，单位pt，默认9
	$step		字体大小+1需要日志数
********************************/

if ( !function_exists('get_tag_cloud') ) {
	function get_tag_cloud($num = 50, $maxsize = 24, $minsize = 9, $step = 5) {
		global $db,$_CACHE;
		get_cache('tag');
		$tags = $_CACHE['tag'];
		shuffle($tags);
		$i = 0;
		$output = '';
		foreach ( $tags as $tag ) {
			$i++;
			$size = $minsize + (round($tag['count']/$step));
			$size > 24 && $size = 24;
			$output .= '<a href="./?tag='.rawurlencode($tag['tagname']).'" title="'.$tag['count'].'篇文章"  rel="tag" style="font-size:'.$size.'pt;">'.$tag['tagname'].'</a>'."\n";
			if ( $i >= $num ) break;
		}
		echo rewrite_url($output, 'tag');
	}
}
?>