<?php template('header');?>

<?php if ( have_post() ) : ?>

	<div class="post">
		<h2><?php get_post_info('title');?></h2>
		<div class="info">
			<span class="date"><?php get_post_info('time','Y年m月d日')?></span>
			<div class="act">
					<span class="comments"><a href="<?php get_post_info('url');?>#comments">转到评论</a></span>
					<span class="addcomment"><a href="<?php get_post_info('url');?>#respond">发表评论</a></span>
				<div class="fixed"></div>
			</div>
			<div class="fixed"></div>
		</div>
		<div class="content">
			<?php get_post_info('content')?>
			<p class="under">
				<span class="categories"><?php get_post_info('category');?></span>
				<span class="tags"><?php get_post_info('tags',',');?></span>
			</p>
			<div class="fixed"></div>
		</div>
	</div>

	<!--comments-->

	<div id="comments">
	<div id="cmtswitcher">
		<a id="commenttab" class="curtab" href="javascript:void(0);">
		<?php get_post_comments_link('暂无评论', '', ' 条评论', true)?>
		</a>
		<span class="addcomment"><a href="<?php get_post_info('url');?>#respond">发表评论</a></span>
		<div class="fixed"></div>
	</div>
	<div id="commentlist">
		
		<!-- comments START -->
		<ol id="comment_list">

		<?php if ( have_comment() ) :?>

			<?php while ( get_comment() ) :?>

			<li class="comment" id="comment-<?php get_comment_info('id')?>">
				<div class="author">
					<div class="pic">
						<?php get_gravatar(34)?>
					</div>
					<div class="name">
						<?php get_comment_info('username_link')?>
					</div>
				</div>

				<div class="info">
					<div class="date">
						<?php get_comment_info('posttime', 'F jS, Y')?> at <?php get_comment_info('posttime', 'G:i a')?>
					</div>
					<div class="act">
						<?php if ( check_purview('reply_comment') ) {?>
							[<a href="<?php get_post_info('url');?>#post_comment" onclick="reply_comment(<?php get_comment_info('id')?>)">回复</a>]
						<?}?>
					</div>
					<div class="fixed"></div>
					<div class="content">
						<?php get_comment_info('content')?>

						<?php get_comment_reply(' reply at ','Y-m-d H:i','',32)?>
					</div>
				</div>
				<div class="fixed"></div>
			</li>

			<?php endwhile;?>

		<?php else : ?>
			<li class="messagebox">
				暂时没有评论.
			</li>
		<?php endif; ?>

		</ol>
		<!-- comments END -->

	</div>
	</div>
	<!-- #comments -->

	<?php if ( post_allow_comment() ) :?>
		<a name="respond"></a>
		<form name="post_comment" id="post_comment" method="post" action="" onsubmit="return ajax_post_comment()">
		<input type="hidden" name="aid" id="aid" value="<?php get_post_info('id');?>" />
		<input type="hidden" name="rid" id="rid" value="0" />
		<div id="respond">

			<?php if ( user_islogin() ) : ?>
				<input type="hidden" name="isuser" id="isuser" value="1" />
				<div class="row">
				当前你正使用 <strong><?php get_user_info('name');?></strong> 登录&nbsp;&nbsp;&nbsp;<a href="login.php?do=logout" title="Log out of this account">退出登录</a>
				</div>
			<?php else : ?>	

				<div id="author_info">
					<div class="row">
						<input type="text" name="username" id="username" class="textfield" value="" size="24" tabindex="1" /> <label id="tip_username" for="username" class="small">昵称 (必须)</label>
					</div>
					<div class="row">
						<input type="text" name="email" id="email" class="textfield" value="" size="24" tabindex="2" />
						<label id="tip_email" for="email" class="small">邮箱 (不公开) (必须)</label>
					</div>
					<div class="row">
						<input type="text" name="homepage" id="homepage" class="textfield" value="" size="24" tabindex="3" />
						<label id="tip_homepage" for="homepage" class="small">网站</label>
					</div>
				</div>

			<?php endif; ?>

		<!-- comment input -->
		<div class="row">
			<input type="checkbox" class="checkbox" name="hide" id="hide" value="1" /> <label for="hide">隐藏评论</label>
			&nbsp;<input type="checkbox" class="checkbox" name="remember" id="remember" value="1" /> <label for="remember">记住我</label>
		</div>
		<div class="row">
			<textarea name="content" id="content" tabindex="4" rows="8" cols="50"></textarea>
			<label id="tip_content" for="content"></label>
		</div>
		
		<?php if (comment_need_vdcode()) {?>
		<div class="row"><img src="<?php get_blog_info('url')?>/vdcode.php" onclick="this.src='<?php get_blog_info('url')?>/vdcode.php?u='+ Math.random()" style="cursor:pointer;vertical-align:bottom;" alt="点击换一张验证码" /> <input type="text" name="vdcode" id="vdcode" class="textfield" style="width:40px;" size="3" /></div>
		<?}?>

		<!-- comment submit and rss -->
		<div id="submitbox">
			<input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" />
			<div class="fixed"></div>
		</div>

		</div>
		</form>
		<script type="text/javascript" language="javascript">get_guestinfo();</script>
	<?php endif; ?>



<?php else : ?>

	<div class="errorbox">
		Error 404 - Not Found
	</div>

<?php endif; ?>

<?php template('footer');?>
