<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<meta http-equiv="Content-Language" content="zh-CN" />
	<title><?php get_title()?></title>
	<meta name="robots" content="all" />
	<meta name="keywords" content="<?php get_keyword()?>" />
	<meta name="description" content="<?php get_description()?>" />
	<meta name="generator" content="Jblog <?php get_blog_info('version')?>" />
	<base href="<?php get_blog_info('url')?>/" />
	<link rel="alternate" type="application/rss+xml" title="<?php get_blog_info('name')?> RSS 2.0 - all posts" href="<?php get_blog_info('url')?>/rss.php" />
	<link rel="alternate" type="application/rss+xml" title="<?php get_blog_info('name')?> RSS 2.0 - all comments" href="<?php get_blog_info('url')?>/rss.php?comments" />

	<!-- style -->
	<link rel="stylesheet" href="<?php get_theme()?>/style.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="<?php get_theme()?>/code.css" type="text/css" media="screen" />
	<link rel="stylesheet" href="<?php get_theme()?>/css/zh_CN.css" type="text/css" media="screen" />
	<!--[if IE]><link rel="stylesheet" type="text/css" href="<?php get_theme()?>/css/ie6.css" media="screen" /><![endif]-->

	<!-- script -->
	<?php get_javascript()?>
	<script language="javascript" type="text/javascript" src="<?php get_theme()?>/theme.js"></script>

</head>

<?php flush(); ?>

<body>
<!-- wrap START -->
<div id="wrap">
<!-- container START -->
<div id="container">

<!-- header START -->
<div id="header">
	<div id="caption">
		<h1 id="title"><a href="<?php get_blog_info('url')?>/"><?php get_blog_info('name')?></a></h1>
		<div id="tagline"><?php get_blog_info('subtitle')?></div>
	</div>

	<!-- navigation START -->
	<div id="navigation">
		<ul id="menus">
			<li <?php if (defined('MODULE') && MODULE == 'index'){echo 'class="current_page_item"';} ?>><a href="<?php get_blog_info('url')?>" class="home">首页</a></li>
			<li <?php if (defined('MODULE') && MODULE == 'archive'){echo 'class="current_page_item"';} ?>><a href="<?php get_other_url('archive')?>">文章归档</a></li>
			<li <?php if (defined('MODULE') && MODULE == 'tag'){echo 'class="current_page_item"';} ?>><a href="<?php get_other_url('tag')?>">标签云集</a></li>
			<li <?php if (defined('MODULE') && MODULE == 'search'){echo 'class="current_page_item"';} ?>><a href="<?php get_other_url('search')?>">文章搜索</a></li>
			<li <?php if (defined('MODULE') && MODULE == 'link'){echo 'class="current_page_item"';} ?>><a href="<?php get_other_url('link')?>">友情链接</a></li>
			<?php get_custom_page_list()?>
			<li><a class="lastmenu" href="javascript:void(0);"></a></li>
		</ul>

		<!-- searchbox START -->
		<div id="searchbox">
			<form action="<?php get_other_url('search')?>" method="post">
			<input type="hidden" name="dosubmit" value="1" />
				<input type="hidden" name="type" value="title" />
				<div class="content">
					<input type="text" class="textfield" name="keyword" size="24" value="" />
					<a class="switcher" ></a>
				</div>
			</form>
		</div>
		<!-- searchbox END -->

		<div class="fixed"></div>
	</div>
	<!-- navigation END -->

	<div class="fixed"></div>
</div>
<!-- header END -->

<!-- content START -->
<div id="main">

	<!-- main START -->
	<div id="main_body">
