<?php template('header');?>

<?php if ( have_post() ) : ?>
	<?php while ( get_post() ) :?>
		<div class="post" id="post-<?php get_post_info('id'); ?>">
			<h2><a class="title" href="<?php get_post_info('url'); ?>" rel="bookmark"><?php get_post_info('title'); ?></a></h2>
			<div class="info">
				<span class="date"><?php get_post_info('time','Y年m月d日'); ?>，<?php get_post_info('views');?> 次阅读</span>
				<div class="act">
					<span class="comments"><?php get_post_comments_link('暂无评论', '', ' 条评论')?></span>
					<div class="fixed"></div>
				</div>
				<div class="fixed"></div>
			</div>
			<div class="content">
				<?php get_post_info('excerpt')?>
				<p class="under">
					<span class="categories"><?php get_post_info('category')?></span>
					<span class="tags"><?php get_post_info('tags','，')?></span>
				</p>
				<div class="fixed"></div>
			</div>
		</div>
	<?php endwhile; ?>

<?php else : ?>
	<div class="errorbox">
		Sorry, but you are looking for something that isn't here.
	</div>
<?php endif; ?>

<div id="pagenavi">
<?php get_pagebar()?>
<div class="fixed"></div>
</div>

<?php template('footer');?>