<?php template('header')?>

	<div id="main">

		<?php if ( have_post() ) :?>
		
			<div class="post" id="post-<?php get_post_info('id');?>">
			
				<h1 class="post-title"><?php get_post_info('title');?></h1>

				<?php get_post_info('content')?>

				<div class="post-info">
				<?php get_post_info('time','F jS, Y')?> in
				<?php get_post_info('category')?>
				| tags:<?php get_post_info('tags',',')?> | 
				<?php get_post_comments_link('No Comments', '', ' Comments')?> 
				</div>

			</div>
		
		<!--comments-->
			<h1 class="comments-title">
			<?php get_post_comments_link('暂无评论', '', ' 条评论', true)?>
			</h1>

			<div id="comment_list">

				<?php if ( have_comment() ) :?>

					<?php while ( get_comment() ) :?>

					<div class="comment" id="comment-<?php get_comment_info('id')?>">
						<a name="comment-<?php get_comment_info('id')?>"></a>
						<div class="comment-avatar">
							<?php get_gravatar(50)?>
						</div>
						
						<div class="comment-content">

							<div class="comment-info">
							<span><?php get_comment_info('username_link')?></span>
							<?php get_comment_info('posttime', 'F jS, Y')?> at <?php get_comment_info('posttime', 'G:i a')?>
							
							<?php if ( check_purview('reply_comment') ) {?>
							[<a href="<?php get_post_info('url');?>#post_comment" onclick="reply_comment(<?php get_comment_info('id')?>,'回复评论')">回复</a>]
							<?}?>

							</div>

							<?php get_comment_info('content')?>

							<?php get_comment_reply(' reply at ','Y-m-d H:i','',32)?>

						</div>

					</div>

					<?php endwhile;?>

				<?php endif;?>

			</div>
			
			<!--Leave a comment-->
			<?php if ( post_allow_comment() ) :?>

			<h1 class="comments-title" id="post_comment_title">发表评论</h1>

			<a name="post_comment"></a>

			<form name="post_comment" id="post_comment" method="post" action="" onsubmit="return ajax_post_comment()">
			<input type="hidden" name="aid" id="aid" value="<?php get_post_info('id');?>" />
			<input type="hidden" name="rid" id="rid" value="0" />
					
					<?php if ( user_islogin() ) : ?>
						<input type="hidden" name="isuser" id="isuser" value="1" />
						<p>
						你当前正使用 <strong><?php get_user_info('name');?></strong> 登录&nbsp;&nbsp;&nbsp;<a href="login.php?do=logout" title="Log out of this account">退出</a>
						</p>
					<?php else : ?>	
						
						<p>
						<input type="text" name="username" id="username" class="text" size="30" /> <label id="tip_username" for="username">昵称</label>
						</p>
						<p><input type="text" name="email" id="email" class="text" size="30" /> <label id="tip_email" for="email">邮箱</label>
						</p>
						<p><input type="text" name="homepage" id="homepage" class="text" size="30" /> <label id="tip_homepage" for="homepage">主页</label>
						</p>
					<?php endif;?>

						<p>
						<input type="checkbox" class="checkbox" name="hide" id="hide" value="1" /> <label for="hide">隐藏</label>
						&nbsp;<input type="checkbox" class="checkbox" name="remember" id="remember" value="1" /> <label for="remember">记住我</label>
						</p>
					<p><textarea name="content" id="content"></textarea><label id="tip_content" for="content"></label></p>

					<?php if (comment_need_vdcode()) {?>
							<p><img src="<?php get_blog_info('url')?>/vdcode.php" onclick="this.src='<?php get_blog_info('url')?>/vdcode.php?u='+ Math.random()" style="cursor:pointer;vertical-align:bottom;" alt="点击换一张验证码" /> <input type="text" name="vdcode" id="vdcode" class="text" style="width:40px;" size="3" /> <label id="tip_vdcode" for="vdcode">请输入运算结果</label></p>
					<?}?>
					
					
					<p><input name="submit" type="submit" id="submit" value="提交评论" /></p>
					

				</form>
				<script type="text/javascript" language="javascript">get_guestinfo();</script>
			<?php endif;?>

			<!--End comment-->

		<?php else :?>

				<div class="post">
		
					<h1>Error 404 - Not Found</h1>

				</div>

		<?php endif;?>
			
		
	</div>

<?php template('sidebar')?>

<?php template('footer')?>