<?php template('header');?>

<?php if ( have_post() ) : ?>

	<div class="textbox">
		<div class="textbox-title">
			<h5><a href="<?php get_post_info('url'); ?>" rel="bookmark"><?php get_post_info('title'); ?></a></h5>
			<div class="textbox-label">
				<?php get_post_info('username')?> 于 <?php get_post_info('time','Y年m月d日'); ?> 发表在 <?php get_post_info('category')?>
			</div>
		</div>
		<div class="textbox-content">
			<?php get_post_info('content')?>
			<div class="extrainfo">
				本文自 <?php get_post_info('time','Y年m月d日'); ?> 发表以来共产生 <?php get_post_info('views')?> 次阅读，<?php get_post_info('comments')?>条评论。
				<span style="padding:0px;margin:0px;display: block">标签：<?php get_post_info('tags',',');?></span>
			</div>
		</div>
	</div>
	
	<!--comments-->
	<div id="commentWrapper" class="comment-wrapper">
		<h5>
			<script type="text/javascript">
			//<![CDATA[
				switch(<?php get_post_info('comments')?>) {
					case 0:
						document.write('沙发还在哦，还不快抢');
						break;
					case 1:
						document.write('还有板凳呢');
						break;
					case 2:
						document.write('只剩地板了');
						break;
					default:
						document.write('<?php get_post_info('comments')?>个同学已经留言，你还在等什么？');
				}
			//]]>
			</script>
		</h5>

	<a name="topreply"></a>

	<?php if ( have_comment() ) :?>
		<div id="comment_list">
		<?php while ( get_comment() ) :?>

			<div id="comment-<?php get_comment_info('id')?>">

				<div class="commentbox">
					<div class="commentbox-title">
					<span class="commentbox-label"><?php get_comment_info('posttime', 'F jS, Y')?> at <?php get_comment_info('posttime', 'G:i a')?>
						<?php if ( check_purview('reply_comment') ) {?>
							[<a href="<?php get_post_info('url');?>#post_comment" onclick="reply_comment(<?php get_comment_info('id')?>,'回复评论')">回复</a>]
						<?}?>
					</span>
					<?php get_comment_info('username_link')?>    说:	
					</div>
					<div class="commentbox-content">
						<?php get_comment_info('content')?>
						<?php get_comment_reply(' 于 ','Y-m-d H:i 回复说：','')?>
					</div>
				</div>
			</div>

		<?php endwhile;?>
		</div>

	<?php endif; ?>
	
	</div>
	<!--end comments-->
	<!--post comment-->
	<?php if ( post_allow_comment() ) :?>
	<div id="commentForm">
		<a name="respond"></a>
		<form name="post_comment" id="post_comment" method="post" action="" onsubmit="return ajax_post_comment()">
		<input type="hidden" name="aid" id="aid" value="<?php get_post_info('id');?>" />
		<input type="hidden" name="rid" id="rid" value="0" />
		<div class="formbox-comment">
			<div class="formbox-comment-title" id="post_comment_title">发表评论</div>
			<div class="formbox-comment-content">
				<div class="formbox-comment-input">
				<?php if ( user_islogin() ) : ?>
					<input type="hidden" name="isuser" id="isuser" value="1" />
					<div class="row">
					当前你正使用 <strong><?php get_user_info('name');?></strong> 登录&nbsp;&nbsp;&nbsp;<a href="login.php?do=logout" title="Log out of this account">退出登录</a>
					</div>
				<?php else : ?>	

					<p id="in" class="in">
						<input type="text" name="username" id="username" class="text" value="" size="24" tabindex="1" /> 
						<label id="tip_username" for="username" class="small">昵称 (必须)</label>
					</p>
					<p id="in" class="in">
						<input type="text" name="email" id="email" class="text" value="" size="24" tabindex="2" />
						<label id="tip_email" for="email" class="small">邮箱 (不公开) (必须)</label>
					</p>
					<p id="in" class="in">
						<input type="text" name="homepage" id="homepage" class="text" value="" size="24" tabindex="3" />
						<label id="tip_homepage" for="homepage" class="small">网站</label>
					</p>

				<?php endif; ?>
				</div>

			<div class="formbox-comment-tool">
				<input type="checkbox" class="checkbox" name="hide" id="hide" value="1" /> <label for="hide">隐藏评论</label>
				&nbsp;<input type="checkbox" class="checkbox" name="remember" id="remember" value="1" /> <label for="remember">记住我</label>
			</div>
			<textarea name="content" id="content" tabindex="4" rows="8" cols="50"></textarea>
			<label id="tip_content" for="content"></label>

		</div>
		
		<?php if (comment_need_vdcode()) {?>
		<div style="padding-top:10px"><img src="<?php get_blog_info('url')?>/vdcode.php" onclick="this.src='<?php get_blog_info('url')?>/vdcode.php?u='+ Math.random()" style="cursor:pointer;vertical-align:bottom;" alt="点击换一张验证码" /> <input type="text" name="vdcode" id="vdcode" class="text" style="width:40px;" size="3" /><label id="tip_vdcode" for="vdcode" class="small"></label></div>
		<?}?>

		<div style="padding-top:10px">
			<input name="submit" type="submit" id="submit" class="button" tabindex="5" value="发射" />
			<input name="reset" type="reset" class="button" tabindex="6" value="重写" />
		</div>

		</div>
		</form>
		<script type="text/javascript" language="javascript">get_guestinfo();</script>
	</div>
	<?php endif; ?>
	<!--end post-->

<?php else : ?>
	<div class="errorbox">
		抱歉，文章不存在或已删除。
	</div>

<?php endif; ?>

<?php template('footer');?>