<?php
// This file was auto-generated from sdk-root/src/data/cloudtrail/2013-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CloudTrail</fullname> <p>This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common errors for CloudTrail.</p> <p>CloudTrail is a web service that records AWS API calls for your AWS account and delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time of the AWS API call, the source IP address, the request parameters, and the response elements returned by the service.</p> <note> As an alternative to using the API, you can use one of the AWS SDKs, which consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.]. The SDKs provide a convenient way to create programmatic access to AWSCloudTrail. For example, the SDKs take care of cryptographically signing requests, managing errors, and retrying requests automatically. For information about the AWS SDKs, including how to download and install them, see the <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services page</a>. </note> <p>See the CloudTrail User Guide for information about the data that is included with each AWS API call listed in the log files.</p>', 'operations' => [ 'AddTags' => '<p>Adds one or more tags to a trail, up to a limit of 10. Tags must be unique per trail. Overwrites an existing tag\'s value when a new value is specified for an existing tag key. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail that applies to all regions only from the region in which the trail was created (that is, from its home region].</p>', 'CreateTrail' => '<p>Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective of the region in which they were created.</p>', 'DeleteTrail' => '<p>Deletes a trail. This operation must be called from the region in which the trail was created. <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other regions] of a trail that is enabled in all regions.</p>', 'DescribeTrails' => '<p>Retrieves settings for the trail associated with the current region for your account.</p>', 'GetTrailStatus' => '<p>Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single region. To return trail status from all regions, you must call the operation on each region.</p>', 'ListPublicKeys' => '<p>Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.</p> <note>CloudTrail uses different private/public key pairs per region. Each digest file is signed with a private key unique to its region. Therefore, when you validate a digest file from a particular region, you must look in the same region for its corresponding public key.</note>', 'ListTags' => '<p>Lists the tags for the specified trail or trails in the current region.</p> <p>Lists the tags for the trail in the current region.</p>', 'LookupEvents' => '<p>Looks up API activity events captured by CloudTrail that create, update, or delete resources in your account. Events for a region can be looked up for the times in which you had CloudTrail turned on in that region during the last seven days. Lookup supports five different attributes: time range (defined by a start time and end time], user name, event name, resource type, and resource name. All attributes are optional. The maximum number of attributes that can be specified in any one lookup request are time range and one other attribute. The default number of results returned is 10, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results. </p> <important>The rate of lookup requests is limited to one per second per account. If this limit is exceeded, a throttling error occurs. </important> <important>Events that occurred during the selected time range will not be available for lookup if CloudTrail logging was not enabled when the events occurred.</important>', 'RemoveTags' => '<p>Removes the specified tags from a trail.</p>', 'StartLogging' => '<p>Starts the recording of AWS API calls and log file delivery for a trail. For a trail that is enabled in all regions, this operation must be called from the region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other regions] of a trail that is enabled in all regions.</p>', 'StopLogging' => '<p>Suspends the recording of AWS API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation cannot be called on the shadow trails (replicated trails in other regions] of a trail enabled in all regions.</p>', 'UpdateTrail' => '<p>Updates the settings that specify delivery of log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. <code>UpdateTrail</code> must be called from the region in which the trail was created; otherwise, an <code>InvalidHomeRegionException</code> is thrown.</p>', ], 'shapes' => [ 'AddTagsRequest' => [ 'base' => '<p>Specifies the tags to add to a trail.</p>', 'refs' => [], ], 'AddTagsResponse' => [ 'base' => '<p> Returns the objects or data listed below if successful. Otherwise, returns an error. </p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files. </p>', 'CreateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail is created in the current region or in all regions. The default is false.</p>', 'CreateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file integrity validation is enabled. The default is false.</p> <note>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail will not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</note>', 'CreateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files. </p>', 'CreateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one region or in all regions.</p>', 'CreateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', 'DescribeTrailsRequest$includeShadowTrails' => '<p>Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region. The default is true.</p>', 'GetTrailStatusResponse$IsLogging' => '<p>Whether the CloudTrail is currently logging AWS API calls.</p>', 'Trail$IncludeGlobalServiceEvents' => '<p>Set to <b>True</b> to include AWS API calls from AWS global services such as IAM. Otherwise, <b>False</b>.</p>', 'Trail$IsMultiRegionTrail' => '<p>Specifies whether the trail belongs only to one region or exists in all regions.</p>', 'Trail$LogFileValidationEnabled' => '<p>Specifies whether log file validation is enabled.</p>', 'UpdateTrailRequest$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files. </p>', 'UpdateTrailRequest$IsMultiRegionTrail' => '<p>Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail] will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted.</p>', 'UpdateTrailRequest$EnableLogFileValidation' => '<p>Specifies whether log file validation is enabled. The default is false.</p> <note>When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail will not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.</note>', 'UpdateTrailResponse$IncludeGlobalServiceEvents' => '<p>Specifies whether the trail is publishing events from global services such as IAM to the log files. </p>', 'UpdateTrailResponse$IsMultiRegionTrail' => '<p>Specifies whether the trail exists in one region or in all regions.</p>', 'UpdateTrailResponse$LogFileValidationEnabled' => '<p>Specifies whether log file integrity validation is enabled.</p>', ], ], 'ByteBuffer' => [ 'base' => NULL, 'refs' => [ 'PublicKey$Value' => '<p>The DER encoded public key value in PKCS#1 format.</p>', ], ], 'CloudTrailARNInvalidException' => [ 'base' => '<p>This exception is thrown when an operation is called with an invalid trail ARN. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>. </p>', 'refs' => [], ], 'CloudWatchLogsDeliveryUnavailableException' => [ 'base' => '<p>Cannot set a CloudWatch Logs delivery for this region.</p>', 'refs' => [], ], 'CreateTrailRequest' => [ 'base' => '<p>Specifies the settings for each trail.</p>', 'refs' => [], ], 'CreateTrailResponse' => [ 'base' => 'Returns the objects or data listed below if successful. Otherwise, returns an error.', 'refs' => [], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'Event$EventTime' => '<p>The date and time of the event returned.</p>', 'GetTrailStatusResponse$LatestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered log files to an account\'s Amazon S3 bucket.</p>', 'GetTrailStatusResponse$LatestNotificationTime' => '<p>Specifies the date and time of the most recent Amazon SNS notification that CloudTrail has written a new log file to an account\'s Amazon S3 bucket. </p>', 'GetTrailStatusResponse$StartLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail started recording API calls for an AWS account. </p>', 'GetTrailStatusResponse$StopLoggingTime' => '<p>Specifies the most recent date and time when CloudTrail stopped recording API calls for an AWS account. </p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryTime' => '<p>Displays the most recent date and time when CloudTrail delivered logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryTime' => '<p>Specifies the date and time that CloudTrail last delivered a digest file to an account\'s Amazon S3 bucket.</p>', 'ListPublicKeysRequest$StartTime' => '<p>Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned. </p>', 'ListPublicKeysRequest$EndTime' => '<p>Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used. </p>', 'LookupEventsRequest$StartTime' => '<p>Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned.</p>', 'LookupEventsRequest$EndTime' => '<p>Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned.</p>', 'PublicKey$ValidityStartTime' => '<p>The starting time of validity of the public key.</p>', 'PublicKey$ValidityEndTime' => '<p>The ending time of validity of the public key.</p>', ], ], 'DeleteTrailRequest' => [ 'base' => '<a>The request that specifies the name of a trail to delete.</a>', 'refs' => [], ], 'DeleteTrailResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'DescribeTrailsRequest' => [ 'base' => '<p>Returns information about the trail.</p>', 'refs' => [], ], 'DescribeTrailsResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'Event' => [ 'base' => '<p>Contains information about an event that was returned by a lookup request. The result includes a representation of a CloudTrail event. </p>', 'refs' => [ 'EventsList$member' => NULL, ], ], 'EventsList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsResponse$Events' => '<p>A list of events returned based on the lookup attributes specified and the CloudTrail event. The events list is sorted by time. The most recent event is listed first.</p>', ], ], 'GetTrailStatusRequest' => [ 'base' => '<p>The name of a trail about which you want the current status.</p>', 'refs' => [], ], 'GetTrailStatusResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'InsufficientEncryptionPolicyException' => [ 'base' => 'This exception is thrown when the policy on the S3 bucket or KMS key is not sufficient.', 'refs' => [], ], 'InsufficientS3BucketPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the S3 bucket is not sufficient.</p>', 'refs' => [], ], 'InsufficientSnsTopicPolicyException' => [ 'base' => '<p>This exception is thrown when the policy on the SNS topic is not sufficient.</p>', 'refs' => [], ], 'InvalidCloudWatchLogsLogGroupArnException' => [ 'base' => '<p>This exception is thrown when the provided CloudWatch log group is not valid.</p>', 'refs' => [], ], 'InvalidCloudWatchLogsRoleArnException' => [ 'base' => '<p>This exception is thrown when the provided role is not valid.</p>', 'refs' => [], ], 'InvalidHomeRegionException' => [ 'base' => '<p>This exception is thrown when an operation is called on a trail from a region other than the region in which the trail was created.</p>', 'refs' => [], ], 'InvalidKmsKeyIdException' => [ 'base' => 'This exception is thrown when the KMS key ARN is invalid.', 'refs' => [], ], 'InvalidLookupAttributesException' => [ 'base' => '<p>Occurs when an invalid lookup attribute is specified.</p>', 'refs' => [], ], 'InvalidMaxResultsException' => [ 'base' => '<p>This exception is thrown if the limit specified is invalid. </p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>Invalid token or token that was previously used in a request with different parameters. This exception is thrown if the token is invalid. </p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>This exception is thrown when the combination of parameters provided is not valid.</p>', 'refs' => [], ], 'InvalidS3BucketNameException' => [ 'base' => '<p>This exception is thrown when the provided S3 bucket name is not valid.</p>', 'refs' => [], ], 'InvalidS3PrefixException' => [ 'base' => '<p>This exception is thrown when the provided S3 prefix is not valid.</p>', 'refs' => [], ], 'InvalidSnsTopicNameException' => [ 'base' => '<p>This exception is thrown when the provided SNS topic name is not valid.</p>', 'refs' => [], ], 'InvalidTagParameterException' => [ 'base' => '<p>This exception is thrown when the key or value specified for the tag does not match the regular expression <code>^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-@]*]$</code>.</p>', 'refs' => [], ], 'InvalidTimeRangeException' => [ 'base' => '<p>Occurs if the timestamp values are invalid. Either the start time occurs after the end time or the time range is outside the range of possible values. </p>', 'refs' => [], ], 'InvalidTokenException' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [], ], 'InvalidTrailNameException' => [ 'base' => '<p>This exception is thrown when the provided trail name is not valid. Trail names must meet the following requirements:</p> <ul> <li>Contain only ASCII letters (a-z, A-Z], numbers (0-9], periods (.], underscores (_], or dashes (-]</li> <li>Start with a letter or number, and end with a letter or number</li> <li>Be between 3 and 128 characters</li> <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are invalid.</li> <li>Not be in IP address format (for example, 192.168.5.4]</li> </ul>', 'refs' => [], ], 'KmsKeyDisabledException' => [ 'base' => '<p>This exception is thrown when the KMS key is disabled.</p>', 'refs' => [], ], 'KmsKeyNotFoundException' => [ 'base' => 'This exception is thrown when the KMS key does not exist, or when the S3 bucket and the KMS key are not in the same region.', 'refs' => [], ], 'ListPublicKeysRequest' => [ 'base' => '<p>Requests the public keys for a specified time range.</p>', 'refs' => [], ], 'ListPublicKeysResponse' => [ 'base' => 'Returns the objects or data listed below if successful. Otherwise, returns an error.', 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Specifies a list of trail tags to return.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p> Returns the objects or data listed below if successful. Otherwise, returns an error. </p>', 'refs' => [], ], 'LookupAttribute' => [ 'base' => '<p>Specifies an attribute and value that filter the events returned.</p>', 'refs' => [ 'LookupAttributesList$member' => NULL, ], ], 'LookupAttributeKey' => [ 'base' => NULL, 'refs' => [ 'LookupAttribute$AttributeKey' => '<p>Specifies an attribute on which to filter the events returned.</p>', ], ], 'LookupAttributesList' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$LookupAttributes' => '<p>Contains a list of lookup attributes. Currently the list can contain only one item.</p>', ], ], 'LookupEventsRequest' => [ 'base' => '<p>Contains a request for LookupEvents.</p>', 'refs' => [], ], 'LookupEventsResponse' => [ 'base' => '<p>Contains a response to a LookupEvents action.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$MaxResults' => '<p>The number of events to return. Possible values are 1 through 50. The default is 10.</p>', ], ], 'MaximumNumberOfTrailsExceededException' => [ 'base' => '<p>This exception is thrown when the maximum number of trails is reached.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'LookupEventsRequest$NextToken' => '<p>The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', 'LookupEventsResponse$NextToken' => '<p>The token to use to get the next page of results after a previous API call. If the token does not appear, there are no more results to return. The token must be passed in with the same parameters as the previous call. For example, if the original call specified an AttributeKey of \'Username\' with a value of \'root\', the call with NextToken should include those same parameters.</p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>This exception is thrown when the requested operation is not permitted.</p>', 'refs' => [], ], 'PublicKey' => [ 'base' => '<p>Contains information about a returned public key.</p>', 'refs' => [ 'PublicKeyList$member' => NULL, ], ], 'PublicKeyList' => [ 'base' => NULL, 'refs' => [ 'ListPublicKeysResponse$PublicKeyList' => '<p>Contains an array of PublicKey objects.</p> <note>The returned public keys may have validity time ranges that overlap.</note>', ], ], 'RemoveTagsRequest' => [ 'base' => '<p>Specifies the tags to remove from a trail.</p>', 'refs' => [], ], 'RemoveTagsResponse' => [ 'base' => '<p> Returns the objects or data listed below if successful. Otherwise, returns an error. </p>', 'refs' => [], ], 'Resource' => [ 'base' => '<p>Specifies the type and name of a resource referenced by an event.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListTagsRequest$ResourceIdList' => '<p>Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', ], ], 'ResourceList' => [ 'base' => '<p>A list of resources referenced by the event returned.</p>', 'refs' => [ 'Event$Resources' => '<p>A list of resources referenced by the event returned.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>This exception is thrown when the specified resource is not found.</p>', 'refs' => [], ], 'ResourceTag' => [ 'base' => '<p>A resource tag.</p>', 'refs' => [ 'ResourceTagList$member' => NULL, ], ], 'ResourceTagList' => [ 'base' => '<p>A list of resource tags.</p>', 'refs' => [ 'ListTagsResponse$ResourceTagList' => NULL, ], ], 'ResourceTypeNotSupportedException' => [ 'base' => '<p>This exception is thrown when the specified resource type is not supported by CloudTrail.</p>', 'refs' => [], ], 'S3BucketDoesNotExistException' => [ 'base' => '<p>This exception is thrown when the specified S3 bucket does not exist.</p>', 'refs' => [], ], 'StartLoggingRequest' => [ 'base' => '<p>The request to CloudTrail to start logging AWS API calls for an account.</p>', 'refs' => [], ], 'StartLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'StopLoggingRequest' => [ 'base' => '<p>Passes the request to CloudTrail to stop logging AWS API calls for the specified account.</p>', 'refs' => [], ], 'StopLoggingResponse' => [ 'base' => '<p>Returns the objects or data listed below if successful. Otherwise, returns an error.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'CreateTrailRequest$Name' => '<p>Specifies the name of the trail. The name must meet the following requirements:</p> <ul> <li>Contain only ASCII letters (a-z, A-Z], numbers (0-9], periods (.], underscores (_], or dashes (-]</li> <li>Start with a letter or number, and end with a letter or number</li> <li>Be between 3 and 128 characters</li> <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are invalid.</li> <li>Not be in IP address format (for example, 192.168.5.4]</li> </ul>', 'CreateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'CreateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'CreateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'CreateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN], a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn.</p>', 'CreateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'CreateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be a an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>Examples:</p> <ul> <li>alias/MyAliasName</li> <li>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</li> <li>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</li> <li>12345678-1234-1234-1234-123456789012</li> </ul>', 'CreateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'CreateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'CreateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>', 'CreateTrailResponse$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery.</p>', 'CreateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was created.</p>', 'CreateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN] of the log group to which CloudTrail logs will be delivered.</p>', 'CreateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'CreateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the format:</p> <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>', 'DeleteTrailRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail to be deleted. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'Event$EventId' => '<p>The CloudTrail ID of the event returned.</p>', 'Event$EventName' => '<p>The name of the event returned.</p>', 'Event$Username' => '<p>A user name or role name of the requester that called the API in the event returned.</p>', 'Event$CloudTrailEvent' => '<p>A JSON string that contains a representation of the event returned.</p>', 'GetTrailStatusRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which you are requesting status. To get the status of a shadow trail (a replication of the trail in another region], you must specify its ARN. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'GetTrailStatusResponse$LatestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver log files to the designated bucket. For more information see the topic <a href="http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>This error occurs only when there is a problem with the destination S3 bucket and will not occur for timeouts. To resolve the issue, create a new bucket and call <code>UpdateTrail</code> to specify the new bucket, or fix the existing objects so that CloudTrail can again write to the bucket. </note>', 'GetTrailStatusResponse$LatestNotificationError' => '<p>Displays any Amazon SNS error that CloudTrail encountered when attempting to send a notification. For more information about Amazon SNS errors, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon SNS Developer Guide</a>. </p>', 'GetTrailStatusResponse$LatestCloudWatchLogsDeliveryError' => '<p>Displays any CloudWatch Logs error that CloudTrail encountered when attempting to deliver logs to CloudWatch Logs.</p>', 'GetTrailStatusResponse$LatestDigestDeliveryError' => '<p>Displays any Amazon S3 error that CloudTrail encountered when attempting to deliver a digest file to the designated bucket. For more information see the topic <a href="http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html">Error Responses</a> in the Amazon S3 API Reference. </p> <note>This error occurs only when there is a problem with the destination S3 bucket and will not occur for timeouts. To resolve the issue, create a new bucket and call <code>UpdateTrail</code> to specify the new bucket, or fix the existing objects so that CloudTrail can again write to the bucket. </note>', 'GetTrailStatusResponse$LatestDeliveryAttemptTime' => '<p>This field is deprecated.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptTime' => '<p>This field is deprecated.</p>', 'GetTrailStatusResponse$LatestNotificationAttemptSucceeded' => '<p>This field is deprecated.</p>', 'GetTrailStatusResponse$LatestDeliveryAttemptSucceeded' => '<p>This field is deprecated.</p>', 'GetTrailStatusResponse$TimeLoggingStarted' => '<p>This field is deprecated.</p>', 'GetTrailStatusResponse$TimeLoggingStopped' => '<p>This field is deprecated.</p>', 'ListPublicKeysRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListPublicKeysResponse$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsRequest$NextToken' => '<p>Reserved for future use.</p>', 'ListTagsResponse$NextToken' => '<p> Reserved for future use. </p>', 'LookupAttribute$AttributeValue' => '<p>Specifies a value for the specified AttributeKey.</p>', 'PublicKey$Fingerprint' => '<p>The fingerprint of the public key.</p>', 'RemoveTagsRequest$ResourceId' => '<p>Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'Resource$ResourceType' => '<p>The type of a resource referenced by the event returned. When the resource type cannot be determined, null is returned. Some examples of resource types are: <b>Instance</b> for EC2, <b>Trail</b> for CloudTrail, <b>DBInstance</b> for RDS, and <b>AccessKey</b> for IAM. For a list of resource types supported for event lookup, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html">Resource Types Supported for Event Lookup</a>.</p>', 'Resource$ResourceName' => '<p>The name of the resource referenced by the event returned. These are user-created names whose values will depend on the environment. For example, the resource name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567" for an EC2 Instance.</p>', 'ResourceIdList$member' => NULL, 'ResourceTag$ResourceId' => '<p>Specifies the ARN of the resource.</p>', 'StartLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail logs AWS API calls. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'StopLoggingRequest$Name' => '<p>Specifies the name or the CloudTrail ARN of the trail for which CloudTrail will stop logging AWS API calls. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'Tag$Key' => '<p>The key in a key-value pair. The key must be must be no longer than 128 Unicode characters. The key must be unique for the resource to which it applies.</p>', 'Tag$Value' => '<p>The value in a key-value pair of a tag. The value must be no longer than 256 Unicode characters.</p>', 'Trail$Name' => '<p>Name of the trail set by calling <a>CreateTrail</a>. The maximum length is 128 characters.</p>', 'Trail$S3BucketName' => '<p>Name of the Amazon S3 bucket into which CloudTrail delivers your trail files. See <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'Trail$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.The maximum length is 200 characters.</p>', 'Trail$SnsTopicName' => '<p>Name of the existing Amazon SNS topic that CloudTrail uses to notify the account owner when new CloudTrail log files have been delivered. The maximum length is 256 characters.</p>', 'Trail$HomeRegion' => '<p>The region in which the trail was created.</p>', 'Trail$TrailARN' => '<p>The Amazon Resource Name of the trail. The <code>TrailARN</code> format is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'Trail$CloudWatchLogsLogGroupArn' => '<p>Specifies an Amazon Resource Name (ARN], a unique identifier that represents the log group to which CloudTrail logs will be delivered.</p>', 'Trail$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'Trail$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the format:</p> <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>', 'TrailNameList$member' => NULL, 'UpdateTrailRequest$Name' => '<p>Specifies the name of the trail or trail ARN. If <code>Name</code> is a trail name, the string must meet the following requirements:</p> <ul> <li>Contain only ASCII letters (a-z, A-Z], numbers (0-9], periods (.], underscores (_], or dashes (-]</li> <li>Start with a letter or number, and end with a letter or number</li> <li>Be between 3 and 128 characters</li> <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are invalid.</li> <li>Not be in IP address format (for example, 192.168.5.4]</li> </ul> <p>If <code>Name</code> is a trail ARN, it must be in the format <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>.</p>', 'UpdateTrailRequest$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files. See <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a>.</p>', 'UpdateTrailRequest$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>. The maximum length is 200 characters.</p>', 'UpdateTrailRequest$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters.</p>', 'UpdateTrailRequest$CloudWatchLogsLogGroupArn' => '<p>Specifies a log group name using an Amazon Resource Name (ARN], a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn.</p>', 'UpdateTrailRequest$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'UpdateTrailRequest$KmsKeyId' => '<p>Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be a an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.</p> <p>Examples:</p> <ul> <li>alias/MyAliasName</li> <li>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</li> <li>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</li> <li>12345678-1234-1234-1234-123456789012</li> </ul>', 'UpdateTrailResponse$Name' => '<p>Specifies the name of the trail.</p>', 'UpdateTrailResponse$S3BucketName' => '<p>Specifies the name of the Amazon S3 bucket designated for publishing log files.</p>', 'UpdateTrailResponse$S3KeyPrefix' => '<p>Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see <a href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a>.</p>', 'UpdateTrailResponse$SnsTopicName' => '<p>Specifies the name of the Amazon SNS topic defined for notification of log file delivery.</p>', 'UpdateTrailResponse$TrailARN' => '<p>Specifies the ARN of the trail that was updated.</p>', 'UpdateTrailResponse$CloudWatchLogsLogGroupArn' => '<p>Specifies the Amazon Resource Name (ARN] of the log group to which CloudTrail logs will be delivered.</p>', 'UpdateTrailResponse$CloudWatchLogsRoleArn' => '<p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a user\'s log group.</p>', 'UpdateTrailResponse$KmsKeyId' => '<p>Specifies the KMS key ID that encrypts the logs delivered by CloudTrail. The value is a fully specified ARN to a KMS key in the format:</p> <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>', ], ], 'Tag' => [ 'base' => '<p>A custom key-value pair associated with a resource such as a CloudTrail trail.</p>', 'refs' => [ 'TagsList$member' => NULL, ], ], 'TagsLimitExceededException' => [ 'base' => '<p>The number of tags per trail has exceeded the permitted amount. Currently, the limit is 10.</p>', 'refs' => [], ], 'TagsList' => [ 'base' => '<p>A list of tags.</p>', 'refs' => [ 'AddTagsRequest$TagsList' => '<p>Contains a list of CloudTrail tags, up to a limit of 10.</p>', 'RemoveTagsRequest$TagsList' => '<p>Specifies a list of tags to be removed. </p>', 'ResourceTag$TagsList' => NULL, ], ], 'Trail' => [ 'base' => '<p>The settings for a trail.</p>', 'refs' => [ 'TrailList$member' => NULL, ], ], 'TrailAlreadyExistsException' => [ 'base' => '<p>This exception is thrown when the specified trail already exists.</p>', 'refs' => [], ], 'TrailList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsResponse$trailList' => '<p>The list of trail objects.</p>', ], ], 'TrailNameList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrailsRequest$trailNameList' => '<p>Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is <code>arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail</code>. If an empty list is specified, information for the trail in the current region is returned.</p> <ul> <li>If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in the current region is returned.</li> <li> If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned. </li> </ul> <note>If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN.</note>', ], ], 'TrailNotFoundException' => [ 'base' => '<p>This exception is thrown when the trail with the given name is not found.</p>', 'refs' => [], ], 'TrailNotProvidedException' => [ 'base' => '<p>This exception is deprecated.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>This exception is thrown when the requested operation is not supported.</p>', 'refs' => [], ], 'UpdateTrailRequest' => [ 'base' => '<p>Specifies settings to update for the trail.</p>', 'refs' => [], ], 'UpdateTrailResponse' => [ 'base' => 'Returns the objects or data listed below if successful. Otherwise, returns an error.', 'refs' => [], ], ],];
