<?php
// This file was auto-generated from sdk-root/src/data/codepipeline/2015-07-09/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'AcknowledgeJob' => '<p>Returns information about a specified job and whether that job has been received by the job worker. Only used for custom actions.</p>', 'AcknowledgeThirdPartyJob' => '<p>Confirms a job worker has received the specified job. Only used for partner actions.</p>', 'CreateCustomActionType' => '<p>Creates a new custom action that can be used in all pipelines associated with the AWS account. Only used for custom actions.</p>', 'CreatePipeline' => '<p>Creates a pipeline.</p>', 'DeleteCustomActionType' => '<p>Marks a custom action as deleted. PollForJobs for the custom action will fail after the action is marked for deletion. Only used for custom actions.</p> <important><p>You cannot recreate a custom action after it has been deleted unless you increase the version number of the action.</p></important>', 'DeletePipeline' => '<p>Deletes the specified pipeline.</p>', 'DisableStageTransition' => '<p>Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline. </p>', 'EnableStageTransition' => '<p>Enables artifacts in a pipeline to transition to a stage in a pipeline.</p>', 'GetJobDetails' => '<p>Returns information about a job. Only used for custom actions.</p> <important><p>When this API is called, AWS CodePipeline returns temporary credentials for the Amazon S3 bucket used to store artifacts for the pipeline, if the action requires access to that Amazon S3 bucket for input or output artifacts. Additionally, this API returns any secret values defined for the action.</p></important>', 'GetPipeline' => '<p>Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with <a>UpdatePipeline</a>.</p>', 'GetPipelineState' => '<p>Returns information about the state of a pipeline, including the stages, actions, and details about the last run of the pipeline.</p>', 'GetThirdPartyJobDetails' => '<p>Requests the details of a job for a third party action. Only used for partner actions.</p> <important><p>When this API is called, AWS CodePipeline returns temporary credentials for the Amazon S3 bucket used to store artifacts for the pipeline, if the action requires access to that Amazon S3 bucket for input or output artifacts. Additionally, this API returns any secret values defined for the action.</p></important>', 'ListActionTypes' => '<p>Gets a summary of all AWS CodePipeline action types associated with your account.</p>', 'ListPipelines' => '<p>Gets a summary of all of the pipelines associated with your account.</p>', 'PollForJobs' => '<p>Returns information about any jobs for AWS CodePipeline to act upon.</p> <important><p>When this API is called, AWS CodePipeline returns temporary credentials for the Amazon S3 bucket used to store artifacts for the pipeline, if the action requires access to that Amazon S3 bucket for input or output artifacts. Additionally, this API returns any secret values defined for the action.</p></important>', 'PollForThirdPartyJobs' => '<p>Determines whether there are any third party jobs for a job worker to act on. Only used for partner actions.</p> <important><p>When this API is called, AWS CodePipeline returns temporary credentials for the Amazon S3 bucket used to store artifacts for the pipeline, if the action requires access to that Amazon S3 bucket for input or output artifacts.</p></important>', 'PutActionRevision' => '<p>Provides information to AWS CodePipeline about new revisions to a source.</p>', 'PutJobFailureResult' => '<p>Represents the failure of a job as returned to the pipeline by a job worker. Only used for custom actions.</p>', 'PutJobSuccessResult' => '<p>Represents the success of a job as returned to the pipeline by a job worker. Only used for custom actions.</p>', 'PutThirdPartyJobFailureResult' => '<p>Represents the failure of a third party job as returned to the pipeline by a job worker. Only used for partner actions.</p>', 'PutThirdPartyJobSuccessResult' => '<p>Represents the success of a third party job as returned to the pipeline by a job worker. Only used for partner actions.</p>', 'StartPipelineExecution' => '<p>Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.</p>', 'UpdatePipeline' => '<p>Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure in conjunction with UpdatePipeline to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.</p>', ], 'shapes' => [ 'AWSSessionCredentials' => [ 'base' => '<p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS]. They can be used to access input and output artifacts in the Amazon S3 bucket used to store artifact for the pipeline in AWS CodePipeline.</p>', 'refs' => [], ], 'AccessKeyId' => [ 'refs' => [ 'AWSSessionCredentials$accessKeyId' => '<p>The access key for the session.</p>', ], ], 'AccountId' => [ 'refs' => [ 'Job$accountId' => '<p>The ID of the AWS account to use when performing the job.</p>', 'JobDetails$accountId' => '<p>The AWS account ID associated with the job.</p>', ], ], 'AcknowledgeJobInput' => [ 'base' => '<p>Represents the input of an acknowledge job action.</p>', 'refs' => [], ], 'AcknowledgeJobOutput' => [ 'base' => '<p>Represents the output of an acknowledge job action.</p>', 'refs' => [], ], 'AcknowledgeThirdPartyJobInput' => [ 'base' => '<p>Represents the input of an acknowledge third party job action.</p>', 'refs' => [], ], 'AcknowledgeThirdPartyJobOutput' => [ 'base' => '<p>Represents the output of an acknowledge third party job action.</p>', 'refs' => [], ], 'ActionCategory' => [ 'refs' => [ 'ActionTypeId$category' => '<p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the values below. </p>', 'CreateCustomActionTypeInput$category' => '<p>The category of the custom action, such as a source action or a build action.</p>', 'DeleteCustomActionTypeInput$category' => '<p>The category of the custom action that you want to delete, such as source or deploy.</p>', ], ], 'ActionConfiguration' => [ 'base' => '<p>Represents information about an action configuration.</p>', 'refs' => [], ], 'ActionConfigurationKey' => [ 'refs' => [ 'ActionConfigurationProperty$name' => '<p>The name of the action configuration property.</p>', ], ], 'ActionConfigurationMap' => [ 'refs' => [ 'ActionConfiguration$configuration' => '<p>The configuration data for the action.</p>', 'ActionDeclaration$configuration' => '<p>The action declaration\'s configuration.</p>', ], ], 'ActionConfigurationProperty' => [ 'base' => '<p>Represents information about an action configuration property.</p>', 'refs' => [], ], 'ActionConfigurationPropertyList' => [ 'refs' => [ 'ActionType$actionConfigurationProperties' => '<p>The configuration properties for the action type.</p>', 'CreateCustomActionTypeInput$configurationProperties' => '<p>The configuration properties for the custom action.</p>', ], ], 'ActionConfigurationPropertyType' => [ 'refs' => [ 'ActionConfigurationProperty$type' => '<p>The type of the configuration property.</p>', ], ], 'ActionConfigurationQueryableValue' => [ 'refs' => [], ], 'ActionConfigurationValue' => [ 'refs' => [], ], 'ActionContext' => [ 'base' => '<p>Represents the context of an action within the stage of a pipeline to a job worker.</p>', 'refs' => [], ], 'ActionDeclaration' => [ 'base' => '<p>Represents information about an action declaration.</p>', 'refs' => [], ], 'ActionExecution' => [ 'base' => '<p>Represents information about how an action runs.</p>', 'refs' => [], ], 'ActionExecutionStatus' => [ 'refs' => [ 'ActionExecution$status' => '<p>The status of the action, or for a completed action, the last status of the action.</p>', ], ], 'ActionName' => [ 'refs' => [ 'ActionContext$name' => '<p>The name of the action within the context of a job.</p>', 'ActionDeclaration$name' => '<p>The action declaration\'s name.</p>', 'ActionState$actionName' => '<p>The name of the action.</p>', 'PutActionRevisionInput$actionName' => '<p>The name of the action that will process the revision.</p>', ], ], 'ActionNotFoundException' => [ 'base' => '<p>The specified action cannot be found.</p>', 'refs' => [], ], 'ActionOwner' => [ 'refs' => [ 'ActionTypeId$owner' => '<p>The creator of the action being called. </p>', 'ListActionTypesInput$actionOwnerFilter' => '<p>Filters the list of action types to those created by a specified entity.</p>', ], ], 'ActionProvider' => [ 'refs' => [ 'ActionTypeId$provider' => '<p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy.</p>', 'CreateCustomActionTypeInput$provider' => '<p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>', 'DeleteCustomActionTypeInput$provider' => '<p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>', ], ], 'ActionRevision' => [ 'base' => '<p>Represents information about the version (or revision] of an action.</p>', 'refs' => [], ], 'ActionRunOrder' => [ 'refs' => [ 'ActionDeclaration$runOrder' => '<p>The order in which actions are run.</p>', ], ], 'ActionState' => [ 'base' => '<p>Represents information about the state of an action.</p>', 'refs' => [], ], 'ActionStateList' => [ 'refs' => [ 'StageState$actionStates' => '<p>The state of the stage.</p>', ], ], 'ActionType' => [ 'base' => '<p>Returns information about the details of an action type. </p>', 'refs' => [], ], 'ActionTypeId' => [ 'base' => '<p>Represents information about an action type.</p>', 'refs' => [ 'ActionDeclaration$actionTypeId' => '<p>The configuration information for the action type. </p>', ], ], 'ActionTypeList' => [ 'refs' => [ 'ListActionTypesOutput$actionTypes' => '<p>Provides details of the action types.</p>', ], ], 'ActionTypeNotFoundException' => [ 'base' => '<p>The specified action type cannot be found.</p>', 'refs' => [], ], 'ActionTypeSettings' => [ 'base' => '<p>Returns information about the settings for an action type. </p>', 'refs' => [ 'ActionType$settings' => '<p>The settings for the action type.</p>', ], ], 'Artifact' => [ 'base' => '<p>Represents information about an artifact that will be worked upon by actions in the pipeline.</p>', 'refs' => [], ], 'ArtifactDetails' => [ 'base' => '<p>Returns information about the details of an artifact.</p>', 'refs' => [ 'ActionType$inputArtifactDetails' => '<p>The details of the input artifact for the action, such as its commit ID.</p>', 'ActionType$outputArtifactDetails' => '<p>The details of the output artifact of the action, such as its commit ID.</p>', ], ], 'ArtifactList' => [ 'refs' => [ 'JobData$inputArtifacts' => '<p>The artifact supplied to the job.</p>', 'JobData$outputArtifacts' => '<p>The output of the job.</p>', 'ThirdPartyJobData$inputArtifacts' => '<p>The name of the artifact that will be worked upon by the action, if any. This name might be system-generated, such as "MyApp", or might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>', 'ThirdPartyJobData$outputArtifacts' => '<p>The name of the artifact that will be the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or might be defined by the user when the action is created.</p>', ], ], 'ArtifactLocation' => [ 'base' => '<p>Represents information about the location of an artifact.</p>', 'refs' => [ 'Artifact$location' => '<p>The location of an artifact.</p>', ], ], 'ArtifactLocationType' => [ 'refs' => [ 'ArtifactLocation$type' => '<p>The type of artifact in the location.</p>', ], ], 'ArtifactName' => [ 'refs' => [ 'Artifact$name' => '<p>The artifact\'s name.</p>', 'InputArtifact$name' => '<p>The name of the artifact to be worked on, for example, "My App".</p> <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>', 'OutputArtifact$name' => '<p>The name of the output of an artifact, such as "My App". </p> <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p> <p>Output artifact names must be unique within a pipeline.</p>', ], ], 'ArtifactStore' => [ 'base' => '<p>The Amazon S3 location where artifacts are stored for the pipeline. If this Amazon S3 bucket is created manually, it must meet the requirements for AWS CodePipeline. For more information, see the <ulink url="http://docs.aws.amazon.com/codepipeline/latest/UserGuide/concepts.html">Concepts</ulink>.</p>', 'refs' => [], ], 'ArtifactStoreLocation' => [ 'refs' => [ 'ArtifactStore$location' => '<p>The location for storing the artifacts for a pipeline, such as an S3 bucket or folder.</p>', ], ], 'ArtifactStoreType' => [ 'refs' => [ 'ArtifactStore$type' => '<p>The type of the artifact store, such as S3.</p>', ], ], 'BlockerDeclaration' => [ 'base' => '<p>Represents information about a gate declaration.</p>', 'refs' => [], ], 'BlockerName' => [ 'refs' => [ 'BlockerDeclaration$name' => '<p>The name of the gate declaration.</p>', ], ], 'BlockerType' => [ 'refs' => [ 'BlockerDeclaration$type' => '<p>The type of the gate declaration. </p>', ], ], 'Boolean' => [ 'refs' => [ 'ActionConfigurationProperty$key' => '<p>Whether the configuration property is a key.</p>', 'ActionConfigurationProperty$queryable' => '<p>Indicates that the proprety will be used in conjunction with PollForJobs. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p> <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to additional restrictions. The value must be less than or equal to twenty (20] characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>', 'ActionConfigurationProperty$required' => '<p>Whether the configuration property is a required value.</p>', 'ActionConfigurationProperty$secret' => '<p>Whether the configuration property is secret. Secrets are hidden from all calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and PollForThirdPartyJobs.</p> <p>When updating a pipeline, passing * * * * * without changing any other values of the action will preserve the prior value of the secret.</p>', 'PutActionRevisionOutput$newRevision' => '<p>The new revision number or ID for the revision after the action completes.</p>', ], ], 'ClientId' => [ 'refs' => [ 'ThirdPartyJob$clientId' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', ], ], 'ClientToken' => [ 'refs' => [ 'AcknowledgeThirdPartyJobInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'GetThirdPartyJobDetailsInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'PutThirdPartyJobFailureResultInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'PutThirdPartyJobSuccessResultInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', ], ], 'Code' => [ 'refs' => [ 'ErrorDetails$code' => '<p>The system ID or error number code of the error.</p>', ], ], 'ContinuationToken' => [ 'refs' => [ 'JobData$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires in order to continue the job asynchronously.</p>', 'PutJobSuccessResultInput$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, that the successful job used to complete a job asynchronously. </p>', 'PutThirdPartyJobSuccessResultInput$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job uses in order to continue the job asynchronously.</p>', 'ThirdPartyJobData$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires in order to continue the job asynchronously.</p>', ], ], 'CreateCustomActionTypeInput' => [ 'base' => '<p>Represents the input of a create custom action operation. </p>', 'refs' => [], ], 'CreateCustomActionTypeOutput' => [ 'base' => '<p>Represents the output of a create custom action operation.</p>', 'refs' => [], ], 'CreatePipelineInput' => [ 'base' => '<p>Represents the input of a create pipeline action.</p>', 'refs' => [], ], 'CreatePipelineOutput' => [ 'base' => '<p>Represents the output of a create pipeline action.</p>', 'refs' => [], ], 'CurrentRevision' => [ 'base' => '<p>Represents information about a current revision.</p>', 'refs' => [ 'PutJobSuccessResultInput$currentRevision' => '<p>The ID of the current revision of the artifact successfully worked upon by the job. </p>', ], ], 'DeleteCustomActionTypeInput' => [ 'base' => '<p>Represents the input of a delete custom action operation. The custom action will be marked as deleted.</p>', 'refs' => [], ], 'DeletePipelineInput' => [ 'base' => '<p>Represents the input of a delete pipeline action.</p>', 'refs' => [], ], 'Description' => [ 'refs' => [ 'ActionConfigurationProperty$description' => '<p>The description of the action configuration property that will be displayed to users.</p>', ], ], 'DisableStageTransitionInput' => [ 'base' => '<p>Represents the input of a disable stage transition input action.</p>', 'refs' => [], ], 'DisabledReason' => [ 'refs' => [ 'DisableStageTransitionInput$reason' => '<p>The reason given to the user why a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>', 'TransitionState$disabledReason' => '<p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>', ], ], 'EnableStageTransitionInput' => [ 'base' => '<p>Represents the input of an enable stage transition action.</p>', 'refs' => [], ], 'Enabled' => [ 'refs' => [ 'TransitionState$enabled' => '<p>Whether the transition between stages is enabled (true] or disabled (false].</p>', ], ], 'EncryptionKey' => [ 'base' => '<p>Represents information about the AWS Key Management Service (AWS KMS] key used to encrypt data in the artifact store.</p>', 'refs' => [ 'ArtifactStore$encryptionKey' => '<p>The AWS Key Management Service (AWS KMS] key used to encrypt the data in the artifact store. If this is undefined, the default key for Amazon S3 is used.</p>', 'ThirdPartyJobData$encryptionKey' => '<p>The AWS Key Management Service (AWS KMS] key used to encrypt and decrypt data in the artifact store for the pipeline.</p>', ], ], 'EncryptionKeyId' => [ 'refs' => [ 'EncryptionKey$id' => '<p>The ID of the AWS KMS key.</p>', ], ], 'EncryptionKeyType' => [ 'refs' => [ 'EncryptionKey$type' => '<p>The type of AWS KMS key, such as a customer master key.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Represents information about an error in AWS CodePipeline.</p>', 'refs' => [ 'ActionExecution$errorDetails' => '<p>The details of an error returned by a URL external to AWS.</p>', ], ], 'ExecutionDetails' => [ 'base' => '<p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline.</p>', 'refs' => [ 'PutJobSuccessResultInput$executionDetails' => '<p>The execution details of the successful job, such as the actions taken by the job worker. </p>', ], ], 'ExecutionId' => [ 'refs' => [ 'ActionExecution$externalExecutionId' => '<p>The external ID of the run of the action.</p>', 'ExecutionDetails$externalExecutionId' => '<p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>', 'FailureDetails$externalExecutionId' => '<p>The external ID of the run of the action that failed.</p>', ], ], 'ExecutionSummary' => [ 'refs' => [ 'ActionExecution$summary' => '<p>A summary of the run of the action.</p>', 'ExecutionDetails$summary' => '<p>The summary of the current status of the actions.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Represents information about failure details.</p>', 'refs' => [ 'PutJobFailureResultInput$failureDetails' => '<p>The details about the failure of a job. </p>', ], ], 'FailureType' => [ 'refs' => [ 'FailureDetails$type' => '<p>The type of the failure.</p>', ], ], 'GetJobDetailsInput' => [ 'base' => '<p>Represents the input of a get job details action.</p>', 'refs' => [], ], 'GetJobDetailsOutput' => [ 'base' => '<p>Represents the output of a get job details action.</p>', 'refs' => [], ], 'GetPipelineInput' => [ 'base' => '<p>Represents the input of a get pipeline action.</p>', 'refs' => [], ], 'GetPipelineOutput' => [ 'base' => '<p>Represents the output of a get pipeline action.</p>', 'refs' => [], ], 'GetPipelineStateInput' => [ 'base' => '<p>Represents the input of a get pipeline state action.</p>', 'refs' => [], ], 'GetPipelineStateOutput' => [ 'base' => '<p>Represents the output of a get pipeline state action.</p>', 'refs' => [], ], 'GetThirdPartyJobDetailsInput' => [ 'base' => '<p>Represents the input of a get third party job details action.</p>', 'refs' => [], ], 'GetThirdPartyJobDetailsOutput' => [ 'base' => '<p>Represents the output of a get third party job details action. </p>', 'refs' => [], ], 'InputArtifact' => [ 'base' => '<p>Represents information about an artifact to be worked on, such as a test or build artifact.</p>', 'refs' => [], ], 'InputArtifactList' => [ 'refs' => [ 'ActionDeclaration$inputArtifacts' => '<p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>', ], ], 'InvalidActionDeclarationException' => [ 'base' => '<p>The specified action declaration was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidBlockerDeclarationException' => [ 'base' => '<p>The specified gate declaration was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidClientTokenException' => [ 'base' => '<p>The client token was specified in an invalid format</p>', 'refs' => [], ], 'InvalidJobException' => [ 'base' => '<p>The specified job was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'InvalidJobStateException' => [ 'base' => '<p>The specified job state was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The next token was specified in an invalid format. Make sure that the next token you provided is the token returned by a previous call.</p>', 'refs' => [], ], 'InvalidNonceException' => [ 'base' => '<p>The specified nonce was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidStageDeclarationException' => [ 'base' => '<p>The specified stage declaration was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidStructureException' => [ 'base' => '<p>The specified structure was specified in an invalid format.</p>', 'refs' => [], ], 'Job' => [ 'base' => '<p>Represents information about a job.</p>', 'refs' => [], ], 'JobData' => [ 'base' => '<p>Represents additional information about a job required for a job worker to complete the job. </p>', 'refs' => [ 'Job$data' => '<p>Additional data about a job.</p>', ], ], 'JobDetails' => [ 'base' => '<p>Represents information about the details of a job.</p>', 'refs' => [ 'GetJobDetailsOutput$jobDetails' => '<p>The details of the job. </p> <note> <p>If AWSSessionCredentials is used, a long-running job can call GetJobDetails again to obtain new credentials.</p> </note>', ], ], 'JobId' => [ 'refs' => [ 'AcknowledgeJobInput$jobId' => '<p>The unique system-generated ID of the job for which you want to confirm receipt.</p>', 'GetJobDetailsInput$jobId' => '<p>The unique system-generated ID for the job.</p>', 'Job$id' => '<p>The unique system-generated ID of the job.</p>', 'JobDetails$id' => '<p>The unique system-generated ID of the job.</p>', 'PutJobFailureResultInput$jobId' => '<p>The unique system-generated ID of the job that failed. This is the same ID returned from PollForJobs.</p>', 'PutJobSuccessResultInput$jobId' => '<p>The unique system-generated ID of the job that succeeded. This is the same ID returned from PollForJobs.</p>', 'ThirdPartyJob$jobId' => '<p>The identifier used to identify the job in AWS CodePipeline.</p>', ], ], 'JobList' => [ 'refs' => [ 'PollForJobsOutput$jobs' => '<p>Information about the jobs to take action on.</p>', ], ], 'JobNotFoundException' => [ 'base' => '<p>The specified job was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'JobStatus' => [ 'refs' => [ 'AcknowledgeJobOutput$status' => '<p>Whether the job worker has received the specified job.</p>', 'AcknowledgeThirdPartyJobOutput$status' => '<p>The status information for the third party job, if any.</p>', ], ], 'LastChangedAt' => [ 'refs' => [ 'TransitionState$lastChangedAt' => '<p>The timestamp when the transition state was last changed.</p>', ], ], 'LastChangedBy' => [ 'refs' => [ 'TransitionState$lastChangedBy' => '<p>The ID of the user who last changed the transition state.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>', 'refs' => [], ], 'ListActionTypesInput' => [ 'base' => '<p>Represents the input of a list action types action.</p>', 'refs' => [], ], 'ListActionTypesOutput' => [ 'base' => '<p>Represents the output of a list action types action.</p>', 'refs' => [], ], 'ListPipelinesInput' => [ 'base' => '<p>Represents the input of a list pipelines action. </p>', 'refs' => [], ], 'ListPipelinesOutput' => [ 'base' => '<p>Represents the output of a list pipelines action.</p>', 'refs' => [], ], 'MaxBatchSize' => [ 'refs' => [ 'PollForJobsInput$maxBatchSize' => '<p>The maximum number of jobs to return in a poll for jobs call.</p>', 'PollForThirdPartyJobsInput$maxBatchSize' => '<p>The maximum number of jobs to return in a poll for jobs call.</p>', ], ], 'MaximumArtifactCount' => [ 'refs' => [ 'ArtifactDetails$maximumCount' => '<p>The maximum number of artifacts allowed for the action type.</p>', ], ], 'Message' => [ 'refs' => [ 'ErrorDetails$message' => '<p>The text of the error message.</p>', 'FailureDetails$message' => '<p>The message about the failure.</p>', ], ], 'MinimumArtifactCount' => [ 'refs' => [ 'ArtifactDetails$minimumCount' => '<p>The minimum number of artifacts allowed for the action type.</p>', ], ], 'NextToken' => [ 'refs' => [ 'ListActionTypesInput$nextToken' => '<p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>', 'ListActionTypesOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned which can be used in a subsequent list action types call to return the next set of action types in the list.</p>', 'ListPipelinesInput$nextToken' => '<p>An identifier that was returned from the previous list pipelines call, which can be used to return the next set of pipelines in the list.</p>', 'ListPipelinesOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned which can be used in a subsequent list pipelines call to return the next set of pipelines in the list.</p>', ], ], 'Nonce' => [ 'refs' => [ 'AcknowledgeJobInput$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. This number must be returned in the response.</p>', 'AcknowledgeThirdPartyJobInput$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. This number must be returned in the response.</p>', 'Job$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. This number must be returned in the response.</p>', 'ThirdPartyJobDetails$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. This number must be returned in the response.</p>', ], ], 'OutputArtifact' => [ 'base' => '<p>Represents information about the output of an action.</p>', 'refs' => [], ], 'OutputArtifactList' => [ 'refs' => [ 'ActionDeclaration$outputArtifacts' => '<p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>', ], ], 'Percentage' => [ 'refs' => [ 'ActionExecution$percentComplete' => '<p>A percentage of completeness of the action as it runs.</p>', 'ExecutionDetails$percentComplete' => '<p>The percentage of work completed on the action, represented on a scale of zero to one hundred percent.</p>', ], ], 'PipelineContext' => [ 'base' => '<p>Represents information about a pipeline to a job worker.</p>', 'refs' => [], ], 'PipelineDeclaration' => [ 'base' => '<p>Represents the structure of actions and stages to be performed in the pipeline. </p>', 'refs' => [ 'UpdatePipelineInput$pipeline' => '<p>The name of the pipeline to be updated.</p>', 'UpdatePipelineOutput$pipeline' => '<p>The structure of the updated pipeline.</p>', ], ], 'PipelineExecutionId' => [ 'refs' => [ 'PutActionRevisionOutput$pipelineExecutionId' => '<p>The ID of the current workflow state of the pipeline. </p>', 'StartPipelineExecutionOutput$pipelineExecutionId' => '<p>The unique system-generated ID of the pipeline that was started.</p>', ], ], 'PipelineList' => [ 'refs' => [ 'ListPipelinesOutput$pipelines' => '<p>The list of pipelines.</p>', ], ], 'PipelineName' => [ 'refs' => [ 'DeletePipelineInput$name' => '<p>The name of the pipeline to be deleted.</p>', 'DisableStageTransitionInput$pipelineName' => '<p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>', 'EnableStageTransitionInput$pipelineName' => '<p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>', 'GetPipelineInput$name' => '<p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an Amazon Web Services (AWS] user account.</p>', 'GetPipelineStateInput$name' => '<p>The name of the pipeline about which you want to get information.</p>', 'GetPipelineStateOutput$pipelineName' => '<p>The name of the pipeline for which you want to get the state.</p>', 'PipelineContext$pipelineName' => '<p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>', 'PipelineDeclaration$name' => '<p>The name of the action to be performed. </p>', 'PipelineSummary$name' => '<p>The name of the pipeline.</p>', 'PutActionRevisionInput$pipelineName' => '<p>The name of the pipeline that will start processing the revision to the source.</p>', 'StartPipelineExecutionInput$name' => '<p>The name of the pipeline to start.</p>', ], ], 'PipelineNameInUseException' => [ 'base' => '<p>The specified pipeline name is already in use.</p>', 'refs' => [], ], 'PipelineNotFoundException' => [ 'base' => '<p>The specified pipeline was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'PipelineStageDeclarationList' => [ 'refs' => [ 'PipelineDeclaration$stages' => '<p>The stage in which to perform the action. </p>', ], ], 'PipelineSummary' => [ 'base' => '<p>Returns a summary of a pipeline.</p>', 'refs' => [], ], 'PipelineVersion' => [ 'refs' => [ 'GetPipelineInput$version' => '<p>The version number of the pipeline. If you do not specify a version, defaults to the most current version.</p>', 'GetPipelineStateOutput$pipelineVersion' => '<p>The version number of the pipeline.</p> <note>A newly-created pipeline is always assigned a version number of <code>1</code>.</note>', 'PipelineDeclaration$version' => '<p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is automatically incremented when a pipeline is updated.</p>', 'PipelineSummary$version' => '<p>The version number of the pipeline.</p>', ], ], 'PipelineVersionNotFoundException' => [ 'base' => '<p>The specified pipeline version was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'PollForJobsInput' => [ 'base' => '<p>Represents the input of a poll for jobs action.</p>', 'refs' => [], ], 'PollForJobsOutput' => [ 'base' => '<p>Represents the output of a poll for jobs action.</p>', 'refs' => [], ], 'PollForThirdPartyJobsInput' => [ 'base' => '<p>Represents the input of a poll for third party jobs action.</p>', 'refs' => [], ], 'PollForThirdPartyJobsOutput' => [ 'base' => '<p>Represents the output of a poll for third party jobs action.</p>', 'refs' => [], ], 'PutActionRevisionInput' => [ 'base' => '<p>Represents the input of a put action revision action.</p>', 'refs' => [], ], 'PutActionRevisionOutput' => [ 'base' => '<p>Represents the output of a put action revision action.</p>', 'refs' => [], ], 'PutJobFailureResultInput' => [ 'base' => '<p>Represents the input of a put job failure result action. </p>', 'refs' => [], ], 'PutJobSuccessResultInput' => [ 'base' => '<p>Represents the input of a put job success result action. </p>', 'refs' => [], ], 'PutThirdPartyJobFailureResultInput' => [ 'base' => '<p>Represents the input of a third party job failure result action.</p>', 'refs' => [], ], 'PutThirdPartyJobSuccessResultInput' => [ 'base' => '<p>Represents the input of a put third party job success result action.</p>', 'refs' => [], ], 'QueryParamMap' => [ 'refs' => [ 'PollForJobsInput$queryParam' => '<p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value will be returned.</p>', ], ], 'Revision' => [ 'refs' => [ 'Artifact$revision' => '<p>The artifact\'s revision ID. Depending on the type of object, this could be a commit ID (GitHub] or a revision ID (Amazon S3].</p>', 'CurrentRevision$revision' => '<p>The revision ID of the current version of an artifact.</p>', ], ], 'RevisionChangeId' => [ 'refs' => [ 'ActionRevision$revisionChangeId' => '<p>The unique identifier of the change that set the state to this revision, for example a deployment ID or timestamp.</p>', ], ], 'RevisionChangeIdentifier' => [ 'refs' => [ 'CurrentRevision$changeIdentifier' => '<p>The change identifier for the current revision.</p>', ], ], 'RevisionId' => [ 'refs' => [ 'ActionRevision$revisionId' => '<p>The system-generated unique ID that identifies the revision number of the action.</p>', ], ], 'RoleArn' => [ 'refs' => [ 'ActionDeclaration$roleArn' => '<p>The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.</p>', 'PipelineDeclaration$roleArn' => '<p>The Amazon Resource Name (ARN] for AWS CodePipeline to use to either perform actions with no actionRoleArn, or to use to assume roles for actions with an actionRoleArn.</p>', ], ], 'S3ArtifactLocation' => [ 'base' => '<p>The location of the Amazon S3 bucket that contains a revision.</p>', 'refs' => [ 'ArtifactLocation$s3Location' => '<p>The Amazon S3 bucket that contains the artifact.</p>', ], ], 'S3BucketName' => [ 'refs' => [ 'S3ArtifactLocation$bucketName' => '<p>The name of the Amazon S3 bucket. </p>', ], ], 'S3ObjectKey' => [ 'refs' => [ 'S3ArtifactLocation$objectKey' => '<p>The key of the object in the Amazon S3 bucket, which uniquely identifies the object in the bucket. </p>', ], ], 'SecretAccessKey' => [ 'refs' => [ 'AWSSessionCredentials$secretAccessKey' => '<p>The secret access key for the session.</p>', ], ], 'SessionToken' => [ 'refs' => [ 'AWSSessionCredentials$sessionToken' => '<p>The token for the session.</p>', ], ], 'StageActionDeclarationList' => [ 'refs' => [ 'StageDeclaration$actions' => '<p>The actions included in a stage.</p>', ], ], 'StageBlockerDeclarationList' => [ 'refs' => [ 'StageDeclaration$blockers' => '<p>The gates included in a stage.</p>', ], ], 'StageContext' => [ 'base' => '<p>Represents information about a stage to a job worker.</p>', 'refs' => [ 'PipelineContext$stage' => '<p>The stage of the pipeline.</p>', ], ], 'StageDeclaration' => [ 'base' => '<p>Represents information about a stage and its definition.</p>', 'refs' => [], ], 'StageName' => [ 'refs' => [ 'DisableStageTransitionInput$stageName' => '<p>The name of the stage where you want to disable the inbound or outbound transition of artifacts. </p>', 'EnableStageTransitionInput$stageName' => '<p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound] or from that stage to the next stage (outbound].</p>', 'PutActionRevisionInput$stageName' => '<p>The name of the stage that contains the action that will act upon the revision.</p>', 'StageContext$name' => '<p>The name of the stage.</p>', 'StageDeclaration$name' => '<p>The name of the stage.</p>', 'StageState$stageName' => '<p>The name of the stage.</p>', ], ], 'StageNotFoundException' => [ 'base' => '<p>The specified stage was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'StageState' => [ 'base' => '<p>Represents information about the state of the stage.</p>', 'refs' => [], ], 'StageStateList' => [ 'refs' => [ 'GetPipelineStateOutput$stageStates' => '<p>A list of the pipeline stage output information, including stage name, state, most recent run details, whether the stage is disabled, and other data. </p>', ], ], 'StageTransitionType' => [ 'refs' => [ 'DisableStageTransitionInput$transitionType' => '<p>Specifies whether artifacts will be prevented from transitioning into the stage and being processed by the actions in that stage (inbound], or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound].</p>', 'EnableStageTransitionInput$transitionType' => '<p>Specifies whether artifacts will be allowed to enter the stage and be processed by the actions in that stage (inbound] or whether already-processed artifacts will be allowed to transition to the next stage (outbound].</p>', ], ], 'StartPipelineExecutionInput' => [ 'base' => '<p>Represents the input of a start pipeline execution action.</p>', 'refs' => [], ], 'StartPipelineExecutionOutput' => [ 'base' => '<p>Represents the output of a start pipeline execution action.</p>', 'refs' => [], ], 'ThirdPartyJob' => [ 'base' => '<p>A response to a PollForThirdPartyJobs request returned by AWS CodePipeline when there is a job to be worked upon by a partner action.</p>', 'refs' => [], ], 'ThirdPartyJobData' => [ 'base' => '<p>Represents information about the job data for a partner action.</p>', 'refs' => [ 'ThirdPartyJobDetails$data' => '<p>The data to be returned by the third party job worker.</p>', ], ], 'ThirdPartyJobDetails' => [ 'base' => '<p>The details of a job sent in response to a GetThirdPartyJobDetails request.</p>', 'refs' => [ 'GetThirdPartyJobDetailsOutput$jobDetails' => '<p>The details of the job, including any protected values defined for the job. </p>', ], ], 'ThirdPartyJobId' => [ 'refs' => [ 'AcknowledgeThirdPartyJobInput$jobId' => '<p>The unique system-generated ID of the job.</p>', 'GetThirdPartyJobDetailsInput$jobId' => '<p>The unique system-generated ID used for identifying the job.</p>', 'PutThirdPartyJobFailureResultInput$jobId' => '<p>The ID of the job that failed. This is the same ID returned from PollForThirdPartyJobs.</p>', 'PutThirdPartyJobSuccessResultInput$jobId' => '<p>The ID of the job that successfully completed. This is the same ID returned from PollForThirdPartyJobs.</p>', 'ThirdPartyJobDetails$id' => '<p>The identifier used to identify the job details in AWS CodePipeline.</p>', ], ], 'ThirdPartyJobList' => [ 'refs' => [ 'PollForThirdPartyJobsOutput$jobs' => '<p>Information about the jobs to take action on.</p>', ], ], 'Timestamp' => [ 'refs' => [ 'ActionExecution$lastStatusChange' => '<p>The last status change of the action.</p>', 'ActionRevision$created' => '<p>The date and time when the most recent version of the action was created, in timestamp format.</p>', 'GetPipelineStateOutput$created' => '<p>The date and time the pipeline was created, in timestamp format.</p>', 'GetPipelineStateOutput$updated' => '<p>The date and time the pipeline was last updated, in timestamp format.</p>', 'PipelineSummary$created' => '<p>The date and time the pipeline was created, in timestamp format.</p>', 'PipelineSummary$updated' => '<p>The date and time of the last update to the pipeline, in timestamp format.</p>', ], ], 'TransitionState' => [ 'base' => '<p>Represents information about the state of transitions between one stage and another stage.</p>', 'refs' => [ 'StageState$inboundTransitionState' => '<p>The state of the inbound transition, which is either enabled or disabled.</p>', ], ], 'UpdatePipelineInput' => [ 'base' => '<p>Represents the input of an update pipeline action.</p>', 'refs' => [], ], 'UpdatePipelineOutput' => [ 'base' => '<p>Represents the output of an update pipeline action.</p>', 'refs' => [], ], 'Url' => [ 'refs' => [ 'ActionExecution$externalExecutionUrl' => '<p>The URL of a resource external to AWS that will be used when running the action, for example an external repository URL.</p>', 'ActionState$entityUrl' => '<p>A URL link for more information about the state of the action, such as a deployment group details page.</p>', 'ActionState$revisionUrl' => '<p>A URL link for more information about the revision, such as a commit details page.</p>', 'ActionTypeSettings$thirdPartyConfigurationUrl' => '<p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service. </p>', ], ], 'UrlTemplate' => [ 'refs' => [ 'ActionTypeSettings$entityUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display within the pipeline.</p>', 'ActionTypeSettings$executionUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>', 'ActionTypeSettings$revisionUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The validation was specified in an invalid format.</p>', 'refs' => [], ], 'Version' => [ 'refs' => [ 'ActionTypeId$version' => '<p>A string that identifies the action type. </p>', 'CreateCustomActionTypeInput$version' => '<p>The version number of the custom action. </p> <note>A newly-created custom action is always assigned a version number of <code>1</code>. This is required.</note>', 'DeleteCustomActionTypeInput$version' => '<p>The version of the custom action to delete.</p>', ], ], ], 'service' => '<fullname>AWS CodePipeline</fullname> <b>Overview</b> <p>This is the AWS CodePipeline API Reference. This guide provides descriptions of the actions and data types for AWS CodePipeline. Some functionality for your pipeline is only configurable through the API. For additional information, see the <a href="http://docs.aws.amazon.com/pipelines/latest/userguide/welcome.html">AWS CodePipeline User Guide</a>.</p> <p>You can use the AWS CodePipeline API to work with pipelines, stages, actions, gates, and transitions, as described below.</p> <p><i>Pipelines</i> are models of automated release processes. Each pipeline is uniquely named, and consists of actions, gates, and stages. </p> <p>You can work with pipelines by calling: <ul> <li> <a>CreatePipeline</a>, which creates a uniquely-named pipeline.</li> <li> <a>DeletePipeline</a>, which deletes the specified pipeline.</li> <li> <a>GetPipeline</a>, which returns information about a pipeline structure.</li> <li> <a>GetPipelineState</a>, which returns information about the current state of the stages and actions of a pipeline.</li> <li> <a>ListPipelines</a>, which gets a summary of all of the pipelines associated with your account.</li> <li> <a>StartPipelineExecution</a>, which runs the the most recent revision of an artifact through the pipeline.</li> <li> <a>UpdatePipeline</a>, which updates a pipeline with edits or changes to the structure of the pipeline.</li> </ul> <p>Pipelines include <i>stages</i>, which are which are logical groupings of gates and actions. Each stage contains one or more actions that must complete before the next stage begins. A stage will result in success or failure. If a stage fails, then the pipeline stops at that stage and will remain stopped until either a new version of an artifact appears in the source location, or a user takes action to re-run the most recent artifact through the pipeline. You can call <a>GetPipelineState</a>, which displays the status of a pipeline, including the status of stages in the pipeline, or <a>GetPipeline</a>, which returns the entire structure of the pipeline, including the stages of that pipeline. For more information about the structure of stages and actions, also refer to the <ulink url="http://docs.aws.amazon.com/codepipeline/latest/UserGuide/pipeline-structure.html">AWS CodePipeline Pipeline Structure Reference</ulink>.</p> </p> <p>Pipeline stages include <i>actions</i>, which are categorized into categories such as source or build actions performed within a stage of a pipeline. For example, you can use a source action to import artifacts into a pipeline from a source such as Amazon S3. Like stages, you do not work with actions directly in most cases, but you do define and interact with actions when working with pipeline operations such as <a>CreatePipeline</a> and <a>GetPipelineState</a>. </p> <p>Pipelines also include <i>transitions</i>, which allow the transition of artifacts from one stage to the next in a pipeline after the actions in one stage complete.</p> <p>You can work with transitions by calling:</p> <ul> <li> <a>DisableStageTransition</a>, which prevents artifacts from transitioning to the next stage in a pipeline.</li> <li> <a>EnableStageTransition</a>, which enables transition of artifacts between stages in a pipeline. </li> </ul> <p><b>Using the API to integrate with AWS CodePipeline</b></p> <p>For third-party integrators or developers who want to create their own integrations with AWS CodePipeline, the expected sequence varies from the standard API user. In order to integrate with AWS CodePipeline, developers will need to work with the following items:</p> <ul> <li>Jobs, which are instances of an action. For example, a job for a source action might import a revision of an artifact from a source. <p>You can work with jobs by calling:</p> <ul> <li> <a>AcknowledgeJob</a>, which confirms whether a job worker has received the specified job,</li> <li> <a>GetJobDetails</a>, which returns the details of a job,</li> <li> <a>PollForJobs</a>, which determines whether there are any jobs to act upon, </li> <li> <a>PutJobFailureResult</a>, which provides details of a job failure, and</li> <li> <a>PutJobSuccessResult</a>, which provides details of a job success.</li> </ul> </li> <li>Third party jobs, which are instances of an action created by a partner action and integrated into AWS CodePipeline. Partner actions are created by members of the AWS Partner Network. <p>You can work with third party jobs by calling:</p> <ul> <li> <a>AcknowledgeThirdPartyJob</a>, which confirms whether a job worker has received the specified job,</li> <li> <a>GetThirdPartyJobDetails</a>, which requests the details of a job for a partner action,</li> <li> <a>PollForThirdPartyJobs</a>, which determines whether there are any jobs to act upon, </li> <li> <a>PutThirdPartyJobFailureResult</a>, which provides details of a job failure, and</li> <li> <a>PutThirdPartyJobSuccessResult</a>, which provides details of a job success.</li> </ul> </li> </ul>',];
