<?php
// This file was auto-generated from sdk-root/src/data/ds/2015-04-16/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Directory Service</fullname> <p>This is the <i>AWS Directory Service API Reference</i>. This guide provides detailed information about AWS Directory Service operations, data types, parameters, and errors.</p>', 'operations' => [ 'ConnectDirectory' => '<p>Creates an AD Connector to connect to an on-premises directory.</p>', 'CreateAlias' => '<p>Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the access URL for the directory, such as <code>http://<![CDATA[&#x3C;]]>alias<![CDATA[&#x3E;]]>.awsapps.com</code>.</p> <important> <p>After an alias has been created, it cannot be deleted or reused, so this operation should only be used when absolutely necessary.</p> </important>', 'CreateComputer' => '<p>Creates a computer account in the specified directory, and joins the computer to the directory.</p>', 'CreateDirectory' => '<p>Creates a Simple AD directory.</p>', 'CreateMicrosoftAD' => 'Creates a Microsoft AD in the AWS cloud.', 'CreateSnapshot' => '<p>Creates a snapshot of a Simple AD directory.</p> <note> <p>You cannot take snapshots of AD Connector directories.</p> </note>', 'CreateTrust' => '<p>AWS Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your Microsoft AD in the AWS cloud, and your existing on-premises Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials.</p><p>This action initiates the creation of the AWS side of a trust relationship between a Microsoft AD in the AWS cloud and an external domain.</p>', 'DeleteDirectory' => '<p>Deletes an AWS Directory Service directory.</p>', 'DeleteSnapshot' => '<p>Deletes a directory snapshot.</p>', 'DeleteTrust' => 'Deletes an existing trust relationship between your Microsoft AD in the AWS cloud and an external domain.', 'DescribeDirectories' => '<p>Obtains information about the directories that belong to this account.</p> <p>You can retrieve information about specific directories by passing the directory identifiers in the <i>DirectoryIds</i> parameter. Otherwise, all directories that belong to the current account are returned.</p> <p>This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more results are available, the <i>DescribeDirectoriesResult.NextToken</i> member contains a token that you pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.</p> <p>You can also specify a maximum number of return results with the <i>Limit</i> parameter.</p>', 'DescribeSnapshots' => '<p>Obtains information about the directory snapshots that belong to this account.</p> <p>This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next call to <a>DescribeSnapshots</a> to retrieve the next set of items.</p> <p>You can also specify a maximum number of return results with the <i>Limit</i> parameter.</p>', 'DescribeTrusts' => '<p>Obtains information about the trust relationships for this account.</p> <p>If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust relationships belonging to the account.</p>', 'DisableRadius' => '<p>Disables multi-factor authentication (MFA] with the Remote Authentication Dial In User Service (RADIUS] server for an AD Connector directory.</p>', 'DisableSso' => '<p>Disables single-sign on for a directory.</p>', 'EnableRadius' => '<p>Enables multi-factor authentication (MFA] with the Remote Authentication Dial In User Service (RADIUS] server for an AD Connector directory.</p>', 'EnableSso' => '<p>Enables single-sign on for a directory.</p>', 'GetDirectoryLimits' => '<p>Obtains directory limit information for the current region.</p>', 'GetSnapshotLimits' => '<p>Obtains the manual snapshot limits for a directory.</p>', 'RestoreFromSnapshot' => '<p>Restores a directory using an existing directory snapshot.</p> <p>When you restore a directory from a snapshot, any changes made to the directory after the snapshot date are overwritten.</p> <p>This action returns as soon as the restore operation is initiated. You can monitor the progress of the restore operation by calling the <a>DescribeDirectories</a> operation with the directory identifier. When the <b>DirectoryDescription.Stage</b> value changes to <code>Active</code>, the restore operation is complete.</p>', 'UpdateRadius' => '<p>Updates the Remote Authentication Dial In User Service (RADIUS] server information for an AD Connector directory.</p>', 'VerifyTrust' => '<p>AWS Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships. </p><p>This action verifies a trust relationship between your Microsoft AD in the AWS cloud and an external domain.</p>', ], 'shapes' => [ 'AccessUrl' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$AccessUrl' => '<p>The access URL for the directory, such as <code>http://<![CDATA[&#x3C;]]>alias<![CDATA[&#x3E;]]>.awsapps.com</code>. If no alias has been created for the directory, <code><![CDATA[&#x3C;]]>alias<![CDATA[&#x3E;]]></code> is the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>', ], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'CreateAliasRequest$Alias' => '<p>The requested alias.</p> <p>The alias must be unique amongst all aliases in AWS. This operation throws an <code>EntityAlreadyExistsException</code> error if the alias already exists.</p>', 'CreateAliasResult$Alias' => '<p>The alias for the directory.</p>', 'DirectoryDescription$Alias' => '<p>The alias for the directory. If no alias has been created for the directory, the alias is the directory identifier, such as <code>d-XXXXXXXXXX</code>.</p>', ], ], 'Attribute' => [ 'base' => '<p>Represents a named directory attribute.</p>', 'refs' => [ 'Attributes$member' => NULL, ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attribute$Name' => '<p>The name of the attribute.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$Value' => '<p>The value of the attribute.</p>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'Computer$ComputerAttributes' => '<p>An array of <a>Attribute</a> objects containing the LDAP attributes that belong to the computer account.</p>', 'CreateComputerRequest$ComputerAttributes' => '<p>An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.</p>', ], ], 'AuthenticationFailedException' => [ 'base' => '<p>An authentication error occurred.</p>', 'refs' => [], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettingsDescription$AvailabilityZones' => '<p>A list of the Availability Zones that the directory is in.</p>', 'DirectoryVpcSettingsDescription$AvailabilityZones' => '<p>The list of Availability Zones that the directory is in.</p>', ], ], 'ClientException' => [ 'base' => '<p>A client exception has occurred.</p>', 'refs' => [], ], 'CloudOnlyDirectoriesLimitReached' => [ 'base' => NULL, 'refs' => [ 'DirectoryLimits$CloudOnlyDirectoriesLimitReached' => '<p>Indicates if the cloud directory limit has been reached.</p>', 'DirectoryLimits$CloudOnlyMicrosoftADLimitReached' => 'Indicates if the Microsoft AD directory limit has been reached.', ], ], 'Computer' => [ 'base' => '<p>Contains information about a computer account in a directory.</p>', 'refs' => [ 'CreateComputerResult$Computer' => '<p>A <a>Computer</a> object that represents the computer account.</p>', ], ], 'ComputerName' => [ 'base' => NULL, 'refs' => [ 'Computer$ComputerName' => '<p>The computer name.</p>', 'CreateComputerRequest$ComputerName' => '<p>The name of the computer account.</p>', ], ], 'ComputerPassword' => [ 'base' => NULL, 'refs' => [ 'CreateComputerRequest$Password' => '<p>A one-time password that is used to join the computer to the directory. You should generate a random, strong password to use for this parameter.</p>', ], ], 'ConnectDirectoryRequest' => [ 'base' => '<p>Contains the inputs for the <a>ConnectDirectory</a> operation.</p>', 'refs' => [], ], 'ConnectDirectoryResult' => [ 'base' => '<p>Contains the results of the <a>ConnectDirectory</a> operation.</p>', 'refs' => [], ], 'ConnectPassword' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryRequest$Password' => '<p>The password for the on-premises user account.</p>', 'DisableSsoRequest$Password' => '<p>The password of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>', 'EnableSsoRequest$Password' => '<p>The password of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. For more information, see the <i>UserName</i> parameter.</p>', ], ], 'ConnectedDirectoriesLimitReached' => [ 'base' => NULL, 'refs' => [ 'DirectoryLimits$ConnectedDirectoriesLimitReached' => '<p>Indicates if the connected directory limit has been reached.</p>', ], ], 'CreateAliasRequest' => [ 'base' => '<p>Contains the inputs for the <a>CreateAlias</a> operation.</p>', 'refs' => [], ], 'CreateAliasResult' => [ 'base' => '<p>Contains the results of the <a>CreateAlias</a> operation.</p>', 'refs' => [], ], 'CreateComputerRequest' => [ 'base' => '<p>Contains the inputs for the <a>CreateComputer</a> operation.</p>', 'refs' => [], ], 'CreateComputerResult' => [ 'base' => '<p>Contains the results for the <a>CreateComputer</a> operation.</p>', 'refs' => [], ], 'CreateDirectoryRequest' => [ 'base' => '<p>Contains the inputs for the <a>CreateDirectory</a> operation. </p>', 'refs' => [], ], 'CreateDirectoryResult' => [ 'base' => '<p>Contains the results of the <a>CreateDirectory</a> operation.</p>', 'refs' => [], ], 'CreateMicrosoftADRequest' => [ 'base' => 'Creates a Microsoft AD in the AWS cloud.', 'refs' => [], ], 'CreateMicrosoftADResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => '<p>Contains the inputs for the <a>CreateSnapshot</a> operation.</p>', 'refs' => [], ], 'CreateSnapshotResult' => [ 'base' => '<p>Contains the results of the <a>CreateSnapshot</a> operation.</p>', 'refs' => [], ], 'CreateTrustRequest' => [ 'base' => '<p>AWS Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your Microsoft AD in the AWS cloud, and your existing on-premises Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials.</p><p>This action initiates the creation of the AWS side of a trust relationship between a Microsoft AD in the AWS cloud and an external domain.</p>', 'refs' => [], ], 'CreateTrustResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDateTime' => [ 'base' => NULL, 'refs' => [ 'Trust$CreatedDateTime' => 'The date and time that the trust relationship was created.', ], ], 'DeleteDirectoryRequest' => [ 'base' => '<p>Contains the inputs for the <a>DeleteDirectory</a> operation.</p>', 'refs' => [], ], 'DeleteDirectoryResult' => [ 'base' => '<p>Contains the results of the <a>DeleteDirectory</a> operation.</p>', 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => '<p>Contains the inputs for the <a>DeleteSnapshot</a> operation.</p>', 'refs' => [], ], 'DeleteSnapshotResult' => [ 'base' => '<p>Contains the results of the <a>DeleteSnapshot</a> operation.</p>', 'refs' => [], ], 'DeleteTrustRequest' => [ 'base' => 'Deletes the local side of an existing trust relationship between the Microsoft AD in the AWS cloud and the external domain.', 'refs' => [], ], 'DeleteTrustResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDirectoriesRequest' => [ 'base' => '<p>Contains the inputs for the <a>DescribeDirectories</a> operation.</p>', 'refs' => [], ], 'DescribeDirectoriesResult' => [ 'base' => '<p>Contains the results of the <a>DescribeDirectories</a> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => '<p>Contains the inputs for the <a>DescribeSnapshots</a> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsResult' => [ 'base' => '<p>Contains the results of the <a>DescribeSnapshots</a> operation.</p>', 'refs' => [], ], 'DescribeTrustsRequest' => [ 'base' => 'Describes the trust relationships for a particular Microsoft AD in the AWS cloud. If no input parameters are are provided, such as directory ID or trust ID, this request describes all the trust relationships.', 'refs' => [], ], 'DescribeTrustsResult' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryRequest$Description' => '<p>A textual description for the directory.</p>', 'CreateDirectoryRequest$Description' => '<p>A textual description for the directory.</p>', 'CreateMicrosoftADRequest$Description' => '<p>A textual description for the directory. This label will appear on the AWS console <code>Directory Details</code> page after the directory is created.</p>', 'DirectoryDescription$Description' => '<p>The textual description for the directory.</p>', ], ], 'DirectoryConnectSettings' => [ 'base' => '<p>Contains information for the <a>ConnectDirectory</a> operation when an AD Connector directory is being created.</p>', 'refs' => [ 'ConnectDirectoryRequest$ConnectSettings' => '<p>A <a>DirectoryConnectSettings</a> object that contains additional information for the operation.</p>', ], ], 'DirectoryConnectSettingsDescription' => [ 'base' => '<p>Contains information about an AD Connector directory.</p>', 'refs' => [ 'DirectoryDescription$ConnectSettings' => '<p>A <a>DirectoryConnectSettingsDescription</a> object that contains additional information about an AD Connector directory. This member is only present if the directory is an AD Connector directory.</p>', ], ], 'DirectoryDescription' => [ 'base' => '<p>Contains information about an AWS Directory Service directory.</p>', 'refs' => [ 'DirectoryDescriptions$member' => NULL, ], ], 'DirectoryDescriptions' => [ 'base' => '<p>A list of directory descriptions.</p>', 'refs' => [ 'DescribeDirectoriesResult$DirectoryDescriptions' => '<p>The list of <a>DirectoryDescription</a> objects that were retrieved.</p> <p>It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryResult$DirectoryId' => '<p>The identifier of the new directory.</p>', 'CreateAliasRequest$DirectoryId' => '<p>The identifier of the directory for which to create the alias.</p>', 'CreateAliasResult$DirectoryId' => '<p>The identifier of the directory.</p>', 'CreateComputerRequest$DirectoryId' => '<p>The identifier of the directory in which to create the computer account.</p>', 'CreateDirectoryResult$DirectoryId' => '<p>The identifier of the directory that was created.</p>', 'CreateMicrosoftADResult$DirectoryId' => 'The identifier of the directory that was created.', 'CreateSnapshotRequest$DirectoryId' => '<p>The identifier of the directory to take a snapshot of.</p>', 'CreateTrustRequest$DirectoryId' => 'The Directory ID of the Microsoft AD in the AWS cloud for which to establish the trust relationship.', 'DeleteDirectoryRequest$DirectoryId' => '<p>The identifier of the directory to delete.</p>', 'DeleteDirectoryResult$DirectoryId' => '<p>The directory identifier.</p>', 'DescribeSnapshotsRequest$DirectoryId' => '<p>The identifier of the directory for which to retrieve snapshot information.</p>', 'DescribeTrustsRequest$DirectoryId' => 'The Directory ID of the AWS directory that is a part of the requested trust relationship.', 'DirectoryDescription$DirectoryId' => '<p>The directory identifier.</p>', 'DirectoryIds$member' => NULL, 'DisableRadiusRequest$DirectoryId' => '<p>The identifier of the directory for which to disable MFA.</p>', 'DisableSsoRequest$DirectoryId' => '<p>The identifier of the directory for which to disable single-sign on.</p>', 'EnableRadiusRequest$DirectoryId' => '<p>The identifier of the directory for which to enable MFA.</p>', 'EnableSsoRequest$DirectoryId' => '<p>The identifier of the directory for which to enable single-sign on.</p>', 'GetSnapshotLimitsRequest$DirectoryId' => '<p>Contains the identifier of the directory to obtain the limits for.</p>', 'Snapshot$DirectoryId' => '<p>The directory identifier.</p>', 'Trust$DirectoryId' => 'The Directory ID of the AWS directory involved in the trust relationship.', 'UpdateRadiusRequest$DirectoryId' => '<p>The identifier of the directory for which to update the RADIUS server information.</p>', ], ], 'DirectoryIds' => [ 'base' => '<p>A list of directory identifiers.</p>', 'refs' => [ 'DescribeDirectoriesRequest$DirectoryIds' => '<p>A list of identifiers of the directories for which to obtain the information. If this member is null, all directories that belong to the current account are returned.</p> <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>', ], ], 'DirectoryLimitExceededException' => [ 'base' => '<p>The maximum number of directories in the region has been reached. You can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</p>', 'refs' => [], ], 'DirectoryLimits' => [ 'base' => '<p>Contains directory limit information for a region.</p>', 'refs' => [ 'GetDirectoryLimitsResult$DirectoryLimits' => '<p>A <a>DirectoryLimits</a> object that contains the directory limits for the current region.</p>', ], ], 'DirectoryName' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryRequest$Name' => '<p>The fully-qualified name of the on-premises directory, such as <code>corp.example.com</code>.</p>', 'CreateDirectoryRequest$Name' => '<p>The fully qualified name for the directory, such as <code>corp.example.com</code>.</p>', 'CreateMicrosoftADRequest$Name' => '<p>The fully qualified domain name for the directory, such as <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be publicly resolvable.</p>', 'DirectoryDescription$Name' => '<p>The fully-qualified name of the directory.</p>', ], ], 'DirectoryShortName' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryRequest$ShortName' => '<p>The NetBIOS name of the on-premises directory, such as <code>CORP</code>.</p>', 'CreateDirectoryRequest$ShortName' => '<p>The short name of the directory, such as <code>CORP</code>.</p>', 'CreateMicrosoftADRequest$ShortName' => '<p>The NetBIOS name for your domain. A short identifier for your domain, such as <code>CORP</code>. If you don\'t specify a NetBIOS name, it will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS <code>corp.example.com</code>. </p>', 'DirectoryDescription$ShortName' => '<p>The short name of the directory.</p>', ], ], 'DirectorySize' => [ 'base' => NULL, 'refs' => [ 'ConnectDirectoryRequest$Size' => '<p>The size of the directory.</p>', 'CreateDirectoryRequest$Size' => '<p>The size of the directory.</p>', 'DirectoryDescription$Size' => '<p>The directory size.</p>', ], ], 'DirectoryStage' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$Stage' => '<p>The current stage of the directory.</p>', ], ], 'DirectoryType' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$Type' => '<p>The directory size.</p>', ], ], 'DirectoryUnavailableException' => [ 'base' => '<p>The specified directory is unavailable or could not be found.</p>', 'refs' => [], ], 'DirectoryVpcSettings' => [ 'base' => '<p>Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.</p>', 'refs' => [ 'CreateDirectoryRequest$VpcSettings' => '<p>A <a>DirectoryVpcSettings</a> object that contains additional information for the operation.</p>', 'CreateMicrosoftADRequest$VpcSettings' => NULL, ], ], 'DirectoryVpcSettingsDescription' => [ 'base' => '<p>Contains information about the directory.</p>', 'refs' => [ 'DirectoryDescription$VpcSettings' => '<p>A <a>DirectoryVpcSettingsDescription</a> object that contains additional information about a directory. This member is only present if the directory is a Simple AD or Managed AD directory.</p>', ], ], 'DisableRadiusRequest' => [ 'base' => '<p>Contains the inputs for the <a>DisableRadius</a> operation.</p>', 'refs' => [], ], 'DisableRadiusResult' => [ 'base' => '<p>Contains the results of the <a>DisableRadius</a> operation.</p>', 'refs' => [], ], 'DisableSsoRequest' => [ 'base' => '<p>Contains the inputs for the <a>DisableSso</a> operation.</p>', 'refs' => [], ], 'DisableSsoResult' => [ 'base' => '<p>Contains the results of the <a>DisableSso</a> operation.</p>', 'refs' => [], ], 'DnsIpAddrs' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettings$CustomerDnsIps' => '<p>A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.</p>', 'DirectoryDescription$DnsIpAddrs' => '<p>The IP addresses of the DNS servers for the directory. For a Simple AD or Microsoft AD directory, these are the IP addresses of the Simple AD or Microsoft AD directory servers. For an AD Connector directory, these are the IP addresses of the DNS servers or domain controllers in the on-premises directory to which the AD Connector is connected.</p>', ], ], 'EnableRadiusRequest' => [ 'base' => '<p>Contains the inputs for the <a>EnableRadius</a> operation.</p>', 'refs' => [], ], 'EnableRadiusResult' => [ 'base' => '<p>Contains the results of the <a>EnableRadius</a> operation.</p>', 'refs' => [], ], 'EnableSsoRequest' => [ 'base' => '<p>Contains the inputs for the <a>EnableSso</a> operation.</p>', 'refs' => [], ], 'EnableSsoResult' => [ 'base' => '<p>Contains the results of the <a>EnableSso</a> operation.</p>', 'refs' => [], ], 'EntityAlreadyExistsException' => [ 'base' => '<p>The specified entity already exists.</p>', 'refs' => [], ], 'EntityDoesNotExistException' => [ 'base' => '<p>The specified entity could not be found.</p>', 'refs' => [], ], 'ExceptionMessage' => [ 'base' => '<p>The descriptive message for the exception.</p>', 'refs' => [ 'AuthenticationFailedException$Message' => '<p>The textual message for the exception.</p>', 'ClientException$Message' => NULL, 'DirectoryLimitExceededException$Message' => NULL, 'DirectoryUnavailableException$Message' => NULL, 'EntityAlreadyExistsException$Message' => NULL, 'EntityDoesNotExistException$Message' => NULL, 'InsufficientPermissionsException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'ServiceException$Message' => NULL, 'SnapshotLimitExceededException$Message' => NULL, 'UnsupportedOperationException$Message' => NULL, ], ], 'GetDirectoryLimitsRequest' => [ 'base' => '<p>Contains the inputs for the <a>GetDirectoryLimits</a> operation.</p>', 'refs' => [], ], 'GetDirectoryLimitsResult' => [ 'base' => '<p>Contains the results of the <a>GetDirectoryLimits</a> operation.</p>', 'refs' => [], ], 'GetSnapshotLimitsRequest' => [ 'base' => '<p>Contains the inputs for the <a>GetSnapshotLimits</a> operation.</p>', 'refs' => [], ], 'GetSnapshotLimitsResult' => [ 'base' => '<p>Contains the results of the <a>GetSnapshotLimits</a> operation.</p>', 'refs' => [], ], 'InsufficientPermissionsException' => [ 'base' => '<p>The account does not have sufficient permission to perform the operation.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <i>NextToken</i> value is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more parameters are not valid.</p>', 'refs' => [], ], 'IpAddr' => [ 'base' => NULL, 'refs' => [ 'DnsIpAddrs$member' => NULL, 'IpAddrs$member' => NULL, ], ], 'IpAddrs' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettingsDescription$ConnectIps' => '<p>The IP addresses of the AD Connector servers.</p>', ], ], 'LastUpdatedDateTime' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$StageLastUpdatedDateTime' => '<p>The date and time that the stage was last updated.</p>', 'Trust$LastUpdatedDateTime' => 'The date and time that the trust relationship was last updated.', ], ], 'LaunchTime' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$LaunchTime' => '<p>Specifies when the directory was created.</p>', ], ], 'Limit' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoriesRequest$Limit' => '<p>The maximum number of items to return. If this value is zero, the maximum number of items is specified by the limitations of the operation.</p>', 'DescribeSnapshotsRequest$Limit' => '<p>The maximum number of objects to return.</p>', 'DescribeTrustsRequest$Limit' => 'The maximum number of objects to return.', 'DirectoryLimits$CloudOnlyDirectoriesLimit' => '<p>The maximum number of cloud directories allowed in the region.</p>', 'DirectoryLimits$CloudOnlyDirectoriesCurrentCount' => '<p>The current number of cloud directories in the region.</p>', 'DirectoryLimits$CloudOnlyMicrosoftADLimit' => 'The maximum number of Microsoft AD directories allowed in the region.', 'DirectoryLimits$CloudOnlyMicrosoftADCurrentCount' => 'The current number of Microsoft AD directories in the region.', 'DirectoryLimits$ConnectedDirectoriesLimit' => '<p>The maximum number of connected directories allowed in the region.</p>', 'DirectoryLimits$ConnectedDirectoriesCurrentCount' => '<p>The current number of connected directories in the region.</p>', 'SnapshotLimits$ManualSnapshotsLimit' => '<p>The maximum number of manual snapshots allowed.</p>', 'SnapshotLimits$ManualSnapshotsCurrentCount' => '<p>The current number of manual snapshots of the directory.</p>', ], ], 'ManualSnapshotsLimitReached' => [ 'base' => NULL, 'refs' => [ 'SnapshotLimits$ManualSnapshotsLimitReached' => '<p>Indicates if the manual snapshot limit has been reached.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeDirectoriesRequest$NextToken' => '<p>The <i>DescribeDirectoriesResult.NextToken</i> value from a previous call to <a>DescribeDirectories</a>. Pass null if this is the first call.</p>', 'DescribeDirectoriesResult$NextToken' => '<p>If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.</p>', 'DescribeSnapshotsRequest$NextToken' => '<p>The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <a>DescribeSnapshots</a>. Pass null if this is the first call.</p>', 'DescribeSnapshotsResult$NextToken' => '<p>If not null, more results are available. Pass this value in the <i>NextToken</i> member of a subsequent call to <a>DescribeSnapshots</a>.</p>', 'DescribeTrustsRequest$NextToken' => '<p>The <i>DescribeTrustsResult.NextToken</i> value from a previous call to <a>DescribeTrusts</a>. Pass null if this is the first call.</p>', 'DescribeTrustsResult$NextToken' => '<p>If not null, more results are available. Pass this value for the <i>NextToken</i> parameter in a subsequent call to <a>DescribeTrusts</a> to retrieve the next set of items.</p>', ], ], 'OrganizationalUnitDN' => [ 'base' => NULL, 'refs' => [ 'CreateComputerRequest$OrganizationalUnitDistinguishedName' => '<p>The fully-qualified distinguished name of the organizational unit to place the computer account in.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryRequest$Password' => '<p>The password for the directory administrator. The directory creation process creates a directory administrator account with the username <code>Administrator</code> and this password.</p>', 'CreateMicrosoftADRequest$Password' => '<p>The password for the default administrative user named <code>Admin</code>.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$RadiusPort' => '<p>The port that your RADIUS server is using for communications. Your on-premises network must allow inbound traffic over this port from the AWS Directory Service servers.</p>', ], ], 'RadiusAuthenticationProtocol' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$AuthenticationProtocol' => '<p>The protocol specified for your RADIUS endpoints.</p>', ], ], 'RadiusDisplayLabel' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$DisplayLabel' => '<p>Not currently used.</p>', ], ], 'RadiusRetries' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$RadiusRetries' => '<p>The maximum number of times that communication with the RADIUS server is attempted. </p>', ], ], 'RadiusSettings' => [ 'base' => '<p>Contains information about a Remote Authentication Dial In User Service (RADIUS] server.</p>', 'refs' => [ 'DirectoryDescription$RadiusSettings' => '<p>A <a>RadiusSettings</a> object that contains information about the RADIUS server configured for this directory.</p>', 'EnableRadiusRequest$RadiusSettings' => '<p>A <a>RadiusSettings</a> object that contains information about the RADIUS server.</p>', 'UpdateRadiusRequest$RadiusSettings' => '<p>A <a>RadiusSettings</a> object that contains information about the RADIUS server.</p>', ], ], 'RadiusSharedSecret' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$SharedSecret' => '<p>The shared secret code that was specified when your RADIUS endpoints were created.</p>', ], ], 'RadiusStatus' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$RadiusStatus' => '<p>The status of the RADIUS MFA server connection.</p>', ], ], 'RadiusTimeout' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$RadiusTimeout' => '<p>The amount of time, in seconds, to wait for the RADIUS server to respond.</p>', ], ], 'RemoteDomainName' => [ 'base' => NULL, 'refs' => [ 'CreateTrustRequest$RemoteDomainName' => 'The Fully Qualified Domain Name (FQDN] of the external domain for which to create the trust relationship.', 'Trust$RemoteDomainName' => 'The Fully Qualified Domain Name (FQDN] of the external domain involved in the trust relationship.', ], ], 'RequestId' => [ 'base' => '<p>The AWS request identifier.</p>', 'refs' => [ 'AuthenticationFailedException$RequestId' => '<p>The identifier of the request that caused the exception.</p>', 'ClientException$RequestId' => NULL, 'DirectoryLimitExceededException$RequestId' => NULL, 'DirectoryUnavailableException$RequestId' => NULL, 'EntityAlreadyExistsException$RequestId' => NULL, 'EntityDoesNotExistException$RequestId' => NULL, 'InsufficientPermissionsException$RequestId' => NULL, 'InvalidNextTokenException$RequestId' => NULL, 'InvalidParameterException$RequestId' => NULL, 'ServiceException$RequestId' => NULL, 'SnapshotLimitExceededException$RequestId' => NULL, 'UnsupportedOperationException$RequestId' => NULL, ], ], 'RestoreFromSnapshotRequest' => [ 'base' => '<p>An object representing the inputs for the <a>RestoreFromSnapshot</a> operation.</p>', 'refs' => [], ], 'RestoreFromSnapshotResult' => [ 'base' => '<p>Contains the results of the <a>RestoreFromSnapshot</a> operation.</p>', 'refs' => [], ], 'SID' => [ 'base' => NULL, 'refs' => [ 'Computer$ComputerId' => '<p>The identifier of the computer.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettingsDescription$SecurityGroupId' => '<p>The security group identifier for the AD Connector directory.</p>', 'DirectoryVpcSettingsDescription$SecurityGroupId' => '<p>The security group identifier for the directory. If the directory was created before 8/1/2014, this is the identifier of the directory members security group that was created when the directory was created. If the directory was created after this date, this value is null.</p>', ], ], 'Server' => [ 'base' => NULL, 'refs' => [ 'Servers$member' => NULL, ], ], 'Servers' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$RadiusServers' => '<p>An array of strings that contains the IP addresses of the RADIUS server endpoints, or the IP addresses of your RADIUS server load balancer.</p>', ], ], 'ServiceException' => [ 'base' => '<p>An exception has occurred in AWS Directory Service.</p>', 'refs' => [], ], 'Snapshot' => [ 'base' => '<p>Describes a directory snapshot.</p>', 'refs' => [ 'Snapshots$member' => NULL, ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotResult$SnapshotId' => '<p>The identifier of the snapshot that was created.</p>', 'DeleteSnapshotRequest$SnapshotId' => '<p>The identifier of the directory snapshot to be deleted.</p>', 'DeleteSnapshotResult$SnapshotId' => '<p>The identifier of the directory snapshot that was deleted.</p>', 'RestoreFromSnapshotRequest$SnapshotId' => '<p>The identifier of the snapshot to restore from.</p>', 'Snapshot$SnapshotId' => '<p>The snapshot identifier.</p>', 'SnapshotIds$member' => NULL, ], ], 'SnapshotIds' => [ 'base' => '<p>A list of directory snapshot identifiers.</p>', 'refs' => [ 'DescribeSnapshotsRequest$SnapshotIds' => '<p>A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.</p>', ], ], 'SnapshotLimitExceededException' => [ 'base' => '<p>The maximum number of manual snapshots for the directory has been reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a directory.</p>', 'refs' => [], ], 'SnapshotLimits' => [ 'base' => '<p>Contains manual snapshot limit information for a directory.</p>', 'refs' => [ 'GetSnapshotLimitsResult$SnapshotLimits' => '<p>A <a>SnapshotLimits</a> object that contains the manual snapshot limits for the specified directory.</p>', ], ], 'SnapshotName' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotRequest$Name' => '<p>The descriptive name to apply to the snapshot.</p>', 'Snapshot$Name' => '<p>The descriptive name of the snapshot.</p>', ], ], 'SnapshotStatus' => [ 'base' => NULL, 'refs' => [ 'Snapshot$Status' => '<p>The snapshot status.</p>', ], ], 'SnapshotType' => [ 'base' => NULL, 'refs' => [ 'Snapshot$Type' => '<p>The snapshot type.</p>', ], ], 'Snapshots' => [ 'base' => '<p>A list of descriptions of directory snapshots.</p>', 'refs' => [ 'DescribeSnapshotsResult$Snapshots' => '<p>The list of <a>Snapshot</a> objects that were retrieved.</p> <p>It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>', ], ], 'SsoEnabled' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$SsoEnabled' => '<p>Indicates if single-sign on is enabled for the directory. For more information, see <a>EnableSso</a> and <a>DisableSso</a>.</p>', ], ], 'StageReason' => [ 'base' => NULL, 'refs' => [ 'DirectoryDescription$StageReason' => '<p>Additional information about the directory stage.</p>', ], ], 'StartTime' => [ 'base' => NULL, 'refs' => [ 'Snapshot$StartTime' => '<p>The date and time that the snapshot was taken.</p>', ], ], 'StateLastUpdatedDateTime' => [ 'base' => NULL, 'refs' => [ 'Trust$StateLastUpdatedDateTime' => 'The date and time that the TrustState was last updated.', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettings$SubnetIds' => '<p>A list of subnet identifiers in the VPC in which the AD Connector is created.</p>', 'DirectoryConnectSettingsDescription$SubnetIds' => '<p>A list of subnet identifiers in the VPC that the AD connector is in.</p>', 'DirectoryVpcSettings$SubnetIds' => '<p>The identifiers of the subnets for the directory servers. The two subnets must be in different Availability Zones. AWS Directory Service creates a directory server and a DNS server in each of these subnets.</p>', 'DirectoryVpcSettingsDescription$SubnetIds' => '<p>The identifiers of the subnets for the directory servers.</p>', ], ], 'Trust' => [ 'base' => 'Describes a trust relationship between an Microsoft AD in the AWS cloud and an external domain.', 'refs' => [ 'Trusts$member' => NULL, ], ], 'TrustDirection' => [ 'base' => NULL, 'refs' => [ 'CreateTrustRequest$TrustDirection' => 'The direction of the trust relationship.', 'Trust$TrustDirection' => 'The trust relationship direction.', ], ], 'TrustId' => [ 'base' => NULL, 'refs' => [ 'CreateTrustResult$TrustId' => 'A unique identifier for the trust relationship that was created.', 'DeleteTrustRequest$TrustId' => 'The Trust ID of the trust relationship to be deleted.', 'DeleteTrustResult$TrustId' => 'The Trust ID of the trust relationship that was deleted.', 'Trust$TrustId' => 'The unique ID of the trust relationship.', 'TrustIds$member' => NULL, 'VerifyTrustRequest$TrustId' => 'The unique Trust ID of the trust relationship to verify.', 'VerifyTrustResult$TrustId' => 'The unique Trust ID of the trust relationship that was verified.', ], ], 'TrustIds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustsRequest$TrustIds' => '<p>A list of identifiers of the trust relationships for which to obtain the information. If this member is null, all trust relationships that belong to the current account are returned.</p> <p>An empty list results in an <code>InvalidParameterException</code> being thrown.</p>', ], ], 'TrustPassword' => [ 'base' => NULL, 'refs' => [ 'CreateTrustRequest$TrustPassword' => 'The trust password. The must be the same password that was used when creating the trust relationship on the external domain.', ], ], 'TrustState' => [ 'base' => NULL, 'refs' => [ 'Trust$TrustState' => 'The trust relationship state.', ], ], 'TrustType' => [ 'base' => NULL, 'refs' => [ 'CreateTrustRequest$TrustType' => 'The trust relationship type.', 'Trust$TrustType' => 'The trust relationship type.', ], ], 'Trusts' => [ 'base' => NULL, 'refs' => [ 'DescribeTrustsResult$Trusts' => '<p>The list of Trust objects that were retrieved.</p> <p>It is possible that this list contains less than the number of items specified in the <i>Limit</i> member of the request. This occurs if there are less than the requested number of items left to retrieve, or if the limitations of the operation have been exceeded.</p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The operation is not supported.</p>', 'refs' => [], ], 'UpdateRadiusRequest' => [ 'base' => '<p>Contains the inputs for the <a>UpdateRadius</a> operation.</p>', 'refs' => [], ], 'UpdateRadiusResult' => [ 'base' => '<p>Contains the results of the <a>UpdateRadius</a> operation.</p>', 'refs' => [], ], 'UseSameUsername' => [ 'base' => NULL, 'refs' => [ 'RadiusSettings$UseSameUsername' => '<p>Not currently used.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettings$CustomerUserName' => '<p>The username of an account in the on-premises directory that is used to connect to the directory. This account must have the following privileges:</p> <ul> <li>Read users and groups</li> <li>Create computer objects</li> <li>Join computers to the domain</li> </ul>', 'DirectoryConnectSettingsDescription$CustomerUserName' => '<p>The username of the service account in the on-premises directory.</p>', 'DisableSsoRequest$UserName' => '<p>The username of an alternate account to use to disable single-sign on. This is only used for AD Connector directories. This account must have privileges to remove a service principal name. </p> <p>If the AD Connector service account does not have privileges to remove a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to disable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>', 'EnableSsoRequest$UserName' => '<p>The username of an alternate account to use to enable single-sign on. This is only used for AD Connector directories. This account must have privileges to add a service principal name. </p> <p>If the AD Connector service account does not have privileges to add a service principal name, you can specify an alternate account with the <i>UserName</i> and <i>Password</i> parameters. These credentials are only used to enable single sign-on and are not stored by the service. The AD Connector service account is not changed.</p>', ], ], 'VerifyTrustRequest' => [ 'base' => 'Initiates the verification of an existing trust relationship between a Microsoft AD in the AWS cloud and an external domain.', 'refs' => [], ], 'VerifyTrustResult' => [ 'base' => NULL, 'refs' => [], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'DirectoryConnectSettings$VpcId' => '<p>The identifier of the VPC in which the AD Connector is created.</p>', 'DirectoryConnectSettingsDescription$VpcId' => '<p>The identifier of the VPC that the AD Connector is in.</p>', 'DirectoryVpcSettings$VpcId' => '<p>The identifier of the VPC in which to create the directory.</p>', 'DirectoryVpcSettingsDescription$VpcId' => '<p>The identifier of the VPC that the directory is in.</p>', ], ], ],];
