<?php
// This file was auto-generated from sdk-root/src/data/marketplacecommerceanalytics/2015-07-01/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'GenerateDataSet' => 'Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be published in comma-separated values (CSV] format with the file name {data_set_type}_YYYY-MM-DD.csv. If a file with the same name already exists (e.g. if the same data set is requested twice], the original file will be overwritten by the new file. Requires a Role with an attached permissions policy providing Allow permissions for the following actions: s3:PutObject, s3:getBucketLocation, sns:SetRegion, sns:ListTopics, sns:Publish, iam:GetRolePolicy.', ], 'shapes' => [ 'DataSetPublicationDate' => [ 'base' => 'The date a data set was published. For daily data sets, provide a date with day-level granularity for the desired day. For weekly data sets, provide a date with day-level granularity within the desired week (the day value will be ignored]. For monthly data sets, provide a date with month-level granularity for the desired month (the day value will be ignored].', 'refs' => [], ], 'DataSetRequestId' => [ 'base' => 'A unique identifier representing a specific request to the GenerateDataSet operation. This identifier can be used to correlate a request with notifications from the SNS topic.', 'refs' => [], ], 'DataSetType' => [ 'base' => 'The type of the data set to publish.', 'refs' => [], ], 'DestinationS3BucketName' => [ 'base' => 'The name (friendly name, not ARN] of the destination S3 bucket.', 'refs' => [], ], 'DestinationS3Prefix' => [ 'base' => '(Optional] The desired S3 prefix for the published data set, similar to a directory path in standard file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3 bucket root.', 'refs' => [], ], 'ExceptionMessage' => [ 'refs' => [], ], 'GenerateDataSetRequest' => [ 'base' => 'Container for the parameters to the GenerateDataSet operation.', 'refs' => [], ], 'GenerateDataSetResult' => [ 'base' => 'Container for the result of the GenerateDataSet operation.', 'refs' => [], ], 'MarketplaceCommerceAnalyticsException' => [ 'base' => 'This exception is thrown when an internal service error occurs.', 'refs' => [], ], 'RoleNameArn' => [ 'base' => 'The Amazon Resource Name (ARN] of the Role with an attached permissions policy to interact with the provided AWS services.', 'refs' => [], ], 'SnsTopicArn' => [ 'base' => 'Amazon Resource Name (ARN] for the SNS Topic that will be notified when the data set has been published or if an error has occurred.', 'refs' => [], ], ], 'service' => 'Provides AWS Marketplace business intelligence data on-demand.',];
