<?php
// This file was auto-generated from sdk-root/src/data/rds/2014-10-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Relational Database Service</fullname> <p> Amazon Relational Database Service (Amazon RDS] is a web service that makes it easier to set up, operate, and scale a relational database in the cloud. It provides cost-efficient, resizeable capacity for an industry-standard relational database and manages common database administration tasks, freeing up developers to focus on what makes their applications and businesses unique. </p> <p> Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL, Microsoft SQL Server, Oracle, or Aurora database server. This means the code, applications, and tools you already use today with your existing databases work with Amazon RDS without modification. Amazon RDS automatically backs up your database and maintains the database software that powers your DB instance. Amazon RDS is flexible: you can scale your database instance\'s compute resources and storage capacity to meet your application\'s demand. As with all Amazon Web Services, there are no up-front investments, and you pay only for the resources you use. </p> <p> This is an interface reference for Amazon RDS. It contains documentation for a programming or command line interface you can use to manage Amazon RDS. Note that Amazon RDS is asynchronous, which means that some interfaces might require techniques such as polling or callback functions to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the maintenance window. For a summary of the Amazon RDS interfaces, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces">Available RDS Interfaces</a>. </p>', 'operations' => [ 'AddSourceIdentifierToSubscription' => '<p>Adds a source identifier to an existing RDS event notification subscription.</p>', 'AddTagsToResource' => '<p> Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.</p> <p>For an overview on tagging Amazon RDS resources, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>.</p>', 'ApplyPendingMaintenanceAction' => '<p>Applies a pending maintenance action to a resource (for example, to a DB instance].</p>', 'AuthorizeDBSecurityGroupIngress' => '<p> Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC]. </p> <note> You cannot authorize ingress from an EC2 security group in one region to an Amazon RDS DB instance in another. You cannot authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another. </note> <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>. </p>', 'CopyDBClusterSnapshot' => '<p>Creates a snapshot of a DB cluster. For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'CopyDBParameterGroup' => '<p> Copies the specified DB parameter group. </p>', 'CopyDBSnapshot' => '<p> Copies the specified DBSnapshot. The source DB snapshot must be in the "available" state. </p> <p>If you are copying from a shared manual DB snapshot, the <code>SourceDBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p>', 'CopyOptionGroup' => '<p>Copies the specified option group. </p>', 'CreateDBCluster' => '<p>Creates a new Amazon Aurora DB cluster. For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'CreateDBClusterParameterGroup' => '<p> Creates a new DB cluster parameter group. </p> <p> Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster. </p> <p> A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using <a>ModifyDBClusterParameterGroup</a>. Once you\'ve created a DB cluster parameter group, you need to associate it with your DB cluster using <a>ModifyDBCluster</a>. When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect. </p> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or modified.</p> </important> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'CreateDBClusterSnapshot' => '<p>Creates a snapshot of a DB cluster. For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'CreateDBInstance' => '<p> Creates a new DB instance. </p>', 'CreateDBInstanceReadReplica' => '<p> Creates a DB instance for a DB instance running MySQL, MariaDB, or PostgreSQL that acts as a Read Replica of a source DB instance. </p> <p> All Read Replica DB instances are created as Single-AZ deployments with backups disabled. All other DB instance attributes (including DB security groups and DB parameter groups] are inherited from the source DB instance, except as specified below. </p> <important> <p> The source DB instance must have backup retention enabled. </p> </important>', 'CreateDBParameterGroup' => '<p> Creates a new DB parameter group. </p> <p> A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using <i>ModifyDBParameterGroup</i>. Once you\'ve created a DB parameter group, you need to associate it with your DB instance using <i>ModifyDBInstance</i>. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect. </p> <important> <p>After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'CreateDBSecurityGroup' => '<p> Creates a new DB security group. DB security groups control access to a DB instance. </p>', 'CreateDBSnapshot' => '<p> Creates a DBSnapshot. The source DBInstance must be in "available" state. </p>', 'CreateDBSubnetGroup' => '<p> Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the region. </p>', 'CreateEventSubscription' => '<p>Creates an RDS event notification subscription. This action requires a topic ARN (Amazon Resource Name] created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p> <p>You can specify the type of source (SourceType] you want to be notified of, provide a list of RDS sources (SourceIds] that triggers the events, and provide a list of event categories (EventCategories] for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.</p> <p>If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you will be notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you will receive notice of the events for that source type for all your RDS sources. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all RDS sources belonging to your customer account.</p>', 'CreateOptionGroup' => '<p> Creates a new option group. You can create up to 20 option groups. </p>', 'DeleteDBCluster' => '<p>The DeleteDBCluster action deletes a previously provisioned DB cluster. A successful response from the web service indicates the request was received correctly. When you delete a DB cluster, all automated backups for that DB cluster are deleted and cannot be recovered. Manual DB cluster snapshots of the DB cluster to be deleted are not deleted. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DeleteDBClusterParameterGroup' => '<p> Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted cannot be associated with any DB clusters. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DeleteDBClusterSnapshot' => '<p>Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated. </p> <note>The DB cluster snapshot must be in the <code>available</code> state to be deleted.</note> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DeleteDBInstance' => '<p> The DeleteDBInstance action deletes a previously provisioned DB instance. A successful response from the web service indicates the request was received correctly. When you delete a DB instance, all automated backups for that instance are deleted and cannot be recovered. Manual DB snapshots of the DB instance to be deleted are not deleted. </p> <p> If a final DB snapshot is requested the status of the RDS instance will be "deleting" until the DB snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this operation. The action cannot be canceled or reverted once submitted. </p> <p>Note that when a DB instance is in a failure state and has a status of \'failed\', \'incompatible-restore\', or \'incompatible-network\', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p>', 'DeleteDBParameterGroup' => '<p> Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted cannot be associated with any DB instances. </p>', 'DeleteDBSecurityGroup' => '<p> Deletes a DB security group. </p> <note>The specified DB security group must not be associated with any DB instances.</note>', 'DeleteDBSnapshot' => '<p> Deletes a DBSnapshot. If the snapshot is being copied, the copy operation is terminated. </p> <note>The DBSnapshot must be in the <code>available</code> state to be deleted.</note>', 'DeleteDBSubnetGroup' => '<p> Deletes a DB subnet group. </p> <note>The specified database subnet group must not be associated with any DB instances.</note>', 'DeleteEventSubscription' => '<p>Deletes an RDS event notification subscription.</p>', 'DeleteOptionGroup' => '<p> Deletes an existing option group. </p>', 'DescribeAccountAttributes' => '<p>Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota\'s maximum value. </p> <p>This command does not take any parameters.</p>', 'DescribeCertificates' => '<p> Lists the set of CA certificates provided by Amazon RDS for this AWS account. </p>', 'DescribeDBClusterParameterGroups' => '<p> Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of the specified DB cluster parameter group. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DescribeDBClusterParameters' => '<p> Returns the detailed parameter list for a particular DB cluster parameter group. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DescribeDBClusterSnapshots' => '<p>Returns information about DB cluster snapshots. This API supports pagination. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DescribeDBClusters' => '<p>Returns information about provisioned Aurora DB clusters. This API supports pagination. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DescribeDBEngineVersions' => '<p> Returns a list of the available DB engines. </p>', 'DescribeDBInstances' => '<p> Returns information about provisioned RDS instances. This API supports pagination. </p>', 'DescribeDBLogFiles' => '<p> Returns a list of DB log files for the DB instance. </p>', 'DescribeDBParameterGroups' => '<p> Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is specified, the list will contain only the description of the specified DB parameter group. </p>', 'DescribeDBParameters' => '<p> Returns the detailed parameter list for a particular DB parameter group. </p>', 'DescribeDBSecurityGroups' => '<p> Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified, the list will contain only the descriptions of the specified DB security group. </p>', 'DescribeDBSnapshotAttributes' => '<p>Returns a list of DB snapshot attribute names and values for a manual DB snapshot.</p> <p>When sharing snapshots with other AWS accounts, <code>DescribeDBSnapshotAttributes</code> returns the <code>restore</code> attribute and a list of the AWS account ids that are authorized to copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all AWS accounts.</p> <p>To add or remove access for an AWS account to copy or restore a manual DB snapshot, or to make the manual DB snapshot public or private, use the <a>ModifyDBSnapshotAttribute</a> API.</p>', 'DescribeDBSnapshots' => '<p> Returns information about DB snapshots. This API supports pagination. </p>', 'DescribeDBSubnetGroups' => '<p> Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup. </p> <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>. </p>', 'DescribeEngineDefaultClusterParameters' => '<p> Returns the default engine and system parameter information for the cluster database engine. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'DescribeEngineDefaultParameters' => '<p> Returns the default engine and system parameter information for the specified database engine. </p>', 'DescribeEventCategories' => '<p>Displays a list of categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in the <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html"> Events</a> topic in the <i>Amazon RDS User Guide.</i></p>', 'DescribeEventSubscriptions' => '<p>Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status. </p> <p>If you specify a SubscriptionName, lists the description for that subscription.</p>', 'DescribeEvents' => '<p> Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned. </p>', 'DescribeOptionGroupOptions' => '<p> Describes all available options. </p>', 'DescribeOptionGroups' => '<p> Describes the available option groups. </p>', 'DescribeOrderableDBInstanceOptions' => '<p> Returns a list of orderable DB instance options for the specified engine. </p>', 'DescribePendingMaintenanceActions' => '<p>Returns a list of resources (for example, DB instances] that have at least one pending maintenance action.</p>', 'DescribeReservedDBInstances' => '<p> Returns information about reserved DB instances for this account, or about a specified reserved DB instance. </p>', 'DescribeReservedDBInstancesOfferings' => '<p> Lists available reserved DB instance offerings. </p>', 'DownloadDBLogFilePortion' => '<p> Downloads all or a portion of the specified log file, up to 1 MB in size. </p>', 'FailoverDBCluster' => '<p>Forces a failover for a DB cluster.</p> <p>A failover for a DB cluster promotes one of the read-only instances in the DB cluster to the master DB instance (the cluster writer] and deletes the current primary instance.</p> <p>Amazon Aurora will automatically fail over to a read-only instance, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a DB instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.</p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'ListTagsForResource' => '<p> Lists all tags on an Amazon RDS resource.</p> <p>For an overview on tagging an Amazon RDS resource, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>.</p>', 'ModifyDBCluster' => '<p>Modify a setting for an Amazon Aurora DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'ModifyDBClusterParameterGroup' => '<p> Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p> <note> <p> Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect. </p> </note> <important> <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <a>DescribeDBClusterParameters</a> command to verify that your DB cluster parameter group has been created or modified.</p> </important>', 'ModifyDBInstance' => '<p> Modify settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. </p>', 'ModifyDBParameterGroup' => '<p> Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request. </p> <note> <p> Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect. </p> </note> <important> <p>After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.</p> </important>', 'ModifyDBSnapshotAttribute' => '<p>Adds an attribute and values to, or removes an attribute and values from a manual DB snapshot.</p> <p>To share a manual DB snapshot with other AWS accounts, specify <code>restore</code> as the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of the AWS account ids that are authorized to retore the manual DB snapshot. Uses the value <code>all</code> to make the manual DB snapshot public and can by copied or restored by all AWS accounts. Do not add the <code>all</code> value for any manual DB snapshots that contain private information that you do not want to be available to all AWS accounts.</p> <p>To view which AWS accounts have access to copy or restore a manual DB snapshot, or whether a manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API.</p> <p>If the manual DB snapshot is encrypted, it cannot be shared.</p>', 'ModifyDBSubnetGroup' => '<p> Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the region. </p>', 'ModifyEventSubscription' => '<p>Modifies an existing RDS event notification subscription. Note that you cannot modify the source identifiers using this call; to change source identifiers for a subscription, use the <a>AddSourceIdentifierToSubscription</a> and <a>RemoveSourceIdentifierFromSubscription</a> calls.</p> <p>You can see a list of the event categories for a given SourceType in the <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <b>DescribeEventCategories</b> action.</p>', 'ModifyOptionGroup' => '<p> Modifies an existing option group. </p>', 'PromoteReadReplica' => '<p> Promotes a Read Replica DB instance to a standalone DB instance. </p> <note> <p>We recommend that you enable automated backups on your Read Replica before promoting the Read Replica. This ensures that no backup is taken during the promotion process. Once the instance is promoted to a primary instance, backups are taken based on your backup settings.</p> </note>', 'PurchaseReservedDBInstancesOffering' => '<p> Purchases a reserved DB instance offering. </p>', 'RebootDBInstance' => '<p> Rebooting a DB instance restarts the database engine service. A reboot also applies to the DB instance any modifications to the associated DB parameter group that were pending. Rebooting a DB instance results in a momentary outage of the instance, during which the DB instance status is set to rebooting. If the RDS instance is configured for MultiAZ, it is possible that the reboot will be conducted through a failover. An Amazon RDS event is created when the reboot is completed. </p> <p> If your DB instance is deployed in multiple Availability Zones, you can force a failover from one AZ to the other during the reboot. You might force a failover to test the availability of your DB instance deployment or to restore operations to the original AZ after a failover occurs. </p> <p> The time required to reboot is a function of the specific database engine\'s crash recovery process. To improve the reboot time, we recommend that you reduce database activities as much as possible during the reboot process to reduce rollback activity for in-transit transactions. </p>', 'RemoveSourceIdentifierFromSubscription' => '<p>Removes a source identifier from an existing RDS event notification subscription.</p>', 'RemoveTagsFromResource' => '<p> Removes metadata tags from an Amazon RDS resource.</p> <p>For an overview on tagging an Amazon RDS resource, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>.</p>', 'ResetDBClusterParameterGroup' => '<p> Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB cluster parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code> parameters. </p> <p> When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <a>RebootDBInstance</a> request. You must call <a>RebootDBInstance</a> for every DB instance in your DB cluster that you want the updated static parameter to apply to.</p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'ResetDBParameterGroup' => '<p> Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters submit a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to <code>pending-reboot</code> to take effect on the next DB instance restart or <code>RebootDBInstance</code> request. </p>', 'RestoreDBClusterFromSnapshot' => '<p>Creates a new DB cluster from a DB cluster snapshot. The target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'RestoreDBClusterToPointInTime' => '<p> Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group. </p> <p>For more information on Amazon Aurora, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html">Aurora on Amazon RDS</a> in the <i>Amazon RDS User Guide.</i></p>', 'RestoreDBInstanceFromDBSnapshot' => '<p>Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with the most of original configuration, but in a system chosen availability zone with the default security group, the default subnet group, and the default DB parameter group. By default, the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that has an option group that is associated with mirroring; in this case, the instance becomes a mirrored AZ deployment and not a single-AZ deployment. </p> <p>If your intent is to replace your original DB instance with the new, restored DB instance, then rename your original DB instance before you call the RestoreDBInstanceFromDBSnapshot action. RDS does not allow two DB instances with the same name. Once you have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as the DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot action. The result is that you will replace the original DB instance with the DB instance created from the snapshot.</p> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p>', 'RestoreDBInstanceToPointInTime' => '<p> Restores a DB instance to an arbitrary point-in-time. Users can restore to any point in time before the LatestRestorableTime for up to BackupRetentionPeriod days. The target database is created with the most of original configuration, but in a system chosen availability zone with the default security group, the default subnet group, and the default DB parameter group. By default, the new DB instance is created as a single-AZ deployment except when the instance is a SQL Server instance that has an option group that is associated with mirroring; in this case, the instance becomes a mirrored deployment and not a single-AZ deployment. </p>', 'RevokeDBSecurityGroupIngress' => '<p> Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC Security Groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId]. </p>', ], 'shapes' => [ 'AccountAttributesMessage' => [ 'base' => '<p>Data returned by the <b>DescribeAccountAttributes</b> action.</p>', 'refs' => [], ], 'AccountQuota' => [ 'base' => '<p>Describes a quota for an AWS account, for example, the number of DB instances allowed.</p>', 'refs' => [ 'AccountQuotaList$member' => NULL, ], ], 'AccountQuotaList' => [ 'base' => NULL, 'refs' => [ 'AccountAttributesMessage$AccountQuotas' => '<p>A list of <a>AccountQuota</a> objects. Within this list, each quota has a name, a count of usage toward the quota maximum, and a maximum value for the quota.</p>', ], ], 'AddSourceIdentifierToSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AddSourceIdentifierToSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyMethod' => [ 'base' => NULL, 'refs' => [ 'Parameter$ApplyMethod' => '<p> Indicates when to apply parameter updates. </p>', ], ], 'ApplyPendingMaintenanceActionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ApplyPendingMaintenanceActionResult' => [ 'base' => NULL, 'refs' => [], ], 'AttributeValueList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotAttribute$AttributeValues' => '<p>The value(s] for the manual DB snapshot attribute.</p> <p>If the <code>AttributeName</code> field is <code>restore</code>, then this field returns a list of AWS account ids that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any AWS account to copy or restore.</p>', 'ModifyDBSnapshotAttributeMessage$ValuesToAdd' => '<p>A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p> <p>To authorize other AWS Accounts to copy or restore a manual snapshot, this is one or more AWS account identifiers, or <code>all</code> to make the manual DB snapshot restorable by any AWS account. Do not add the <code>all</code> value for any manual DB snapshots that contain private information that you do not want to be available to all AWS accounts.</p>', 'ModifyDBSnapshotAttributeMessage$ValuesToRemove' => '<p>A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p> <p>To remove authorization for other AWS Accounts to copy or restore a manual snapshot, this is one or more AWS account identifiers, or <code>all</code> to remove authorization for any AWS account to copy or restore the DB snapshot. If you specify <code>all</code>, AWS accounts that have their account identifier explicitly added to the <code>restore</code> attribute can still copy or restore the manual DB snapshot.</p>', ], ], 'AuthorizationAlreadyExistsFault' => [ 'base' => '<p> The specified CIDRIP or EC2 security group is already authorized for the specified DB security group. </p>', 'refs' => [], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p> Specified CIDRIP or EC2 security group is not authorized for the specified DB security group. </p> <p>RDS may not also be authorized via IAM to perform necessary actions on your behalf.</p>', 'refs' => [], ], 'AuthorizationQuotaExceededFault' => [ 'base' => '<p> DB security group authorization quota has been reached. </p>', 'refs' => [], ], 'AuthorizeDBSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'AuthorizeDBSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AvailabilityZone' => [ 'base' => '<p> Contains Availability Zone information. </p> <p> This data type is used as an element in the following data type: <ul><li><a>OrderableDBInstanceOption</a></li></ul></p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, 'Subnet$SubnetAvailabilityZone' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOption$AvailabilityZones' => '<p> A list of Availability Zones for the orderable DB instance. </p>', ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$AvailabilityZones' => '<p>A list of EC2 Availability Zones that instances in the DB cluster can be created in. For information on regions and Availability Zones, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>. </p>', 'DBCluster$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.</p>', 'DBClusterSnapshot$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.</p>', 'RestoreDBClusterFromSnapshotMessage$AvailabilityZones' => '<p>Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DBCluster$StorageEncrypted' => '<p>Specifies whether the DB cluster is encrypted.</p>', 'DBClusterMember$IsClusterWriter' => '<p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>', 'DBClusterSnapshot$StorageEncrypted' => '<p>Specifies whether the DB cluster snapshot is encrypted.</p>', 'DBInstance$MultiAZ' => '<p> Specifies if the DB instance is a Multi-AZ deployment. </p>', 'DBInstance$AutoMinorVersionUpgrade' => '<p> Indicates that minor version patches are applied automatically. </p>', 'DBInstance$PubliclyAccessible' => '<p> Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p> <p> Default: The default behavior varies depending on whether a VPC has been requested or not. The following list shows the default behavior in each case. </p> <ul> <li> <b>Default VPC:</b>true</li> <li> <b>VPC:</b>false</li> </ul> <p> If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be private. </p>', 'DBInstance$StorageEncrypted' => '<p> Specifies whether the DB instance is encrypted. </p>', 'DBInstance$CopyTagsToSnapshot' => '<p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>', 'DBInstanceStatusInfo$Normal' => '<p> Boolean value that is true if the instance is operating normally, or false if the instance is in an error state. </p>', 'DBSnapshot$Encrypted' => '<p> Specifies whether the DB snapshot is encrypted. </p>', 'DeleteDBClusterMessage$SkipFinalSnapshot' => '<p> Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If <code>true</code> is specified, no DB cluster snapshot is created. If <code>false</code> is specified, a DB cluster snapshot is created before the DB cluster is deleted. </p> <note>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is <code>false</code>.</note> <p>Default: <code>false</code></p>', 'DeleteDBInstanceMessage$SkipFinalSnapshot' => '<p> Determines whether a final DB snapshot is created before the DB instance is deleted. If <code>true</code> is specified, no DBSnapshot is created. If <code>false</code> is specified, a DB snapshot is created before the DB instance is deleted. </p> <p>Note that when a DB instance is in a failure state and has a status of \'failed\', \'incompatible-restore\', or \'incompatible-network\', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".</p> <p>Specify <code>true</code> when deleting a Read Replica.</p> <note>The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is <code>false</code>.</note> <p>Default: <code>false</code></p>', 'DescribeDBEngineVersionsMessage$DefaultOnly' => '<p> Indicates that only the default version of the specified engine or engine and major version combination is returned. </p>', 'DescribeDBSnapshotsMessage$IncludeShared' => '<p>True to include shared manual DB snapshots from other AWS accounts that this AWS account has been given permission to copy or restore; otherwise false. The default is false.</p> <p>An AWS account is given permission to restore a manual DB snapshot from another AWS account by the <a>ModifyDBSnapshotAttribute</a> API.</p>', 'DescribeDBSnapshotsMessage$IncludePublic' => '<p>True to include manual DB snapshots that are public and can be copied or restored by any AWS account; otherwise false. The default is false.</p> <p>An manual DB snapshot is shared as public by the <a>ModifyDBSnapshotAttribute</a> API.</p>', 'DownloadDBLogFilePortionDetails$AdditionalDataPending' => '<p> Boolean value that if true, indicates there is more data to be downloaded. </p>', 'EventSubscription$Enabled' => '<p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>', 'ModifyDBClusterMessage$ApplyImmediately' => '<p>A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. </p> <p>If this parameter is set to <code>false</code>, changes to the DB cluster are applied during the next maintenance window.</p> <p>Default: <code>false</code></p>', 'ModifyDBInstanceMessage$ApplyImmediately' => '<p>Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance. </p> <p> If this parameter is set to <code>false</code>, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and will be applied on the next call to <a>RebootDBInstance</a>, or the next failure reboot. Review the table of parameters in <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance and Using the Apply Immediately Parameter</a> to see the impact that setting <code>ApplyImmediately</code> to <code>true</code> or <code>false</code> has for each modified parameter and to determine when the changes will be applied. </p> <p>Default: <code>false</code></p>', 'ModifyDBInstanceMessage$AllowMajorVersionUpgrade' => '<p> Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage and the change is asynchronously applied as soon as possible. </p> <p>Constraints: This parameter must be set to true when specifying a value for the EngineVersion parameter that is a different major version than the DB instance\'s current version.</p>', 'ModifyOptionGroupMessage$ApplyImmediately' => '<p> Indicates whether the changes should be applied immediately, or during the next maintenance window for each instance associated with the option group. </p>', 'Option$Persistent' => '<p> Indicate if this option is persistent. </p>', 'Option$Permanent' => '<p>Indicate if this option is permanent.</p>', 'OptionGroup$AllowsVpcAndNonVpcInstanceMemberships' => '<p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>', 'OptionGroupOption$PortRequired' => '<p> Specifies whether the option requires a port. </p>', 'OptionGroupOption$Persistent' => '<p> A persistent option cannot be removed from the option group once the option group is used, but this option can be removed from the db instance while modifying the related data and assigning another option group without this option. </p>', 'OptionGroupOption$Permanent' => '<p> A permanent option cannot be removed from the option group once the option group is used, and it cannot be removed from the db instance after assigning an option group with this permanent option. </p>', 'OptionGroupOptionSetting$IsModifiable' => '<p> Boolean value where true indicates that this option group option can be changed from the default value. </p>', 'OptionSetting$IsModifiable' => '<p> A Boolean value that, when true, indicates the option setting can be modified from the default. </p>', 'OptionSetting$IsCollection' => '<p> Indicates if the option setting is part of a collection. </p>', 'OrderableDBInstanceOption$MultiAZCapable' => '<p> Indicates whether this orderable DB instance is multi-AZ capable. </p>', 'OrderableDBInstanceOption$ReadReplicaCapable' => '<p> Indicates whether this orderable DB instance can have a Read Replica. </p>', 'OrderableDBInstanceOption$Vpc' => '<p> Indicates whether this is a VPC orderable DB instance. </p>', 'OrderableDBInstanceOption$SupportsStorageEncryption' => '<p> Indicates whether this orderable DB instance supports encrypted storage. </p>', 'OrderableDBInstanceOption$SupportsIops' => '<p> Indicates whether this orderable DB instance supports provisioned IOPS. </p>', 'OrderableDBInstanceOption$SupportsEnhancedMonitoring' => '<p>Indicates whether the DB instance supports enhanced monitoring at intervals from 1 to 60 seconds.</p>', 'Parameter$IsModifiable' => '<p> Indicates whether (<code>true</code>] or not (<code>false</code>] the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>', 'ReservedDBInstance$MultiAZ' => '<p> Indicates if the reservation applies to Multi-AZ deployments. </p>', 'ReservedDBInstancesOffering$MultiAZ' => '<p> Indicates if the offering applies to Multi-AZ deployments. </p>', 'ResetDBClusterParameterGroupMessage$ResetAllParameters' => '<p>A value that is set to <code>true</code> to reset all parameters in the DB cluster parameter group to their default values, and <code>false</code> otherwise. You cannot use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>', 'ResetDBParameterGroupMessage$ResetAllParameters' => '<p> Specifies whether (<code>true</code>] or not (<code>false</code>] to reset all parameters in the DB parameter group to default values. </p> <p>Default: <code>true</code></p>', 'RestoreDBClusterToPointInTimeMessage$UseLatestRestorableTime' => '<p>A value that is set to <code>true</code> to restore the DB cluster to the latest restorable backup time, and <code>false</code> otherwise. </p> <p>Default: <code>false</code></p> <p>Constraints: Cannot be specified if <code>RestoreToTime</code> parameter is provided.</p>', 'RestoreDBInstanceToPointInTimeMessage$UseLatestRestorableTime' => '<p> Specifies whether (<code>true</code>] or not (<code>false</code>] the DB instance is restored from the latest backup time. </p> <p>Default: <code>false</code></p> <p>Constraints: Cannot be specified if RestoreTime parameter is provided.</p>', 'UpgradeTarget$AutoUpgrade' => '<p>A value that indicates whether the target version will be applied to any source DB instances that have AutoMinorVersionUpgrade set to true.</p>', 'UpgradeTarget$IsMajorVersionUpgrade' => '<p>A value that indicates whether a database engine will be upgraded to a major version.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CopyDBSnapshotMessage$CopyTags' => '<p>True to copy all tags from the source DB snapshot to the target DB snapshot; otherwise false. The default is false.</p>', 'CreateDBClusterMessage$StorageEncrypted' => '<p>Specifies whether the DB cluster is encrypted.</p>', 'CreateDBInstanceMessage$MultiAZ' => '<p> Specifies if the DB instance is a Multi-AZ deployment. You cannot set the AvailabilityZone parameter if the MultiAZ parameter is set to true. Do not set this value if you want a Multi-AZ deployment for a SQL Server DB instance. Multi-AZ for SQL Server is set using the Mirroring option in an option group. </p>', 'CreateDBInstanceMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. </p> <p>Default: <code>true</code></p>', 'CreateDBInstanceMessage$PubliclyAccessible' => '<p> Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p> <p> Default: The default behavior varies depending on whether a VPC has been requested or not. The following list shows the default behavior in each case. </p> <ul> <li> <b>Default VPC:</b> true</li> <li> <b>VPC:</b> false</li> </ul> <p> If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be private. </p>', 'CreateDBInstanceMessage$StorageEncrypted' => '<p> Specifies whether the DB instance is encrypted. </p> <p> Default: false </p>', 'CreateDBInstanceMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the DB instance to snapshots of the DB instance; otherwise false. The default is false.</p>', 'CreateDBInstanceReadReplicaMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor engine upgrades will be applied automatically to the Read Replica during the maintenance window. </p> <p>Default: Inherits from the source DB instance</p>', 'CreateDBInstanceReadReplicaMessage$PubliclyAccessible' => '<p> Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p> <p> Default: The default behavior varies depending on whether a VPC has been requested or not. The following list shows the default behavior in each case. </p> <ul> <li> <b>Default VPC:</b>true</li> <li> <b>VPC:</b>false</li> </ul> <p> If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be private. </p>', 'CreateDBInstanceReadReplicaMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the Read Replica to snapshots of the Read Replica; otherwise false. The default is false.</p>', 'CreateEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <b>true</b> to activate the subscription, set to <b>false</b> to create the subscription but not active it. </p>', 'DescribeDBEngineVersionsMessage$ListSupportedCharacterSets' => '<p> If this parameter is specified, and if the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version. </p>', 'DescribeOrderableDBInstanceOptionsMessage$Vpc' => '<p> The VPC filter value. Specify this parameter to show only the available VPC or non-VPC offerings. </p>', 'DescribeReservedDBInstancesMessage$MultiAZ' => '<p> The Multi-AZ filter value. Specify this parameter to show only those reservations matching the specified Multi-AZ parameter. </p>', 'DescribeReservedDBInstancesOfferingsMessage$MultiAZ' => '<p> The Multi-AZ filter value. Specify this parameter to show only the available offerings matching the specified Multi-AZ parameter. </p>', 'ModifyDBInstanceMessage$MultiAZ' => '<p> Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter does not result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. </p> <p>Constraints: Cannot be specified if the DB instance is a Read Replica. This parameter cannot be used with SQL Server DB instances. Multi-AZ for SQL Server DB instances is set using the Mirroring option in an option group associated with the DB instance.</p>', 'ModifyDBInstanceMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor version upgrades will be applied automatically to the DB instance during the maintenance window. Changing this parameter does not result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to <code>true</code> during the maintenance window, and a newer minor version is available, and RDS has enabled auto patching for that engine version. </p>', 'ModifyDBInstanceMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the DB instance to snapshots of the DB instance; otherwise false. The default is false.</p>', 'ModifyDBInstanceMessage$PubliclyAccessible' => '<p>True to make the DB instance Internet-facing with a publicly resolvable DNS name, which resolves to a public IP address. False to make the DB instance internal with a DNS name that resolves to a private IP address. </p> <p><code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a public subnet and <code>PubliclyAccessible</code> must be true in order for it to be publicly accessible. </p> <p>Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p> Default: false </p>', 'ModifyEventSubscriptionMessage$Enabled' => '<p> A Boolean value; set to <b>true</b> to activate the subscription. </p>', 'PendingModifiedValues$MultiAZ' => '<p> Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment. </p>', 'RebootDBInstanceMessage$ForceFailover' => '<p> When <code>true</code>, the reboot will be conducted through a MultiAZ failover. </p> <p>Constraint: You cannot specify <code>true</code> if the instance is not configured for MultiAZ.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$MultiAZ' => '<p> Specifies if the DB instance is a Multi-AZ deployment. </p> <p>Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ parameter is set to <code>true</code>.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$PubliclyAccessible' => '<p> Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p> <p> Default: The default behavior varies depending on whether a VPC has been requested or not. The following list shows the default behavior in each case. </p> <ul> <li> <b>Default VPC:</b> true</li> <li> <b>VPC:</b> false</li> </ul> <p> If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be private. </p>', 'RestoreDBInstanceFromDBSnapshotMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor version upgrades will be applied automatically to the DB instance during the maintenance window. </p>', 'RestoreDBInstanceFromDBSnapshotMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the restored DB instance to snapshots of the DB instance; otherwise false. The default is false.</p>', 'RestoreDBInstanceToPointInTimeMessage$MultiAZ' => '<p> Specifies if the DB instance is a Multi-AZ deployment. </p> <p>Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ parameter is set to <code>true</code>.</p>', 'RestoreDBInstanceToPointInTimeMessage$PubliclyAccessible' => '<p> Specifies the accessibility options for the DB instance. A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address. A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p> <p> Default: The default behavior varies depending on whether a VPC has been requested or not. The following list shows the default behavior in each case. </p> <ul> <li> <b>Default VPC:</b>true</li> <li> <b>VPC:</b>false</li> </ul> <p> If no DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be publicly accessible. If a specific DB subnet group has been specified as part of the request and the PubliclyAccessible value has not been set, the DB instance will be private. </p>', 'RestoreDBInstanceToPointInTimeMessage$AutoMinorVersionUpgrade' => '<p> Indicates that minor version upgrades will be applied automatically to the DB instance during the maintenance window. </p>', 'RestoreDBInstanceToPointInTimeMessage$CopyTagsToSnapshot' => '<p>True to copy all tags from the restored DB instance to snapshots of the DB instance; otherwise false. The default is false.</p>', ], ], 'Certificate' => [ 'base' => '<p>A CA certificate for an AWS account. </p>', 'refs' => [ 'CertificateList$member' => NULL, ], ], 'CertificateList' => [ 'base' => NULL, 'refs' => [ 'CertificateMessage$Certificates' => '<p>The list of <a>Certificate</a> objects for the AWS account.</p>', ], ], 'CertificateMessage' => [ 'base' => '<p>Data returned by the <b>DescribeCertificates</b> action.</p>', 'refs' => [], ], 'CertificateNotFoundFault' => [ 'base' => '<p><i>CertificateIdentifier</i> does not refer to an existing certificate. </p>', 'refs' => [], ], 'CharacterSet' => [ 'base' => '<p> This data type is used as a response element in the action <a>DescribeDBEngineVersions</a>. </p>', 'refs' => [ 'DBEngineVersion$DefaultCharacterSet' => '<p> The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API is not specified. </p>', 'SupportedCharacterSetsList$member' => NULL, ], ], 'CopyDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CopyOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBInstanceReadReplicaMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceReadReplicaResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'CreateOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DBCluster' => [ 'base' => '<p>Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>CreateDBCluster</a> </li> <li> <a>DeleteDBCluster</a> </li> <li> <a>FailoverDBCluster</a> </li> <li> <a>ModifyDBCluster</a> </li> <li> <a>RestoreDBClusterFromSnapshot</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBClusters</a> action.</p>', 'refs' => [ 'CreateDBClusterResult$DBCluster' => NULL, 'DBClusterList$member' => NULL, 'DeleteDBClusterResult$DBCluster' => NULL, 'FailoverDBClusterResult$DBCluster' => NULL, 'ModifyDBClusterResult$DBCluster' => NULL, 'RestoreDBClusterFromSnapshotResult$DBCluster' => NULL, 'RestoreDBClusterToPointInTimeResult$DBCluster' => NULL, ], ], 'DBClusterAlreadyExistsFault' => [ 'base' => '<p>User already has a DB cluster with the given identifier. </p>', 'refs' => [], ], 'DBClusterList' => [ 'base' => NULL, 'refs' => [ 'DBClusterMessage$DBClusters' => '<p>Contains a list of DB clusters for the user.</p>', ], ], 'DBClusterMember' => [ 'base' => '<p>Contains information about an instance that is part of a DB cluster.</p>', 'refs' => [ 'DBClusterMemberList$member' => NULL, ], ], 'DBClusterMemberList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterMembers' => '<p>Provides the list of instances that make up the DB cluster.</p>', ], ], 'DBClusterMessage' => [ 'base' => '<p>Contains the result of a successful invocation of the <a>DescribeDBClusters</a> action.</p>', 'refs' => [], ], 'DBClusterNotFoundFault' => [ 'base' => '<p><i>DBClusterIdentifier</i> does not refer to an existing DB cluster. </p>', 'refs' => [], ], 'DBClusterOptionGroupMemberships' => [ 'base' => NULL, 'refs' => [ 'DBCluster$DBClusterOptionGroupMemberships' => '<p> Provides the list of option group memberships for this DB cluster. </p>', ], ], 'DBClusterOptionGroupStatus' => [ 'base' => '<p>Contains status information for a DB cluster option group.</p>', 'refs' => [ 'DBClusterOptionGroupMemberships$member' => NULL, ], ], 'DBClusterParameterGroup' => [ 'base' => '<p>Contains the result of a successful invocation of the <a>CreateDBClusterParameterGroup</a> action. </p> <p>This data type is used as a request parameter in the <a>DeleteDBClusterParameterGroup</a> action, and as a response element in the <a>DescribeDBClusterParameterGroups</a> action. </p>', 'refs' => [ 'CreateDBClusterParameterGroupResult$DBClusterParameterGroup' => NULL, 'DBClusterParameterGroupList$member' => NULL, ], ], 'DBClusterParameterGroupDetails' => [ 'base' => '<p>Provides details about a DB cluster parameter group including the parameters in the DB cluster parameter group.</p>', 'refs' => [], ], 'DBClusterParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupsMessage$DBClusterParameterGroups' => '<p>A list of DB cluster parameter groups.</p>', ], ], 'DBClusterParameterGroupNameMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DBClusterParameterGroupNotFoundFault' => [ 'base' => '<p> <i>DBClusterParameterGroupName</i> does not refer to an existing DB Cluster parameter group. </p>', 'refs' => [], ], 'DBClusterParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DBClusterQuotaExceededFault' => [ 'base' => '<p>User attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota. </p>', 'refs' => [], ], 'DBClusterSnapshot' => [ 'base' => '<p>Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>CreateDBClusterSnapshot</a> </li> <li> <a>DeleteDBClusterSnapshot</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBClusterSnapshots</a> action.</p>', 'refs' => [ 'CopyDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'CreateDBClusterSnapshotResult$DBClusterSnapshot' => NULL, 'DBClusterSnapshotList$member' => NULL, 'DeleteDBClusterSnapshotResult$DBClusterSnapshot' => NULL, ], ], 'DBClusterSnapshotAlreadyExistsFault' => [ 'base' => '<p>User already has a DB cluster snapshot with the given identifier. </p>', 'refs' => [], ], 'DBClusterSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshotMessage$DBClusterSnapshots' => '<p> Provides a list of DB cluster snapshots for the user. </p>', ], ], 'DBClusterSnapshotMessage' => [ 'base' => '<p> Provides a list of DB cluster snapshots for the user as the result of a call to the <a>DescribeDBClusterSnapshots</a> action. </p>', 'refs' => [], ], 'DBClusterSnapshotNotFoundFault' => [ 'base' => '<p><i>DBClusterSnapshotIdentifier</i> does not refer to an existing DB cluster snapshot. </p>', 'refs' => [], ], 'DBEngineVersion' => [ 'base' => '<p> This data type is used as a response element in the action <a>DescribeDBEngineVersions</a>. </p>', 'refs' => [ 'DBEngineVersionList$member' => NULL, ], ], 'DBEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersionMessage$DBEngineVersions' => '<p> A list of <code>DBEngineVersion</code> elements. </p>', ], ], 'DBEngineVersionMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBEngineVersions</a> action. </p>', 'refs' => [], ], 'DBInstance' => [ 'base' => '<p> Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>CreateDBInstance</a> </li> <li> <a>DeleteDBInstance</a> </li> <li> <a>ModifyDBInstance</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBInstances</a> action.</p>', 'refs' => [ 'CreateDBInstanceReadReplicaResult$DBInstance' => NULL, 'CreateDBInstanceResult$DBInstance' => NULL, 'DBInstanceList$member' => NULL, 'DeleteDBInstanceResult$DBInstance' => NULL, 'ModifyDBInstanceResult$DBInstance' => NULL, 'PromoteReadReplicaResult$DBInstance' => NULL, 'RebootDBInstanceResult$DBInstance' => NULL, 'RestoreDBInstanceFromDBSnapshotResult$DBInstance' => NULL, 'RestoreDBInstanceToPointInTimeResult$DBInstance' => NULL, ], ], 'DBInstanceAlreadyExistsFault' => [ 'base' => '<p> User already has a DB instance with the given identifier. </p>', 'refs' => [], ], 'DBInstanceList' => [ 'base' => NULL, 'refs' => [ 'DBInstanceMessage$DBInstances' => '<p> A list of <a>DBInstance</a> instances. </p>', ], ], 'DBInstanceMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBInstances</a> action. </p>', 'refs' => [], ], 'DBInstanceNotFoundFault' => [ 'base' => '<p> <i>DBInstanceIdentifier</i> does not refer to an existing DB instance. </p>', 'refs' => [], ], 'DBInstanceStatusInfo' => [ 'base' => '<p>Provides a list of status information for a DB instance.</p>', 'refs' => [ 'DBInstanceStatusInfoList$member' => NULL, ], ], 'DBInstanceStatusInfoList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$StatusInfos' => '<p> The status of a Read Replica. If the instance is not a Read Replica, this will be blank. </p>', ], ], 'DBLogFileNotFoundFault' => [ 'base' => '<p><i>LogFileName</i> does not refer to an existing DB log file.</p>', 'refs' => [], ], 'DBParameterGroup' => [ 'base' => '<p>Contains the result of a successful invocation of the <a>CreateDBParameterGroup</a> action. </p> <p>This data type is used as a request parameter in the <a>DeleteDBParameterGroup</a> action, and as a response element in the <a>DescribeDBParameterGroups</a> action. </p>', 'refs' => [ 'CopyDBParameterGroupResult$DBParameterGroup' => NULL, 'CreateDBParameterGroupResult$DBParameterGroup' => NULL, 'DBParameterGroupList$member' => NULL, ], ], 'DBParameterGroupAlreadyExistsFault' => [ 'base' => '<p> A DB parameter group with the same name exists. </p>', 'refs' => [], ], 'DBParameterGroupDetails' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBParameters</a> action. </p>', 'refs' => [], ], 'DBParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DBParameterGroupsMessage$DBParameterGroups' => '<p> A list of <a>DBParameterGroup</a> instances. </p>', ], ], 'DBParameterGroupNameMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>ModifyDBParameterGroup</a> or <a>ResetDBParameterGroup</a> action. </p>', 'refs' => [], ], 'DBParameterGroupNotFoundFault' => [ 'base' => '<p> <i>DBParameterGroupName</i> does not refer to an existing DB parameter group. </p>', 'refs' => [], ], 'DBParameterGroupQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of DB parameter groups. </p>', 'refs' => [], ], 'DBParameterGroupStatus' => [ 'base' => '<p> The status of the DB parameter group. </p> <p>This data type is used as a response element in the following actions:</p> <ul> <li> <a>CreateDBInstance</a> </li> <li> <a>CreateDBInstanceReadReplica</a> </li> <li> <a>DeleteDBInstance</a> </li> <li> <a>ModifyDBInstance</a> </li> <li> <a>RebootDBInstance</a> </li> <li> <a>RestoreDBInstanceFromDBSnapshot</a> </li> </ul>', 'refs' => [ 'DBParameterGroupStatusList$member' => NULL, ], ], 'DBParameterGroupStatusList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBParameterGroups' => '<p> Provides the list of DB parameter groups applied to this DB instance. </p>', ], ], 'DBParameterGroupsMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBParameterGroups</a> action. </p>', 'refs' => [], ], 'DBSecurityGroup' => [ 'base' => '<p> Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>DescribeDBSecurityGroups</a> </li> <li> <a>AuthorizeDBSecurityGroupIngress</a> </li> <li> <a>CreateDBSecurityGroup</a> </li> <li> <a>RevokeDBSecurityGroupIngress</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBSecurityGroups</a> action.</p>', 'refs' => [ 'AuthorizeDBSecurityGroupIngressResult$DBSecurityGroup' => NULL, 'CreateDBSecurityGroupResult$DBSecurityGroup' => NULL, 'DBSecurityGroups$member' => NULL, 'RevokeDBSecurityGroupIngressResult$DBSecurityGroup' => NULL, ], ], 'DBSecurityGroupAlreadyExistsFault' => [ 'base' => '<p> A DB security group with the name specified in <i>DBSecurityGroupName</i> already exists. </p>', 'refs' => [], ], 'DBSecurityGroupMembership' => [ 'base' => '<p> This data type is used as a response element in the following actions: </p> <ul> <li> <a>ModifyDBInstance</a> </li> <li> <a>RebootDBInstance</a> </li> <li> <a>RestoreDBInstanceFromDBSnapshot</a> </li> <li> <a>RestoreDBInstanceToPointInTime</a> </li> </ul>', 'refs' => [ 'DBSecurityGroupMembershipList$member' => NULL, ], ], 'DBSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$DBSecurityGroups' => '<p> Provides List of DB security group elements containing only <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>', 'Option$DBSecurityGroupMemberships' => '<p> If the option requires access to a port, then this DB security group allows access to the port. </p>', ], ], 'DBSecurityGroupMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBSecurityGroups</a> action. </p>', 'refs' => [], ], 'DBSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateDBInstanceMessage$DBSecurityGroups' => '<p> A list of DB security groups to associate with this DB instance. </p> <p> Default: The default DB security group for the database engine. </p>', 'ModifyDBInstanceMessage$DBSecurityGroups' => '<p> A list of DB security groups to authorize on this DB instance. Changing this setting does not result in an outage and the change is asynchronously applied as soon as possible. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'OptionConfiguration$DBSecurityGroupMemberships' => '<p> A list of DBSecurityGroupMemebrship name strings used for this option. </p>', ], ], 'DBSecurityGroupNotFoundFault' => [ 'base' => '<p> <i>DBSecurityGroupName</i> does not refer to an existing DB security group. </p>', 'refs' => [], ], 'DBSecurityGroupNotSupportedFault' => [ 'base' => '<p> A DB security group is not allowed for this action. </p>', 'refs' => [], ], 'DBSecurityGroupQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of DB security groups. </p>', 'refs' => [], ], 'DBSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroupMessage$DBSecurityGroups' => '<p> A list of <a>DBSecurityGroup</a> instances. </p>', ], ], 'DBSnapshot' => [ 'base' => '<p> Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>CreateDBSnapshot</a> </li> <li> <a>DeleteDBSnapshot</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBSnapshots</a> action.</p>', 'refs' => [ 'CopyDBSnapshotResult$DBSnapshot' => NULL, 'CreateDBSnapshotResult$DBSnapshot' => NULL, 'DBSnapshotList$member' => NULL, 'DeleteDBSnapshotResult$DBSnapshot' => NULL, ], ], 'DBSnapshotAlreadyExistsFault' => [ 'base' => '<p> <i>DBSnapshotIdentifier</i> is already used by an existing snapshot. </p>', 'refs' => [], ], 'DBSnapshotAttribute' => [ 'base' => '<p>Contains the name and values of a manual DB snapshot attribute</p> <p>Manual DB snapshot attributes are used to authorize other AWS accounts to restore a manual DB snapshot. For more information, see the <a>ModifyDBSnapshotAttribute</a> API.</p>', 'refs' => [ 'DBSnapshotAttributeList$member' => NULL, ], ], 'DBSnapshotAttributeList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotAttributesResult$DBSnapshotAttributes' => '<p>The list of attributes and values for the manual DB snapshot.</p>', ], ], 'DBSnapshotAttributesResult' => [ 'base' => '<p>Contains the results of a successful call to the <a>DescribeDBSnapshotAttributes</a> API.</p> <p>Manual DB snapshot attributes are used to authorize other AWS accounts to copy or restore a manual DB snapshot. For more information, see the <a>ModifyDBSnapshotAttribute</a> API.</p>', 'refs' => [ 'DescribeDBSnapshotAttributesResult$DBSnapshotAttributesResult' => NULL, 'ModifyDBSnapshotAttributeResult$DBSnapshotAttributesResult' => NULL, ], ], 'DBSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DBSnapshotMessage$DBSnapshots' => '<p> A list of <a>DBSnapshot</a> instances. </p>', ], ], 'DBSnapshotMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBSnapshots</a> action. </p>', 'refs' => [], ], 'DBSnapshotNotFoundFault' => [ 'base' => '<p> <i>DBSnapshotIdentifier</i> does not refer to an existing DB snapshot. </p>', 'refs' => [], ], 'DBSubnetGroup' => [ 'base' => '<p> Contains the result of a successful invocation of the following actions: </p> <ul> <li> <a>CreateDBSubnetGroup</a> </li> <li> <a>ModifyDBSubnetGroup</a> </li> <li> <a>DescribeDBSubnetGroups</a> </li> <li> <a>DeleteDBSubnetGroup</a> </li> </ul> <p>This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action.</p>', 'refs' => [ 'CreateDBSubnetGroupResult$DBSubnetGroup' => NULL, 'DBInstance$DBSubnetGroup' => '<p> Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group. </p>', 'DBSubnetGroups$member' => NULL, 'ModifyDBSubnetGroupResult$DBSubnetGroup' => NULL, ], ], 'DBSubnetGroupAlreadyExistsFault' => [ 'base' => '<p> <i>DBSubnetGroupName</i> is already used by an existing DB subnet group. </p>', 'refs' => [], ], 'DBSubnetGroupDoesNotCoverEnoughAZs' => [ 'base' => '<p> Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone. </p>', 'refs' => [], ], 'DBSubnetGroupMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeDBSubnetGroups</a> action. </p>', 'refs' => [], ], 'DBSubnetGroupNotAllowedFault' => [ 'base' => '<p> Indicates that the DBSubnetGroup should not be specified while creating read replicas that lie in the same region as the source instance. </p>', 'refs' => [], ], 'DBSubnetGroupNotFoundFault' => [ 'base' => '<p> <i>DBSubnetGroupName</i> does not refer to an existing DB subnet group. </p>', 'refs' => [], ], 'DBSubnetGroupQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of DB subnet groups. </p>', 'refs' => [], ], 'DBSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroupMessage$DBSubnetGroups' => '<p> A list of <a>DBSubnetGroup</a> instances. </p>', ], ], 'DBSubnetQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of subnets in a DB subnet groups. </p>', 'refs' => [], ], 'DBUpgradeDependencyFailureFault' => [ 'base' => '<p> The DB upgrade failed because a resource the DB depends on could not be modified. </p>', 'refs' => [], ], 'DeleteDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBClusterSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBClusterSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBSecurityGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeAccountAttributesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeCertificatesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClusterSnapshotsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBClustersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBEngineVersionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBLogFilesDetails' => [ 'base' => '<p>This data type is used as a response element to <a>DescribeDBLogFiles</a>.</p>', 'refs' => [ 'DescribeDBLogFilesList$member' => NULL, ], ], 'DescribeDBLogFilesList' => [ 'base' => NULL, 'refs' => [ 'DescribeDBLogFilesResponse$DescribeDBLogFiles' => '<p> The DB log files returned. </p>', ], ], 'DescribeDBLogFilesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBLogFilesResponse' => [ 'base' => '<p> The response from a call to <a>DescribeDBLogFiles</a>. </p>', 'refs' => [], ], 'DescribeDBParameterGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBParametersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSecurityGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBSnapshotAttributesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSnapshotAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDBSnapshotsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeDBSubnetGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultClusterParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineDefaultParametersMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEngineDefaultParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventCategoriesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventSubscriptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOptionGroupOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOptionGroupsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeOrderableDBInstanceOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribePendingMaintenanceActionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReservedDBInstancesMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'DescribeReservedDBInstancesOfferingsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p> The amount of the recurring charge. </p>', 'ReservedDBInstance$FixedPrice' => '<p> The fixed price charged for this reserved DB instance. </p>', 'ReservedDBInstance$UsagePrice' => '<p> The hourly price charged for this reserved DB instance. </p>', 'ReservedDBInstancesOffering$FixedPrice' => '<p> The fixed price charged for this offering. </p>', 'ReservedDBInstancesOffering$UsagePrice' => '<p> The hourly price charged for this offering. </p>', ], ], 'DownloadDBLogFilePortionDetails' => [ 'base' => '<p>This data type is used as a response element to <a>DownloadDBLogFilePortion</a>.</p>', 'refs' => [], ], 'DownloadDBLogFilePortionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'EC2SecurityGroup' => [ 'base' => '<p> This data type is used as a response element in the following actions: </p> <ul> <li> <a>AuthorizeDBSecurityGroupIngress</a> </li> <li> <a>DescribeDBSecurityGroups</a> </li> <li> <a>RevokeDBSecurityGroupIngress</a> </li> </ul>', 'refs' => [ 'EC2SecurityGroupList$member' => NULL, ], ], 'EC2SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroup$EC2SecurityGroups' => '<p> Contains a list of <a>EC2SecurityGroup</a> elements. </p>', ], ], 'Endpoint' => [ 'base' => '<p> This data type is used as a response element in the following actions: </p> <ul> <li> <a>CreateDBInstance</a> </li> <li> <a>DescribeDBInstances</a> </li> <li> <a>DeleteDBInstance</a> </li> </ul>', 'refs' => [ 'DBInstance$Endpoint' => '<p> Specifies the connection endpoint. </p>', ], ], 'EngineDefaults' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeEngineDefaultParameters</a> action. </p>', 'refs' => [ 'DescribeEngineDefaultClusterParametersResult$EngineDefaults' => NULL, 'DescribeEngineDefaultParametersResult$EngineDefaults' => NULL, ], ], 'Event' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeEvents</a> action. </p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventCategoriesList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType in the <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <b>DescribeEventCategories</b> action. </p>', 'DescribeEventsMessage$EventCategories' => '<p> A list of event categories that trigger notifications for a event notification subscription. </p>', 'Event$EventCategories' => '<p> Specifies the category for the event. </p>', 'EventCategoriesMap$EventCategories' => '<p>The event categories for the specified source type</p>', 'EventSubscription$EventCategoriesList' => '<p>A list of event categories for the RDS event notification subscription.</p>', 'ModifyEventSubscriptionMessage$EventCategories' => '<p> A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType in the <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <b>DescribeEventCategories</b> action. </p>', ], ], 'EventCategoriesMap' => [ 'base' => '<p>Contains the results of a successful invocation of the <a>DescribeEventCategories</a> action.</p>', 'refs' => [ 'EventCategoriesMapList$member' => NULL, ], ], 'EventCategoriesMapList' => [ 'base' => NULL, 'refs' => [ 'EventCategoriesMessage$EventCategoriesMapList' => '<p>A list of EventCategoriesMap data types.</p>', ], ], 'EventCategoriesMessage' => [ 'base' => '<p>Data returned from the <b>DescribeEventCategories</b> action.</p>', 'refs' => [], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p> A list of <a>Event</a> instances. </p>', ], ], 'EventSubscription' => [ 'base' => '<p>Contains the results of a successful invocation of the <a>DescribeEventSubscriptions</a> action.</p>', 'refs' => [ 'AddSourceIdentifierToSubscriptionResult$EventSubscription' => NULL, 'CreateEventSubscriptionResult$EventSubscription' => NULL, 'DeleteEventSubscriptionResult$EventSubscription' => NULL, 'EventSubscriptionsList$member' => NULL, 'ModifyEventSubscriptionResult$EventSubscription' => NULL, 'RemoveSourceIdentifierFromSubscriptionResult$EventSubscription' => NULL, ], ], 'EventSubscriptionQuotaExceededFault' => [ 'base' => '<p>You have reached the maximum number of event subscriptions.</p>', 'refs' => [], ], 'EventSubscriptionsList' => [ 'base' => NULL, 'refs' => [ 'EventSubscriptionsMessage$EventSubscriptionsList' => '<p>A list of EventSubscriptions data types.</p>', ], ], 'EventSubscriptionsMessage' => [ 'base' => '<p>Data returned by the <b>DescribeEventSubscriptions</b> action.</p>', 'refs' => [], ], 'EventsMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeEvents</a> action. </p>', 'refs' => [], ], 'FailoverDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'FailoverDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => NULL, 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificatesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterParameterGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClusterSnapshotsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBClustersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBEngineVersionsMessage$Filters' => '<p> Not currently supported. </p>', 'DescribeDBInstancesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBLogFilesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBParameterGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBSecurityGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBSnapshotsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeDBSubnetGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEngineDefaultClusterParametersMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEngineDefaultParametersMessage$Filters' => '<p> Not currently supported. </p>', 'DescribeEventCategoriesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventSubscriptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeEventsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeOptionGroupOptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeOptionGroupsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeOrderableDBInstanceOptionsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribePendingMaintenanceActionsMessage$Filters' => '<p>A filter that specifies one or more resources to return pending maintenance actions for.</p> <p>Supported filters:</p> <ul> <li> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs]. The results list will only include pending maintenance actions for the DB instances identified by these ARNs.</li> </ul>', 'DescribeReservedDBInstancesMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'DescribeReservedDBInstancesOfferingsMessage$Filters' => '<p>This parameter is not currently supported.</p>', 'ListTagsForResourceMessage$Filters' => '<p>This parameter is not currently supported.</p>', ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>This parameter is not currently supported.</p>', ], ], 'IPRange' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeDBSecurityGroups</a> action. </p>', 'refs' => [ 'IPRangeList$member' => NULL, ], ], 'IPRangeList' => [ 'base' => NULL, 'refs' => [ 'DBSecurityGroup$IPRanges' => '<p> Contains a list of <a>IPRange</a> elements. </p>', ], ], 'InstanceQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of DB instances. </p>', 'refs' => [], ], 'InsufficientDBClusterCapacityFault' => [ 'base' => '<p>The DB cluster does not have enough capacity for the current operation. </p>', 'refs' => [], ], 'InsufficientDBInstanceCapacityFault' => [ 'base' => '<p> Specified DB instance class is not available in the specified Availability Zone. </p>', 'refs' => [], ], 'InsufficientStorageClusterCapacityFault' => [ 'base' => '<p>There is insufficient storage available for the current action. You may be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DBClusterSnapshot$AllocatedStorage' => '<p>Specifies the allocated storage size in gigabytes (GB]. </p>', 'DBClusterSnapshot$Port' => '<p>Specifies the port that the DB cluster was listening on at the time of the snapshot. </p>', 'DBClusterSnapshot$PercentProgress' => '<p>Specifies the percentage of the estimated data that has been transferred. </p>', 'DBInstance$AllocatedStorage' => '<p> Specifies the allocated storage size specified in gigabytes. </p>', 'DBInstance$BackupRetentionPeriod' => '<p> Specifies the number of days for which automatic DB snapshots are retained. </p>', 'DBInstance$DbInstancePort' => '<p> Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port. </p>', 'DBSnapshot$AllocatedStorage' => '<p> Specifies the allocated storage size in gigabytes (GB]. </p>', 'DBSnapshot$Port' => '<p> Specifies the port that the database engine was listening on at the time of the snapshot. </p>', 'DBSnapshot$PercentProgress' => '<p> The percentage of the estimated data that has been transferred. </p>', 'DownloadDBLogFilePortionMessage$NumberOfLines' => '<p> The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file will be truncated at 1 MB in size. </p> <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter. <ul><li><p>If neither Marker or NumberOfLines are specified, the entire log file is returned.</p></li><li><p>If NumberOfLines is specified and Marker is not specified, then the most recent lines from the end of the log file are returned.</p></li><li><p>If Marker is specified as "0", then the specified number of lines from the beginning of the log file are returned.</p></li><li><p>You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.</p></li></ul></p>', 'Endpoint$Port' => '<p> Specifies the port that the database engine is listening on. </p>', 'ReservedDBInstance$Duration' => '<p> The duration of the reservation in seconds. </p>', 'ReservedDBInstance$DBInstanceCount' => '<p> The number of reserved DB instances. </p>', 'ReservedDBInstancesOffering$Duration' => '<p> The duration of the offering in seconds. </p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1. </p> <p>Default: 1 </p> <p>Constraints:</p> <ul> <li>Must be a value from 1 to 35</li> </ul>', 'CreateDBClusterMessage$Port' => '<p> The port number on which the instances in the DB cluster accept connections. </p> <p> Default: <code>3306</code></p>', 'CreateDBInstanceMessage$AllocatedStorage' => '<p> The amount of storage (in gigabytes] to be initially allocated for the database instance. </p> <p> Type: Integer</p> <p> <b>MySQL</b> </p> <p> Constraints: Must be an integer from 5 to 6144.</p> <p> <b>MariaDB</b> </p> <p> Constraints: Must be an integer from 5 to 6144.</p> <p> <b>PostgreSQL</b> </p> <p> Constraints: Must be an integer from 5 to 6144.</p> <p> <b>Oracle</b> </p> <p> Constraints: Must be an integer from 10 to 6144.</p> <p> <b>SQL Server</b> </p> <p> Constraints: Must be an integer from 200 to 4096 (Standard Edition and Enterprise Edition] or from 20 to 4096 (Express Edition and Web Edition]</p>', 'CreateDBInstanceMessage$BackupRetentionPeriod' => '<p> The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups. </p> <p> Default: 1 </p> <p>Constraints:</p> <ul> <li>Must be a value from 0 to 35</li> <li>Cannot be set to 0 if the DB instance is a source to Read Replicas</li> </ul>', 'CreateDBInstanceMessage$Port' => '<p> The port number on which the database accepts connections. </p> <p> <b>MySQL</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p> <p>Type: Integer </p> <p> <b>MariaDB</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p> <p>Type: Integer </p> <p> <b>PostgreSQL</b> </p> <p> Default: <code>5432</code></p> <p> Valid Values: <code>1150-65535</code></p> <p>Type: Integer </p> <p> <b>Oracle</b> </p> <p> Default: <code>1521</code></p> <p> Valid Values: <code>1150-65535</code></p> <p> <b>SQL Server</b> </p> <p> Default: <code>1433</code></p> <p> Valid Values: <code>1150-65535</code> except for <code>1434</code>, <code>3389</code>, <code>47001</code>, <code>49152</code>, and <code>49152</code> through <code>49156</code>. </p> <p> <b>Amazon Aurora</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p> <p>Type: Integer </p>', 'CreateDBInstanceMessage$Iops' => '<p> The amount of Provisioned IOPS (input/output operations per second] to be initially allocated for the DB instance. </p> <p> Constraints: To use PIOPS, this value must be an integer greater than 1000.</p>', 'CreateDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 60.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code></p>', 'CreateDBInstanceReadReplicaMessage$Port' => '<p> The port number that the DB instance uses for connections. </p> <p>Default: Inherits from the source DB instance</p> <p>Valid Values: <code>1150-65535</code></p>', 'CreateDBInstanceReadReplicaMessage$Iops' => '<p> The amount of Provisioned IOPS (input/output operations per second] to be initially allocated for the DB instance. </p>', 'CreateDBInstanceReadReplicaMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the Read Replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 60.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code></p>', 'DBCluster$AllocatedStorage' => '<p>Specifies the allocated storage size in gigabytes (GB]. </p>', 'DBCluster$BackupRetentionPeriod' => '<p>Specifies the number of days for which automatic DB snapshots are retained. </p>', 'DBCluster$Port' => '<p>Specifies the port that the database engine is listening on. </p>', 'DBInstance$Iops' => '<p> Specifies the Provisioned IOPS (I/O operations per second] value. </p>', 'DBInstance$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>', 'DBSnapshot$Iops' => '<p> Specifies the Provisioned IOPS (I/O operations per second] value of the DB instance at the time of the snapshot. </p>', 'DescribeCertificatesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParameterGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClusterSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBEngineVersionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBLogFilesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p>', 'DescribeDBParameterGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSecurityGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSnapshotsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeDBSubnetGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultClusterParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEngineDefaultParametersMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventSubscriptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p> The number of minutes to retrieve events for. </p> <p>Default: 60</p>', 'DescribeEventsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOptionGroupOptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOptionGroupsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeOrderableDBInstanceOptionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribePendingMaintenanceActionsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReservedDBInstancesMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'DescribeReservedDBInstancesOfferingsMessage$MaxRecords' => '<p> The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so that the following results can be retrieved. </p> <p>Default: 100</p> <p>Constraints: Minimum 20, maximum 100.</p>', 'ModifyDBClusterMessage$BackupRetentionPeriod' => '<p>The number of days for which automated backups are retained. You must specify a minimum value of 1. </p> <p>Default: 1 </p> <p>Constraints:</p> <ul> <li>Must be a value from 1 to 35</li> </ul>', 'ModifyDBClusterMessage$Port' => '<p> The port number on which the DB cluster accepts connections. </p> <p>Constraints: Value must be <code>1150-65535</code></p> <p>Default: The same port as the original DB cluster.</p>', 'ModifyDBInstanceMessage$AllocatedStorage' => '<p> The new storage capacity of the RDS instance. Changing this setting does not result in an outage and the change is applied during the next maintenance window unless <code>ApplyImmediately</code> is set to <code>true</code> for this request. </p> <p> <b>MySQL</b> </p> <p>Default: Uses existing setting</p> <p>Valid Values: 5-6144</p> <p>Constraints: Value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> <p>Type: Integer</p> <p> <b>MariaDB</b> </p> <p>Default: Uses existing setting</p> <p>Valid Values: 5-6144</p> <p>Constraints: Value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> <p>Type: Integer</p> <p> <b>PostgreSQL</b> </p> <p>Default: Uses existing setting</p> <p>Valid Values: 5-6144</p> <p>Constraints: Value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> <p>Type: Integer</p> <p> <b>Oracle</b> </p> <p>Default: Uses existing setting</p> <p>Valid Values: 10-6144</p> <p>Constraints: Value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p> <p> <b>SQL Server</b> </p> <p>Cannot be modified.</p> <p> If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS], amount of IOPS provisioned (if any], and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance will be available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance will be suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a Read Replica for the instance, and creating a DB snapshot of the instance. </p>', 'ModifyDBInstanceMessage$BackupRetentionPeriod' => '<p> The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups. </p> <p>Changing this parameter can result in an outage if you change from 0 to a non-zero value or from a non-zero value to 0. These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.</p> <p>Default: Uses existing setting</p> <p>Constraints:</p> <ul> <li>Must be a value from 0 to 35</li> <li>Can be specified for a MySQL Read Replica only if the source is running MySQL 5.6</li> <li>Can be specified for a PostgreSQL Read Replica only if the source is running PostgreSQL 9.3.5</li> <li>Cannot be set to 0 if the DB instance is a source to Read Replicas</li> </ul>', 'ModifyDBInstanceMessage$Iops' => '<p> The new Provisioned IOPS (I/O operations per second] value for the RDS instance. Changing this setting does not result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. </p> <p>Default: Uses existing setting</p> <p>Constraints: Value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.</p> <p> <b>SQL Server</b> </p> <p>Setting the IOPS value for the SQL Server database engine is not supported.</p> <p>Type: Integer</p> <p> If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS], amount of IOPS provisioned (if any], and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance will be available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance will be suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a Read Replica for the instance, and creating a DB snapshot of the instance. </p>', 'ModifyDBInstanceMessage$MonitoringInterval' => '<p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 60.</p> <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p> <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code></p>', 'ModifyDBInstanceMessage$DBPortNumber' => '<p> The port number on which the database accepts connections. </p> <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p> <p>Your database will restart when you change the <code>DBPortNumber</code> value regardless of the value of the <code>ApplyImmediately</code> parameter.</p> <p> <b>MySQL</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p> <p> <b>MariaDB</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p> <p> <b>PostgreSQL</b> </p> <p> Default: <code>5432</code></p> <p> Valid Values: <code>1150-65535</code></p> <p> <b>Oracle</b> </p> <p> Default: <code>1521</code></p> <p> Valid Values: <code>1150-65535</code></p> <p> <b>SQL Server</b> </p> <p> Default: <code>1433</code></p> <p> Valid Values: <code>1150-65535</code> except for <code>1434</code>, <code>3389</code>, <code>47001</code>, <code>49152</code>, and <code>49152</code> through <code>49156</code>. </p> <p> <b>Amazon Aurora</b> </p> <p> Default: <code>3306</code></p> <p> Valid Values: <code>1150-65535</code></p>', 'Option$Port' => '<p> If required, the port configured for this option to use. </p>', 'OptionConfiguration$Port' => '<p> The optional port for the option. </p>', 'OptionGroupOption$DefaultPort' => '<p> If the option requires a port, specifies the default port for the option. </p>', 'PendingModifiedValues$AllocatedStorage' => '<p> Contains the new <code>AllocatedStorage</code> size for the DB instance that will be applied or is in progress. </p>', 'PendingModifiedValues$Port' => '<p> Specifies the pending port for the DB instance. </p>', 'PendingModifiedValues$BackupRetentionPeriod' => '<p> Specifies the pending number of days for which automated backups are retained. </p>', 'PendingModifiedValues$Iops' => '<p> Specifies the new Provisioned IOPS value for the DB instance that will be applied or is being applied. </p>', 'PromoteReadReplicaMessage$BackupRetentionPeriod' => '<p> The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups. </p> <p> Default: 1 </p> <p>Constraints:</p> <ul> <li>Must be a value from 0 to 8</li> </ul>', 'PurchaseReservedDBInstancesOfferingMessage$DBInstanceCount' => '<p> The number of instances to reserve. </p> <p>Default: <code>1</code></p>', 'RestoreDBClusterFromSnapshotMessage$Port' => '<p> The port number on which the new DB cluster accepts connections. </p> <p>Constraints: Value must be <code>1150-65535</code></p> <p>Default: The same port as the original DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$Port' => '<p> The port number on which the new DB cluster accepts connections. </p> <p>Constraints: Value must be <code>1150-65535</code></p> <p>Default: The same port as the original DB cluster.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$Port' => '<p> The port number on which the database accepts connections. </p> <p>Default: The same port as the original DB instance</p> <p>Constraints: Value must be <code>1150-65535</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$Iops' => '<p> Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter is not specified, the IOPS value will be taken from the backup. If this parameter is set to 0, the new instance will be converted to a non-PIOPS instance, which will take additional time, though your DB instance will be available for connections before the conversion starts. </p> <p> Constraints: Must be an integer greater than 1000.</p> <p> <b>SQL Server</b> </p> <p>Setting the IOPS value for the SQL Server database engine is not supported.</p>', 'RestoreDBInstanceToPointInTimeMessage$Port' => '<p> The port number on which the database accepts connections. </p> <p>Constraints: Value must be <code>1150-65535</code></p> <p>Default: The same port as the original DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$Iops' => '<p> The amount of Provisioned IOPS (input/output operations per second] to be initially allocated for the DB instance. </p> <p> Constraints: Must be an integer greater than 1000.</p> <p> <b>SQL Server</b> </p> <p>Setting the IOPS value for the SQL Server database engine is not supported.</p>', ], ], 'InvalidDBClusterSnapshotStateFault' => [ 'base' => '<p>The supplied value is not a valid DB cluster snapshot state. </p>', 'refs' => [], ], 'InvalidDBClusterStateFault' => [ 'base' => '<p>The supplied value is not a valid DB cluster state. </p>', 'refs' => [], ], 'InvalidDBInstanceStateFault' => [ 'base' => '<p> The specified DB instance is not in the <i>available</i> state. </p>', 'refs' => [], ], 'InvalidDBParameterGroupStateFault' => [ 'base' => '<p> The DB parameter group cannot be deleted because it is in use. </p>', 'refs' => [], ], 'InvalidDBSecurityGroupStateFault' => [ 'base' => '<p> The state of the DB security group does not allow deletion. </p>', 'refs' => [], ], 'InvalidDBSnapshotStateFault' => [ 'base' => '<p> The state of the DB snapshot does not allow deletion. </p>', 'refs' => [], ], 'InvalidDBSubnetGroupFault' => [ 'base' => '<p> Indicates the DBSubnetGroup does not belong to the same VPC as that of an existing cross region read replica of the same source instance. </p>', 'refs' => [], ], 'InvalidDBSubnetGroupStateFault' => [ 'base' => '<p> The DB subnet group cannot be deleted because it is in use. </p>', 'refs' => [], ], 'InvalidDBSubnetStateFault' => [ 'base' => '<p> The DB subnet is not in the <i>available</i> state. </p>', 'refs' => [], ], 'InvalidEventSubscriptionStateFault' => [ 'base' => '<p>This error can occur if someone else is modifying a subscription. You should retry the action.</p>', 'refs' => [], ], 'InvalidOptionGroupStateFault' => [ 'base' => '<p> The option group is not in the <i>available</i> state. </p>', 'refs' => [], ], 'InvalidRestoreFault' => [ 'base' => '<p> Cannot restore from vpc backup to non-vpc DB instance. </p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p> The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC. </p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p> DB subnet group does not cover all Availability Zones after it is created because users\' change. </p>', 'refs' => [], ], 'KMSKeyNotAccessibleFault' => [ 'base' => '<p> Error accessing KMS key. </p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>The tag key (name] of the tag to be removed.</p>', ], ], 'ListTagsForResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$Used' => '<p>The amount currently used toward the quota maximum.</p>', 'AccountQuota$Max' => '<p>The maximum allowed value for the quota.</p>', 'DescribeDBLogFilesDetails$LastWritten' => '<p> A POSIX timestamp when the last log entry was written. </p>', 'DescribeDBLogFilesDetails$Size' => '<p> The size, in bytes, of the log file for the specified DB instance. </p>', 'DescribeDBLogFilesMessage$FileLastWritten' => '<p> Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds. </p>', 'DescribeDBLogFilesMessage$FileSize' => '<p> Filters the available log files for files larger than the specified size. </p>', ], ], 'ModifyDBClusterMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBSnapshotAttributeMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDBSubnetGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyDBSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEventSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyEventSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyOptionGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ModifyOptionGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'Option' => [ 'base' => '<p> Option details. </p>', 'refs' => [ 'OptionsList$member' => NULL, ], ], 'OptionConfiguration' => [ 'base' => '<p> A list of all available options </p>', 'refs' => [ 'OptionConfigurationList$member' => NULL, ], ], 'OptionConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ModifyOptionGroupMessage$OptionsToInclude' => '<p> Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration. </p>', ], ], 'OptionGroup' => [ 'base' => '<p/>', 'refs' => [ 'CopyOptionGroupResult$OptionGroup' => NULL, 'CreateOptionGroupResult$OptionGroup' => NULL, 'ModifyOptionGroupResult$OptionGroup' => NULL, 'OptionGroupsList$member' => NULL, ], ], 'OptionGroupAlreadyExistsFault' => [ 'base' => '<p> The option group you are trying to create already exists. </p>', 'refs' => [], ], 'OptionGroupMembership' => [ 'base' => '<p> Provides information on the option groups the DB instance is a member of. </p>', 'refs' => [ 'OptionGroupMembershipList$member' => NULL, ], ], 'OptionGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$OptionGroupMemberships' => '<p> Provides the list of option group memberships for this DB instance. </p>', ], ], 'OptionGroupNotFoundFault' => [ 'base' => '<p> The specified option group could not be found. </p>', 'refs' => [], ], 'OptionGroupOption' => [ 'base' => '<p> Available option. </p>', 'refs' => [ 'OptionGroupOptionsList$member' => NULL, ], ], 'OptionGroupOptionSetting' => [ 'base' => '<p>Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action. </p>', 'refs' => [ 'OptionGroupOptionSettingsList$member' => NULL, ], ], 'OptionGroupOptionSettingsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionGroupOptionSettings' => '<p> Specifies the option settings that are available (and the default value] for each option in an option group. </p>', ], ], 'OptionGroupOptionsList' => [ 'base' => '<p> List of available option group options. </p>', 'refs' => [ 'OptionGroupOptionsMessage$OptionGroupOptions' => NULL, ], ], 'OptionGroupOptionsMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'OptionGroupQuotaExceededFault' => [ 'base' => '<p> The quota of 20 option groups was exceeded for this AWS account. </p>', 'refs' => [], ], 'OptionGroups' => [ 'base' => '<p> List of option groups. </p>', 'refs' => [], ], 'OptionGroupsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroups$OptionGroupsList' => '<p> List of option groups. </p>', ], ], 'OptionNamesList' => [ 'base' => NULL, 'refs' => [ 'ModifyOptionGroupMessage$OptionsToRemove' => '<p> Options in this list are removed from the option group. </p>', ], ], 'OptionSetting' => [ 'base' => '<p> Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values. </p>', 'refs' => [ 'OptionSettingConfigurationList$member' => NULL, 'OptionSettingsList$member' => NULL, ], ], 'OptionSettingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Option$OptionSettings' => '<p> The option settings for this option. </p>', ], ], 'OptionSettingsList' => [ 'base' => NULL, 'refs' => [ 'OptionConfiguration$OptionSettings' => '<p> The option settings to include in an option group. </p>', ], ], 'OptionsDependedOn' => [ 'base' => NULL, 'refs' => [ 'OptionGroupOption$OptionsDependedOn' => '<p> List of all options that are prerequisites for this option. </p>', ], ], 'OptionsList' => [ 'base' => NULL, 'refs' => [ 'OptionGroup$Options' => '<p> Indicates what options are available in the option group. </p>', ], ], 'OrderableDBInstanceOption' => [ 'base' => '<p> Contains a list of available options for a DB instance </p> <p> This data type is used as a response element in the <a>DescribeOrderableDBInstanceOptions</a> action. </p>', 'refs' => [ 'OrderableDBInstanceOptionsList$member' => NULL, ], ], 'OrderableDBInstanceOptionsList' => [ 'base' => NULL, 'refs' => [ 'OrderableDBInstanceOptionsMessage$OrderableDBInstanceOptions' => '<p>An <a>OrderableDBInstanceOption</a> structure containing information about orderable options for the DB instance.</p>', ], ], 'OrderableDBInstanceOptionsMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeOrderableDBInstanceOptions</a> action. </p>', 'refs' => [], ], 'Parameter' => [ 'base' => '<p> This data type is used as a request parameter in the <a>ModifyDBParameterGroup</a> and <a>ResetDBParameterGroup</a> actions. </p> <p>This data type is used as a response element in the <a>DescribeEngineDefaultParameters</a> and <a>DescribeDBParameters</a> actions.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'DBClusterParameterGroupDetails$Parameters' => '<p>Provides a list of parameters for the DB cluster parameter group.</p>', 'DBParameterGroupDetails$Parameters' => '<p> A list of <a>Parameter</a> values. </p>', 'EngineDefaults$Parameters' => '<p> Contains a list of engine default parameters. </p>', 'ModifyDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameters in the DB cluster parameter group to modify.</p>', 'ModifyDBParameterGroupMessage$Parameters' => '<p> An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request. </p> <p>Valid Values (for the application method]: <code>immediate | pending-reboot</code></p> <note>You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when you reboot the DB instance without failover. </note>', 'ResetDBClusterParameterGroupMessage$Parameters' => '<p>A list of parameter names in the DB cluster parameter group to reset to the default values. You cannot use this parameter if the <code>ResetAllParameters</code> parameter is set to <code>true</code>.</p>', 'ResetDBParameterGroupMessage$Parameters' => '<p> An array of parameter names, values, and the apply method for the parameter update. At least one parameter name, value, and apply method must be supplied; subsequent arguments are optional. A maximum of 20 parameters can be modified in a single request. </p> <p> <b>MySQL</b> </p> <p>Valid Values (for Apply method]: <code>immediate</code> | <code>pending-reboot</code></p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>MariaDB</b> </p> <p>Valid Values (for Apply method]: <code>immediate</code> | <code>pending-reboot</code></p> <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p> <p> <b>Oracle</b> </p> <p>Valid Values (for Apply method]: <code>pending-reboot</code></p>', ], ], 'PendingMaintenanceAction' => [ 'base' => '<p>Provides information about a pending maintenance action for a resource.</p>', 'refs' => [ 'PendingMaintenanceActionDetails$member' => NULL, ], ], 'PendingMaintenanceActionDetails' => [ 'base' => NULL, 'refs' => [ 'ResourcePendingMaintenanceActions$PendingMaintenanceActionDetails' => '<p>A list that provides details about the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActions' => [ 'base' => NULL, 'refs' => [ 'PendingMaintenanceActionsMessage$PendingMaintenanceActions' => '<p>A list of the pending maintenance actions for the resource.</p>', ], ], 'PendingMaintenanceActionsMessage' => [ 'base' => '<p>Data returned from the <b>DescribePendingMaintenanceActions</b> action.</p>', 'refs' => [], ], 'PendingModifiedValues' => [ 'base' => '<p> This data type is used as a response element in the <a>ModifyDBInstance</a> action. </p>', 'refs' => [ 'DBInstance$PendingModifiedValues' => '<p> Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements. </p>', ], ], 'PointInTimeRestoreNotEnabledFault' => [ 'base' => '<p> <i>SourceDBInstanceIdentifier</i> refers to a DB instance with <i>BackupRetentionPeriod</i> equal to 0. </p>', 'refs' => [], ], 'PromoteReadReplicaMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PromoteReadReplicaResult' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionedIopsNotAvailableInAZFault' => [ 'base' => '<p> Provisioned IOPS not available in the specified Availability Zone. </p>', 'refs' => [], ], 'PurchaseReservedDBInstancesOfferingMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'PurchaseReservedDBInstancesOfferingResult' => [ 'base' => NULL, 'refs' => [], ], 'ReadReplicaDBInstanceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'DBInstance$ReadReplicaDBInstanceIdentifiers' => '<p> Contains one or more identifiers of the Read Replicas associated with this DB instance. </p>', ], ], 'RebootDBInstanceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RebootDBInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeReservedDBInstances</a> and <a>DescribeReservedDBInstancesOfferings</a> actions. </p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstance$RecurringCharges' => '<p> The recurring price charged to run this reserved DB instance. </p>', 'ReservedDBInstancesOffering$RecurringCharges' => '<p> The recurring price charged to run this reserved DB instance. </p>', ], ], 'RemoveSourceIdentifierFromSubscriptionMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RemoveSourceIdentifierFromSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ReservedDBInstance' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeReservedDBInstances</a> and <a>PurchaseReservedDBInstancesOffering</a> actions. </p>', 'refs' => [ 'PurchaseReservedDBInstancesOfferingResult$ReservedDBInstance' => NULL, 'ReservedDBInstanceList$member' => NULL, ], ], 'ReservedDBInstanceAlreadyExistsFault' => [ 'base' => '<p> User already has a reservation with the given identifier. </p>', 'refs' => [], ], 'ReservedDBInstanceList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstanceMessage$ReservedDBInstances' => '<p> A list of reserved DB instances. </p>', ], ], 'ReservedDBInstanceMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeReservedDBInstances</a> action. </p>', 'refs' => [], ], 'ReservedDBInstanceNotFoundFault' => [ 'base' => '<p> The specified reserved DB Instance not found. </p>', 'refs' => [], ], 'ReservedDBInstanceQuotaExceededFault' => [ 'base' => '<p> Request would exceed the user\'s DB Instance quota. </p>', 'refs' => [], ], 'ReservedDBInstancesOffering' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeReservedDBInstancesOfferings</a> action. </p>', 'refs' => [ 'ReservedDBInstancesOfferingList$member' => NULL, ], ], 'ReservedDBInstancesOfferingList' => [ 'base' => NULL, 'refs' => [ 'ReservedDBInstancesOfferingMessage$ReservedDBInstancesOfferings' => '<p> A list of reserved DB instance offerings. </p>', ], ], 'ReservedDBInstancesOfferingMessage' => [ 'base' => '<p> Contains the result of a successful invocation of the <a>DescribeReservedDBInstancesOfferings</a> action. </p>', 'refs' => [], ], 'ReservedDBInstancesOfferingNotFoundFault' => [ 'base' => '<p> Specified offering does not exist. </p>', 'refs' => [], ], 'ResetDBClusterParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResetDBParameterGroupMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'ResourceNotFoundFault' => [ 'base' => '<p>The specified resource ID was not found. </p>', 'refs' => [], ], 'ResourcePendingMaintenanceActions' => [ 'base' => '<p>Describes the pending maintenance actions for a resource.</p>', 'refs' => [ 'ApplyPendingMaintenanceActionResult$ResourcePendingMaintenanceActions' => NULL, 'PendingMaintenanceActions$member' => NULL, ], ], 'RestoreDBClusterFromSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBClusterFromSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBClusterToPointInTimeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBClusterToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceFromDBSnapshotMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBInstanceFromDBSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreDBInstanceToPointInTimeMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RestoreDBInstanceToPointInTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'RevokeDBSecurityGroupIngressMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'RevokeDBSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'SNSInvalidTopicFault' => [ 'base' => '<p>SNS has responded that there is a problem with the SND topic specified.</p>', 'refs' => [], ], 'SNSNoAuthorizationFault' => [ 'base' => '<p>You do not have permission to publish to the SNS topic ARN.</p>', 'refs' => [], ], 'SNSTopicArnNotFoundFault' => [ 'base' => '<p>The SNS topic ARN does not exist.</p>', 'refs' => [], ], 'SharedSnapshotQuotaExceededFault' => [ 'base' => '<p>You have exceeded the maximum number of account ids that you can share a manual DB snapshot with.</p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed number of DB snapshots. </p>', 'refs' => [], ], 'SourceIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateEventSubscriptionMessage$SourceIds' => '<p> The list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it cannot end with a hyphen or contain two consecutive hyphens. </p> <p>Constraints:</p> <ul> <li>If SourceIds are supplied, SourceType must also be provided.</li> <li>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</li> <li>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</li> <li>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</li> <li>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</li> </ul>', 'EventSubscription$SourceIdsList' => '<p>A list of source IDs for the RDS event notification subscription.</p>', ], ], 'SourceNotFoundFault' => [ 'base' => '<p>The requested source could not be found.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p> The event source to retrieve events for. If no value is specified, all events are returned. </p>', 'Event$SourceType' => '<p> Specifies the source type for this event. </p>', ], ], 'StorageQuotaExceededFault' => [ 'base' => '<p> Request would result in user exceeding the allowed amount of storage available across all DB instances. </p>', 'refs' => [], ], 'StorageTypeNotSupportedFault' => [ 'base' => '<p> <i>StorageType</i> specified cannot be associated with the DB Instance. </p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccountQuota$AccountQuotaName' => '<p>The name of the Amazon RDS quota for this AWS account.</p>', 'AddSourceIdentifierToSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to add a source identifier to.</p>', 'AddSourceIdentifierToSubscriptionMessage$SourceIdentifier' => '<p> The identifier of the event source to be added. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it cannot end with a hyphen or contain two consecutive hyphens. </p> <p>Constraints:</p> <ul> <li>If the source type is a DB instance, then a <code>DBInstanceIdentifier</code> must be supplied.</li> <li>If the source type is a DB security group, a <code>DBSecurityGroupName</code> must be supplied.</li> <li>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> must be supplied.</li> <li>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> must be supplied.</li> </ul>', 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon RDS resource the tags will be added to. This value is an Amazon Resource Name (ARN]. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ResourceIdentifier' => '<p>The RDS Amazon Resource Name (ARN] of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>.</p>', 'ApplyPendingMaintenanceActionMessage$ApplyAction' => '<p>The pending maintenance action to apply to this resource.</p>', 'ApplyPendingMaintenanceActionMessage$OptInType' => '<p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> cannot be undone.</p> <p>Valid values:</p> <ul> <li> <code>immediate</code> - Apply the maintenance action immediately.</li> <li> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</li> <li> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</li> </ul>', 'AttributeValueList$member' => NULL, 'AuthorizeDBSecurityGroupIngressMessage$DBSecurityGroupName' => '<p> The name of the DB security group to add authorization to. </p>', 'AuthorizeDBSecurityGroupIngressMessage$CIDRIP' => '<p> The IP range to authorize. </p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p> Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupId' => '<p> Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'AuthorizeDBSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p> AWS account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The AWS Access Key ID is not an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'AvailabilityZone$Name' => '<p> The name of the availability zone. </p>', 'AvailabilityZones$member' => NULL, 'Certificate$CertificateIdentifier' => '<p>The unique key that identifies a certificate. </p>', 'Certificate$CertificateType' => '<p>The type of the certificate. </p>', 'Certificate$Thumbprint' => '<p>The thumbprint of the certificate. </p>', 'CertificateMessage$Marker' => '<p> An optional pagination token provided by a previous <a>DescribeCertificates</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'CharacterSet$CharacterSetName' => '<p> The name of the character set. </p>', 'CharacterSet$CharacterSetDescription' => '<p> The description of the character set. </p>', 'CopyDBClusterSnapshotMessage$SourceDBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>my-cluster-snapshot1</code></p>', 'CopyDBClusterSnapshotMessage$TargetDBClusterSnapshotIdentifier' => '<p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>my-cluster-snapshot2</code></p>', 'CopyDBParameterGroupMessage$SourceDBParameterGroupIdentifier' => '<p> The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>. </p> <p>Constraints:</p> <ul> <li>Must specify a valid DB parameter group.</li> <li>If the source DB parameter group is in the same region as the copy, specify a valid DB parameter group identifier, for example <code>my-db-param-group</code>, or a valid ARN.</li> <li>If the source DB parameter group is in a different region than the copy, specify a valid DB parameter group ARN, for example <code>arn:aws:rds:us-west-2:123456789012:pg:special-parameters</code>.</li> </ul>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupIdentifier' => '<p>The identifier for the copied DB parameter group.</p> <p>Constraints:</p> <ul> <li>Cannot be null, empty, or blank</li> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-db-parameter-group</code></p>', 'CopyDBParameterGroupMessage$TargetDBParameterGroupDescription' => '<p>A description for the copied DB parameter group.</p>', 'CopyDBSnapshotMessage$SourceDBSnapshotIdentifier' => '<p> The identifier for the source DB snapshot. </p> <p>If you are copying from a shared manual DB snapshot, this must be the ARN of the shared DB snapshot.</p> <p>Constraints:</p> <ul> <li>Must specify a valid system snapshot in the "available" state.</li> <li>If the source snapshot is in the same region as the copy, specify a valid DB snapshot identifier.</li> <li>If the source snapshot is in a different region than the copy, specify a valid DB snapshot ARN. For more information, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html"> Copying a DB Snapshot</a>.</li> </ul> <p>Example: <code>rds:mydb-2012-04-02-00-01</code></p> <p>Example: <code>arn:aws:rds:rr-regn-1:123456789012:snapshot:mysql-instance1-snapshot-20130805</code></p>', 'CopyDBSnapshotMessage$TargetDBSnapshotIdentifier' => '<p> The identifier for the copied snapshot. </p> <p>Constraints:</p> <ul> <li>Cannot be null, empty, or blank</li> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-db-snapshot</code></p>', 'CopyOptionGroupMessage$SourceOptionGroupIdentifier' => '<p>The identifier or ARN for the source option group. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>. </p> <p>Constraints:</p> <ul> <li>Must specify a valid option group.</li> <li>If the source option group is in the same region as the copy, specify a valid option group identifier, for example <code>my-option-group</code>, or a valid ARN.</li> <li>If the source option group is in a different region than the copy, specify a valid option group ARN, for example <code>arn:aws:rds:us-west-2:123456789012:og:special-options</code>.</li> </ul>', 'CopyOptionGroupMessage$TargetOptionGroupIdentifier' => '<p>The identifier for the copied option group. </p> <p>Constraints:</p> <ul> <li>Cannot be null, empty, or blank</li> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-option-group</code></p>', 'CopyOptionGroupMessage$TargetOptionGroupDescription' => '<p>The description for the copied option group. </p>', 'CreateDBClusterMessage$CharacterSetName' => '<p>A value that indicates that the DB cluster should be associated with the specified CharacterSet. </p>', 'CreateDBClusterMessage$DatabaseName' => '<p>The name for your database of up to 8 alpha-numeric characters. If you do not provide a name, Amazon RDS will not create a database in the DB cluster you are creating.</p>', 'CreateDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier. This parameter is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>my-cluster1</code></p>', 'CreateDBClusterMessage$DBClusterParameterGroupName' => '<p> The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, <code>default.aurora5.6</code> for the specified engine will be used. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'CreateDBClusterMessage$DBSubnetGroupName' => '<p>A DB subnet group to associate with this DB cluster. </p>', 'CreateDBClusterMessage$Engine' => '<p>The name of the database engine to be used for this DB cluster. </p> <p>Valid Values: <code>aurora</code></p>', 'CreateDBClusterMessage$EngineVersion' => '<p>The version number of the database engine to use. </p> <p> <b>Aurora</b> </p> <p>Example: <code>5.6.10a</code></p>', 'CreateDBClusterMessage$MasterUsername' => '<p> The name of the master user for the client DB cluster. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 16 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul>', 'CreateDBClusterMessage$MasterUserPassword' => '<p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@". </p> <p>Constraints: Must contain from 8 to 41 characters. </p>', 'CreateDBClusterMessage$OptionGroupName' => '<p>A value that indicates that the DB cluster should be associated with the specified option group. </p> <p>Permanent options cannot be removed from an option group. The option group cannot be removed from a DB cluster once it is associated with a DB cluster. </p>', 'CreateDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter. </p> <p>Default: A 30-minute window selected at random from an 8-hour block of time per region. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li> <li>Times should be in Universal Coordinated Time (UTC].</li> <li>Must not conflict with the preferred maintenance window.</li> <li>Must be at least 30 minutes.</li> </ul>', 'CreateDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC]. </p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code></p> <p>Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBClusterMessage$KmsKeyId' => '<p>The KMS key identifier for an encrypted DB cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN] for the KMS encryption key. If you are creating a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p> <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.</p>', 'CreateDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p> The name of the DB cluster parameter group. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <note>This value is stored as a lowercase string.</note>', 'CreateDBClusterParameterGroupMessage$DBParameterGroupFamily' => '<p> The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family. </p>', 'CreateDBClusterParameterGroupMessage$Description' => '<p> The description for the DB cluster parameter group. </p>', 'CreateDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>my-cluster1-snapshot1</code></p>', 'CreateDBClusterSnapshotMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster to create a snapshot for. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>my-cluster1</code></p>', 'CreateDBInstanceMessage$DBName' => '<p>The meaning of this parameter differs according to the database engine you use.</p> <p>Type: String</p> <p> <b>MySQL</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. </p> <p>Constraints:</p> <ul> <li>Must contain 1 to 64 alphanumeric characters</li> <li>Cannot be a word reserved by the specified database engine</li> </ul> <p> <b>MariaDB</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance. </p> <p>Constraints:</p> <ul> <li>Must contain 1 to 64 alphanumeric characters</li> <li>Cannot be a word reserved by the specified database engine</li> </ul> <p> <b>PostgreSQL</b> </p> <p>The name of the database to create when the DB instance is created. If this parameter is not specified, the default "postgres" database is created in the DB instance. </p> <p>Constraints:</p> <ul> <li>Must contain 1 to 63 alphanumeric characters</li> <li>Must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0-9].</li> <li>Cannot be a word reserved by the specified database engine</li> </ul> <p> <b>Oracle</b> </p> <p> The Oracle System ID (SID] of the created DB instance. </p> <p>Default: <code>ORCL</code></p> <p>Constraints:</p> <ul> <li>Cannot be longer than 8 characters</li> </ul> <p> <b>SQL Server</b> </p> <p>Not applicable. Must be null.</p> <p> <b>Amazon Aurora</b> </p> <p>The name of the database to create when the primary instance of the DB cluster is created. If this parameter is not specified, no database is created in the DB instance. </p> <p>Constraints:</p> <ul> <li>Must contain 1 to 64 alphanumeric characters</li> <li>Cannot be a word reserved by the specified database engine</li> </ul>', 'CreateDBInstanceMessage$DBInstanceIdentifier' => '<p> The DB instance identifier. This parameter is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens (1 to 15 for SQL Server].</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul> <p>Example: <code>mydbinstance</code></p>', 'CreateDBInstanceMessage$DBInstanceClass' => '<p> The compute and memory capacity of the DB instance. </p> <p> Valid Values: <code>db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.xlarge |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large</code></p>', 'CreateDBInstanceMessage$Engine' => '<p> The name of the database engine to be used for this instance. </p> <p> Valid Values: <code>MySQL</code> | <code>mariadb</code> | <code>oracle-se1</code> | <code>oracle-se</code> | <code>oracle-ee</code> | <code>sqlserver-ee</code> | <code>sqlserver-se</code> | <code>sqlserver-ex</code> | <code>sqlserver-web</code> | <code>postgres</code> | <code>aurora</code></p> <p> Not every database engine is available for every AWS region. </p>', 'CreateDBInstanceMessage$MasterUsername' => '<p> The name of master user for the client DB instance. </p> <p> <b>MySQL</b> </p> <p>Constraints:</p> <ul> <li>Must be 1 to 16 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul> <p> <b>MariaDB</b> </p> <p>Constraints:</p> <ul> <li>Must be 1 to 16 alphanumeric characters.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul> <p>Type: String</p> <p> <b>Oracle</b> </p> <p>Constraints:</p> <ul> <li>Must be 1 to 30 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul> <p> <b>SQL Server</b> </p> <p>Constraints:</p> <ul> <li>Must be 1 to 128 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul> <p> <b>PostgreSQL</b> </p> <p>Constraints:</p> <ul> <li>Must be 1 to 63 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot be a reserved word for the chosen database engine.</li> </ul>', 'CreateDBInstanceMessage$MasterUserPassword' => '<p> The password for the master database user. Can be any printable ASCII character except "/", """, or "@". </p> <p>Type: String</p> <p> <b>MySQL</b> </p> <p> Constraints: Must contain from 8 to 41 characters. </p> <p> <b>MariaDB</b> </p> <p> Constraints: Must contain from 8 to 41 characters. </p> <p> <b>Oracle</b> </p> <p> Constraints: Must contain from 8 to 30 characters. </p> <p> <b>SQL Server</b> </p> <p> Constraints: Must contain from 8 to 128 characters. </p> <p> <b>PostgreSQL</b> </p> <p> Constraints: Must contain from 8 to 128 characters. </p> <p> <b>Amazon Aurora</b> </p> <p> Constraints: Must contain from 8 to 41 characters. </p>', 'CreateDBInstanceMessage$AvailabilityZone' => '<p> The EC2 Availability Zone that the database instance will be created in. For information on regions and Availability Zones, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>. </p> <p> Default: A random, system-chosen Availability Zone in the endpoint\'s region. </p> <p> Example: <code>us-east-1d</code></p> <p> Constraint: The AvailabilityZone parameter cannot be specified if the MultiAZ parameter is set to <code>true</code>. The specified Availability Zone must be in the same region as the current endpoint. </p>', 'CreateDBInstanceMessage$DBSubnetGroupName' => '<p> A DB subnet group to associate with this DB instance. </p> <p> If there is no DB subnet group, then it is a non-VPC DB instance. </p>', 'CreateDBInstanceMessage$PreferredMaintenanceWindow' => '<p> The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC]. For more information, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBMaintenance.html">DB Instance Maintenance</a>. </p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code></p> <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'CreateDBInstanceMessage$DBParameterGroupName' => '<p> The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine will be used. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'CreateDBInstanceMessage$PreferredBackupWindow' => '<p> The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. For more information, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.BackingUpAndRestoringAmazonRDSInstances.html">DB Instance Backups</a>. </p> <p> Default: A 30-minute window selected at random from an 8-hour block of time per region. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints: </p> <ul> <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li> <li>Times should be in Universal Coordinated Time (UTC].</li> <li>Must not conflict with the preferred maintenance window.</li> <li>Must be at least 30 minutes.</li> </ul>', 'CreateDBInstanceMessage$EngineVersion' => '<p> The version number of the database engine to use. </p> <p> The following are the database engines and major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS region. </p> <p><b>MySQL</b></p> <ul> <li><b>Version 5.1 (Only available in the following regions: ap-northeast-1, ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2]:</b> <code> 5.1.73a | 5.1.73b</code></li> <li><b>Version 5.5 (Only available in the following regions: ap-northeast-1, ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2]:</b> <code> 5.5.40 | 5.5.40a</code></li> <li><b>Version 5.5 (Available in all regions]:</b> <code> 5.5.40b | 5.5.41 | 5.5.42</code></li> <li><b>Version 5.6 (Available in all regions]:</b> <code> 5.6.19a | 5.6.19b | 5.6.21 | 5.6.21b | 5.6.22 | 5.6.23</code></li> </ul> <p><b>MariaDB</b></p> <ul> <li><b>Version 10.0 (Available in all regions except AWS GovCloud (US] Region (us-gov-west-1]]:</b> <code> 10.0.17 </code></li> </ul> <p><b>Oracle Database Enterprise Edition (oracle-ee]</b></p> <ul> <li><b>Version 11.2 (Only available in the following regions: ap-northeast-1, ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2]:</b> <code> 11.2.0.2.v3 | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7</code></li> <li><b>Version 11.2 (Available in all regions]:</b> <code> 11.2.0.3.v1 | 11.2.0.3.v2 | 11.2.0.3.v3 | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4</code></li> <li><b>Version 12.1 (Available in all regions]:</b> <code>12.1.0.1.v1 | 12.1.0.1.v2 | 12.1.0.2.v1 </code></li> </ul> <p><b>Oracle Database Standard Edition (oracle-se]</b></p> <ul> <li><b>Version 11.2 (Only available in the following regions: us-west-1]:</b> <code> 11.2.0.2.v3 | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7</code></li> <li><b>Version 11.2 (Only available in the following regions: eu-central-1, us-west-1]:</b> <code> 11.2.0.3.v1 | 11.2.0.3.v2 | 11.2.0.3.v3 | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4</code></li> <li><b>Version 12.1 (Only available in the following regions: eu-central-1, us-west-1]:</b> <code>12.1.0.1.v1 | 12.1.0.1.v2</code></li> </ul> <p><b>Oracle Database Standard Edition One (oracle-se1]</b></p> <ul> <li><b>Version 11.2 (Only available in the following regions: us-west-1]:</b> <code> 11.2.0.2.v3 | 11.2.0.2.v4 | 11.2.0.2.v5 | 11.2.0.2.v6 | 11.2.0.2.v7</code></li> <li><b>Version 11.2 (Only available in the following regions: eu-central-1, us-west-1]:</b> <code> 11.2.0.3.v1 | 11.2.0.3.v2 | 11.2.0.3.v3 | 11.2.0.4.v1 | 11.2.0.4.v3 | 11.2.0.4.v4</code></li> <li><b>Version 12.1 (Only available in the following regions: eu-central-1, us-west-1]:</b> <code> 12.1.0.1.v1 | 12.1.0.1.v2</code></li> </ul> <p><b>PostgreSQL</b></p> <ul> <li><b>Version 9.3 (Only available in the following regions: ap-northeast-1, ap-southeast-1, ap-southeast-2, eu-west-1, sa-east-1, us-west-1, us-west-2]:</b> <code> 9.3.1 | 9.3.2</code></li> <li><b>Version 9.3 (Available in all regions]:</b> <code> 9.3.3 | 9.3.5 | 9.3.6 | 9.3.9 | 9.3.10</code></li> <li><b>Version 9.4 (Available in all regions]:</b> <code> 9.4.1 | 9.4.4 | 9.4.5</code></li> </ul> <p><b>Microsoft SQL Server Enterprise Edition (sqlserver-ee]</b></p> <ul> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.2789.0.v1</code></li> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.6000.34.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.2100.60.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.5058.0.v1</code></li> </ul> <p><b>Microsoft SQL Server Express Edition (sqlserver-ex]</b></p> <ul> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.2789.0.v1</code></li> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.6000.34.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.2100.60.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.5058.0.v1</code></li> <li><b>Version 12.00 (Available in all regions]:</b> <code> 12.00.4422.0.v1</code></li> </ul> <p><b>Microsoft SQL Server Standard Edition (sqlserver-se]</b></p> <ul> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.2789.0.v1</code></li> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.6000.34.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.2100.60.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.5058.0.v1</code></li> <li><b>Version 12.00 (Available in all regions]:</b> <code> 12.00.4422.0.v1</code></li> </ul> <p><b>Microsoft SQL Server Web Edition (sqlserver-web]</b></p> <ul> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.2789.0.v1</code></li> <li><b>Version 10.50 (Available in all regions]:</b> <code> 10.50.6000.34.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.2100.60.v1</code></li> <li><b>Version 11.00 (Available in all regions]:</b> <code> 11.00.5058.0.v1</code></li> <li><b>Version 12.00 (Available in all regions]:</b> <code> 12.00.4422.0.v1</code></li> </ul>', 'CreateDBInstanceMessage$LicenseModel' => '<p> License model information for this DB instance. </p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code></p>', 'CreateDBInstanceMessage$OptionGroupName' => '<p> Indicates that the DB instance should be associated with the specified option group. </p> <p> Permanent options, such as the TDE option for Oracle Advanced Security TDE, cannot be removed from an option group, and that option group cannot be removed from a DB instance once it is associated with a DB instance </p>', 'CreateDBInstanceMessage$CharacterSetName' => '<p> For supported engines, indicates that the DB instance should be associated with the specified CharacterSet. </p>', 'CreateDBInstanceMessage$DBClusterIdentifier' => '<p>The identifier of the DB cluster that the instance will belong to.</p> <p>For information on creating a DB cluster, see <a>CreateDBCluster</a>.</p> <p>Type: String</p>', 'CreateDBInstanceMessage$StorageType' => '<p> Specifies the storage type to be associated with the DB instance. </p> <p> Valid values: <code>standard | gp2 | io1</code></p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>standard</code></p>', 'CreateDBInstanceMessage$TdeCredentialArn' => '<p> The ARN from the Key Store with which to associate the instance for TDE encryption. </p>', 'CreateDBInstanceMessage$TdeCredentialPassword' => '<p> The password for the given ARN from the Key Store in order to access the device. </p>', 'CreateDBInstanceMessage$KmsKeyId' => '<p> The KMS key identifier for an encrypted DB instance. </p> <p>The KMS key identifier is the Amazon Resource Name (ARN] for the KMS encryption key. If you are creating a DB instance with the same AWS account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.</p> <p>If the <code>StorageEncrypted</code> parameter is true, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.</p>', 'CreateDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'CreateDBInstanceReadReplicaMessage$DBInstanceIdentifier' => '<p> The DB instance identifier of the Read Replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string. </p>', 'CreateDBInstanceReadReplicaMessage$SourceDBInstanceIdentifier' => '<p> The identifier of the DB instance that will act as the source for the Read Replica. Each DB instance can have up to five Read Replicas. </p> <p>Constraints:</p> <ul> <li>Must be the identifier of an existing MySQL, MariaDB, or PostgreSQL DB instance.</li> <li>Can specify a DB instance that is a MySQL Read Replica only if the source is running MySQL 5.6.</li> <li>Can specify a DB instance that is a PostgreSQL Read Replica only if the source is running PostgreSQL 9.3.5.</li> <li>The specified DB instance must have automatic backups enabled, its backup retention period must be greater than 0.</li> <li>If the source DB instance is in the same region as the Read Replica, specify a valid DB instance identifier.</li> <li>If the source DB instance is in a different region than the Read Replica, specify a valid DB instance ARN. For more information, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing a Amazon RDS Amazon Resource Name (ARN]</a>.</li> </ul>', 'CreateDBInstanceReadReplicaMessage$DBInstanceClass' => '<p> The compute and memory capacity of the Read Replica. </p> <p> Valid Values: <code>db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.xlarge |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large</code></p> <p>Default: Inherits from the source DB instance.</p>', 'CreateDBInstanceReadReplicaMessage$AvailabilityZone' => '<p> The Amazon EC2 Availability Zone that the Read Replica will be created in. </p> <p> Default: A random, system-chosen Availability Zone in the endpoint\'s region. </p> <p> Example: <code>us-east-1d</code></p>', 'CreateDBInstanceReadReplicaMessage$OptionGroupName' => '<p> The option group the DB instance will be associated with. If omitted, the default option group for the engine specified will be used. </p>', 'CreateDBInstanceReadReplicaMessage$DBSubnetGroupName' => '<p> Specifies a DB subnet group for the DB instance. The new DB instance will be created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance is not created in a VPC. </p> <p>Constraints:</p> <ul> <li>Can only be specified if the source DB instance identifier specifies a DB instance in another region.</li> <li>The specified DB subnet group must be in the same region in which the operation is running.</li> <li> All Read Replicas in one region that are created from the same source DB instance must either: <ul><li>Specify DB subnet groups from the same VPC. All these Read Replicas will be created in the same VPC.</li><li>Not specify a DB subnet group. All these Read Replicas will be created outside of any VPC.</li></ul></li> </ul>', 'CreateDBInstanceReadReplicaMessage$StorageType' => '<p> Specifies the storage type to be associated with the Read Replica. </p> <p> Valid values: <code>standard | gp2 | io1</code></p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>standard</code></p>', 'CreateDBInstanceReadReplicaMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'CreateDBParameterGroupMessage$DBParameterGroupName' => '<p> The name of the DB parameter group. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <note>This value is stored as a lowercase string.</note>', 'CreateDBParameterGroupMessage$DBParameterGroupFamily' => '<p> The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family. </p>', 'CreateDBParameterGroupMessage$Description' => '<p> The description for the DB parameter group. </p>', 'CreateDBSecurityGroupMessage$DBSecurityGroupName' => '<p> The name for the DB security group. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> <li>Must not be "Default"</li> <li>Cannot contain spaces</li> </ul> <p>Example: <code>mysecuritygroup</code></p>', 'CreateDBSecurityGroupMessage$DBSecurityGroupDescription' => '<p> The description for the DB security group. </p>', 'CreateDBSnapshotMessage$DBSnapshotIdentifier' => '<p> The identifier for the DB snapshot. </p> <p>Constraints:</p> <ul> <li>Cannot be null, empty, or blank</li> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-snapshot-id</code></p>', 'CreateDBSnapshotMessage$DBInstanceIdentifier' => '<p> The DB instance identifier. This is the unique key that identifies a DB instance. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'CreateDBSubnetGroupMessage$DBSubnetGroupName' => '<p> The name for the DB subnet group. This value is stored as a lowercase string. </p> <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, underscores, or hyphens. Must not be default.</p> <p>Example: <code>mySubnetgroup</code></p>', 'CreateDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p> The description for the DB subnet group. </p>', 'CreateEventSubscriptionMessage$SubscriptionName' => '<p>The name of the subscription. </p> <p>Constraints: The name must be less than 255 characters. </p>', 'CreateEventSubscriptionMessage$SnsTopicArn' => '<p> The Amazon Resource Name (ARN] of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>', 'CreateEventSubscriptionMessage$SourceType' => '<p> The type of source that will be generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned. </p> <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>', 'CreateOptionGroupMessage$OptionGroupName' => '<p> Specifies the name of the option group to be created. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>myoptiongroup</code></p>', 'CreateOptionGroupMessage$EngineName' => '<p> Specifies the name of the engine that this option group should be associated with. </p>', 'CreateOptionGroupMessage$MajorEngineVersion' => '<p> Specifies the major version of the engine that this option group should be associated with. </p>', 'CreateOptionGroupMessage$OptionGroupDescription' => '<p> The description of the option group. </p>', 'DBCluster$CharacterSetName' => '<p>If present, specifies the name of the character set that this cluster is associated with. </p>', 'DBCluster$DatabaseName' => '<p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster. </p>', 'DBCluster$DBClusterIdentifier' => '<p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster. </p>', 'DBCluster$DBClusterParameterGroup' => '<p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>', 'DBCluster$DBSubnetGroup' => '<p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group. </p>', 'DBCluster$Status' => '<p>Specifies the current state of this DB cluster. </p>', 'DBCluster$PercentProgress' => '<p>Specifies the progress of the operation as a percentage. </p>', 'DBCluster$Endpoint' => '<p>Specifies the connection endpoint for the primary instance of the DB cluster. </p>', 'DBCluster$Engine' => '<p>Provides the name of the database engine to be used for this DB cluster. </p>', 'DBCluster$EngineVersion' => '<p>Indicates the database engine version. </p>', 'DBCluster$MasterUsername' => '<p>Contains the master username for the DB cluster. </p>', 'DBCluster$PreferredBackupWindow' => '<p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>', 'DBCluster$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC]. </p>', 'DBCluster$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'DBCluster$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB cluster.</p>', 'DBCluster$DbClusterResourceId' => '<p>If <code>StorageEncrypted</code> is true, the region-unique, immutable identifier for the encrypted DB cluster. This identifier is found in AWS CloudTrail log entries whenever the KMS key for the DB cluster is accessed. </p>', 'DBClusterMember$DBInstanceIdentifier' => '<p>Specifies the instance identifier for this member of the DB cluster.</p>', 'DBClusterMember$DBClusterParameterGroupStatus' => '<p>Specifies the status of the DB cluster parameter group for this member of the DB cluster. </p>', 'DBClusterMessage$Marker' => '<p>A pagination token that can be used in a subsequent DescribeDBClusters request.</p>', 'DBClusterOptionGroupStatus$DBClusterOptionGroupName' => '<p>Specifies the name of the DB cluster option group.</p>', 'DBClusterOptionGroupStatus$Status' => '<p>Specifies the status of the DB cluster option group.</p>', 'DBClusterParameterGroup$DBClusterParameterGroupName' => '<p>Provides the name of the DB cluster parameter group. </p>', 'DBClusterParameterGroup$DBParameterGroupFamily' => '<p>Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with. </p>', 'DBClusterParameterGroup$Description' => '<p>Provides the customer-specified description for this DB cluster parameter group. </p>', 'DBClusterParameterGroupDetails$Marker' => '<p> An optional pagination token provided by a previous DescribeDBClusterParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'DBClusterParameterGroupNameMessage$DBClusterParameterGroupName' => '<p> The name of the DB cluster parameter group. </p> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <note>This value is stored as a lowercase string.</note>', 'DBClusterParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBClusterSnapshot$DBClusterSnapshotIdentifier' => '<p>Specifies the identifier for the DB cluster snapshot. </p>', 'DBClusterSnapshot$DBClusterIdentifier' => '<p>Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from. </p>', 'DBClusterSnapshot$Engine' => '<p>Specifies the name of the database engine. </p>', 'DBClusterSnapshot$Status' => '<p>Specifies the status of this DB cluster snapshot. </p>', 'DBClusterSnapshot$VpcId' => '<p>Provides the VPC ID associated with the DB cluster snapshot. </p>', 'DBClusterSnapshot$MasterUsername' => '<p>Provides the master username for the DB cluster snapshot. </p>', 'DBClusterSnapshot$EngineVersion' => '<p>Provides the version of the database engine for this DB cluster snapshot. </p>', 'DBClusterSnapshot$LicenseModel' => '<p>Provides the license model information for this DB cluster snapshot. </p>', 'DBClusterSnapshot$SnapshotType' => '<p>Provides the type of the DB cluster snapshot. </p>', 'DBClusterSnapshot$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB cluster snapshot.</p>', 'DBClusterSnapshotMessage$Marker' => '<p> An optional pagination token provided by a previous <a>DescribeDBClusterSnapshots</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBEngineVersion$Engine' => '<p> The name of the database engine. </p>', 'DBEngineVersion$EngineVersion' => '<p> The version number of the database engine. </p>', 'DBEngineVersion$DBParameterGroupFamily' => '<p> The name of the DB parameter group family for the database engine. </p>', 'DBEngineVersion$DBEngineDescription' => '<p> The description of the database engine. </p>', 'DBEngineVersion$DBEngineVersionDescription' => '<p> The description of the database engine version. </p>', 'DBEngineVersionMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBInstance$DBInstanceIdentifier' => '<p> Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance. </p>', 'DBInstance$DBInstanceClass' => '<p> Contains the name of the compute and memory capacity class of the DB instance. </p>', 'DBInstance$Engine' => '<p> Provides the name of the database engine to be used for this DB instance. </p>', 'DBInstance$DBInstanceStatus' => '<p> Specifies the current state of this database. </p>', 'DBInstance$MasterUsername' => '<p> Contains the master username for the DB instance. </p>', 'DBInstance$DBName' => '<p>The meaning of this parameter differs according to the database engine you use. For example, this value returns MySQL, MariaDB, or PostgreSQL information when returning values from CreateDBInstanceReadReplica since Read Replicas are only supported for these engines.</p> <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL, Amazon Aurora</b> </p> <p> Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance. </p> <p>Type: String</p> <p> <b>Oracle</b> </p> <p> Contains the Oracle System ID (SID] of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance. </p>', 'DBInstance$PreferredBackupWindow' => '<p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>', 'DBInstance$AvailabilityZone' => '<p> Specifies the name of the Availability Zone the DB instance is located in. </p>', 'DBInstance$PreferredMaintenanceWindow' => '<p> Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC]. </p>', 'DBInstance$EngineVersion' => '<p> Indicates the database engine version. </p>', 'DBInstance$ReadReplicaSourceDBInstanceIdentifier' => '<p> Contains the identifier of the source DB instance if this DB instance is a Read Replica. </p>', 'DBInstance$LicenseModel' => '<p> License model information for this DB instance. </p>', 'DBInstance$CharacterSetName' => '<p> If present, specifies the name of the character set that this instance is associated with. </p>', 'DBInstance$SecondaryAvailabilityZone' => '<p> If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support. </p>', 'DBInstance$StorageType' => '<p> Specifies the storage type associated with DB instance. </p>', 'DBInstance$TdeCredentialArn' => '<p> The ARN from the Key Store with which the instance is associated for TDE encryption. </p>', 'DBInstance$DBClusterIdentifier' => '<p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>', 'DBInstance$KmsKeyId' => '<p> If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance. </p>', 'DBInstance$DbiResourceId' => '<p> If <code>StorageEncrypted</code> is true, the region-unique, immutable identifier for the encrypted DB instance. This identifier is found in AWS CloudTrail log entries whenever the KMS key for the DB instance is accessed. </p>', 'DBInstance$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p>', 'DBInstance$EnhancedMonitoringResourceArn' => '<p>The Amazon Resource Name (ARN] of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>', 'DBInstance$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to CloudWatch Logs.</p>', 'DBInstanceMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'DBInstanceStatusInfo$StatusType' => '<p> This value is currently "read replication." </p>', 'DBInstanceStatusInfo$Status' => '<p> Status of the DB instance. For a StatusType of read replica, the values can be replicating, error, stopped, or terminated. </p>', 'DBInstanceStatusInfo$Message' => '<p> Details of the error if there is an error for the instance. If the instance is not in an error state, this value is blank. </p>', 'DBParameterGroup$DBParameterGroupName' => '<p>Provides the name of the DB parameter group. </p>', 'DBParameterGroup$DBParameterGroupFamily' => '<p>Provides the name of the DB parameter group family that this DB parameter group is compatible with. </p>', 'DBParameterGroup$Description' => '<p>Provides the customer-specified description for this DB parameter group. </p>', 'DBParameterGroupDetails$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBParameterGroupNameMessage$DBParameterGroupName' => '<p> Provides the name of the DB parameter group. </p>', 'DBParameterGroupStatus$DBParameterGroupName' => '<p> The name of the DP parameter group. </p>', 'DBParameterGroupStatus$ParameterApplyStatus' => '<p> The status of parameter updates. </p>', 'DBParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBSecurityGroup$OwnerId' => '<p> Provides the AWS ID of the owner of a specific DB security group. </p>', 'DBSecurityGroup$DBSecurityGroupName' => '<p> Specifies the name of the DB security group. </p>', 'DBSecurityGroup$DBSecurityGroupDescription' => '<p> Provides the description of the DB security group. </p>', 'DBSecurityGroup$VpcId' => '<p> Provides the VpcId of the DB security group. </p>', 'DBSecurityGroupMembership$DBSecurityGroupName' => '<p> The name of the DB security group. </p>', 'DBSecurityGroupMembership$Status' => '<p> The status of the DB security group. </p>', 'DBSecurityGroupMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBSecurityGroupNameList$member' => NULL, 'DBSnapshot$DBSnapshotIdentifier' => '<p> Specifies the identifier for the DB snapshot. </p>', 'DBSnapshot$DBInstanceIdentifier' => '<p> Specifies the DB instance identifier of the DB instance this DB snapshot was created from. </p>', 'DBSnapshot$Engine' => '<p> Specifies the name of the database engine. </p>', 'DBSnapshot$Status' => '<p> Specifies the status of this DB snapshot. </p>', 'DBSnapshot$AvailabilityZone' => '<p> Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot. </p>', 'DBSnapshot$VpcId' => '<p> Provides the VPC ID associated with the DB snapshot. </p>', 'DBSnapshot$MasterUsername' => '<p> Provides the master username for the DB snapshot. </p>', 'DBSnapshot$EngineVersion' => '<p> Specifies the version of the database engine. </p>', 'DBSnapshot$LicenseModel' => '<p> License model information for the restored DB instance. </p>', 'DBSnapshot$SnapshotType' => '<p> Provides the type of the DB snapshot. </p>', 'DBSnapshot$OptionGroupName' => '<p> Provides the option group name for the DB snapshot. </p>', 'DBSnapshot$SourceRegion' => '<p> The region that the DB snapshot was created in or copied from. </p>', 'DBSnapshot$SourceDBSnapshotIdentifier' => '<p> The DB snapshot Arn that the DB snapshot was copied from. It only has value in case of cross customer or cross region copy. </p>', 'DBSnapshot$StorageType' => '<p> Specifies the storage type associated with DB Snapshot. </p>', 'DBSnapshot$TdeCredentialArn' => '<p> The ARN from the Key Store with which to associate the instance for TDE encryption. </p>', 'DBSnapshot$KmsKeyId' => '<p> If <code>Encrypted</code> is true, the KMS key identifier for the encrypted DB snapshot. </p>', 'DBSnapshotAttribute$AttributeName' => '<p>The name of the manual DB snapshot attribute.</p> <p>An attribute name of <code>restore</code> applies to the list of AWS accounts that have permission to copy or restore the manual DB snapshot.</p>', 'DBSnapshotAttributesResult$DBSnapshotIdentifier' => '<p>The identifier of the manual DB snapshot that the attributes apply to.</p>', 'DBSnapshotMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DBSubnetGroup$DBSubnetGroupName' => '<p> Specifies the name of the DB subnet group. </p>', 'DBSubnetGroup$DBSubnetGroupDescription' => '<p> Provides the description of the DB subnet group. </p>', 'DBSubnetGroup$VpcId' => '<p> Provides the VpcId of the DB subnet group. </p>', 'DBSubnetGroup$SubnetGroupStatus' => '<p> Provides the status of the DB subnet group. </p>', 'DBSubnetGroupMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DeleteDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DeleteDBClusterMessage$FinalDBSnapshotIdentifier' => '<p> The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is set to <code>false</code>. </p> <note> Specifying this parameter and also setting the <code>SkipFinalShapshot</code> parameter to true results in an error. </note> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DeleteDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p> The name of the DB cluster parameter group. </p> <p>Constraints:</p> <ul> <li>Must be the name of an existing DB cluster parameter group.</li> <li>You cannot delete a default DB cluster parameter group.</li> <li>Cannot be associated with any DB clusters.</li> </ul>', 'DeleteDBClusterSnapshotMessage$DBClusterSnapshotIdentifier' => '<p>The identifier of the DB cluster snapshot to delete. </p> <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>', 'DeleteDBInstanceMessage$DBInstanceIdentifier' => '<p> The DB instance identifier for the DB instance to be deleted. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DeleteDBInstanceMessage$FinalDBSnapshotIdentifier' => '<p> The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to <code>false</code>. </p> <note> Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error. </note> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> <li>Cannot be specified when deleting a Read Replica.</li> </ul>', 'DeleteDBParameterGroupMessage$DBParameterGroupName' => '<p> The name of the DB parameter group. </p> <p>Constraints:</p> <ul> <li>Must be the name of an existing DB parameter group</li> <li>You cannot delete a default DB parameter group</li> <li>Cannot be associated with any DB instances</li> </ul>', 'DeleteDBSecurityGroupMessage$DBSecurityGroupName' => '<p> The name of the DB security group to delete. </p> <note>You cannot delete the default DB security group.</note> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> <li>Must not be "Default"</li> <li>Cannot contain spaces</li> </ul>', 'DeleteDBSnapshotMessage$DBSnapshotIdentifier' => '<p> The DBSnapshot identifier. </p> <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>', 'DeleteDBSubnetGroupMessage$DBSubnetGroupName' => '<p> The name of the database subnet group to delete. </p> <note>You cannot delete the default subnet group.</note> <p> Constraints: </p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DeleteEventSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to delete.</p>', 'DeleteOptionGroupMessage$OptionGroupName' => '<p> The name of the option group to be deleted. </p> <note>You cannot delete default option groups.</note>', 'DescribeCertificatesMessage$CertificateIdentifier' => '<p> The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeCertificatesMessage$Marker' => '<p> An optional pagination token provided by a previous <a>DescribeCertificates</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClusterParameterGroupsMessage$DBClusterParameterGroupName' => '<p> The name of a specific DB cluster parameter group to return details for. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBClusterParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClusterParametersMessage$DBClusterParameterGroupName' => '<p> The name of a specific DB cluster parameter group to return parameter details for. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBClusterParametersMessage$Source' => '<p> A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>. </p>', 'DescribeDBClusterParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClusterSnapshotsMessage$DBClusterIdentifier' => '<p>A DB cluster identifier to retrieve the list of DB cluster snapshots for. This parameter cannot be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBClusterSnapshotsMessage$DBClusterSnapshotIdentifier' => '<p>A specific DB cluster snapshot identifier to describe. This parameter cannot be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> <li>If this is the identifier of an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</li> </ul>', 'DescribeDBClusterSnapshotsMessage$SnapshotType' => '<p>The type of DB cluster snapshots that will be returned. Values can be <code>automated</code> or <code>manual</code>. If this parameter is not specified, the returned results will include all snapshot types. </p>', 'DescribeDBClusterSnapshotsMessage$Marker' => '<p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBClustersMessage$DBClusterIdentifier' => '<p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBClustersMessage$Marker' => '<p> An optional pagination token provided by a previous <a>DescribeDBClusters</a> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBEngineVersionsMessage$Engine' => '<p> The database engine to return. </p>', 'DescribeDBEngineVersionsMessage$EngineVersion' => '<p> The database engine version to return. </p> <p>Example: <code>5.1.49</code></p>', 'DescribeDBEngineVersionsMessage$DBParameterGroupFamily' => '<p> The name of a specific DB parameter group family to return details for. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBEngineVersionsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBInstancesMessage$DBInstanceIdentifier' => '<p> The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBInstancesMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBLogFilesDetails$LogFileName' => '<p> The name of the log file for the specified DB instance. </p>', 'DescribeDBLogFilesMessage$DBInstanceIdentifier' => '<p> The customer-assigned name of the DB instance that contains the log files you want to list. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBLogFilesMessage$FilenameContains' => '<p> Filters the available log files for log file names that contain the specified string. </p>', 'DescribeDBLogFilesMessage$Marker' => '<p> The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords. </p>', 'DescribeDBLogFilesResponse$Marker' => '<p> A pagination token that can be used in a subsequent DescribeDBLogFiles request. </p>', 'DescribeDBParameterGroupsMessage$DBParameterGroupName' => '<p> The name of a specific DB parameter group to return details for. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBParameterGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBParametersMessage$DBParameterGroupName' => '<p> The name of a specific DB parameter group to return details for. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBParametersMessage$Source' => '<p> The parameter types to return. </p> <p>Default: All parameter types returned</p> <p>Valid Values: <code>user | system | engine-default</code></p>', 'DescribeDBParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBSecurityGroupsMessage$DBSecurityGroupName' => '<p> The name of the DB security group to return details for. </p>', 'DescribeDBSecurityGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBSnapshotAttributesMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot to modify the attributes for.</p>', 'DescribeDBSnapshotsMessage$DBInstanceIdentifier' => '<p> A DB instance identifier to retrieve the list of DB snapshots for. This parameter cannot be used in conjunction with <code>DBSnapshotIdentifier</code>. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DescribeDBSnapshotsMessage$DBSnapshotIdentifier' => '<p> A specific DB snapshot identifier to describe. This parameter cannot be used in conjunction with <code>DBInstanceIdentifier</code>. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> <li>If this is the identifier of an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</li> </ul>', 'DescribeDBSnapshotsMessage$SnapshotType' => '<p>The type of snapshots that will be returned. You can specify one of the following values:</p> <ul> <li><code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my AWS account.</li> <li><code>manual</code> - Return all DB snapshots that have been taken by my AWS account.</li> <li><code>shared</code> - Return all manual DB snapshots that have been shared to my AWS account.</li> <li><code>public</code> - Return all DB snapshots that have been marked as public.</li> </ul> <p>If you do not specify a <code>SnapshotType</code>, then both automated and manual snapshots are returned. You can include shared snapshots with these results by setting the <code>IncludeShared</code> parameter to <code>true</code>. You can include public snapshots with these results by setting the <code>IncludePublic</code> parameter to <code>true</code>.</p> <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters do not apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter does not apply when <code>SnapshotType</code> is set to <code>shared</code>. the <code>IncludeShared</code> parameter does not apply when <code>SnapshotType</code> is set to <code>public</code>.</p>', 'DescribeDBSnapshotsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeDBSubnetGroupsMessage$DBSubnetGroupName' => '<p> The name of the DB subnet group to return details for. </p>', 'DescribeDBSubnetGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEngineDefaultClusterParametersMessage$DBParameterGroupFamily' => '<p> The name of the DB cluster parameter group family to return engine parameter information for. </p>', 'DescribeEngineDefaultClusterParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEngineDefaultParametersMessage$DBParameterGroupFamily' => '<p> The name of the DB parameter group family. </p>', 'DescribeEngineDefaultParametersMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeEventCategoriesMessage$SourceType' => '<p> The type of source that will be generating the events. </p> <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>', 'DescribeEventSubscriptionsMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to describe.</p>', 'DescribeEventSubscriptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'DescribeEventsMessage$SourceIdentifier' => '<p> The identifier of the event source for which events will be returned. If not specified, then all sources are included in the response. </p> <p>Constraints:</p> <ul> <li>If SourceIdentifier is supplied, SourceType must also be provided.</li> <li>If the source type is <code>DBInstance</code>, then a <code>DBInstanceIdentifier</code> must be supplied.</li> <li>If the source type is <code>DBSecurityGroup</code>, a <code>DBSecurityGroupName</code> must be supplied.</li> <li>If the source type is <code>DBParameterGroup</code>, a <code>DBParameterGroupName</code> must be supplied.</li> <li>If the source type is <code>DBSnapshot</code>, a <code>DBSnapshotIdentifier</code> must be supplied.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul>', 'DescribeEventsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeOptionGroupOptionsMessage$EngineName' => '<p> A required parameter. Options available for the given engine name will be described. </p>', 'DescribeOptionGroupOptionsMessage$MajorEngineVersion' => '<p> If specified, filters the results to include only options for the specified major engine version. </p>', 'DescribeOptionGroupOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeOptionGroupsMessage$OptionGroupName' => '<p> The name of the option group to describe. Cannot be supplied together with EngineName or MajorEngineVersion. </p>', 'DescribeOptionGroupsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeOptionGroupsMessage$EngineName' => '<p> Filters the list of option groups to only include groups associated with a specific database engine. </p>', 'DescribeOptionGroupsMessage$MajorEngineVersion' => '<p> Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified. </p>', 'DescribeOrderableDBInstanceOptionsMessage$Engine' => '<p> The name of the engine to retrieve DB instance options for. </p>', 'DescribeOrderableDBInstanceOptionsMessage$EngineVersion' => '<p> The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version. </p>', 'DescribeOrderableDBInstanceOptionsMessage$DBInstanceClass' => '<p> The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class. </p>', 'DescribeOrderableDBInstanceOptionsMessage$LicenseModel' => '<p> The license model filter value. Specify this parameter to show only the available offerings matching the specified license model. </p>', 'DescribeOrderableDBInstanceOptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'DescribePendingMaintenanceActionsMessage$ResourceIdentifier' => '<p>The ARN of a resource to return pending maintenance actions for.</p>', 'DescribePendingMaintenanceActionsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>. </p>', 'DescribeReservedDBInstancesMessage$ReservedDBInstanceId' => '<p> The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID. </p>', 'DescribeReservedDBInstancesMessage$ReservedDBInstancesOfferingId' => '<p> The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier. </p>', 'DescribeReservedDBInstancesMessage$DBInstanceClass' => '<p> The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class. </p>', 'DescribeReservedDBInstancesMessage$Duration' => '<p> The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration. </p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code></p>', 'DescribeReservedDBInstancesMessage$ProductDescription' => '<p> The product description filter value. Specify this parameter to show only those reservations matching the specified product description. </p>', 'DescribeReservedDBInstancesMessage$OfferingType' => '<p> The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type. </p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code></p>', 'DescribeReservedDBInstancesMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeReservedDBInstancesOfferingsMessage$ReservedDBInstancesOfferingId' => '<p> The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier. </p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code></p>', 'DescribeReservedDBInstancesOfferingsMessage$DBInstanceClass' => '<p> The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class. </p>', 'DescribeReservedDBInstancesOfferingsMessage$Duration' => '<p> Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration. </p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code></p>', 'DescribeReservedDBInstancesOfferingsMessage$ProductDescription' => '<p> Product description filter value. Specify this parameter to show only the available offerings matching the specified product description. </p>', 'DescribeReservedDBInstancesOfferingsMessage$OfferingType' => '<p> The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type. </p> <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code></p>', 'DescribeReservedDBInstancesOfferingsMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DownloadDBLogFilePortionDetails$LogFileData' => '<p> Entries from the specified log file. </p>', 'DownloadDBLogFilePortionDetails$Marker' => '<p> A pagination token that can be used in a subsequent DownloadDBLogFilePortion request. </p>', 'DownloadDBLogFilePortionMessage$DBInstanceIdentifier' => '<p> The customer-assigned name of the DB instance that contains the log files you want to list. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'DownloadDBLogFilePortionMessage$LogFileName' => '<p> The name of the log file to be downloaded. </p>', 'DownloadDBLogFilePortionMessage$Marker' => '<p> The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines. </p>', 'EC2SecurityGroup$Status' => '<p> Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked". </p>', 'EC2SecurityGroup$EC2SecurityGroupName' => '<p> Specifies the name of the EC2 security group. </p>', 'EC2SecurityGroup$EC2SecurityGroupId' => '<p> Specifies the id of the EC2 security group. </p>', 'EC2SecurityGroup$EC2SecurityGroupOwnerId' => '<p> Specifies the AWS ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>', 'Endpoint$Address' => '<p> Specifies the DNS address of the DB instance. </p>', 'Endpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'EngineDefaults$DBParameterGroupFamily' => '<p> Specifies the name of the DB parameter group family that the engine default parameters apply to. </p>', 'EngineDefaults$Marker' => '<p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'Event$SourceIdentifier' => '<p> Provides the identifier for the source of the event. </p>', 'Event$Message' => '<p> Provides the text of this event. </p>', 'EventCategoriesList$member' => NULL, 'EventCategoriesMap$SourceType' => '<p>The source type that the returned categories belong to</p>', 'EventSubscription$CustomerAwsId' => '<p>The AWS customer account associated with the RDS event notification subscription.</p>', 'EventSubscription$CustSubscriptionId' => '<p>The RDS event notification subscription Id.</p>', 'EventSubscription$SnsTopicArn' => '<p>The topic ARN of the RDS event notification subscription.</p>', 'EventSubscription$Status' => '<p>The status of the RDS event notification subscription.</p> <p>Constraints:</p> <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p> <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>', 'EventSubscription$SubscriptionCreationTime' => '<p>The time the RDS event notification subscription was created.</p>', 'EventSubscription$SourceType' => '<p>The source type for the RDS event notification subscription.</p>', 'EventSubscriptionsMessage$Marker' => '<p> An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'EventsMessage$Marker' => '<p> An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'FailoverDBClusterMessage$DBClusterIdentifier' => '<p>A DB cluster identifier to force a failover for. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'Filter$Name' => '<p>This parameter is not currently supported.</p>', 'FilterValueList$member' => NULL, 'IPRange$Status' => '<p> Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked". </p>', 'IPRange$CIDRIP' => '<p> Specifies the IP range. </p>', 'KeyList$member' => NULL, 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN]. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>.</p>', 'ModifyDBClusterMessage$DBClusterIdentifier' => '<p>The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must be the identifier for an existing DB cluster.</li> <li>Must contain from 1 to 63 alphanumeric characters or hyphens.</li> <li>First character must be a letter.</li> <li>Cannot end with a hyphen or contain two consecutive hyphens.</li> </ul>', 'ModifyDBClusterMessage$NewDBClusterIdentifier' => '<p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-cluster2</code></p>', 'ModifyDBClusterMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to use for the DB cluster.</p>', 'ModifyDBClusterMessage$MasterUserPassword' => '<p>The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@". </p> <p>Constraints: Must contain from 8 to 41 characters. </p>', 'ModifyDBClusterMessage$OptionGroupName' => '<p>A value that indicates that the DB cluster should be associated with the specified option group. Changing this parameter does not result in an outage except in the following case, and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second] period during which new connections are rejected but existing connections are not interrupted. </p> <p>Permanent options cannot be removed from an option group. The option group cannot be removed from a DB cluster once it is associated with a DB cluster. </p>', 'ModifyDBClusterMessage$PreferredBackupWindow' => '<p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p> <p>Default: A 30-minute window selected at random from an 8-hour block of time per region. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li> <li>Times should be in Universal Coordinated Time (UTC].</li> <li>Must not conflict with the preferred maintenance window.</li> <li>Must be at least 30 minutes.</li> </ul>', 'ModifyDBClusterMessage$PreferredMaintenanceWindow' => '<p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC]. </p> <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code></p> <p>Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p> <p>Constraints: Minimum 30-minute window.</p>', 'ModifyDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to modify.</p>', 'ModifyDBInstanceMessage$DBInstanceIdentifier' => '<p> The DB instance identifier. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must be the identifier for an existing DB instance</li> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'ModifyDBInstanceMessage$DBInstanceClass' => '<p> The new compute and memory capacity of the DB instance. To determine the instance classes that are available for a particular DB engine, use the <a>DescribeOrderableDBInstanceOptions</a> action. </p> <p> Passing a value for this setting causes an outage during the change and is applied during the next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request. </p> <p>Default: Uses existing setting</p> <p>Valid Values: <code>db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.xlarge | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large</code></p>', 'ModifyDBInstanceMessage$MasterUserPassword' => '<p> The new password for the DB instance master user. Can be any printable ASCII character except "/", """, or "@".</p> <p> Changing this parameter does not result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <p>Default: Uses existing setting</p> <p>Constraints: Must be 8 to 41 alphanumeric characters (MySQL, MariaDB, and Amazon Aurora], 8 to 30 alphanumeric characters (Oracle], or 8 to 128 alphanumeric characters (SQL Server].</p> <note> Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked. </note>', 'ModifyDBInstanceMessage$DBParameterGroupName' => '<p> The name of the DB parameter group to apply to the DB instance. Changing this setting does not result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window. </p> <p>Default: Uses existing setting</p> <p>Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.</p>', 'ModifyDBInstanceMessage$PreferredBackupWindow' => '<p> The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter does not result in an outage and the change is asynchronously applied as soon as possible. </p> <p>Constraints:</p> <ul> <li>Must be in the format hh24:mi-hh24:mi</li> <li>Times should be in Universal Time Coordinated (UTC]</li> <li>Must not conflict with the preferred maintenance window</li> <li>Must be at least 30 minutes</li> </ul>', 'ModifyDBInstanceMessage$PreferredMaintenanceWindow' => '<p> The weekly time range (in UTC] during which system maintenance can occur, which might result in an outage. Changing this parameter does not result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied. </p> <p>Default: Uses existing setting</p> <p>Format: ddd:hh24:mi-ddd:hh24:mi</p> <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p> <p>Constraints: Must be at least 30 minutes</p>', 'ModifyDBInstanceMessage$EngineVersion' => '<p> The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. </p> <p> For major version upgrades, if a non-default DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family. </p> <p>For a list of valid engine versions, see <a>CreateDBInstance</a>.</p>', 'ModifyDBInstanceMessage$OptionGroupName' => '<p> Indicates that the DB instance should be associated with the specified option group. Changing this parameter does not result in an outage except in the following case and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is set to <code>true</code> for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second] period during which new connections are rejected but existing connections are not interrupted. </p> <p> Permanent options, such as the TDE option for Oracle Advanced Security TDE, cannot be removed from an option group, and that option group cannot be removed from a DB instance once it is associated with a DB instance </p>', 'ModifyDBInstanceMessage$NewDBInstanceIdentifier' => '<p> The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set <code>Apply Immediately</code> to true, or will occur during the next maintenance window if <code>Apply Immediately</code> to false. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'ModifyDBInstanceMessage$StorageType' => '<p> Specifies the storage type to be associated with the DB instance. </p> <p> Valid values: <code>standard | gp2 | io1</code></p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>standard</code></p>', 'ModifyDBInstanceMessage$TdeCredentialArn' => '<p> The ARN from the Key Store with which to associate the instance for TDE encryption. </p>', 'ModifyDBInstanceMessage$TdeCredentialPassword' => '<p> The password for the given ARN from the Key Store in order to access the device. </p>', 'ModifyDBInstanceMessage$CACertificateIdentifier' => '<p> Indicates the certificate that needs to be associated with the instance. </p>', 'ModifyDBInstanceMessage$MonitoringRoleArn' => '<p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a>.</p> <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>', 'ModifyDBParameterGroupMessage$DBParameterGroupName' => '<p> The name of the DB parameter group. </p> <p>Constraints:</p> <ul> <li>Must be the name of an existing DB parameter group</li> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'ModifyDBSnapshotAttributeMessage$DBSnapshotIdentifier' => '<p>The identifier for the DB snapshot to modify the attributes for.</p>', 'ModifyDBSnapshotAttributeMessage$AttributeName' => '<p>The name of the DB snapshot attribute to modify.</p> <p>To manage authorization for other AWS accounts to copy or restore a manual DB snapshot, this value is <code>restore</code>.</p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupName' => '<p> The name for the DB subnet group. This value is stored as a lowercase string. </p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens. Must not be "Default".</p> <p>Example: <code>mySubnetgroup</code></p>', 'ModifyDBSubnetGroupMessage$DBSubnetGroupDescription' => '<p> The description for the DB subnet group. </p>', 'ModifyEventSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription.</p>', 'ModifyEventSubscriptionMessage$SnsTopicArn' => '<p> The Amazon Resource Name (ARN] of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>', 'ModifyEventSubscriptionMessage$SourceType' => '<p> The type of source that will be generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned. </p> <p>Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot</p>', 'ModifyOptionGroupMessage$OptionGroupName' => '<p> The name of the option group to be modified. </p> <p> Permanent options, such as the TDE option for Oracle Advanced Security TDE, cannot be removed from an option group, and that option group cannot be removed from a DB instance once it is associated with a DB instance </p>', 'Option$OptionName' => '<p> The name of the option. </p>', 'Option$OptionDescription' => '<p> The description of the option. </p>', 'OptionConfiguration$OptionName' => '<p> The configuration of options to include in a group. </p>', 'OptionGroup$OptionGroupName' => '<p> Specifies the name of the option group. </p>', 'OptionGroup$OptionGroupDescription' => '<p>Provides a description of the option group. </p>', 'OptionGroup$EngineName' => '<p> Indicates the name of the engine that this option group can be applied to. </p>', 'OptionGroup$MajorEngineVersion' => '<p> Indicates the major engine version associated with this option group. </p>', 'OptionGroup$VpcId' => '<p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>', 'OptionGroupMembership$OptionGroupName' => '<p> The name of the option group that the instance belongs to. </p>', 'OptionGroupMembership$Status' => '<p> The status of the DB instance\'s option group membership (e.g. in-sync, pending, pending-maintenance, applying]. </p>', 'OptionGroupOption$Name' => '<p> The name of the option. </p>', 'OptionGroupOption$Description' => '<p> The description of the option. </p>', 'OptionGroupOption$EngineName' => '<p>The name of the engine that this option can be applied to. </p>', 'OptionGroupOption$MajorEngineVersion' => '<p> Indicates the major engine version that the option is available for. </p>', 'OptionGroupOption$MinimumRequiredMinorEngineVersion' => '<p> The minimum required engine version for the option to be applied. </p>', 'OptionGroupOptionSetting$SettingName' => '<p> The name of the option group option. </p>', 'OptionGroupOptionSetting$SettingDescription' => '<p> The description of the option group option. </p>', 'OptionGroupOptionSetting$DefaultValue' => '<p> The default value for the option group option. </p>', 'OptionGroupOptionSetting$ApplyType' => '<p> The DB engine specific parameter type for the option group option. </p>', 'OptionGroupOptionSetting$AllowedValues' => '<p> Indicates the acceptable values for the option group option. </p>', 'OptionGroupOptionsMessage$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'OptionGroups$Marker' => '<p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'OptionNamesList$member' => NULL, 'OptionSetting$Name' => '<p> The name of the option that has settings that you can set. </p>', 'OptionSetting$Value' => '<p> The current value of the option setting. </p>', 'OptionSetting$DefaultValue' => '<p> The default value of the option setting. </p>', 'OptionSetting$Description' => '<p> The description of the option setting. </p>', 'OptionSetting$ApplyType' => '<p> The DB engine specific parameter type. </p>', 'OptionSetting$DataType' => '<p> The data type of the option setting. </p>', 'OptionSetting$AllowedValues' => '<p> The allowed values of the option setting. </p>', 'OptionsDependedOn$member' => NULL, 'OrderableDBInstanceOption$Engine' => '<p> The engine type of the orderable DB instance. </p>', 'OrderableDBInstanceOption$EngineVersion' => '<p> The engine version of the orderable DB instance. </p>', 'OrderableDBInstanceOption$DBInstanceClass' => '<p> The DB instance class for the orderable DB instance. </p>', 'OrderableDBInstanceOption$LicenseModel' => '<p> The license model for the orderable DB instance. </p>', 'OrderableDBInstanceOption$StorageType' => '<p> Indicates the storage type for this orderable DB instance. </p>', 'OrderableDBInstanceOptionsMessage$Marker' => '<p> An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>', 'Parameter$ParameterName' => '<p> Specifies the name of the parameter. </p>', 'Parameter$ParameterValue' => '<p> Specifies the value of the parameter. </p>', 'Parameter$Description' => '<p> Provides a description of the parameter. </p>', 'Parameter$Source' => '<p> Indicates the source of the parameter value. </p>', 'Parameter$ApplyType' => '<p> Specifies the engine specific parameters type. </p>', 'Parameter$DataType' => '<p> Specifies the valid data type for the parameter. </p>', 'Parameter$AllowedValues' => '<p> Specifies the valid range of values for the parameter. </p>', 'Parameter$MinimumEngineVersion' => '<p> The earliest engine version to which the parameter can apply. </p>', 'PendingMaintenanceAction$Action' => '<p>The type of pending maintenance action that is available for the resource.</p>', 'PendingMaintenanceAction$OptInStatus' => '<p>Indicates the type of opt-in request that has been received for the resource.</p>', 'PendingMaintenanceAction$Description' => '<p>A description providing more detail about the maintenance action.</p>', 'PendingMaintenanceActionsMessage$Marker' => '<p> An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>. </p>', 'PendingModifiedValues$DBInstanceClass' => '<p> Contains the new <code>DBInstanceClass</code> for the DB instance that will be applied or is in progress. </p>', 'PendingModifiedValues$MasterUserPassword' => '<p> Contains the pending or in-progress change of the master credentials for the DB instance. </p>', 'PendingModifiedValues$EngineVersion' => '<p> Indicates the database engine version. </p>', 'PendingModifiedValues$DBInstanceIdentifier' => '<p> Contains the new <code>DBInstanceIdentifier</code> for the DB instance that will be applied or is in progress. </p>', 'PendingModifiedValues$StorageType' => '<p> Specifies the storage type to be associated with the DB instance. </p>', 'PendingModifiedValues$CACertificateIdentifier' => '<p>Specifies the identifier of the CA certificate for the DB instance.</p>', 'PromoteReadReplicaMessage$DBInstanceIdentifier' => '<p> The DB instance identifier. This value is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must be the identifier for an existing Read Replica DB instance</li> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>mydbinstance</code></p>', 'PromoteReadReplicaMessage$PreferredBackupWindow' => '<p> The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. </p> <p> Default: A 30-minute window selected at random from an 8-hour block of time per region. To see the time blocks available, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p> <p>Constraints:</p> <ul> <li>Must be in the format <code>hh24:mi-hh24:mi</code>.</li> <li>Times should be in Universal Coordinated Time (UTC].</li> <li>Must not conflict with the preferred maintenance window.</li> <li>Must be at least 30 minutes.</li> </ul>', 'PurchaseReservedDBInstancesOfferingMessage$ReservedDBInstancesOfferingId' => '<p> The ID of the Reserved DB instance offering to purchase. </p> <p>Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706</p>', 'PurchaseReservedDBInstancesOfferingMessage$ReservedDBInstanceId' => '<p> Customer-specified identifier to track this reservation. </p> <p>Example: myreservationID</p>', 'ReadReplicaDBInstanceIdentifierList$member' => NULL, 'RebootDBInstanceMessage$DBInstanceIdentifier' => '<p> The DB instance identifier. This parameter is stored as a lowercase string. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RecurringCharge$RecurringChargeFrequency' => '<p> The frequency of the recurring charge. </p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SubscriptionName' => '<p>The name of the RDS event notification subscription you want to remove a source identifier from.</p>', 'RemoveSourceIdentifierFromSubscriptionMessage$SourceIdentifier' => '<p> The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group. </p>', 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon RDS resource the tags will be removed from. This value is an Amazon Resource Name (ARN]. For information about creating an ARN, see <a href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN"> Constructing an RDS Amazon Resource Name (ARN]</a>.</p>', 'ReservedDBInstance$ReservedDBInstanceId' => '<p> The unique identifier for the reservation. </p>', 'ReservedDBInstance$ReservedDBInstancesOfferingId' => '<p> The offering identifier. </p>', 'ReservedDBInstance$DBInstanceClass' => '<p> The DB instance class for the reserved DB instance. </p>', 'ReservedDBInstance$CurrencyCode' => '<p> The currency code for the reserved DB instance. </p>', 'ReservedDBInstance$ProductDescription' => '<p> The description of the reserved DB instance. </p>', 'ReservedDBInstance$OfferingType' => '<p> The offering type of this reserved DB instance. </p>', 'ReservedDBInstance$State' => '<p> The state of the reserved DB instance. </p>', 'ReservedDBInstanceMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'ReservedDBInstancesOffering$ReservedDBInstancesOfferingId' => '<p> The offering identifier. </p>', 'ReservedDBInstancesOffering$DBInstanceClass' => '<p> The DB instance class for the reserved DB instance. </p>', 'ReservedDBInstancesOffering$CurrencyCode' => '<p> The currency code for the reserved DB instance offering. </p>', 'ReservedDBInstancesOffering$ProductDescription' => '<p> The database engine used by the offering. </p>', 'ReservedDBInstancesOffering$OfferingType' => '<p> The offering type. </p>', 'ReservedDBInstancesOfferingMessage$Marker' => '<p> An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'ResetDBClusterParameterGroupMessage$DBClusterParameterGroupName' => '<p>The name of the DB cluster parameter group to reset.</p>', 'ResetDBParameterGroupMessage$DBParameterGroupName' => '<p> The name of the DB parameter group. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'ResourcePendingMaintenanceActions$ResourceIdentifier' => '<p>The ARN of the resource that has pending maintenance actions.</p>', 'RestoreDBClusterFromSnapshotMessage$DBClusterIdentifier' => '<p>The name of the DB cluster to create from the DB cluster snapshot. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-snapshot-id</code></p>', 'RestoreDBClusterFromSnapshotMessage$SnapshotIdentifier' => '<p>The identifier for the DB cluster snapshot to restore from. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RestoreDBClusterFromSnapshotMessage$Engine' => '<p>The database engine to use for the new DB cluster. </p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p>', 'RestoreDBClusterFromSnapshotMessage$EngineVersion' => '<p>The version of the database engine to use for the new DB cluster.</p>', 'RestoreDBClusterFromSnapshotMessage$DBSubnetGroupName' => '<p>The name of the DB subnet group to use for the new DB cluster. </p>', 'RestoreDBClusterFromSnapshotMessage$DatabaseName' => '<p>The database name for the restored DB cluster. </p>', 'RestoreDBClusterFromSnapshotMessage$OptionGroupName' => '<p>The name of the option group to use for the restored DB cluster. </p>', 'RestoreDBClusterFromSnapshotMessage$KmsKeyId' => '<p>The KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster snapshot.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN] for the KMS encryption key. If you are restoring a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p> <ul> <li>If the DB cluster snapshot is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB cluster snapshot.</li> <li>If the DB cluster snapshot is not encrypted, then the restored DB cluster is not encrypted.</li> </ul> <p>If <code>SnapshotIdentifier</code> refers to a DB cluster snapshot that is not encrypted, and you specify a value for the <code>KmsKeyId</code> parameter, then the restore request is rejected.</p>', 'RestoreDBClusterToPointInTimeMessage$DBClusterIdentifier' => '<p> The name of the new DB cluster to be created. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RestoreDBClusterToPointInTimeMessage$SourceDBClusterIdentifier' => '<p> The identifier of the source DB cluster from which to restore. </p> <p>Constraints:</p> <ul> <li>Must be the identifier of an existing database instance</li> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RestoreDBClusterToPointInTimeMessage$DBSubnetGroupName' => '<p> The DB subnet group name to use for the new DB cluster. </p>', 'RestoreDBClusterToPointInTimeMessage$OptionGroupName' => '<p>The name of the option group for the new DB cluster.</p>', 'RestoreDBClusterToPointInTimeMessage$KmsKeyId' => '<p>The KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p> <p>The KMS key identifier is the Amazon Resource Name (ARN] for the KMS encryption key. If you are restoring a DB cluster with the same AWS account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.</p> <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster will be encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p> <p>If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following will occur:</p> <ul> <li>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</li> </ul> <li>If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.</li> <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that is note encrypted, then the restore request is rejected.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBInstanceIdentifier' => '<p> Name of the DB instance to create from the DB snapshot. This parameter isn\'t case-sensitive. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens (1 to 15 for SQL Server]</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>Example: <code>my-snapshot-id</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBSnapshotIdentifier' => '<p> The identifier for the DB snapshot to restore from. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 255 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBInstanceClass' => '<p> The compute and memory capacity of the Amazon RDS DB instance. </p> <p>Valid Values: <code>db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$AvailabilityZone' => '<p> The EC2 Availability Zone that the database instance will be created in. </p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ parameter is set to <code>true</code>.</p> <p>Example: <code>us-east-1a</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBSubnetGroupName' => '<p> The DB subnet group name to use for the new instance. </p>', 'RestoreDBInstanceFromDBSnapshotMessage$LicenseModel' => '<p> License model information for the restored DB instance. </p> <p> Default: Same as source. </p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$DBName' => '<p> The database name for the restored DB instance. </p> <note> <p>This parameter doesn\'t apply to the MySQL or MariaDB engines.</p> </note>', 'RestoreDBInstanceFromDBSnapshotMessage$Engine' => '<p> The database engine to use for the new instance. </p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p> <p> Valid Values: <code>MySQL</code> | <code>mariadb</code> | <code>oracle-se1</code> | <code>oracle-se</code> | <code>oracle-ee</code> | <code>sqlserver-ee</code> | <code>sqlserver-se</code> | <code>sqlserver-ex</code> | <code>sqlserver-web</code> | <code>postgres</code> | <code>aurora</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$OptionGroupName' => '<p>The name of the option group to be used for the restored DB instance.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, cannot be removed from an option group, and that option group cannot be removed from a DB instance once it is associated with a DB instance </p>', 'RestoreDBInstanceFromDBSnapshotMessage$StorageType' => '<p> Specifies the storage type to be associated with the DB instance. </p> <p> Valid values: <code>standard | gp2 | io1</code></p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>standard</code></p>', 'RestoreDBInstanceFromDBSnapshotMessage$TdeCredentialArn' => '<p> The ARN from the Key Store with which to associate the instance for TDE encryption. </p>', 'RestoreDBInstanceFromDBSnapshotMessage$TdeCredentialPassword' => '<p> The password for the given ARN from the Key Store in order to access the device. </p>', 'RestoreDBInstanceToPointInTimeMessage$SourceDBInstanceIdentifier' => '<p> The identifier of the source DB instance from which to restore. </p> <p>Constraints:</p> <ul> <li>Must be the identifier of an existing database instance</li> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$TargetDBInstanceIdentifier' => '<p> The name of the new database instance to be created. </p> <p>Constraints:</p> <ul> <li>Must contain from 1 to 63 alphanumeric characters or hyphens</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'RestoreDBInstanceToPointInTimeMessage$DBInstanceClass' => '<p> The compute and memory capacity of the Amazon RDS DB instance. </p> <p>Valid Values: <code>db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large</code></p> <p>Default: The same DBInstanceClass as the original DB instance.</p>', 'RestoreDBInstanceToPointInTimeMessage$AvailabilityZone' => '<p> The EC2 Availability Zone that the database instance will be created in. </p> <p>Default: A random, system-chosen Availability Zone.</p> <p>Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ parameter is set to true.</p> <p>Example: <code>us-east-1a</code></p>', 'RestoreDBInstanceToPointInTimeMessage$DBSubnetGroupName' => '<p> The DB subnet group name to use for the new instance. </p>', 'RestoreDBInstanceToPointInTimeMessage$LicenseModel' => '<p> License model information for the restored DB instance. </p> <p> Default: Same as source. </p> <p> Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code></p>', 'RestoreDBInstanceToPointInTimeMessage$DBName' => '<p> The database name for the restored DB instance. </p> <note> <p>This parameter is not used for the MySQL or MariaDB engines.</p> </note>', 'RestoreDBInstanceToPointInTimeMessage$Engine' => '<p> The database engine to use for the new instance. </p> <p>Default: The same as source</p> <p>Constraint: Must be compatible with the engine of the source</p> <p> Valid Values: <code>MySQL</code> | <code>mariadb</code> | <code>oracle-se1</code> | <code>oracle-se</code> | <code>oracle-ee</code> | <code>sqlserver-ee</code> | <code>sqlserver-se</code> | <code>sqlserver-ex</code> | <code>sqlserver-web</code> | <code>postgres</code>| <code>aurora</code></p>', 'RestoreDBInstanceToPointInTimeMessage$OptionGroupName' => '<p>The name of the option group to be used for the restored DB instance.</p> <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, cannot be removed from an option group, and that option group cannot be removed from a DB instance once it is associated with a DB instance </p>', 'RestoreDBInstanceToPointInTimeMessage$StorageType' => '<p> Specifies the storage type to be associated with the DB instance. </p> <p> Valid values: <code>standard | gp2 | io1</code></p> <p> If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter. </p> <p> Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>standard</code></p>', 'RestoreDBInstanceToPointInTimeMessage$TdeCredentialArn' => '<p> The ARN from the Key Store with which to associate the instance for TDE encryption. </p>', 'RestoreDBInstanceToPointInTimeMessage$TdeCredentialPassword' => '<p> The password for the given ARN from the Key Store in order to access the device. </p>', 'RevokeDBSecurityGroupIngressMessage$DBSecurityGroupName' => '<p> The name of the DB security group to revoke ingress from. </p>', 'RevokeDBSecurityGroupIngressMessage$CIDRIP' => '<p> The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and <code>EC2SecurityGroupOwnerId</code> cannot be provided. </p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p> The name of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupId' => '<p> The id of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'RevokeDBSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p> The AWS Account Number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The AWS Access Key ID is not an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided. </p>', 'SourceIdsList$member' => NULL, 'Subnet$SubnetIdentifier' => '<p> Specifies the identifier of the subnet. </p>', 'Subnet$SubnetStatus' => '<p> Specifies the status of the subnet. </p>', 'SubnetIdentifierList$member' => NULL, 'Tag$Key' => '<p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and cannot be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*]$"].</p>', 'Tag$Value' => '<p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and cannot be prefixed with "aws:" or "rds:". The string can only contain only the set of Unicode letters, digits, white-space, \'_\', \'.\', \'/\', \'=\', \'+\', \'-\' (Java regex: "^([\\\\p{L}\\\\p{Z}\\\\p{N}_.:/=+\\\\-]*]$"].</p>', 'UpgradeTarget$Engine' => '<p>The name of the upgrade target database engine. </p>', 'UpgradeTarget$EngineVersion' => '<p>The version number of the upgrade target database engine.</p>', 'UpgradeTarget$Description' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'VpcSecurityGroupMembership$Status' => '<p> The status of the VPC security group. </p>', ], ], 'Subnet' => [ 'base' => '<p> This data type is used as a response element in the <a>DescribeDBSubnetGroups</a> action. </p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetAlreadyInUse' => [ 'base' => '<p> The DB subnet is already in use in the Availability Zone. </p>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateDBSubnetGroupMessage$SubnetIds' => '<p> The EC2 Subnet IDs for the DB subnet group. </p>', 'ModifyDBSubnetGroupMessage$SubnetIds' => '<p> The EC2 subnet IDs for the DB subnet group. </p>', ], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'DBSubnetGroup$Subnets' => '<p> Contains a list of <a>Subnet</a> elements. </p>', ], ], 'SubscriptionAlreadyExistFault' => [ 'base' => '<p>The supplied subscription name already exists.</p>', 'refs' => [], ], 'SubscriptionCategoryNotFoundFault' => [ 'base' => '<p>The supplied category does not exist.</p>', 'refs' => [], ], 'SubscriptionNotFoundFault' => [ 'base' => '<p>The subscription name does not exist.</p>', 'refs' => [], ], 'SupportedCharacterSetsList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$SupportedCharacterSets' => '<p> A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the CreateDBInstance API. </p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'Certificate$ValidFrom' => '<p>The starting date from which the certificate is valid. </p>', 'Certificate$ValidTill' => '<p>The final date that the certificate continues to be valid. </p>', 'DBCluster$EarliestRestorableTime' => '<p>Specifies the earliest time to which a database can be restored with point-in-time restore. </p>', 'DBCluster$LatestRestorableTime' => '<p>Specifies the latest time to which a database can be restored with point-in-time restore. </p>', 'DBClusterSnapshot$SnapshotCreateTime' => '<p>Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC]. </p>', 'DBClusterSnapshot$ClusterCreateTime' => '<p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC]. </p>', 'DBInstance$InstanceCreateTime' => '<p> Provides the date and time the DB instance was created. </p>', 'DBInstance$LatestRestorableTime' => '<p> Specifies the latest time to which a database can be restored with point-in-time restore. </p>', 'DBSnapshot$SnapshotCreateTime' => '<p> Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC]. </p>', 'DBSnapshot$InstanceCreateTime' => '<p> Specifies the time when the snapshot was taken, in Universal Coordinated Time (UTC]. </p>', 'DescribeEventsMessage$StartTime' => '<p> The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a></p> <p>Example: 2009-07-08T18:00Z</p>', 'DescribeEventsMessage$EndTime' => '<p> The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a></p> <p>Example: 2009-07-08T18:00Z</p>', 'Event$Date' => '<p> Specifies the date and time of the event. </p>', 'PendingMaintenanceAction$AutoAppliedAfterDate' => '<p>The date of the maintenance window when the action will be applied. The maintenance action will be applied to the resource during its first maintenance window after this date. If this date is specified, any <code>next-maintenance</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$ForcedApplyDate' => '<p>The date when the maintenance action will be automatically applied. The maintenance action will be applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any <code>immediate</code> opt-in requests are ignored.</p>', 'PendingMaintenanceAction$CurrentApplyDate' => '<p>The effective date when the pending maintenance action will be applied to the resource. This date takes into account opt-in requests received from the <a>ApplyPendingMaintenanceAction</a> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>', 'ReservedDBInstance$StartTime' => '<p> The time the reservation started. </p>', 'RestoreDBClusterToPointInTimeMessage$RestoreToTime' => '<p> The date and time to restore the DB cluster to. </p> <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC] format</p> <p>Constraints:</p> <ul> <li>Must be before the latest restorable time for the DB instance</li> <li>Cannot be specified if <code>UseLatestRestorableTime</code> parameter is true</li> </ul> <p>Example: <code>2015-03-07T23:45:00Z</code></p>', 'RestoreDBInstanceToPointInTimeMessage$RestoreTime' => '<p> The date and time to restore from. </p> <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC] format</p> <p>Constraints:</p> <ul> <li>Must be before the latest restorable time for the DB instance</li> <li>Cannot be specified if UseLatestRestorableTime parameter is true</li> </ul> <p>Example: <code>2009-09-07T23:45:00Z</code></p>', ], ], 'Tag' => [ 'base' => '<p>Metadata assigned to an Amazon RDS resource consisting of a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => '<p>A list of tags.</p>', 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>The tags to be assigned to the Amazon RDS resource.</p>', 'CopyDBClusterSnapshotMessage$Tags' => NULL, 'CopyDBParameterGroupMessage$Tags' => NULL, 'CopyDBSnapshotMessage$Tags' => NULL, 'CopyOptionGroupMessage$Tags' => NULL, 'CreateDBClusterMessage$Tags' => NULL, 'CreateDBClusterParameterGroupMessage$Tags' => NULL, 'CreateDBClusterSnapshotMessage$Tags' => '<p>The tags to be assigned to the DB cluster snapshot.</p>', 'CreateDBInstanceMessage$Tags' => NULL, 'CreateDBInstanceReadReplicaMessage$Tags' => NULL, 'CreateDBParameterGroupMessage$Tags' => NULL, 'CreateDBSecurityGroupMessage$Tags' => NULL, 'CreateDBSnapshotMessage$Tags' => NULL, 'CreateDBSubnetGroupMessage$Tags' => NULL, 'CreateEventSubscriptionMessage$Tags' => NULL, 'CreateOptionGroupMessage$Tags' => NULL, 'PurchaseReservedDBInstancesOfferingMessage$Tags' => NULL, 'RestoreDBClusterFromSnapshotMessage$Tags' => '<p>The tags to be assigned to the restored DB cluster. </p>', 'RestoreDBClusterToPointInTimeMessage$Tags' => NULL, 'RestoreDBInstanceFromDBSnapshotMessage$Tags' => NULL, 'RestoreDBInstanceToPointInTimeMessage$Tags' => NULL, 'TagListMessage$TagList' => '<p>List of tags returned by the ListTagsForResource operation.</p>', ], ], 'TagListMessage' => [ 'base' => '<p/>', 'refs' => [], ], 'UpgradeTarget' => [ 'base' => '<p>The version of the database engine that a DB instance can be upgraded to.</p>', 'refs' => [ 'ValidUpgradeTargetList$member' => NULL, ], ], 'ValidUpgradeTargetList' => [ 'base' => NULL, 'refs' => [ 'DBEngineVersion$ValidUpgradeTarget' => '<p>A list of engine versions that this database engine version can be upgraded to.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateDBClusterMessage$VpcSecurityGroupIds' => '<p>A list of EC2 VPC security groups to associate with this DB cluster. </p>', 'CreateDBInstanceMessage$VpcSecurityGroupIds' => '<p> A list of EC2 VPC security groups to associate with this DB instance. </p> <p> Default: The default EC2 VPC security group for the DB subnet group\'s VPC. </p>', 'ModifyDBClusterMessage$VpcSecurityGroupIds' => '<p> A lst of VPC security groups that the DB cluster will belong to. </p>', 'ModifyDBInstanceMessage$VpcSecurityGroupIds' => '<p> A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible. </p> <p>Constraints:</p> <ul> <li>Must be 1 to 255 alphanumeric characters</li> <li>First character must be a letter</li> <li>Cannot end with a hyphen or contain two consecutive hyphens</li> </ul>', 'OptionConfiguration$VpcSecurityGroupMemberships' => '<p> A list of VpcSecurityGroupMemebrship name strings used for this option. </p>', 'RestoreDBClusterFromSnapshotMessage$VpcSecurityGroupIds' => '<p> A list of VPC security groups that the new DB cluster will belong to. </p>', 'RestoreDBClusterToPointInTimeMessage$VpcSecurityGroupIds' => '<p> A lst of VPC security groups that the new DB cluster belongs to. </p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>This data type is used as a response element for queries on VPC security group membership.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'DBCluster$VpcSecurityGroups' => '<p> Provides a list of VPC security groups that the DB cluster belongs to. </p>', 'DBInstance$VpcSecurityGroups' => '<p> Provides List of VPC security group elements that the DB instance belongs to. </p>', 'Option$VpcSecurityGroupMemberships' => '<p> If the option requires access to a port, then this VPC security group allows access to the port. </p>', ], ], ],];
