<?php
// This file was auto-generated from sdk-root/src/data/support/2013-04-15/docs-2.json
return [ 'operations' => [ 'AddAttachmentsToSet' => '<p>Adds one or more attachments to an attachment set. If an <code>AttachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>AttachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p> <p>An attachment set is a temporary container for attachments that are to be added to a case or case communication. The set is available for one hour after it is created; the <code>ExpiryTime</code> returned in the response indicates when the set expires. The maximum number of attachments in a set is 3, and the maximum size of any attachment in the set is 5 MB.</p>', 'AddCommunicationToCase' => '<p>Adds additional customer communication to an AWS Support case. You use the <code>CaseId</code> value to identify the case to add communication to. You can list a set of email addresses to copy on the communication using the <code>CcEmailAddresses</code> value. The <code>CommunicationBody</code> value contains the text of the communication.</p> <p>The response indicates the success or failure of the request.</p> <p>This operation implements a subset of the features of the AWS Support Center.</p>', 'CreateCase' => '<p>Creates a new case in the AWS Support Center. This operation is modeled on the behavior of the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. Its parameters require you to specify the following information: </p> <ol> <li> <b>IssueType.</b> The type of issue for the case. You can specify either "customer-service" or "technical." If you do not indicate a value, the default is "technical." </li> <li> <b>ServiceCode.</b> The code for an AWS service. You obtain the <code>ServiceCode</code> by calling <a>DescribeServices</a>. </li> <li> <b>CategoryCode.</b> The category for the service defined for the <code>ServiceCode</code> value. You also obtain the category code for a service by calling <a>DescribeServices</a>. Each AWS service defines its own set of category codes. </li> <li> <b>SeverityCode.</b> A value that indicates the urgency of the case, which in turn determines the response time according to your service level agreement with AWS Support. You obtain the SeverityCode by calling <a>DescribeSeverityLevels</a>.</li> <li> <b>Subject.</b> The <b>Subject</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</li> <li> <b>CommunicationBody.</b> The <b>Description</b> field on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page.</li> <li> <b>AttachmentSetId.</b> The ID of a set of attachments that has been created by using <a>AddAttachmentsToSet</a>.</li> <li> <b>Language.</b> The human language in which AWS Support handles the case. English and Japanese are currently supported.</li> <li> <b>CcEmailAddresses.</b> The AWS Support Center <b>CC</b> field on the <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. You can list email addresses to be copied on any correspondence about the case. The account that opens the case is already identified by passing the AWS Credentials in the HTTP POST method or in a method or function call from one of the programming languages supported by an <a href="http://aws.amazon.com/tools/">AWS SDK</a>. </li> </ol> <note><p>To add additional communication or attachments to an existing case, use <a>AddCommunicationToCase</a>.</p> </note> <p>A successful <a>CreateCase</a> request returns an AWS Support case number. Case numbers are used by the <a>DescribeCases</a> operation to retrieve existing AWS Support cases. </p>', 'DescribeAttachment' => '<p>Returns the attachment that has the specified ID. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the <a>AttachmentDetails</a> objects that are returned by the <a>DescribeCommunications</a> operation.</p>', 'DescribeCases' => '<p>Returns a list of cases that you specify by passing one or more case IDs. In addition, you can filter the cases by date by setting values for the <code>AfterTime</code> and <code>BeforeTime</code> request parameters. You can set values for the <code>IncludeResolvedCases</code> and <code>IncludeCommunications</code> request parameters to control how much information is returned. </p> <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error. </p> <p>The response returns the following in JSON format:</p> <ol> <li>One or more <a>CaseDetails</a> data types. </li> <li>One or more <code>NextToken</code> values, which specify where to paginate the returned records represented by the <code>CaseDetails</code> objects.</li> </ol>', 'DescribeCommunications' => '<p>Returns communications (and attachments] for one or more support cases. You can use the <code>AfterTime</code> and <code>BeforeTime</code> parameters to filter by date. You can use the <code>CaseId</code> parameter to restrict the results to a particular case.</p> <p>Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error. </p> <p>You can use the <code>MaxResults</code> and <code>NextToken</code> parameters to control the pagination of the result set. Set <code>MaxResults</code> to the number of cases you want displayed on each page, and use <code>NextToken</code> to specify the resumption of pagination.</p>', 'DescribeServices' => '<p>Returns the current list of AWS services and a list of service categories that applies to each one. You then use service names and categories in your <a>CreateCase</a> requests. Each AWS service has its own set of categories.</p> <p>The service codes and category codes correspond to the values that are displayed in the <b>Service</b> and <b>Category</b> drop-down lists on the AWS Support Center <a href="https://console.aws.amazon.com/support/home#/case/create">Create Case</a> page. The values in those fields, however, do not necessarily match the service codes and categories returned by the <code>DescribeServices</code> request. Always use the service codes and categories obtained programmatically. This practice ensures that you always have the most recent set of service and category codes.</p>', 'DescribeSeverityLevels' => '<p>Returns the list of severity levels that you can assign to an AWS Support case. The severity level for a case is also a field in the <a>CaseDetails</a> data type included in any <a>CreateCase</a> request. </p>', 'DescribeTrustedAdvisorCheckRefreshStatuses' => '<p>Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. Check IDs can be obtained by calling <a>DescribeTrustedAdvisorChecks</a>.</p>', 'DescribeTrustedAdvisorCheckResult' => '<p>Returns the results of the Trusted Advisor check that has the specified check ID. Check IDs can be obtained by calling <a>DescribeTrustedAdvisorChecks</a>.</p> <p>The response contains a <a>TrustedAdvisorCheckResult</a> object, which contains these three objects:</p> <ul> <li><a>TrustedAdvisorCategorySpecificSummary</a></li> <li><a>TrustedAdvisorResourceDetail</a></li> <li><a>TrustedAdvisorResourcesSummary</a></li> </ul> <p>In addition, the response contains these fields:</p> <ul> <li> <b>Status.</b> The alert status of the check: "ok" (green], "warning" (yellow], "error" (red], or "not_available".</li> <li> <b>Timestamp.</b> The time of the last refresh of the check.</li> <li> <b>CheckId.</b> The unique identifier for the check.</li> </ul>', 'DescribeTrustedAdvisorCheckSummaries' => '<p>Returns the summaries of the results of the Trusted Advisor checks that have the specified check IDs. Check IDs can be obtained by calling <a>DescribeTrustedAdvisorChecks</a>.</p> <p>The response contains an array of <a>TrustedAdvisorCheckSummary</a> objects.</p>', 'DescribeTrustedAdvisorChecks' => '<p>Returns information about all available Trusted Advisor checks, including name, ID, category, description, and metadata. You must specify a language code; English ("en"] and Japanese ("ja"] are currently supported. The response contains a <a>TrustedAdvisorCheckDescription</a> for each check.</p>', 'RefreshTrustedAdvisorCheck' => '<p>Requests a refresh of the Trusted Advisor check that has the specified check ID. Check IDs can be obtained by calling <a>DescribeTrustedAdvisorChecks</a>.</p> <p>The response contains a <a>TrustedAdvisorCheckRefreshStatus</a> object, which contains these fields:</p> <ul> <li> <b>Status.</b> The refresh status of the check: "none", "enqueued", "processing", "success", or "abandoned".</li> <li> <b>MillisUntilNextRefreshable.</b> The amount of time, in milliseconds, until the check is eligible for refresh.</li> <li> <b>CheckId.</b> The unique identifier for the check.</li> </ul>', 'ResolveCase' => '<p>Takes a <code>CaseId</code> and returns the initial state of the case along with the state of the case after the call to <a>ResolveCase</a> completed.</p>', ], 'shapes' => [ 'AddAttachmentsToSetRequest' => [ 'refs' => [], ], 'AddAttachmentsToSetResponse' => [ 'base' => '<p>The ID and expiry time of the attachment set returned by the <a>AddAttachmentsToSet</a> operation.</p>', 'refs' => [], ], 'AddCommunicationToCaseRequest' => [ 'base' => '<p>To be written.</p>', 'refs' => [], ], 'AddCommunicationToCaseResponse' => [ 'base' => '<p>The result of the <a>AddCommunicationToCase</a> operation.</p>', 'refs' => [], ], 'AfterTime' => [ 'refs' => [ 'DescribeCasesRequest$afterTime' => '<p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', 'DescribeCommunicationsRequest$afterTime' => '<p>The start date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', ], ], 'Attachment' => [ 'base' => '<p>An attachment to a case communication. The attachment consists of the file name and the content of the file.</p>', 'refs' => [ 'DescribeAttachmentResponse$attachment' => '<p>The attachment content and file name.</p>', ], ], 'AttachmentDetails' => [ 'base' => '<p>The file name and ID of an attachment to a case communication. You can use the ID to retrieve the attachment with the <a>DescribeAttachment</a> operation.</p>', 'refs' => [], ], 'AttachmentId' => [ 'refs' => [ 'AttachmentDetails$attachmentId' => '<p>The ID of the attachment.</p>', 'DescribeAttachmentRequest$attachmentId' => '<p>The ID of the attachment to return. Attachment IDs are returned by the <a>DescribeCommunications</a> operation.</p>', ], ], 'AttachmentIdNotFound' => [ 'base' => '<p>An attachment with the specified ID could not be found.</p>', 'refs' => [], ], 'AttachmentLimitExceeded' => [ 'base' => '<p>The limit for the number of attachment sets created in a short period of time has been exceeded.</p>', 'refs' => [], ], 'AttachmentSet' => [ 'refs' => [ 'Communication$attachmentSet' => '<p>Information about the attachments to the case communication. </p>', ], ], 'AttachmentSetExpired' => [ 'base' => '<p>The expiration time of the attachment set has passed. The set expires 1 hour after it is created.</p>', 'refs' => [], ], 'AttachmentSetId' => [ 'refs' => [ 'AddAttachmentsToSetRequest$attachmentSetId' => '<p>The ID of the attachment set. If an <code>AttachmentSetId</code> is not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>AttachmentSetId</code> is specified, the attachments are added to the specified set, if it exists.</p>', 'AddAttachmentsToSetResponse$attachmentSetId' => '<p>The ID of the attachment set. If an <code>AttachmentSetId</code> was not specified, a new attachment set is created, and the ID of the set is returned in the response. If an <code>AttachmentSetId</code> was specified, the attachments are added to the specified set, if it exists.</p>', 'AddCommunicationToCaseRequest$attachmentSetId' => '<p>The ID of a set of one or more attachments for the communication to add to the case. Create the set by calling <a>AddAttachmentsToSet</a></p>', 'CreateCaseRequest$attachmentSetId' => '<p>The ID of a set of one or more attachments for the case. Create the set by using <a>AddAttachmentsToSet</a>.</p>', ], ], 'AttachmentSetIdNotFound' => [ 'base' => '<p>An attachment set with the specified ID could not be found.</p>', 'refs' => [], ], 'AttachmentSetSizeLimitExceeded' => [ 'base' => '<p>A limit for the size of an attachment set has been exceeded. The limits are 3 attachments and 5 MB per attachment.</p>', 'refs' => [], ], 'Attachments' => [ 'refs' => [ 'AddAttachmentsToSetRequest$attachments' => '<p>One or more attachments to add to the set. The limit is 3 attachments per set, and the size limit is 5 MB per attachment.</p>', ], ], 'BeforeTime' => [ 'refs' => [ 'DescribeCasesRequest$beforeTime' => '<p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', 'DescribeCommunicationsRequest$beforeTime' => '<p>The end date for a filtered date search on support case communications. Case communications are available for 12 months after creation.</p>', ], ], 'Boolean' => [ 'refs' => [ 'TrustedAdvisorCheckSummary$hasFlaggedResources' => '<p>Specifies whether the Trusted Advisor check has flagged resources.</p>', 'TrustedAdvisorResourceDetail$isSuppressed' => '<p>Specifies whether the AWS resource was ignored by Trusted Advisor because it was marked as suppressed by the user.</p>', ], ], 'CaseCreationLimitExceeded' => [ 'base' => '<p>The case creation limit for the account has been exceeded. </p>', 'refs' => [], ], 'CaseDetails' => [ 'base' => '<p>A JSON-formatted object that contains the metadata for a support case. It is contained the response from a <a>DescribeCases</a> request. <b>CaseDetails</b> contains the following fields:</p> <ol> <li> <b>CaseID.</b> The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>.</li> <li> <b>CategoryCode.</b> The category of problem for the AWS Support case. Corresponds to the CategoryCode values returned by a call to <a>DescribeServices</a>.</li> <li> <b>DisplayId.</b> The identifier for the case on pages in the AWS Support Center.</li> <li> <b>Language.</b> The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</li> <li> <b>RecentCommunications.</b> One or more <a>Communication</a> objects. Fields of these objects are <code>Attachments</code>, <code>Body</code>, <code>CaseId</code>, <code>SubmittedBy</code>, and <code>TimeCreated</code>.</li> <li> <b>NextToken.</b> A resumption point for pagination.</li> <li> <b>ServiceCode.</b> The identifier for the AWS service that corresponds to the service code defined in the call to <a>DescribeServices</a>.</li> <li> <b>SeverityCode. </b>The severity code assigned to the case. Contains one of the values returned by the call to <a>DescribeSeverityLevels</a>.</li> <li> <b>Status.</b> The status of the case in the AWS Support Center.</li> <li> <b>Subject.</b> The subject line of the case.</li> <li> <b>SubmittedBy.</b> The email address of the account that submitted the case.</li> <li> <b>TimeCreated.</b> The time the case was created, in ISO-8601 format.</li> </ol>', 'refs' => [], ], 'CaseId' => [ 'refs' => [ 'AddCommunicationToCaseRequest$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', 'CaseDetails$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', 'Communication$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', 'CreateCaseResponse$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', 'DescribeCommunicationsRequest$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', 'ResolveCaseRequest$caseId' => '<p>The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i></p>', ], ], 'CaseIdList' => [ 'refs' => [ 'DescribeCasesRequest$caseIdList' => '<p>A list of ID numbers of the support cases you want returned. The maximum number of cases is 100. </p>', ], ], 'CaseIdNotFound' => [ 'base' => '<p>The requested <code>CaseId</code> could not be located.</p>', 'refs' => [], ], 'CaseList' => [ 'refs' => [ 'DescribeCasesResponse$cases' => '<p>The details for the cases that match the request.</p>', ], ], 'CaseStatus' => [ 'refs' => [ 'ResolveCaseResponse$finalCaseStatus' => '<p>The status of the case after the <a>ResolveCase</a> request was processed.</p>', 'ResolveCaseResponse$initialCaseStatus' => '<p>The status of the case when the <a>ResolveCase</a> request was sent.</p>', ], ], 'Category' => [ 'base' => '<p>A JSON-formatted name/value pair that represents the category name and category code of the problem, selected from the <a>DescribeServices</a> response for each AWS service.</p>', 'refs' => [], ], 'CategoryCode' => [ 'refs' => [ 'CaseDetails$categoryCode' => '<p>The category of problem for the AWS Support case.</p>', 'Category$code' => '<p>The category code for the support case. </p>', 'CreateCaseRequest$categoryCode' => '<p>The category of problem for the AWS Support case. </p>', ], ], 'CategoryList' => [ 'refs' => [ 'Service$categories' => '<p>A list of categories that describe the type of support issue a case describes. Categories consist of a category name and a category code. Category names and codes are passed to AWS Support when you call <a>CreateCase</a>.</p>', ], ], 'CategoryName' => [ 'refs' => [ 'Category$name' => '<p>The category name for the support case. </p>', ], ], 'CcEmailAddress' => [ 'refs' => [], ], 'CcEmailAddressList' => [ 'refs' => [ 'AddCommunicationToCaseRequest$ccEmailAddresses' => '<p>The email addresses in the CC line of an email to be added to the support case.</p>', 'CaseDetails$ccEmailAddresses' => '<p>The email addresses that receive copies of communication about the case.</p>', 'CreateCaseRequest$ccEmailAddresses' => '<p>A list of email addresses that AWS Support copies on case correspondence.</p>', ], ], 'Communication' => [ 'base' => '<p>A communication associated with an AWS Support case. The communication consists of the case ID, the message body, attachment information, the account email address, and the date and time of the communication.</p>', 'refs' => [], ], 'CommunicationBody' => [ 'refs' => [ 'AddCommunicationToCaseRequest$communicationBody' => '<p>The body of an email communication to add to the support case.</p>', 'Communication$body' => '<p>The text of the communication between the customer and AWS Support.</p>', 'CreateCaseRequest$communicationBody' => '<p>The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.</p>', ], ], 'CommunicationList' => [ 'refs' => [ 'DescribeCommunicationsResponse$communications' => '<p>The communications for the case.</p>', 'RecentCaseCommunications$communications' => '<p>The five most recent communications associated with the case.</p>', ], ], 'CreateCaseRequest' => [ 'refs' => [], ], 'CreateCaseResponse' => [ 'base' => '<p>The AWS Support case ID returned by a successful completion of the <a>CreateCase</a> operation. </p>', 'refs' => [], ], 'Data' => [ 'refs' => [ 'Attachment$data' => '<p>The content of the attachment file.</p>', ], ], 'DescribeAttachmentLimitExceeded' => [ 'base' => '<p>The limit for the number of <a>DescribeAttachment</a> requests in a short period of time has been exceeded.</p>', 'refs' => [], ], 'DescribeAttachmentRequest' => [ 'refs' => [], ], 'DescribeAttachmentResponse' => [ 'base' => '<p>The content and file name of the attachment returned by the <a>DescribeAttachment</a> operation.</p>', 'refs' => [], ], 'DescribeCasesRequest' => [ 'refs' => [], ], 'DescribeCasesResponse' => [ 'base' => '<p>Returns an array of <a>CaseDetails</a> objects and a <code>NextToken</code> that defines a point for pagination in the result set.</p>', 'refs' => [], ], 'DescribeCommunicationsRequest' => [ 'refs' => [], ], 'DescribeCommunicationsResponse' => [ 'base' => '<p>The communications returned by the <a>DescribeCommunications</a> operation.</p>', 'refs' => [], ], 'DescribeServicesRequest' => [ 'refs' => [], ], 'DescribeServicesResponse' => [ 'base' => '<p>The list of AWS services returned by the <a>DescribeServices</a> operation.</p>', 'refs' => [], ], 'DescribeSeverityLevelsRequest' => [ 'refs' => [], ], 'DescribeSeverityLevelsResponse' => [ 'base' => '<p>The list of severity levels returned by the <a>DescribeSeverityLevels</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckRefreshStatusesRequest' => [ 'refs' => [], ], 'DescribeTrustedAdvisorCheckRefreshStatusesResponse' => [ 'base' => '<p>The statuses of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckRefreshStatuses</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckResultRequest' => [ 'refs' => [], ], 'DescribeTrustedAdvisorCheckResultResponse' => [ 'base' => '<p>The result of the Trusted Advisor check returned by the <a>DescribeTrustedAdvisorCheckResult</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorCheckSummariesRequest' => [ 'refs' => [], ], 'DescribeTrustedAdvisorCheckSummariesResponse' => [ 'base' => '<p>The summaries of the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorCheckSummaries</a> operation.</p>', 'refs' => [], ], 'DescribeTrustedAdvisorChecksRequest' => [ 'refs' => [], ], 'DescribeTrustedAdvisorChecksResponse' => [ 'base' => '<p>Information about the Trusted Advisor checks returned by the <a>DescribeTrustedAdvisorChecks</a> operation.</p>', 'refs' => [], ], 'DisplayId' => [ 'refs' => [ 'CaseDetails$displayId' => '<p>The ID displayed for the case in the AWS Support Center. This is a numeric string. </p>', 'DescribeCasesRequest$displayId' => '<p>The ID displayed for a case in the AWS Support Center user interface. </p>', ], ], 'Double' => [ 'refs' => [ 'TrustedAdvisorCostOptimizingSummary$estimatedMonthlySavings' => '<p>The estimated monthly savings that might be realized if the recommended actions are taken.</p>', 'TrustedAdvisorCostOptimizingSummary$estimatedPercentMonthlySavings' => '<p>The estimated percentage of savings that might be realized if the recommended actions are taken.</p>', ], ], 'ErrorMessage' => [ 'refs' => [ 'AttachmentIdNotFound$message' => '<p>An attachment with the specified ID could not be found.</p>', 'AttachmentLimitExceeded$message' => '<p>The limit for the number of attachment sets created in a short period of time has been exceeded.</p>', 'AttachmentSetExpired$message' => '<p>The expiration time of the attachment set has passed. The set expires 1 hour after it is created.</p>', 'AttachmentSetIdNotFound$message' => '<p>An attachment set with the specified ID could not be found.</p>', 'AttachmentSetSizeLimitExceeded$message' => '<p>A limit for the size of an attachment set has been exceeded. The limits are 3 attachments and 5 MB per attachment.</p>', 'CaseCreationLimitExceeded$message' => '<p>An error message that indicates that you have exceeded the number of cases you can have open. </p>', 'CaseIdNotFound$message' => '<p>The requested <code>CaseId</code> could not be located.</p>', 'DescribeAttachmentLimitExceeded$message' => '<p>The limit for the number of <a>DescribeAttachment</a> requests in a short period of time has been exceeded.</p>', 'InternalServerError$message' => '<p>An internal server error occurred.</p>', ], ], 'ExpiryTime' => [ 'refs' => [ 'AddAttachmentsToSetResponse$expiryTime' => '<p>The time and date when the attachment set expires.</p>', ], ], 'FileName' => [ 'refs' => [ 'Attachment$fileName' => '<p>The name of the attachment file.</p>', 'AttachmentDetails$fileName' => '<p>The file name of the attachment.</p>', ], ], 'IncludeCommunications' => [ 'refs' => [ 'DescribeCasesRequest$includeCommunications' => '<p>Specifies whether communications should be included in the <a>DescribeCases</a> results. The default is <i>true</i>.</p>', ], ], 'IncludeResolvedCases' => [ 'refs' => [ 'DescribeCasesRequest$includeResolvedCases' => '<p>Specifies whether resolved support cases should be included in the <a>DescribeCases</a> results. The default is <i>false</i>.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An internal server error occurred.</p>', 'refs' => [], ], 'IssueType' => [ 'refs' => [ 'CreateCaseRequest$issueType' => '<p>The type of issue for the case. You can specify either "customer-service" or "technical." If you do not indicate a value, the default is "technical." </p>', ], ], 'Language' => [ 'refs' => [ 'CaseDetails$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'CreateCaseRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeCasesRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeServicesRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeSeverityLevelsRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', ], ], 'Long' => [ 'refs' => [ 'TrustedAdvisorCheckRefreshStatus$millisUntilNextRefreshable' => '<p>The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.</p>', 'TrustedAdvisorResourcesSummary$resourcesFlagged' => '<p>The number of AWS resources that were flagged (listed] by the Trusted Advisor check.</p>', 'TrustedAdvisorResourcesSummary$resourcesIgnored' => '<p>The number of AWS resources ignored by Trusted Advisor because information was unavailable.</p>', 'TrustedAdvisorResourcesSummary$resourcesProcessed' => '<p>The number of AWS resources that were analyzed by the Trusted Advisor check.</p>', 'TrustedAdvisorResourcesSummary$resourcesSuppressed' => '<p>The number of AWS resources ignored by Trusted Advisor because they were marked as suppressed by the user.</p>', ], ], 'MaxResults' => [ 'refs' => [ 'DescribeCasesRequest$maxResults' => '<p>The maximum number of results to return before paginating.</p>', 'DescribeCommunicationsRequest$maxResults' => '<p>The maximum number of results to return before paginating.</p>', ], ], 'NextToken' => [ 'refs' => [ 'DescribeCasesRequest$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCasesResponse$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCommunicationsRequest$nextToken' => '<p>A resumption point for pagination.</p>', 'DescribeCommunicationsResponse$nextToken' => '<p>A resumption point for pagination.</p>', 'RecentCaseCommunications$nextToken' => '<p>A resumption point for pagination.</p>', ], ], 'RecentCaseCommunications' => [ 'base' => '<p>The five most recent communications associated with the case.</p>', 'refs' => [ 'CaseDetails$recentCommunications' => '<p>The five most recent communications between you and AWS Support Center, including the IDs of any attachments to the communications. Also includes a <code>nextToken</code> that you can use to retrieve earlier communications.</p>', ], ], 'RefreshTrustedAdvisorCheckRequest' => [ 'refs' => [], ], 'RefreshTrustedAdvisorCheckResponse' => [ 'base' => '<p>The current refresh status of a Trusted Advisor check.</p>', 'refs' => [], ], 'ResolveCaseRequest' => [ 'refs' => [], ], 'ResolveCaseResponse' => [ 'base' => '<p>The status of the case returned by the <a>ResolveCase</a> operation.</p>', 'refs' => [], ], 'Result' => [ 'refs' => [ 'AddCommunicationToCaseResponse$result' => '<p>True if <a>AddCommunicationToCase</a> succeeds. Otherwise, returns an error.</p>', ], ], 'Service' => [ 'base' => '<p>Information about an AWS service returned by the <a>DescribeServices</a> operation. </p>', 'refs' => [], ], 'ServiceCode' => [ 'refs' => [ 'CaseDetails$serviceCode' => '<p>The code for the AWS service returned by the call to <a>DescribeServices</a>.</p>', 'CreateCaseRequest$serviceCode' => '<p>The code for the AWS service returned by the call to <a>DescribeServices</a>.</p>', 'Service$code' => '<p>The code for an AWS service returned by the <a>DescribeServices</a> response. The <code>Name</code> element contains the corresponding friendly name.</p>', ], ], 'ServiceCodeList' => [ 'refs' => [ 'DescribeServicesRequest$serviceCodeList' => '<p>A JSON-formatted list of service codes available for AWS services.</p>', ], ], 'ServiceList' => [ 'refs' => [ 'DescribeServicesResponse$services' => '<p>A JSON-formatted list of AWS services.</p>', ], ], 'ServiceName' => [ 'refs' => [ 'Service$name' => '<p>The friendly name for an AWS service. The <code>Code</code> element contains the corresponding code.</p>', ], ], 'SeverityCode' => [ 'refs' => [ 'CaseDetails$severityCode' => '<p>The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p>', 'CreateCaseRequest$severityCode' => '<p>The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p> <note><p>The availability of severity levels depends on each customer\'s support subscription. In other words, your subscription may not necessarily require the urgent level of response time.</p></note>', ], ], 'SeverityLevel' => [ 'base' => '<p>A code and name pair that represent a severity level that can be applied to a support case. </p>', 'refs' => [], ], 'SeverityLevelCode' => [ 'refs' => [ 'SeverityLevel$code' => '<p>One of four values: "low," "medium," "high," and "urgent". These values correspond to response times returned to the caller in <code>SeverityLevel.name</code>. </p>', ], ], 'SeverityLevelName' => [ 'refs' => [ 'SeverityLevel$name' => '<p>The name of the severity level that corresponds to the severity level code.</p>', ], ], 'SeverityLevelsList' => [ 'refs' => [ 'DescribeSeverityLevelsResponse$severityLevels' => '<p>The available severity levels for the support case. Available severity levels are defined by your service level agreement with AWS.</p>', ], ], 'Status' => [ 'refs' => [ 'CaseDetails$status' => '<p>The status of the case. </p>', ], ], 'String' => [ 'refs' => [ 'DescribeTrustedAdvisorCheckResultRequest$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'DescribeTrustedAdvisorCheckResultRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'DescribeTrustedAdvisorChecksRequest$language' => '<p>The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en"] and Japanese ("ja"]. Language parameters must be passed explicitly for operations that take them.</p>', 'RefreshTrustedAdvisorCheckRequest$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckDescription$category' => '<p>The category of the Trusted Advisor check.</p>', 'TrustedAdvisorCheckDescription$description' => '<p>The description of the Trusted Advisor check, which includes the alert criteria and recommended actions (contains HTML markup].</p>', 'TrustedAdvisorCheckDescription$id' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckDescription$name' => '<p>The display name for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckRefreshStatus$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckRefreshStatus$status' => '<p>The status of the Trusted Advisor check for which a refresh has been requested: "none", "enqueued", "processing", "success", or "abandoned".</p>', 'TrustedAdvisorCheckResult$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckResult$status' => '<p>The alert status of the check: "ok" (green], "warning" (yellow], "error" (red], or "not_available".</p>', 'TrustedAdvisorCheckResult$timestamp' => '<p>The time of the last refresh of the check.</p>', 'TrustedAdvisorCheckSummary$checkId' => '<p>The unique identifier for the Trusted Advisor check.</p>', 'TrustedAdvisorCheckSummary$status' => '<p>The alert status of the check: "ok" (green], "warning" (yellow], "error" (red], or "not_available".</p>', 'TrustedAdvisorCheckSummary$timestamp' => '<p>The time of the last refresh of the check.</p>', 'TrustedAdvisorResourceDetail$region' => '<p>The AWS region in which the identified resource is located. </p>', 'TrustedAdvisorResourceDetail$resourceId' => '<p>The unique identifier for the identified resource.</p>', 'TrustedAdvisorResourceDetail$status' => '<p>The status code for the resource identified in the Trusted Advisor check.</p>', ], ], 'StringList' => [ 'refs' => [ 'DescribeTrustedAdvisorCheckRefreshStatusesRequest$checkIds' => '<p>The IDs of the Trusted Advisor checks.</p>', 'DescribeTrustedAdvisorCheckSummariesRequest$checkIds' => '<p>The IDs of the Trusted Advisor checks.</p>', 'TrustedAdvisorCheckDescription$metadata' => '<p>The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the <b>Metadata</b> element of the <a>TrustedAdvisorResourceDetail</a> for the check. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>', 'TrustedAdvisorResourceDetail$metadata' => '<p>Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the <a>TrustedAdvisorCheckDescription</a> object returned by the call to <a>DescribeTrustedAdvisorChecks</a>. <b>Metadata</b> contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data. </p>', ], ], 'Subject' => [ 'refs' => [ 'CaseDetails$subject' => '<p>The subject line for the case in the AWS Support Center.</p>', 'CreateCaseRequest$subject' => '<p>The title of the AWS Support case.</p>', ], ], 'SubmittedBy' => [ 'refs' => [ 'CaseDetails$submittedBy' => '<p>The email address of the account that submitted the case.</p>', 'Communication$submittedBy' => '<p>The email address of the account that submitted the AWS Support case. </p>', ], ], 'TimeCreated' => [ 'refs' => [ 'CaseDetails$timeCreated' => '<p>The time that the case was case created in the AWS Support Center. </p>', 'Communication$timeCreated' => '<p>The time the communication was created. </p>', ], ], 'TrustedAdvisorCategorySpecificSummary' => [ 'base' => '<p>The container for summary information that relates to the category of the Trusted Advisor check.</p>', 'refs' => [ 'TrustedAdvisorCheckResult$categorySpecificSummary' => '<p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>', 'TrustedAdvisorCheckSummary$categorySpecificSummary' => '<p>Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.</p>', ], ], 'TrustedAdvisorCheckDescription' => [ 'base' => '<p>The description and metadata for a Trusted Advisor check.</p>', 'refs' => [], ], 'TrustedAdvisorCheckList' => [ 'refs' => [ 'DescribeTrustedAdvisorChecksResponse$checks' => '<p>Information about all available Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCheckRefreshStatus' => [ 'base' => '<p>The refresh status of a Trusted Advisor check. </p>', 'refs' => [ 'RefreshTrustedAdvisorCheckResponse$status' => '<p>The current refresh status for a check, including the amount of time until the check is eligible for refresh. </p>', ], ], 'TrustedAdvisorCheckRefreshStatusList' => [ 'refs' => [ 'DescribeTrustedAdvisorCheckRefreshStatusesResponse$statuses' => '<p>The refresh status of the specified Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCheckResult' => [ 'base' => '<p>The results of a Trusted Advisor check returned by <a>DescribeTrustedAdvisorCheckResult</a>.</p>', 'refs' => [ 'DescribeTrustedAdvisorCheckResultResponse$result' => '<p>The detailed results of the Trusted Advisor check.</p>', ], ], 'TrustedAdvisorCheckSummary' => [ 'base' => '<p>A summary of a Trusted Advisor check result, including the alert status, last refresh, and number of resources examined.</p>', 'refs' => [], ], 'TrustedAdvisorCheckSummaryList' => [ 'refs' => [ 'DescribeTrustedAdvisorCheckSummariesResponse$summaries' => '<p>The summary information for the requested Trusted Advisor checks.</p>', ], ], 'TrustedAdvisorCostOptimizingSummary' => [ 'base' => '<p>The estimated cost savings that might be realized if the recommended actions are taken.</p>', 'refs' => [ 'TrustedAdvisorCategorySpecificSummary$costOptimizing' => '<p>The summary information about cost savings for a Trusted Advisor check that is in the Cost Optimizing category.</p>', ], ], 'TrustedAdvisorResourceDetail' => [ 'base' => '<p>Contains information about a resource identified by a Trusted Advisor check. </p>', 'refs' => [], ], 'TrustedAdvisorResourceDetailList' => [ 'refs' => [ 'TrustedAdvisorCheckResult$flaggedResources' => '<p>The details about each resource listed in the check result.</p>', ], ], 'TrustedAdvisorResourcesSummary' => [ 'base' => '<p>Details about AWS resources that were analyzed in a call to Trusted Advisor <a>DescribeTrustedAdvisorCheckSummaries</a>. </p>', 'refs' => [], ], ], 'service' => '<fullname>AWS Support</fullname> <p>The AWS Support API reference is intended for programmers who need detailed information about the AWS Support operations and data types. This service enables you to manage your AWS Support cases programmatically. It uses HTTP methods that return results in JSON format.</p> <p>The AWS Support service also exposes a set of <a href="https://aws.amazon.com/premiumsupport/trustedadvisor/">Trusted Advisor</a> features. You can retrieve a list of checks and their descriptions, get check results, specify checks to refresh, and get the refresh status of checks. </p> <p>The following list describes the AWS Support case management operations: </p> <ul> <li> <b>Service names, issue categories, and available severity levels. </b>The <a>DescribeServices</a> and <a>DescribeSeverityLevels</a> operations return AWS service names, service codes, service categories, and problem severity levels. You use these values when you call the <a>CreateCase</a> operation. </li> <li> <b>Case creation, case details, and case resolution.</b> The <a>CreateCase</a>, <a>DescribeCases</a>, <a>DescribeAttachment</a>, and <a>ResolveCase</a> operations create AWS Support cases, retrieve information about cases, and resolve cases.</li> <li> <b>Case communication.</b> The <a>DescribeCommunications</a>, <a>AddCommunicationToCase</a>, and <a>AddAttachmentsToSet</a> operations retrieve and add communications and attachments to AWS Support cases. </li> </ul> <p>The following list describes the operations available from the AWS Support service for Trusted Advisor:</p> <ul> <li> <a>DescribeTrustedAdvisorChecks</a> returns the list of checks that run against your AWS resources.</li> <li>Using the <code>CheckId</code> for a specific check returned by <a>DescribeTrustedAdvisorChecks</a>, you can call <a>DescribeTrustedAdvisorCheckResult</a> to obtain the results for the check you specified.</li> <li> <a>DescribeTrustedAdvisorCheckSummaries</a> returns summarized results for one or more Trusted Advisor checks.</li> <li> <a>RefreshTrustedAdvisorCheck</a> requests that Trusted Advisor rerun a specified check. </li> <li> <a>DescribeTrustedAdvisorCheckRefreshStatuses</a> reports the refresh status of one or more checks. </li> </ul> <p>For authentication of requests, AWS Support uses <a href="http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <p>See <a href="http://docs.aws.amazon.com/awssupport/latest/user/Welcome.html">About the AWS Support API</a> in the <i>AWS Support User Guide</i> for information about how to use this service to create and manage your support cases, and how to call Trusted Advisor for results of checks on your resources. </p>',];
