<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View extends CI_Controller {

	public function index( $id = 0 ) {
		$realip = xi_get_ClientIp();  

	    $uuid = $this->pic_model->guuid($id);

		if ( $this->pic_model->is_view($uuid) ) {  //记录存在
			$this->pic_model->addview($uuid);      //更新浏览次数
			$query = $this->pic_model->one($uuid);

			foreach ($query as $value) {

				$data['url']     = base_url($value['pic_url']);
				$data['id']      = $value['ID'];
				$data['uuid']    = $uuid;
				$data['name']    = $value['pic_name'];
				$data['text']    = $value['pic_text'];
				$data['tags']    = $value['pic_tag'];
				$data['user']    = $value['pic_user'];
				$data['catanothername']   = $value['pic_type'];
				$data['catname'] = $this->catalogue_model->name_by_another($value['pic_type']);
				$data['date']    = $value['pic_datetime'];
				$data['collect'] = $this->love_model->pic_love($uuid);
				$data['like']    = $this->like_model->pic_like($uuid);
				$data['view']    = $value['pic_view'];
				$data['share']   = $value['pic_share'];

				if($this->system_model->sysinfo('have_comment') == "TRUE")
				{
					$data['comment'] = TRUE;
				}
				else
				{
					$data['comment'] = FALSE;
				}
				if( $this->session->userdata('online') ) {
					$user = $this->session->userdata('Username');
					$data['is_love'] = $this->love_model->is_love($uuid,$user);

					$data['username'] = $user;

					$pic  = 'upload/user/' . $this->user_model->picture($user) . '_3.jpg';
					if (file_exists($pic)) {
						$data['userpic'] = base_url('upload/user/' . $this->user_model->picture($user) . '_3.jpg');
					} else {
						$data['userpic'] = base_url('upload/user/default_3.jpg');
					}
				} else {
					$data['is_love']  = 0;

					$data['username'] = 0;
					$data['userpic']  = 0;
				}
				
				$data['is_like'] = $this->like_model->is_like($uuid,$realip);

				$next = $id + 1;
				while ( !$this->pic_model->is_view($this->pic_model->guuid($next)) && $next < $this->pic_model->max_id() ) {
					$next++;
				}
				$pres = $id - 1;
				while ( !$this->pic_model->is_view($this->pic_model->guuid($pres)) && $pres > 0 ) {
					$pres--;
				}
				$data['next']  = $next;
				$data['pres']  = $pres;
			}
		
			$title       = $this->system_model->sysinfo('webtitle');
			$keywords    = $this->system_model->sysinfo('keywords');
			$description = $this->system_model->sysinfo('description');
			$search      = "";

			$head['search']      = $search;
			$head['title']       = $title;
			$head['keywords']    = $keywords;
			$head['description'] = $description;

			if ($data['name'] != "") 
			{
				$head['title']    = $data['name'] . "-" . $title;
			}

			if ($data['tags'] != "") 
			{
				$head['keywords']    = str_replace(" ","，",$data['tags']);
			}
			if ($data['text'] != "") 
			{
				$head['description']    = $data['text'];
			}

			$this->load->view('default/xi_header.php',$head);

			$this->load->view('xi_view.php',$data);
			$this->load->view('default/xi_copy.php');
	        $this->load->view('default/xi_footer.php');
    	}
    	else
    	{
    		show_404("view error");
    	}
	}

}

/* End of file xixi.php */
/* Location: ./application/controllers/xixi.php */