<?php
class Pic_model extends CI_Model {
  private $pagenum = 12;
  
	public function __construct() {
    	$this->load->database();
      $this->load->model('tags_model');
      $this->load->model('system_model');
  	}
    
    public function picturesNew( $page, $limit ) {  //按照添加日期返回所有图像记录
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),$limit,$limit*($page-1));
      return $query->result_array();
    }

    public function pictures( $page ) {  //按照添加日期返回所有图像记录
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),12,12*($page-1));
      return $query->result_array();
    }

    public function getall() {
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1));
      return $query->result_array();
    }

    public function is_hash( $hash ) {  //查看某条记录是否存在
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $hash));
      return $query->num_rows();
    }

    public function is_view( $uuid ) {  //查看某条记录是否存在
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid,'pic_status' => 1));
      return $query->num_rows();
    }

    public function one( $uuid ) {  //返回一条记录的信息
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      return $query->result_array();
    }

   public function one_id( $id ) {  //返回一条记录的信息
      $query = $this->db->get_where('xi_picture',array('ID' => $id));
      return $query->result_array();
    }

    public function one_url( $id ) {  //返回一条记录的信息
      $query = $this->db->get_where('xi_picture',array('ID' => $id));
      foreach ($query->result_array() as $value) {
        return base_url($value['pic_url']);
      }
    }

    public function one_thumb( $id ) {  //返回一条记录的信息
      $query = $this->db->get_where('xi_picture',array('ID' => $id));
      foreach ($query->result_array() as $value) {
          $thumb    = explode(".",$value['pic_url']);
          $thumbpic = $thumb[0] . "_thumb." . $thumb[1];
          $image_u  = base_url($thumbpic);
          return $image_u;
      }
    }

    public function max_id() {  //返回最大的ID
      $this->db->order_by("ID", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),1);
      foreach ($query->result_array() as $value) {
        return $value['ID'];
      }
    }

    public function guuid($id) {   //根据记录的ID返回uuid
      $query = $this->db->get_where('xi_picture',array('ID' => $id));
      foreach ($query->result_array() as $value) {
        return $value['pic_uuid'];
      }
    }

    public function getid($uuid) {  
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        return $value['ID'];
      }
    }

    public function gettag($id) {   
      $query = $this->db->get_where('xi_picture',array('ID' => $id));
      foreach ($query->result_array() as $value) {
        return $value['pic_tag'];
      }
    }

    public function search($search,$page) {
      $this->db->like('pic_name', $search);
      $this->db->or_like('pic_text', $search);
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),12,12*($page-1));
      return $query->result_array();
    }

    public function searchNew($search,$page,$limit) {
      $this->db->like('pic_name', $search);
      $this->db->or_like('pic_text', $search);
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),$limit,$limit*($page-1));
      return $query->result_array();
    }

    public function searchnum($search) {
      $this->db->like('pic_name', $search);
      $this->db->or_like('pic_text', $search);
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1));
      return $query->num_rows();
    }

    public function catalogue( $catalogue,$page ) {  //根据类型返回记录信息
      $this->db->where('pic_status', 1);
      $this->db->where('pic_type', $catalogue);
      $this->db->order_by("pic_datetime", "desc");
      $query = $this->db->get('xi_picture',12,12*($page-1));
      return $query->result_array();
    }

    public function catalogueNew( $catalogue,$page,$limit ) {  //根据类型返回记录信息
      $this->db->where('pic_status', 1);
      $this->db->where('pic_type', $catalogue);
      $this->db->order_by("pic_datetime", "desc");
      $query = $this->db->get('xi_picture',$limit,$limit*($page-1));
      return $query->result_array();
    }

    public function cataloguenum( $catalogue ) {  //根据类型返回记录信息
      $this->db->where('pic_status', 1);
      $this->db->where('pic_type', $catalogue);
      $query = $this->db->get('xi_picture');
      return $query->num_rows();
    }

    public function tag($tag,$page) {  //根据标签返回记录信息
      $this->db->like('pic_tag', $tag);
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),12,12*($page-1));
      return $query->result_array();
    }

    public function tagNew($tag,$page,$limit) {  //根据标签返回记录信息
      $this->db->like('pic_tag', $tag);
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1),$limit,$limit*($page-1));
      return $query->result_array();
    }

    public function tagnum($tag) {  //根据标签返回记录信息
      $this->db->like('pic_tag', $tag);
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1));
      return $query->num_rows();
    }

    public function alltag($tag) {  //根据标签返回记录信息
      $sql   = "SELECT * FROM xi_picture WHERE pic_tag LIKE ? AND pic_status = ? ORDER BY RAND() LIMIT 6"; 
      $query = $this->db->query($sql, array('%'. $tag . '%',1));
      return $query->result_array();
    }

    public function check($page) {  //返回所有未审核的记录
      $this->db->order_by("ID", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 0),12,12*($page-1));
      return $query->result_array();
    }

    public function checknum() {
      $query = $this->db->get_where('xi_picture', array('pic_status' => 0));
      return $query->num_rows();
    }

    public function picturenum() {
      $query = $this->db->get_where('xi_picture', array('pic_status' => 1));
      return $query->num_rows();
    }

    public function todayhot() {
      $today       = date("Y-m-d");
      $today_start = $today . " 00:00:00";
      $today_end   = $today . " 23:59:59";
      $sql   = "SELECT * FROM xi_picture WHERE pic_datetime BETWEEN ? AND  ? AND pic_status = ? LIMIT 0,3"; 
      $query = $this->db->query($sql, array($today_start,$today_end,1));
      return $query->result_array();
    }

    public function todayhot2() {
      $today       = date("Y-m-d");
      $today_start = $today . " 00:00:00";
      $today_end   = $today . " 23:59:59";
      $sql   = "SELECT * FROM xi_picture WHERE pic_datetime BETWEEN ? AND  ? AND pic_status = ? LIMIT 3,3"; 
      $query = $this->db->query($sql, array($today_start,$today_end,1));
      return $query->result_array();
    }

    public function random() {  //随机返回1条记录
      $sql   = "SELECT * FROM xi_picture WHERE pic_status = 1 ORDER BY RAND() LIMIT 1"; 
      $query = $this->db->query($sql);
      return $query->result_array();
    }

    public function randombytag($tag) {  //随机返回1条记录
      $sql   = "SELECT * FROM xi_picture WHERE pic_tag LIKE ? AND pic_status = 1 ORDER BY RAND() LIMIT 1"; 
      $query = $this->db->query($sql, array('%'. $tag . '%'));
      return $query->result_array();
    }

    public function user( $user, $page ) {  //按照添加日期返回$user的所有图像记录
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1, 'pic_user' => $user),$this->pagenum,$this->pagenum*($page-1));
      return $query->result_array();
    }

    public function collect( $user, $page ) {  
      $this->db->order_by("pic_datetime", "desc"); 
      $query = $this->db->get_where('xi_picture',array('pic_status' => 1, 'pic_user' => $user),$this->pagenum,$this->pagenum*($page-1));
      return $query->result_array();
    }

  	//INSERT
    public function releasenew( $title,$info,$type,$picurl,$hash,$tags ) { //插入一条图片记录
      $now  = date("Y-m-d H:i:s");
      $username = $this->session->userdata('Username');

      if($this->system_model->sysinfo('is_image_status') == "TRUE")
      {
         $status = 0;
      } else {
         $status = 1;
      }

      if($this->user_model->is_admin($username)) {
        $status = 1;
      }

      $pic = array(
        'pic_uuid' => $hash,
        'pic_url'  => $picurl,
        'pic_name' => $title,
        'pic_type' => $type,
        'pic_text' => $info,
        'pic_user' => $username,
        'pic_tag' => trim($tags),
        'pic_status' => $status,
        'pic_datetime' => $now
      );
      $db = $this->db->insert('xi_picture',$pic);

      //更新标签的次数
      $tag  = explode (" ", $tags);
      for ($i = 0; $i < count($tag); $i++) {
        if ($this->tags_model->is_tag($tag[$i])) {
          $this->tags_model->addamount($tag[$i]);
        } else {
          if ($tag[$i] != "") {
            $this->tags_model->addtag($tag[$i]);
          }
        }
      }

      return $db;
    }

    //INSERT
    public function release( $picurl,$hash ) { //插入一条图片记录
      $now  = date("Y-m-d H:i:s");
      $username = $this->session->userdata('Username');
      
      if($this->system_model->sysinfo('is_image_status') == "TRUE")
      {
         $status = 0;
      } else {
         $status = 1;
      }

      if($this->user_model->is_admin($username)) {
        $status = 1;
      }

      $tags   = preg_replace("/\s|　/","",$this->input->post('tag')); //去除所以空格
      $newtag = str_replace(","," ",$tags);

      $pic = array(
        'pic_uuid' => $hash,
        'pic_url'  => $picurl,
        'pic_name' => trim($this->input->post('title')),
        'pic_type' => $this->input->post('type'),
        'pic_text' => $this->input->post('info'),
        'pic_user' => $username,
        'pic_tag'  => $newtag,
        'pic_status' => $status,
        'pic_datetime' => $now
      );

      $db = $this->db->insert('xi_picture',$pic);

      //更新标签的次数
      $tag  = explode (" ", $newtag);
      for ($i = 0; $i < count($tag); $i++) {
        if ($this->tags_model->is_tag($tag[$i])) {
          $this->tags_model->addamount($tag[$i]);
        } else {
          if ($tag[$i] != "") {
            $this->tags_model->addtag($tag[$i]);
          }
        }
      }

      return $db;
    }
  	//UPDATE
    public function addown( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $down = $value['pic_share'];
      }

      $down++;

      $data = array( 'pic_share' => $down );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $down;
    }

    public function addview( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $view = $value['pic_view'];
      }

      $view++;

      $data = array( 'pic_view' => $view );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $view;
    }


    public function addlike( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $like = $value['pic_like'];
      }

      $like++;

      $data = array( 'pic_like' => $like );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $like;
    }

    public function removelike( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $like = $value['pic_like'];
      }

      if ($like>0) {
         $like--;
      }

      $data = array( 'pic_like' => $like );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $like;
    }


    public function addlove( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $love = $value['pic_collect'];
      }

      $love++;

      $data = array( 'pic_collect' => $love );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $love;
    }

    public function removelove( $uuid ) {  //更新记录 浏览 次数
      $query = $this->db->get_where('xi_picture',array('pic_uuid' => $uuid));
      foreach ($query->result_array() as $value) {
        $love = $value['pic_collect'];
      }

      if ($love>0) {
         $love--;
      }
      
      $data = array( 'pic_collect' => $love );  
      $this->db->where('pic_uuid',$uuid); 
      $this->db->update('xi_picture', $data); 

      return $love;
    }


    public function pass( $uuid ) {   //审核通过
      $this->db->where('pic_uuid', $uuid);
      $this->db->update('xi_picture', array('pic_status' => 1)); 
    }

    public function edittags( $id,$tags ) {
      $data = array( 'pic_tag' => $tags );  
      $this->db->where('ID',$id); 
      $this->db->update('xi_picture', $data); 
    }

    public function setsort( $uuid, $string ) { 
      $this->db->where('pic_uuid', $uuid);
      $this->db->update('xi_picture', array('pic_sort' => $string)); 
    }

  	//DELETE
    public function delete( $uuid ) {   //删除图片记录
      $this->db->delete('xi_picture', array('pic_uuid' => $uuid)); 
    }

}
?>