<?php
	include_once('common/Logger.php');
    include_once('common/Database.php');
    include_once('common/Component.php');
    include_once('common/SetupFileSystem.php');
    include_once('common/FileSystemCheck.php'); 

    @unlink('install.log');

    $logger   = new Logger();
    $database = new Database();

    $logger->write('info', 'install start.');

    $dir = new FolderWritable();
    $is_write_upload = $dir->check('../upload/');
    $is_write_user   = $dir->check('../upload/user/');
    $is_write_config = $dir->check('../application/config/');
    $is_write_logs   = $dir->check('../application/logs/');

    if (!($is_write_upload & $is_write_user & $is_write_config & $is_write_logs)) 
    {
        $logger->write('error', 'folder not writable.');
        return;
    }

    $database_host     = $_POST['database_host'];
    $database_name     = $_POST['database_name'];
    $database_user     = $_POST['database_user'];
    $database_password = $_POST['database_password'];

    $status = $database->connect($database_host, $database_name, $database_user, $database_password);

    if ($status) 
    {
        $logger->write('info', 'database connect successed.');
    }
    else
    {
    	return;
    }

    $status = $database->RunSQLFile('files/xixi.sql');

    if ($status) 
    {
        $logger->write('info', 'query database successed.');
    }
    else
    {
    	return;
    }

    $status = $database->CreateAdministrator();

    if ($status) 
    {
        $logger->write('info', 'creat administrator successed.');
    }
    else
    {
        return;
    }

    $status = $database->SystemConfig();

    if ($status) 
    {
        $logger->write('info', 'creat webtitle successed.');
    }
    else
    {
        return;
    }

    $sysConfig = new OverWriteSystemConfig();

    $status    = $sysConfig->Install();

    if($status)
    {
        $logger->write('info', 'creat system config successed.');
    }
    else
    {
    	return;
    }

    $dataConfig = new OverWriteDatabaseConfig();

    $status     = $dataConfig->Install();
    
    if($status)
    {
        $logger->write('info', 'creat database config successed.');
    }
    else
    {
    	return;
    }

    if($status)
    {
        $install_lock = "../application/config/install.lock";
        if ( $fp = fopen($install_lock, 'a'))
        {
            fwrite($fp, "Installed");
            fclose($fp);
        }
        $logger->write('info', 'Xixi Image Install was Successful.You can delete install folder.');
    }
    else
    {
        $logger->write('info', 'Xixi Image Install was Unsuccessful.');
    }

/* End of file install.php */
/* Location: ./install/install.php */