<!DOCTYPE html>
<html lang="zh-cn">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>西西美图安装程序</title>
    <!-- Bootstrap -->
    <link href="../dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../dist/css/normalize.css" rel="stylesheet">
    <link href="../dist/css/signin.css" rel="stylesheet">
    <style>
    body {
      background-color: #FFFFFF;
    }
    </style>

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="http://cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="http://cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <div class="wrap">
      <div class="container">
        <div class="well well-lg">
          <?php if (!file_exists('../application/config/install.lock')) { ?>
          <h3>目录权限检测</h3>
          <?php 
            include_once('common/FileSystemCheck.php'); 
            $dir = new FolderWritable();
            $is_write_upload = $dir->check('../upload/');
            $is_write_user   = $dir->check('../upload/user/');
            $is_write_config = $dir->check('../application/config/');
            $is_write_logs   = $dir->check('../application/logs/');
          ?>
          <table class="table">
            <tbody>
              <tr>
                <td>upload</td>
                <?php if( $is_write_upload ) { ?>
                <td style="color: green;">writable</td>
                <?php } else { ?>
                <td style="color: red;">not writable</td>
                <?php } ?>
              </tr>
              <tr>
                <td>upload/user</td>
                <?php if( $is_write_user ) { ?>
                <td style="color: green;">writable</td>
                <?php } else { ?>
                <td style="color: red;">not writable</td>
                <?php } ?>
              </tr>
              <tr>
                <td>application/config</td>
                <?php if( $is_write_config ) { ?>
                <td style="color: green;">writable</td>
                <?php } else { ?>
                <td style="color: red;">not writable</td>
                <?php } ?>
              </tr>
              <tr>
                <td>application/logs</td>
                <?php if( $is_write_logs ) { ?>
                <td style="color: green;">writable</td>
                <?php } else { ?>
                <td style="color: red;">not writable</td>
                <?php } ?>
              </tr>
            </tbody>
          </table>

          
          <form action="install.php" method="POST" class="form-horizontal" role="form">
            <h3>数据库信息</h3>
            <div class="form-group">
              <label for="inputEmail3" class="col-sm-2 control-label">数据库服务器地址</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="database_host" value="localhost" required="true">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">数据库用户名称</label>
              <div class="col-sm-8">
                <input type="text" class="form-control"name="database_user" value="root" required="true">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">数据库用户密码</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="database_password" placeholder="" required="true" autofocus="true">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">数据库名称</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="database_name" value="xiximage" required="true">
              </div>
            </div>
            <h3>网站基础信息</h3>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">网站名称</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="webname" value="西西美图" required="true" maxlength="64">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">网站地址</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="weburl" value="http://" required="true" maxlength="128">
                <span class="help-block">访问你网站的地址 例如: http://xiximage.com/  不要忘记最后的 /</span>
              </div>
            </div>
            <h3>管理员信息</h3>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">管理员用户名</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="username" value="admin" required="true" maxlength="12">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">管理员邮箱</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="email" required="true" maxlength="64">
              </div>
            </div>
            <div class="form-group">
              <label for="inputPassword3" class="col-sm-2 control-label">管理员密码</label>
              <div class="col-sm-8">
                <input type="text" class="form-control" name="password" required="true" maxlength="18" placeholder="最少6位">
              </div>
            </div>
            <div class="form-group">
              <div class="col-sm-offset-2 col-sm-8">
                <button type="submit" class="btn btn-default">安 装</button>
              </div>
            </div>
          </form>
          <?php } else { ?>
            <h4>程序已经安装。如需重新安装请先删文件：/application/config/install.lock。</h4>
            <h4>重新安装将清空数据，请谨慎。</h4>
          <?php } ?>
        </div>
      </div>
    </div>
    <div class="footer">
      <div class="container">
        <p class="text-center text">Copyright © 2014 <a href="http://xiximage.com/" target="_black">西西美图</a> v 5.0 By <a href="http://hbdx.cc/" target="_black">dolphin</a></p>
      </div>
    </div>

    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="../dist/js/jquery-1.11.1.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="../dist/js/bootstrap.min.js"></script>
  </body>
</html>