<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
		\App\Http\Middleware\EncryptCookies::class,
		\Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
		\Illuminate\Session\Middleware\StartSession::class,
		\App\Http\Middleware\RockResponse::class,
		\App\Http\Middleware\CrossOriginResponse::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            'shareerrors',
            'bindings',
        ],
		
		'webapi' => [
			'shareerrors',
            'bindings',
			'json'
        ],

        'api' => [
            'throttle:60,1', //请求次数，1分钟60次
            'bindings',
			'json'
        ],
		
		'openapi' => [
            'shareerrors',
            'bindings',
            'openapicheck',
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'shareerrors' 	=> \Illuminate\View\Middleware\ShareErrorsFromSession::class,
        'json' 		=> \App\Http\Middleware\JsonResponse::class,
        'apiauth' 	=> \App\Http\Middleware\ApiauthResponse::class,
        'openapicheck' 	=> \App\Http\Middleware\OpenApiResponse::class,
        'auth' 		=> \Illuminate\Auth\Middleware\Authenticate::class,
        'auth.basic'=> \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' 	=> \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'can' 		=> \Illuminate\Auth\Middleware\Authorize::class,
        'guest' 	=> \App\Http\Middleware\RedirectIfAuthenticated::class,
        'throttle' 	=> \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'csrftoken' => \App\Http\Middleware\VerifyCsrfToken::class,
    ];
}
