<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Http\Admin;

use App\Xielei\Admin\Model\Config as ModelConfig;
use Ebcms\Config;
use Psr\Http\Message\ResponseInterface;
use Xielei\RequestFilter;
use Xielei\Session;

class Password extends Common
{
    public function post(
        Config $config,
        RequestFilter $input,
        Session $session,
        ModelConfig $configModel
    ): ResponseInterface {
        $oldpwd = $config->get('managers.' . $session->get('admin') . '.password@xielei/admin');
        if ($oldpwd != $input->post('oldpwd')) {
            return $this->failure('密码错误！');
        }
        $newpwd = $input->post('newpwd', '', ['trim']);
        if (strlen($newpwd) < 6) {
            return $this->failure('密码最少6位');
        }
        $configModel->save([
            'xielei' => [
                'admin' => [
                    'managers' => [
                        $session->get('admin') => [
                            'password' => $newpwd,
                        ],
                    ],
                ],
            ],
        ]);
        return $this->success('修改成功！');
    }
}
