<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Model;

use Ebcms\App;
use Ebcms\Hook;
use SplPriorityQueue;

/**
 * @property SplPriorityQueue[] $menus
 */
class Menu
{
    private $menus = [];

    public function add(string $group, array $value, int $priority = 50): self
    {
        if (!isset($this->menus[$group])) {
            $this->menus[$group] = new SplPriorityQueue;
        }
        $this->menus[$group]->insert($value, $priority);
        return $this;
    }

    public function getMenus(): iterable
    {
        App::getInstance()->execute(function (
            Hook $hook
        ) {
            $hook->emit('menu@xielei.admin');
        });
        foreach ($this->menus as $group => $value) {
            yield $group => clone $value;
        }
    }
}
