<?php

namespace Xielei;

class ImageCaptcha
{

    public function create(string $str, int $width = 100, int $height = 30, int $level = 5)
    {
        $im = imagecreatetruecolor($width, $height);

        imagefill($im, 0, 0, imagecolorallocate($im, 255, 255, 255));

        $count = intval(($width + $height) / 60) * $level;
        for ($i = 0; $i < $count; $i++) {
            imageline($im, mt_rand(-$width, 2 * $width), mt_rand(-$height, 2 * $height), mt_rand(-$width, 2 * $width), mt_rand(-$height, 2 * $height), imagecolorallocate($im, mt_rand(100, 255), mt_rand(100, 255), mt_rand(100, 255)));
        }

        $count = intval($width * $height / 300) * $level;
        for ($i = 0; $i < $count; $i++) {
            imagechar($im, mt_rand(1, 5), mt_rand(-10, $width + 10), mt_rand(-10, $height + 10), $this->randChar(), imagecolorallocate($im, mt_rand(100, 255), mt_rand(100, 255), mt_rand(100, 255)));
        }

        $str_arr = str_split(str_repeat($str . '  ', 15));
        for ($i = 0; $i < 10; $i++) {
            $base = [
                'x' => mt_rand(-count($str_arr) * 10, 10),
                'y' => $i * 15 - 5,
            ];
            foreach ($str_arr as $key => $value) {
                imagechar($im, 5, $base['x'] + $key * 12 + mt_rand(-2, 2), $base['y'] + mt_rand(-2, 2), $value, imagecolorallocate($im, mt_rand(0, 150), mt_rand(0, 150), mt_rand(0, 150)));
            }
        }

        $count = intval($width * $height / 100) * $level;
        for ($i = 0; $i < $count; $i++) {
            imagesetpixel($im, mt_rand(0, $width), mt_rand(0, $height), imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255)));
        }

        ob_start();
        imagepng($im);
        $content = ob_get_clean();
        imagedestroy($im);
        return $content;
    }

    private function randChar(): string
    {
        $str = 'QWERTYUIOPASDFGHJKLZXCVBNM1234567890qwertyuiopasdfghjklzxcvbnm~!@#$%^&*()_+`[]\;\',./<>?:"{}|';
        return $str[mt_rand(0, strlen($str) - 1)];
    }
}
