﻿# Host: localhost  (Version: 5.7.26)
# Date: 2020-07-25 17:51:38
# Generator: MySQL-Front 5.3  (Build 4.234)

/*!40101 SET NAMES utf8 */;

#
# Structure for table "prefix_xielei_manual_manual"
#

DROP TABLE IF EXISTS `prefix_xielei_manual_manual`;
CREATE TABLE `prefix_xielei_manual_manual` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `alias` varchar(255) NOT NULL DEFAULT '' COMMENT '目录',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `tpl_manual` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_post` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `state` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否发布',
  `body` text,
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT '目录',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='内容栏目表';

#
# Data for table "prefix_xielei_manual_manual"
#

INSERT INTO `prefix_xielei_manual_manual` VALUES (1,'ebcms/framework 手册','ebcms/framework','','','','',1,'## 写在最前\r\n\r\n很多人好奇，全球那么多php框架，为什么还要重复造轮子？\r\n\r\n本人从事php开发超过5年，用过很多的框架，thinkphp、laravel、zendframework...，也用过很多成熟的基于php开发的产品，比如wordpress、discuz、phpcms、dedecms...，但总是这里或者哪里不让我如意的地方。\r\n\r\n**我心中理想的框架应该具备：**\r\n\r\n- 标准化：常用的操作、通用的类库，应该遵守统一的规范或接口\r\n- 应用生态：应该有很好的应用分享机制\r\n- 国际化：世界各地的开发者都能够无缝参与进来\r\n\r\n于是ebcms/framework出来了\r\n\r\n## 项目特点\r\n\r\n#### 1.严格遵守PSR规范\r\n\r\n本项目严格遵守PSR规范，`消息`、`日志`、`缓存`、`容器`、`事件`、`代码规范`...\r\n\r\n遵守PSR规范带来的直接好处是即刻拥有了composer上的海量的生态资源，并且更容易让其他php开发者无缝参与进来。\r\n\r\n#### 2.先进的应用生态理念\r\n\r\n本项目原生理念就是为应用分享，基于composer优秀的包依赖机制，您开发的APP可以通过composer被世界各地的人使用，您也可以使用别人开发的APP。\r\n\r\n#### 3.极简内核\r\n\r\n得益于遵守PSR规范，我们的内核极度简单，概括来讲就是`流程`+`路由`+`配置`，系统没有其他多余的东西，因为PSR已经帮我们规定好了，你只需要符合PSR规范。\r\n\r\n***项目开源地址：[Github](https://github.com/ebcms/framework)，欢迎PR ^_^***','/ebcms/public/uploads/2020/07-23/5f1959005b2d1.jpg',1595486640,1595670581);

#
# Structure for table "prefix_xielei_manual_post"
#

DROP TABLE IF EXISTS `prefix_xielei_manual_post`;
CREATE TABLE `prefix_xielei_manual_post` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `manual_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1 目录 2文档',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键词',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '摘要',
  `body` text,
  `alias` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `state` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `rank` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `list` (`manual_id`,`state`) USING BTREE,
  FULLTEXT KEY `ft_index` (`title`,`keywords`,`description`,`body`) /*!50100 WITH PARSER `ngram` */ 
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='内容基本表';

#
# Data for table "prefix_xielei_manual_post"
#

INSERT INTO `prefix_xielei_manual_post` VALUES (1,1,12,2,'流程','','','系统流程执行如下：\r\n\r\n1. 入口文件`index.php`\r\n2. 载入文件`bootstrap.php`\r\n3. 执行钩子`app.start`\r\n4. 解析路由\r\n5. 执行钩子`app.start@包`\r\n6. 执行程序\r\n7. 执行钩子`app.end@包`\r\n8. 执行钩子`app.end`\r\n9. 结束\r\n\r\n`app.start`：系统开始解析路由之前\r\n\r\n`app.start@包`：路由解析完成后，此时可以得到请求的`包名`、`控制器名`\r\n\r\n`app.end@包`：此时系统已经完成执行，可以得到`响应`\r\n\r\n`app.end`：同上，只是`app.end@包`仅会在请求某个包的url下执行\r\n\r\n**特别说明**\r\n\r\n*若配置路由直接路由到闭包的时候，则不会执行相关包的钩子（即无5和7），因为没有经过包。*','',0,1595486686,1595662874,1,5),(2,1,12,2,'钩子','','','**整个系统有且仅有四个钩子**\r\n\r\n* `app.start`\r\n* `app.start@包`\r\n* `app.end@包`\r\n* `app.end`\r\n\r\n钩子的作用主要是在系统执行到某个点的时候，进行切面操作，例如：\r\n\r\n* 在`app.start`的时候注册路由\r\n* 在`app.end`的时候操作`响应`\r\n* 在`app.start@包`的时候，对该包的执行进行一些配置\r\n\r\n钩子会自动载入包对应文件夹下的**所有文件**，如下：\r\n\r\n* /hook/钩子名/\\*\\*.php\r\n* /所有安装了的包/src/hook/钩子名/\\*\\*.php\r\n\r\n**可以跨包操作**\r\n\r\n例如在`xielei/manual`包下面配置钩子`/hook/app.start@xielei.test/foo.php`,`/hook/app.start@xielei.test/bar.php`文件夹，在文件加下的文件就会在**`xielei/test`**包执行的时候引入上述两个文件\r\n\r\n常见的使用场景如下：\r\n\r\n* 设置模板路径，做主题包\r\n* 对其他包做插件\r\n* ...\r\n\r\n**钩子示例**\r\n\r\n记录全局请求日志 `/hook/app.start/log.php`\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\Container;\r\nuse Monolog\\Handler\\StreamHandler;\r\nuse Monolog\\Logger;\r\nuse Psr\\Log\\LoggerInterface;\r\n\r\nApp::getInstance()->execute(function (\r\n    Container $container,\r\n    App $app\r\n) {\r\n    $container->set(LoggerInterface::class, function () use ($app): LoggerInterface {\r\n        $log = new Logger($_SERVER[\'HTTP_HOST\']);\r\n        $log->pushHandler(new StreamHandler($app->getAppPath() . \'/runtime/log/\' . date(\'Y-m-d\') . \'/debug.log\', Logger::DEBUG));\r\n        return $log;\r\n    });\r\n    $container->get(LoggerInterface::class)->debug($_SERVER[\'REQUEST_METHOD\'] . \':\' . $_SERVER[\'REQUEST_URI\'], [$_POST, $_GET]);\r\n});\r\n```\r\n\r\n给`xielei/article`包自定义函数 `/hook/app.start@xielei.article/functions.php`\r\n```php\r\nfunction test(): array\r\n{\r\n    return [];\r\n}\r\n```\r\n\r\n给`xielei/article`包注入中间件 `/hook/app.start@xielei.article/middleware.php`\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\RequestHandler;\r\n\r\nApp::getInstance()->execute(function (\r\n    RequestHandler $requestHandler,\r\n    App $app\r\n) {\r\n    $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n});\r\n```\r\n\r\n...还有很多，这里就不一一列举。','',0,1595486693,1595664243,1,4),(3,1,12,2,'配置','','','**配置类`\\Ebcms\\Config`**\r\n\r\n配置分类三块：\r\n\r\n**用户配置**\r\n\r\n此配置位于系统的`config`文件夹下面，拥有最高的优先级，例如：\r\n\r\n`/config/xielei/article/site.php`\r\n\r\n**模块配置**\r\n\r\n模块配置有开发者事先配置，在对应包的`config`文件夹下面，例如：\r\n\r\n`包路径/src/config/site.php`\r\n\r\n**默认配置**\r\n\r\n默认配置是固定在代码中，无模块配置和用户配置的时候的默认值，例如：\r\n\r\n```php\r\n$config->get(\'key\',\'默认值\');\r\n$config->get(\'siteconfig@xielei.article\', [...]);\r\n$config->get(\'site.title@xielei.article\', \'某某网站\');\r\n```\r\n\r\n**优先级顺序**\r\n\r\n`用户配置`>`模块配置`>`默认配置`\r\n\r\n意思就是 在有用户配置的情况下会优先使用用户配置，否则就使用模块配置，若没有模块配置，再使用默认配置\r\n\r\n用法：\r\n\r\n```php\r\n$config->get(\'foo.bar@包\', \'默认值\');\r\n```\r\n\r\n例如：\r\n\r\n```php\r\n// 获取包xielei/article的配置文件site.php下的title值\r\n$config->get(\'site.title@xielei.article\');\r\n\r\n// 获取包xielei/article的配置文件site.php下的所有值\r\n$config->get(\'site@xielei/article\');\r\n```\r\n\r\n**只能获取已经安装的模块的配置数据**\r\n\r\n**包可以用`.`分割，也可以用`/`分割**','',0,1595486703,1595664255,1,3),(4,1,12,2,'中间件','','','**中间件遵守标准的PSR规范！**\r\n\r\n中间件由`\\Ebcms\\RequestHandler`管理\r\n\r\n支持如下方法：\r\n\r\n* `middleware(MiddlewareInterface $middleware)` 注册一个中间件\r\n* `middlewares(array $middlewares)` 注册多个中间件\r\n* `prependMiddleware(MiddlewareInterface $middleware)` 注册一个中间件(顶部追加)\r\n* `lazyMiddleware(string $middleware)` 注册一个中间件(字符串形式、命名空间形式)\r\n* `lazyMiddlewares(array $middlewares)` 注册多个中间件(字符串形式、命名空间形式)\r\n* `lazyPrependMiddleware(string $middleware)` 注册一个中间件(字符串形式、命名空间形式)(顶部追加)\r\n\r\n**前置中间件**\r\n\r\n前置中间件就是在获得响应之前进行条件判断返回其他响应，主要是用作拦截，比如权限认证、跳转等等\r\n\r\n一个前置中间件的示例：\r\n\r\n```php\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\nuse Psr\\Http\\Server\\MiddlewareInterface;\r\nuse Psr\\Http\\Server\\RequestHandlerInterface;\r\n\r\nclass Auth implements MiddlewareInterface\r\n{\r\n    public function process(\r\n        ServerRequestInterface $request,\r\n        RequestHandlerInterface $handler\r\n    ): ResponseInterface {\r\n        if (\'未登录\') {\r\n            // 在响应之前返回跳转\r\n            return new JumpResponse(\'http://...\', 302);\r\n        }\r\n        return $handler->handle($request);\r\n    }\r\n}\r\n\r\n```\r\n\r\n**后置中间件**\r\n\r\n后置中间件主要是在获得响应后，对`响应`做变更，例如往响应的代码中注入代码，比如加入统计代码之类的。\r\n\r\n一个后置中间件的示例：\r\n\r\n```php\r\nuse Ebcms\\StreamFactory;\r\nuse Psr\\Http\\Message\\ServerRequestInterface;\r\nuse Psr\\Http\\Message\\ResponseInterface;\r\nuse Psr\\Http\\Server\\MiddlewareInterface;\r\nuse Psr\\Http\\Server\\RequestHandlerInterface;\r\n\r\nclass RejectTongjiCode implements MiddlewareInterface\r\n{\r\n\r\n    public function process(\r\n        ServerRequestInterface $request,\r\n        RequestHandlerInterface $handler\r\n    ): ResponseInterface {\r\n        $response = $handler->handle($request);\r\n        // 在响应之后，对响应注入其他代码\r\n        $tongji_code = \'<script>...</script>\';\r\n        $contents = str_replace(\'</body>\', $tongji_code . \'</body>\', $response->getBody());\r\n        return $response->withBody((new StreamFactory())->createStream($contents));\r\n    }\r\n}\r\n\r\n```\r\n\r\n*前置中间件和后置中间件的代码区别就是前置是在`$handler->handle($request)`处理之前返回其他`响应`，后置是在获取`$handler->handle($request)`响应之后对`响应`做出处理*\r\n\r\n**将中间件注入到系统**\r\n\r\n注入到系统中有很多方式，比如在钩子上注入，也可以在控制器中注入，也可以在路由上注入\r\n\r\n**通过钩子注入示例**\r\n\r\n```php\r\n// /hook/app.start/aaa.php\r\nuse Ebcms\\App;\r\nuse Ebcms\\RequestHandler;\r\n\r\nApp::getInstance()->execute(function (\r\n    RequestHandler $requestHandler\r\n) {\r\n    $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n});\r\n```\r\n\r\n**在控制器中注入示例**\r\n\r\n```php\r\nuse Ebcms\\RequestHandler;\r\n\r\nclass Index\r\n{\r\n    public function __construct(\r\n        RequestHandler $requestHandler\r\n    ) {\r\n        $requestHandler->lazyMiddleware(SomeMiddleware::class);\r\n    }\r\n}\r\n```','',0,1595486714,1595664331,1,2),(5,1,12,2,'路由','','','**路由类`\\Ebcms\\Router`**\r\n\r\n**注册路由**\r\n\r\n方法如下：\r\n\r\n```php\r\n$router->getCollector()->... \r\n$router->getCollector()->get(\'/index\', Index::class, \'第三个参数是路由别名\');\r\n```\r\n\r\n**支持`get`,`post`,`put`,`delete`,`patch`,`head`等方法。**\r\n\r\n另外也支持路由分组，例如：\r\n\r\n```php\r\n$router->getCollector()->addGroup(\'/sub\', function($route){\r\n\t$route->get(\'/a\', ControlerA::class,\'/suba\');\r\n\t$route->get(\'/b\', ControllerB::class,\'/subb\');\r\n\t$route->addGroup(\'/sub2\', function($route){\r\n\t\t$route->get(\'/cc\', ControllerC::class, \'/subsub\');\r\n\t});\r\n});\r\n```\r\n\r\n**生成地址**\r\n\r\n`$router->buildUrl(\'/suba\')`就会生成`/sub/a`\r\n\r\n`$router->buildUrl(\'/subb\')`就会生成`/sub/b`\r\n\r\n`$router->buildUrl(\'/subsub\')`就会生成`/sub/sub2/cc`\r\n\r\n**路由分发**\r\n\r\n当访问`/sub/sub2/cc`的时候，就会分发到`ControllerC`控制器。\r\n\r\n**默认路由**\r\n\r\n上面讲的是自定义路由的情况，若是没有定义路由，系统会有默认路由，规则如下：\r\n\r\n`/包/路径`\r\n\r\n举例：\r\n\r\n* `/xielei/article/index` 路由到 `App\\Xielei\\Article\\Http\\Index`\r\n* `/xielei/article/admin/article/create` 路由到 `App\\Xielei\\Article\\Http\\Admin\\Article\\Create`\r\n* `/xielei/article/admin/create-category` 路由到 `App\\Xielei\\Article\\Http\\Admin\\CreateCategory`\r\n* `/xielei/my-demo/show-item` 路由到 `App\\Xielei\\MyDemo\\Http\\ShowItem`\r\n\r\n**绑定域名**\r\n\r\n示例代码如下：\r\n\r\n```php\r\n$router->getCollector()->addGroup(\'http://www.ebcms.com/sub\', function($route){\r\n\t$route->get(\'/foo\', ControlerA::class,\'/name-1\');\r\n\t$route->addGroup(\'/sub2\', function($route){\r\n\t\t$route->get(\'/cc\', ControllerC::class, \'/name-2\');\r\n\t\t$route->get(\'/cc/ddd.html\', ControllerC::class, \'/name-houzui\');\r\n\t});\r\n});\r\n\r\n$router->buildUrl(\'/name-1\'); // http://www.ebcms.com/sub/foo\r\n\r\n$router->buildUrl(\'/name-2\'); // http://www.ebcms.com/sub/sub2/cc\r\n\r\n$router->buildUrl(\'/name-houzui\'); // http://www.ebcms.com/sub/sub2/cc/ddd.html\r\n```\r\n\r\n**通常，要是不绑定域名，不限制https或http的话 `http://www.ebcms.com/` 可以通过代码获取当前的域名而不必固定写死**\r\n','',0,1595486720,1595664345,1,1),(6,1,12,2,'依赖注入','','','**容器类`\\Ebcms\\Container`**\r\n\r\n**依赖注入来自开源项目[ebcms/psr11](https://github.com/ebcms/psr11)，欢迎PR ^-^.**\r\n\r\n依赖注入的好处就是可以全局管理类，无须实例化直接获取。\r\n\r\n**自动实例化类**\r\n\r\n```php\r\nclass Bar\r\n{\r\n    public function __construct()\r\n    {\r\n    }\r\n}\r\n\r\n\r\nclass Foo\r\n{\r\n    public function __construct(Bar $bar)\r\n    {\r\n        $this->bar = $bar;\r\n    }\r\n    \r\n    public function getBar()\r\n    {\r\n        return $this->bar;\r\n    }\r\n}\r\n\r\n$foo = $container->get(Foo::class); //Foo\r\n$foo->getBar(); //Bar\r\n```\r\n\r\n而无须实例化Foo类，也不需要实例化Bar类，这一切都通过$container帮您完成。\r\n\r\n**默认的，执行的控制器的构造方法`__construct()`支持依赖注入，例如：**\r\n\r\n```php\r\nuse Ebcms\\App;\r\nuse Ebcms\\Config;\r\nuse Ebcms\\Router;\r\nuse Xielei\\Template;\r\n\r\nclass Index\r\n{\r\n    public function __construct(\r\n        App $app,\r\n        Router $router,\r\n        Config $config,\r\n        Template $template,\r\n        ...\r\n    ) {\r\n        $config->get(......);\r\n        $router->buildUrl(..);\r\n    }\r\n}\r\n```\r\n\r\n**通过容器获取的类支持依赖注入，例如：**\r\n\r\n```php\r\n$container->get(Foo::class);\r\n```\r\n\r\n那么 此处的Foo类的构造函数就可以依赖注入\r\n\r\n**通过`App::getInstrance()->execute(function(...){})`实现依赖注入，例如：**\r\n\r\n```php\r\nApp::getInstance()->execute(function (\r\n    App $app,\r\n    RequestHandler $requestHandler,\r\n    RequestFilter $input,\r\n    Router $router,\r\n    Config $config,\r\n    Template $template,\r\n    ....\r\n) {\r\n    $app->....\r\n});\r\n```\r\n','',0,1595486816,1595664361,1,0),(7,1,12,2,'说明','','','为了文档的简洁，本文档对一些常用的、标准的术语或变量等作了简写，具体如下：\r\n\r\n## 系统\r\n\r\n| 变量      | 实体                | 备注 |\r\n| --------- | ------------------- | ---- |\r\n| `$app`    | `\\Ebcms\\App`实例    | 应用 |\r\n| `$router` | `\\Ebcms\\Router`实例 | 路由 |\r\n| `$config` | `\\Ebcms\\Config`实例 | 配置 |\r\n\r\n## Psr 标准\r\n\r\n| 变量               | 实体                                     | 备注     |\r\n| ------------------ | ---------------------------------------- | -------- |\r\n| `$uriFactory`      | 实现接口`UriFactoryInterface`的实例      | URI 工厂 |\r\n| `$responseFactory` | 实现接口`ResponseFactoryInterface`的实例 | 响应工厂 |\r\n| `$response`        | 实现接口`ResponseInterface`的实例        | 响应     |\r\n| `响应`             | 实现接口`ResponseInterface`的实例        |          |\r\n| `$container`       | 实现接口`ContainerInterface`的实例       | 容器     |\r\n| `$cache`           | 实现接口`CacheInterface`的实例           | 缓存     |\r\n| `$logger`          | 实现接口`LoggerInterface`的实例          | 日志     |\r\n| `$simplecache`     | 实现接口`SimpleCacheInterface`的实例     | 简单缓存 |\r\n| `$...`             | ...                                      | ...      |\r\n\r\n_还有很多，具体请看[PSR](https://www.php-fig.org/)官方文档_\r\n\r\n','',0,1595488340,1595670147,1,6),(12,1,0,1,'核心手册','','',NULL,'',0,1595665449,1595665481,1,4),(13,1,0,1,'第一个APP(入门)','','',NULL,'',0,1595665480,1595665815,1,3),(14,1,13,2,'文件结构','','',NULL,'',0,1595665524,1595665582,1,2),(15,1,13,2,'包配置','','',NULL,'',0,1595665537,1595665571,1,1),(16,1,13,2,'HelloWorld','','',NULL,'',0,1595665568,1595665954,1,0),(17,1,0,1,'第二个APP(进阶)','','',NULL,'',0,1595665829,1595665836,1,2),(18,1,0,1,'杂项','','',NULL,'',0,1595665833,1595665837,1,1),(19,1,18,2,'App全网发布','','',NULL,'',0,1595665851,1595666027,1,2),(20,1,18,2,'实现restful风格的控制器','','',NULL,'',0,1595665911,1595665920,1,1),(21,1,18,2,'制作私有APP','','',NULL,'',0,1595666121,1595666123,1,0),(22,1,0,1,'优秀APP推荐','','',NULL,'',0,1595670345,1595670388,1,0),(23,1,22,2,'xielei/manual 文档系统','','',NULL,'',0,1595670367,1595670368,1,3),(24,1,22,2,'xielei/info 分类信息管理系统','','',NULL,'',0,1595670454,1595670470,1,2),(25,1,22,2,'xielei/article 文章管理系统','','',NULL,'',0,1595670468,1595670469,1,1),(26,1,22,2,'xielei/installer 安装引导系统','','',NULL,'',0,1595670569,1595670581,1,0);
