<?php
/** 
 * 程序说明
 * @package   Drawer
 * @author     Joytou, Pzy
 * @copyright  Copyright (c) 2019
 * @version    1.0.1.1(Release)
 *
 * 设置说明
 * $sitetitle - 标题名称
 * $username - 用户名
 * $password - 密码
 * $timezone - 默认时区
 * $open_basedir - 限制可访问目录。为空字符串即不限制，建议设置为__DIR__，仅可以访问当前目录和子目录。
 * $safe_num - 限制最多可尝试登录次数，为0则不限制，建议设置为3-5
 * $logable - 进行日志记录。true则记录操作日志，false则不记录。日志记录保存在与文件管理器文件同名的.log文件中。例如：filebox.php.log
 */
$sitetitle = "Drawer";
$username = "admin";
$password = "admin";
$timezone = "Asia/Shanghai";
$open_basedir = __DIR__;
$safe_num = 3;
$logable = false;

if( !headers_sent() && // 如果页面头部信息还没有输出
extension_loaded("zlib") && // 而且php已经加载了zlib扩展
strstr($_SERVER["HTTP_ACCEPT_ENCODING"],"gzip")) //而且浏览器接受GZIP
{
	ini_set('zlib.output_compression', 'On');
	ini_set('zlib.output_compression_level', '4');
}
header( 'Content-Type: text/html; charset=utf-8' );
date_default_timezone_set( $timezone ); //设置默认时区
ini_set( 'open_basedir', $open_basedir ); //限制可访问目录，避免恶意修改
define( 'php_self', substr( $_SERVER[ 'PHP_SELF' ], strrpos( $_SERVER[ 'PHP_SELF' ], '/' ) + 1 ) ); //获取文件管理器文件名
session_start();

$version = '1.0.1.1';
$dir = ( isset( $_POST[ 'dir' ] ) && $_POST[ 'dir' ] != '' ) ? $_POST[ 'dir' ] : '.'; //获取当前目录
$dir = htmlspecialchars( $dir );
$dir = dircode( $dir );
$opendfile = ( isset( $_POST[ 'file' ] ) && $_POST[ 'file' ] != '' ) ? $_POST[ 'file' ] : ''; //获取当前打开的文件
$opendfile = htmlspecialchars( $opendfile );
$operate = ( isset( $_POST[ 'op' ] ) && $_POST[ 'op' ] != '' ) ? $_POST[ 'op' ] : ''; //获取要进行的文件夹或文件操作
$extradata = ( isset( $_REQUEST[ 'data' ] ) && $_REQUEST[ 'data' ] != '' ) ? $_REQUEST[ 'data' ] : ''; //获取额外的数据，内容视具体操作而定
$_SESSION[ 'order' ] = ( isset( $_POST[ 'order' ] ) && $_POST[ 'order' ] != '' ) ? $_POST[ 'order' ] : ( isset( $_SESSION[ 'order' ] ) ? $_SESSION[ 'order' ] : '' ); //获取排序字段名
$_SESSION[ 'sort' ] = ( isset( $_POST[ 'sort' ] ) && $_POST[ 'sort' ] != '' ) ? $_POST[ 'sort' ] : ( isset( $_SESSION[ 'sort' ] ) ? $_SESSION[ 'sort' ] : '' ); //获取排序方式
$showNavbar = false; //是否展示导航栏
$isWindows = DIRECTORY_SEPARATOR == '\\';
$msg = "";

/**
 * 错误处理函数
 *
 * @access public
 * @param integer $errno 错误的级别
 * @param string $errstr 错误的信息
 * @param string $errfile 发生错误的文件名
 * @param integer $errline 错误发生的行号
 * @return boolean
 */
function myErrorHandler( $errno, $errstr, $errfile, $errline ) {
	$log_file = "./php_%s_log_" . date( "Ymd" ) . ".log"; //定义日志文件存放目录和文件名  
	$template = '';
	switch ( $errno ) {
		case E_USER_ERROR:
			$template .= "用户ERROR级错误，必须修复 错误编号[$errno] $errstr ";
			$template .= "错误位置 文件$errfile,第 $errline 行\n";
			$log_file = sprintf( $log_file, 'error' );
			exit( 1 ); //系统退出  
			break;
		case E_USER_WARNING:
			$template .= "用户WARNING级错误，建议修复 错误编号[$errno] $errstr ";
			$template .= "错误位置 文件$errfile,第 $errline 行\n";
			$log_file = sprintf( $log_file, 'warning' );
			break;
		case E_USER_NOTICE:
			$template .= "用户NOTICE级错误，不影响系统，可不修复 错误编号[$errno] $errstr ";
			$template .= "错误位置 文件$errfile,第 $errline 行\n";
			$log_file = sprintf( $log_file, 'notice' );
			break;
		default:
			$template .= "未知错误类型: 错误编号[$errno] $errstr  ";
			$template .= "错误位置 文件$errfile,第 $errline 行\n";
			$log_file = sprintf( $log_file, 'unknown' );
			break;
	}
	//    file_put_contents($log_file,$template,FILE_APPEND);  
	return true;
}
$error_handler = set_error_handler( "myErrorHandler" ); //开启自定义错误日志  

/**
 * 将字符串进行UTF-8编码，并返回编码后的字符串以及原字符串的字符集
 *
 * @access public
 * @param string $str 要编码的字符串
 * @return array(["code"], ["string"])
 */
function encode( $str ) {
	$arr = array();
	if ( function_exists( 'mb_detect_encoding' ) )
		$encode = mb_detect_encoding( $str, array( 'ASCII', 'UTF-8', 'GB2312', 'GBK', 'BIG5' ) );
	else
		$encode = 'UTF-8';
	switch ( $encode ) {
		case 'EUC-CN':
			$encode = 'GB2312';
			break;
		case 'CP936':
			$encode = 'GBK';
			break;
	}
	$arr[ "string" ] = mb_convert_encoding( $str, 'utf-8', $encode );
	$arr[ "code" ] = $encode;
	return $arr;
}

/**
 * 将已按照UTF-8编码的字符串进行解码
 *
 * @access public
 * @param string $str 需要解码的字符串
 * @param string $code 字符串默认的字符集
 * @return string
 */
function decode( $str, $code ) {
	return mb_convert_encoding( $str, $code, 'utf-8' );
}

/**
 * 将url地址的特殊符号进行编码
 *
 * @access public
 * @param string $str url地址
 * @return string
 */
function urlcode( $str ) //对URL特殊符号进行编码
{
	$arr_find = array( '+', ' ', '?', '%', '#', '&', '=' );
	$arr_replace = array( '%2B', '%20', '%3F', '%25', '%23', '%26', '%3D' );
	return str_replace( $arr_find, $arr_replace, $str );
}

/**
 * dir路径去除末端"/"符号和"%2F"
 *
 * @access public
 * @param string $dir dir路径
 * @return string
 */
function dircode( $dir ) {
	$rdir = $dir;
	while ( ( substr( $rdir, -1 ) == '/' ) || ( substr( $rdir, -3 ) == '%2F' ) ) {
		if ( substr( $rdir, -1 ) == '/' ) {
			$rdir = substr( $rdir, 0, strlen( $rdir ) - 1 );
		}
		if ( substr( $rdir, -3 ) == '%2F' ) {
			$rdir = substr( $rdir, 0, strlen( $rdir ) - 3 );
		}
	}
	return $rdir;
}

/**
 * 页面头部
 *
 * @access public
 * @global string $sitetitle 页面标题
 * @global string $showNavbar 是否展示导航栏
 */
function maintop() {
	global $sitetitle, $showNavbar;
	$logo = 'data:image/png;base64,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';
	$bg = 'data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAUEBAQEAwUEBAQGBQUGCA0ICAcHCBALDAkNExAUExIQEhIUFx0ZFBYcFhISGiMaHB4fISEhFBkkJyQgJh0gISD/2wBDAQUGBggHCA8ICA8gFRIVICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICD/wAARCAJYAyADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDvD1pppx60011kDabTqbQA09ajPWnMaYaCRD0pKDSUGTGnrTT1p1NPWqERnpSUp6UlAxKKKKBBRRRQA2ilxRigBKKXFGKACnCgCigYo60tJS4zQA2lpce1KFNACUoWnAelLigVyLFGKfto2UDuMxRin7KNtAXIiKTFSFT2pCD3oAjIptSYpMUCI6KfijFADKKfikwKAI6KftHpRtHpQSMop+0elG0elAABTgKUCnAUFABTwDmhRUgFAxwFOAoAp4FSWKBUg60gFPA5oAlXgU8U0U8VIhwp46Zpop/QUDFPWlFIetKKDQWnjrTKfTAfRRRUgFFFFACr1p1NXrTqQxR0paQdKWgBacOlNpw6UygpwptOoAfSimU4HmosWSCnUwGnA9qLDH0o6UlKOlSIcOtOpo606gaCiilAoGFKOtJTqoB46UUUVIBQelFB6UARmkpxFJimA2ig9aKQ7Bn3pCabmjNUFhGqFzxUhNRnrQBTlXrVQ8GtKVMrWfKuDVEMbnjFRN1pxNMNBDID1pppx6001oQNpp6U6mnpQBEetMNObrTTQSNNJmlPWm0GTCmnrTqaetUIjPSkpT0pKBiUUUUCCiiigAopaKBiUUtFAWDFLSijBoAUDNOopQKBC4pcUUooATFGKdRigBuKMU/FGKAsMxRin4oxQFiLFGKkppFAERUU0qfSpSKTFAyLbRtNPwaTB9KAsMwaMU/B9KTaaAsN20bak2mjaaCCPbRtqTaaNpoAaFNPUU4CnAUFCAU4ClApwHNADgKkAoHSngVJYAU8CgU4DPAoGPFOFIAacBSEPUU8U1elPqR9QPWnL0pp605elUaC0tJS0AOopOaMmpAWikyaOaAHL1p1NXrTqQxR0paQdKWgBacOlJSjpTKCnU2nUALmlFNpRTsWSDpTh1pi9aeM5pWGSUo6Ug6Uo6VkIcOtOpo606gaFoop1UMKUDNA606kAUUUUgCjtRRQAw0UGig1sMPWkp2OaKBWIu9FLjmlqiGxhFMxzUpphxQSRydKz5l61fc1VlGaoTM9hTTUsgwaioIZAetNPWlJ5pCea0MhtNPSnUw9KAIW6009ac3WmnrQA2kpaSgyYU096dTT3qhojNJSmkoEFBoooAbSU7FGKBBS0uBRigYlOHWlCjvSgDNAx1LilxS4oGJS4pcUuKBjcUtOxRipKEpcU7bS7aAGYNG01LijFAEW00bTUuKMUAQYNGKkKnPSk2n0oAZik21JtPpRsPpQBFijaPSpNp9KNp9DQBHtHpRt9qk2n0NG0+lAEe2jbUuKMUGdiLbRtqXFGKBWGhaULUgWnBaChgQ4p4TFPAp2KAGhakC0oFPAqSxAKcBzSgU4DmgBwHFFOCjFG0UCG0o60u0UoAzQA8dKcKaOlOFMsKdTadQAUUUUDCiiigBB1paUUtBQg6U4daB0pR1oAdS9sUmaKkoKUdaB1pwAoAWnjtTacOcVAD1HNPAGelIOKcKAJKUdKSlHSpKRJSHpS0h6UCHDpTqaOlOoLFFLSCloAbRS4oxQAlFLijFADaSnUmKDQiPWinEZptBIlIadTTVEMY1R5p7VHQSRNmoyOKnIzTSvFWmDM+ZcVWq/OvBqi3BqiGVaaetOJ5ppPNMyG009KdTSeKAIj1pp6049aaetADaSlpKDNhTT3paQ96oERmkpTSUCCilxQAc0AGKMU4Kc07FAwwPSlAHpS4paAG0o60tKKAFxS4pcUoFBQmKUClwacFoEG32pcU7FLipLG4pcU4CjFADcUYp+KMUAMxRin4oxQA3FGPenYoxQA3HvRj3p2KMUAM20bafijFADNtG2n4oxQBFso2VLijFAWItlG2pcUYoCwgFOApwU+lOC0EjQpxTgvFPA4pwFAXG4pwHFO20oAqR3EAp+2lAFOxQAlFLkUZosMSgdaXNGaLAKOlOFJSimUFOptOoAKKKKBhRRRQAopaYOtLQUPFFNHSloAdmnDpTKcOlQUOHWpMU1RTqAFxTh2pKcvUVIEgFOpBTgKAHUo6UlKOlSUiSkPSlpD0oEOHSnU0dKdQWKKWkFLigAxRilooHYTFGKWigLDSKSnUhoLIzRTjTaBDKaadTTVGbI2qM1I1RN0NBImaRjxSZ5pjmqBkcnOaoyrg1dqGRc1SJMgnmmk0Uh61RiIT70wn3optADSeaTvSnrTe9BAh6Ug+6aU9KRelAxAaWjaKXFMQmB6UmBTsUYpiG4HpTsCjFOxQAgFLigClxQFhKUU7AoxUmglLinBfSl20AAp46UBRTgBQMKcAKUAUuBQMTbS7aXFLioGJtpdtLilxTANlGyn4pcUAR7KNlSYoxQBHsPpRsPpUuKMUARbD6UbD6VLijFAEWw+lGw+lS4oxQBFsPpRsPpUuKMUARbDRsNTYoxTEQ7DRtNTYoxQA0KaMNUmKMUAR4alAbNPxQBQA4dKM0uKMUgEzS5NGKUDmgBw6UEcilxxRTGFMIxT8UUALRRRQAU6kApaAG0U7HtRj2oKG0U7HtRj2oAQUo60oBpcUAFOHUUYNKMigBacKTFKKAHCloFLigBQaetMpy1mUSA0opnenjrUM0Q/FKBRThQIUClA5oFOHWmA4CnAUlOFIoUCnbaARmnUAMopcH0owaBiUUuDSYOKAGHrSGlI5pCKBDKSnYpuKBDaQ0tIabERtUJ71M1QnvQgGGmNTzTGrVEsjPWoX61MetQt1oEYZPNNLc0FhmmkjNMwEzSZopKYCHrTe9LSd6CBD0pF6UtA6UALRS0UAJRS0UxCUtLS0zSwgpR1pRS0BYcFOKULTl6U7FSA3FLinUtAAAacAaUU4A0FCAHHSnBfanAU7FAhoX2pdo9KdilxUlDcD0pQKcBSgUALijbT9po2miwDNtG2n7aUJzRYBAgxRsHrUm2l20ARbB60bB61Lto20ARbB60bB61Lto20ARbB60bB61Lto20ARbPajZ7VLijFMRFs9qNntUuKMUARbD6UbD6VLijFAEWw+lGw+lS4oxQAzA9KMD0p+KMUAMwPSlp2KMUAJS4p2KTFIY2jFOIpMUwEpQKWigApaKWpAMUYpaKooTFGKWlwaAF2+9AXmnUDrQAYoxS0UAFKBQBSikA4UtIOlOFABinKKMU8CoKEA5p4HNAFPHrUM0QoHFOApKUU0IcBzTsCkXrTqAEzThRilApFCinCgCnbRQMWijFGKCQoPSjFBBxQMjPWmmnEc0hHNAxlNp2KTFBJHSGlpDTYiNqhPepmqE96EAw0xqeaY1aolkZ61C3Wpj1qFutAjnCeaCaKKowEzSUUUAFFFFABRRRQAlAoxTgKAAU7FAFLigBMU7FAHNOwKAEUCnYFKBS4pAFOAoxTgKYwFKBSgU4CgYgFOApQtOAqRgBTsUoFOAoATFOAp4AxTgKZQ0LTgtOAp2KAG4ox7U7BpcVFxjNtKBzT9vtSheelAhMUYqTaKNoosBHijFSbRRtFAEeKMVJtFG0VdwI8UYqTaKNoouBHijFSbRRgUgI8UYqTAowKAIsUYqTaKNopgR4oxUm0UbRQBHijFLijFQAmKKXFGKAFoxTtvHWjb71YDcCkwKft96NvvQBHSinbaXb70ANp2OKUKKXFAEdPHSk2inAcUAA60tAHNLigBlFP2j0o2j0qLlDKcvWl2j0pQOaAFpRSgUuKkBKcOtABpwXmgBwpwpAKcBUjFFOHSkAp4AxQMSlFFKKYxwB4p1A7U6gBadSU7GDSLBetOHWjHOaB1oEOooooEFFFFADajbqakqNupoGhh6UynnpTKBDT0qM1IelRmrYiM1EetSmoj1pDGGmNTzTGrQhkLdahepm61C9MRz9FFFMwG0UUUAFFFFABRRRQAuKcBQKUUAKBTwKAKdQAmKXFFLQAAUuKBS0AOApwFA6VIBQUIFpwFKBTgKAEApwFLinAVAxAKdilCmngU7AJilAp22nBaZQ0CnAU8LTgtADcUoFP20oWoKGgGnYpwFLRcQ3FGKfRRcQzFGKfRRcBmKMU+ipuAzFGKfRRcCLFGKfRWgDMUYp9FMCPFGKf+FH4UAMxRin/hR+FAEeBRgU6ipAbgUYFOooATFLilxS49qoBuKMU7HtRj2oAbigCn4ooAbilxThS0AR04dKKKQBRSjrS0AGPajHtTqMH0qChuPagCnYNLg0AG2lAFLilpAJilxS4paAAdacKBThUjAU8dKF6U4dKBjcU4Dikpy9KYxwFOxSClpAOxxT6ADilxzQUHel70UDrQIKKKKACiiigBtRt1NSVG3U0DQw9KZTz0plAhp6VGak7GozVsRGaiPWpTUR60hjDTGp5pjVoQyFutQvUx61E4NMRzlFFFM5AooooAKKXFLig0CilxS4oAAKeo70gX1p4FAAKdQBTsUANpRS4pwFBQgFOxShaeF5oAQCpAMUoXinAc1JYAU8DmkAxT1B60AOApQKXFKBTAAKdigCnYoAKUUYpQKgoWpKaAMU+gBcUYpaKkBMGjBpaKACijFGKACijFLigBMUYpaKAExRilooASijFGKYBRRijFADaKXFGKAEopcUYpgNxRin0VVxDMUoFOpMUXEGKMU7FGKgobijFOxRigBMUYp+2jbQAzFGKfto20AG2jbT8UYpDGbaNtPxRigBgBzTse1KBzS4oAaB7UuPanAUuKAExRinUv4UgExQBTh7inY9qACiiimUFKOtAFPC80AOA4pQKUClxUgApw60YpQOaYDwOKXFA6UVJYUUUUAJRS4oxQAlFLijFACVG3WpKjbrTEiM9KaelOPSmnpQBG1RmpGqM00SR96Y1P70xutWhsY3Won71K3Won71SIYzvUbAVJ3FRtQhHMUUUVRxhRRRQMfilxSgcUoGaDQQCnBadijBoAMU4CgCnAUAAFOA5oANPVaAAD2pwWnAcU4CgoQClxTgKcBk0AIFp4X2p4HFAFSWIFx1p1LilC0wFApQKUClAOKAFApwHpSgYpaAEwacAcUtKKgoMU7FFLSAMUYoopAGKMUUtACUU7aaNpoAbSjrS7aNtABtFG0U7FGKAG7RRtFOxRigCOilwaMGmAlFLg0YNADaKXaaNpoASil2mjaaADFGKdtNG00rgNxSgc0u00AEGi4hQOOlGPanDpRU3GNx7UuPaloouAuKXFLRRcBMUYp1GKLgJijFOopjG4oxTqKAGheaXb7U4dadQMaF4pdlOHSlpiGbaXbS4NKAaBiAUuKXFLQIjpQKMU9QaChQKfigCnYqQClxSgUtMBtKOtLSjrTAdRRRUFhRRRQAuKMUtFACYoxS0lADajbrUlRt1piRGelNPSnnpTCOKAI2qM1I1RmmiSPvTG61J3phBq0NkbdaifvUrdaifvVIhjO4qNqk71G1AjmKdTadiqOZABQBzTgKULzQUPAxSgUoFOAoAQCnYpQKXFACAU8ClC08LSKEC1IABQBTwKQCAU4CnhaUKKCxoFPAGaUClAoAMUoFOxRimAmKcKXFKF56UAOA4pQMmgA07pUFBgUoFAFLSAXFGKWigBMUc0tFAC0UUUgCiiigCSgdaKB1oAWlFJSigBaKKKkYUUUUANooooAKKKKAEopaKAEopaKAEopcUuKAEop2KXAoAZSjrTqXFBQ2lFOoAoAQdaWnAc0uKYDRRTwKMUWAbRUmKMUiiOipMUYoAbgUoAp+KUCgQzAp2B6U7FLigdiPAowPSpMUYoCwzA9KKfijFAWG4pwFO2+1O20CaEAp4HNIBTgMUxBRS4pcVJYlLilA9KXbQAbaNv0p2KXFADNv0o20/FGKAGYNJUmKQigCPmkp5BpuKAEpDTsUhoAjNIRxTjSUAV3FREVYIqNhzVEEOKQipMUhFAFZk5qJl61aIqNlqh3KhU54pjKaslaYy1SJZyQp1Np4Gas5RVHepAKQCnAUDHAU4CgCnqO9AAFpwFKAacFoAULxTgtKBTgtIoQCnhcmgKc1IFxQABeKXFPA4pcUFjMe1KBTsUoBz0oAAvFOC04ClxSAbilxTqXFACUAUuKKgoKXFApaAFxRiiigAxRiiigAooopAFFFLQA+gdaMUuKAClFJSigBaKKKkYUUUUAFFFFABRRRQAYoxS0UAJilxS0UAGKMUtOoGJil2mlUU6gBm2jbS0op2GJtpQvNLg+lOAOaAGhOadspwHNLigBoXil2+1OApcGkAm2jbT8GjaaChm2jbT8H0o2mgBNhpQnFPxQBQA3ZTtvtS4p2KAI9oo2inYoxQA3aKNop2KMUAGKMU/HtRigBuKXFLRQIMH0pwX1paUUihMUuKWlxQAmKXFLxRxQAmKMUvFHFACYpMU7FJQA3FJj2pxFFAER60hp5GaaQaAIzSU8im4oAiIqNhUxFRkUyCKkIqQrmkxxTAhYVGambPpUZpktkJ+lRmpiKjYGqFc5LaKkUCkxT1FaGAADFPAGaAOKeF56UFChaeFpQtPAqRgBUgUE0KtPC0AJtHpTgtOwKcAKZQ0LS7aeAKcAPSgBNtKF5p2KXFIBKUDmlxSgc0XAKKXFGKzKEopcUYoAWijFGKACijFGKACilxRigBKKXFGKACilpwGKADtSjrRS0AOoooqRhRRRQAUUUUAFFFFAC0UUUAFFFFABRRSgUALRRS0DFoopQKBhRRTqoBtOAoAp4FIAApwoApQKQDqUDNAX1p1BQUuKMUtAhMUtGKXFIoTFLS4pce1ADaKfg0YNADKKfg0Ac80AGDRg0/FGKAGYNGDT8UYoATFGKdRQA3FGKdRQA3FGKdRQO43FGKdRQFxKWnYFGBQFhtFOwKMCgLB2pCOadijrQBHSU7GKKAAjimkCnGkNAiIikqQimEe1AEZ60wipSKaRTEREU2nkUmKAIWFRkcVMwpmMihEMhI5ppFS45ppFNEs5DFSKvtTcVKqnFbmABeOlPA5oAOKeqnNAx4XjpTwtOUYFOAqShAKdilAp2KAGgGnAGnheOlOC0yhoBxTsGnBadtpANxRjmn7aMVncBtKKdtNAU5pXASin7TRtNMoZRT9po2mgBtFO2mjaaAG0U7aaNpoATBowafRQAzBowafRQAmMUtGKWgApcUCloAKKKKkYUUUUAFFFFABRRRQAtFFFABS0lLQAtFFLQMWlAzQOtOoAbRRTqoYUoGaB1p1IAApwFFKBSAUCnYoApaYC0uKBS0hhS0UooAMU4ClAFLSKEAFOxRS0AJijFLijFACYoxS4oxQAuKMUuKMUAJijFFFABijFFFABijFLijFABtFG0UuKMUDE2igDmlxSgc0ALijFKOlFAxMUYpaKAG0EUpFFADetNIxTjSEcUCG0UEUUCExSEcU7FBFAEJFNIqQimkUxEZFMIqUimkUAQEUwjAqZhmm44pITRCRzTWFS45ppFMk5DBqVabipFFdBghwHFSADNNA4qQDmgYtPHSkxTgOKRQ5etSYpAKdigBcUoHFFKOlZlC4p2KKWmAgGadS4oxUgApaKXFACUUuKMUAJRS4oxQAlFLijFACUUuKMUAJRS4oxQAlFLijFAC0UYoxUjCijFGKACiiigAooooAWiiigAooooAKKKKAClpKWgBadTadQNCr1p1NXrTqAG06m06qGKvWnDrTV604daQD6cO1Npw7UiyQUtIKWgkKWilApFAKcvWkpwHNAD6BRQKAFpRSUooAbRRg0YNABRRg0YNAD6KMUYoKCijFGKAClApcUYoATFLilxS4oAMCjApcUYqQEwKMClxRigAopcUYoASilxRigBtFLigjigBuKQ07FJigBpA9KQgelPppqgIzTaew703FAgxTCOKkppHagRGaaRTjSUARkU0jinmmnpQSyFulRsTmpWFRMOaZJy2KkUelNxUig10GA8Dingc0gHFPA5oGLinqOKTaakAwKRQoHNOxQBzTqAExTgOKTFOA4qChcUuKMU4A0wFxS0UoqAExRTqMUANop2KMUANop2KMUANop2KMUANop2KMUANopaKAEopaKACinYoxUjG0U7FGKAGUUUUAFFFFAC0UUUAFFFFABRRRQAUtJS0ALTqbTqBoVetOpq9adQA2nU2nVQxV604daavWnDrSAfTh2ptOHakWSClpBSjrQSOxS0Uq0ihQMUtFKBQAtAooFAC0opKUUALRRijFBQUUYoxQAtFLijFACUtGKAOaAHYoxSiloATFLilFLQITFGKeCMUuR61IyPFGKkooAbg0YNOooAbg0YNOooAjxRipKQ9KAI8UhFPpD0oAYRTTT6aaoBhHamdKkNJQIbTTTqQ0CI2HemkVIfSmUARkU09KeaaelBLIWqM9alaompks5qpR0pKcK3MBw6U8Ug6U8daQx+KcOlJSjpUsocOtLSDrS0gJKUdKSlHSkWOpaSnUAJS0UtSAUUuKWgY2inUUBYbRTqKAsNop1FAWG0U6igLDKKWigQlFLRQAmaM0tFACZozS0UANooooAKKKKACiiigAooooAKKKKACiiigB1OptOoGhV606mr1p1ADadTadVDFXrTh1pq9acOtIB9OHam04dqRZIKWkFLQSLT1plPWkUOHWnjpTB1p46UAFFFFABRRRQA6lHSkpR0oKFHWlpB1paACiiigB1A60UDrQAtFFFSA6iiigAooooAeOlFA6UUAFFFFABRRRQAU1qdijrQAym07GKKAENNNPppoAYaSnGkNAELU3vT2FMqhBTTT+1NNAEZpD0pxpp6UEsibvUbVI3eo2pkM5zFOAptOWtjAkA4p4XnrTB0qQdaBjqUdKSlHSpZQ4dacOtNHWnDrQBJSjpSU4dKksdS0lLg0AFKKMUuD6VIwpdvrQop1ACbRRtFLRQAm0UbRS0UAJtFG0UtFACbRRtFLRQBHijFKQc0YPpQAmKMUuD6UYPpQAmKMUtFACYoxS0lADaSlPWkoEFFFFABRRRQAUUUUAFFFFABRRRQA6nU2nUDQq9adTR1p2RQA2nU2nVQxV604daavWnDrSAfTh2ptOHakWSClpop1BItPWmU5aRQ8daeOlMHWnjpQAUUUUAFFFFADqUdKSlHSgoUdaWkHWloAKKKKAHUDrRQOtAC0UUVIDqKKKACiiigB46UUDpRQAUUUUAFFFFADqQil7UUAN603bTjRQAhHpTDUlMPWgBhptPPSm0ARt0qOpWqPvVCYuOM0w1LUZoAiPemnpTm6mmnpQSyJu9RtUjd6jamQznT1p60w9aetamBJTh1ptOHWgocKf2pgp/akUAqReoqMVIvUUDJKUUlKKzGOp1Np1A0LRRRVDCiiigBQaWm0oNIQtFFFIQ2iiiqKCiiigApc0lFADqKbS5pCG0UUUhhSUtJQA09aSlPWkoJCiiigBKKKKACiiigAooooAKB1oooAeOlFNpaAFopKKAJBRTR0pQaZQ4UtNpc0wJM04GmA5pwqQHg04GmCnUAS0oNNBpRSLJAeafmoxTwc0AOoFJmloAWnU3NFACDg0+mUoOKBjxRSUuaBi5pabSg0AOFLTaXNADqKKKQDqKbS5pASUUUUAFA60UDrQA6iiigAooooAWkpaSgBDSUppKACmHvT6Ye9ADTTT0pxpp6UAMao/4qkaoieaoQvemGnUw0Ahppp6Uppp6UEsjbvUbVI3eompkM549aetMPWnrWpgSU4dabTh1oKHCn9qYKf2pFgKkXqKjFSL1oAkpRSUorMY6nU2nUDQtFGaKoYUUUUAFFFFACg0tNpc0hCUUuKMUxiUUuKMUAJRRRQAUUUUAJRRRUgFJS0lADT1pKU9aSgkKKKKAEooooAKKKKAG0UUUAFLSUUAPzRmm5ozQA7NGaSigB4NLTR0pRQUOBpabTgaYDqeD3qMU5aAJBTqYKdSAlpQaaKcKRY8Uo600UoNAElGaYDin0AOozSCloAbS0lFAx4OKdTKMkUAPzS00EY60oNADgaWm0ooGOpwptKKAFooopAOpwORTaUHmkIdRRRQMdRRRQAUUUUALSUtJQAhpKU0mR60AFMPen5FMPU0ANNNPSnGmnpQBE9R96kaou9UIWmE040w0DGmmnpTjTT0oM2RN3qNqkbvUZpks56niowacDW5gSinjpUQNPBoAkHSnCo804GoNrkgNLTAacDSHclzThUe71pwNIkkFLmmA07NAC5pc02lBqRjhS02lzQMdRSZozTuMWikzRmi4DiKSnUhFAhKKKKYxcijIptFSIdkUZFNooCwUUUhNAxKKKSgkKSikJoAKKKbQA/ikpM0hNUIUmkpM0hPvQAtFMyaMmgB9FMyaMmgB+aM0zJpQTmgB9KOtNzQDzQBJmlpmaXNAx9KDTM0uaAJKUGm5pc0rlD9xpytzUeaUHmgCYGnA1GDTgaQEgNOBOajBpQaYEtKDTc0uaksfk0oamZozQBJS0zdTgaAHA0tNzS5oAKAcGkzRQBJSg0wHsadQMfSimZpwNAx4paaDS5oEL3pabSg1Ixy+lOplLu9aAJKKbmjNADqKbmjNAC0lL2pKAA9KZTz0plACk80wmlNNNACGmmlppoAjc81GKc9MqhAaa1LmmtQMQ9KjY04nioiaCGMZuajY80rHmmE1RBz4NSA1Dmnqa2MCYGnZqMGng0gH5pw+tN60oqS7kgNOzTBS0wuSZpwNR04VBRKDTs1GtOFAD6Wm5pc1IxwNLTaM0APzRmkzRQULmjNJRQA6ikooAcDRTaXNMBM0ZpD1opCFzRmkooAKKKSgQUmaDSUAFFFNoAKM0GkoAM0hOKQmm1QhSTSZpDRQAvFHFJRQAvFHFJRQAvFAxmkooAflaUEZplKOtAD80uaZmlyKBj80oNMBpc0ASZpc03NLmpKHZpc02jNAEgNPDVFmnA0wJgaUGoge1PBpATZpc00GlpFjs0uabRmgB+aXNNpRQA8E0oOaZSjrQA8UU2nZoKFpQSKaDS0Ejt1OBplKpoGSg0uaYKdmgY6lpKKkBwNLTaKAJMijIptFADsijIptFAD6KQEYoyPWgBT0plOyKacdqAGE00mlY03NAATTSaXNNJoAiamZpzGmVQBTHPFOJpj9qAGseKiJp7HjFRMeKCGRk0wmlJ5phpkM53NOBqENTw1dBgThqeDUANPDc0CLANPBqENUgNSMlzRnmo807NIaJgaXPNRhqXPNIolzSg81HnilBoAl3Ubj6VHmlFTYCbJo3VFmnA47UWAeG5pd1MDc9KXNBQ8GlzTAaXNADt1G6m5ozQA7dRupuaM0AOzRmm5ozQA7NGabmjNACk8UmaQnikzQApNJmkJOaTcaAFyaMmm5ozVaAOyaM03NGaNAEJ5ozSZpM0iR3FHFNzRmgAzRmkzRmrAXNGaTNGaAFzRmkzRmgBc0ZpM0ZoAdSg0ygdazsBJk0obmmUClYCUHjilBqLNOBGKLFEuadUeRTgR607APpwPNR5pwNSUSinZqINTt3vQBLmlzUW73pQ1OwyUGlBqPd70oPNICcHinZqENS7qCrE2aXNRBqXdQBJmlzTM0uaAH5pc0zNLmgLkmaKZn3pc0iiQH1p2aizS5oAmzS1HuHrS5oAkzS1HmlzQMkpQaZmlzUgPFO3Co80ZoAXNJmkzSZoAdmkyaTNBNACGmE0pNMLelACE89aaTzQTzTSaAGmmmlJppqgGk00n1oJ5ptADGNRMeKkaom6UGbIiaYxp5qNqZJzG6nBqhDU4MK6DAsBqeDUAanhhQIsBuKkV/eqitmpQ1IEWdw9aA1QbqUNzSYy0Gp27moA1OzzU2LJ93FOBqAHinq1MCfNGaj3D1p2adgH5pc0wGlzRYB469aXPuajB5pc1mUSjp1pfxqMGjd9aAJPxo/Go931o3fWgCT8aPxqPd9aN31oAk/Gj8aj3fWjd9aAJPxo/Go931o3fWgB56UykJ4pM0AKaKaTSZoAfRTM0ZpgPopmaM0AGaM03NGaokdmjNNzRmgBc0ZpuaM1QDs0ZpuaM0AOzRmm7vpRu+lADs0Zpu76UZoAdmgHmkzRmkA/NANNzSg0WAdmlB4pmacDRYokp3TmmBhS7hikA/NKDUe7mnA+9ZjJAadmowaUGkBLmjNMzS0FD80oODTAaWncCbNLmot3vS7hSGS5pQai3CnAigdyYNShqizSg0ATZozUW6nBhQBLmlzTM0tIsfmlzTAaKAJc0uaZmloEPDUu6mA0UATZpc1Fn3pQ2akZLmjNMz70uRQAuaM03NLmgB2aQ9KSigBrGo805qZQAhNNJpTTDQAlNJ4paa3WqAaaaTSmm0AMaoWqVqiNBDImqNutPamN1NMg5ANTg5qvv8AenB66jjuWQ1O3VWD04PQFy0rc9alV/WqisakDVJpcthqeGqqrGpVJqSWycGpAarg04MaoZODTgahDcU4NQBNup4bNV808NSZaLCtTs1XBp4c+tIZLmlzUeaXNIBwNLmowaXNJoZJRTc0uaLALS5puaM0WAfmjNNzRmm0IXNGaTNGaQxM0ZppopgOzRmm0UALRTaKAHZFJmm0UAGaM+9JRSuSLn3oz70lFFwFopKKLgLRSUUXAM0Z96bRQA7PvQDTaUUAPyKMim5pc0wFzRmkzRmgB2aXNMyPWlzVFD80oNMzS5oAkzSg1HmlzWYEu40oaos0uaAJgadmog1LupDuSA07NRbqXNIolzS5qIHmlzSGTAjvS7hUINLmmBPvpQ1Q5pQaBk273pwaoM04E5osBYVqduFQZpQaRROCCKXNQZpd1AE+admoQ1PzSKQ8GlzUYNOzQMfmlyaZmjNAEmaUMRTM0ZoESZNGTTc0ZoAdk0ZNNzRmgAJpCaQmmk0AKTTSaQmmk+9AxjHmmk0ppueKZAlNNKaaaBEbNURNPfrUZPFIbIyaYaU00mmQzhd9KH96r7venBq6jz7lkPTg/NVwacDzQO5cVqlV8VVVuKlDUmXcsq1SK9VVJqVWpMCyGzTw1Vg1PDc0Fk4NPDVDmlBoAnzTg1Q5pQaGUThhTg1QA0oapGWA1O3cVCGp2aGgJQ1OBqEGnBvWpAl3e9G73qPNGaCiTd70bveo80ZoAk3GjcajyaXNVckk3GjJqOlyfWkMkoqPcfWjcfWgZJRUe4+tG4+tACk4o3e1M5o5pAP3e1G72pvNFAC5ozSUUiRc0ZpKKAFzRmkooAXNGaSigBN1G72pp60UwHbvajdz0ptFMB+eKXNR596M+9KwEmaM1Hn3oz70WAdmlB9Kbmlqih4anZqMUUASZpc1HzSg+tICTNLmmZozQA8H3p26owaM0mgJQacGqLNKDUjJg3NLu96izS5oGShqXdUQYUu4UATZpQaiyKcCKCrkmadu96hyKdkUBcm30u73qHNKDUlkwf3pd1Q5pwbtQFiYGpA3FQBhTg1AEoPpTw1QhqdkUiiXNGajpQfWgZJmlzTKXNAD80ZpuaN1ADs0Zpu6jIoAUmmk0hIppNAAW5pueaQ0negBTTTTj0phpkCGmMacetRsaAI2PNRt0p7dTUZ6UgZGaaacaaTTIZ5ySaVW5pMUAYrrPNLKsMU4sKrhiKNxoAnDc1Krmqqt61KrUDTLauakDGqqtUwYUrF3JwxB61KrZqsGqRTg0irloNTg9QBqdmlYdycPTg3vUANOBoBE4NOBqENTweaQ7k4PFOzUOaUNSsMlHFOzUQal3UAS5ozUe6jdVFEmaM1HupQ2TQBJmjNNzRn3pAPzRmmZ96M+9AD80ZpuaM0AOzRmm5ozQA7NGabmjNTYB2aM03NGaLALmjNJmjNFgFzRmkzRmiwC5ozSUUWAXNGaSiiwBRRRRYAoooosAUUZozQAUUZozQA7NG403NGaLAO3GjcabmjNFgJd1G6o80ZosBJu96NxqPNGaLAT7qN1RbjRuNFmMl3Ubqi3GjcaNRk2/wB6duqDNKGNIZOG96Xd71BuNKGoAmDHPWl3n1qEPzS7vepsBMHPrS7z61CGpd1FgLAfjrTg1QBqcGqbGiZPupwaoA1PDUWKuS5pQajzSg0CJgacGNQg07NMCfNLmog1OBpFEoNODVEDTgaAHbjRuNMzRmgB+40bjTM0ZoAdmjNNzRmgLi5pCRTc0E8UAITTSTSFqaTQAhJppJpSeaaTQA1qYacxphPFITGGmHrTiaaaZLPPOKDUYalLV1nmCk0VGW5pwNAElKGIpgalyKYydXqVXqmGqRZKALqvUytVBJOaso9Iq5bDetODVArU8GkVcnBpwNQBqkBpASg08NUINPBpFJk2aXNQ5FOBNAyXNGajBpc+9AEuaM0zNGaCx+aUHmo80oPNAyXNGaaDRmkIdmjNJRQA7NGabmjNAx2aM03NGaAHZozTc0Zp2AdmjNNzRzRYCTn1o59aZRRYQ/n1o59aZSjrRYCSikpaLDCiiiiwBRRRRYAoooosAUUmRRmoAWikzRmgBaKYW5pNxq7ASUVHuNG40WAkoqPcaN1FhElFR7qN1FgJM0ZqPcKNwoKJM0ZqPcKN4oAkzS7qi3Ubqgom3Uu6od4pd4pASg807NQBuadmqsBMG460u73qEGjNFgLAanhqrBqkDVFiiwDTwagDU8GkMk3U4NUWaUGkUThqXNQg04NQBODTw1QA08GkUTg04GoQ1PDD1oAdmjNNz70Z96AHZozTd3vRn3oAdmjNNz70E8daAFzSE8UzJoJOKAsISc0hNNzSUAKaQk0hpKBCMajbtT2NR54pDY0009aU9aQ0yGeaZ96Yz1XM+e9IXzXWeTcm8znrUgk96p7qcGoC5eVgRQWqsr471IGzVFXJQx704NUGaXdQFy2jcircZ6VnxtmrsZqSi0OtOB5qMEUoNAEwNODVCGp4NIZMGqQNVcGnq3NAyfNKDUeaN1BRLmjNRhqduoAfuIpdx9ajzS5pFJkgb1pwNRA04GkUTbqN1RZNKDmgm5KDS5qPNLmgdx2aM03NLmkUOFLTc0ZoEOpQcGmZpc0ASUtMB9KXd7Uh3Ezzmn1HSg4oEPFLSUZouMM0ZoopAGaM0UUALRRRVAFFFFACZozRRUgGaM0UUALSGjNFO4BTDyaCc0lAhxb0ptGaTNMANFJmkzQA6kzTM0ZFAxxNJmm5pMigCXNGaZkUZFMB+aMmmZFGRQBIDTs1EGHrTtwpFkoanA1CDTgaBkwNPDVBuNODDvxSauMsK2DUgaqwanhqhodyfNKDUO6nA0i7kwNOBqIGnA0rDJgacGxUWaXNAEufenZqHNLu96AJ93FG6o93FAakO5IWozUeaXNAx+TRk0zI9aMj1oAfmjNMyPWjI9aAAmm5pCR60hb0oAcTimEmkJpM0DEJpKKQmggKKSkoA8dBqVW4qDNKrnNdZ4dyzmjmkTk4qysQIoC5AG9akDEdKa8ZU9OKaDiqLuWFbNOxUGakV+xoHcnjbBxVtJMVQzipEkNSaGksme9Sq2TVBH96tI1AyfNODYqINTgaQycNmnA1XBqRX7UASk03dSEimmgskDVIrZqAYqQEYoGTA04Goge1OBpCJQacDUYNKDSKTJM0oOKjzRmgkmyKUGoc0uaBkuaXNMpQam5oPzRmm0uaYC5pc03NLQA7NLmm0UBYdS0lFAhwOKdTKXJFIB9FFFIYUUUUALRRRVAFFFFACUUUVIBRRRQAlNJzRkmkpiCkozSE8UwGk0maQn3ozSGGaTNJmgkYouAhYCk3CmkjNITQIUt6UmaTIpM0DJM0Zpm6jdVAPzRmmbqM0APBp4aoQacDQMmBp4NQBqeGFAybNOBqHI9acGBqSiYMR0p4aoAacDQBMGp4NQA9qeDik0UWA1PBqAGnq1SUS7velzUWaUGpKJc0uajBzS0gJc8UoNR5pQaAJN3NOBqLNOBoGh272o3e1MzRmgofu9qN3tTM0ZoAXNJmkpKAFzSZoNJQIKSlptBIUhOKD0ptMDxsGnjrUQNOBrsPARZjbmrsb8VmK2DVhZeKDRFqWQEVWzk1G0hJpUOTQUSipFFRg09WoAlB4py4zUQJqRaRaLCDjrVlOlVUNTq+B1pFFjdShqrb+acHNAyyG96du96rhs04NQBMCc1OOlVlNSq1I0uS04VGDTwaAuSU6mA0uakQ8HtTqjzSgmgCXNLTc0ZoAeDS0zNLmgB2aWkoBoNBwpabS5oGSUopuaWgY6lpuaUdaAH0UlLSELRRRQAU8dKZTx0pMEKOtLSDrS0IYUUUUwCiiigApDRmikAUw8mgnNJQIQ0hNBNNJqhjSaQk4pCaaSaADJ9aaTSE0hNAXAmkz70hNNLCgLjs0maZupC1ADyR603I9aZmjIoAOaUE460mRR1oAcDz1p2R61HS0ATUoNMzS5oAfmlzTM0uaAJN1PU1EKcDQUWAaeDVcGpFapGSg07NRA07NJlolBp4NQA08NipZSJN1SBqr596eretOwiwrU7NQBvenhqkZLmjNR7hRuFAE2fejNRbh60oYZ60ASZoz70zcKNwpFD8+9GaZuFG4UALk0Zpu40bjQA6im7jRuNFgHUhozSUiQplKTmkoGeMA07NRrT67TwkOB5qRTUI61KKC0PqROKip4oKJC2KcpqLvUyDigCZKlAqFDzirCg0FIUHFKHIpCMUnepKJgc08UxRxUgFBQ4VKBmmqKkAoAXOBShqYx4pobmkO5aVqeG5qFDmng80BcsA0uaYDS5qSh+aXNMzS0ASZNODetR0tAEmaXNMBpw60APpaSig0HA0tJRQBJS5pgOKdSKHUoNNFKOtMB9FFFIB1FFFAhaeOlMp46UmCFHWlpB1paEMKKKKYBRRRQA2mk5oPWkpCCkopDTAaTTSaD1pp70xjCeaaTQaSgBM0hNFMJ4oM7gTTCaCaQmgVxN1JmkzSE0BcUmjNNzSFqAuPzSg8VFupwbigLkgPNLmow3NOzQFx2acGqPPvSg0GpIGpwPvUWaUHmgCcU4GowadnmgZIDTg1RZpwNJoZMrU8GoFPNPDCkUSg08GoQaeDU2KuSZoBpmeKUGm0BJmnB6hzTt1ICXf7Uu/2qHdS7qBk+6gNzUO4+tKGOaAJ9x9KNx9KZuo3VIx+4+lG4+lMyaMmgCTPvRn3puaKRQ7PvRn3ptLQBJ2ppOaSikIKSiigDxhad2pimn12nhIKetMHWpAKCx4NPBqMU8UFDx1qQGowDTx60ASxfeq8uNtZyPg1YWYYoKLJ6VCetMMwPejeDQBZibHWrJYEVnCTBqZZcikyiyHwanVsiqG/mrETZpDJmyajAOam60hGKBjkNThgap78GpFfigCfdTg9QhqXNIZLu5pweoc0oNIZZBpwNQhqcDTETBqfUIqQYoKHZpRTaUUAPFOFNFLQA6lpKWpGhV60+mL1p1I1HjpS0g6UtBA+iiigoWnjpTKeOlJghR1paQdaWhDCiikJoAKKQnFNJzSAcTimGjNITTENJppNBNNJoGBYCmM1NJphNUApNNLU0mmEmgBxYUwtxTSaaTVGQpNMJNBNNoEOpM03dSFqAHE+tISKZmkzQMXNPBGKizSg8UASgjNLmogeadu+lAiTNKDUYPpTgakskFOpgNLmgQ+nBjUeacDQWSg04VGDTgaBEgpwNR5pwNBoSg04GogaUGgCYGlzUWaUNUjJc0uajDUuaBj807NMzS5pjHg0oJzTM0oNAD80tMzS5qLlEgPrS1HmjNAEuaXNR5NKCKLAPFLTc0uaQDqKbRQMdRTaKAPF1NS1EoNSDpXUeGhw61IBUa4zUueKC0APNOB5qAsc08MaCiyp5p9Vw1SB6AFHDU+oQxzUgagodUi1Du5p4agCWnKcGmA5pc80AmTjmrMfFVouasjgVJRMJKC+arljmgEmgZJTlbBpoBxSd6BlkHinbveoVbilz3oAl3Uoaoc0u6kMshqepqupqVTTBFlTnmpFqBTUoNAx2TmnCmU4HikUSClBpopaBElLTadUjQq9adTV606kajx0paQdKWggfRRRQULTx0plPHSkwQo60tIOtLQhiUhOKWmE5NIApM0GkqhCZppNKaaaBjSaaTQaYTmkAhNMJpCeaYzVQCsajJpCaYWoACaaTTWfmm5PrVGI8n1phakJpKBhmkzTc0ZoFcXNJmm596MigB2aXNMpw6UAOozSCloAdmnA0ylFSMlBp2ajBp2RQMfmnA0zIpQaCiQGnA1GDTqBj91OBqLNOB5oKJQadmowadmgZJmjNMzS1Ax+aXNMBpaAJ80uaZmlBqih+aM02lzQA7NLmowfWlqBkmaM0wGlFICTNLmm0oNO4x4NKG9aZmlzTAkzRmkzRUjFzRmkooA8f2gU09Km21E4xXQjyJDM81IDxUWOamVciqZCGAc1JilC07FAuUaOKkU0ynA0D5SSlBIplLmqLJOtKDTAcU4GgCRTTwajBp1SCLKMKsBsiqStipQ1IomBGeasJjAxVQGpUfHFSWWTjFQOvOalByKCuQaBkIfFSK4NVyDmnJ1oAtUhoWlIoAclSrUaAVKooKTJUNTKahQCpVoHcdSikpRQMkHanU0dqdQIeOlOHSmjpTh0qRoevWn0xetPoNRw6UtIOlLSJJB0oIFA6Up6VIgPWig9aKs1CiiigAptOptAAaSlNJQAw0w9acetNNSSRHrTKU9abmgBjdKjJp7GoyaokDUbHmnk1Ex5oAYTk0hozTSaoyA03NBNJmgQlIaTNGaYg4pKTd6UmTQA8Uopm4U4GgCQUtR5pd1ADs04Got1OBpDJQaXJ9ajBpc0DJAcU8Gos04GgslBpQaYDTs0APpwNMBpQak0JhS1GDT80gHU4GmZpc0wHU7NMzS5oAkzS5qPNLmgolDetLUWaXNAEtKDUeaUNUlElLmow1OzQA/NKDTc0tMY7NKDTc0UASZpRTKcKkolFLTFPanZpAeSGonIoZ/eomat0eVIcoyasKM1VQ81bSqZmtx4SkIqamsOKDZ7FY8UA0r96Yo5oMWybNFJSiqLQoNKOtNp1AyRTT6jB5p4oZKHipVpig1KAcVJSFBqRTUQ61KtQaE6H5alzUKdKcG5oGKUBo2YNOU5pxxigBoOKcOaj71MgzQA9QcVIBQBingUE3FFSrUYp6nmgq4+lFJSig0JB2p1NHanUCHjpTh0po6U4dKkaHr1p9MXrT6DUcOlLSDpS0iSQdKU9KQdKU9KkQHrRQetFWahRRRQAU2nU2gANJSmmnpQBGx5pp60rdaa1SSQk02nUw0ARMaYTTm61GTzVEsCaiY8089KibrQITNNJoppIqjICaYTQT3pKAE3UhPrSE0maYhc0maQ0UAOzS5ptGaAHbvel3VHmjNAEmaUGo804GkMlDU7NRA04HmgCYGlBpgNKDQWSg07NRilB7UDJQacDTB0pwqTQeDTgaYDS0ASAinZqPNKGoAkzS5qPI9aXcKAH5pc1GG9adQMfmlzTAaWgZJmjNMpc1Ix+acDzUeaUUgLA6UuaYDxTqoodS5popaAH5pRTaUVBQ8HvT6jFOBoA8a3UZFRZNGTXStDxm7kyGrSNxVJDVhGoYIuBj61IDkc1WDVIGqDYY/U0ynN1ptWYy3FpRSUo61QDqcO1Npw7UGg+lXg0lKOtIRejUbRUoQVWjlwAKlEorM0IMkMakQnAqLPJNSJ0FUT1LK9KP4jQvSlAO6pLJU7U5ulNSnmgY0VMlRCpFOKBMlHNLSDpS0CJB0pRSDpSigCagUlKBzQWSr0p9MXpT6Ch9PplPqRocvWpBUa9akFBqPHSlHWkHSnAHNIkeOlLSDpS1IhaKKKssKKKKAGU2nU2goaaQ9KU0h6UARnrUb1IetRvUkkRphp5phoYELVE3apWqJu1USMqNutSVG3WgzGmoT1qY1CetUSJQaKQ0ANJODTMmnMRg80zIrQgfketGRUOTRuNICXNGaZmlzUlC5pc02loAfRSDpS0DHilB5pBRQBJk4o3GkopASinDrTRTh1oKH0o64pKUdaCh9LmkpaCR+aKSloNB2aKSigY6iiigskWnU1SPWl3CpELS0maKBCinrTBTxQUOyfU0AnPU0lKOtAEo6UtIOlKOtAx9KDzSUDrSKJaM0lLUlHi9IelFFdJ4o9KmXpRRSYImUmnZNFFQAtFFFUhsKYTg0UVaAkBqQdqKKC0PooopASJT6KKzNBBT0NFFWR1LK9qsiiioNBR1p9FFAwpRRRQJj6UdaKKBEnanCiigCZe1TAUUUFIdThRRQWPp9FFSNDl61IKKKDUkXtUoFFFSQFFFFIBaKKKssKKKKAGU2iigoaaQ9KKKAIz1pj0UVJJCaYaKKGBC1RNRRVEjKjaiigzIiTzTDRRVEiHpTDRRQBCxPNNzRRVkBRRRQA+iiipKCiiigB46UUUUDHjpTqKKAHU4daKKQElFFFBQ8GnUUUDH0UUUFD6dRRQNBRRRQMWiiigBcmjJ9aKKAFBNOyaKKBkgNOFFFJjQ6gdaKKQx4JxTx1oopIY+lHWiimUOp1FFBR//Z';
	echo '<!DOCTYPE html>'
		. '<html>'
	. '<head>'
	. "<title>$sitetitle</title>"
	. '<meta name="viewport" content="width=device-width, initial-scale=1.0">'
	. '<!-- 引入 Bootstrap -->'
	. '<link href="./css/bootstrap.min.css" rel="stylesheet">'
	. '<!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->'
	. '<link href="./css/ie10-viewport-bug-workaround.css" rel="stylesheet">'
	. '<link rel="stylesheet" href="./css/font-awesome.min.css">'
	. '<!-- Just for debugging purposes. Don\'t actually copy these 2 lines! -->'
	. '<!--[if lt IE 9]><script src="./js/ie8-responsive-file-warning.js"></script><![endif]-->'
	. '<script src="./js/ie-emulation-modes-warning.js"></script>'
	. '<!-- HTML5 Shiv 和 Respond.js 用于让 IE8 支持 HTML5元素和媒体查询 -->'
	. '<!-- 注意： 如果通过 file://  引入 Respond.js 文件，则该文件无法起效果 -->'
	. '<!--[if lt IE 9]>'
	. '<script src="./js/html5shiv.js"></script>'
	. '<script src="./js/respond.min.js"></script>'
	. '<![endif]-->'
	. '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />'
	. '<!-- jQuery (Bootstrap 的 JavaScript 插件需要引入 jQuery) -->'
	. '<script src="./js/jquery.min.js"></script>'
	. '<!-- 包括所有已编译的插件 -->'
	. '<script src="./js/bootstrap.min.js"></script>'
	. '<!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->'
	. '<script src="./js/ie10-viewport-bug-workaround.js"></script>'
	. '<style type="text/css">';
	echo 'body{';
	if ( $showNavbar ): echo 'background-color:#eee;padding-right:4px;';
	else :echo 'background:url("' . $bg . '") 0 0 no-repeat;background-size:cover;';
	endif;
	echo '}'
	.'.form-signin{max-width:330px;padding:15px;margin:0 auto}'
	.'.form-signin .checkbox,.form-signin .form-signin-heading{margin-bottom:10px}'
	.'.form-signin .checkbox{font-weight:400}'
	.'.form-signin .form-control{position:relative;height:auto;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;padding:10px;font-size:16px}'
	.'.form-signin .form-control:focus{z-index:2}'
	.'.form-signin input[type=email]{margin-bottom:-1px;border-bottom-right-radius:0;border-bottom-left-radius:0}'
	.'.form-signin input[type=password]{margin-bottom:10px;border-top-left-radius:0;border-top-right-radius:0}'
	.'.blog-footer{padding:40px 0;color:#999;text-align:center;background-color:#f9f9f9;border-top:1px solid #e5e5e5;}'
	.'.blog-footer p:last-child{margin-bottom:0;}'
	.'thead>tr>th>a:link,thead>tr>th>a:hover,thead>tr>th>a:active{color:#000;text-decoration:none;}'
	.'tr.active td{background-color:#ccc!important;}'
	.'.btn-group.operate{position:fixed;left:35%;bottom:1%;}'
	.'@media screen and (max-width:425px){.btn-group.operate{left:0%;}}'
	.'@media screen and (max-width:320px){.btn-group.operate{}#filetable.table>tbody>tr>td, #filetable.table>tbody>tr>th, #filetable.table>tfoot>tr>td, #filetable.table>tfoot>tr>th, #filetable.table>thead>tr>td, #filetable.table>thead>tr>th{padding-left:0;padding-right:0;}}'
	.'div.page-header.text-center span{display:inline-block;height:39px;width:45px;background:url("' . $logo . '");background-repeat:no-repeat;background-size:contain;}'
	.'div.page-header.text-center h1{display:inline;}'
	.'table#filetable td:nth-child(1){word-break:break-all;width:0;}'
	.'</style>'
	. '</head>'
	. '<body>';
	if ( $showNavbar == true ) {
		echo '<nav class="navbar navbar-default" role="navigation">'
		. '<div class="container-fluid">'
		. '<div class="navbar-header">'
		. '<a class="navbar-brand" href="' . php_self . '" onclick="return false;">' . $sitetitle . '</a>'
		. '</div>'
		. '<div>'
		. '<ul class="nav navbar-nav">'
		. '<li class="active"><a href="javascript:void(0);" onclick="opendir(\'.\')"><i class="fa fa-home"></i>主页</a></li>'
		. '<li><a href="javascript:void(0);" onClick="fcreate()"><i class="fa fa-file"></i>新建文件</a></li>'
		. '<li><a href="javascript:void(0);" onClick="fupload()"><i class="fa fa-upload"></i>上传文件</a></li>'
		. '<li><a href="javascript:void(0);" onClick="fremotedownload()"><i class="fa fa-cloud-download"></i>远程下载</a></li>'
		. '<li><a href="javascript:void(0);" onClick="checkVersion()"><i class="fa fa-info-circle"></i>检查更新</a></li>'
		. '<li><a href="javascript:void(0);" onClick="logout()"><i class="fa fa-sign-out"></i>注销</a></li>'
		. '</ul>'
		. '</div>'
		. '</div>'
		. '</nav>';
	}
	echo '<div class="container">'
	. '<div class="page-header text-center">'
	. "<span></span><h1>$sitetitle</h1>"
	. '</div>';
}

/**
 * 页面尾部
 *
 * @access public
 */
function mainbottom() {
	echo '</div>'
	. '<div id="paddingDiv"></div>'
	. '<footer class="blog-footer">'
	. '<p>&copy; 2019 Joytou</p>'
	. '<p>Designed by Pzy</p>'
	. '</footer>'
	. '<script>if($("body").height()<$(window).height()){$("div#paddingDiv").height($(window).height()-$("body").height());}</script>'
	. '</body>'
	. '</html>';
}

/**
 * 规范字符串格式
 *
 * @access public
 * @param string $data 需要规范格式的字符串
 * @return string
 */
function test_input( $data ) {
	$data = trim( $data );
	$data = stripslashes( $data );
	$data = htmlspecialchars( $data );
	return $data;
}

/**
 * 输出日志
 *
 * @access public
 * @param string $log 日志信息
 * @global string $logable 是否输出日志
 */
function writelog( $log ) {
	global $logable;
	if ( $logable ) {
		$myfile = fopen( php_self . ".log", "a" );
		fwrite( $myfile, date( "Y-m-d h:i:s" ) . "	" . "IP地址：" . $_SERVER[ 'REMOTE_ADDR' ] . "	" . $log . "\r\n" );
		fclose( $myfile );
	}
}

/**
 * 计算文件大小
 *
 * @access public
 * @param string $file 要计算大小的文件名
 * @return string
 */
function getSize( $file ) {
	$num = filesize( $file );
	clearstatcache();
	$sizestr = '';
	if ( $num < 1024 ) {
		$sizestr = $num . 'B';
	} elseif ( $num >= 1024 && $num < 1048576 ) {
		$sizestr = round( $num / 1024, 2 ) . 'K';
	} elseif ( $num >= 1048576 && $num < 1073741824 ) {
		$sizestr = round( $num / 1048576, 2 ) . 'M';
	} else {
		$sizestr = round( $num / 1073741824, 2 ) . 'G';
	}
	return $sizestr;
}

/**
 * 重命名文件或文件夹
 *
 * @access public
 * @param string $oldname 要重命名的文件或文件夹
 * @param string $newname 新的名字
 * @return string
 */
function frename( $oldname, $newname ) {
	$type = is_dir( $oldname ) ? "文件夹" : "文件";
	if ( rename( $oldname, $newname ) ) {
		writelog( $type . $oldname . "重命名成功！已命名为：" . $newname );
		return $type . $oldname . "重命名成功！已命名为：" . $newname;
	} else {
		writelog( $type . $oldname . "重命名失败！" );
		return $type . $oldname . "重命名失败！";
	}
}

/**
 * 删除文件或文件夹
 *
 * @access public
 * @param string $dir 要删除的文件或文件夹
 * @return string
 */
function fremove( $dir ) {
	$result = "";
	if ( is_dir( $dir ) ) {
		if ( $dh = opendir( $dir ) ) {
			while ( ( $file = readdir( $dh ) ) !== false ) { //遍历出当前目录的所有文件夹和文件
				if ( !( $file == '.' || $file == '..' ) ) { //排除掉两个返回上级目录的路径
					$result .= fremove( $dir . '/' . $file ); //只要遍历到任何子目录或文件夹，都继续循环下一级遍历
				}
			}
			closedir( $dh );
		}
		//当前目录的所有子文件夹和子文件已经全部删除了，则当前目录为空目录，可删除
		if ( rmdir( $dir ) ) {
			$result .= "目录" . $dir . "已删除<br>";
		} else {
			$result .= "无法删除目录" . $dir . "<br>";
		}
	} else {
		if ( unlink( $dir ) ) {
			$result .= "文件" . $dir . "已删除<br>";
		} else {
			$result .= "无法删除文件" . $dir . "<br>";
		}
	}
	clearstatcache();
	writelog( $result );
	return $result;
}

/**
 * 复制文件或文件夹
 *
 * @access public
 * @param string $file 要复制的文件或文件夹
 * @param string $tofile 目标文件或文件夹所在文件夹
 * @param string targetfile 目标文件或文件夹
 * @return string
 */
function fcopy( $file, $tofile, $targetfile ) {
	$result = "";
	if ( ( $file . '/' ) == $tofile ) { //原文件夹和目标文件夹不能相同，否则会出现在【原文件夹】创建【同名子文件夹】的死循环
		$result .= "目标文件不能为原文件！";
	} else {
		if ( is_dir( $file ) ) {
			@mkdir( $tofile . $targetfile );
			if ( $dh = opendir( $file ) ) {
				while ( ( $files = readdir( $dh ) ) !== false ) { //遍历出当前目录的所有文件夹和文件
					if ( !( $files == '.' || $files == '..' ) ) { //排除掉两个返回上级目录的路径
						$result .= fcopy( $file . '/' . $files, $tofile . $targetfile . '/', $files );
					}
				}
			}
		} else {
			if(($handle1=fopen($file, 'r'))&&($handle2=fopen($tofile.$targetfile, 'w'))){
				stream_copy_to_stream($handle1, $handle2);
				fclose($handle1);
				fclose($handle2);
				$result .= "{$file}已复制到{$tofile}{$targetfile}<br>";
			}else{
				$result .= "{$file}无法复制到{$tofile}{$targetfile}<br>";
			}
		}
	}
	clearstatcache();
	writelog( $result );
	return $result;
}

/**
 * 移动文件或文件夹
 *
 * @access public
 * @param string $file 要移动的文件或文件夹
 * @param string $tofile 目标文件或文件夹所在文件夹
 * @param string targetfile 目标文件或文件夹
 * @return string
 */
function fcut( $file, $tofile, $targetfile ) { //和function fcopy( $file, $tofile )同一个原理，只是复制完文件删除原文件，然后删除父文件夹
	$result = "";
	if ( ( $file . '/' ) == $tofile ) { //原文件夹和目标文件夹不能相同，否则会出现在【原文件夹】创建【同名子文件夹】的死循环
		$result .= "目标文件不能为原文件！";
	} else {
		if ( is_dir( $file ) ) {
			@mkdir( $tofile . $targetfile );
			$result .= "@mkdir( {$tofile}{$targetfile} );<br>";
			if ( $dh = opendir( $file ) ) {
				while ( ( $files = readdir( $dh ) ) !== false ) { //遍历出当前目录的所有文件夹和文件
					if ( !( $files == '.' || $files == '..' ) ) { //排除掉两个返回上级目录的路径
						$result .= fcut( $file . '/' . $files, $tofile . $targetfile . '/', $files );
						rmdir( $file . '/' . $files );
					}
				}
			}
		} else {
			if(($handle1=fopen($file, 'r'))&&($handle2=fopen($tofile.$targetfile, 'w'))){
				stream_copy_to_stream($handle1, $handle2);
				fclose($handle1);
				fclose($handle2);
				unlink($file);
				$result .= "{$file}已移动到{$tofile}{$targetfile}<br>";
			}else{
				$result .= "{$file}无法移动到{$tofile}{$targetfile}<br>";
			}
		}
	}
	clearstatcache();
	writelog( $result );
	return $result;
}

/**
 * 保存文件内容
 *
 * @access public
 * @param string $filename 目标文件名
 * @param string $content 要保存的文件内容
 * @return string
 */
function fedit( $filename, $content ) {
	if ( $myfile = fopen( $filename, "w" ) ) {
		fwrite( $myfile, $content );
		fclose( $myfile );
		clearstatcache();
		writelog( $filename . "保存成功" );
		return "保存成功！";
	} else {
		writelog( $filename . "无法保存" );
		clearstatcache();
		return "无法保存！";
	}
	if ( is_writable( $filename ) ) {
		file_put_contents( $filename, $content );
		writelog( $filename . "保存成功" );
		echo "{$filename}保存成功";
	} else {
		writelog( $filename . "无法保存，原因：文件不可写" );
		echo "文件{$filename}不可写";
	}
}

/**
 * 读取文件
 *
 * @access public
 * @param string $filename 要读取的文件名
 * @return array(["code"], ["string"])
 */
function freadfile( $filename ) {
	$result = "";
	$arr = array();
	$result = file_get_contents( $filename );
	$arr[ "string" ] = htmlspecialchars( encode( $result )[ "string" ] );
	$arr[ "code" ] = encode( $result )[ "code" ];
	writelog( $filename . "被读取" );
	return $arr;
}

/**
 * 高亮文件内容
 *
 * @access public
 * @param string $filename 要读取的文件名
 * @return string
 */
function freadfile_highlight( $filename ) {
	$result = "";
	if ( $file = fopen( $filename, "r" ) ) {
		$result = filesize( $filename ) > 0 ? encode( fread( $file, filesize( $filename ) ) )[ "string" ] : "";
		fclose( $file );
	} else {
		$result = "null";
	}
	clearstatcache();
	//$result = htmlspecialchars( $result );
	writelog( $filename . "被预览读取" );
	return $result;
}

/**
 * 修改文件或文件夹的权限
 *
 * @access public
 * @param string $filename 要修改权限的文件或文件夹
 * @param integer $mode 要修改的权限，四位数字
 * @return string
 */
function fchmod( $filename, $mode ) {
	$mode_arr = str_split( strrev( $mode ) );
	$mode = "";
	for ( $i = 3; $i >= 0; $i-- ) {
		if ( !isset( $mode_arr[ $i ] ) ) {
			$mode_arr[ $i ] = "0";
		}
		$mode .= $mode_arr[ $i ];
	}
	if ( chmod( $filename, ( int )$mode ) ) {
		writelog( $filename . "修改权限" . ( int )$mode . "成功" );
		return $filename . "修改成功";
	} else {
		writelog( $filename . "修改权限失败" );
		return $filename . "修改失败";
	}
}

/**
 * 创建文件或文件夹
 *
 * @access public
 * @param string $path 要创建的文件或文件夹所在文件夹
 * @param string $file 目标文件或文件夹
 * @param string type 创建的类型，文件则file，文件夹则directory
 * @return string
 */
function fcreate( $path, $file, $type ) {
	$result = "";
	if ( !file_exists( $path ) ) {
		return "路径不存在";
	} else {
		if ( file_exists( $path . '/' . $file ) ) {
			return "已存在同名" . ( is_file( ( $path . '/' . $file ) ) ? "文件" : "文件夹" ) . $file;
		} else {
			switch ( $type ) {
				case "directory":
					mkdir( $path . '/' . $file );
					$result .= "文件夹{$file}创建成功！";
					break;
				case "file":
					$fopen = fopen( $path . '/' . $file, 'w' );
					fwrite( $fopen, "" );
					fclose( $fopen );
					$result .= "文件{$file}创建成功！<a href='" . php_self . "?dir=" . urlcode( $path ) . "&op=edit&file={$file}'>点击编辑</a>";
					break;
			}
		}
		writelog( $result );
		return $result;
	}
}

/**
 * 上传文件
 *
 * @access public
 * @param string $path 要上传的文件所保存的位置
 * @extend param array $_FILES["data"] form表单提交的文件信息数组
 * @return string
 */
function fupload( $path ) {
	$result = '';
	if ( $_FILES[ "data" ][ "error" ] > 0 ) {
		$result .= '文件上传出错：<br/>';
		$result .= '错误代码：0x00000' . $_FILES[ 'data' ][ 'error' ].'<br/>';
		$result .= '错误原因：';
		switch($_FILES[ 'data' ][ 'error' ]){
			case 1:
				$result.='上传的文件数量超过了服务器限制：'.ini_get('max_file_uploads');
				break;
			case 2:
				$result.='上传的文件大小超过了服务器限制：'.ini_get('upload_max_filesize');
				break;
			case 3:
				$result.='文件上传不完整';
				break;
			case 4:
				$result.='没有文件被上传';
				break;
			case 6:
				$result.='找不到服务器临时文件夹'.ini_get('upload_tmp_dir').'，请确保服务器配置无误';
				break;
			case 7:
				$result.='文件写入失败，请确保当前文件夹以及文件具有写入权限';
				break;
		}
	} else {
		if ( file_exists( $path . '/' . $_FILES[ "data" ][ "name" ] ) ) {
			$result .= $_FILES[ "data" ][ "name" ] . "文件已经存在。 ";
		} else {
			// 如果 upload 目录不存在该文件则将文件上传到 upload 目录下
			move_uploaded_file( $_FILES[ "data" ][ "tmp_name" ], $path . '/' . $_FILES[ "data" ][ "name" ] );
			$result .= "文件上传成功！";
		}
	}
	writelog( $_FILES[ "data" ][ "name" ] . $result );
	return $result;
}

/**
 * 遍历出所有文件或文件夹
 *
 * @access public
 * @param string $dira 要遍历的文件夹名
 * @return array
 */
function traverseDir( $dira ) {
	if ( $dh = opendir( $dira ) ) {
		while ( ( $file = readdir( $dh ) ) !== false ) {
			if ( ( $file != '.' ) && ( $file != '..' ) && is_dir( $dira . '/' . $file ) ) {
				yield $dira . '/' . $file;
				foreach ( traverseDir( $dira . '/' . $file ) as $v ) {
					yield encode($v)['string'];
				}
			}
			clearstatcache();
		}
	}
}

/**
 * 遍历出所有文件或文件夹(实验功能)
 */
function outputDir( $dira, $hide=false ) {
	$tmp='';
	if ( $dh = opendir( $dira ) ) {
		$tmp.='<ul class'.($hide?' style="display:none"':'').'>';
		while ( ( $file = readdir( $dh ) ) !== false ) {
			if ( ( $file != '.' ) && ( $file != '..' ) && is_dir( $dira . '/' . $file ) ) {
				$fileId=sizeof(explode('/', ( $dira . '/' . $file )))-1;
				$tmp.='<li>';
				$tmp.='<div class="treeNode" style="padding-left: '.(20*$fileId).'px" data-file-id="'.$fileId.'" data-file="'.$dira . '/' . $file.'">';
						$tmp.='<i class="fa fa-plus-square"></i>';
						$tmp.='<i class="fa fa-folder"></i>';
						$tmp.='<span class="title">'.encode($file)['string'].'</span>';
					$tmp.='</div>';
					$tmp.=outputDir( $dira . '/' . $file, true );
				$tmp.='</li>';
			}
		}
		$tmp.='</ul>';
	}
	return $tmp;
}

/**
 * 预览压缩包
 *
 * @access public
 * @param string $file 目标压缩包的文件名
 * @return string
 */
function fPreviewArchive( $file ) {
	$result = "";
	switch ( substr( $file, strrpos( $file, "." ) + 1 ) ) {
		case "zip":
			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive();
				if ( $zip->open( $file ) === TRUE ) {
					$result .= "<table class='table table-striped table-hover row mx-0' style='max-height:400px;overflow:auto;'>";
					$result .= "<thead class='thead-light w-100'>";
					$result .= "<tr class='row mx-0'>";
					$result .= "<th class='col-7'>文件名</th>";
					$result .= "<th class='col-5'>大小</th>";
					$result .= "</tr>";
					$result .= "</thead>";
					$result .= "<tbody class='w-100'>";
					for ( $i = 0; $i < $zip->numFiles; $i++ ) {
						$info = $zip->statIndex( $i );
						$result .= "<tr class='row mx-0'>";
						$result .= "<td class='col-7' style='word-wrap:break-word;'>" . $zip->getNameIndex( $i ) . "</td>";
						$result .= "<td class='col-5'>" . $info[ 'size' ] . "</td>";
						$result .= "</tr>";
					}
					$result .= "</tbody></table>";
					$zip->close();
				} else {
					$result .= "无法打开压缩文件！";
				}
			} else {
				$result .= "不支持ZipArchive";
			}
			break;
		case "rar":
			if ( class_exists( 'RarArchive' ) ) {
				$rar_file = rar_open( $file );
				if ( rar_broken_is( $rar_file ) ) {
					return "压缩文件已经损坏，请检查原文件后重新下载或上传！";
				}
				if ( $rar_file ) {
					$entries = rar_list( $rar_file );
					foreach ( $entries as $entry ) {
						$result .= $entry . "<br>";
					}
					rar_close( $rar_file );
				} else {
					$result .= "无法打开压缩文件！";
				}
			} else {
				$result .= "不支持RarArchive";
			}
			break;
		default:
			$result .= "不支持的压缩文件";
			break;
	}
	writelog( $file . $result );
	return $result;
}

/**
 * 解压压缩包
 *
 * @access public
 * @param string $dd 要解压的路径名
 * @param string $file 目标压缩包的文件名
 * @return string
 */
function fUnArchive( $dd, $file ) {
	$result = "";
	switch ( substr( $file, strrpos( $file, "." ) + 1 ) ) {
		case "zip":
			if ( class_exists( 'ZipArchive' ) ) {
				$zip = new ZipArchive();
				if ( $zip->open( $file ) === TRUE ) {
					if ( $zip->extractTo( $dd ) ) {
						$result .= "解压完成！";
					} else {
						$result .= "解压失败！";
					}
					$zip->close();
				} else {
					$result .= "无法打开压缩文件！";
				}
			} else {
				$result .= "不支持ZipArchive";
			}
			break;
		case "rar":
			if ( class_exists( 'RarArchive' ) ) {
				$rar_file = rar_open( $file );
				if ( rar_broken_is( $rar_file ) ) {
					return "压缩文件已经损坏，请检查原文件后重新下载或上传！";
				}
				if ( $rar_file ) {
					if ( $rar_file->extract( $dd ) ) {
						$result .= "解压完成！";
					} else {
						$result .= "解压失败！";
					}
					rar_close( $rar_file );
				} else {
					$result .= "无法打开压缩文件！";
				}
			} else {
				$result .= "不支持RarArchive";
			}
			break;
	}
	writelog( $file . $result );
	return $result;
}

/**
 * 压缩文件或文件夹
 *
 * @access public
 * @global string $dir 当前访问的路径
 * @param string $zipfile 目标压缩包的文件名
 * @param string $files 要压缩的文件或文件夹，多个则之间用英文逗号,隔开
 * @return string
 */
function archivefile( $zipfile, $files ) {
	global $dir;
	$result = '';
	if ( class_exists( 'ZipArchive' ) ) {
		$zip = new ZipArchive();
		if ( $zip->open( $zipfile, ZipArchive::CREATE | ZipArchive::OVERWRITE ) ) {
			foreach ( explode( ',', $files ) as $file ) {
				if ( is_dir( $dir . '/' . $file ) ) {
					addFileToZip( $dir . '/' . $file, $zip );
				} else {
					$zip->addFile( $dir . '/' . $file );
				}
				$result .= $dir . '/' . $file . "已经添加进压缩包<br>";
			}
			$zip->close();
			$result .= "压缩包创建完成<br>";
		} else {
			$result .= "无法创建压缩包<br>";
		}
	} else {
		$result .= "不支持ZipArchive";
	}
	return $result;
}

/**
 * archivefile()的辅助函数，用于将文件夹或文件添加进压缩包
 *
 * @access public
 * @param string $path 正在检索文件或文件夹
 * @param object $zip 目标zip对象
 */
function addFileToZip( $path, $zip ) {
	$handler = opendir( $path ); //打开当前文件夹由$path指定。
	while ( ( $filename = readdir( $handler ) ) !== false ) {
		if ( $filename != "." && $filename != ".." ) { //文件夹文件名字为'.'和‘..’，不要对他们进行操作
			if ( is_dir( $path . "/" . $filename ) ) { // 如果读取的某个对象是文件夹，则递归
				addFileToZip( $path . "/" . $filename, $zip );
			} else { //将文件加入zip对象
				$zip->addFile( $path . "/" . $filename );
			}
		}
	}
	@closedir( $path );
}

/**
 * CURL下载的回调函数
 *
 * @access public
 * @param $ch
 * @param int $countDownloadSize 下载的文件总大小
 * @param int $currentDownloadSize 已下载的文件大小
 * @param int $countUploadSize 上传的文件总大小
 * @param int $currentUploadSize 已上传的文件大小
 */
function downloadProgress_callback( $ch, $countDownloadSize, $currentDownloadSize, $countUploadSize, $currentUploadSize ) {
	global $msg;
	$progress = '';
	$progress .= ($currentDownloadSize/$countDownloadSize*100).'%';
	$msg = $progress;
}

if ( !function_exists( 'array_column' ) ) {
	/**
	 * 返回输入数组中某个单一列的值。
	 *
	 * @access public
	 * @param array $input 规定要使用的多维数组（记录集）
	 * @param string $columnKey 需要返回值的列
	 * @param string $indexKey 用作返回数组的索引/键的列
	 * @return array
	 */
	function array_column( array $input, $columnKey, $indexKey = null ) {
		$array = array();
		foreach ( $input as $value ) {
			if ( !array_key_exists( $columnKey, $value ) ) {
				trigger_error( "Key \"$columnKey\" does not exist in array" );
				return false;
			}
			if ( is_null( $indexKey ) ) {
				$array[] = $value[ $columnKey ];
			} else {
				if ( !array_key_exists( $indexKey, $value ) ) {
					trigger_error( "Key \"$indexKey\" does not exist in array" );
					return false;
				}
				if ( !is_scalar( $value[ $indexKey ] ) ) {
					trigger_error( "Key \"$indexKey\" does not contain scalar value" );
					return false;
				}
				$array[ $value[ $indexKey ] ] = $value[ $columnKey ];
			}
		}
		return $array;
	}
}

/**
 * 显示文件夹和文件列表
 *
 * @access public
 * @param $ch
 * @param string $dir 要遍历的文件夹
 */
function showFileList( $dir ) {
	global $username, $password;
	$dir_arr = array();
	$file_arr = array();
	$canGoBack = false;
	if ( @is_dir( $dir ) ) {
		writelog( "访问合法路径" . $dir );
		if ( $dh = opendir( $dir ) ) {
			while ( ( $file = readdir( $dh ) ) !== false ) { //遍历出所有子文件夹
				if ( $file == "." || $file == ".." ) {
					continue;
				}
				$fileinfo = "";
				$fileinfo .= "创建时间：" . date( "Y-m-d H:i:s", @filectime( $dir . '/' . $file ) ) . "<br>";
				$fileinfo .= "访问时间：" . date( "Y-m-d H:i:s", @fileatime( $dir . '/' . $file ) ) . "<br>";
				$fileinfo .= "修改时间：" . date( "Y-m-d H:i:s", @filemtime( $dir . '/' . $file ) ) . "<br>";
				$fileinfo .= "读/写：" . @( is_writable( $dir . '/' . $file ) ? ( is_readable( $dir . '/' . $file ) ? "可读写" : "只写" ) : ( is_readable( $dir . '/' . $file ) ? "只读" : "不可读写" ) );
				$type = "";
				$opicon = "download";
				$optip = "下载";
				$op = "fdownload";
				//修改文件前面的图标
				switch ( substr( $file, strrpos( $file, "." ) + 1 ) ) {
					case "jpg":
					case "jpeg":
					case "png":
					case "gif":
					case "bmp":
					case "webp":
					case "ico":
					case "tif":
						$type = "-image";
						$opicon = "photo";
						$optip = "查看";
						$op = "fimg";
						break;
					case "zip":
					case "rar":
						$type = "-archive";
						$opicon = "gift";
						$optip = "解压";
						$op = "unarchive";
						break;
					case "wav":
					case "aif":
					case "aiff":
					case "au":
					case "mp1":
					case "mp2":
					case "mp3":
					case "ra":
					case "rm":
					case "ram":
					case "mid":
					case "rmi":
						$type = "-audio";
						$opicon = "music";
						$optip = "播放";
						$op = "playmusic";
						break;
					case "c":
					case "hpp":
					case "cpp":
					case "h":
					case "php":
					case "asp":
					case "aspx":
					case "jsp":
					case "asm":
					case "for":
					case "lib":
					case "lst":
					case "msg":
					case "obj":
					case "pas":
					case "wki":
					case "bas":
					case "java":
					case "py":
						$type = "-code";
						$opicon = "edit";
						$optip = "编辑";
						$op = "fedit";
						break;
					case "xls":
					case "xlsx":
						$type = "-excel";
						$opicon = "eye";
						$optip = "预览";
						$op = "office";
						break;
					case "avi":
					case "mpg":
					case "mp4":
					case "mov":
					case "swf":
						$type = "-movie";
						$opicon = "film";
						$optip = "播放";
						$op = "playfilm";
						break;
					case "pdf":
						$type = "-pdf";
						$opicon = "eye";
						$optip = "预览";
						$op = "office";
						break;
					case "ppt":
					case "pptx":
						$type = "-powerpoint";
						$opicon = "eye";
						$optip = "预览";
						$op = "office";
						break;
					case "txt":
					case "text":
					case "htm":
					case "html":
					case "shtml":
					case "css":
					case "js":
					case "tpl":
					case "htx":
					case "inf":
					case "ini":
					case "log":
					case "asa":
					case "inc":
					case "htaccess":
					case "htpasswd":
					case "less":
					case "sass":
					case "scss":
					case "rb":
						$type = "-text";
						$opicon = "edit";
						$optip = "编辑";
						$op = "fedit";
						break;
					case "doc":
					case "docx":
						$type = "word";
						$opicon = "eye";
						$optip = "预览";
						$op = "office";
						break;
				}
				$tempdir = ( $file == '..' ) ?
					( pathinfo( $dir )[ 'dirname' ] ) : //返回上一级目录 
					( ( $file == '.' ) ?
						( $file ) : //返回根目录
						( $dir . '/' . $file ) ); //写出当前所有子文件夹全路径
				$canGoBack = ( '.' == $dir );
				$info_arr = array();
				$info_arr[ 'path' ] = $dir . '/';
				$info_arr[ 'name' ] = $file;
				$info_arr[ 'extname' ] = substr( $file, strrpos( $file, "." ) + 1 );
				$info_arr[ 'size' ] = filesize( $dir . '/' . $file );
				$info_arr[ 'mtime' ] = @filemtime( $dir . '/' . $file );
				$info_arr[ 'fileinfo' ] = $fileinfo;
				if ( is_dir( $tempdir ) && ( $file != $dir ) && ( $file != '.' ) && ( $file != '..' ) ) {
					$dir_arr[] = $info_arr;
				}
				if ( is_file( $tempdir ) ) {
					$info_arr[ 'type' ] = $type;
					$info_arr[ 'opicon' ] = $opicon;
					$info_arr[ 'optip' ] = $optip;
					$info_arr[ 'op' ] = $op;
					$file_arr[] = $info_arr;
				}
			}
		}
	} else {
		?>
		<div class="alert alert-danger"><strong>警告！</strong>路径
			<?php echo $dir ?>不合法！</div>
		<?php
		exit;
	}
	?>
	<ul class="breadcrumb">
<?php 
array_multisort(array_column($file_arr, $_SESSION['order']),($_SESSION['sort']=='desc'?SORT_DESC:SORT_ASC),($_SESSION['order']=='name'||$_SESSION['order']=='type')?(SORT_STRING | SORT_FLAG_CASE):SORT_REGULAR,(($_SESSION['order']=='type')?array_column($file_arr, 'extname'):array_column($file_arr, 'name')),$file_arr);
array_multisort(array_column($dir_arr, $_SESSION['order']),($_SESSION['sort']=='desc'?SORT_DESC:SORT_ASC),($_SESSION['order']=='name'||$_SESSION['order']=='type')?(SORT_STRING | SORT_FLAG_CASE):SORT_REGULAR,$dir_arr);
$dirarray = explode('/',$dir);//将当前目录分割成数组，以输出面包屑导航
for($i=0;$i<count($dirarray)-1;$i++){//输出带链接路径部分
$dirarray[$i]=encode($dirarray[$i])['string'];
?>
		<li>
			<a href='javascript:void(0);' onclick='opendir("<?php for($j=0;$j<=$i;$j++)echo ($j>0?'/':'').$dirarray[$j]; ?>")'>
				<?php echo $dirarray[$i] ?>
			</a>
		</li>
		<?php } ?>
		<li class="active">
			<?php echo $dirarray[count($dirarray)-1] ?>
		</li>
	</ul>
	<a href = 'javascript:void(0);'
	onclick = 'opendir("<?php echo $dir;?>")' >
		<div class="fa fa-refresh" style="position:relative;top:-45px;right:10px;height:0;width:auto;float:right;"></div> </a>
	<table id="filetable" class="table table-striped table-hover" data-toggle="modal" data-target="#exampleModal">
		<thead>
			<tr>
				<th class="">
					<a href="javascript:void(0);" onclick="sort('<?php echo $dir ?>','name','<?php echo $_SESSION['sort']=='asc'?'desc':'asc' ?>')">文件名<?php if($_SESSION['order']=='name'){?><i class="fa fa-sort-<?php echo $_SESSION['sort']=='asc'?'asc':'desc' ?>"></i><?php } ?></a>
					<a href="javascript:void(0);" onclick="sort('<?php echo $dir ?>','type','<?php echo $_SESSION['sort']=='asc'?'desc':'asc' ?>')">类型<?php if($_SESSION['order']=='type'){?><i class="fa fa-sort-<?php echo $_SESSION['sort']=='asc'?'asc':'desc' ?>"></i><?php } ?></a>
					<a href="javascript:void(0);" onclick="sort('<?php echo $dir ?>','mtime','<?php echo $_SESSION['sort']=='asc'?'desc':'asc' ?>')">时间<?php if($_SESSION['order']=='mtime'){?><i class="fa fa-sort-<?php echo $_SESSION['sort']=='asc'?'asc':'desc' ?>"></i><?php } ?></a>
				</th>
				<th class=""><a href="javascript:void(0);" onclick="sort('<?php echo $dir ?>','size','<?php echo $_SESSION['sort']=='asc'?'desc':'asc' ?>')">大小<?php if($_SESSION['order']=='size'){?><i class="fa fa-sort-<?php echo $_SESSION['sort']=='asc'?'asc':'desc' ?>"></i><?php } ?></a>
				</th>
				<th class="">操作</th>
				<th class="">权限</th>
			</tr>
		</thead>
		<tbody>
			<?php if(!$canGoBack){ ?>
			<tr data-back="true">
				<td class=""><i class="fa fa-home"></i>
					<a href='javascript:void(0);' onclick='opendir(".")'>根目录</a>
				</td>
				<td class=""></td>
				<td class=""></td>
				<td class=""></td>
			</tr>
			<tr data-back="true">
				<td class=""><i class="fa fa-level-up"></i>
					<a href='javascript:void(0);' onclick='opendir("<?php echo pathinfo( $dir )[ 'dirname' ]?>")'>上一级目录</a>
				</td>
				<td class=""></td>
				<td class=""></td>
				<td class=""></td>
			</tr>
			<?php } ?>
			<?php foreach($dir_arr as $v){ ?>
			<tr>
				<td class=""><i class="fa fa-folder-o "></i>
					<a href='javascript:void(0);' onclick='opendir("<?php echo encode($v['path'].$v['name'])['string']?>")' data-toggle='tooltip' data-html='true' title='<?php echo $v['fileinfo']?>' style='word-wrap: break-word;'>
						<?php echo encode($v['name'])['string'] ?>
					</a>
					<input type="hidden" value="<?php echo urlcode($v['name'])?>"/>
					<input type="hidden" value="<?php echo urlcode($v['path'].$v['name']) ?>"/>
				</td>
				<td class=""></td>
				<td class="">
					<a href='javascript:void(0);' onclick='opendir("<?php echo $v['path'].$v['name']?>")'><i class="fa fa-folder-open-o" data-toggle="tooltip" data-placement="left" title="打开"></i></a> &nbsp;&nbsp;&nbsp;
					<a href='javascript:void(0);' onclick='frename1($(this),"<?php echo substr($v['path'],0,strlen($v['path'])-1).'","'.$v['name'] ?>")'><i class="fa fa-magic" data-toggle="tooltip" data-placement="left" title="重命名"></i></a> &nbsp;&nbsp;&nbsp;
					<a href="javascript:void(0);" onClick="window.open('<?php echo encode($v['path'].$v['name'].'/')['string'] ?>')"><i class="fa fa-external-link" data-toggle="tooltip" data-placement="left" title="新窗口打开"></i></a>
				</td>
				<td class="">
					<?php echo substr(sprintf("%o",fileperms($v['path'].$v['name'])),-4);clearstatcache();?>
				</td>
			</tr>
			<?php } ?>
			<?php foreach($file_arr as $v){ ?>
			<tr>
				<td class=""><i class="fa fa-file<?php echo $v['type'] ?>-o"></i>
					<a href="javascript:void(0);" onClick="fpreview('<?php echo encode($v['name'])['string']?>','<?php echo $v['opicon']?>')" data-toggle="tooltip" data-html="true" title="<?php echo $v['fileinfo'] ?>" style="word-wrap: break-word;">
						<?php echo encode($v['name'])['string'] ?> </a><input type="hidden" value="<?php echo encode($v['name'])['string']?>"/>
				</td>
				<td class="">
					<?php echo getSize($v['path'].$v['name'])?>
				</td>
				<td class="">
					<a href="javascript:void(0);" onClick="<?php echo $v['op'] ?>('<?php echo urlcode($v['path']).'\',\''.urlcode($v['name']) ?>')"><i class="fa fa-<?php echo $v['opicon'] ?>" data-toggle="tooltip" data-placement="left" title="<?php echo $v['optip'] ?>"></i></a> &nbsp;&nbsp;&nbsp;
					<a href='javascript:void(0);' onclick='frename1($(this),"<?php echo substr($v['path'],0,strlen($v['path'])-1).'","'.$v['name'] ?>")'><i class="fa fa-magic" data-toggle="tooltip" data-placement="left" title="重命名"></i></a> &nbsp;&nbsp;&nbsp;
					<a href="javascript:void(0);" onClick="window.open('<?php echo encode($v['path'].$v['name'])['string'] ?>')"><i class="fa fa-external-link" data-toggle="tooltip" data-placement="left" title="新窗口打开"></i></a>
				</td>
				<td class="">
					<?php echo substr(sprintf("%o",fileperms($v['path'].$v['name'])),-4);clearstatcache();?>
				</td>
			</tr>
			<?php } ?>
		</tbody>
	</table>
	<div class="btn-group operate">
		<button type="button" class="btn btn-primary" onClick="selectall()">全选</button>
		<button type="button" class="btn btn-primary" onClick="zipfile()">压缩</button>
		<button type="button" class="btn btn-primary" onClick="fdelete()">删除</button>
		<button type="button" class="btn btn-primary" onClick="fcopy()">复制</button>
		<button type="button" class="btn btn-primary" onClick="fcut()">移动</button>
		<button type="button" class="btn btn-primary" onClick="fchmod()">权限</button>
		<button type="button" class="btn btn-primary" onClick="fcompare()">对比</button>
	</div>
	<div id="loadModal"></div>
	<?php
}

/**
 *加载Modal模态框
 */
function loadModal(){
	echo '<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">'
		.'<div class="modal-dialog">'
	  	.'<div class="modal-content">'
	  	.'<div class="modal-header">'
	  	.'<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>'
	  	.'<h4 class="modal-title" id="myModalLabel"></h4>'
	  	.'</div>'
	  	.'<div class="modal-body">'
	  	.'</div>'
	  	.'<div class="modal-footer">'
	  	.'<button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="opendir(\\\'<?php echo $dir ?>\\\')">确定</button>'
		.'</div>'
	  	.'</div><!-- /.modal-content -->'
	  	.'</div><!-- /.modal -->'
	  	.'</div>';
}

/**
 *加载自定义javascript
 */
function loadScript( $init = false ) {
	global $username, $password, $dir,$opendfile, $operate, $extradata, $version;
	?>
	<script type="text/javascript">
		history.replaceState(null, null, document.URL);
		window.document.oncontextmenu = function(){
			return false;
		}
	</script>
	<script>
		<?php if($init){?>
		$( document ).ready( function () {
			<?php }?>
			$( '.btn-group.operate' ).css( "left", ( $( document ).width() - $( '.btn-group.operate' ).width() ) / 2 );
			$( '[data-toggle="tooltip"]' ).tooltip();
			$( '.btn-group.operate button:gt(1)' ).addClass( 'disabled' );
			$( '.btn-group.operate button:gt(1)' ).attr( 'disabled', 'disabled' );
			$( '#filetable tbody tr' ).click( function (e) {
				if(e.target=="[object HTMLTableCellElement]"){
					if ( $( this ).attr( "data-back" ) != "true" ) {
						$( this ).toggleClass( "active" );
					}
					if ( $( '#filetable tr.active' ).length > 0 ) {
						$( '.btn-group.operate button:gt(1)' ).removeClass( 'disabled' );
						$( '.btn-group.operate button:gt(1)' ).attr( 'disabled', false );
					} else {
						$( '.btn-group.operate button:gt(1)' ).addClass( 'disabled' );
						$( '.btn-group.operate button:gt(1)' ).attr( 'disabled', 'disabled' );
					}
					if ( $( '#filetable tbody tr.active:not([data-back])' ).length != $( '#filetable tbody tr:not([data-back])' ).length ) {
						$( '.btn-group.operate button:eq(0)' ).removeClass( 'disabled' );
						$( '.btn-group.operate button:eq(0)' ).attr( 'disabled', false );
					} else {
						$( '.btn-group.operate button:eq(0)' ).addClass( 'disabled' );
						$( '.btn-group.operate button:eq(0)' ).attr( 'disabled', 'disabled' );
					}
				}
			} );
			<?php if($init){?>
		} );
		<?php }?>

		function opendir( data ) {
			$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "showfilelist",
					dir: data
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
		}
		function nameformat(formats,count=0){
			Date.prototype.format = function(fmt){
				var o = {
					"M+" : this.getMonth()+1,                 //月份
					"d+" : this.getDate(),                    //日
					"h+" : this.getHours(),                   //小时
					"m+" : this.getMinutes(),                 //分
					"s+" : this.getSeconds(),                 //秒
					"q+" : Math.floor((this.getMonth()+3)/3), //季度
					"S"  : this.getMilliseconds()            //毫秒
					//"i+"  : count                             //计数
				};
				if(/(y+)/.test(fmt)){
					fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
				 }
				if(/(i+)/.test(fmt)){
					var zero="";
					for(var i=0;i<(RegExp.$1.length-count.toString().length);i++)
					{
						zero+="0";
					}
					zero+=count.toString();
					fmt=fmt.replace(RegExp.$1, zero.substr(zero.length-RegExp.$1.length));
				}
				for(var k in o){
					if(new RegExp("("+ k +")").test(fmt)){
						fmt = fmt.replace(
							RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));  
					}
				}
				return fmt;
			}
			var d=new Date().format(formats);
			return d;
		}
		function frename1( element, dir, data ) {
			if($( '#filetable tbody tr.active').length>0){
				var arrElement = [];
				var rename = [];
				var selectedElement = $( '#filetable tbody tr.active');
				$( "#loadModal" ).html('<?php loadModal(); ?>');
				$( '#myModal .modal-title' ).text("批量重命名");
				selectedElement.each(function(index,element){
					arrElement[index]=$(this).children().eq(0).children().eq(2).val();
					rename[index]=$(this).children().eq(0).children().eq(2).val();
				});
				$( '#myModal .modal-body' ).html("<input id='findInput' class='form-control' type='text' placeholder='查找内容，支持正则表达式' style='width:100%'><input id='replaceInput' class='form-control' type='text' placeholder='替换内容，支持正则表达式' style='width:100%'><input id='frBtn' class='btn btn-secondary' type='button' value='预览'><div id='preview'></div>");
				$('#frBtn').click(function(){
					if($('#findInput').val().charAt(0)=='/'){
						try{
							var findStr=eval($('#findInput').val());
						}catch(e){
							var findStr=$('#findInput').val();
						}
					}else{
						var findStr=$('#findInput').val();
					}
					if($('#replaceInput').val().charAt(0)=='/'){
						try{
							var replaceStr=eval($('#replaceInput').val());
						}catch(e){
							var replaceStr=$('#replaceInput').val();
						}
					}else{
						var replaceStr=$('#replaceInput').val();
					}
					for(var i=0;i<arrElement.length;i++){
						rename[i]=arrElement[i].replace(findStr,replaceStr.replace(/\{[\s\S]*\}/,function(word){
							return nameformat(word, i).replace(/[\{|\}]/g,'');
						}));
					}
					var tmp="<table class='table table-bordered table-striped table-hover table-condensed'><tr><th>文件名</th><th>预览</th></tr>";
					for(var i=0;i<rename.length;i++){
						tmp=tmp+"<tr><td>"+arrElement[i]+"</td><td>"+rename[i]+"</td></tr>";
					}
					tmp=tmp+"</table>";
					$('#preview').html(tmp);
				});
				$( '#myModal .modal-footer .btn' ).attr("onclick","");
				$( '#myModal .modal-footer .btn' ).click(function(){
					$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "batchrename",
						dir: dir,
						file:arrElement.toString(),
						data:rename.toString()
					},
					function ( data, status ) {
						$( "#loadModal").html( data );
					} );
				});
				$('#myModal').on('hide.bs.modal', function () {
					$('body').css('padding-right',parseInt($('body').css('padding-right').replace('px',''))-17+'px');//修复Modal组件被连续调用之后，右间距无法恢复的问题
				})
				$( '#myModal' ).modal( {
					backdrop: false
				} )
			}else{
				element.parent().parent().children().eq(0).html("<input type='text' class='form-control' data-dir='"+dir+"' data-originname='"+data+"' value='" + data + "'>");
				element.parent().parent().children().eq(0).children().eq(0).bind('blur',function(event){
					frename2($(this));
				}).bind('keypress',function(event){ 
					if(event.keyCode == 13)      
					{  
						$(this).unbind('blur');
						frename2($(this));
					}  
				});
			}
		}
		function frename2( element ) {
			var dirname=element.attr("data-dir");
			var oldname=element.attr("data-originname");
			var newname=element.val();
			$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "rename",
					dir: dirname,
					file:oldname,
					data:newname
				},
				function ( data, status ) {
					$( "#loadModal").html( data );
				} );
		}
		function fcreate() {
 			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-title' ).text("新建文件");
			$( '#myModal .modal-body' ).html("<input type=\"text\" class=\"form-control\" value=\"\" placeholder=\"请输入新的文件夹或文件名称\" id=\"usr\"><select class=\"form-control\" id=\"sel2\"><option value=\"directory\">文件夹</option><option value=\"file\">文件</option></select>");
			$( '#myModal .modal-footer .btn' ).click(function(){
				var filename=$( '#usr' ).val();
				var type=$( '#sel2' ).val();
				$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "create",
						dir: "<?php echo $dir ?>",
						file:filename,
						data:type
					},
					function ( data, status ) {
						$( "#main" ).html( data );
					} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fupload() {
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "<form id=\"fileform\" action=\"<?php echo php_self ?>\" method=\"post\"  enctype=\"multipart/form-data\"><div class=\"custom-file\"><input type=\"file\" class=\"custom-file-input\" name=\"data\" id=\"customFile\"><input type=\"hidden\" name=\"username\" value=\"<?php echo $username;?>\"><input type=\"hidden\" name=\"password\" value=\"<?php echo md5($password);?>\"><input type=\"hidden\" name=\"op\" value=\"upload\"><input type=\"hidden\" name=\"dir\" value=\"<?php echo $dir ?>\"><label class=\"custom-file-label\" for=\"customFile\">选择文件</label></div></form>" );
			var formData = new FormData();
			$( '#myModal .modal-title' ).text( "上传文件" );
			$( '#myModal .modal-footer .btn' ).text( "上传" );	
			$( '#myModal .modal-footer .btn' ).attr("onclick","");
			$( '#myModal .modal-footer .btn' ).click(function(){
				formData.append("username", "<?php echo $username;?>");
				formData.append("password", "<?php echo md5($password);?>");
				formData.append("op", "upload");
				formData.append("dir", "<?php echo $dir ?>");
				formData.append("data",$('#customFile')[0].files[0]);
				$.ajax({
					url: "<?php echo php_self;?>",
					type: "POST",
					cache: false,
					data: formData,
					processData: false,
					contentType: false,
					beforeSend: function(XHR){
						$( '#myModal .modal-body' ).html( "<div class=\"progress-bar progress-bar-success\" role=\"progressbar\" aria-valuenow=\"60\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 40%;\"><span class=\"sr-only\">40% 完成</span></div>" );
						$( 'button.close' ).hide();
						$( '#myModal .modal-footer .btn' ).hide();
						$( '#myModal' ).modal({keyboard: false,backdrop: false});
						$( '#myModal' ).modal('show');
					},
					complete: function(XHR, TS){
						$( "#loadModal").html(XHR.responseText);
      				},
					xhr: function() {
						var xhr = new XMLHttpRequest();
						//使用XMLHttpRequest.upload监听上传过程，注册progress事件，打印回调函数中的event事件
						xhr.upload.addEventListener('progress', function (e) {
							console.log(e);
							//loaded代表上传了多少
							//total代表总数为多少
							var progressRate = ((e.loaded / e.total) * 100).toFixed(0) + '%';
							//通过设置进度条的宽度达到效果
							$('div.progress-bar.progress-bar-success').css('width', progressRate);
							$('span.sr-only').html(progressRate+" 完成");
						})
						return xhr;
					}
				});
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function checkVersion(){
			var url=eval(function(p,a,c,k,e,d){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--)d[e(c)]=k[c]||e(c);k=[function(e){return d[e]}];e=function(){return'\\w+'};c=1};while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);return p}('"4://1.3.2/8/5/0/7/6"',62,9,'Drawer|api|com|github|https|joytou|latest|releases|repos'.split('|'),0,{}));
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html("<i class=\"fa fa-spinner fa-pulse fa-2x fa-fw\"></i>正在检查更新，请稍候...");
			$( '#myModal .modal-title' ).text( "检查更新" ); 
			$( '#myModal .modal-footer .btn' ).text( "确定" ); 
			$( '#myModal .modal-footer .btn' ).attr("onclick","");
			setTimeout(function(){
				$.getJSON(url,function(data,status,xhr){
					var pattern = /([\d]+).([\d]+).([\d]+).([\d])/;
					var latestVirsion = pattern.exec(data['name']);
					var localVirsion = pattern.exec("<?php echo $version; ?>");
					if(parseInt(latestVirsion[1])>parseInt(localVirsion[1]) || 
						parseInt(latestVirsion[2])>parseInt(localVirsion[2]) || 
						parseInt(latestVirsion[3])>parseInt(localVirsion[3]) || 
						parseInt(latestVirsion[4])>parseInt(localVirsion[4])){
						var filesize = parseInt(data['assets'][0]['size']);
						if ( filesize < 1024 ) {
							filesize = filesize+ 'B';
						} else if ( filesize >= 1024 && filesize < 1048576 ) {
							filesize = ( filesize / 1024 ).toFixed(2) + 'K';
						} else if ( filesize >= 1048576 && filesize < 1073741824 ) {
							filesize = ( filesize / 1048576 ).toFixed(2) + 'M';
						} else {
							filesize = ( filesize / 1073741824 ).toFixed(2) + 'G';
						}
						$( '#myModal .modal-body' ).html('检测到新版本：<strong>'+data['name']+'</strong>'
						+'<br/>文件大小：'+filesize
						+'<br/>发布时间：'+(data['published_at'].replace(/[T|Z]/g,'&nbsp;&nbsp;'))
						+'<br/>更新内容：<br/>&nbsp;&nbsp;&nbsp;&nbsp;'+(data['body'].replace(/\r\n/g,"<br/>&nbsp;&nbsp;&nbsp;&nbsp;"))
						+'<br/>是否更新？');
						$( '#myModal .modal-footer .btn' ).text( "下载" );
						$( '#myModal .modal-footer .btn' ).click(function(){
							var link = document.createElement('a');
							link.style.display = 'none';
							link.href = data['assets'][0]['browser_download_url'];
							document.body.appendChild(link);
							link.click();
							document.body.removeChild(link);
						});
					}else{
						$( '#myModal .modal-body' ).html("当前已经是最新版本<br/>版本号："+data['name']);
					}
				});
			},1000);
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fremotedownload(){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html("什么是远程下载？<br>远程下载是从其它服务器获取文件并直接下载到当前服务器的一种功能。<br>类似于SSH的Wget功能，免去我们下载再手动上传所浪费的时间。<select class='form-control' id='sel1'><option>.</option><?php foreach(traverseDir(".") as $v){echo "<option".($v==$dir?" selected='selected'":"").">{$v}</option>"; } ?></select><input type='text' class='form-control' id='usre' value=\"\" placeholder='请输入远程文件的下载地址'>");
			$( '#myModal .modal-title' ).text( "远程下载" ); 
			$( '#myModal .modal-footer .btn' ).text( "确定" ); 
			$( '#myModal .modal-footer .btn' ).attr("onclick","");
			$( '#myModal .modal-footer .btn' ).click(function(){
				var dirname=$('#sel1').val();
				var filename=$('input[type=text]#usre').val();
				var formData = new FormData();
				formData.append("username", "<?php echo $username;?>");
				formData.append("password", "<?php echo md5($password);?>");
				formData.append("op", "remotedownload");
				formData.append("dir", $('#sel1').val());
				formData.append("file",$('input[type=text]#usre').val());
				$.ajax({
					url: "<?php echo php_self;?>",
					type: "POST",
					cache: false,
					data: formData,
					processData: false,
					contentType: false,
					beforeSend: function(XHR){
						$( '#myModal .modal-body' ).html( "<div class=\"progress-bar progress-bar-success\" role=\"progressbar\" aria-valuenow=\"60\" aria-valuemin=\"0\" aria-valuemax=\"100\" style=\"width: 100%;\"><span class=\"sr-only\">0% 完成</span></div>" );
						$( 'button.close' ).hide();
						$( '#myModal .modal-footer .btn' ).hide();
						$( '#myModal' ).modal({keyboard: false,backdrop: false});
						$( '#myModal' ).modal('show');
					},
					complete: function(XHR, TS){
						$( "#main").html(XHR.responseText);
      				}
				});
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function logout(){
			history.replaceState(null, null, document.URL);
			location.reload(true);
		}
		function selectall() {
			$( '#filetable tbody tr' ).each( function () {
				if ( !$( this ).attr( "data-back" ) && !$( this ).hasClass( "active" ) ) {
					$( this ).addClass( "active" );
				}
			} );
			if($( '#filetable tbody tr.active:not([data-back])' ).length==$( '#filetable tbody tr:not([data-back])' ).length){
				$('.btn-group.operate button:gt(1)').removeClass('disabled');
				$('.btn-group.operate button:gt(1)').attr('disabled',false);
				$('.btn-group.operate button:eq(0)').addClass('disabled');
				$('.btn-group.operate button:eq(0)').attr('disabled','disabled');
			}
		}
		function zipfile() {
			var arr = "";
			$( '#filetable tr' ).filter( ".active" ).each( function () {
				arr += $( $( this ).find( "td" )[ 0 ] ).find( "input[type=hidden]" )[ 0 ].value.trim() + ",";
			} );
			arr = arr.substr( 0, arr.length - 1 );
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "确定压缩以下文件或文件夹吗？<br>" + arr.replace( /,/g, "<br>" ) );
			$( '#myModal .modal-title' ).text( "压缩文件" );
			$( '#myModal .modal-footer .btn' ).text( "确定" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "" );
			$( '#myModal .modal-footer .btn' ).click(function(){
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "zip",
					dir: "<?php echo $dir ?>",
					file:arr
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fdelete() {
			var arr = "";
			$( '#filetable tr' ).filter( ".active" ).each( function () {
				arr += $( $( this ).find( "td" )[ 0 ] ).find( "input[type=hidden]" )[ 0 ].value.trim() + ",";
			} );
			arr = arr.substr( 0, arr.length - 1 );
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "确定删除以下文件或文件夹吗？<br>" + arr.replace( /,/g, "<br>" ) );
			$( '#myModal .modal-title' ).text( "删除文件" );
			$( '#myModal .modal-footer .btn' ).text( "确定" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "" );
			$( '#myModal .modal-footer .btn' ).click(function(){
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "del",
					dir: "<?php echo $dir ?>",
					file:arr
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fcopy() {
			var arr = "";
			$( '#filetable tr' ).filter( ".active" ).each( function () {
				arr += $( $( this ).find( "td" )[ 0 ] ).find( "input[type=hidden]" )[ 0 ].value.trim() + ",";
			} );
			arr = arr.substr( 0, arr.length - 1 );
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "将复制以下文件或文件夹到<select class=\"form-control\" id=\"sel1\"><option<?php echo $dir=='.'?" disabled='disabled'":""?>>.</option><?php foreach(traverseDir(".") as $v){echo "<option".($v==$dir?" disabled='disabled'":"").">{$v}</option>";}?></select><br>"+arr.replace(/,/g,"<br>"));
			$( '#myModal .modal-title' ).text( "复制文件" ); 
			$( '#myModal .modal-footer .btn' ).text( "确定" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "" );
			$( '#myModal .modal-footer .btn' ).click(function(){
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "copy",
					dir: "<?php echo $dir ?>",
					file:arr,
					data:$( '#sel1' ).val()
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fcut() {
			var arr = "";
			$( '#filetable tr' ).filter( ".active" ).each( function () {
				arr += $( $( this ).find( "td" )[ 0 ] ).find( "input[type=hidden]" )[ 0 ].value.trim() + ",";
			} );
			arr = arr.substr( 0, arr.length - 1 );
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "将以下文件或文件夹移动到<select class=\"form-control\" id=\"sel1\"><option<?php echo $dir=='.'?" disabled='disabled'":""?>>.</option><?php foreach(traverseDir(".") as $v){echo "<option".($v==$dir?" disabled='disabled'":"").">{$v}</option>"; } ?></select><br>"+arr.replace(/,/g,"<br>"));
			$( '#myModal .modal-title' ).text( "移动文件" ); 
			$( '#myModal .modal-footer .btn' ).text( "确定" );  
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "" );
			$( '#myModal .modal-footer .btn' ).click(function(){
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "cut",
					dir: "<?php echo $dir ?>",
					file:arr,
					data:$( '#sel1' ).val()
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fchmod(){
			arr = "";
			$( '#filetable tr' ).filter( ".active" ).each( function () {
				arr += $( $( this ).find( "td" )[ 0 ] ).find( "input[type=hidden]" )[ 0 ].value.trim() + ",";
			} );
			arr = arr.substr( 0, arr.length - 1 );
			chmod1=0;
			chmod2=0;
			chmod3=0;
			chmod4=0;
			chmodstr = "";
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$('#myModal .modal-body').html("<table id='chmodtable' width='100%' border='0' cellspacing='0' cellpadding='0' align='center'><tbody><tr><td align='center' scope='col'>&nbsp;</td><td align='center' scope='col'>读</td><td align='center' scope='col'>写</td><td align='center' scope='col'>执行</td></tr><tr><td align='center' scope='row'>所有者</td><td align='center'><input type='checkbox' name='checkbox1' id='checkbox1' value='4'></td><td align='center'><input type='checkbox' name='checkbox2' id='checkbox2' value='2'></td><td align='center'><input type='checkbox' name='checkbox3' id='checkbox3' value='1'></td></tr><tr><td align='center' scope='row'>用户组</td><td align='center'><input type='checkbox' name='checkbox4' id='checkbox4' value='4'></td><td align='center'><input type='checkbox' name='checkbox5' id='checkbox5' value='2'></td><td align='center'><input type='checkbox' name='checkbox6' id='checkbox6' value='1'></td></tr><tr><td align='center' scope='row'>其它</td><td align='center'><input type='checkbox' name='checkbox7' id='checkbox7' value='4'></td><td align='center'><input type='checkbox' name='checkbox8' id='checkbox8' value='2'></td><td align='center'><input type='checkbox' name='checkbox9' id='checkbox9' value='1'></td></tr><tr><td colspan='4' align='center'>----特殊权限----</td></tr><tr><td align='center' scope='row'>&nbsp;</td><td align='center'><input type='checkbox' name='checkbox10' id='checkbox10' value='4'><label for='checkbox10'>设置GID </label></td><td align='center'><input type='checkbox' name='checkbox11' id='checkbox11' value='2'><label for='checkbox11'>设置UID </label></td><td align='center'><input type='checkbox' name='checkbox12' id='checkbox12' value='1'><label for='checkbox12'>粘滞 </label></td></tr><tr><td colspan='4' align='center'>&nbsp;</td></tr></tbody></table>"+arr.replace(/,/g,"<br>"));
			$( 'table#chmodtable tbody tr input[type=checkbox]' ).click( function () {
				switch($(this).parent().parent().index())
				{
					case 1:
						if($( this ).is( ":checked" )){
							chmod2+=parseInt($(this).attr("value"));	
						}else{
							chmod2-=parseInt($(this).attr("value"));
						}
						break;
					case 2:
						if($( this ).is( ":checked" )){
							chmod3+=parseInt($(this).attr("value"));	
						}else{
							chmod3-=parseInt($(this).attr("value"));
						}
						break;
					case 3:
						if($( this ).is( ":checked" )){
							chmod4+=parseInt($(this).attr("value"));	
						}else{
							chmod4-=parseInt($(this).attr("value"));
						}
						break;
					case 5:
						if($( this ).is( ":checked" )){
							chmod1+=parseInt($(this).attr("value"));	
						}else{
							chmod1-=parseInt($(this).attr("value"));
						}
						break;
				}
				chmodstr = chmod1.toString()+chmod2.toString()+chmod3.toString()+chmod4.toString()+"";
				$( 'table#chmodtable tbody tr:eq(6) td' ).html(chmodstr);
			} );
			chmodstr = chmod1.toString()+chmod2.toString()+chmod3.toString()+chmod4.toString()+"";
			$( '#myModal .modal-title' ).text( "修改权限" );
			$( '#myModal .modal-footer .btn' ).text( "确定" );
			$( '#myModal .modal-footer .btn' ).attr("onclick","");
			$( '#myModal .modal-footer .btn' ).click(function(){
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "chmod",
					dir: "<?php echo $dir ?>",
					file:arr,
					data:chmodstr
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fcompare(){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html('<div id="edit_div_title" style="border-bottom: 1px solid #e5e5e5;"></div><div id="edit_div" style="overflow-y: scroll;"><div id="edit_div1" style="float:left;width:45%;overflow-wrap: break-word;"></div><div id="edit_div2" style="float:left;margin-left:10px;width:45%;overflow-wrap: break-word;"></div><div style="float:none;clear:both;"></div></div>');
			$('#edit_div').css('height',$(window).height()*0.65);
			$('#edit_div_title').html($($('#filetable tr').filter(".active").eq(0).find("td")[0]).find("input[type=hidden]")[0].value.trim()+"&nbsp;&nbsp;>&nbsp;&nbsp;"+$($('#filetable tr').filter(".active").eq(1).find("td")[0]).find("input[type=hidden]")[0].value.trim());
			$.ajaxSettings.async = false;
			$.post( "<?php echo php_self;?>", {
				username: "<?php echo $username;?>",
				password: "<?php echo md5($password);?>",
				op: "readfile",
				dir: "<?php echo $dir ?>",
				file:$($('#filetable tr').filter(".active").eq(0).find("td")[0]).find("input[type=hidden]")[0].value.trim()
			},
			function ( data, status ) {
				$('#edit_div1').html(data.string.replace(/\r\n/g,"<br/>"));
			},"json");
			$.post( "<?php echo php_self;?>", {
				username: "<?php echo $username;?>",
				password: "<?php echo md5($password);?>",
				op: "readfile",
				dir: "<?php echo $dir ?>",
				file:$($('#filetable tr').filter(".active").eq(1).find("td")[0]).find("input[type=hidden]")[0].value.trim()
			},
			function ( data, status ) {
				$('#edit_div2').html(data.string.replace(/\r\n/g,"<br/>"));
			},"json");
			var op = eq({ 
				value1: document.getElementById("edit_div1").innerHTML, 
				value2: document.getElementById("edit_div2").innerHTML 
			});
			document.getElementById("edit_div1").innerHTML=op.value1+"\r\n";
			document.getElementById("edit_div2").innerHTML=op.value2+"\r\n";
			$.ajaxSettings.async = true;
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fpreview( fname, op ) {
			<?php writelog("预览文件".$opendfile);?>
			switch ( op ) {
				case "edit":
					$( "#loadModal" ).html('<?php loadModal(); ?>');
					$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "previewedit",
						dir: "<?php echo $dir ?>",
						file:fname
					},
					function ( data, status ) {
						$( '#myModal .modal-body' ).html( "<div style='width:100%;height:400px;overflow:auto;'>"+data+"</div>");
					} );
					$( '#myModal .modal-footer .btn' ).text( "编辑" );
					$( '#myModal .modal-footer .btn' ).attr( "onclick", "fedit('<?php echo $dir ?>','"+fname+"')" );
					$( '#myModal' ).modal( {
						backdrop: false
					} )
					break;
				case "photo":
					$( "#loadModal" ).html('<?php loadModal(); ?>');
					$( '#myModal .modal-body' ).html( "<img src='<?php echo $dir.'/' ?>"+fname+"' class='img-thumbnail' style='width:100%;'>");
					$( '#myModal .modal-title' ).text( "查看图片" );
					$( '#myModal .modal-footer .btn' ).text( "查看原图" );
					$( '#myModal .modal-footer .btn' ).attr( "onclick", "window.open('<?php echo $dir.'/' ?>"+fname+"')" );
					$( '#myModal' ).modal( {
						backdrop: false
					} )
					break;
				case "music":
					$( "#loadModal" ).html('<?php loadModal(); ?>');
					$( '#myModal .close' ).click(function(){
						$( "#loadModal" ).html('');
					});
					$( '#myModal .modal-body' ).html( "<audio src='<?php echo $dir.'/' ?>"+fname+"' style='width:100%' controls='controls' preload='auto'>Your browser does not support the audio element.</audio>");
					$( '#myModal .modal-title' ).text( "播放音乐" );
					$( '#myModal .modal-footer .btn' ).text( "下载" );
					$( '#myModal .modal-footer .btn' ).attr( "onclick", "fdownload('<?php echo $dir ?>',fname)");
					$( '#myModal' ).modal( {
						backdrop: false
					} )
					break;
				case "film":
					$( "#loadModal" ).html('<?php loadModal(); ?>');
					$( '#myModal .close' ).click(function(){
						$( "#loadModal" ).html('');
					});
					$( '#myModal .modal-body' ).html( "<video src='<?php echo $dir.'/' ?>"+fname+"' style='width:100%' controls='controls' preload='auto'>Your browser does not support the video element.</video>");
					$( '#myModal .modal-title' ).text( "播放视频" );
					$( '#myModal .modal-footer .btn' ).text( "下载" );
					$( '#myModal .modal-footer .btn' ).attr( "onclick", "fdownload('<?php echo $dir ?>',fname)");
					$( '#myModal' ).modal( {
						backdrop: false
					} )
					break;
				case "download":
					$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "download",
						dir: "<?php echo $dir ?>",
						file:fname
					},
					function ( data, status ) {
						if ('msSaveOrOpenBlob' in navigator){
							window.navigator.msSaveOrOpenBlob(new Blob([data]), '<?php echo php_self.'/'.$dir.'/' ?>'+fname);
						}else{
						   	var url = window.URL.createObjectURL(new Blob([data], { type: "application/octet-stream" }));
						   	var link = document.createElement('a');
						   	link.style.display = 'none';
							link.href = url;
						   	link.setAttribute('download', fname);
						   	document.body.appendChild(link);
							link.click();
							document.body.removeChild(link);
						}
					} );
					break;
				case "gift":
					$( "#loadModal" ).html('<?php loadModal(); ?>');
					$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "pzip",
						dir: "<?php echo $dir ?>",
						file:fname
					},
					function ( data, status ) {
						$( '#myModal .modal-body' ).html(data);
					} );
					$( '#myModal .modal-footer .btn' ).text( "解压" );
					$( '#myModal .modal-footer .btn' ).attr("onclick","");
					$( '#myModal .modal-footer .btn' ).click(function(){
						unarchive2("<?php echo $dir;?>",fname);
					});
					$( '#myModal' ).modal( {
						backdrop: false
					} )
					break;
				case "eye":
					window.open("https://view.officeapps.live.com/op/view.aspx?src=<?php echo $_SERVER['SERVER_NAME'].'/'.$dir.'/'.$file ?>");
					break;
			}
		}
		function fdownload(dirname, filename){
			$.post( "<?php echo php_self;?>", {
				username: "<?php echo $username;?>",
				password: "<?php echo md5($password);?>",
				op: "download",
				dir: dirname,
				file:filename
			},
			function ( data, status ) {
				if ('msSaveOrOpenBlob' in navigator){
					window.navigator.msSaveOrOpenBlob(new Blob([data]), '<?php echo php_self.'/' ?>'+dirname+'/'+filename);
				}else{
				   	var url = window.URL.createObjectURL(new Blob([data], { type: "application/octet-stream" }));
				   	var link = document.createElement('a');
				   	link.style.display = 'none';
					link.href = url;
				   	link.setAttribute('download', fname);
				   	document.body.appendChild(link);
					link.click();
					document.body.removeChild(link);
				}
			} );
		}
		function fimg(dirname, filename){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .modal-body' ).html( "<img src='"+dirname+"/"+filename+"' class='img-thumbnail' style='width:100%;'>");
			$( '#myModal .modal-title' ).text( "查看图片" );
			$( '#myModal .modal-footer .btn' ).text( "查看原图" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "window.open('"+dirname+"/"+filename+"')" );
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function unarchive(dirname, filename){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$.post( "<?php echo php_self;?>", {
				username: "<?php echo $username;?>",
				password: "<?php echo md5($password);?>",
				op: "pzip",
				dir: dirname,
				file:filename
			},
			function ( data, status ) {
				$( '#myModal .modal-body' ).html(data);
			} );
			$( '#myModal .modal-footer .btn' ).text( "解压" );
			$( '#myModal .modal-footer .btn' ).attr("onclick","");
			$( '#myModal .modal-footer .btn' ).click(function(){
				unarchive2(dirname, filename);
			});
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function unarchive2(dirname, filename){
			$.post( "<?php echo php_self;?>", {
						username: "<?php echo $username;?>",
						password: "<?php echo md5($password);?>",
						op: "unarchive",
						dir: dirname,
						file:filename
					},
					function ( data, status ) {
						$( "#loadModal").html( data );
					} );
		}
		function playmusic(dirname, filename){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
					$( '#myModal .close' ).click(function(){
						$( "#loadModal" ).html('');
					});
					$( '#myModal .modal-body' ).html( "<audio src='"+dirname+"/"+filename+"' style='width:100%' controls='controls' preload='auto'>Your browser does not support the audio element.</audio>");
					$( '#myModal .modal-title' ).text( "播放音乐" );
					$( '#myModal .modal-footer .btn' ).text( "下载" );
					$( '#myModal .modal-footer .btn' ).attr( "onclick", "fdownload('<?php echo $dir ?>',fname)");
					$( '#myModal' ).modal( {
						backdrop: false
					} )
		}
		function playfilm(dirname, filename){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$( '#myModal .close' ).click(function(){
				$( "#loadModal" ).html('');
			});
			$( '#myModal .modal-body' ).html( "<video src='"+dirname+"/"+filename+"' style='width:100%' controls='controls' preload='auto'>Your browser does not support the video element.</video>");
			$( '#myModal .modal-title' ).text( "播放视频" );
			$( '#myModal .modal-footer .btn' ).text( "下载" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "fdownload('<?php echo $dir ?>',fname)");
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fedit(dirname, filename){
			$( "#loadModal" ).html('<?php loadModal(); ?>');
			$.post( "<?php echo php_self;?>", {
				username: "<?php echo $username;?>",
				password: "<?php echo md5($password);?>",
				op: "readfile",
				dir: dirname,
				file:filename
			},
			function ( data, status ) {
				$( '#myModal .modal-body' ).html("<form id=\"fileform\"><input type=\"text\" class=\"form-control\" value=\""+filename+"\" id=\"usr\" disabled><input type=\"text\" name=\"code\" id=\"code\" value=\"\"><label class=\"form-check-label\"><input type=\"checkbox\" class=\"form-check-input\" checked=\"checked\" id=\"autowrap\">自动换行</label><br><div id=\"textareadiv\" style=\"position: relative;\"><textarea style=\"position: absolute;top: 0;left: 0; resize: none;\" class=\"form-control\" rows=\"12\" id=\"comment\" name=\"data\"></textarea><textarea style=\"position: absolute;top: 1px;left: 1px;font-size: 14px;resize: none;overflow: hidden;padding:6px 0;border:none;\" rows=\"12\" id=\"commentline\" wrap=\"off\" readonly disabled></textarea></div></form>");
				$('#code').val(data.code);
				$('#comment').html(data.string);
				fedit2();
			},"json" );
			$( '#myModal .modal-title' ).text( "编辑文件" );
			$( '#myModal .modal-footer .btn' ).text( "保存" );
			$( '#myModal .modal-footer .btn' ).attr( "onclick", "" );
			$( '#myModal .modal-footer .btn' ).click(function(){
				var tmpJson={};
				tmpJson.code=$('#code').val();
				tmpJson.string=$('#comment').val();
				$( "#loadModal" ).html('<?php loadModal(); ?>');
				$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "save",
					dir: dirname,
					file:filename,
					data:JSON.stringify(tmpJson)
				},
				function ( data, status ) {
					$( '#loadModal' ).html(data);
				});
			});
			$('#myModal').on('hidden.bs.modal', function () {
				$('body').css('padding-right',parseInt($('body').css('padding-right').replace('px',''))-17+'px');//修复Modal组件被连续调用之后，右间距无法恢复的问题
			})
			$( '#myModal' ).modal( {
				backdrop: false
			} )
		}
		function fedit2(){
			$( '#autowrap' ).click( function () {
				if ( $( this ).is( ":checked" ) ) {
					$( '#comment' ).attr( "wrap", "virtual" ); // style="overflow:scroll;"
					$( '#commentline' ).attr( "wrap", "virtual" );
				} else {
					$( '#comment' ).attr( "wrap", "off" );
					$( '#commentlline' ).attr( "wrap", "off" );
				}
				$( '#textareadiv' ).css("height",$( '#comment' ).css("height"));//将textarea的父容器高度设置为textarea的高度，不然弹出的对话框会变形
			} );
			$('#comment').bind( 'input propertychange',function(){
				var lines = $('#comment').val().split("\n").length;//计算总行数
				$('#commentline').val('');
				for(var i=1;i<=lines;i++){
					$('#commentline').val($('#commentline').val()+i+"\r\n");//逐行输出行数
				}
				$('#commentline').attr("cols",lines.toString().split("").length);//设置显示行数的文本框宽度自适应
				$('#comment').css("padding-left",$('#commentline').css("width"));//设置显示内容的文本框左边空出位置以显示行数
			});
			if($('#commentline')){
				$( '#commentline' ).css("height",parseInt($( '#comment' ).css("height").replace("px",""))-2+"px");//显示行数的文本框高度为显示内容的文本框高度减去二
				$( '#textareadiv' ).css("height",$( '#comment' ).css("height"));//将textarea的父容器高度设置为textarea的高度，不然弹出的对话框会变形
				var lines = $('#comment').val().split("\n").length;//计算总行数
				for(var i=1;i<=lines;i++){
					$('#commentline').val($('#commentline').val()+i+"\r\n");//逐行输出行数
				}
				$('#commentline').attr("cols",lines.toString().split("").length);//设置显示行数的文本框宽度自适应
				$('#comment').css("padding-left",$('#commentline').css("width"));//设置显示内容的文本框左边空出位置以显示行数
			}
			$('#comment').scroll(function(){
				$('#commentline').scrollTop($(this).scrollTop());
			});
		}
		function office(dirname, filename){
			window.open("https://view.officeapps.live.com/op/view.aspx?src=<?php echo $_SERVER['SERVER_NAME'];?>/"+dirname+"/"+filename);
		}
		function sort(dirname, ordername, sortname){
			$.post( "<?php echo php_self;?>", {
					username: "<?php echo $username;?>",
					password: "<?php echo md5($password);?>",
					op: "showfilelist",
					dir: dirname,
					order: ordername,
					sort: sortname
				},
				function ( data, status ) {
					$( "#main" ).html( data );
				} );
		}
		function eq(op) {
                if(!op){
                    return op;
                }
                if(!op.value1_style){
                    op.value1_style="background-color:#FEC8C8;";
                }
                if(!op.value2_style){
                    op.value2_style="background-color:#FEC8C8;";
                }
                if(!op.eq_min){
                    op.eq_min=3;
                }
                if(!op.eq_index){
                    op.eq_index=5;
                }
                if (!op.value1 || !op.value2) {
                    return op;
                }
                var ps = {
                    v1_i: 0,
                    v1_new_value: "",
                    v2_i: 0,
                    v2_new_value: ""
                };
                while (ps.v1_i < op.value1.length && ps.v2_i < op.value2.length) {
                    if (op.value1[ps.v1_i] == op.value2[ps.v2_i]) {
                        ps.v1_new_value += op.value1[ps.v1_i].replace(/</g,"<").replace(">",">");
                        ps.v2_new_value += op.value2[ps.v2_i].replace(/</g,"<").replace(">",">");
                        ps.v1_i += 1;
                        ps.v2_i += 1;
                        if (ps.v1_i >= op.value1.length) {
                            ps.v2_new_value += "<span style='" + op.value2_style + "'>" + op.value2.substr(ps.v2_i).replace(/</g,"<").replace(">",">") + "</span>";
                            break;
                        }
                        if (ps.v2_i >= op.value2.length) {
                            ps.v1_new_value += "<span style='" + op.value1_style + "'>" + op.value1.substr(ps.v1_i).replace(/</g,"<").replace(">",">") + "</span>";
                            break;
                        }
                    } else {
                        ps.v1_index = ps.v1_i + 1;
                        ps.v1_eq_length = 0;
                        ps.v1_eq_max = 0;
                        ps.v1_start = ps.v1_i + 1;
                        while (ps.v1_index < op.value1.length) {
                            if (op.value1[ps.v1_index] == op.value2[ps.v2_i + ps.v1_eq_length]) {
                                ps.v1_eq_length += 1;
                            } else if (ps.v1_eq_length > 0) {
                                if (ps.v1_eq_max < ps.v1_eq_length) {
                                    ps.v1_eq_max = ps.v1_eq_length;
                                    ps.v1_start = ps.v1_index - ps.v1_eq_length;
                                }
                                ps.v1_eq_length = 0;
                                break;//只寻找最近的
                            }
                            ps.v1_index += 1;
                        }
                        if (ps.v1_eq_max < ps.v1_eq_length) {
                            ps.v1_eq_max = ps.v1_eq_length;
                            ps.v1_start = ps.v1_index - ps.v1_eq_length;
                        }
 
                        ps.v2_index = ps.v2_i + 1;
                        ps.v2_eq_length = 0;
                        ps.v2_eq_max = 0;
                        ps.v2_start = ps.v2_i + 1;
                        while (ps.v2_index < op.value2.length) {
                            if (op.value2[ps.v2_index] == op.value1[ps.v1_i + ps.v2_eq_length]) {
                                ps.v2_eq_length += 1;
                            } else if (ps.v2_eq_length > 0) {
                                if (ps.v2_eq_max < ps.v2_eq_length) {
                                    ps.v2_eq_max = ps.v2_eq_length;
                                    ps.v2_start = ps.v2_index - ps.v2_eq_length;
                                }
                                ps.v1_eq_length = 0;
                                break;//只寻找最近的
                            }
                            ps.v2_index += 1;
                        }
                        if (ps.v2_eq_max < ps.v2_eq_length) {
                            ps.v2_eq_max = ps.v2_eq_length;
                            ps.v2_start = ps.v2_index - ps.v2_eq_length;
                        }
                        if (ps.v1_eq_max < op.eq_min && ps.v1_start - ps.v1_i > op.eq_index) {
                            ps.v1_eq_max = 0;
                        }
                        if (ps.v2_eq_max < op.eq_min && ps.v2_start - ps.v2_i > op.eq_index) {
                            ps.v2_eq_max = 0;
                        }
                        if ((ps.v1_eq_max == 0 && ps.v2_eq_max == 0)) {
                            ps.v1_new_value += "<span style='" + op.value1_style + "'>" + op.value1[ps.v1_i].replace(/</g,"<").replace(">",">") + "</span>";
                            ps.v2_new_value += "<span style='" + op.value2_style + "'>" + op.value2[ps.v2_i].replace(/</g,"<").replace(">",">") + "</span>";
                            ps.v1_i += 1;
                            ps.v2_i += 1;
 
                            if (ps.v1_i >= op.value1.length) {
                                ps.v2_new_value += "<span style='" + op.value2_style + "'>" + op.value2.substr(ps.v2_i).replace(/</g,"<").replace(">",">") + "</span>";
                                break;
                            }
                            if (ps.v2_i >= op.value2.length) {
                                ps.v1_new_value += "<span style='" + op.value1_style + "'>" + op.value1.substr(ps.v1_i).replace(/</g,"<").replace(">",">") + "</span>";
                                break;
                            }
                        } else if (ps.v1_eq_max > ps.v2_eq_max) {
                            ps.v1_new_value += "<span style='" + op.value1_style + "'>" + op.value1.substr(ps.v1_i, ps.v1_start - ps.v1_i).replace(/</g,"<").replace(">",">") + "</span>";
                            ps.v1_i = ps.v1_start;
                        } else {
                            ps.v2_new_value += "<span style='" + op.value2_style + "'>" + op.value2.substr(ps.v2_i, ps.v2_start - ps.v2_i).replace(/</g,"<").replace(">",">") + "</span>";
                            ps.v2_i = ps.v2_start;
                        }
                    }
                }
                op.value1 = ps.v1_new_value;
                op.value2 = ps.v2_new_value;
                return op;
            }
	</script>
	<?php
}
?>
<?php
if ( !isset( $_POST[ 'username' ] ) ||
	 !isset( $_POST[ 'password' ] ) || 
	 ( htmlspecialchars( $_POST[ 'username' ] ) != $username ) || 
	 ( htmlspecialchars( $_POST[ 'password' ] ) != md5($password) ) ) {
	//检测出未登录。或者是直接传送操作数据，没有用户名密码，屏蔽恶意攻击或篡改系统
	maintop();
	?>
	<form class="form-signin" method="post">
		<h2 class="form-signin-heading">登录</h2>
		<label for="username" class="sr-only">用户名</label>
		<input type="text" id="username" class="form-control" name="username" <?php if(isset($_COOKIE[ 'username'])){echo ' value="'.$_COOKIE[ 'username']. '"';}?> placeholder="请输入用户名" required autofocus>
		<label for="password" class="sr-only">密码</label>
		<input type="password" id="password" class="form-control" name="password" <?php if(isset($_COOKIE[ 'password'])){echo ' value="'.$_COOKIE[ 'password']. '"';}?> placeholder="请输入密码" required>
		<div class="checkbox">
			<label>
	            <input type="checkbox" id="remember-me" name="remember-me"<?php if(isset($_COOKIE['username'])||isset($_COOKIE['password'])){echo ' checked="checked"';}?>> 记住我
	          </label>
		
		</div>
		<button class="btn btn-lg btn-primary btn-block" type="submit">登录</button>
	</form>
	<script>
	var str="";
		$('#password').focus(function(){
			str=$(this).val();
		});
		$('#password').blur(function(){
			if(str!=$(this).val()){
				$(this).val(MD5($(this).val()));
			}
		});
		$('#password').keypress(function(event){
			var keycode = (event.keyCode ? event.keyCode : event.which);
			if(keycode == '13'){
				$(this).val(MD5($(this).val()));
			}
		});
		
var MD5 = function (string) {
 function RotateLeft(lValue, iShiftBits) {
  return (lValue<<iShiftBits) | (lValue>>>(32-iShiftBits));
 }
 function AddUnsigned(lX,lY) {
  var lX4,lY4,lX8,lY8,lResult;
  lX8 = (lX & 0x80000000);
  lY8 = (lY & 0x80000000);
  lX4 = (lX & 0x40000000);
  lY4 = (lY & 0x40000000);
  lResult = (lX & 0x3FFFFFFF)+(lY & 0x3FFFFFFF);
  if (lX4 & lY4) {
   return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
  }
  if (lX4 | lY4) {
   if (lResult & 0x40000000) {
    return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
   } else {
    return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
   }
  } else {
   return (lResult ^ lX8 ^ lY8);
  }
  }
  function F(x,y,z) { return (x & y) | ((~x) & z); }
  function G(x,y,z) { return (x & z) | (y & (~z)); }
  function H(x,y,z) { return (x ^ y ^ z); }
 function I(x,y,z) { return (y ^ (x | (~z))); }
 function FF(a,b,c,d,x,s,ac) {
  a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac));
  return AddUnsigned(RotateLeft(a, s), b);
 };
 function GG(a,b,c,d,x,s,ac) {
  a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac));
  return AddUnsigned(RotateLeft(a, s), b);
 };
 function HH(a,b,c,d,x,s,ac) {
  a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac));
  return AddUnsigned(RotateLeft(a, s), b);
 };
 function II(a,b,c,d,x,s,ac) {
  a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac));
  return AddUnsigned(RotateLeft(a, s), b);
 };
 function ConvertToWordArray(string) {
  var lWordCount;
  var lMessageLength = string.length;
  var lNumberOfWords_temp1=lMessageLength + 8;
  var lNumberOfWords_temp2=(lNumberOfWords_temp1-(lNumberOfWords_temp1 % 64))/64;
  var lNumberOfWords = (lNumberOfWords_temp2+1)*16;
  var lWordArray=Array(lNumberOfWords-1);
  var lBytePosition = 0;
  var lByteCount = 0;
  while ( lByteCount < lMessageLength ) {
   lWordCount = (lByteCount-(lByteCount % 4))/4;
   lBytePosition = (lByteCount % 4)*8;
   lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount)<<lBytePosition));
   lByteCount++;
  }
  lWordCount = (lByteCount-(lByteCount % 4))/4;
  lBytePosition = (lByteCount % 4)*8;
  lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80<<lBytePosition);
  lWordArray[lNumberOfWords-2] = lMessageLength<<3;
  lWordArray[lNumberOfWords-1] = lMessageLength>>>29;
  return lWordArray;
 };
 function WordToHex(lValue) {
  var WordToHexValue="",WordToHexValue_temp="",lByte,lCount;
  for (lCount = 0;lCount<=3;lCount++) {
   lByte = (lValue>>>(lCount*8)) & 255;
   WordToHexValue_temp = "0" + lByte.toString(16);
   WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length-2,2);
  }
  return WordToHexValue;
 };
 function Utf8Encode(string) {
  string = string.replace(/\r\n/g,"\n");
  var utftext = "";
  for (var n = 0; n < string.length; n++) {
   var c = string.charCodeAt(n);
   if (c < 128) {
    utftext += String.fromCharCode(c);
   }
   else if((c > 127) && (c < 2048)) {
    utftext += String.fromCharCode((c >> 6) | 192);
    utftext += String.fromCharCode((c & 63) | 128);
   }
   else {
    utftext += String.fromCharCode((c >> 12) | 224);
    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
    utftext += String.fromCharCode((c & 63) | 128);
   }
  }
  return utftext;
 };
 var x=Array();
 var k,AA,BB,CC,DD,a,b,c,d;
 var S11=7, S12=12, S13=17, S14=22;
 var S21=5, S22=9 , S23=14, S24=20;
 var S31=4, S32=11, S33=16, S34=23;
 var S41=6, S42=10, S43=15, S44=21;
 string = Utf8Encode(string);
 x = ConvertToWordArray(string);
 a = 0x67452301; b = 0xEFCDAB89; c = 0x98BADCFE; d = 0x10325476;
 for (k=0;k<x.length;k+=16) {
  AA=a; BB=b; CC=c; DD=d;
  a=FF(a,b,c,d,x[k+0], S11,0xD76AA478);
  d=FF(d,a,b,c,x[k+1], S12,0xE8C7B756);
  c=FF(c,d,a,b,x[k+2], S13,0x242070DB);
  b=FF(b,c,d,a,x[k+3], S14,0xC1BDCEEE);
  a=FF(a,b,c,d,x[k+4], S11,0xF57C0FAF);
  d=FF(d,a,b,c,x[k+5], S12,0x4787C62A);
  c=FF(c,d,a,b,x[k+6], S13,0xA8304613);
  b=FF(b,c,d,a,x[k+7], S14,0xFD469501);
  a=FF(a,b,c,d,x[k+8], S11,0x698098D8);
  d=FF(d,a,b,c,x[k+9], S12,0x8B44F7AF);
  c=FF(c,d,a,b,x[k+10],S13,0xFFFF5BB1);
  b=FF(b,c,d,a,x[k+11],S14,0x895CD7BE);
  a=FF(a,b,c,d,x[k+12],S11,0x6B901122);
  d=FF(d,a,b,c,x[k+13],S12,0xFD987193);
  c=FF(c,d,a,b,x[k+14],S13,0xA679438E);
  b=FF(b,c,d,a,x[k+15],S14,0x49B40821);
  a=GG(a,b,c,d,x[k+1], S21,0xF61E2562);
  d=GG(d,a,b,c,x[k+6], S22,0xC040B340);
  c=GG(c,d,a,b,x[k+11],S23,0x265E5A51);
  b=GG(b,c,d,a,x[k+0], S24,0xE9B6C7AA);
  a=GG(a,b,c,d,x[k+5], S21,0xD62F105D);
  d=GG(d,a,b,c,x[k+10],S22,0x2441453);
  c=GG(c,d,a,b,x[k+15],S23,0xD8A1E681);
  b=GG(b,c,d,a,x[k+4], S24,0xE7D3FBC8);
  a=GG(a,b,c,d,x[k+9], S21,0x21E1CDE6);
  d=GG(d,a,b,c,x[k+14],S22,0xC33707D6);
  c=GG(c,d,a,b,x[k+3], S23,0xF4D50D87);
  b=GG(b,c,d,a,x[k+8], S24,0x455A14ED);
  a=GG(a,b,c,d,x[k+13],S21,0xA9E3E905);
  d=GG(d,a,b,c,x[k+2], S22,0xFCEFA3F8);
  c=GG(c,d,a,b,x[k+7], S23,0x676F02D9);
  b=GG(b,c,d,a,x[k+12],S24,0x8D2A4C8A);
  a=HH(a,b,c,d,x[k+5], S31,0xFFFA3942);
  d=HH(d,a,b,c,x[k+8], S32,0x8771F681);
  c=HH(c,d,a,b,x[k+11],S33,0x6D9D6122);
  b=HH(b,c,d,a,x[k+14],S34,0xFDE5380C);
  a=HH(a,b,c,d,x[k+1], S31,0xA4BEEA44);
  d=HH(d,a,b,c,x[k+4], S32,0x4BDECFA9);
  c=HH(c,d,a,b,x[k+7], S33,0xF6BB4B60);
  b=HH(b,c,d,a,x[k+10],S34,0xBEBFBC70);
  a=HH(a,b,c,d,x[k+13],S31,0x289B7EC6);
  d=HH(d,a,b,c,x[k+0], S32,0xEAA127FA);
  c=HH(c,d,a,b,x[k+3], S33,0xD4EF3085);
  b=HH(b,c,d,a,x[k+6], S34,0x4881D05);
  a=HH(a,b,c,d,x[k+9], S31,0xD9D4D039);
  d=HH(d,a,b,c,x[k+12],S32,0xE6DB99E5);
  c=HH(c,d,a,b,x[k+15],S33,0x1FA27CF8);
  b=HH(b,c,d,a,x[k+2], S34,0xC4AC5665);
  a=II(a,b,c,d,x[k+0], S41,0xF4292244);
  d=II(d,a,b,c,x[k+7], S42,0x432AFF97);
  c=II(c,d,a,b,x[k+14],S43,0xAB9423A7);
  b=II(b,c,d,a,x[k+5], S44,0xFC93A039);
  a=II(a,b,c,d,x[k+12],S41,0x655B59C3);
  d=II(d,a,b,c,x[k+3], S42,0x8F0CCC92);
  c=II(c,d,a,b,x[k+10],S43,0xFFEFF47D);
  b=II(b,c,d,a,x[k+1], S44,0x85845DD1);
  a=II(a,b,c,d,x[k+8], S41,0x6FA87E4F);
  d=II(d,a,b,c,x[k+15],S42,0xFE2CE6E0);
  c=II(c,d,a,b,x[k+6], S43,0xA3014314);
  b=II(b,c,d,a,x[k+13],S44,0x4E0811A1);
  a=II(a,b,c,d,x[k+4], S41,0xF7537E82);
  d=II(d,a,b,c,x[k+11],S42,0xBD3AF235);
  c=II(c,d,a,b,x[k+2], S43,0x2AD7D2BB);
  b=II(b,c,d,a,x[k+9], S44,0xEB86D391);
  a=AddUnsigned(a,AA);
  b=AddUnsigned(b,BB);
  c=AddUnsigned(c,CC);
  d=AddUnsigned(d,DD);
 }
 var temp = WordToHex(a)+WordToHex(b)+WordToHex(c)+WordToHex(d);
 return temp.toLowerCase();
}
	</script>
	<?php
	mainbottom();
	exit;
} else { //已经传进来正确的用户名和密码
	if ( isset( $_POST[ 'op' ] ) && $_POST[ 'op' ] != '' ) {
		//如果接收到op，则表示接收ajax请求，直接返回操作结果
		switch ( $_POST[ 'op' ] ) {
			case 'showfilelist':
				showFileList( $dir );
				loadScript();
				break;
			case 'rename':
				$msg=frename($dir.'/'.$opendfile,$dir.'/'.$extradata);
				break;
			case 'create':
				$msg=fcreate( $dir, $opendfile, $extradata );
				break;
			case 'upload':
				$msg=fupload($dir);
				break;
			case 'remotedownload':
				$dirarr = explode( '/', $opendfile );
				$targetfile = $dirarr[ count( $dirarr ) - 1 ];
				ignore_user_abort(true);
				set_time_limit(24*60*60);
				$ch = curl_init();
				$timeout = 50;
				curl_setopt($ch, CURLOPT_URL, $opendfile);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
				//curl_setopt($ch, CURLOPT_NOPROGRESS, false);
				//curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, "downloadProgress_callback");
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
				$content = curl_exec($ch);
				curl_close($ch);
				writelog("远程下载文件".$opendfile);
				$msg.=fedit($dir.'/'.$targetfile,$content);
				break;
			case 'zip':
				$msg=archivefile($dir.'/'.date("Ymdhis").'.zip', $opendfile);
				break;
			case 'del':
				foreach ( explode( ',', $opendfile ) as $v ) {
					$msg .= fremove( $dir . '/' . $v );
				}
				break;
			case 'copy':
				foreach ( explode( ',', $opendfile ) as $v ) {
					$dirarr = explode( '/', $dir . '/' . $v );
					$targetdir = $dirarr[ count( $dirarr ) - 1 ];
					$msg .= fcopy( $dir . '/' . $v, $extradata . '/', $targetdir );
				}
				break;
			case 'cut':
				foreach ( explode( ',', $opendfile ) as $v ) {
					$dirarr = explode( '/', $dir . '/' . $v );
					$targetdir = $dirarr[ count( $dirarr ) - 1 ];
					$msg .= fcut( $dir . '/' . $v, $extradata . '/', $targetdir );
				}
				break;
			case 'chmod':
				foreach ( explode( ',', $opendfile ) as $v ) {
					$dirarr = explode( '/', $dir . '/' . $v );
					$targetdir = $dirarr[ count( $dirarr ) - 1 ];
					$msg .= fchmod( $dir . '/' . $v, $extradata);
				}
				break;
			case 'previewedit':
				echo str_replace(["\n","\r","\""], [ "", "", "'"], encode(highlight_file( $dir.'/'.$opendfile, true ) ))["string"];
				break;
			case 'download':
				if(!file_exists($dir.'/'.$opendfile)){
					header('HTTP/1.1 404 NOT FOUND');
				}else{
					Header("Content-type: application/octet-stream");
					Header("Accept-Ranges: bytes");
					Header("Accept-Length: ".filesize($dir.'/'.$opendfile));
					Header("Content-Disposition: attachment; filename=".$file_name);
					Header("Content-Transfer-Encoding: binary"); 
					echo file_get_contents($dir.'/'.$opendfile);
				}
				break;
			case 'pzip':
				echo fPreviewArchive($dir . '/' . $opendfile);
				break;
			case 'unarchive':
				$msg = fUnArchive($dir, $opendfile);
				break;
			case 'readfile':
				echo json_encode(freadfile($dir.'/'.$opendfile));
				break;
			case 'save':
				$extradata= json_decode($extradata,true);
				$msg=fedit( $dir . '/' . $opendfile, decode($extradata['string'], $extradata['code']));
				break;
			case 'batchrename':
				$opendfile_arr=explode( ',', $opendfile );
				$extradata_arr=explode( ',', $extradata );
				for($i=0;$i<sizeof($opendfile_arr);$i++){
					$msg.=frename($dir.'/'.$opendfile_arr[$i], $dir.'/'.$extradata_arr[$i]).'<br>';
				}
				break;
		}
		if(isset($msg) && $msg!=''){
			?>
			<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
							<h4 class="modal-title" id="myModalLabel">系统提示</h4>
						</div>
						<div class="modal-body">
							系统提示消息
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-secondary" data-dismiss="modal" aria-hidden="true">确定</button>
						</div>
					</div><!-- /.modal-content -->
				</div><!-- /.modal -->
			</div>
			<script>
			$( '#myModal .modal-body' ).html( "<?php echo $msg; ?>" );
			$( '#myModal .modal-title' ).text( "系统提示" );
			$( '#myModal .close' ).hide();
			<?php if(isset($jsop)&&$jsop!=''){?>
			$('#myModal').on('hide.bs.modal', function () {
				<?php echo $jsop;?>
			})
			<?php }?>
			$('#myModal').on('hidden.bs.modal', function () {
				$( "#loadModal").html("");
  				opendir('<?php echo $dir;?>');
			})
			$( '#myModal' ).modal( {
				backdrop: false,
				show:false
			} )
			$('#myModal').modal('show');
			</script>
			<?php
		}
		exit;
	}
	//如果不是ajax请求，则正常显示界面
	if(isset($_POST['remember-me'])){
		setcookie('username',$_POST[ 'username' ]);
		setcookie('password',md5($_POST[ 'password' ]));
	}else{
		setcookie('username','',time()-3600);
		setcookie('password','',time()-3600);
	}
	$showNavbar = true;
	maintop();
	?>
	<div id="main">
		<?php
		showFileList( $dir );
		loadScript();
		?>
	</div>
	<?php
	mainbottom();
}
?>