<?php

####################################################################################################################################################
#
#	115上传类 
#
#	by   : lianyue
#	mail : admin@lianyue.org
#	url  : www.lianyue.org
#
#	功能 :  上传文件 , 分享文件 , 删除文件 , 提取文件 , 获取文件地址
#	使用要设置到 cache 目录可以写入 需要curl 支持
#	另外本人还有QQ中转站的自动上传 外链分享 但是不准备发出来
#
#	最后面是测试展示
#
####################################################################################################################################################

//** 缓存目录
define('cache_dir', dirname(__FILE__).'/cache/');


//** 缓存文件加密
define("cache_file", '____________'.md5(__FILE__ . PHP_VERSION).'.txt');


##########################################################################
#
#	curl
#
##########################################################################

function get_url($arr = array()){


	if(!isset($arr['url']))
		 return false; 
	$arr['agent'] = isset($arr['agent']) ? $arr['agent'] : $_SERVER['HTTP_USER_AGENT'];
	$arr['ip'] = isset($arr['ip']) ? $arr['ip'] : $_SERVER["REMOTE_ADDR"];
	$arr['header'] = isset($arr['header']) ? $arr['header'] : false;
	$arr['referer'] = isset($arr['referer']) ? $arr['referer'] : '';
	$arr['cookiejar'] = isset($arr['cookiejar']) ? $arr['cookiejar'] : '';
	$arr['cookiefile'] = isset($arr['cookiefile']) ? $arr['cookiefile'] : '';
	$arr['post'] = isset($arr['post']) ? $arr['post'] : '';
	$arr['cookie'] = isset($arr['cookie']) ? $arr['cookie'] : '';
	$arr['time'] = isset($arr['time']) ? $arr['time'] : 8;
	$arr['download'] = isset($arr['download']) ? $arr['download'] : '';
	$arr['location'] = isset($arr['location']) ? $arr['location'] : false;
	$arr['body'] = isset($arr['body']) ? $arr['body'] : true;
	$arr['body'] = $arr['body'] ? false : true;

		
	

	$ch = curl_init($arr['url']);
	if(!$arr['download'])
		curl_setopt($ch, CURLOPT_URL,$arr['url']);
	curl_setopt($ch, CURLOPT_DNS_USE_GLOBAL_CACHE, 3600) ;	
	curl_setopt($ch, CURLOPT_BINARYTRANSFER, true) ;		
	curl_setopt($ch, CURLOPT_ENCODING, 'gzip,deflate');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_HEADER,$arr['header']);
	curl_setopt($ch, CURLOPT_NOBODY,$arr['body']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION,$arr['location']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array("X-FORWARDED-FOR:{$arr['ip']}","CLIENT-IP:{$arr['ip']}"));
	curl_setopt($ch, CURLOPT_USERAGENT,$arr['agent']);
	//保存cookie
	if ($arr['cookiejar']){
		curl_setopt($ch, CURLOPT_COOKIEJAR,cache_dir.$arr['cookiejar'].cache_file);

		//检测是否可写
		if (!is_writable(cache_dir)) {
			die('文件'.cache_dir.'不可写');
		}
		//保存时候检测 index.html 是否存在  防止被目录浏览
		if (!file_exists(cache_dir.'/index.html')){
			if (!is_dir(cache_dir)){
				@mkdir(cache_dir,0777);
			}
			@fwrite(fopen(cache_dir.'/index.html', "w"),'');
		}
	}
	
	//读取cookie
	if ($arr['cookiefile'])
		curl_setopt($ch, CURLOPT_COOKIEFILE,cache_dir.$arr['cookiefile'].cache_file);
		
	//来路
	if ($arr['referer'])
		curl_setopt($ch, CURLOPT_REFERER,$arr['referer']);
		
	//发送post
	if ($arr['post'])
		curl_setopt($ch, CURLOPT_POSTFIELDS,$arr['post']);
	
	//发送cookie
	if($arr['cookie'])
		curl_setopt($ch, CURLOPT_COOKIE,$arr['cookie']);
		
	//多少秒超时
	curl_setopt($ch, CURLOPT_TIMEOUT,$arr['time']);
	
	//连接并且下载保存成临时文件
	if($arr['download']){
		$local = cache_dir."tmp." . time().rand(1000000,10000000000).md5($arr['download']);
		$fp = fopen($local, "w");
		curl_setopt($ch, CURLOPT_FILE, $fp);
	}
	$get_url = curl_exec($ch);
	$info = curl_getinfo($ch);
		
	//关闭连接
	curl_close($ch);

	
	//修改下载文件名称
	if($arr['download']){
		fclose($fp);
		rename($local,$arr['download']);
	//	return $info;
	}
    return $get_url;
}

##########################################################################
#
#	115上传类
#
##########################################################################
class _115 {
	
	//** 115 帐号
	var $account = 'admin@lianyue.org';
	
	//** 115 密码
	var $passwd = '******';
	
	//** 115 存放类型  
	var $aid = '1';
	
	//** 115 存放目录  目录 id  没目录留空    目录 是数字id  不是 目录名
	var $cid = '';
	

	##############################
	#
	#	115 存放类型  代码  aid
	#	1 = 我的文件
	#	2 = 我的文档
	#	3 = 我的相册
	#	4 = 我的音乐
	#	9 = 我的视频
	#
	##############################

	
	//** 上传文件
	function upload($file){

		if(!file_exists($file)){
			return array( 'error'=>'文件不存在' );
		}
		$file = strtr($file,"\\","/");
		ignore_user_abort(true);
		set_time_limit(0);

		$arr['time'] = 3600;
		$arr['cookiefile'] = '115';
		$arr['url'] = 'http://vipup.u.115.com/upload';
		$arr['agent'] = 'Shockwave Flash';
		$arr['post']['Filename'] = basename($file);
		$arr['post']['aid'] = $this->aid;
		$arr['post']['cookie'] = $this->cookie();
		$arr['post']['Filedata'] = "@{$file}";
		if($this->cid)
			$arr['post']['cid'] = $this->cid;
		
		$content = get_url($arr);
		$content = json_decode($content,true);
		if(isset($content['data']['pick_code'])){
			$return['code'] =  $content['data']['pick_code'];
			$return['id'] =  $content['data']['file_id'];
			$return['size'] =  $content['data']['file_size'];
			$this->share($return['id']);
			return $return;
		}else{
			return array( 'error'=>'失败'.$content['code'] );
		}
	}
	
	
	
	
	//分享 
	function share($id) {
		if(is_array($id)){
			$tid = '';
			foreach ( $id as $value)
				$tid.= "{$value},";
			$tid = rtrim($tid,',');
		}else{
			$tid = $id;
		}
	
		$arr['url'] = 'http://115.com/?ct=file&ac=share';
		$arr['cookiefile'] = '115';
		$arr['post']['tid'] = $tid;
		$arr['post']['is_share'] = 1;
		get_url($arr);
	}
	
	
	
	//上传需要的cookie
	function cookie() {
		$file = cache_dir.'115'.cache_file;
		if($this->is_login()){
			$fh = @fopen( $file,"r");
			$cookie = @fread($fh,filesize($file));
			@fclose($fh);
			preg_match ('/OOFA	(.+)/',$cookie,$cookie);
		}else{
			$cookie[1] = $this->login();
		}
		$cookie = urldecode($cookie[1]);
		return $cookie;
	}
	
	
	//检测是否登录 is_login
	function is_login() {
		$arr['cookiefile'] = '115';
		$arr['url'] = 'http://web.api.115.com/lists?aid=32&limit=1';
		if(strstr(get_url($arr),'\u8bf7\u5148\u767b\u5f55'))
			return false;
		return true;
	}
	
	
	//登录115  并且返回需要的cookie
	function login() {
		$arr['cookiejar'] = '115';
		$arr['referer'] = 'http://115.com/';
		$arr['url'] = 'http://passport.115.com/?ac=login';
		$arr['post']['login[account]'] = $this->account;
		$arr['post']['login[passwd]'] = $this->passwd;
		$arr['post']['back'] = 'http://115.com/?ac=login';
		$arr['post']['login[time]'] = 'on';
		$arr['header'] = true;
		$cookie = get_url($arr);
		preg_match ('/OOFA=(.+);/isU',$cookie,$cookie);
		if(!isset($cookie[1]))
			die('错误:你提供的115帐号密码可能不正确');
		return $cookie[1];
	}
	
	
	
	//提取文件地址
	function code($code) {
		$arr['cookiefile'] = '115';
		$arr['referer'] = 'http://115.com/';
		$arr['url'] = 'http://115.com/?ct=pickcode&ac=download&pickcode='.$code;
		$content = get_url($arr);
		if(!$content){
			$this->login();
			$content = get_url($arr);
		}
		if(!$content)
			return array( 'error'=>'503' );
		
		preg_match('/<div class="bottom">(.+)<\/span>/isU', $content, $content);
		if(!isset($content[0]))
			return array( 'error'=>'404' );
			
		preg_match_all('/<a href="http(.+)<\/a>/isU',$content[1], $content);
		if(!isset($content[0][0]))
			return array( 'error'=>'404' );
			
		foreach ( $content[0] as $value){
			preg_match('/<a href\="(.+)"/isU', $value, $url);
			preg_match('/">(.+)<\/a>/isU', $value, $isp);
			if( isset($url[1]) && isset($isp[1]) )
				$return[] = array( 'url' => $url[1], 'isp'=> $isp[1]); 
			
		}
		if(!isset($return[0]['url']))
			return array( 'error'=>'404' );
			
		return $return;

	}
	
	
	//删除文件
	function delete($id) {
		if(is_array($id)){
			$tid = '';
			foreach ( $id as $value){
				$tid.= "{$value},";
			}
			$tid = rtrim($tid,',');
		}else{
			$tid = $id;
		}
		$arr['cookiefile'] = '115';
		$arr['referer'] = 'http://115.com/';
		$arr['url'] = 'http://115.com/?ct=file&ac=delete';
		$arr['post'] = http_build_query(array('tid'=>$tid , 'aid'=>1,'pid'=>0));
		$content = get_url($arr);
		$content = json_decode($content,true);
		if(!isset($content['data']['f'])){
			$this->login();
			$content = get_url($arr);
		}
		if(!isset($content['data']['f']))
			return 0;
		
		return $content['data']['f'];
	}
}


$_115 = new _115();

//** 上传文件
$content = $_115->upload('E:/www/lianyue.zip');

//** 判断有错误没 
if(isset($content['error'])){
	//有错误
	echo $content['error'];
}else{
	//没错误
	
	//**分享文件
	 $_115->share($content['id']);
	 
	 //显示上传信息
	 echo "文件id  :{$content['id']}<br/>\r\n";
	 echo "文件大小:{$content['size']}<br/>\r\n";
	 echo "提取码  :{$content['code']}<br/>\r\n";
	 echo "下载地址:http://115.com/file/{$content['code']}<br/>\r\n";
	
}
