<?php
 namespace App\Http\Controllers\Admin; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Admin\Cms\CategoryCms; use TechSoft\Laravel\Admin\Cms\Field\FieldEmpty; use TechSoft\Laravel\Admin\Cms\Field\FieldImage; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminPowerUtil; use TechSoft\Laravel\Admin\Util\AdminUtil; class ForumCategoryController extends AdminCheckController { private $cmsConfigData = [ 'model' => 'forum_category', 'pageTitle' => '帖子分类', 'group' => 'data', 'maxLevel' => 2, 'canAdd' => true, 'canEdit' => true, 'canDelete' => true, 'canView' => true, 'canSort' => true, 'fields' => [ 'title' => ['type' => FieldText::class, 'title' => '名称', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], 'cover' => ['type' => FieldImage::class, 'title' => '图标', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], 'desc' => ['type' => FieldText::class, 'title' => '描述', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], '_tag' => ['type' => FieldEmpty::class, 'title' => '标签', 'list' => true,], '_admin' => ['type' => FieldEmpty::class, 'title' => '分类管理员', 'list' => true,], ] ]; public function dataProcessViewField($key, &$record) { switch ($key) { case '_admin': $memberUserNames = []; $memberUserIds = ModelUtil::values('forum_category_admin', 'memberUserId', ['categoryId' => $record['id']]); if (!empty($memberUserIds)) { $memberUsers = ModelUtil::allIn('member_user', 'id', $memberUserIds); foreach ($memberUsers as $memberUser) { $memberUserNames[] = '<span class="uk-badge">' . htmlspecialchars($memberUser['username']) . '</span>'; } } $edit = '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\ForumCategoryController@admin', ['id' => $record['id']]) . '">修改</a>'; return join(' ', $memberUserNames) . ' ' . $edit; case '_tag': $tags = ModelUtil::all('forum_category_tag', ['categoryId' => $record['id']], ['*'], ['sort', 'asc']); $tagNames = []; if (!empty($tags)) { foreach ($tags as $tag) { $tagNames[] = '<span class="uk-badge uk-badge-success">' . htmlspecialchars($tag['title']) . '</span>'; } } $edit = '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\ForumCategoryController@tag', ['id' => $record['id']]) . '">修改</a>'; return join(' ', $tagNames) . ' ' . $edit; } } public function dataList(CategoryCms $categoryCms) { return $categoryCms->executeList($this, $this->cmsConfigData); } public function dataAdd(CategoryCms $categoryCms) { return $categoryCms->executeAdd($this, $this->cmsConfigData); } public function dataEdit(CategoryCms $categoryCms) { return $categoryCms->executeEdit($this, $this->cmsConfigData); } public function dataDelete(CategoryCms $categoryCms) { return $categoryCms->executeDelete($this, $this->cmsConfigData); } public function dataView(CategoryCms $categoryCms) { return $categoryCms->executeView($this, $this->cmsConfigData); } public function dataSort(CategoryCms $categoryCms) { return $categoryCms->executeSort($this, $this->cmsConfigData); } public function admin($id) { if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return AdminPowerUtil::demoResponse(); } $memberUserIds = Input::get('memberUserId', []); if (empty($memberUserIds)) { $memberUserIds = []; } $memberUserIds = array_unique($memberUserIds); ModelUtil::delete('forum_category_admin', ['categoryId' => $id]); foreach ($memberUserIds as $memberUserId) { ModelUtil::insert('forum_category_admin', ['categoryId' => $id, 'memberUserId' => $memberUserId]); } return Response::send(0, null, null, '[root-reload]'); } $memberUserIds = ModelUtil::values('forum_category_admin', 'memberUserId', ['categoryId' => $id]); $memberUsers = ModelUtil::allIn('member_user', 'id', $memberUserIds); $viewData = []; $viewData['memberUsers'] = $memberUsers; return view('admin.forum.categoryAdmin', $viewData); } public function adminSearch() { $keyword = Input::get('keyword'); $data = []; $data['list'] = []; if ($keyword) { $option = []; $option['whereOperate'] = ['username', 'like', '%' . $keyword . '%']; $paginateData = ModelUtil::paginate('member_user', 1, 10, $option); foreach ($paginateData['records'] as $record) { $data['list'][] = [ 'id' => $record['id'], 'username' => htmlspecialchars($record['username']), ]; } } return Response::json(0, null, $data); } public function tag($categoryId) { $tags = ModelUtil::all('forum_category_tag', ['categoryId' => $categoryId], ['*'], ['sort', 'asc']); if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return AdminPowerUtil::demoResponse(); } $input = InputPackage::buildFromInput(); $tagIds = $input->getArray('tagId'); $tagTitles = $input->getArray('tagTitle'); $tagSort = $input->getArray('tagSort'); foreach ($tags as $tag) { if (!in_array($tag['id'], $tagIds)) { ModelUtil::delete('forum_category_tag', ['id' => $tag['id']]); } } foreach ($tagTitles as $index => $tagTitle) { $title = trim($tagTitle); if (empty($title)) { continue; } $id = intval($tagIds[$index]); $sort = intval($tagSort[$index]); if ($id) { ModelUtil::update('forum_category_tag', ['id' => $id,], [ 'sort' => $sort, 'title' => $title, ]); } else { ModelUtil::insert('forum_category_tag', [ 'categoryId' => $categoryId, 'sort' => $sort, 'title' => $title, ]); } } return Response::send(0, null, null, '[root-reload]'); } $tags = ModelUtil::all('forum_category_tag', ['categoryId' => $categoryId], ['*'], ['sort', 'asc']); return view('admin.forum.tag', compact('tags')); } }