<?php
 namespace App\Http\Controllers\Main; use App\Constant\AppConstant; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Util\TreeUtil; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Forum\ForumUtil; use TechSoft\Laravel\Forum\Types\ThreadStatus; class ForumController extends BaseController { public function index($categoryId, $page = 1) { $category = ForumUtil::loadCategory($categoryId); $childCategories = ForumUtil::getChildCategories($category['id']); $type = Input::get('type'); $tagId = Input::get('tagId'); $order = []; $order[] = ['isTop', 'desc']; $order[] = ['id', 'desc']; switch ($type) { case 'digest': $order [] = ['isDigest', 'desc']; $type = 'digest'; break; default: $type = null; break; } $where = []; if ($tagId) { $where['tagId'] = $tagId; } $where['status'] = ThreadStatus::VERIFY_PASS; $option = []; $option['where'] = $where; $option['order'] = $order; $paginateData = ForumUtil::paginateThreadsByCategory($categoryId, $page, AppConstant::FORUM_THREAD_PAGE_SIZE, $option); $threads = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], AppConstant::FORUM_THREAD_PAGE_SIZE, $page, '/forum/' . $category['id'] . '/{page}' . ($type ? '?type=' . $type : '')); ModelUtil::join($threads, 'memberUserId', '_memberUser', 'member_user', 'id'); ModelUtil::join($threads, 'tagId', '_tag', 'forum_category_tag', 'id'); $categories = ForumUtil::getCategories(); $categoryChain = TreeUtil::chain($categories, $categoryId); $latestThreads = ForumUtil::listLatestThreads(8); $categoryTags = ForumUtil::getCategoryTagMap($category['id']); $viewData = []; $viewData['tagId'] = $tagId; $viewData['type'] = $type; $viewData['category'] = $category; $viewData['childCategories'] = $childCategories; $viewData['threads'] = $threads; $viewData['pageHtml'] = $pageHtml; $viewData['categoryChain'] = $categoryChain; $viewData['latestThreads'] = $latestThreads; $viewData['categoryTags'] = $categoryTags; return $this->_view('forum.index', $viewData); } }