<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Forum\ForumUtil; use TechSoft\Laravel\Forum\Types\PostStatus; use TechSoft\Laravel\Forum\Types\ThreadStatus; use TechSoft\Laravel\Html\HtmlConverter; use TechSoft\Laravel\Member\MemberUtil; class MemberController extends BaseController { private function getMemberUserInfo($memberUserId) { $memberUser = MemberUtil::get($memberUserId); if (empty($memberUser)) { return null; } $memberUser['_threadCount'] = ForumUtil::getMemberThreadCount($memberUser['id']); $memberUser['_postCount'] = ForumUtil::getMemberPostCount($memberUser['id']); return $memberUser; } public function index() { if (!$this->memberUserId()) { return Response::send(0, null, null, '/login'); } return Response::send(0, null, null, '/member/' . $this->memberUserId()); } public function one($memberUserId) { $memberUser = $this->getMemberUserInfo($memberUserId); if (empty($memberUser)) { return redirect('/'); } $option = []; $option['order'] = ['id', 'desc']; $option['where'] = ['status' => ThreadStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateMemberThreads($memberUser['id'], 1, 10, $option); $latestThreads = $paginateData['records']; $option['where'] = ['status' => PostStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateMemberPosts($memberUser['id'], 1, 10, $option); $latestPosts = $paginateData['records']; foreach ($latestPosts as &$latestPost) { if (empty($latestPost['contentHtml'])) { if (empty($latestPost['contentType'])) { $latestPost['contentType'] = HtmlType::RICH_TEXT; } $latestPost['contentHtml'] = HtmlConverter::convertToHtml($latestPost['contentType'], $latestPost['content'], AtMemberInterceptor::class); ForumUtil::updatePost($latestPost['id'], $latestPost); } } ModelUtil::join($latestPosts, 'threadId', '_thread', 'forum_thread', 'id'); return $this->_view('member.one', compact('memberUser', 'latestThreads', 'latestPosts')); } public function threads($memberUserId) { $memberUser = $this->getMemberUserInfo($memberUserId); if (empty($memberUser)) { return redirect('/'); } $page = Input::get('page', 1); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = ['status' => ThreadStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateThreadsByMemberUserId($memberUser['id'], $page, 10, $option); $threads = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], 10, $page, '/member/' . $memberUser['id'] . '/threads?page={page}'); return $this->_view('member.threads', compact('memberUser', 'threads', 'pageHtml')); } public function favorites($memberUserId) { $memberUser = $this->getMemberUserInfo($memberUserId); if (empty($memberUser)) { return redirect('/'); } $page = Input::get('page', 1); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = ['status' => ThreadStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateMemberFavoriteThreads($memberUser['id'], $page, 10, $option); $threads = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], 10, $page, '/member/' . $memberUser['id'] . '/favorites?page={page}'); return $this->_view('member.favorites', compact('memberUser', 'threads', 'pageHtml')); } public function ups($memberUserId) { $memberUser = $this->getMemberUserInfo($memberUserId); if (empty($memberUser)) { return redirect('/'); } $page = Input::get('page', 1); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = ['status' => ThreadStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateMemberUpThreads($memberUser['id'], $page, 10, $option); $threads = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], 10, $page, '/member/' . $memberUser['id'] . '/ups?page={page}'); return $this->_view('member.ups', compact('memberUser', 'threads', 'pageHtml')); } public function posts($memberUserId) { $memberUser = $this->getMemberUserInfo($memberUserId); if (empty($memberUser)) { return redirect('/'); } $page = Input::get('page', 1); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = ['status' => PostStatus::VERIFY_PASS]; $paginateData = ForumUtil::paginateMemberPosts($memberUser['id'], 1, 10, $option); $posts = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], 10, $page, '/member/' . $memberUser['id'] . '/posts?page={page}'); foreach ($posts as &$post) { if (empty($post['contentHtml'])) { if (empty($post['contentType'])) { $post['contentType'] = HtmlType::RICH_TEXT; } $post['contentHtml'] = HtmlConverter::convertToHtml($post['contentType'], $post['content'], AtMemberInterceptor::class); ForumUtil::updatePost($post['id'], $post); } } ModelUtil::join($posts, 'threadId', '_thread', 'forum_thread', 'id'); return $this->_view('member.posts', compact('memberUser', 'posts', 'pageHtml')); } }