<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ModifyForumVerify extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('forum_thread', function (Blueprint $table) {
            /** @see \TechSoft\Laravel\Forum\Types\ThreadStatus */
            $table->tinyInteger('status')->nullable()->comment('');
        });
        Schema::table('forum_post', function (Blueprint $table) {
            /** @see \TechSoft\Laravel\Forum\Types\PostStatus */
            $table->tinyInteger('status')->nullable()->comment('');
        });
        \TechOnline\Laravel\Dao\ModelUtil::model('forum_thread')->where('id', '>', 0)->update(['status' => \TechSoft\Laravel\Forum\Types\ThreadStatus::VERIFY_PASS]);
        \TechOnline\Laravel\Dao\ModelUtil::model('forum_post')->where('id', '>', 0)->update(['status' => \TechSoft\Laravel\Forum\Types\PostStatus::VERIFY_PASS]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
