@extends('admin::frameDialog')

@section('pageTitle','标签管理')

@section('headAppend')
    @parent
    <style type="text/css">

    </style>
@endsection

@section('dialogBody')

    <div class="admin-form">
        <form action="?" method="post" data-ajax-form class="uk-form">
            <table class="uk-table">
                <thead>
                    <tr>
                        <th class="uk-text-left">名称</th>
                        <th class="uk-text-left">排序</th>
                        <th class="uk-text-left" width="10">&nbsp;</th>
                    </tr>
                </thead>
                <tbody data-item-list>
                @foreach($tags as $tag)
                    <tr class="line">
                        <td>
                            <input type="hidden" name="tagId[]" value="{{$tag['id']}}">
                            <input type="text" name="tagTitle[]" class="uk-width-1-1" value="{{$tag['title']}}" />
                        </td>
                        <td>
                            <input type="text" name="tagSort[]" class="uk-width-1-1" value="{{$tag['sort']}}" />
                        </td>
                        <td>
                            <a href="javascript:;" data-item-delete><i class="uk-icon-remove"></i></a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
                <tbody data-item-tpl style="display:none;">
                    <tr class="line">
                        <td>
                            <input type="hidden" name="tagId[]" value="0">
                            <input type="text" name="tagTitle[]" class="uk-width-1-1" value="" />
                        </td>
                        <td>
                            <input type="text" name="tagSort[]" class="uk-width-1-1" value="999" />
                        </td>
                        <td>
                            <a href="javascript:;" data-item-delete><i class="uk-icon-remove"></i></a>
                        </td>
                    </tr>
                </tbody>
                <tbody>
                    <tr>
                        <td colspan="3" style="padding:10px;text-align:center;">
                            <a href="javascript:;" data-item-add><i class="uk-icon-plus"></i></a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </form>
    </div>

    <script>
        $(function () {
            var $list = $('[data-item-list]');
            var tpl = $('[data-item-tpl]').html();
            $('[data-item-add]').on('click',function () {
                $list.append(tpl);
                return false;
            });
            $(document).on('click','[data-item-delete]',function () {
                $(this).closest('tr').remove();
                return false;
            });
        });
    </script>

@endsection
