@extends('theme.default.m.frame')

@section('pageTitle',htmlspecialchars($category['title']))
@section('pageTitleMain',htmlspecialchars($category['title']))
@section('headerTitle',htmlspecialchars($category['title']))

@section('bodyContent')

    <div class="pb pb-thread-list">
        <div class="head">
            <div class="more">
                <a class="btn primary" href="/thread/edit?categoryId={{$category['id']}}"><span class="uk-icon-plus"></span> 我要发帖</a>
            </div>
            <div class="tab">
                <a href="/forum/{{$category['id']}}" class="btn @if(!$type) cur @endif" >全部主题</a>
                <a href="/forum/{{$category['id']}}?type=digest" class="btn @if('digest'==$type) cur @endif" >精华</a>
            </div>
        </div>
        @if(!empty($categoryTags))
            <div class="thread-tag">
                <a href="?{{\TechOnline\Laravel\Http\Request::mergeQueries(['tagId'=>null])}}" @if(empty($tagId)) class="cur" @endif>全部</a>
                @foreach($categoryTags as $categoryTagId=>$categoryTagTitle)
                    <a href="?{{\TechOnline\Laravel\Http\Request::mergeQueries(['tagId'=>$categoryTagId])}}" @if($tagId==$categoryTagId) class="cur" @endif>{{$categoryTagTitle}}</a>
                @endforeach
            </div>
        @endif
        <div class="body">
            @if(!empty($threads))
                @foreach($threads as $thread)
                    <div class="item">
                        <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                            @if(empty($thread['_memberUser']['avatar']))
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                            @else
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                            @endif
                        </a>
                        <a href="/thread/{{$thread['id']}}" class="main">
                            <div class="title">
                                @if($thread['isTop'])
                                    <span class="uk-text-danger">[置顶]</span>
                                @endif
                                @if($thread['isDigest'])
                                    <span class="uk-text-warning">[精华]</span>
                                @endif
                                {{$thread['title']}}
                            </div>
                            <div class="attr">
                                <div class="right">
                                    <i class="uk-icon-eye"></i> {{$thread['postCount']}}/{{$thread['clickCount']}}
                                </div>
                                @if(!empty($thread['_tag']))
                                    <span class="tag">{{$thread['_tag']['title']}}</span>
                                @endif
                                <span>{{$thread['_memberUser']['username'] or '[已删除用户]'}}</span>
                                发布
                                <time datetime="{{$thread['created_at']}}"></time>
                                @if($thread['lastReplyTime'])
                                    ·
                                    更新 <time datetime="{{$thread['lastReplyTime']}}"></time>
                                @endif
                            </div>
                        </a>
                    </div>
                @endforeach
            @else
                <div class="empty">
                    暂无记录~
                </div>
            @endif

        </div>
        <div class="body">
            <div class="page-container">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>

@endsection