@extends('theme.default.m.frame')

@section('pageTitle',\TechSoft\Laravel\Config\ConfigUtil::get('siteName'))
@section('pageTitleMain',\TechSoft\Laravel\Config\ConfigUtil::get('siteName'))

@section('bodyScript')
    @parent
    <script>
        var swiper = new Swiper('.pb-banner .swiper-container', {
            pagination: '.swiper-pagination',
            paginationClickable: '.swiper-pagination',
            nextButton: '.swiper-button-next',
            prevButton: '.swiper-button-prev',
            loop: true
        });
    </script>
@endsection

@section('bodyContent')

    <div class="pb-home-search">
        <form action="/search" method="get">
            <div class="mui-input-row mui-search">
                <input type="search" name="keywords" class="mui-input-clear" placeholder="搜索 帖子">
            </div>
        </form>
    </div>

    <div class="pb pb-banner">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                @if(empty($banners))
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                @else
                    @foreach($banners as $banner)
                        <a class="swiper-slide"
                           style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($banner['image'])}});"
                           @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                    @endforeach
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination-white"></div>
        </div>
    </div>

    @foreach(\TechSoft\Laravel\Forum\ForumUtil::getTreeCategories() as $category1)
        <div class="pb pb-forum">
            <div class="head">
                {{$category1['title']}}
            </div>
            <div class="body">
                <div class="uk-grid">
                    @foreach($category1['_child'] as $category2)
                        <div class="uk-width-1-1">
                            <div class="item">
                                <a class="icon" href="/forum/{{$category2['id']}}">
                                    @if($category2['cover'])
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($category2['cover'])}}"/>
                                    @else
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/none.png')}}"/>
                                    @endif
                                </a>
                                <a href="/forum/{{$category2['id']}}" class="title">{{$category2['title']}}</a>
                                <div class="desc">
                                    {{$category2['desc']}}
                                </div>
                                <div class="stat">
                                    主题: {{$category2['threadCount'] or 0}}, 帖数: {{$category2['postCount'] or 0}}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endforeach

    <div class="pb pb-thread-list">
        <div class="head" style="color:red;">最热帖子</div>
        <div class="body">
            @foreach($hottestThreads as $thread)
                <div class="item">
                    <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                        @if(empty($thread['_memberUser']['avatar']))
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                        @else
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                        @endif
                    </a>
                    <a href="/thread/{{$thread['id']}}" class="main">
                        <div class="title">
                            @if($thread['isTop'])
                                <span class="uk-text-danger">[置顶]</span>
                            @endif
                            @if($thread['isDigest'])
                                <span class="uk-text-warning">[精华]</span>
                            @endif
                            {{$thread['title']}}
                        </div>
                        <div class="attr">
                            <div class="right">
                                <i class="uk-icon-eye"></i> {{$thread['postCount']}}/{{$thread['clickCount']}}
                            </div>
                            <span>{{$thread['_memberUser']['username'] or '[已删除用户]'}}</span>
                            发布于
                            <time datetime="{{$thread['created_at']}}"></time>
                            @if($thread['lastReplyTime'])
                                ·
                                最后更新于 <time datetime="{{$thread['lastReplyTime']}}"></time>
                            @endif
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
    </div>

    <div class="pb pb-thread-list">
        <div class="head">最新帖子</div>
        <div class="body">
            @foreach($latestThreads as $thread)
                <div class="item">
                    <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                        @if(empty($thread['_memberUser']['avatar']))
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                        @else
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                        @endif
                    </a>
                    <a href="/thread/{{$thread['id']}}" class="main">
                        <div class="title">
                            @if($thread['isTop'])
                                <span class="uk-text-danger">[置顶]</span>
                            @endif
                            @if($thread['isDigest'])
                                <span class="uk-text-warning">[精华]</span>
                            @endif
                            {{$thread['title']}}
                        </div>
                        <div class="attr">
                            <div class="right">
                                <i class="uk-icon-eye"></i> {{$thread['postCount']}}/{{$thread['clickCount']}}
                            </div>
                            <span>{{$thread['_memberUser']['username'] or '[已删除用户]'}}</span>
                            发布于
                            <time datetime="{{$thread['created_at']}}"></time>
                            @if($thread['lastReplyTime'])
                                ·
                                最后更新于 <time datetime="{{$thread['lastReplyTime']}}"></time>
                            @endif
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
    </div>

    <div class="pb pb-partner">
        <div class="head">
            合作伙伴
        </div>
        <div class="body">
            <div class="row">
                @foreach($partners as $partner)
                    <div class="col-4">
                        <a class="item" href="{{$partner['link']}}" target="_blank" title="{{$partner['title']}}">
                            <div class="cover" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($partner['logo'])}})"></div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

@endsection






