@extends('theme.default.m.frame')

@section('pageTitleMain',htmlspecialchars($memberUser['username']).'的个人中心')

@section('bodyContent')

    <div class="pb">
        <div class="body">
            <div class="pb-member-info">
                <div class="uk-grid">
                    <div class="uk-width-1-3">
                        @if(!empty($_memberUser['id']) && $memberUser['id']==$_memberUser['id'])
                            <a href="/member/profile_avatar" class="avatar" title="点击修改头像">
                        @else
                            <a href="javascript:;" class="avatar">
                        @endif
                            @if(empty($memberUser['avatar']))
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                            @else
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($memberUser['avatar'])}}">
                            @endif
                        </a>
                    </div>
                    <div class="uk-width-2-3">
                        <a class="profile" href="/member/profile"><i class="uk-icon-cog"></i> 修改资料</a>
                        <div class="username">{{$memberUser['username'] or ''}}</div>
                        <div class="info">{{$memberUser['realname'] or ''}}</div>
                        <div class="info">第 {{$memberUser['id']}} 位会员</div>
                        <div class="info">注册于 <time datetime="{{$memberUser['created_at']}}"></time></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="pb">
        <div class="body">
            <div class="pb-member-stat">
                <div class="uk-grid">
                    <div class="uk-width-1-2">
                        <a class="count">{{$memberUser['_threadCount'] or 0}}</a>
                        <div class="title">帖子</div>
                    </div>
                    <div class="uk-width-1-2">
                        <a class="count">{{$memberUser['_postCount'] or 0}}</a>
                        <div class="title">评论</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="pb">
        <div class="body">
            <div class="pb-member-menu-list">
                <a href="/member/{{$memberUser['id']}}/threads" @if($base_request_path=='/member/'.$memberUser['id'].'/threads') class="cur" @endif><i class="uk-icon-list"></i> Ta 发布的帖子</a>
                <a href="/member/{{$memberUser['id']}}/posts" @if($base_request_path=='/member/'.$memberUser['id'].'/posts') class="cur" @endif><i class="uk-icon-comment-o"></i> Ta 发表的评论</a>
                <a href="/member/{{$memberUser['id']}}/ups" @if($base_request_path=='/member/'.$memberUser['id'].'/ups') class="cur" @endif><i class="uk-icon-thumbs-o-up"></i> Ta 赞过的帖子</a>
                <a href="/member/{{$memberUser['id']}}/favorites" @if($base_request_path=='/member/'.$memberUser['id'].'/favorites') class="cur" @endif><i class="uk-icon-heart-o"></i> Ta 收藏的帖子</a>
            </div>
        </div>
    </div>

    <div class="pb">
        <div class="head">发布的帖子</div>
        <div class="body">

            <div class="pb-member-thread-list">

                @if(empty($latestThreads))
                    <div class="empty">
                        没有记录~
                    </div>
                @else
                    @foreach($latestThreads as $latestThread)
                        <div class="item">
                            <a href="/thread/{{$latestThread['id']}}" target="_blank">{{$latestThread['title']}}</a>
                            <br>
                            {{$latestThread['clickCount'] or 0}}阅读
                            ⋅
                            {{$latestThread['upCount'] or 0}}点赞
                            ⋅
                            {{$latestThread['postCount'] or 0}}回复
                            ⋅
                            <span class="time"><time datetime="{{$latestThread['created_at']}}"></time></span>
                        </div>
                    @endforeach
                @endif

            </div>

        </div>
    </div>
    <div class="pb">
        <div class="head">最新评论</div>
        <div class="body">

            <div class="pb-member-comment-list">

                @if(empty($latestPosts))
                    <div class="empty">
                        没有记录~
                    </div>
                @else
                    @foreach($latestPosts as $latestPost)
                        <div class="item">
                            <div class="thread">
                                <a target="_blank" href="/thread/{{$latestPost['_thread']['id']}}">{{$latestPost['_thread']['title']}}</a>
                                &nbsp;&nbsp;
                                <span class="time"><time datetime="{{$latestPost['created_at']}}"></time></span>
                            </div>
                            <div class="comment">
                                {!! $latestPost['content'] !!}
                            </div>
                        </div>
                    @endforeach
                @endif

            </div>

        </div>
    </div>


@endsection