@extends('theme.default.m.frame')

@section('pageTitle',htmlspecialchars($memberUser['username']).'发表的评论')
@section('headerTitle',htmlspecialchars($memberUser['username']).'发表的评论')

@section('bodyContent')

    <div class="pb">
        <div class="body">
            <div class="pb-member-comment-list">

                @if(empty($posts))
                    <div class="empty">
                        没有记录~
                    </div>
                @else
                    @foreach($posts as $post)
                        <div class="item">
                            <div class="thread">
                                @if(empty($post['_thread']))
                                    <a href="javascript:;">[帖子已删除]</a>
                                @else
                                    <a target="_blank" href="/thread/{{$post['_thread']['id']}}">{{$post['_thread']['title']}}</a>
                                @endif
                                &nbsp;&nbsp;
                                <span class="time"><time datetime="{{$post['created_at']}}"></time></span>
                            </div>
                            <div class="comment">
                                {!! $post['content'] !!}
                            </div>
                        </div>
                    @endforeach
                @endif

            </div>

            <div class="page-container">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>


@endsection