@extends('theme.default.m.frame')

@section('pageTitle','搜索：'.htmlspecialchars($keywords))
@section('pageTitleMain','搜索：'.htmlspecialchars($keywords))

@section('bodyContent')

    <div class="pb pb-thread-list">
        <div class="body">
            @if(!empty($threads))
                @foreach($threads as $thread)
                    <div class="item">
                        <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                            @if(empty($thread['_memberUser']['avatar']))
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                            @else
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                            @endif
                        </a>
                        <a href="/thread/{{$thread['id']}}" class="main">
                            <div class="title">
                                @if($thread['isTop'])
                                    <span class="uk-text-danger">[置顶]</span>
                                @endif
                                @if($thread['isDigest'])
                                    <span class="uk-text-warning">[精华]</span>
                                @endif
                                {{$thread['title']}}
                            </div>
                            <div class="attr">
                                <div class="right">
                                    <i class="uk-icon-eye"></i> {{$thread['postCount']}}/{{$thread['clickCount']}}
                                </div>
                                @if(!empty($thread['_tag']))
                                    <span class="tag">{{$thread['_tag']['title']}}</span>
                                @endif
                                <span>{{$thread['_memberUser']['username'] or '[已删除用户]'}}</span>
                                发布
                                <time datetime="{{$thread['created_at']}}"></time>
                                @if($thread['lastReplyTime'])
                                    ·
                                    更新 <time datetime="{{$thread['lastReplyTime']}}"></time>
                                @endif
                            </div>
                        </a>
                    </div>
                @endforeach
            @else
                <div class="empty">
                    暂无记录~
                </div>
            @endif

        </div>
        <div class="body">
            <div class="page-container">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>

@endsection