@extends('theme.default.m.frame')

@if($thread)
    @section('pageTitle','编辑帖子')
    @section('pageTitleMain','编辑帖子')
    @section('headerTitle','编辑帖子')
@else
    @section('pageTitle','发布帖子')
    @section('pageTitleMain','发布帖子')
    @section('headerTitle','编辑帖子')
@endif

@section('bodyScript')
    @parent
    <script>
        $(function(){
            editor = window.api.editor.simple('#content',{
                imageListServer: '/data/image_select_dialog/simple_list',
                imageUploadServer: '/data/image_select_dialog/upload_file',
                imageUploadFileName: 'file',
                imageListEnable: true
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="pb">
        <div class="body">
            <form action="?" class="uk-form" data-ajax-form method="post">
                @if(!empty($categoryTags))
                    <div class="line">
                        <div class="label">标签</div>
                        <div class="field">
                            <div class="widget-radio widget-radio-primary" data-tab-only>
                                @foreach($categoryTags as $categoryTagId=>$categoryTagTitle)
                                    <label><input type="radio" name="tagId" value="{{$categoryTagId}}" @if(isset($thread['tagId']) && $thread['tagId']==$categoryTagId) checked @endif  />{{$categoryTagTitle}}</label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
                <div class="line">
                    <div class="label">标题</div>
                    <div class="field">
                        <input type="text" name="title" class="uk-width-1-1" value="{{$thread['title'] or ''}}"/>
                    </div>
                </div>
                <div class="line">
                    <div class="label">内容</div>
                    <div class="field">
                        <script type="text/plain" id="content" name="content">{!! $thread['content'] or '' !!}</script>
                    </div>
                </div>
                <div class="line">
                    <div class="label">&nbsp;</div>
                    <div class="field">
                        <button class="uk-button uk-button-primary uk-width-1-1">提交</button>
                    </div>
                </div>
                <input type="hidden" name="categoryId" value="{{$category['id'] or ''}}">
            </form>
        </div>
    </div>

@endsection