@extends('theme.default.m.frame')

@section('pageTitle',htmlspecialchars($thread['title']))
@section('pageTitleMain',htmlspecialchars($thread['title']))
@section('pageKeywords',htmlspecialchars($thread['title']))

@section('bodyScript')
    @parent
    @if($_memberUserId)
        <script>
            var editor = null;
            $(function(){
                editor = window.api.editor.simple('#content',{
                    imageListServer: '/data/image_select_dialog/simple_list',
                    imageUploadServer: '/data/image_select_dialog/upload_file',
                    imageUploadFileName: 'file',
                    imageListEnable: true
                });
            });
        </script>
    @endif
    <script>
        $(function(){
            <?php $postId =intval(\Illuminate\Support\Facades\Input::get('postId')) ; ?>
            @if($postId)
                window.location.href='#post-{{$postId}}';
            @endif
        });
    </script>
@endsection

@section('bodyContent')

    <div class="pb pb-thread">
        <div class="body">
            <h1>
                @if($thread['isTop'])
                    <span class="uk-text-danger">[置顶]</span>
                @endif
                @if($thread['isDigest'])
                    <span class="uk-text-warning">[精华]</span>
                @endif
                {{$thread['title']}}
            </h1>
            <div class="attr">
                <a href="/member/{{$thread['_memberUser']['id']}}">{{$thread['_memberUser']['username'] or '[已删除用户]'}}</a>
                发表于 <time datetime="{{$thread['created_at']}}"></time>
                阅读：<span class="cnt">{{$thread['clickCount']}}</span>
                回复：<span class="cnt">{{$thread['postCount']}}</span>
            </div>
            <div class="content html-container">
                {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($thread['contentHtml'],'data-src',true) !!}
            </div>
            <div class="uk-text-center" data-share-buttons data-sites="weibo,qq,qzone,wechat"></div>
            <div class="thread-action">
                @if(empty($thread['_memberData']['fav']))
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/fav" data-toggle-class="cur"><i class="uk-icon-star"></i> 收藏</a>
                @else
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/fav" data-toggle-class="cur" class="cur"><i class="uk-icon-star"></i> 收藏</a>
                @endif
                @if(empty($thread['_memberData']['up']))
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/up" data-toggle-class="cur" data-toggle-change="1"><i class="uk-icon-thumbs-o-up"></i> 赞（<span data-value>{{$thread['upCount'] or 0}}</span>）</a>
                @else
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/up" data-toggle-class="cur" data-toggle-change="-1" class="cur"><i class="uk-icon-thumbs-o-up"></i> 赞（<span data-value>{{$thread['upCount'] or 0}}</span>）</a>
                @endif
                @if(empty($thread['_memberData']['down']))
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/down" data-toggle-class="cur" data-toggle-change="1"><i class="uk-icon-thumbs-o-down"></i> 踩（<span data-value>{{$thread['downCount'] or 0}}</span>）</a>
                @else
                    <a href="javascript:;" data-ajax-toggle="/thread/toggle/{{$thread['id']}}/down" data-toggle-class="cur" data-toggle-change="-1" class="cur"><i class="uk-icon-thumbs-o-down"></i> 踩（<span data-value>{{$thread['downCount'] or 0}}</span>）</a>
                @endif

            </div>
            <div class="action">
                @if($_memberUserId==$thread['memberUserId'])
                    <a href="/thread/edit/{{$thread['id']}}">编辑</a>
                @endif
                @if($isAdmin || $_memberUserId==$thread['memberUserId'])
                    <a href="javascript:;" data-ajax-request-loading data-ajax-request="/thread/delete/{{$thread['id']}}" data-confirm="确定删除?">删除</a>
                @endif
                @if($isAdmin)
                    @if($thread['isTop'])
                        <a href="javascript:;" data-ajax-request-loading data-ajax-request="/thread/set_top/{{$thread['id']}}" data-confirm="取消确定置顶?">取消置顶</a>
                    @else
                        <a href="javascript:;" data-ajax-request-loading data-ajax-request="/thread/set_top/{{$thread['id']}}" data-confirm="确定设为置顶?">设为置顶</a>
                    @endif
                    @if($thread['isDigest'])
                        <a href="javascript:;" data-ajax-request-loading data-ajax-request="/thread/set_digest/{{$thread['id']}}" data-confirm="确定取消精华?">取消精华</a>
                    @else
                        <a href="javascript:;" data-ajax-request-loading data-ajax-request="/thread/set_digest/{{$thread['id']}}" data-confirm="确定设为精华?">设为精华</a>
                    @endif
                @endif
                <a href="#comment">回复</a>
            </div>
        </div>
    </div>


    <div class="pb pb-post-list">
        <div class="body">
            @foreach($posts as $post)
                <div class="item">
                    <a name="post-{{$post['id']}}" id="post-{{$post['id']}}"></a>
                    <a href="/member/{{$post['_memberUser']['id']}}" class="avatar">
                        @if(empty($post['_memberUser']['avatar']))
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                        @else
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($post['_memberUser']['avatar'])}}">
                        @endif
                    </a>
                    <div class="user">
                        <a href="/member/{{$post['_memberUser']['id']}}">{{$post['_memberUser']['username'] or '[已删除用户]'}}</a>
                        发表于
                        <time datetime="{{$post['created_at']}}"></time>
                    </div>
                    <div class="content">
                        {!! $post['content'] !!}
                    </div>
                    <div class="action">
                        <a href="#comment" onclick="editor && ( editor.setContent($(this).attr('data-username')) ); editor && ($('[name=replyPostId]').val( {{$post['id']}} ));"
                           data-username="<?php if(!empty($post['_memberUser']['username'])){echo '@'.htmlspecialchars($post['_memberUser']['username']).': ';} ?>">回复</a>
                        @if($post['memberUserId']==$_memberUserId)
                            <a href="javascript:;" data-confirm="确定删除?" data-ajax-request-loading data-ajax-request="/thread/post_delete/{{$post['id']}}">删除</a>
                        @endif
                    </div>
                </div>
            @endforeach
            <div class="page-container">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>

    <div class="pb pb-thread-reply">
        <div class="body">
            <a id="comment" name="comment"></a>
            @if($_memberUserId)
                <form action="/thread/post/{{$thread['id']}}" data-ajax-form method="post">
                    <div class="title"><i class="uk-icon-comment"></i> 发表回复</div>
                    <div class="form">
                        <div style="padding:10px 0 0 0;">
                            <script type="text/plain" id="content" name="content"></script>
                        </div>
                    </div>
                    <div class="button">
                        <button type="submit" class="uk-button uk-button-primary uk-width-1-1">发表回复</button>
                    </div>
                    <input type="hidden" name="replyPostId" value="0" />
                </form>
            @else
                <div class="uk-text-center uk-text-danger" style="padding:50px 0;">请 <a href="/login?redirect={{urlencode($base_request_path)}}">登录</a> 后再回复</div>
            @endif
        </div>
    </div>

@endsection