@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($category['title']))

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                @foreach($categoryChain as $categoryChainItem)
                    <li><a href="/forum/{{$categoryChainItem['id']}}">{{$categoryChainItem['title']}}</a></li>
                @endforeach
            </ul>
        </div>

        <div class="pb pb-forum-title">
            <h1>{{$category['title']}}</h1>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-4">
                <div class="pb pb-forum-threads">
                    <div class="body">
                        @if(!empty($childCategories))
                            <div class="pb pb-forum-sub">
                                <div class="uk-grid">
                                    @foreach($childCategories as $category2)
                                        <div class="uk-width-1-2">
                                            <div class="item">
                                                <a class="icon" href="/forum/{{$category2['id']}}">
                                                    @if($category2['cover'])
                                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($category2['cover'])}}"/>
                                                    @else
                                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/none.png')}}"/>
                                                    @endif
                                                </a>
                                                <a href="/forum/{{$category2['id']}}" class="title">{{$category2['title']}}</a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        <div class="thread-title">
                            <a href="/forum/{{$category['id']}}" @if(!$type) class="cur" @endif >全部主题</a>
                            <a href="/forum/{{$category['id']}}?type=digest" @if('digest'==$type) class="cur" @endif >精华</a>
                        </div>
                        @if(!empty($categoryTags))
                            <div class="thread-tag">
                                <a href="?{{\TechOnline\Laravel\Http\Request::mergeQueries(['tagId'=>null])}}" @if(empty($tagId)) class="cur" @endif>全部</a>
                                @foreach($categoryTags as $categoryTagId=>$categoryTagTitle)
                                    <a href="?{{\TechOnline\Laravel\Http\Request::mergeQueries(['tagId'=>$categoryTagId])}}" @if($tagId==$categoryTagId) class="cur" @endif>{{$categoryTagTitle}}</a>
                                @endforeach
                            </div>
                        @endif
                        <ul class="thread-list">
                            @foreach($threads as $thread)
                                <li class="item">
                                    <div class="reply">{{$thread['postCount']}}/{{$thread['clickCount']}}</div>
                                    <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                                        @if(empty($thread['_memberUser']['avatar']))
                                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                                        @else
                                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                                        @endif
                                    </a>
                                    <a href="/thread/{{$thread['id']}}" class="title">
                                        @if($thread['isTop'])
                                            <span class="uk-text-danger">[置顶]</span>
                                        @endif
                                        @if($thread['isDigest'])
                                            <span class="uk-text-warning">[精华]</span>
                                        @endif
                                        {{$thread['title']}}
                                    </a>
                                    <div class="attr">
                                        @if(!empty($thread['_tag']))
                                            <span class="tag">{{$thread['_tag']['title']}}</span>
                                        @endif
                                        <a href="/member/{{$thread['_memberUser']['id']}}">{{$thread['_memberUser']['username'] or '[已删除用户]'}}</a>
                                        发布于
                                        <time datetime="{{$thread['created_at']}}"></time>
                                        @if($thread['lastReplyTime'])
                                            ·
                                            最后更新于 <time datetime="{{$thread['lastReplyTime']}}"></time>
                                        @endif
                                    </div>
                                </li>
                            @endforeach
                            @if(empty($threads))
                                <li class="empty">
                                    暂无数据
                                </li>
                            @endif
                        </ul>
                        <div class="page-container">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-width-1-4">
                <div class="pb pb-button">
                    <a class="uk-button uk-button-primary" href="/thread/edit?categoryId={{$category['id']}}"><span class="uk-icon-plus"></span> 我要发帖</a>
                </div>
                <div class="pb pb-list">
                    <div class="head">最新帖子</div>
                    <div class="body">
                        @foreach($latestThreads as $t)
                            <a href="/thread/{{$t['id']}}">{{$t['title']}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection