<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('siteFavIco'))}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription'))">
    <meta name="viewport" content="width=device-width, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle')@yield('pageTitleMain') - {{\TechSoft\Laravel\Config\ConfigUtil::get('siteName')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="@assets('theme/default/pc/css/style.css')"/>
    @show
    @section('headAppend')@show
    {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
</head>
<body>
@section('body')

    <header>
        <div class="main-container">
            <nav class="uk-navbar">
                <ul class="uk-navbar-nav uk-navbar-nav-right">
                    @if(empty($_memberUser))
                        <li><a href="/login">登录</a></li>
                    @else
                        <li>
                            <a href="/member/message" class="notice">
                                <i class="uk-icon-bell"></i>
                                <?php $count = \TechSoft\Laravel\MemberMessage\MemberMessageUtil::getUnreadMessageCount($_memberUser['id']); ?>
                                @if($count)
                                    <span class="count" data-member-unread-message-count>{{$count}}</span>
                                @endif
                            </a>
                        </li>
                        <li class="uk-parent" data-uk-dropdown>
                            <a href="javascript:;" class="username">{{\TechSoft\Laravel\Member\MemberUtil::viewName($_memberUser)}}</a>
                            <div class="uk-dropdown uk-dropdown-navbar uk-dropdown-bottom" style="top: 40px; left: 0px;">
                                <ul class="uk-nav uk-nav-navbar">
                                    <li><a href="/member/{{$_memberUser['id']}}"><i class="uk-icon-user"></i> 个人中心</a></li>
                                    <li><a href="/member/profile"><i class="uk-icon-cog"></i> 编辑资料</a></li>
                                    <li><a data-confirm="确定退出?" data-href="/logout"><i class="uk-icon-sign-out"></i> 退出</a></li>
                                </ul>
                            </div>
                        </li>
                    @endif
                </ul>
                <div class="search">
                    <form class="uk-form" method="get" action="/search">
                        <input type="text" placeholder="输入关键词搜索" name="keywords" value="{{Input::get('keywords','')}}" />
                        <button type="submit" class="uk-button"><i class="uk-icon-search"></i></button>
                    </form>
                </div>
                <a class="uk-navbar-brand" href="/"><img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'))}}" /></a>
                <ul class="uk-navbar-nav">
                    @foreach(\TechSoft\Laravel\Forum\ForumUtil::getTreeCategories() as $category1)
                        <li class="uk-parent" data-uk-dropdown>
                            <a href="javascript:;">{{$category1['title']}}</a>
                            <div class="uk-dropdown uk-dropdown-navbar">
                                <ul class="uk-nav uk-nav-navbar">
                                    @foreach($category1['_child'] as $category2)
                                        <li><a href="/forum/{{$category2['id']}}">{{$category2['title']}}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </nav>
        </div>
    </header>

    @section('bodyContent')@show

    <footer>
        <div class="main-container">
            <div class="copyright">
                <a href="http://beian.miit.gov.cn/" target="_blank" style="color:#EEE;">{{\TechSoft\Laravel\Config\ConfigUtil::get('siteBeian','[网站备案信息]')}}</a>
                &copy;
                {{\TechSoft\Laravel\Config\ConfigUtil::get('siteDomain')}}
            </div>
        </div>
    </footer>
@show
@section('bodyScript')
    <script src="@assets('assets/main/basic.js')"></script>
@show
@section('bodyAppend')@show
</body>
</html>
