@extends('theme.default.pc.frame')

@section('pageTitle',\TechSoft\Laravel\Config\ConfigUtil::get('siteName'))

@section('bodyScript')
    @parent
    <script>
        var swiper = new Swiper('.pb-banner .swiper-container', {
            pagination: '.swiper-pagination',
            paginationClickable: '.swiper-pagination',
            nextButton: '.swiper-button-next',
            prevButton: '.swiper-button-prev',
            loop: true
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-banner">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    @if(empty($banners))
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1000x400');"></a>
                    @else
                        @foreach($banners as $banner)
                            <a class="swiper-slide"
                               style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($banner['image'])}});"
                               @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination swiper-pagination-white"></div>
                <div class="swiper-button-next swiper-button-white"></div>
                <div class="swiper-button-prev swiper-button-white"></div>
            </div>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-4">
                @foreach(\TechSoft\Laravel\Forum\ForumUtil::getTreeCategories() as $category1)
                    <div class="pb pb-forum">
                        <div class="head">
                            {{$category1['title']}}
                        </div>
                        <div class="body">
                            <div class="uk-grid">
                                @foreach($category1['_child'] as $category2)
                                    <div class="uk-width-1-2">
                                        <div class="item">
                                            <a class="icon" href="/forum/{{$category2['id']}}">
                                                @if($category2['cover'])
                                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($category2['cover'])}}"/>
                                                @else
                                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/none.png')}}"/>
                                                @endif
                                            </a>
                                            <a href="/forum/{{$category2['id']}}" class="title">{{$category2['title']}}</a>
                                            <div class="desc">
                                                {{$category2['desc']}}
                                            </div>
                                            <div class="stat">
                                                主题: {{$category2['threadCount'] or 0}}, 帖数: {{$category2['postCount'] or 0}}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="uk-width-1-4">

                <div class="pb pb-latest">
                    <div class="list">
                        <div class="head">最新帖子</div>
                        <div class="body">
                            @foreach($latestThreads as $t)
                                <a href="/thread/{{$t['id']}}">{{$t['title']}}</a>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div class="pb pb-latest">
                    <div class="list">
                        <div class="head" style="color:red;">最热帖子</div>
                        <div class="body">
                            @foreach($hottestThreads as $t)
                                <a href="/thread/{{$t['id']}}">{{$t['title']}}</a>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </div>



        <div class="pb pb-partner">
            <div class="head">
                合作伙伴
            </div>
            <div class="body">
                <div class="uk-grid">
                    @foreach($partners as $partner)
                        <div class="uk-width-1-6">
                            <a class="item" href="{{$partner['link']}}" target="_blank" title="{{$partner['title']}}">
                                <div class="cover" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($partner['logo'])}})"></div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

    </div>


@endsection