@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($memberUser['username']).'发表的评论')

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/member/{{$memberUser['id']}}">个人中心</a></li>
                <li class="uk-active"><span>发表的评论</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-10">

                @include('theme.default.pc.member.oneLeft')

            </div>
            <div class="uk-width-7-10">
                <div class="pb">
                    <div class="head">发表的评论</div>
                    <div class="body">

                        <div class="member-comment-list">

                            @if(empty($posts))
                                <div class="empty">
                                    没有记录~
                                </div>
                            @else
                                @foreach($posts as $post)
                                    <div class="item">
                                        <div class="thread">
                                            @if(empty($post['_thread']))
                                                <a href="javascript:;">[帖子已删除]</a>
                                            @else
                                                <a target="_blank" href="/thread/{{$post['_thread']['id']}}">{{$post['_thread']['title']}}</a>
                                            @endif
                                            &nbsp;&nbsp;
                                            <span class="time"><time datetime="{{$post['created_at']}}"></time></span>
                                        </div>
                                        <div class="comment">
                                            {!! $post['content'] !!}
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                        </div>

                        <div class="page-container">
                            {!! $pageHtml !!}
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection