@extends('theme.default.pc.frame')

@section('pageTitleMain','搜索：'.htmlspecialchars($keywords))

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><span>搜索：{{$keywords}}</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-4">
                <div class="pb pb-forum-threads">
                    <ul class="thread-list">
                        @foreach($threads as $thread)
                            <li class="item">
                                <div class="reply">{{$thread['postCount']}}/{{$thread['clickCount']}}</div>
                                <a href="/member/{{$thread['_memberUser']['id']}}" class="avatar" target="_blank">
                                    @if(empty($thread['_memberUser']['avatar']))
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('assets/lib/img/avatar.png')}}">
                                    @else
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($thread['_memberUser']['avatar'])}}">
                                    @endif
                                </a>
                                <a href="/thread/{{$thread['id']}}" class="title">
                                    @if($thread['isTop'])
                                        <span class="uk-text-danger">[置顶]</span>
                                    @endif
                                    @if($thread['isDigest'])
                                        <span class="uk-text-warning">[精华]</span>
                                    @endif
                                    {{$thread['title']}}
                                </a>
                                <div class="attr">
                                    @if(!empty($thread['_tag']))
                                        <span class="tag">{{$thread['_tag']['title']}}</span>
                                    @endif
                                    <a href="/member/{{$thread['_memberUser']['id']}}">{{$thread['_memberUser']['username'] or '[已删除用户]'}}</a>
                                    发布于
                                    <time datetime="{{$thread['created_at']}}"></time>
                                    @if($thread['lastReplyTime'])
                                    ·
                                    最后更新于 <time datetime="{{$thread['lastReplyTime']}}"></time>
                                    @endif
                                </div>
                            </li>
                        @endforeach
                        @if(empty($threads))
                            <li class="empty">
                                暂无数据
                            </li>
                        @endif
                    </ul>
                    <div class="page-container">
                        {!! $pageHtml !!}
                    </div>
                </div>
            </div>
            <div class="uk-width-1-4">
                <div class="pb pb-list">
                    <div class="head">最新帖子</div>
                    <div class="body">
                        @foreach($latestThreads as $t)
                            <a href="/thread/{{$t['id']}}">{{$t['title']}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection