DROP TABLE IF EXISTS `cmseasy_archive`;-- 
CREATE TABLE `cmseasy_archive` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(6) NOT NULL,
  `typeid` int(6) NOT NULL,
  `title` varchar(60) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `tag` varchar(255) DEFAULT NULL,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `view` int(11) NOT NULL DEFAULT '0',
  `color` char(20) DEFAULT NULL,
  `strong` tinyint(1) DEFAULT '0',
  `toppost` tinyint(1) DEFAULT '0',
  `font` char(6) DEFAULT NULL,
  `spid` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `mtitle` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `description` text,
  `listorder` int(11) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `author` varchar(20) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `checked` tinyint(2) DEFAULT '0',
  `introduce` text,
  `introduce_len` int(5) NOT NULL,
  `content` mediumtext,
  `template` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `linkto` varchar(255) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(255) DEFAULT NULL,
  `comment_num` int(11) DEFAULT '0',
  `attachment_id` varchar(50) DEFAULT NULL,
  `attachment_path` varchar(150) DEFAULT NULL,
  `grade` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pics` text,
  `type` char(10) NOT NULL,
  `province_id` int(3) NOT NULL,
  `city_id` int(3) DEFAULT NULL,
  `section_id` int(3) DEFAULT NULL,
  `outtime` date NOT NULL,
  `my_size` varchar(100) DEFAULT NULL,
  `my_zhaopinbumen` varchar(100) DEFAULT NULL,
  `my_jobtype` varchar(10) DEFAULT NULL,
  `my_jobtitle` varchar(100) DEFAULT NULL,
  `my_jobnumber` varchar(100) DEFAULT NULL,
  `my_jobgender` varchar(10) DEFAULT NULL,
  `my_jobwork` text,
  `my_jobacademic` varchar(10) DEFAULT NULL,
  `my_jobage` varchar(100) DEFAULT NULL,
  `my_jobworkareas` varchar(100) DEFAULT NULL,
  `my_jobrequirements` text,
  `my_contactname` varchar(100) DEFAULT NULL,
  `my_vr` varchar(255) DEFAULT '',
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `my_tonghangbijiao` varchar(100) DEFAULT NULL,
  `my_donggongjindu` varchar(100) DEFAULT NULL,
  `my_zhiwei` varchar(100) DEFAULT NULL,
  `iscomment` tinyint(1) DEFAULT '1',
  `updatedate` datetime DEFAULT NULL COMMENT '修改时间',
  `my_field` varchar(255) DEFAULT NULL COMMENT '商品信息字段',
  `praise` varchar(255) DEFAULT NULL,
  `salesnum` int(11) DEFAULT NULL,
  `langid` int(11) DEFAULT NULL,
  `inventory` int(11) NOT NULL DEFAULT '0',
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  `combined` varchar(500) DEFAULT NULL COMMENT '组合商品',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`) USING BTREE,
  KEY `keyword` (`keyword`) USING BTREE,
  KEY `title` (`title`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `catid` (`typeid`) USING BTREE,
  KEY `typeid` (`catid`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=131 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_b_category`;-- 
CREATE TABLE `cmseasy_b_category` (
  `catid` int(6) NOT NULL AUTO_INCREMENT,
  `parentid` int(6) NOT NULL,
  `catname` varchar(30) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `scategory` varchar(50) DEFAULT NULL,
  `listorder` int(11) DEFAULT NULL,
  `image` varchar(150) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `keyword` varchar(150) DEFAULT NULL,
  `description` text,
  `categorycontent` mediumtext,
  `htmldir` varchar(50) NOT NULL,
  `template` varchar(50) DEFAULT NULL,
  `listtemplate` varchar(50) DEFAULT NULL,
  `showtemplate` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `listtemplatewap` varchar(50) DEFAULT NULL,
  `showtemplatewap` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `listhtmlrule` varchar(100) DEFAULT NULL,
  `showhtmlrule` varchar(100) DEFAULT NULL,
  `module` varchar(16) NOT NULL DEFAULT 'article',
  `isshow` tinyint(2) DEFAULT '1',
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `ispages` tinyint(2) DEFAULT NULL,
  `includecatarchives` tinyint(2) DEFAULT '0',
  `addarcenable` tinyint(2) DEFAULT NULL,
  `linkto` varchar(150) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(20) DEFAULT NULL,
  `thumb` varchar(100) DEFAULT NULL,
  `thumb_width` int(3) DEFAULT NULL,
  `thumb_height` int(3) DEFAULT NULL,
  `isnav` tinyint(1) DEFAULT NULL,
  `ismobilenav` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `nofollow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '控制nofollow',
  `isblank` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设置新窗口打开',
  `contentrank` varchar(255) DEFAULT '',
  `isshopping` tinyint(1) NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  PRIMARY KEY (`catid`),
  UNIQUE KEY `category` (`catid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;-- 
INSERT INTO `cmseasy_archive` VALUES('1','1','0','企业文化','','','cmseasy','127','0','','0','0','','0','','','','','0','2010-07-18 23:53:18','cmseasy','','','1','1','企业文化简介内容&hellip;&hellip;','200','<p>企业文化简介内容&hellip;&hellip;</p>','0','','0','','0','0','','1','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 23:53:18','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('2','1','0','企业荣誉','','','cmseasy','127','0','','0','0','','0','','','','','0','2010-07-18 23:53:59','cmseasy','','','1','1','企业荣誉介绍&hellip;&hellip;','200','<p>企业荣誉介绍&hellip;&hellip;</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 23:53:59','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('3','1','0','诚聘英才','','','cmseasy','127','0','','0','0','','0','','','','','0','2010-07-18 23:58:30','cmseasy','','','1','1','诚聘英才内容&hellip;&hellip;','200','<p>诚聘英才内容&hellip;&hellip;</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 23:58:30','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('4','1','0','网站地图','','','cmseasy','127','0','','0','0','','0','','','','','0','2010-07-18 23:59:22','cmseasy','','','1','1','','200','','archive/show_sitemap.html','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 23:59:22','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('5','13','0','白蜡木家具好吗？解析白蜡木家具的优缺点','','','cmseasy','127','0','','0','0','','0','','','','','2105','2010-07-18 22:14:31','cmseasy','','/upload/images/201304/2105.jpg','1','1','框架介绍 1. 前言 CMSEasy根据当前广为流行的敏捷开发方式，实现了基于ROR模型框架，能够快速高效的完成各种应用的开发和扩展。 2. 环境   开发语言：PHP   数据库：MySQL   系统环境：Window Server 或者Linux   框架结构 Cmseasy内核 ● 数据缓存 ●      数据库CRUD ● URI ●      MVC模式 ●      自定义模板 ●      表单模型 优势： 由内核进行总体控制，提高程序的安全性，可靠性。 …','200','<p>很多设计师认为做好了企业网站就一定能够做好行业网站的设计，其实对设计来说行业网站和企业网站的设计截然不同，对整个网站的创意、风格、整体框架布局、文字编排、图片的合理利用，空间的合理安排上面等&hellip;有着许多诸多的要求，需要考虑的面更广，面对的问题也会更多。对于一名优秀的网站设计师来说不能绝不能放过任何一点小细节，本篇文章简述的是设计师在做行业网站时所需考虑的一些问题。&nbsp;</p><p>一、网站风格/创意</p><p>　　风格(style)是抽象的。是指站点的整体形象给浏览者的综合感受。整体形象包括站点的版面布局，色彩，字体，浏览方式等&hellip;。如：我们觉得迪斯尼是生动活泼的而IBM则是专业严肃的。每一个网站都会给人们留下的不同感受。这里我们需要做到的是根据网站的定位做出网站特有的风格。除此我们还需要在风格同一上需要把握一下，其实这个风格的统一和传统的印刷出版物没什么区别。你网页上所有的图像、文字，包括像背景颜色、区分线、字体、标题、注脚什么的，都要统一风格，贯穿全站。这样子用户看起来舒服、顺畅，会对你的网站留下一个&ldquo;很专业&rdquo;的印象。而企业网站设计师往往就缺乏这一点，没有全局意思。</p><p>　　创意，所谓创意就是不拘一格？某些设计师在做创意的时候大费周章，做出来确实不可否认很有创意、很别致，但往往对于行业网站的客户为什么不能接受呢？此时不要太责怪客户的不识货，应该反思，抓住客户的需求。其实做行业网站不需要很多大的创意，也不要浪费过多的时间去追求如何个性、如何好看，我们只需要一点小小的创意贯穿全站，也许会使网站更生动更具有吸引力、更有思想，比如企业网站管理程序(<a href=\"http://www.cmseasy.cn/\">http://www.cmseasy.cn/</a>)就是一个很好的案例，它把领先的SEO融入到网站中，使它脱颖而出。</p><p>二、网站LOGO</p><p>　　Logo顾名思义就是站点的标志图案，logo最重要的就是用图形化的方式传递网站的定位和经营理念、同时便于人们识别。网站logo的设计过程中一般有以下三种思路：1.直接以网站网址作为logo。2.根据网站提供的产品/服务特点展开logo设计。3.以传递网站运营商的经营理念为特色。如：企业网站建设网logo(<a href=\"http://www.cmseasy.cn\">www.cmseasy.cn</a>)</p><p>三、视觉流程</p><p>　　人们在阅读某种信息时，视觉总有一种自然的流动习惯，先看什么，后看什么，再看什么。在心理学的研究表明，一般的浏览习惯是从上到下、从左到右，在一个平面上，上松下稳而压抑。同样，平面的左松右稳。所以平面的视觉影响力上方强于下方，左侧强于右侧。这样平面的上部和中上部被称为&ldquo;最佳视域&rdquo;，也就是最优选的地方。在网页设计中一些突出或推荐的信息通常都放在这个位置。当然这种视觉流程只是一种感觉并非一种固定的公式，只要符合人们的心理顺序和逻辑顺序，就可以更为灵活地运用，在网页设计中，灵活而合理地运用直接影响到传达信息的准确与有效性。</p><p>四、网页框架与布局</p><p>　　网页布局大致可分为&ldquo;国&rdquo;字型、拐角型、&ldquo;T&rdquo;字型、&ldquo;L&rdquo;字型、综合框架型、Flash型、变化型，在这里就不做一一论述了。其实在我们在做设计的时候并没有过多的去考虑什么形式，比如我们在一张纸看到一个圆形的东西，很容易可以联想到它像太阳，而有些人则联想到月亮等等&hellip;这都是一种形式比喻，最重要的是抓住客户的需求，把握网站的定位做处合理的框架布局。</p><p>1． 分辨率</p><p>　　网页的整体宽度可分为三种设置形式：百分比、象素、象素+百分比。通常在网站建设中以象素形式最为常用，行业网站也不列外。我们在设计网页的时候必定会考虑到分辨率的问题，科技发展到现在我们通常用的是1024*768和800*600的分辨率，现在网络上很多都是用到778个象素的宽度，在800的分辨率下面往往使整个网页很压抑，有种不透气的感觉，其实这个宽度是指在800*600的分辨率上网页的最宽宽度，不代表最佳视觉，不妨试试760~770的象素，不管在1024还是800的分辨率下都可以达到较佳的视觉效果。</p><p>2． 合理广告</p><p>　　在目前一些网站的广告（弹出广告、浮动广告、大广告、banner广告、通栏广告等等&hellip;）让人觉得很烦琐，更本就不愿意来看，有时连你这个网站都不上了，这样一来网站受到了严重的影响、广告也没达到广告的目的。这些问题都是我们在设计网站之前需要考虑、需要规划的内容之一。</p><p>　　浮动广告有两种，第一种是在网页两边空余的地方可以上下浮动的广告，第二种是满屏幕到处随机移动的广告。建议能使用第一种的情况下尽量使用第一种，不可避免第二种情况时尽量在数量上控制最多一个就好。如果数量过多会直接影响到用户的心理、防挨到用户浏览信息,适得其反。首页广告不宜过多适中即可。如在注册或者某个购买步骤的页面上最好不要出现过多的其他无关的内容让用户分心，避免客户流失等&hellip;</p><p>3．空间的合理利用</p><p>　　很多的网页都具有一个特点，用一个字来形容，那就是&ldquo;塞&rdquo;，它将各种各样的信息如文字、图片、动画等不加考虑的塞到页面上，有多少挤多少，不加以规范，导致浏览时会遇到很多的不方便，主要就是页面主次不分，喧宾夺主，要不就是没有重点，没有很好的归类，整体就像各大杂烩。让人难以找到需要的东西。有的则是一片空白失去平衡，也可以用个&ldquo;散&rdquo;字来形容。</p><p>　　并非要把整个页面塞满了才不觉得空，也并非让整个页面空旷才不觉得满，只要合理的安排、有机的组合，使页面达到平衡，既使在一边的部分大面积留空，同样不会让人感到空，相反这样会给人留下广阔的思考空间，给人回味又达到了视觉效果。</p><p>4．文字编排</p><p>　　在网页设计中，字体的处理与颜色、版式、图形化等其他设计元素的处理一样非常关键。</p><p>4.1文字图形化</p><p>　　文字图形化就是将文字用图片的形式来表现，这种形式在页面的子栏目里面最为常用，因为它具有突出，同时又美化了页面，使页面更加人性化加强了视觉效果。是文字无法达到的。对于通用性的网站弊端就是扩展性不强。</p><p>4.2强调文字</p><p>　　如果将个别文字作为页面的诉求重点，则可以通过加粗、加下划线、加大号字体、加指示性符号、倾斜字体、改变字体颜色等手段有意识地强化文字的视觉效果，使其在页面整体中显得出众而夺目。这些方法实际上都是运用了对比的法则。如果在更新频率低的情况下也可以使用文字图形化。</p><p>&nbsp;</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 22:14:31','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('6','13','0','ktv装修设计中软装 ','','','cmseasy','127','0','','0','0','','0','','','','','2104','2010-07-18 22:21:57','cmseasy','','/upload/images/201304/2104.jpg','1','1','网站的良好运营靠的是什么？靠技术，肯定不是，因为技术的发展是一个相对的概念，不具有耐久性，缺乏凝聚力，如果仅仅靠这个，是不能维系整个网站发展的。网站其实就是企业，只不过它是提供给自己的客户以不同的产品，即以网页的形式展现给他们浏览、以交互的方式让他们参与等等，既然网站是一个企业就不能回避一个问题，就是盈利的问题，如果只顾向网站投钱，作亏本生意，是那个网站都不愿意做的事情。所以网络如果要给自己带来回报，就必须以高标准来要求，这样就不得不提升到网站文化的高度。还是先来看一下企业文化的定义吧！  　　 只要问一问任何一家一流的高科技企业，什么使这些企业引以自豪，十家有八家或许会告诉你，它们引以自豪的是自己的产品或服务。剩下的两家则会举出一系列的东西，如它们的业务流程、它们的业务伙伴关系、它们的员工等等。总之，概括起来就是：企业文化。 什么是企业文化呢？Terence E. De','200','<p>网站的良好运营靠的是什么？靠技术，肯定不是，因为技术的发展是一个相对的概念，不具有耐久性，缺乏凝聚力，如果仅仅靠这个，是不能维系整个网站发展的。网站其实就是企业，只不过它是提供给自己的客户以不同的产品，即以网页的形式展现给他们浏览、以交互的方式让他们参与等等，既然网站是一个企业就不能回避一个问题，就是盈利的问题，如果只顾向网站投钱，作亏本生意，是那个网站都不愿意做的事情。所以网络如果要给自己带来回报，就必须以高标准来要求，这样就不得不提升到网站文化的高度。还是先来看一下企业文化的定义吧！&nbsp;</p><p>　　 只要问一问任何一家一流的高科技企业，什么使这些企业引以自豪，十家有八家或许会告诉你，它们引以自豪的是自己的产品或服务。剩下的两家则会举出一系列的东西，如它们的业务流程、它们的业务伙伴关系、它们的员工等等。总之，概括起来就是：企业文化。 什么是企业文化呢？Terence E. Deal（特伦斯）和Allan A. Kennedy（阿伦）合著了一部颇具影响的专著，《企业文化》（Corporate Culture）。书中给企业文化的定义是，\"用以规范企业人多数情况下行为的一个强有力的不成文规则体系。\"</p><p>　　其实企业文化指的是一个企业中所有员工共有的一套观念、信念、价值和行为准则，以及由此导致的行为模式。企业文化是以人为本的管理哲学，是把精神文明建设同企业特点和市场对企业发展的要求结合起来的一个重要形式，是借助文化力量的管理方式，良好的企业文化能为企业保持数十年的竞争优势。</p><p>　　可以说企业文化是企业的灵魂。一个没有自己企业文化的企业其经营往往是随波逐流的，其员工也没有主人翁意识，这样的企业是长不了的。纵观国内外现代化企业管理已经从以物为中心的管理转向以人为中心的管理，从而越来越突出人在企业生存和发展中的作用和力量。企业最重要的资源是知识，而知识是人的资源，所以重视人就是重视企业最重要的资源。IBM这样一个老牌的大公司为什么经历如此多的风风雨雨至今仍然是蓝色巨人？HP公司为什么能保持20多年持续稳定的发展？其答案都很简单：重视人的建设是他们立于不败之地的保证。</p><p>　　虽然现在的网站赖以竞争的本钱并不是靠的自己的文化，而是一些比如机遇、技术、条件等，但是现在并不能代表以后，随着社会经济和网络技术的发展，外部条件都不是问题，如果仅靠这些，网站之间的差别将变得很小，这样网站生存的价值就会变小。所以要能够在竞争中立于不败之地，就应该坚持以人为本，挖掘网站人的潜力，让他们发挥自己的才能，使他们能够不断的超越自我，更好的凸现自己的价值。从而形成一种合力，使网站的发展形成一种良好的机制。</p><p>　　 在这样的情况下，网页设计就被赋予了新的内容，要求也随之提高，主要表现在几个方面：</p><p>　　首先就是网站的整体形象，一个网站给人的第一印象就是主页，但是绝不是说，只要主页做好了，网站的整体形象就好，因为在用户对整个网站的浏览的过程中，会自然而然的形成一种对网站的看法，这种看法是附带有感情色彩的，比如喜欢、不喜欢、没有什么感觉等，这就是整体形象的体现，这是靠主页和其它的页面相配合来完成的，所以在制作网页的时候要考虑怎么将自己网站好的一面体现给自己的用户，又要考虑体现的方式，侧重点，不能一锅端，都放在主页上，造成杂乱的形象。而要给人以好的可以信赖的形象就必须从许多细节上入手，同时规范整个网站的外在表现，具体在于标志的设计、标准色彩的表达以及标准字体的设计。这些都是很重要的，有一个统一的、标准的形象是赢得自己用户信赖的条件。</p><p>　　其次是如何在网页设计中将整个网站的员工的精神风貌体现出来，每个企业的员工其实是一分宝贵的财富，所以能够充分的将员工的精神风貌体现出来一方面可以激励他们努力的工作，热爱自己的工作，也是加强企业凝聚力的一个手段；同时也可以通过这样的方法来赢得自己的客户的支持，在网站林立的今天，赢得自己的用户就是赢得了市场，就是获得了生存的基本条件。</p><p>　　再次，在网页设计的时候，需要结合网站本身的特点，提炼出自己的经营理念，摆脱低层次的网站运行模式，网站作为一个企业就必须在不断的发展壮大的时候，结合自身的文化特色，提炼出一些深层次的东西，而这些东西就是企业的灵魂，很多世界知名品牌都有自己的独特的经营理念，比如微软是\"成功诀窍 = 人才 + 创新，管理 = 合适的时间 + 应做的事\"，惠普是\"财富= 人才 = 资本 + 知识\"，飞利普是\"新产品 = 技术内涵 + 观念创新\"，东芝是\"企业活力 = 智力&times;（毅力 + 体力 + 速度）\"，麦当劳是\"企业的活力 = 原材料&times;设备&times;人力资源人力资源 = 人数&times;能力&times;态度\"。这样就给网页设计师提出了更高的要求，要求他们能够深入的了解网站，同时将自己融入的到网站中，不断的发掘具有闪光性的东西，同时找到合适的表达方式来加以强化。这样才能够使网站靠自身的优势获得用户的好感。从而奠定良性运行的基础。</p><p>　　既然网站文化给网页设计师提出了更高的要求，那么具体到网页设计师身上该如何应对呢？提高自身的文化素质是必不可少的，假如自身素质不高的话，就无法领会到很多其中的内涵，这样在自己的设计表达的时候就不可能到位，其实作品就是一面镜子，在其中可以折射出设计者自身的素质，这是掩盖不了的，所以提高自身的文化修养是很重要的，形成一种习惯，这样在无形中就可以在设计的作品表现出来，所以这里没有任何捷径可以走，只有在平时的生活中点点滴滴的积累。同时要有一颗积极向上的心，对生活充满热情！这样才可能在自己的网页设计中挖掘出好的东西来，也给自己的用户留下好的印象。<br/>&nbsp;</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 22:21:57','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('7','13','0','酒店设计也方便销售','','','cmseasy','127','0','','0','0','','0','','','','','2103','2010-07-18 22:22:19','cmseasy','','/upload/images/201304/2103.jpg','1','1','随着网络技术的不断发展，网络应用已经渗透到人类社会的各个角落。作为网络世界的支撑点的网站，更是人们关注的热点：政府利用网站宣传自己的施政纲领，日益成为与百姓交流的直通车；企业利用网站宣传自己的形象，挖掘无限商机；个人利用网站展示个性风采，创建彼此沟通的桥梁。越来越多的人希望拥有网站，开辟网络世界里的一片天地。如何设计一个出色的网站呢？关于这个问题，人们讨论的很多，可以讨论的内容也很多，加之网络技术的飞速发展，很难提出一个绝对权威和正确的设计思路，任何网站都基于以下设计思路：  中国站长第一门户          一、定位网站的主题和名称  网站的主题也就是网站的题材，网站设计开始首先遇到的问题。网站题材千奇百怪,琳琅满目，','200','<p>&nbsp;随着网络技术的不断发展，网络应用已经渗透到人类社会的各个角落。作为网络世界的支撑点的网站，更是人们关注的热点：政府利用网站宣传自己的施政纲领，日益成为与百姓交流的直通车；企业利用网站宣传自己的形象，挖掘无限商机；个人利用网站展示个性风采，创建彼此沟通的桥梁。越来越多的人希望拥有网站，开辟网络世界里的一片天地。如何设计一个出色的网站呢？关于这个问题，人们讨论的很多，可以讨论的内容也很多，加之网络技术的飞速发展，很难提出一个绝对权威和正确的设计思路，任何网站都基于以下设计思路：&nbsp;</p><p>中国站长第一门户</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp; 一、定位网站的主题和名称 <br/>网站的主题也就是网站的题材，网站设计开始首先遇到的问题。网站题材千奇百怪,琳琅满目，只要想的到，就可以把它制作出来。</p><p>如果题材已经确定以后，就可以围绕题材给网站起一个名字。网站名称，也是网站设计的一部分，而且是很关键的一个要素。</p><p>中国站长第一门户建议：</p><p>1、名称要正。其实就是要合法，和理，和情。不能用反动的，色情的，迷信的，危害社会安全的名词语句。</p><p>2、名称要易记。最好用中文名称，不要使用英文或者中英文混合型名称。另外，网站名称的字数应该控制在六个字(最好四个字)以内，四个字的也可以用成语。字数少还有个好处，适合于其他站点的链接排版。</p><p>3、名称要有特色。名称平实就可以接受，如果能体现一定的内涵，给浏览者更多的视觉冲击和空间想象力，则为上品。例如：音乐前卫，网页陶吧，e书时空等。在体现出网站主题的同时，能点出特色之处。</p><p>二、定位网站的CI形象</p><p>所谓CI(corporate identity)，意思是通过视觉来统一企业的形象。一个杰出的网站，和实体公司一样，需要整体的形象包装和设计。准确的，有创意的CI设计，对网站的宣传推广有事半功倍的效果。中国站长第一门户</p><p>三、确定网站的栏目</p><p>建立一个网站好比写一篇文章，首先要拟好提纲，文章才能主题明确，层次清晰。如果网站结构不清晰，目录庞杂，内容东一块西一块。结果不但浏览者看得糊涂，自己扩充和维护网站也相当困难。网站的题材确定后，并且收集和组织了许多相关的资料内容，但如何组织内容才能吸引网友们来浏览网站呢？栏目的实质是一个网站的大纲索引，索引应该将网 站的主体明确显示出来。</p><p>四、确定网站的目录结构</p><p>网站的目录是指你建立网站时创建的目录。例如：在用frontpage98建立网站时都默认建立了根目录和images(存放图片)子目录。目录结构的好坏，对浏览者来说并没有什么太大的感觉，但是对于站点本身的上传维护，内容未来的扩充和移植有着重要的影响。</p><p>五、确定网站的链接结构中国站长第一门户</p><p>网站的链接结构是指页面之间相互链接的拓扑结构。它建立在目录结构基础之上，但可以跨越目录。建立网站的链接结构有两种基本方式：</p><p>1、树状链接结构</p><p>类似DOS的目录结构，首页链接指向一级页面，一级页面链接指向二级页面。这样的链接结构浏览时，一级级进入，一级级退出。优点是条理清晰，访问者明确知道自己在什么位置，不会\"迷\"路。缺点是浏览效率低，一个栏目下的子页面到另一个栏目下的子页面，必须绕经首页。</p><p>2、星状链接结构</p><p>类似网络服务器的链接，每个页面相互之间都建立有链接。这种链接结构的优点是浏览方便，随时可以到达自己喜欢的页面。缺点是链接太多，容易使浏览者迷路，搞不清自己在什么位置，看了多少内容。中国站长第一门户<br/>&nbsp;</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 22:22:19','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('38','13','0','三合板是什么,三合板价格和规格','','','admin','1','0','','0','0','','0','','','','','2107','2014-10-11 16:30:47','admin','','/upload/images/201304/2107.jpg','1','1','关于一个网站的开展而言，跟着查找引擎越来越注重用户体验，良多的网站都邑更好的投合用户，然后添加一些比拟利于用户体验的插件，以及良多时分我们网站后期开展的需求，所以网站改版相对而言就会很必定。然则作为小我站长的我们，无论从技能、网站整顿的运作都是显得那么势单力薄。特殊是一些站长由于改版后招致网站降权，然后就懊悔万分，这些都是很经常见的，那么若何才干做到网站改版不降权呢?今日我与人人分享一些我在网站改版中的一些经历心得吧。
　　(一)改版也要包管网站正常拜访。
　　在我们对其网站改版的进程中，切勿封闭网站，招致蜘蛛无法抓取匍匐。然后降低网站的收录，以及降权。所以我们在对网站改版的进程中必然要包管网站可以正常拜访，而且包管内容的正常更新，外链的推行这些方面。
　　(二)应用当地测试的方法进行改版。
　　在我之前做站的时分发现良多站长直接在网站的效劳器上面临网站进行改版，大幅度的调试，完全疏忽了此时蜘蛛还在你的网站匍匐，然后惹起蜘蛛的恶感或许说是不信赖，招致网站降权从新审核。所以在这里，我引荐人人最好是在当地测试性的改版，等模板以及一些插件彻底的精确的调试终了之后，在直接上传到效劳器上面，如许不只仅可以包管在改版时期网站属于正常形态，还也到达了我们改版的目标。
　　(三)做好网站全体构造融洽。
　　关于有些站点而言，良多时分会晤临大幅度的改版，触及到网站一些栏目标途径调整等情况，在这时分我们需求严密的记载好网站栏目标之前途径，而且不要把之前的途径直接删除，可以做成301重定向的方法进行权重传输，而且关于新途径的话百度也是有审核期的，所以我们在做内链的时分尽能够的多引入蜘蛛匍匐，然后促使早日审核。
　　(四)网站题目很主要。
　　一般来说的话，我是不引荐人人修正网站题目的，由于这关系到整个网站的权重以及要害词排名问题，然则有时分不得已照样必需修正的，那么在这个时分我建议人人尽能够的小型变化，不然的话招致网站降权是一定的。还在这时分需求增强内链的根底性以及外链的辅佐性，只要如许才干更好的使其网站即使降权也能疾速恢复。
　　(五)网站改版后的推行任务。
　　关于网站改版之后而言，推行任务的量愈加需求加大，由于在我们改版之后网站同新站一样都是有一个审核期的，在这时期网站排名能够很不睬想，所以我们除了做好网站内部任务之外，推行任务也长短常要害的，然则人人必然切记我们推行出去的不是白费，必然要包管推行出去的外链都是质量性的，只要如许才干更好的使其网站恢复，渡过这个审核期。
　　(六)改版后必然要包管网站友链不会撤失落。
　　在我们改版后网站在面对审核期的时分，网站权重会降低，收录快照等方面也能够会有些缓慢，所以在这时分良多友链站长会把你的网站链接撤失落，招致网站被二次降权都是极为经常见的，所以在这里我想说的是，在我们对网站改版的时分必然要告诉你一切的友谊链接站长们，通知他你的目标，以及是审核期很快就会恢复的，不要他们撤失落你链接，如许就可以了，当然照样需求你人际关系咯，哈哈。
　　总结：其实关于网站改版而言，我们更多的照样需求留意到一些细节性的任务，更好的尊于用户体验的原则结构合理的网站，然后进行优化在到后期的推行恢复任务，这些都不是一朝一夕就可以完成的，照样需求我们有一颗好的心态积极的去面临。只要如许我们的网站才干做好，做强做大。','0','<p>关于一个网站的开展而言，跟着查找引擎越来越注重用户体验，良多的网站都邑更好的投合用户，然后添加一些比拟利于用户体验的插件，以及良多时分我们网站后期开展的需求，所以网站改版相对而言就会很必定。然则作为小我站长的我们，无论从技能、网站整顿的运作都是显得那么势单力薄。特殊是一些站长由于改版后招致网站降权，然后就懊悔万分，这些都是很经常见的，那么若何才干做到网站改版不降权呢?今日我与人人分享一些我在网站改版中的一些经历心得吧。</p><div>　　(一)改版也要包管网站正常拜访。</div><div>　　在我们对其网站改版的进程中，切勿封闭网站，招致蜘蛛无法抓取匍匐。然后降低网站的收录，以及降权。所以我们在对网站改版的进程中必然要包管网站可以正常拜访，而且包管内容的正常更新，外链的推行这些方面。</div><div>　　(二)应用当地测试的方法进行改版。</div><div>　　在我之前做站的时分发现良多站长直接在网站的效劳器上面临网站进行改版，大幅度的调试，完全疏忽了此时蜘蛛还在你的网站匍匐，然后惹起蜘蛛的恶感或许说是不信赖，招致网站降权从新审核。所以在这里，我引荐人人最好是在当地测试性的改版，等模板以及一些插件彻底的精确的调试终了之后，在直接上传到效劳器上面，如许不只仅可以包管在改版时期网站属于正常形态，还也到达了我们改版的目标。</div><div>　　(三)做好网站全体构造融洽。</div><div>　　关于有些站点而言，良多时分会晤临大幅度的改版，触及到网站一些栏目标途径调整等情况，在这时分我们需求严密的记载好网站栏目标之前途径，而且不要把之前的途径直接删除，可以做成301重定向的方法进行权重传输，而且关于新途径的话百度也是有审核期的，所以我们在做内链的时分尽能够的多引入蜘蛛匍匐，然后促使早日审核。</div><div>　　(四)网站题目很主要。</div><div>　　一般来说的话，我是不引荐人人修正网站题目的，由于这关系到整个网站的权重以及要害词排名问题，然则有时分不得已照样必需修正的，那么在这个时分我建议人人尽能够的小型变化，不然的话招致网站降权是一定的。还在这时分需求增强内链的根底性以及外链的辅佐性，只要如许才干更好的使其网站即使降权也能疾速恢复。</div><div>　　(五)网站改版后的推行任务。</div><div>　　关于网站改版之后而言，推行任务的量愈加需求加大，由于在我们改版之后网站同新站一样都是有一个审核期的，在这时期网站排名能够很不睬想，所以我们除了做好网站内部任务之外，推行任务也长短常要害的，然则人人必然切记我们推行出去的不是白费，必然要包管推行出去的外链都是质量性的，只要如许才干更好的使其网站恢复，渡过这个审核期。</div><div>　　(六)改版后必然要包管网站友链不会撤失落。</div><div>　　在我们改版后网站在面对审核期的时分，网站权重会降低，收录快照等方面也能够会有些缓慢，所以在这时分良多友链站长会把你的网站链接撤失落，招致网站被二次降权都是极为经常见的，所以在这里我想说的是，在我们对网站改版的时分必然要告诉你一切的友谊链接站长们，通知他你的目标，以及是审核期很快就会恢复的，不要他们撤失落你链接，如许就可以了，当然照样需求你人际关系咯，哈哈。</div><div>　　总结：其实关于网站改版而言，我们更多的照样需求留意到一些细节性的任务，更好的尊于用户体验的原则结构合理的网站，然后进行优化在到后期的推行恢复任务，这些都不是一朝一夕就可以完成的，照样需求我们有一颗好的心态积极的去面临。只要如许我们的网站才干做好，做强做大。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:30:47','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('8','13','0','我州开展出口食品农产品 国际标准培训','','','cmseasy','127','4','','0','0','','0','','','','','2102','2010-07-18 22:22:46','cmseasy','','/upload/images/201304/2102.jpg','1','1','网站建设合同是在网站建设项目中，企业（需要建网站方）和承建方（专业网站制作公司）之间共同确立的双方在项目中的权利，义务和合作内容的契约文件。本文就网站建设合同应该包含哪些主要内容，应该注意一些什么逐个做说明：         网站建设合同是在网站建设项目中，企业（需要建网站方）和承建方（专业网站制作公司）之间共同确立的双方在项目中的权利，义务和合作内容的契约文件。网站建设合同必须包含以下主要内容： 1）网站建设工作范围 2）网站建设工作流程与时间进度 3）网站建设质量要求 4）网站承建费用支付，支付标准与支付方式 下面就每一部分应该写明一些什么内容和注意一些什么点逐个做说明（合同其他部分如，违约形式与责任，合同附件里的《网','200','<p>&nbsp;网站建设合同是在网站建设项目中，企业（需要建网站方）和承建方（专业网站制作公司）之间共同确立的双方在项目中的权利，义务和合作内容的契约文件。本文就网站建设合同应该包含哪些主要内容，应该注意一些什么逐个做说明：</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 网站建设合同是在网站建设项目中，企业（需要建网站方）和承建方（专业网站制作公司）之间共同确立的双方在项目中的权利，义务和合作内容的契约文件。网站建设合同必须包含以下主要内容：<br/>1）网站建设工作范围<br/>2）网站建设工作流程与时间进度<br/>3）网站建设质量要求<br/>4）网站承建费用支付，支付标准与支付方式<br/>下面就每一部分应该写明一些什么内容和注意一些什么点逐个做说明（合同其他部分如，违约形式与责任，合同附件里的《网站建设方案书》本文不作讨论）。<br/>一、网站建设工作范围<br/>网站建设项目涉及到的工作一般包括，需求调研与《网站建设方案书》制作，网站建设素材准备，网站页面设计与制作，网站功能性部分程序开发与页面融合，数据库设计与数据输入，服务器购买（软件和硬件）或服务器空间租用、服务器存放，域名注册与解析。<br/>所先，在这些网站建设工作中，合同需要确定哪些是承建方的工作，哪些不是，哪些是企业或者第三方的工作，以及各方工作之间的合作方式和要求。<br/>这里需要注意的是，如果企业在工作中需要和建设方或者第三方进行合作，那么必须清晰说明这种合作的流程，方式和要求。譬如，如果网站建设素材由企业提供，合同必须对企业提供的素材内容，时间，要求作出清晰的说明。<br/>其次，对于承建方工作部分，必须细致地说明。<br/>例如，网站需要建设哪些栏目，每个栏目需要制作哪些内容，网站需要开发哪些功能性的程序（如BBS）等，对这些合同必须相当明确地作出说明。合同可以用建设方确认通过的《网站建设方案书》作为合同附录，来更详细阐明承建方的工作。<br/>二、项目建设工作流程与时间进度</p><p>网站建设流程一般流程为：需求调研，完成网站《网站建设方案书》，《方案书》确认，素材（文字，图片，数据）收集与整理，页面风格设计，风格设计确认，页面制作，程序开发，整合（页面，程序），建设方评估与测试，网站改进与建设方确认，服务器与域名准备，网站上传发布，网站维护。<br/>所先，合同必须说明项目开展的工作流程。<br/>其次，对于每个工作流程，需要概要说明承建方的工作内容，尤其对于需要企业参与的部分，需要说明企业的工作内容和要求。例如，需求调研时企业的配合和资源提供；设计制作确认时的确认方式和确认范围。<br/>最后，是对每个流程环节的完成时间要求说明。合同需要给出每个流程环节的工作估计以及项目最终完工的日期估计，双方可以根据需要，协商在进度限制上的严格度。<br/>三、网站建设质量要求<br/>网站建设质量主要指网站页面设计，制作与网站程序的质量。合同需要对这些工作的质量作出周到的，尽量可度量的要求，譬如为保证浏览速度，建设方也可以对每个网页的大小作出一般性限制。<br/>对于页面设计与制作，由于对设计风格的认识差异会导致建设方和承建方的质量评判结果不同，同时设计质量也难以度量，容易出现建设方多次否定设计的情况。在这个时候需要用变通的办法来弥合双方的质量评判差异。<br/>例如，可以由承建方设计出5种建设方要求风格的设计页面，然后由建设方选择，或者重复修正设计不能超过5次，而承建方可以以半价收取落选设计页面费用的代价来限制设计要求的变化。<br/>还有一种办法，就是采取第三方来度量页面设计与制作质量。例如，找一些普通的上网用户，测试他们成功搜索网站中某个特定内容所需要的时间，用这个时间来衡量网站连接设计质量和合理性。例如，可以通过在门户网站做网上调查，由网民来评判网站设计与制作质量，这样做同时也很好地宣传了网站。<br/>而对于网站功能性程序来说，合同应该对功能作出详细的说明。如会员注册登陆系统，那么除了会员的注册，登陆，退出外，系统还应该提供给会员什么功能，譬如新闻定制等。这部分可以在《网站建设方案书》里作出更详细的说明。<br/>如果，网站承建方同时提供虚拟主机空间，那么企业还可以对网站访问速度，宕机时间，网站带宽等方面作出要求（空间租用双方一般也可以另签《网站空间租用合同》）。</p><p>四、网站承建费用支付，支付标准与支付方式<br/>网站建设业内一般采用按制作量记费的方式，譬如按页面数量记费。<br/>但网站制作量，如页面数量等，在制作过程中是变化的，所以在签合同的时候无法给出整个网站建设完成后的确切费用。但是合同却可以给出网站建设的收费项和收费标准，等网站建设完成后，统计整个网站的每项工作量，再结合记费标准来算出项目实际标的。<br/>所先，确定网站建设收费项。网站建设收费项一般可以包括以下一些：<br/>1）素材整理阶段的文字录入费，图片处理费，翻译费<br/>2）《网站建设方案书》制作费用<br/>3）普通页面制作费用<br/>4）页面风格设计费用（一般指主页和栏目首页）<br/>5）页面特效制作费用（譬如JavaScript，Flash等）<br/>6）功能性程序开发费用（如调查系统，会员注册系统等）<br/>7）数据库数据录入费用<br/>8）空间租用费用等。<br/>其次，确定每个收费项的单位价格。例如，文字翻译每千字50元等。<br/>这一条款关系到日后合同标的的计算，所以务必非常清晰，双方不妨多花一点时间来协商这里的细节，以达到彼此在这一条款上的一致认可，以妨日后引起不必要的争执。为了做到这一点，我认为原则就?quot;细\"。譬如，必须定义怎么算作一个页面，是1024下的800*600，还是800*800？如果是800*600，那么一个800*1200的页面就算做两页；这是一个协商的过程，这样计算是否合理，我觉得只要双方都同意这样计算就没有问题，关键是必须使得日后统计制作量和计算合同标的时双方没有歧义。<br/>费用支付一般可以分成三次进行。一般合同签署一周内支付一定数量，作为项目启动费用；项目中期支付一定数量；项目结束后，计算项目实际标的，再支付余额。<br/>如前面所说，作为网站建设项目的建设合同还需要其他很多条款和辅助合同，如：《空间租用合同》等，但是以上谈到四点却是合同里最重要，也是最需要\"细扣\"的内容，希望大家以后在撰写网站建设合同时能从中获得一点帮助。<br/>&nbsp;</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2010-07-18 22:22:46','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('9','13','0','主题酒店设计是主题公园与酒店的完美结合-主题酒店设计','','','cmseasy','127','227','','0','0','','0','','','','','2101','2011-11-27 02:50:29','cmseasy','','/upload/images/201304/2101.jpg','1','1','主题酒店作为一种正在兴起的酒店发展新形态，在国外已有近50年的历史，而在我国的发展历史不长，分布范围目前也仅仅局限在酒店业比较发达的广东、上海、深圳等地。有以回归大自然、科技或怀旧为主题的酒店，都体现出与众不同的经营特色。虽然主题酒店在我国的出现属于新鲜事物，但是在国际酒店业中属于一种发展新趋势。从国内仅有的几家主题酒店经营情况来看，经营状况均好于其他酒店。面对前景如此光明的主题酒店，重庆主题酒店设计师对主题酒店的规划设计进行解析，给正在发展的主题酒店提供一点中肯的“炮灰”。本文从引入主题、定位主题、展示主题、合理配置功能等几部分来阐述。
','200','<p>主题酒店作为一种正在兴起的酒店发展新形态，在国外已有近50年的历史，而在我国的发展历史不长，分布范围目前也仅仅局限在酒店业比较发达的广东、上海、深圳等地。有以回归大自然、科技或怀旧为主题的酒店，都体现出与众不同的经营特色。虽然主题酒店在我国的出现属于新鲜事物，但是在国际酒店业中属于一种发展新趋势。从国内仅有的几家主题酒店经营情况来看，经营状况均好于其他酒店。面对前景如此光明的主题酒店，重庆主题酒店设计师对主题酒店的规划设计进行解析，给正在发展的主题酒店提供一点中肯的“炮灰”。本文从引入主题、定位主题、展示主题、合理配置功能等几部分来阐述。</p><p>一、引入主题</p><p>&nbsp; &nbsp; 
主题酒店也称“特色酒店”，是以某一特定的主题，来体现酒店的建筑风格和装饰艺术，以及特定的文化氛围，让顾客获得富有个性的文化感受，同时将服务项目融入主题，以个性化的服务取代一般化的服务，让顾客获得欢乐、知识和刺激。历史、文化、城市、自然、神话、童话故事等都可以成为酒店借以发挥的主题。</p><p>二、定位主题</p><p>&nbsp; &nbsp; 
在做景区规划时，首先要确定她的发展方向及定位，才能在众多的竞争者中脱颖而出，做强做大。同样，主题酒店亦是如此，只不过当其位于景区之内时，更多的是依附于景区的主题定位，与之相呼应，为其服务。当她位于城市区或者不仅仅依附于景区而存在，主题酒店的准确定位显得尤为重要，所要考虑的问题也较多。杭州“梦幻城堡”是个因主题定位不准而失败的典型案例。</p><p>&nbsp; &nbsp; 
2003年年底，计划耗资15亿元人民币、号称“中国首座超五星酒店”的“梦幻城堡”本应从杭州萧山区传来开工的消息，不料却被杭州有关方面宣布其计划流产。有关人士称：“由于方案改变，‘梦幻城堡’不能再建。”“梦幻城堡”原计划是杭州2006年世界休闲博览会的标志性建筑，占地13万平方米，高100多米，其投资方是著名民营企业宋城集团。而其设计者，更是设计过世界最大酒店(米高梅大酒店)的美国著名设计师威尔登·辛普逊先生。</p><p>&nbsp; &nbsp; 
这种超豪华的设计，理应是成功的典范，但却以失败而告终。究其失败的根源，不是说她没有定位，而在于其犯了两个定位上的致命伤。一是主题过于超前脱离市场定位：杭州作为休闲之都，又地处于长江三角洲的中心区域，所以定位在长江三角洲地区休闲散客和商务会议客是合理的。而“梦幻城堡”的主题选择却不支持这一定位，其超五星的建设将远远超出休闲市场的消费能力。二是主题过于异类脱离城市定位：杭州是个优美而宁静的江南水乡，是个现代休闲城市；而“梦幻城堡”以“梦幻”为主题，豪华且气势磅礴，与根植于生活的温馨舒适的休闲气氛相反，追求一种远离现实的体验。她的错在于没有考虑到所在城市的形象定位和城市规划，那么失败也是理所当然。</p><p>&nbsp; &nbsp; 
在准确定位主题酒店过程中，应从几方面着手寻找。一是注意密切关注竞争对手，避免主题定位相似；二是深度挖掘主题内涵，避免形式大于内容；三是主题有酒店适应性，避免定位本末倒置；四是主题适当回避“尘世”，避免陷入大众俗套。当较好地把握住了以上四点的时候，才能说把准了一个主题酒店的定位。</p><p>&nbsp; &nbsp; 
深入展示主题，抓住主题酒店定位之后，就必须考虑如何让游客领略到酒店的主题魅力，这就要求主题酒店进行自我展示。一个成功的主题酒店能够通过其主题环境与氛围来展示主题概念。换句话说，主题环境与氛围是主题概念的物化。既可以通过主题建筑、主题景观等外在实物的表征来透视酒店的主题，也可以透过主题装饰物等内部的实物表象来展示酒店的主题。但均需精挑细选，严格把关，做到尽善尽美，和谐一致，才能烘托出一个惟妙惟肖的主题环境与氛围。</p><p>三、主题建筑、主题景观和环境协调</p><p>&nbsp; &nbsp; 
重庆主题酒店设计师认为主题建筑是主题酒店的有形展示，在顾客首次购买时起着关键性作用。主题建筑除了要追求独特外，还应该把握好和周边地理环境的协调性，与周边环境的协调本身也是顾客体验的一部分。下面介绍以自然风光为背景的两个主题酒店，其主题建筑和主题景观均与主题环境相符合，被证明是成功的。</p><p>木屋·肯尼亚树顶旅馆</p><p>&nbsp; &nbsp; 
早期的树顶旅馆完全搭建在几棵大树杈上，目前的建筑仍为全木结构，只是大树杈换成了数十根大木柱。建筑底层吊空，上有三层客房。顶层观景平台正对着肯尼亚山白雪皑皑的山顶。旅馆前面有大水塘，是大象、犀牛、白尾猴、狒狒饮水、补充盐分的地方，是人与动物和谐相处的最好镜头。特别是晚间，旅游会打开探照灯照亮楼下空地，工作人员把盐撒在地上，几十头大象就会争先恐后地用长鼻子卷食，游客可在树顶旅馆中观看给大象喂食盐的这一项特别表演。&nbsp;</p><p>&nbsp; &nbsp; 
位于奥地利东南的布鲁毛罗格纳温泉酒店的座右铭是“微妙的不同”，它带给房客的视觉震撼力实在是“大不同”。奥地利建筑艺术家百水先生（Hundertwasser）的风格在这里发挥得淋漓尽致：一组Wald鄄hofhaeuser公寓群，竟将房舍嵌进了地下，如同一座座土拨鼠的地穴；别墅群的顶端种植着绿茸茸的草坪和灌木，甚至连窗户里都会探出一棵棵的树来，对建筑的认识被彻底颠覆。游客从温泉酒店的游泳池一路游到温泉池，可体验到百水先生设计的无规则水路忽左忽右、忽上忽下的变化，眼前的景致一会儿是波斯宫殿，一会儿又变成了斑马小屋，令你忘记人世间所有的游戏规则。</p><p>&nbsp; &nbsp; 
当然除了自然风光酒店外，还有名人文化酒店、历史文化酒店、城市特色酒店和艺术特色酒店等等。各种主题类型的酒店的不同，其所要展现的主题建筑与主题景观亦不同。但主题景观和主题建筑的和谐一致能够对主题起到渲染作用，达到锦上添花的效果。</p><p>四、主题装饰物</p><p>&nbsp; &nbsp; 
从某种程度上讲，主题酒店是主题公园与酒店的完美结合，迪斯尼主题酒店是一个很好的例子，现在主题酒店的一种发展模式就是依托成功的主题公园进行经营，深圳的威尼斯酒店就是如此。而作为内部的实物表象，员工工服是主题氛围的重要表现之一，因为员工是流动的主题符号。除了员工工服，主题装饰物与灯光和色彩的合理搭配，都能给顾客美好的主题氛围体验。</p><p>五、合理配置功能</p><p>&nbsp; &nbsp; 
通过对主题定位的把握，对主题建筑及主题景观的理念的理解，围绕着主题这条线索来将他进行分解，通过合理配置功能来完善主题酒店的规划设计。</p><p>&nbsp; &nbsp; 
酒店按服务区域划分，一般分客房区、餐饮区、公共活动区、会议和展览区、健身娱乐区、行政后勤区。这些区域既要划分明确，又要有机联系。</p><p>&nbsp; &nbsp; 
酒店从经营角度讲，酒店由收益部分和非收益部分构成，当总建筑面积确定之后，面积结构应精心安排以下几个部分：客房部分包括单床房、双床房、双人房、各种套房等。餐饮部门包括主餐厅、副餐厅、主酒吧、俱乐部、鸡尾酒室、咖啡室等，另外应包括与宴会有关的大、中、小宴会厅；其它营业部门，包括会议室、健身设施、桑拿、美容、游泳池、洗衣部、商业中心等。非收益部分包括，大堂、总服务台、办公室、行李房、电话总机室、电脑室、仓库、更衣室、医务室、职工食堂、锅炉房、停车场、洗车场等。</p><p>&nbsp; &nbsp; 
一家好的酒店，除了造型独特，外形美观，与当地环境融为一体，有深刻的文化内涵之外，就是酒店的内部功能布局非常合理，每一项功能所占的位置恰到好处，既方便客人使用，又便于经营者进行管理，既不浪费面积，又体现酒店浓郁的服务氛围，客人住后感到满意，经营者节约了大量人力。总的来说，就是要掌握酒店内部的功能分配的十分合理，完全具备方便客人和便于管理的要求。而其功能布局要注意以下几点：</p><p>&nbsp; &nbsp; 
（1）员工和客人各行其道互不交叉，包括行李入口也要与客人分开。当客人进入大堂，马上映入眼帘的是总服务台。当在总台办完入住手续之后，顺路进入电梯厅，乘电梯到达所住楼层。而员工呢，从员工入口进入酒店，第一步打卡，第二步更衣，第三步从员工通道乘员工专用电梯进入各自的工作岗位，员工与客人会各自行走，不会发生碰撞现象。安排通道不仅员工与客人分开，员工通道也要注意把人与物分开。酒店的库房一般都在地下，员工出入拿东西、送货要分成上、下道，不要人物混杂，不然既影响工作，又容易出事故。</p><p>&nbsp; &nbsp; 
（2）各项功能，各就其位，既不浪费面积，又安排得非常恰当。一家酒店的大堂，应是功能最多的。除了总服务台、礼宾部、行李柜台，还有大堂酒吧或茶座，咖啡厅，其至商务中心、鲜花店、书屋、精品店都要安排在大堂附近。对于西餐厅、封闭酒吧、风味餐厅的安排要与桑拿健身、泳池分别在不同楼层，不要相隔太近，不要安排在同一个楼层。有的酒店把这种不同的功能安排在同一楼层，各种不同的味道相互影响，严重影响了酒店形象，客人也非常不满意。</p><p>&nbsp; &nbsp; 
（3）从客人需求的连续性布局功能。上述提到的几家酒店都具有这样特点，如将健身房安排在与游泳池较近的地方，西餐厅与封闭酒吧、咖啡厅安排在较近的地方，零点餐厅安排在一楼，中餐厅，风味厅靠近，多功能厅与会议室安排在同一楼层，这种安排充分考虑了客人需求的连续性。有些饭店在功能布局上没有相互照应，只是根据面积大小来布局，结果形成同类功能过于分散，不方便客人使用。</p><p><br/></p>','archive/show.html','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 02:50:29','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('10','8','2','美式风格四居室家居装修设计效果图','','','cmseasy','127','3','','0','0','','0','','','','','3103','2011-11-27 03:31:43','cmseasy','','/upload/images/201304/3103.jpg','1','1','','200','<p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710970922048.jpg\" title=\"14710970922048.jpg\" alt=\"21705552_1463630005218_690x460.jpg\"/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','82','116','124','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:31:43','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('11','8','2','混搭风格的家居设计','','','cmseasy','127','0','','0','0','','0','','','','','3105','2011-11-27 03:31:19','cmseasy','','/upload/images/201304/3105.jpg','1','1','','200','<p>在家居设计中有些突破常规的设计往往能让人过目不忘。如果是运用在家里那么最终效果也是令人称赞的。如果你喜欢新奇的事物，喜欢新奇的设计，完全可以尝试将自己的家引入与众不同的设计，今天小编也收集了不少设计，一起来看看吧。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710979782797.jpg\" title=\"14710979782797.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p>看到这样的设计你会怎么想呢，是不是觉得墙面破损了呢。其实这是个性的灯光设计，要设计这样的效果并非易事，整面墙都要与之配合。嘘......我家墙里藏的可都是黄金......</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710979867904.jpg\" title=\"14710979867904.jpg\" alt=\"16663664.jpg\"/></p><p><br/></p><p>如果将墙壁设计成这个样子你进入客厅便会感觉到一种不一样的氛围。想象过你的墙壁充满灯光，好了现在就可以这样做，这个壁灯与天花衔接，是一种功能性和装饰性都不错的灯具。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710979934278.jpg\" title=\"14710979934278.jpg\" alt=\"16663666.jpg\"/></p><p><br/></p><p>这样的的灯具很个性，像一个木桩，木桩上的纹理又像山上的盘山公路。有很多很酷的灯具阿联都可以找到，但这个雕塑灯留下了深刻了印象，再生木材打造，每一件都是独一无二。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:31:19','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('12','8','2','蓝色与黑白色彩在家居设计中应用','','','cmseasy','127','3','','0','0','','0','','','','','3106','2011-11-27 03:31:11','cmseasy','','/upload/images/201304/3106.jpg','1','1','','200','<p>&nbsp; &nbsp; 蓝色，是一种令人产生遐想的色彩。传统的蓝色常常成为现代装饰设计中热带风情的体现。蓝色还具有调节神经、镇静安神的作用。蓝色清新淡雅，与各种水果相配也很养眼，但不宜用在餐厅或是厨房，蓝色的餐桌或餐垫上的食物，总是不如暖色环境看着有食欲;同时不要在餐厅内装白炽灯或蓝色的情调灯，科学实验证明，蓝色灯光会让食物看起来不诱人。但作为卫浴间的装饰却能强化神秘感与隐私感。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710981689956.jpg\" title=\"14710981689956.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710981825413.jpg\" title=\"14710981825413.jpg\" alt=\"16644785.jpg\"/></p><p>　　</p><p>&nbsp; &nbsp; 黑白配的房间很有现代感，是一些时尚人士的首选。但如果在房间内把黑白等比使用就显得太过花哨了，长时间在这种环境里，会使人眼花缭乱，紧张、烦躁，让人无所适从。最好以白色为主，局部以其他色彩为点缀，空间变得明亮舒畅，同时兼具品位与趣味。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710981925474.jpg\" title=\"14710981925474.jpg\" alt=\"16663666.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:31:11','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('13','8','2','万万想不到的奇幻家居设计','','','cmseasy','127','1','','0','0','','0','','','','','3107','2011-11-27 03:31:02','cmseasy','','/upload/images/201304/3107.jpg','1','1','','200','<p>很多人都会对心中理想的住宅有所构想，但往往当我们有能力设计自己的理想住宅时，我们已没有亲自打造它的时间了；但国外有些人却做到了。看看下面这些奇幻的家居设计，有没有和你儿时的构想重合了呢？</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710983543160.jpg\" title=\"14710983543160.jpg\" alt=\"16663664.jpg\"/></p><p><br/></p><p>这座漂流屋的灵感来自于大自然，全景视野加上悠闲的生活态度给人奢华的享受，此外这座漂流屋也能随意更动位置，里头的格局也能视顾客的要求而做改变，堪称是完美的豪华家居。</p><p>水泥钢筋的建筑出现在水面上自然有违视觉的和谐感，因此设计师决定选用通透的玻璃幕墙来分隔室内外，并且运用木质内墙、地板、天花板配搭温暖柔和的暗黄灯光降低违和感，仿佛这只是海面上的一艘船，几乎与水面齐平的底层甲板让周遭景色与“Floating house”实现了无缝衔接，自在不拘束，能够灵活移动，还能毫无阻挡地感受到海面波光与自然光的流动，非常适合亲水一族。</p><p><br/></p><p>摄影师Nick Olson和设计师Lilah Horwitz花了几个月的时间收集各种不同的造型窗户，最后的成果如你所见非常特别又梦幻。</p><p>想要做到在室内不受限制地感受阳光的洗礼，房屋墙体的限制是一大阻碍，因此他们将面湖的房屋正面改由形形色色的旧窗户拼接而成。经过数月的体力劳动和省吃俭用之后，成品终于出炉，虽然整个房子只花了大概$500美元建成，窗户略旧，室内的墙面也和打了无数补丁一样，与传统意义上的度假屋相去甚远，但那份朴素与恬静正正迎合了这远离烦嚣的乡间。</p><p><br/></p><p>这间湖中小屋第一次被发现的时候是在1968年，一群年轻的泳客发现这间仅有单人房的屋子，虽然它无法被称做一间完美的家，不过对在这座湖里玩耍的游客来说，是一个很棒的休憩场所。不知道当初建造这栋小屋出来的人，是抱着什么目的呢？</p><p><br/></p><p>摄影师Simon Dale花了3000英镑和家人一起打造出电影《The Lord of the Rings》里Hobbit的家，整间房子都使用环保性材料，除了非常有特色之外，也巧妙的跟自然融为一体。</p><p><br/></p><p>为了打造他的梦想家居，不眠不修的连续工作6个星期，整座房子除了外观特别之外，里面所见之处的东西全都取自于大自然。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:31:02','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('14','8','2','家居设计巧藏巧露','','','cmseasy','127','1','','0','0','','0','','','','','3108','2011-11-27 03:30:32','cmseasy','','/upload/images/201304/3108.jpg','1','1','','200','<p>藏真露假：有的客厅门洞开得过多，会显得凌乱，将进出不是很频繁的房间门加以隐藏，会增加整体感。可用一带滑轨的假书橱来掩饰，尽管假书橱的厚度可能显得不够，一般外人也不易发现破绽，如房间的窗户过小，可在适当的墙面上利用装饰画“露”出一个假窗来，同样会增添一种开放的感觉。 当然最常见的还是隐形门的运用，像这边墙绘中间就藏着一扇门。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710985245053.jpg\" title=\"14710985245053.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p>藏笨露精：如今不少家庭都拥有了彩电、冰箱、音响、空调等家用电器，通常家电以实用为主，这些笨重的东西已不再是富足的象征，失去了装饰作用，如将它们巧妙地“藏”在木制柜橱、木制花格档板之后，并能很方便地抽出推进，既美观又可节省空间。</p><p><br/></p><p>藏灯露影：大型的花卉有极好的装饰效果，可在其下方设置一至数个射灯，将花卉的影子投射到天花板或墙壁上，能强调其效果。当夏夜的微风吹来，会增添一种树影婆娑的生动美感。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710985321169.jpg\" title=\"14710985321169.jpg\" alt=\"16644785.jpg\"/></p><p><br/></p><p>藏重露轻：由于建筑结构等原因，有的室内天花板上会留有难看的“过梁”，造成一种生硬的沉重感。解决的方法是用装饰材料将其包装成曲线、曲面状，或可用造型独特的吊顶来遮盖，从而使天花板的败笔在艺术创意中变得轻盈起来。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:30:32','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('15','8','1','春天扮美家 绿色可是必不可少的利器','','','cmseasy','127','773','','0','0','','1','','','','','3101','2011-11-27 03:37:10','cmseasy','','/upload/images/201304/3101.jpg','1','1','提到春天，大家肯定首先会想到绿色，绿色的小草、绿色的树木，一切都焕发出勃勃生机。虽然时下天气仍热有些寒冷，但实际早已入春，大家不妨对家居做一些改造，为家中也增添一些绿色的家具或饰物，让家居也感受到春日的勃勃生机。
','200','<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">提到春天，大家肯定首先会想到绿色，绿色的小草、绿色的树木，一切都焕发出勃勃生机。虽然时下天气仍热有些寒冷，但实际早已入春，大家不妨对家居做一些改造，为家中也增添一些绿色的家具或饰物，让家居也感受到春日的勃勃生机。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><img src=\"/upload/images/201608/14703006621401.jpg\" style=\"border: 0px none; vertical-align: middle; max-width: 100%; height: auto; display: block; margin: 10px auto;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">客厅布置的小巧精致，墙面粉刷为简单的白色，搭配上轻盈的木色、灰色，给人的感觉轻松舒适。苹果绿是所有色彩中的点睛之笔，苹果绿的窗帘、抱枕点缀其中，营造出生机勃勃的感觉。洁白的砖块堆砌形状的沙发背墙，既属于客厅的一道装饰设计，又是区分客厅与餐厅空间机能的分界线。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><img src=\"/upload/images/201608/14703006632084.jpg\" style=\"border: 0px none; vertical-align: middle; max-width: 100%; height: 477px; display: block; margin: 10px auto; width: 550px;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">餐厅的椅子上同样也放了苹果绿的椅垫，和窗帘相互映衬，让人的心情瞬间明朗起来。依傍窗前就餐，白天有阳光为伴，晚上有夜景作陪，好不巧妙，与大自然的接触，仿佛触手可及。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><img src=\"/upload/images/201608/14703006648954.jpg\" style=\"border: 0px none; vertical-align: middle; max-width: 100%; height: 550px; display: block; margin: 10px auto; width: 523px;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">厨房为狭长型空间，墙体、橱柜和地板都是白色设计，从视觉上让空间更加开阔，同时给人明亮干净的空间质感。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><img src=\"/upload/images/201608/14703006651254.jpg\" style=\"border: 0px none; vertical-align: middle; max-width: 100%; height: auto; display: block; margin: 10px auto;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">卧室间的床头背景墙同样刷成了鲜艳的苹果绿，十分抢眼，一进房间就能看到，在搭配的黄色灯光和温润的木质家具，整个卧室空间弥漫出温馨气氛。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><img src=\"/upload/images/201608/14703006666178.jpg\" style=\"border: 0px none; vertical-align: middle; max-width: 100%; height: auto; display: block; margin: 10px auto;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51);-- line-height: 30px; text-indent: 32px; font-family: 微软雅黑; white-space: normal;\">卧室连接一个南向阳台，大块的落地玻璃窗设计，满足了采用需求，在阳台处，一桌一椅便可轻松享受午后的休闲时光。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:8:{i:1;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-1.jpg\";s:3:\"alt\";s:0:\"\";}i:2;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-2.jpg\";s:3:\"alt\";s:0:\"\";}i:3;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-3.jpg\";s:3:\"alt\";s:0:\"\";}i:4;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-4.jpg\";s:3:\"alt\";s:0:\"\";}i:5;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-5.jpg\";s:3:\"alt\";s:0:\"\";}i:6;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-6.jpg\";s:3:\"alt\";s:0:\"\";}i:7;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-7.jpg\";s:3:\"alt\";s:0:\"\";}i:8;a:2:{s:3:\"url\";s:37:\"/upload/images/201304/duotu3101-8.jpg\";s:3:\"alt\";s:0:\"\";}}','','82','116','124','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:37:10','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('16','10','1','雅致中的别样韵味','','','cmseasy','127','3','','0','0','','0','','','','','3201','2011-11-27 03:30:22','cmseasy','','/upload/images/201304/3201.jpg','1','1','','200','<p>当传统与现代碰撞会擦出别样的火花，新中式风格就是传统与现代相结合的产物，这种风格非常讲究住宅的细节装饰，尤其是在面积较小的住宅中，往往可以达到更理想的效果。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710987636464.jpg\" title=\"14710987636464.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p>客厅是传统与现代居室风格的碰撞，设计师以现代的装饰手法和家具，结合古典中式的装饰元素，来呈现亦古亦今的空间氛围。中式风格的古色古香与现代风格的简单素雅自然衔接，使生活的实用性和对传统文化的追求同时得到了满足。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710989539238.jpg\" title=\"14710989539238.jpg\" alt=\"16663664.jpg\"/></p><p><br/></p><p>几乎所有的家居设计中，都未跳过书房这一环节。当家居设计的大部分环节都只在表现其本身的功能与形态时，书房的设置却总是极有分寸而又极其丰富地传达着家居主人的内心，从而提升了主人的身份与品位。</p><p><br/></p><p><br/></p><p>中式装饰材料以木质为主。讲究雕刻彩绘、造型典雅。餐桌的设计很别致，仿古风格的设计让整个餐厅的格调提升。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710989674462.jpg\" title=\"14710989674462.jpg\" alt=\"16644785.jpg\"/></p><p><br/></p><p>居室在色彩方面秉承了传统古典风格的典雅和华贵，但与之不同的是加入了很多现代元素，呈现着时尚的特征。在配饰的选择方面更为简洁，少了许多奢华的装饰，更加流畅地表达出传统文化中的精髓。为了给居室增添几分暖意。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:30:22','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('17','10','1','复古巴洛克风格的回归','','','cmseasy','127','0','','0','0','','0','','','','','3202','2011-11-27 03:30:14','cmseasy','','/upload/images/201304/3202.jpg','1','1','','200','<p>巴洛克风格是欧洲文艺复兴时期所流行的一种艺术风格，其复杂的曲线与华丽装饰，我们经常可以在皮鞋的设计上看到巴洛克纹理，其实在家居设计上也同样可以显示出巴洛克风韵的绝美，今天小编分享的家居案例便是一个以巴洛克风格为核心的家居设计。</p><p>复古风的逆袭 巴洛克风格家居设计</p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710993259223.jpg\" title=\"14710993259223.jpg\" alt=\"16644785.jpg\"/></p><p><br/></p><p>巴洛克风格是欧洲文艺复兴时期所流行的一种艺术风格，其复杂的曲线与华丽装饰，我们经常可以在皮鞋的设计上看到巴洛克纹理，其实在家居设计上也同样可以显示出巴洛克风韵的绝美，今天小编分享的家居案例便是一个以巴洛克风格为核心的设计案例，仅仅是华丽的曲线与装饰还不够，设计师融入了古典气息让人梦回那个大师辈出的年代。</p><p>家居设计\">复古风的逆袭 巴洛克风格家居设计</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710993344336.jpg\" title=\"14710993344336.jpg\" alt=\"16663664.jpg\"/></p><p><br/></p><p>设计师主要是通过空间基底来表现复古风格的，看整个空间布局上是不是有一种宫殿般的感觉。而在颜色选择上，设计师以轻色调即白色与浅棕色以及金色为表现巴 洛克之美。首先先看到客厅与书房之间的界线，设计师以玻璃材质，三种不同的颜色交织设计的气势。而宝格丽大理石又是点睛之笔，壁炉一般的电视墙奢华味浓厚。 复古风的逆袭 巴洛克风格家居设计</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710993416286.jpg\" title=\"14710993416286.jpg\" alt=\"14710987636464.jpg\"/></p><p><br/></p><p>这个家居真的非常精致，不仅在设计风格，也在装饰的选材上，小编第一次知道宝格丽除了珠宝原来也是卖家居材料的。当我们的视线从地板满满的品味到天花板上时，再一次被精巧的工艺所折服。天花板上的每一处走线都配上了浮雕线板勾勒与滚边，这一切营造出公共空间的细腻质感。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:30:14','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('18','8','2','体验现代家居生活','','','cmseasy','127','40','','0','0','','1','','','','','3102','2011-11-27 03:32:03','cmseasy','','/upload/images/201304/3102.jpg','1','1','','200','<p>　　当清晨的阳光洒向你的窗户，这是一天的开始。家是一天的起点，也是终点。</p><p>当你回到家，迎接你的是家人最纯真的笑脸，它让你忘却一切烦恼。掌上明珠家居现代生活方式正要为您提供便捷、舒适的生活方式，让家人时时陪伴在您身边。</p><p>　　追求华丽、高雅的古典风格。居室色彩主调为白色。家具为古典弯腿式，家具、门、窗漆成白色。擅用各种花饰、丰富的木线变化、富丽的窗帘帷幄是西式传统室内装饰的固定模式，空间环境多表现出华美、富丽、浪漫的气氛。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710969889257.jpg\" title=\"14710969889257.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p>　　现代美式风格特点</p><p><br/></p><p>　　1、客厅简洁明快</p><p><br/></p><p>　　客厅作为待客区域，一般要求简洁明快，同时装修较其它空间要更明快光鲜，通常使用大量的石材和木饰面装饰;美国人喜欢有历史感的东西，这不仅反映在软装摆件上对仿古艺术品的喜爱，同时也反映在装修上对各种仿古墙地砖、石材的偏爱和对各种仿旧工艺的追求上。总体而言，美式田园风格的客厅是宽敞而富有历史气息的。</p><p><br/></p><p>　　2、厨房开敞</p><p><br/></p><p>　　厨房在美国人眼中一般是开敞的(由于其饮食烹饪习惯)，同时需要有一个便餐台在厨房的一隅，还要具备功能强大又简单耐用的厨具设备，如水槽下的残渣粉碎机，烤箱等。</p><p><br/></p><p>　　需要有容纳双开门冰箱的宽敞位置和足够的操作台面。在装饰上也有很多讲究，如喜好仿古面的墙砖、橱具门板喜好用实木门扇或是白色模压门扇仿木纹色。另外，厨房的窗也喜欢配置窗帘等。</p><p><br/></p><p>　　3、卧室布置温馨</p><p><br/></p><p>　　美式家居的卧室布置较为温馨，作为主人的私密空间，主要以功能性和实用舒适为考虑的重点，一般的卧室不设顶灯，多用温馨柔软的成套布艺来装点，同时在软装和用色上非常统一。</p><p><br/></p><p>　　4、书房简单实用</p><p><br/></p><p>　　美式家居的书房简单实用，但软装颇为丰富，各种象征主人过去生活经历的陈设一应俱全，被翻卷边的古旧书籍、颜色发黄的航海地图、乡村风景的油画、一支鹅毛笔……即使是装饰品，这些东西也足以为书房的美式风格加分。家庭室：家庭室作为家庭成员休息交流的中心，属私密性很强的空间，一般设于餐厅旁，并有电视机，同时沙发和座椅选择轻松明快的式样，室内绿化也较为丰富，装饰画较多。</p><p><br/></p>','archive/show_pic.html','0','0','','0','0','','','','','0','','','0','N;','','82','116','124','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:32:03','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('19','10','0','家居设计找灵感','','','cmseasy','127','0','','0','0','','0','','','','','3203','2011-11-27 02:19:39','cmseasy','','/upload/images/201304/3203.jpg','1','1','','200','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711004339613.jpg\" style=\"\" title=\"14711004339613.jpg\"/></p><p><br/></p><p><br/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711004337936.jpg\" style=\"\" title=\"14711004337936.jpg\"/></p><p><br/></p><p><br/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711004331250.jpg\" style=\"\" title=\"14711004331250.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 02:19:39','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('24','8','1','自由开阔家居设计 美式经典植入纽约时尚','','','cmseasy','1','2','','0','0','','0','','','','','3104','2011-11-27 03:31:31','cmseasy','','/upload/images/201304/3104.jpg','1','1','','0','<p>落地原木书柜，垂直的空间动线分配不同机能需求，有效的建立空间开放感受;线条柔软的窗幔及现代感的画作调和空间的冷硬，提供简洁温润的氛围;大面积景观窗以不同角度撒入充沛光线、释放视野，纾解空间压迫感。</p><p>在家居设计中有些突破常规的设计往往能让人过目不忘。如果是运用在家里那么最终效果也是令人称赞的。如果你喜欢新奇的事物，喜欢新奇的设计，完全可以尝试将自己的家引入与众不同的设计，今天小编也收集了不少设计，一起来看看吧。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710975512833.jpg\" title=\"14710975512833.jpg\" alt=\"94387_hui.jpg\"/></p><p><br/></p><p>看到这样的设计你会怎么想呢，是不是觉得墙面破损了呢。其实这是个性的灯光设计，要设计这样的效果并非易事，整面墙都要与之配合。嘘......我家墙里藏的可都是黄金......</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14710975609544.jpg\" title=\"14710975609544.jpg\" alt=\"21705552_1463630005218_690x460.jpg\"/></p><p><br/></p><p>如果将墙壁设计成这个样子你进入客厅便会感觉到一种不一样的氛围。想象过你的墙壁充满灯光，好了现在就可以这样做，这个壁灯与天花衔接，是一种功能性和装饰性都不错的灯具。</p><p><br/></p><p><br/></p><p>这样的的灯具很个性，像一个木桩，木桩上的纹理又像山上的盘山公路。有很多很酷的灯具阿联都可以找到，但这个雕塑灯留下了深刻了印象，再生木材打造，每一件都是独一无二。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2011-11-27 03:31:31','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('26','7','0','部门主管','','','cmseasy','1','29','#000000','0','0','','0','','','','','7001','2012-08-04 10:06:32','cmseasy','','','1','1','职位详细说明','0','<p>&nbsp;职位详细说明</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','销售部','1','热爱本职工作','2','1','至少2年销售经验','4','20-40','不限','5000-8000','董先生','','0','','','','','1','2012-08-04 10:06:32','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('27','10','0','家居设计潮流趋势','','','admin','1','0','','0','0','','0','','','','','3204','2014-10-11 16:10:04','admin','','/upload/images/201304/3204.jpg','1','1','','0','<p>互联网的发展使得信息的交互沟通越来越快，世界各地的设计风格也越来越多的融合在一起，我们可以看到怀旧风格正逐渐向古典和现代风格过渡，色彩变得模糊并适中，让设计的整体显得更为亲密平和。在设计中闪亮的色彩渐渐消退，柔和的色调正缓缓到来，这些独特的色彩与微妙的色调之间达成一种平衡与和谐。下面是一些设计师所感知到的2015年家居潮流趋势。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711007361007.jpg\" title=\"14711007361007.jpg\" alt=\"12624135.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:10:04','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('28','10','0','灰白空间不乏味','','','admin','1','0','','0','0','','0','','','','','3205','2014-10-11 16:11:10','admin','','/upload/images/201304/3205.jpg','1','1','','0','<p>忙碌的工作占据了生活中的大部分黄金时间，这个时候，一个温馨而甜美的家也许能够让人获得难得的心灵安宁和精神享受。带着唯美家居拥有的时尚、浪漫又不乏温馨气息，来平复人们内心深处的焦躁。</p><p>大而宽敞、采光明亮的开放型空间让舒适感得到了极大展现</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/upload/images/201608/14711015441628.jpg\" title=\"14711015441628.jpg\" alt=\"20130615_0e23a239852c13596e6cw2xtlml1aybr_sp.jpg\"/></p><p><br/></p><p>从色彩搭配的角度，此空间中唯有“灰、白”两色，却完全没有单调乏味之感。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:11:10','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('29','10','0','意大利简约时尚型','','','admin','1','0','','0','0','','0','','','','','3206','2014-10-11 16:13:06','admin','','/upload/images/201304/3206.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711761931833.jpg\" style=\"\" title=\"14711761931833.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711761931010.jpg\" style=\"\" title=\"14711761931010.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:13:06','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('30','10','0','回归自然书写素雅生活','','','admin','1','2','','0','0','','0','','','','','3207','2014-10-11 16:13:46','admin','','/upload/images/201304/3207.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711762761403.jpg\" style=\"\" title=\"14711762761403.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711762761041.jpg\" style=\"\" title=\"14711762761041.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711762761294.jpg\" style=\"\" title=\"14711762761294.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:13:46','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('31','10','0','简约自然','','','admin','1','0','','0','0','','0','','','','','3208','2014-10-11 16:15:34','admin','','/upload/images/201304/3208.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711764686282.jpg\" style=\"\" title=\"14711764686282.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711764698679.jpg\" style=\"\" title=\"14711764698679.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711764691910.jpg\" style=\"\" title=\"14711764691910.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711764695327.jpg\" style=\"\" title=\"14711764695327.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:15:34','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('32','12','0','完美演绎自然主义的优雅和简约风范','','','admin','1','1','','0','0','','0','','','','','3301','2014-10-11 16:17:20','admin','','/upload/images/201304/3301.jpg','1','1','分析过度优化会导致不好的后果
   1、上网站的疑问、描绘不要过多堆砌关头词。良多站长在标题里和描绘里写量的环节词，并且为了省劲通常会把标题和描绘一样，这是大忌。标题写3到5个纽带词，描绘里写100个字符，里面嵌入标题的关键词就可以了，没需要把要做的一切的关键字都一股脑儿的塞进去，这不单对SEO搜索引擎不友好，即是对用户而言，用户体会极差。 
   2、文章内容里塞关键字。网站编纂为了省劲，很难写原创文章，可是又不得不环绕着政策关键字，所以强行把关键字塞进文章里，读着很是欠亨顺，这不光是对蜘蛛不友好，对用户而言也是不友好的。文章内容应该真恰是有用户认可，才干真实注重到你的关键字。 
   3、图像title和alt特点堆砌关键字。站长在给这些图像加title和alt特点为了省劲，图简略，爽性把一切的图像title和alt特点里堆上关键字，尽管可以增加关键字密度，但蜘蛛并不吃这一套。 
   4、网站的次导航建立不合理。次导航确实被许多搜索引擎优化人员所正视，然则许多人就仅仅简略的把关键字聚积到底部，没有排序。其实排序长短常首要的，意图关键字的排序依照热度来合理枚举才是优化的精采习气。 
   5、网站沟通的友情连接的过多且凌乱。许多增加的友情连接根柢和网站不相关，这样的友情连接又有多大的含义呢?并且有的增加友情连接也没有对方是不是加了签?是不是导出来连接过多?还有对方pr值若何?可以自个网站带来若干很多pr值?所以在交流连接时必然要权衡一下，再进行连接交流。 
   6、网站主页过量堆积关键字密度。为了把方针关键字做上去，许多站长在网站主页板框里很多再三关键字，致使关键字密度大得离谱，通常一个网站的关键字密度在2%~8%之间，可是为了让蜘蛛非常好的抓取你的网站关键字，就会加大网站关键字密度的构造。一不留心关键字密渡过大堆积就会形成优化过度，致使网站降权，乃至K站。所以在进行网站优化时一定要合理的采用操作网站关键字的密度。','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711766892099.jpg\" style=\"\" title=\"14711766892099.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711766898915.jpg\" style=\"\" title=\"14711766898915.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711766908873.jpg\" style=\"\" title=\"14711766908873.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:17:20','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('33','12','0','温馨时尚型的家居氛围','','','admin','1','0','','0','0','','0','','','','','3302','2014-10-11 16:18:45','admin','','/upload/images/201304/3302.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711768728838.jpg\" style=\"\" title=\"14711768728838.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711768721042.jpg\" style=\"\" title=\"14711768721042.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711768721599.jpg\" style=\"\" title=\"14711768721599.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:18:45','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('34','12','0','拒绝媚俗，带您洗尽铅华的纯净大方','','','admin','1','0','','0','0','','0','','','','','3303','2014-10-11 16:19:41','admin','','/upload/images/201304/3303.jpg','1','1','','0','<p>纯正的乌金木纹，全新的板木结合新结构，让消费者以板式的价格来体验享受新实木概念型家具产品。尊荣卓越，奇迹再现，澳玛乌金板木新实木概念家具。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711770551436.jpg\" style=\"\" title=\"14711770551436.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711770551292.jpg\" style=\"\" title=\"14711770551292.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711770555560.jpg\" style=\"\" title=\"14711770555560.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:19:41','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('35','12','0','识真我本色，导智慧人生','','','admin','1','0','','0','0','','0','','','','','3304','2014-10-11 16:21:08','admin','','/upload/images/201304/3304.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711775991542.jpg\" style=\"\" title=\"14711775991542.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711775991060.jpg\" style=\"\" title=\"14711775991060.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711775991020.jpg\" style=\"\" title=\"14711775991020.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:21:08','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('36','12','0','现代简约','','','admin','1','0','','0','0','','0','','','','','3305','2014-10-11 16:21:49','admin','','/upload/images/201304/3305.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711776505910.jpg\" style=\"\" title=\"14711776505910.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711776501844.jpg\" style=\"\" title=\"14711776501844.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711776501221.jpg\" style=\"\" title=\"14711776501221.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711776504450.jpg\" style=\"\" title=\"14711776504450.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:21:49','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('37','13','0','教你巧手贴壁纸 自己动手也能行','','','admin','1','0','','0','0','','0','','','','','2106','2014-10-11 16:25:59','admin','','/upload/images/201304/2106.jpg','1','1','　　分析过度优化会导致不好的后果、上网站的疑问、描绘不要过多堆砌关头词。良多站长在标题里和描绘里写量的环节词，并且为了省劲通常会把标题和描绘一样，这是大忌。标题写3到5个纽带词，描绘里写100个字符，里面嵌入标题的关键词就可以了，没需要把要做的一切的关键字都一股脑儿的塞进去，这不单对SEO搜索引擎不友好，即是对用户而言，用户体会极差。
　　、文章内容里塞关键字。网站编纂为了省劲，很难写原创文章，可是又不得不环绕着政策关键字，所以强行把关键字塞进文章里，读着很是欠亨顺，这不光是对蜘蛛不友好，对用户而言也是不友好的。文章内容应该真恰是有用户认可，才干真实注重到你的关键字。
　　、图像title和alt特点堆砌关键字。站长在给这些图像加title和alt特点为了省劲，图简略，爽性把一切的图像title和alt特点里堆上关键字，尽管可以增加关键字密度，但蜘蛛并不吃这一套。
　　、网站的次导航建立不合理。次导航确实被许多搜索引擎优化人员所正视，然则许多人就仅仅简略的把关键字聚积到底部，没有排序。其实排序长短常首要的，意图关键字的排序依照热度来合理枚举才是优化的精采习气。
　　、网站沟通的友情连接的过多且凌乱。许多增加的友情连接根柢和网站不相关，这样的友情连接又有多大的含义呢?并且有的增加友情连接也没有对方是不是加了签?是不是导出来连接过多?还有对方pr值若何?可以自个网站带来若干很多pr值?所以在交流连接时必然要权衡一下，再进行连接交流。
　　、网站主页过量堆积关键字密度。为了把方针关键字做上去，许多站长在网站主页板框里很多再三关键字，致使关键字密度大得离谱，通常一个网站的关键字密度在2%~8%之间，可是为了让蜘蛛非常好的抓取你的网站关键字，就会加大网站关键字密度的构造。一不留心关键字密渡过大堆积就会形成优化过度，致使网站降权，乃至K站。所以在进行网站优化时一定要合理的采用操作网站关键字的密度。','0','<p>&nbsp;　　分析过度优化会导致不好的后果、上网站的疑问、描绘不要过多堆砌关头词。良多站长在标题里和描绘里写量的环节词，并且为了省劲通常会把标题和描绘一样，这是大忌。标题写3到5个纽带词，描绘里写100个字符，里面嵌入标题的关键词就可以了，没需要把要做的一切的关键字都一股脑儿的塞进去，这不单对SEO搜索引擎不友好，即是对用户而言，用户体会极差。</p><div>　　、文章内容里塞关键字。网站编纂为了省劲，很难写原创文章，可是又不得不环绕着政策关键字，所以强行把关键字塞进文章里，读着很是欠亨顺，这不光是对蜘蛛不友好，对用户而言也是不友好的。文章内容应该真恰是有用户认可，才干真实注重到你的关键字。</div><div>　　、图像title和alt特点堆砌关键字。站长在给这些图像加title和alt特点为了省劲，图简略，爽性把一切的图像title和alt特点里堆上关键字，尽管可以增加关键字密度，但蜘蛛并不吃这一套。</div><div>　　、网站的次导航建立不合理。次导航确实被许多搜索引擎优化人员所正视，然则许多人就仅仅简略的把关键字聚积到底部，没有排序。其实排序长短常首要的，意图关键字的排序依照热度来合理枚举才是优化的精采习气。</div><div>　　、网站沟通的友情连接的过多且凌乱。许多增加的友情连接根柢和网站不相关，这样的友情连接又有多大的含义呢?并且有的增加友情连接也没有对方是不是加了签?是不是导出来连接过多?还有对方pr值若何?可以自个网站带来若干很多pr值?所以在交流连接时必然要权衡一下，再进行连接交流。</div><div>　　、网站主页过量堆积关键字密度。为了把方针关键字做上去，许多站长在网站主页板框里很多再三关键字，致使关键字密度大得离谱，通常一个网站的关键字密度在2%~8%之间，可是为了让蜘蛛非常好的抓取你的网站关键字，就会加大网站关键字密度的构造。一不留心关键字密渡过大堆积就会形成优化过度，致使网站降权，乃至K站。所以在进行网站优化时一定要合理的采用操作网站关键字的密度。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:25:59','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('39','13','0','乌拉草床垫的优缺点','','','admin','1','0','','0','0','','0','','','','','2108','2014-10-11 16:31:46','admin','','/upload/images/201304/2108.jpg','1','1','对于我们优化人员来说，在每一个网站建设之初我们都在想我们的网站在优化竞争中赢在起跑线上。为此在建站之初，网站的结构是否有利于我们的优化是我们不得不考虑的一件重要的事情。对于一个好的网站结构来说，它不仅可以对你的排名起到很好的促进作用，对于你的投资回报率提高来说也有很好的作用。如果你的站点有一个用关键词构架的优化结构的话，那么对于你的优化来说将起到事半功倍的效果。我们可以将关键词区分为主关键词、次关键词和长尾关键词，这三种都有各自的优势，那么本文将围绕着这三种关键词阐述如何构建你的站点的优化结构，来使你的站点获得更高的排名和点击率，达到利益的最大化。
　　一：主关键词构建站点的优化结构的第一步就是设置主关键词，我们可以将我们的主要关键词置于站点的标题信息中，当然我们也可以将主要的关键词分布于其他站点的基本信息中。主关键词的设置相对比较简单，笔者就不详细的介绍。
　　二：次要关键词对于一个站点来说，第二个重要的组成部分就是次要关键词。次要关键词相对于主要关键词在优化的难度上会相对较低。我们在构架网站的优化结构的时候，可以将网站的次要关键词设置为站点的分类目录。我们这样做的目的是更好的利用链接的权重。你的站点内容都有链接到各自的目录分类。而这些目录分类又会链接到有着主关键词的主页页面。这一个看似简单的过程却可以很好的提高你的站点的排名，而且也可以使含有主关键词的主页权重更加的高，成为焦点。当然分类目录的数量也要有所控制，笔者建议分类目录的数量最好不要超过8个，对于一些站点分类比较多的话，你可以尝试着使用子类别。
　　三：长尾关键词站点优化结构构建的第三步就是长尾关键词的使用，长尾关键词相对于主关键词和次要关键词来说，优化的难度最小，但是流量比较低，而且存在着不确定的因素。对于长尾关键词你可以在站点的内容中利用。你的站点内容可以影响到你的主关键词、次关键词，当然也包括长尾关键词。对于这方面可以在站点上发布尽可能多的内容，并保持内容的高质量以及内容的相关性和与分类目录的联系。这样才能达到最好的效果。
　　如何让自己的站点赢在起跑线上，是每一优化人员都在苦心琢磨的问题，但其实从最基本的网站的构架就可以有很大的作用，希望本文对大家有所帮助。','0','<p>对于我们优化人员来说，在每一个网站建设之初我们都在想我们的网站在优化竞争中赢在起跑线上。为此在建站之初，网站的结构是否有利于我们的优化是我们不得不考虑的一件重要的事情。对于一个好的网站结构来说，它不仅可以对你的排名起到很好的促进作用，对于你的投资回报率提高来说也有很好的作用。如果你的站点有一个用关键词构架的优化结构的话，那么对于你的优化来说将起到事半功倍的效果。我们可以将关键词区分为主关键词、次关键词和长尾关键词，这三种都有各自的优势，那么本文将围绕着这三种关键词阐述如何构建你的站点的优化结构，来使你的站点获得更高的排名和点击率，达到利益的最大化。</p><div>　　一：主关键词构建站点的优化结构的第一步就是设置主关键词，我们可以将我们的主要关键词置于站点的标题信息中，当然我们也可以将主要的关键词分布于其他站点的基本信息中。主关键词的设置相对比较简单，笔者就不详细的介绍。</div><div>　　二：次要关键词对于一个站点来说，第二个重要的组成部分就是次要关键词。次要关键词相对于主要关键词在优化的难度上会相对较低。我们在构架网站的优化结构的时候，可以将网站的次要关键词设置为站点的分类目录。我们这样做的目的是更好的利用链接的权重。你的站点内容都有链接到各自的目录分类。而这些目录分类又会链接到有着主关键词的主页页面。这一个看似简单的过程却可以很好的提高你的站点的排名，而且也可以使含有主关键词的主页权重更加的高，成为焦点。当然分类目录的数量也要有所控制，笔者建议分类目录的数量最好不要超过8个，对于一些站点分类比较多的话，你可以尝试着使用子类别。</div><div>　　三：长尾关键词站点优化结构构建的第三步就是长尾关键词的使用，长尾关键词相对于主关键词和次要关键词来说，优化的难度最小，但是流量比较低，而且存在着不确定的因素。对于长尾关键词你可以在站点的内容中利用。你的站点内容可以影响到你的主关键词、次关键词，当然也包括长尾关键词。对于这方面可以在站点上发布尽可能多的内容，并保持内容的高质量以及内容的相关性和与分类目录的联系。这样才能达到最好的效果。</div><div>　　如何让自己的站点赢在起跑线上，是每一优化人员都在苦心琢磨的问题，但其实从最基本的网站的构架就可以有很大的作用，希望本文对大家有所帮助。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:31:46','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('40','14','0','家居风水之阳台风水禁忌','','','admin','1','6','','0','0','','0','','','','','2201','2014-10-11 16:32:42','admin','','/upload/images/201304/2201.jpg','1','1','日前，“首届米兰中华美食文化节”在米兰开幕。专程从中国赶赴米兰参加首届米兰中华美食文化节的“中国美食走进联合国”厨师团的名厨们纷纷亮出了自己的拿手绝活。
在首届米兰中华美食文化节上，“中国美食走进联合国”厨师团的名厨们精心烹制的美味佳肴仿佛是一件件精美的艺术品，令人叹为观止，不仅为中华美食文化节增添光彩，也让现场的中意宾客大饱眼福，惊叹中华美食的博大精深，连连惊呼大师们的高超绝技。
厨师团的厨师们和意大利宾客合影。','0','<p>日前，“首届米兰中华美食文化节”在米兰开幕。专程从中国赶赴米兰参加首届米兰中华美食文化节的“中国美食走进联合国”厨师团的名厨们纷纷亮出了自己的拿手绝活。</p><p><br/></p><p>在首届米兰中华美食文化节上，“中国美食走进联合国”厨师团的名厨们精心烹制的美味佳肴仿佛是一件件精美的艺术品，令人叹为观止，不仅为中华美食文化节增添光彩，也让现场的中意宾客大饱眼福，惊叹中华美食的博大精深，连连惊呼大师们的高超绝技。</p><p><br/></p><p>厨师团的厨师们和意大利宾客合影。</p><p><br/></p><p style=\"text-align:center\"><img src=\"/upload/images/201607/14696041541018.jpg\" title=\"14696041541018.jpg\" alt=\"header.jpg\"/></p><p>在随后举行的首届米兰中华美食文化节新闻发布会上，米兰华侨华人工商会秘书长周建煌、高炳义大师，意大利名厨Eros Picco，意大利第一位华人侍酒师叶刘洁先后就中华美食今后在欧洲的发展创新，中华美食的源远流长以及意大利餐与中餐的相互借鉴，意大利红酒文化与中餐的巧妙互融发表了各自的建言。(夏晓彤)</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:32:42','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('41','14','0','客厅装修中的风水问题注意事项','','','admin','1','0','','0','0','','0','','','','','2202','2014-10-11 16:33:35','admin','','/upload/images/201304/2202.jpg','1','1','对于网站SEO健康度，前面已经为大家谈到三个方面《快速提升网站SEO健康度一：网站内容健康》《快速提升网站SEO健康度二：网站硬件健康》《快速提升网站SEO健康度三：网站内链健康》，对于网站的SEO健康其实还有很多，而对于关键词的重视程度相信大家也是有相当的认识，今天我要为大家介绍的就是网站关键词的选取与布局。
　　网站的关键词是非常关键的，我们在做SEO的时候对于关键词有两个要注意的，一个就是选取，选取关键词要选取对的关键词，选取适合自己实力，自己能搞定，还要注意这些关键词的效果;另外一个就是布局，布局要根据权重高低原则进行，另外要注意自然性，广泛性，长尾关键词是一个重要的方面。下面从两个方面为大家做一个简单的分析。
　　1、网站关键词的选取健康对于关键词的选取，前面我们已经跟大家做了一个简单的介绍，其实关键词的选取很简单，只需要做到下面的几个方面即可：
　　A、首先我们要看行业的关键词是否适合我们做，例如我们是做SEO的，但是你的实力没有那么大，肯定就不能面向全国做的，我们可以根据自己所在的地区进行选择，在北京就可以选择北京SEO，如果觉得北京SEO比较难做，而我又是湖北人，那么我也可以选择武汉SEO，这里我要说的就是根据自己的实力选择，盲目的选择一个超越自己实力的关键词，不仅仅难以优化，而且还对自己的信心造成伤害。
　　当然根据能力选择只是网站关键词选取是否适合的一个方面，有的行业词太大，能够分出来的长尾词和辅助词特别多，有的甚至延伸到不同的行业去了，这时候就要注意选取，不要可以去做行业词，选取长尾词优化更好，例如我有位朋友是做“印花”的，但是长尾词中有“印花税”这样完全不是行业里的词，那做好印花都有可能造成很大的损失，而且他目前的业务只面向义乌，那么他肯定需要选择长尾词做优化，如义乌印花，义乌印花厂等。
　　B、其次我们选取关键词的时候需要注意衡量这个关键词的价值。之前优化过很多的案例，有些关键词是很热的，做起来也相当的吃力，当然做到第一之后的效果是相当给力的，这样的关键词价值很高的，当然值得去选取，但是开始的时候我们是分辨不了的，这个时候就需要借助工具，例如百度指数，百度的相关搜索，还有站长伯乐，爱站等挖掘长尾词的工具，只要我们能分辨难度大小和价值就可以了。一般来说，我们搜索一个词，百度竞价越多，这个词的价值就越高，当然难度也就有点大了。另外，我们要挖掘一些能带来精准客户的长尾词，这些词虽然一天就几个搜索量，但是有时候来了就可以发展成客户。
　　2、网站关键词的布局健康对于关键词的布局其实我之前都没有好的系统的想法，一直都是按照自己随性的设置，今天为了这篇文章做了一个简单的整理。
　　A、布局首先要考虑关键词所在位置的权重。
　　第一就是网站的标签。在标题标签里的权重当然会非常高，关键词标签和描述标签紧接着，其次一个页面我们权重最高的应该是H1标签，在这个标签里面我们要设置一些需要优化的关键词，接下来就是H2-H6，一些锚文本加粗的关键词位置权重也算不错。
　　第二点就是网站的导航和次导航。一般来说导航里面插入一些关键词，或者说利用不同的关键词做导航会提升这个关键词的权重，因为这些导航链接链向的页面都是和这个关键词相关的知识，相关性得到了很好的保证。例如我们是卖秋装的，在导航里面假如秋装，就会导向所有秋装所在列表页面，用户就会在这个页面找到自己想要的秋装。
　　第三，一般在一个页面的首部和尾部都是权重比较高的，所以需要在这些地方多布局一些关键词，让关键词在重要的位置多表现，权重自然提升了。
　　B、关键词布局的三性：自然性，广泛性，长尾性。
　　关键词在网站内部出现的时候一定要注意自然合理，特别是那些读起来都不通顺的，那就很不友好了，广泛性指的是我们要在网站的每个角落都注意设定一些关键词，特别是对于一些长尾关键词，需要做锚文本的就要做上，权重就在这样一点一滴中积累起来的，另外需要注意关键词布局的长尾性，越多的长尾我们能够引导的流量可能就越多，潜在的意向客户就会越多，所以长尾绝对需要重视，特别是我们每天进行网站更新的时候就需要注意在文章中进行长尾关键词建设，一般我都是利用网站标题优化长尾词，这样权重高，优化的排名也会很好。
','0','<p>对于网站SEO健康度，前面已经为大家谈到三个方面《快速提升网站SEO健康度一：网站内容健康》《快速提升网站SEO健康度二：网站硬件健康》《快速提升网站SEO健康度三：网站内链健康》，对于网站的SEO健康其实还有很多，而对于关键词的重视程度相信大家也是有相当的认识，今天我要为大家介绍的就是网站关键词的选取与布局。</p><div>　　网站的关键词是非常关键的，我们在做SEO的时候对于关键词有两个要注意的，一个就是选取，选取关键词要选取对的关键词，选取适合自己实力，自己能搞定，还要注意这些关键词的效果;另外一个就是布局，布局要根据权重高低原则进行，另外要注意自然性，广泛性，长尾关键词是一个重要的方面。下面从两个方面为大家做一个简单的分析。</div><div>　　1、网站关键词的选取健康对于关键词的选取，前面我们已经跟大家做了一个简单的介绍，其实关键词的选取很简单，只需要做到下面的几个方面即可：</div><div>　　A、首先我们要看行业的关键词是否适合我们做，例如我们是做SEO的，但是你的实力没有那么大，肯定就不能面向全国做的，我们可以根据自己所在的地区进行选择，在北京就可以选择北京SEO，如果觉得北京SEO比较难做，而我又是湖北人，那么我也可以选择武汉SEO，这里我要说的就是根据自己的实力选择，盲目的选择一个超越自己实力的关键词，不仅仅难以优化，而且还对自己的信心造成伤害。</div><div>　　当然根据能力选择只是网站关键词选取是否适合的一个方面，有的行业词太大，能够分出来的长尾词和辅助词特别多，有的甚至延伸到不同的行业去了，这时候就要注意选取，不要可以去做行业词，选取长尾词优化更好，例如我有位朋友是做&ldquo;印花&rdquo;的，但是长尾词中有&ldquo;印花税&rdquo;这样完全不是行业里的词，那做好印花都有可能造成很大的损失，而且他目前的业务只面向义乌，那么他肯定需要选择长尾词做优化，如义乌印花，义乌印花厂等。</div><div>　　B、其次我们选取关键词的时候需要注意衡量这个关键词的价值。之前优化过很多的案例，有些关键词是很热的，做起来也相当的吃力，当然做到第一之后的效果是相当给力的，这样的关键词价值很高的，当然值得去选取，但是开始的时候我们是分辨不了的，这个时候就需要借助工具，例如百度指数，百度的相关搜索，还有站长伯乐，爱站等挖掘长尾词的工具，只要我们能分辨难度大小和价值就可以了。一般来说，我们搜索一个词，百度竞价越多，这个词的价值就越高，当然难度也就有点大了。另外，我们要挖掘一些能带来精准客户的长尾词，这些词虽然一天就几个搜索量，但是有时候来了就可以发展成客户。</div><div>　　2、网站关键词的布局健康对于关键词的布局其实我之前都没有好的系统的想法，一直都是按照自己随性的设置，今天为了这篇文章做了一个简单的整理。</div><div>　　A、布局首先要考虑关键词所在位置的权重。</div><div>　　第一就是网站的标签。在标题标签里的权重当然会非常高，关键词标签和描述标签紧接着，其次一个页面我们权重最高的应该是H1标签，在这个标签里面我们要设置一些需要优化的关键词，接下来就是H2-H6，一些锚文本加粗的关键词位置权重也算不错。</div><div>　　第二点就是网站的导航和次导航。一般来说导航里面插入一些关键词，或者说利用不同的关键词做导航会提升这个关键词的权重，因为这些导航链接链向的页面都是和这个关键词相关的知识，相关性得到了很好的保证。例如我们是卖秋装的，在导航里面假如秋装，就会导向所有秋装所在列表页面，用户就会在这个页面找到自己想要的秋装。</div><div>　　第三，一般在一个页面的首部和尾部都是权重比较高的，所以需要在这些地方多布局一些关键词，让关键词在重要的位置多表现，权重自然提升了。</div><div>　　B、关键词布局的三性：自然性，广泛性，长尾性。</div><div>　　关键词在网站内部出现的时候一定要注意自然合理，特别是那些读起来都不通顺的，那就很不友好了，广泛性指的是我们要在网站的每个角落都注意设定一些关键词，特别是对于一些长尾关键词，需要做锚文本的就要做上，权重就在这样一点一滴中积累起来的，另外需要注意关键词布局的长尾性，越多的长尾我们能够引导的流量可能就越多，潜在的意向客户就会越多，所以长尾绝对需要重视，特别是我们每天进行网站更新的时候就需要注意在文章中进行长尾关键词建设，一般我都是利用网站标题优化长尾词，这样权重高，优化的排名也会很好。</div><div>&nbsp;</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:33:35','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('42','14','0','富贵竹多少根招财','','','admin','1','0','','0','0','','0','','','','','2203','2014-10-11 16:35:09','admin','','/upload/images/201304/2203.jpg','1','1','分享四大注意点可避免网站优化过度第一点、关键字切勿堆砌过度在优化网站前就要确定好需要优化的关键字，然后再title、网站全体页面上进行恰当的组织，而不是盲目的堆砌许多关键字。这儿关于关键字在网站页面上的方案有个小窍门，那就是：保证优化关键字出现在第一个语句傍边，这个正是搜索引擎在抓取页面的时分所垂青并显示出来的。
　　第二点、恰当的更新网站内容许多站长兄弟都用过信息收集器来给自个的网站添加内容，本来这点不是一个十分正确的做法。首要，搜索引擎不会喜爱重复性的东西，其次，收集的信息尽管多， 可是也缺罕见用的针对性，简略致使网站关键字密度的稀释。真实的做法是，恰当的更新一些有价值，互联网上罕见的内容。只需这样，不论是搜索引擎，用户，还 是自个，都大快人心。
　　第三点、切勿收买过多的外链这点在新站傍边恰当普片，本来这样对网站是弊大于利的。搜索引擎十分喜爱新内容，新网站的参加，而这个新字要表现在哪？无非就是在互联网上没有这个站点的 任何痕迹，假定新站前期收买许多的外链，网站外链俄然暴增，尽管能够添加网站的权重，可是关于搜索引擎就不太友好了，会引起搜索引擎的怀疑。
　　第四点、请不要过火相信你的技能有些兄弟技能很牛X，会运用一些窍门强制性的添加外链或是添加用户的到访（这点跟收买黑链殊途同归），这样尽管会在短时间内给网站带来流量，可是这样为了 优化而优化的心态是永久也留不住客户的，用户体会度欠好，乃至是欺骗了用户，下一次用户就不会买你的帐，而搜索引擎最注重的是什么？当然是用户的体会，如 果你开脱了它的天主，那么它一定也是不会让你好过的。','0','<p>分享四大注意点可避免网站优化过度第一点、关键字切勿堆砌过度在优化网站前就要确定好需要优化的关键字，然后再title、网站全体页面上进行恰当的组织，而不是盲目的堆砌许多关键字。这儿关于关键字在网站页面上的方案有个小窍门，那就是：保证优化关键字出现在第一个语句傍边，这个正是搜索引擎在抓取页面的时分所垂青并显示出来的。</p><div>　　第二点、恰当的更新网站内容许多站长兄弟都用过信息收集器来给自个的网站添加内容，本来这点不是一个十分正确的做法。首要，搜索引擎不会喜爱重复性的东西，其次，收集的信息尽管多， 可是也缺罕见用的针对性，简略致使网站关键字密度的稀释。真实的做法是，恰当的更新一些有价值，互联网上罕见的内容。只需这样，不论是搜索引擎，用户，还 是自个，都大快人心。</div><div>　　第三点、切勿收买过多的外链这点在新站傍边恰当普片，本来这样对网站是弊大于利的。搜索引擎十分喜爱新内容，新网站的参加，而这个新字要表现在哪？无非就是在互联网上没有这个站点的 任何痕迹，假定新站前期收买许多的外链，网站外链俄然暴增，尽管能够添加网站的权重，可是关于搜索引擎就不太友好了，会引起搜索引擎的怀疑。</div><div>　　第四点、请不要过火相信你的技能有些兄弟技能很牛X，会运用一些窍门强制性的添加外链或是添加用户的到访（这点跟收买黑链殊途同归），这样尽管会在短时间内给网站带来流量，可是这样为了 优化而优化的心态是永久也留不住客户的，用户体会度欠好，乃至是欺骗了用户，下一次用户就不会买你的帐，而搜索引擎最注重的是什么？当然是用户的体会，如 果你开脱了它的天主，那么它一定也是不会让你好过的。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:35:09','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('46','14','0','中式风格起源及发展','','','admin','1','0','','0','0','','0','','','','','2206','2014-10-11 16:40:02','admin','','/upload/images/201304/2206.jpg','1','1','一、避免友链牵连赏罚。友情链接作为较高质量外链的一种，在传递权重上的能力决然是要高于其他链接的。因为年夜部门友链交流城市选用链接锚文本的形式，所以对方针关头词排名排名的影响也是相当大的。当然，由于友情链接的这种特点，在传递责罚时，也会起到较大的影响。
　　若是与你交换友链的上网站惨遭惩罚，只要友链还在，那你必然受牵连。一向兢兢业业的你也就会被SEO搜索引擎牵连惩罚，从而导致百度引擎快照不更新的情形。按期搜检你的友情链接，发现问题实时与对方联系、沟通、措置。
　　二、网站切莫频仍改版。
　　这点搜罗网站的title、及网站的结构代码。当你确立网站的title、信息与架构、主题时要稳重。一旦确立尽可能的不要更改，即使要改，也要慢慢逐步的改削。不到万不得已，万万不要一次性大改版。
　　一个频繁更改网站信息及架构的网站，百度会认为你还没有筹备好，会把你再次丢进.考查期.。更有甚者，直接k站。如斯一来，网站的百度快照又若何更新三、远离化手法。
　　化就是俗称的.作弊.，诸如堆砌环节字、潜匿链接、桥页等等等等。这些化手段都是经由过程.棍骗.搜索引擎或用户，来达到提高枢纽词排名的目的。百度和谷歌等搜索引擎都是峻厉冲击这些化行为的。小到.百度11位.，大到降权甚至k站。假如你揭竿而起，视搜索引擎为无物。那么，搜索引擎就不会对你手下留情。而网站的快照也就很有可能遏制更新或者倒退。不外对于k站来说，快照不更新倒只是小时而已。
　　四、保证空间的不变性。
　　一个经常宕机的处事器，就别想奢望获得搜索引擎的青睐，更别想快照更新的勤快。试想一下，百度蜘蛛经常爬到你的网站，却时常遭到无法打开的情况。那么，百度如何抓取网站的新内容，又如何更新快照五、坚持内容页面的更新。
　　笔者的不雅概念是，即使搜索引擎蜘蛛经常爬到你的网站，可是如果没有新的内容让它抓取，百度快照也就没有了更新可言。所以，你想要网站的快照更新的勤快，那么，网站的内容及页面也要更新的勤快。
　　不过，复制粘贴的内容笔者劝列位仍是越少越好。蜘蛛见异思迁，巨匠都是知道的。如果你持久的复制粘贴，不仅不能吸引蜘蛛更新网站的快照，反而还会遭到蜘蛛的厌弃。青岛沙盘模子?六、坚持培植外链。
　　网站的外链建设与内容更新都是一样需要持续性去做的事，千万不成三天打鱼两天晒网。可以这么说，拿小我博客来说，相对信息量比其他站要小的多。你可以3天更新一篇文章，切莫一天不增添外链。拥有复杂的外链系统，才能更多的指导蜘蛛爬向你的网站。然后抓取新的内容，是以更新百度快照。
　　还有，新站在做外链的时辰，千万不要想着一顿吃成胖子。建站初期，天天建设外链的数目可以少一点，逐步增加。然则，切记要坚持，','0','<p>&nbsp;　　一、避免友链牵连赏罚。</p><p>　　友情链接作为较高质量外链的一种，在传递权重上的能力决然是要高于其他链接的。因为年夜部门友链交流城市选用链接锚文本的形式，所以对方针关头词排名排名的影响也是相当大的。当然，由于友情链接的这种特点，在传递责罚时，也会起到较大的影响。</p><p>　　若是与你交换友链的上网站惨遭惩罚，只要友链还在，那你必然受牵连。一向兢兢业业的你也就会被SEO搜索引擎牵连惩罚，从而导致百度引擎快照不更新的情形。按期搜检你的友情链接，发现问题实时与对方联系、沟通、措置。</p><p>　　二、网站切莫频仍改版。</p><p>　　这点搜罗网站的title、及网站的结构代码。当你确立网站的title、信息与架构、主题时要稳重。一旦确立尽可能的不要更改，即使要改，也要慢慢逐步的改削。不到万不得已，万万不要一次性大改版。</p><p>　　一个频繁更改网站信息及架构的网站，百度会认为你还没有筹备好，会把你再次丢进.考查期.。更有甚者，直接k站。如斯一来，网站的百度快照又若何更新三、远离化手法。</p><p>　　化就是俗称的.作弊.，诸如堆砌环节字、潜匿链接、桥页等等等等。这些化手段都是经由过程.棍骗.搜索引擎或用户，来达到提高枢纽词排名的目的。百度和谷歌等搜索引擎都是峻厉冲击这些化行为的。小到.百度11位.，大到降权甚至k站。假如你揭竿而起，视搜索引擎为无物。那么，搜索引擎就不会对你手下留情。而网站的快照也就很有可能遏制更新或者倒退。不外对于k站来说，快照不更新倒只是小时而已。</p><p>　　四、保证空间的不变性。</p><p>　　一个经常宕机的处事器，就别想奢望获得搜索引擎的青睐，更别想快照更新的勤快。试想一下，百度蜘蛛经常爬到你的网站，却时常遭到无法打开的情况。那么，百度如何抓取网站的新内容，又如何更新快照五、坚持内容页面的更新。</p><p>　　笔者的不雅概念是，即使搜索引擎蜘蛛经常爬到你的网站，可是如果没有新的内容让它抓取，百度快照也就没有了更新可言。所以，你想要网站的快照更新的勤快，那么，网站的内容及页面也要更新的勤快。</p><p>　　不过，复制粘贴的内容笔者劝列位仍是越少越好。蜘蛛见异思迁，巨匠都是知道的。如果你持久的复制粘贴，不仅不能吸引蜘蛛更新网站的快照，反而还会遭到蜘蛛的厌弃。青岛沙盘模子?六、坚持培植外链。</p><p>　　网站的外链建设与内容更新都是一样需要持续性去做的事，千万不成三天打鱼两天晒网。可以这么说，拿小我博客来说，相对信息量比其他站要小的多。你可以3天更新一篇文章，切莫一天不增添外链。拥有复杂的外链系统，才能更多的指导蜘蛛爬向你的网站。然后抓取新的内容，是以更新百度快照。</p><p>　　还有，新站在做外链的时辰，千万不要想着一顿吃成胖子。建站初期，天天建设外链的数目可以少一点，逐步增加。然则，切记要坚持，</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:40:02','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('44','14','0','家居装修风水禁忌有哪些','','','admin','1','0','','0','0','','0','','','','','2204','2014-10-11 16:37:42','admin','','/upload/images/201304/2204.jpg','1','1','1.策划(职称炒作实在说的难听逆耳小半便是炒作，说的业余小半那便是策划。一度好的疑难以及好的情势可以给用户带来反感度以及退步转发、共享率!那样我们要若何敷衍外链情势制止策划呢?童鞋们大概许都看过电视机大要一些带有往事素质的作品，而这类作品都是颠末历程策划职员细致策划的，是以他们的造访量都及高而且用户都非常喜好。说点譬如：譬如拿一些名士名站等敷衍于用户体贴的论题制止策划!千万最重要的是没有要涉及侵权梗概没有犯警就行郑州SEO培训2.人脉接洽作为互联网络职业的我们最重要的大概许便是人脉，当我们的人脉会聚到注定的程度时间敷衍于我们前期的事变以及睁开都会失落去较年夜的帮手。当你方才进入某个职业的时间没有人脉，想要别人给你承接，要么你到群里的吆喝着换情谊联接，吆喝半响上去别人看你的上网站没有权重、没有流量根柢就瞧没有起你网站，更没有会给你加联接!不异除了你够亏弱衰弱，你的网站都非常良好，到阿谁时间的你更没有会瞧没有起那些残余站点了。而自个有人脉的话，就可以间接的跟其住口，正常都邑给你加挽联接。
　　3.构思构思跟反面的策划有点近似千篇一律!凭据现在我们的生理判断出，如今的人好奇心都非常强，分外是敷衍一些搞笑的构思、现已好奇的论题都分外锐敏!相似正在优酷里边的构思搞笑视频，若是说你自个可以想要这类视频，尔后正在视频里边加上自个网站的联接!终极通过该署用户看完后一直的给你转发、共享。那样没有可思议终极你的外链会抵达一度怎样办的程度允在增长4.情势某个斗劲我们就特殊非常明白了，但是这笔还是要简练下自个的一些不雅观点共享给童鞋们。做情势最稀有的便是写软文!把一些有价格的货品共享给有需求的人，进而得到转发以及搜集。一同还可以结识到更多的人脉!正常的人写软文都是比较间接的。作者主意写软文的人最佳凭据自个的零丁的体例来制止翻译的策划!让用户正在获取到自个想要的货色一同还能使得心绪变得开畅。那样的软翰墨是顺遂的软文。
　　通过之上四点我们可以鲜明较着的看进去，该署要领完全跟搜刮引擎优化武艺没有搭边的。最次要也还是要陈诉我们我们没有要被搜刮引擎优化给搜刮引擎优化了!要学会跳出搜刮引擎优化某个制约来敷衍待搜刮引擎优化，叫做旁观者清!当你跳出某个制约的时间你才气看到更多你看没有到的货色!更没有要把搜刮引擎优化想的偏激奇妙了!','0','<p>1.策划(职称炒作实在说的难听逆耳小半便是炒作，说的业余小半那便是策划。一度好的疑难以及好的情势可以给用户带来反感度以及退步转发、共享率!那样我们要若何敷衍外链情势制止策划呢?童鞋们大概许都看过电视机大要一些带有往事素质的作品，而这类作品都是颠末历程策划职员细致策划的，是以他们的造访量都及高而且用户都非常喜好。说点譬如：譬如拿一些名士名站等敷衍于用户体贴的论题制止策划!千万最重要的是没有要涉及侵权梗概没有犯警就行郑州SEO培训2.人脉接洽作为互联网络职业的我们最重要的大概许便是人脉，当我们的人脉会聚到注定的程度时间敷衍于我们前期的事变以及睁开都会失落去较年夜的帮手。当你方才进入某个职业的时间没有人脉，想要别人给你承接，要么你到群里的吆喝着换情谊联接，吆喝半响上去别人看你的上网站没有权重、没有流量根柢就瞧没有起你网站，更没有会给你加联接!不异除了你够亏弱衰弱，你的网站都非常良好，到阿谁时间的你更没有会瞧没有起那些残余站点了。而自个有人脉的话，就可以间接的跟其住口，正常都邑给你加挽联接。</p><div>　　3.构思构思跟反面的策划有点近似千篇一律!凭据现在我们的生理判断出，如今的人好奇心都非常强，分外是敷衍一些搞笑的构思、现已好奇的论题都分外锐敏!相似正在优酷里边的构思搞笑视频，若是说你自个可以想要这类视频，尔后正在视频里边加上自个网站的联接!终极通过该署用户看完后一直的给你转发、共享。那样没有可思议终极你的外链会抵达一度怎样办的程度允在增长4.情势某个斗劲我们就特殊非常明白了，但是这笔还是要简练下自个的一些不雅观点共享给童鞋们。做情势最稀有的便是写软文!把一些有价格的货品共享给有需求的人，进而得到转发以及搜集。一同还可以结识到更多的人脉!正常的人写软文都是比较间接的。作者主意写软文的人最佳凭据自个的零丁的体例来制止翻译的策划!让用户正在获取到自个想要的货色一同还能使得心绪变得开畅。那样的软翰墨是顺遂的软文。</div><div>　　通过之上四点我们可以鲜明较着的看进去，该署要领完全跟搜刮引擎优化武艺没有搭边的。最次要也还是要陈诉我们我们没有要被搜刮引擎优化给搜刮引擎优化了!要学会跳出搜刮引擎优化某个制约来敷衍待搜刮引擎优化，叫做旁观者清!当你跳出某个制约的时间你才气看到更多你看没有到的货色!更没有要把搜刮引擎优化想的偏激奇妙了!</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:37:42','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('45','14','0','不良的阳台风水格局如何化解','','','admin','1','0','','0','0','','0','','','','','2205','2014-10-11 16:37:52','admin','','/upload/images/201304/2205.jpg','1','1','权重的盘算要领是什么样的！在搜刮引擎优化词库中，存在一个名词，叫“权重”，权重是网页本身与查询词（以下俗称关键字）之间的干系度盘算。搜刮引擎在用户发送查找指令后，通常是凭据网页权重来举行排序，通常所说的网站权重，可以明白为网站首页的权重值。
　　网页权重的盘算依靠于基础权重、链接权重、用户评价权重三个方面：
　　网页基础权重：重要受到关键字的绝对权重、关键字频率、网页长度（与网页巨细区离开）的影响。
　　1、绝对权重搜刮引擎会对任何一个新的网页赋予一个缺省的权重值（有喜好的朋侪可以相识下TF*IDF算法），WEB尺度化是提升基础权重的紧急因素，一些标签将影响关键字的权重值，终极的基础权重值是这些因素举行相加得到的；2、关键字频率这一因素各人应该都非常清楚了，关键字频率的理论数据为2%-8%。关键字在网页中的位置都市存在一个权重值，对每个位置上的权重举行求和盘算，则可以得到关键字在整个页面的权重值。
　　3、网页长度上面提到的盘算方法都很公平，但假如思量到雷同的关键字出如今差别的网页中，网页的长度越长，那么，关键字可得到的权重值就会越高，以是，某一关键字的权重值在肯定程度上还受网页长度的影响。
　　网页链接权重：重要是内部链接和外部链接。敷衍内部链接来讲，为了公平，搜刮引擎一重般不会给较多的权分值，特殊是一些牢固位置的链接，这些简直有利用搜刮引擎相识整个网站结构，但权重分值一样平常没有运动链接（内容链接）高。
　　敷衍新的网页来讲，搜刮引擎在链接上会优先赐与一个补偿值，如许有助于它得到更多的链接与用户评价。
　　外部链接对网页的影响就像关键字密度一样被各人所存眷，链接笔墨地点页面的权重值、链接位置、链接数目都市在肯定程度上给促进网页链接权重增长。
　　用户评价权重：重要是搜刮引擎对搜刮结果中网页的用户评价盘算。
　　当用户搜刮某一关键字的时间，总是先欣赏搜刮结果的网页标题与择要部门，末了再决定点击本身以为有效的网页，若某个链接固然在返回结果表上出现的位置不太靠前，但被选取点击的次数比力多，于是搜刮引擎应该感慨该链接是比力受接待的，其位置应该往前调。
　　对与如许的评价方法，敷衍谁人排名考前的网页有很大的上风，而且用户并非只存眷搜刮结果第一页，第二页及反面的，也有大概被存眷，那么，在这里，搜刮引擎会对这些链接引入一个补偿值。
　　这里的补偿值是凭据用户点击搜刮结果每页的概率来盘算补偿因子，末了用这个补偿因子与用户评价权重值乘积求和得到。
　　附：百度权重盘算要领在谷歌推出中国市场之后，百度变得是越来越紧急了，百度权重固然不是由百度提出来的，但是却被浩繁的站长所追捧，关于探究百度权重盘算要领，若何进步百度权重，百度权重是什么意思的文章越发是到处都是，本日搜刮引擎优化天空就简单的扥想一下：百度权重的盘算要领：
　　关于站长东西内里百度权重的盘算要领：
　　百度流量在1到100之间的时间百度权重为百度流量在100到500之间百度权重为百度流量在500到1000之间百度权重为1000到5000之间的就是5000到10000就是10000到50000是5万到20万是20万到100是超过100万是网站关键字排名直接可以大概影响百度流量，而百度流量的巨细直接决定了百度权重的巨细（这就是站长东西现在对百度权重的逆向推理要领，以后大概会篡改）特殊阐发：站长东西的权重盘算要领是比力笼统的，只能大抵的看出网站权重，并不精准！百度从未公然其权重盘算要领！
　　百度自身也曾多次阐发：并没有百度权重这么一说，固然为什么会受到这么多搜刮引擎优化er的追捧，自然是有缘故起因的。','0','<p>权重的盘算要领是什么样的！在搜刮引擎优化词库中，存在一个名词，叫&ldquo;权重&rdquo;，权重是网页本身与查询词（以下俗称关键字）之间的干系度盘算。搜刮引擎在用户发送查找指令后，通常是凭据网页权重来举行排序，通常所说的网站权重，可以明白为网站首页的权重值。</p><div>　　网页权重的盘算依靠于基础权重、链接权重、用户评价权重三个方面：</div><div>　　网页基础权重：重要受到关键字的绝对权重、关键字频率、网页长度（与网页巨细区离开）的影响。</div><div>　　1、绝对权重搜刮引擎会对任何一个新的网页赋予一个缺省的权重值（有喜好的朋侪可以相识下TF*IDF算法），WEB尺度化是提升基础权重的紧急因素，一些标签将影响关键字的权重值，终极的基础权重值是这些因素举行相加得到的；2、关键字频率这一因素各人应该都非常清楚了，关键字频率的理论数据为2%-8%。关键字在网页中的位置都市存在一个权重值，对每个位置上的权重举行求和盘算，则可以得到关键字在整个页面的权重值。</div><div>　　3、网页长度上面提到的盘算方法都很公平，但假如思量到雷同的关键字出如今差别的网页中，网页的长度越长，那么，关键字可得到的权重值就会越高，以是，某一关键字的权重值在肯定程度上还受网页长度的影响。</div><div>　　网页链接权重：重要是内部链接和外部链接。敷衍内部链接来讲，为了公平，搜刮引擎一重般不会给较多的权分值，特殊是一些牢固位置的链接，这些简直有利用搜刮引擎相识整个网站结构，但权重分值一样平常没有运动链接（内容链接）高。</div><div>　　敷衍新的网页来讲，搜刮引擎在链接上会优先赐与一个补偿值，如许有助于它得到更多的链接与用户评价。</div><div>　　外部链接对网页的影响就像关键字密度一样被各人所存眷，链接笔墨地点页面的权重值、链接位置、链接数目都市在肯定程度上给促进网页链接权重增长。</div><div>　　用户评价权重：重要是搜刮引擎对搜刮结果中网页的用户评价盘算。</div><div>　　当用户搜刮某一关键字的时间，总是先欣赏搜刮结果的网页标题与择要部门，末了再决定点击本身以为有效的网页，若某个链接固然在返回结果表上出现的位置不太靠前，但被选取点击的次数比力多，于是搜刮引擎应该感慨该链接是比力受接待的，其位置应该往前调。</div><div>　　对与如许的评价方法，敷衍谁人排名考前的网页有很大的上风，而且用户并非只存眷搜刮结果第一页，第二页及反面的，也有大概被存眷，那么，在这里，搜刮引擎会对这些链接引入一个补偿值。</div><div>　　这里的补偿值是凭据用户点击搜刮结果每页的概率来盘算补偿因子，末了用这个补偿因子与用户评价权重值乘积求和得到。</div><div>　　附：百度权重盘算要领在谷歌推出中国市场之后，百度变得是越来越紧急了，百度权重固然不是由百度提出来的，但是却被浩繁的站长所追捧，关于探究百度权重盘算要领，若何进步百度权重，百度权重是什么意思的文章越发是到处都是，本日搜刮引擎优化天空就简单的扥想一下：百度权重的盘算要领：</div><div>　　关于站长东西内里百度权重的盘算要领：</div><div>　　百度流量在1到100之间的时间百度权重为百度流量在100到500之间百度权重为百度流量在500到1000之间百度权重为1000到5000之间的就是5000到10000就是10000到50000是5万到20万是20万到100是超过100万是网站关键字排名直接可以大概影响百度流量，而百度流量的巨细直接决定了百度权重的巨细（这就是站长东西现在对百度权重的逆向推理要领，以后大概会篡改）特殊阐发：站长东西的权重盘算要领是比力笼统的，只能大抵的看出网站权重，并不精准！百度从未公然其权重盘算要领！</div><div>　　百度自身也曾多次阐发：并没有百度权重这么一说，固然为什么会受到这么多搜刮引擎优化er的追捧，自然是有缘故起因的。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:37:52','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('47','14','0','欧式风格的设计要点','','','admin','1','0','','0','0','','0','','','','','2207','2014-10-11 16:40:48','admin','','/upload/images/201304/2207.jpg','1','1','我们做SEO优化一直都在强调不要轻易更改我们网站的标题，最好在做站初期就规划好自己的网站标题。要不然后期再做修改对我们的影响是可想而知的。就像你开一个店，如果天天改招牌，对你店里的生意影响是一样的。但是有些站一定要改，那么有没有好的办法，或者说修改TITLE后，如何快速恢复网站的权重呢最近我有个朋友一个站，上线了一个多月后听人家说网站的标题没有写好，结果他把整个标题给更改了，结果是导致搜索引擎的蜘蛛几周都没有光临他那个站，所以说网站权重不够的话，轻易更改标题很容易导致网站降权的。这个和我们现实生活差不多，我们本来对一个人相当熟悉，结果他把面部给整容了，那么我们在短时间能认识吗?肯定不会了，我们就必须花一段时间来重新认识，我们的网站标题也是一样，当我们更改标题后，搜索引擎是会需要花一段时间重新考察我们网站的，所以建议大家在建站前期想好网站标题，后期就不要修改了。但是现在我的这位朋友已经修改了文章标题，该怎么恢复网站权重呢?今天十堰SEO就来和大家谈谈网站标题更改后如何恢复网站权重：
　　一 、增加网站内容的质量在修改网站标题的一段时间内，尽可能的每天多更新几篇高质量的文章，因为搜索引擎是最喜欢这样的文章的，这样才能增加搜索引擎蜘蛛来我们网站的次数，让我们的网站早点通过审核期。
　　二 、去高质量的论坛，博客发外链去权重高的论坛，博客通过发链接诱饵，吸引蜘蛛来访问我们的网站，因为这些地方的蜘蛛访问量很大，通过这样的方式把蜘蛛带到我们的网站，增加蜘蛛访问你网站的频率，这样才会在最短的时间内让搜索引擎更新你的网站。
　　三 、通过友情链接带动如果我们有资源的话，可以找一些网站快照新的站点做友情链接，让这些站点带带，网站快照新代表蜘蛛是很喜欢的，说明蜘蛛访问的次数也是挺多的，这样也可以把蜘蛛引导到我们的站点。当然我们也可以通过友情链接交换平台，很多链接平台类收录很大的，可以把我们的网站提交到这些平台，因为友情链接平台因为有着大量的站长在上面更新，所以更新速度非常的快，有利于吸引蜘蛛到上来。
　　四 、门户站点博客像新浪，搜狐，天涯，网易这些博客的权重还是很高的，而且收录比较快，我们可以通过这些平台来引导蜘蛛去访问我们网站的次数，加快网站更新的速度。
　　五 、可以通过百度自己的产品百度对自己的产品待遇还是很好的，我们可以通过百度空间，百度百科，百度知道，百度贴吧等等，发布我们的内容，尽量带上链接地址，这样可以可以加快更新网站的内容。
　　通过上面六个方法，坚持4-8周的时间(一般百度的审核期是这么长)，相信网站的权重是会回来的，以上仅为个人观点，欢迎大家共同探讨，共同交流学习。','0','<p>&nbsp;　　我们做SEO优化一直都在强调不要轻易更改我们网站的标题，最好在做站初期就规划好自己的网站标题。要不然后期再做修改对我们的影响是可想而知的。就像你开一个店，如果天天改招牌，对你店里的生意影响是一样的。但是有些站一定要改，那么有没有好的办法，或者说修改TITLE后，如何快速恢复网站的权重呢最近我有个朋友一个站，上线了一个多月后听人家说网站的标题没有写好，结果他把整个标题给更改了，结果是导致搜索引擎的蜘蛛几周都没有光临他那个站，所以说网站权重不够的话，轻易更改标题很容易导致网站降权的。这个和我们现实生活差不多，我们本来对一个人相当熟悉，结果他把面部给整容了，那么我们在短时间能认识吗?肯定不会了，我们就必须花一段时间来重新认识，我们的网站标题也是一样，当我们更改标题后，搜索引擎是会需要花一段时间重新考察我们网站的，所以建议大家在建站前期想好网站标题，后期就不要修改了。但是现在我的这位朋友已经修改了文章标题，该怎么恢复网站权重呢?今天十堰SEO就来和大家谈谈网站标题更改后如何恢复网站权重：</p><div>　　一 、增加网站内容的质量在修改网站标题的一段时间内，尽可能的每天多更新几篇高质量的文章，因为搜索引擎是最喜欢这样的文章的，这样才能增加搜索引擎蜘蛛来我们网站的次数，让我们的网站早点通过审核期。</div><div>　　二 、去高质量的论坛，博客发外链去权重高的论坛，博客通过发链接诱饵，吸引蜘蛛来访问我们的网站，因为这些地方的蜘蛛访问量很大，通过这样的方式把蜘蛛带到我们的网站，增加蜘蛛访问你网站的频率，这样才会在最短的时间内让搜索引擎更新你的网站。</div><div>　　三 、通过友情链接带动如果我们有资源的话，可以找一些网站快照新的站点做友情链接，让这些站点带带，网站快照新代表蜘蛛是很喜欢的，说明蜘蛛访问的次数也是挺多的，这样也可以把蜘蛛引导到我们的站点。当然我们也可以通过友情链接交换平台，很多链接平台类收录很大的，可以把我们的网站提交到这些平台，因为友情链接平台因为有着大量的站长在上面更新，所以更新速度非常的快，有利于吸引蜘蛛到上来。</div><div>　　四 、门户站点博客像新浪，搜狐，天涯，网易这些博客的权重还是很高的，而且收录比较快，我们可以通过这些平台来引导蜘蛛去访问我们网站的次数，加快网站更新的速度。</div><div>　　五 、可以通过百度自己的产品百度对自己的产品待遇还是很好的，我们可以通过百度空间，百度百科，百度知道，百度贴吧等等，发布我们的内容，尽量带上链接地址，这样可以可以加快更新网站的内容。</div><div>　　通过上面六个方法，坚持4-8周的时间(一般百度的审核期是这么长)，相信网站的权重是会回来的，以上仅为个人观点，欢迎大家共同探讨，共同交流学习。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:40:48','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('48','14','0','享受中西混搭装修风格的奇妙感觉','','','admin','1','0','','0','0','','0','','','','','2208','2014-10-11 16:41:54','admin','','/upload/images/201304/2208.jpg','1','1','强调剂性诉求的上网站多以成立企业抽象为主，以效劳为导向。那儿那里的效劳有两规模含意，一是自身企业需要的即是效劳，如效劳事业；二是企业的售前、售后效劳。经由效劳晋升企业正在存户心中的位置，从而推进营销，这一典型则定然要正视网站的格调设想和创意，以理性诉求为主，苦心衬着或者营建一种特部门企业空气，苦心默示一种网站或者货色及效劳的价钱感，决没有能顿挫顿挫，更没有能可是将保守的效劳搬到网下去，我看面前绝年夜年夜少数网站就是那样，咱们需要什么什么效劳，欢送与咱们联络，之类，试想，互联收集然则一度虚构的前提，您没有给阅读者营建一种守信的气氛，别人凭什么置信你的效劳呢？事实中企业的信用正在网上一样无效。你能够找没有出本人真正存正在主力的中心，没有主要，咱们能够经过网站创立，回过甚来扫视一下本人的公司、企业，从新为企业塑造一度新的抽象定位，并正在当前的经营中下力量增强创设，从而外行业中自成一家，力争正在顾客心中营建一种簇新的抽象，并发生思疑感。请您细心思忖一下：SEO搜索引擎络上成千盈百的共事业网站，顾客干什么购置或者运用你的货物或者效劳，而没有取舍合作者的货物或者效劳？市道经济是合作性的。你必需为世人取舍你的品牌而没有是别人的品牌创举说辞。因而，一局限，要增强出格气氛的营建，正在理性诉求凹凸功力，消弭企业与顾客正在功夫与时刻上的距离，构建存户忠厚度，增多存户价格，经过拓展、构建、维持并强化存户联系使自己效益最年夜化 ； 另一范围，好好设想你的网站，配合的设想可以营建一种共同的企业文明——互联网络企业文明，或者许这与保守营销格调没有符，没有重要，没有要过度于依托保守营销！ 网站建树：
　　剖析规范楷模也对比罕有，便是将下面而二者连系兴起，因为关于统一种货物，没有同的人能够基于没有同的抉择——偶然货物自身的特功能够决议你是感性的仍是理性的。因而，正在网站的气氛营建上就要寄望区分：假如某一范围没有能充沛注明货物或者效劳的特点，就要将二者联合兴起，正在没有同的全体分辩遏制感性和理性的诉求，借以打动没有同类型的顾客，既以少量的现实一般企业的手艺劣势，又营建一种理性的气氛，强调货物或者效劳给人带来的价格，经过二者的联合，零丁营建企业共同的气氛。正常来说，以理性为主的网站多为消费范例的企业，而理性诉求为主的网站多为效劳范例的企业，万万这种总结法子并没有是相对于的，无意，作为消费型的企业，其网站能够是效劳型的，也有能够是说明型的，也有能够一度网站正在没有同声代取舍没有同范例的网站，正在诉求格调上也就没有一样。但无论是什么范例，照旧那句话，所有为营销效劳，那样，网站能力施展其真正的价格。','0','<p>强调剂性诉求的上网站多以成立企业抽象为主，以效劳为导向。那儿那里的效劳有两规模含意，一是自身企业需要的即是效劳，如效劳事业；二是企业的售前、售后效劳。经由效劳晋升企业正在存户心中的位置，从而推进营销，这一典型则定然要正视网站的格调设想和创意，以理性诉求为主，苦心衬着或者营建一种特部门企业空气，苦心默示一种网站或者货色及效劳的价钱感，决没有能顿挫顿挫，更没有能可是将保守的效劳搬到网下去，我看面前绝年夜年夜少数网站就是那样，咱们需要什么什么效劳，欢送与咱们联络，之类，试想，互联收集然则一度虚构的前提，您没有给阅读者营建一种守信的气氛，别人凭什么置信你的效劳呢？事实中企业的信用正在网上一样无效。你能够找没有出本人真正存正在主力的中心，没有主要，咱们能够经过网站创立，回过甚来扫视一下本人的公司、企业，从新为企业塑造一度新的抽象定位，并正在当前的经营中下力量增强创设，从而外行业中自成一家，力争正在顾客心中营建一种簇新的抽象，并发生思疑感。请您细心思忖一下：SEO搜索引擎络上成千盈百的共事业网站，顾客干什么购置或者运用你的货物或者效劳，而没有取舍合作者的货物或者效劳？市道经济是合作性的。你必需为世人取舍你的品牌而没有是别人的品牌创举说辞。因而，一局限，要增强出格气氛的营建，正在理性诉求凹凸功力，消弭企业与顾客正在功夫与时刻上的距离，构建存户忠厚度，增多存户价格，经过拓展、构建、维持并强化存户联系使自己效益最年夜化 ； 另一范围，好好设想你的网站，配合的设想可以营建一种共同的企业文明&mdash;&mdash;互联网络企业文明，或者许这与保守营销格调没有符，没有重要，没有要过度于依托保守营销！ 网站建树：</p><div>　　剖析规范楷模也对比罕有，便是将下面而二者连系兴起，因为关于统一种货物，没有同的人能够基于没有同的抉择&mdash;&mdash;偶然货物自身的特功能够决议你是感性的仍是理性的。因而，正在网站的气氛营建上就要寄望区分：假如某一范围没有能充沛注明货物或者效劳的特点，就要将二者联合兴起，正在没有同的全体分辩遏制感性和理性的诉求，借以打动没有同类型的顾客，既以少量的现实一般企业的手艺劣势，又营建一种理性的气氛，强调货物或者效劳给人带来的价格，经过二者的联合，零丁营建企业共同的气氛。正常来说，以理性为主的网站多为消费范例的企业，而理性诉求为主的网站多为效劳范例的企业，万万这种总结法子并没有是相对于的，无意，作为消费型的企业，其网站能够是效劳型的，也有能够是说明型的，也有能够一度网站正在没有同声代取舍没有同范例的网站，正在诉求格调上也就没有一样。但无论是什么范例，照旧那句话，所有为营销效劳，那样，网站能力施展其真正的价格。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:41:54','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('49','15','0','房子装修贴墙纸注意问题','','','admin','1','0','','0','0','','0','','','','','2308','2014-10-11 16:48:03','admin','','/upload/images/201304/2308.jpg','1','1','SEO优化也即是查找引擎优化，SEO查找引擎优化也即是博客内容被查找引擎录入及优先排序，以此添加博客的点击率和曝光度，终究提升博客的归纳能力。写博客的人，内容不只要对用户友爱，让大部门人都能看懂，并且也要对查找引擎友爱。这儿首要介绍下卢松松常用的博客SEO优化窍门。 
   1：博客要经常连接更新，文字一直紧紧盘绕关头字，环绕上彀站主题。 
   2：SEO优化重点以文章内容页优化为主。 
   3：恰当给每个页面添加环节词页面描绘索引擎抓取器标签。 
   4：在新文章中恰当添加一些老文章的连接，文章的内部连接必定要天然。 
   5：新博客可以建立单一纽带词战略，以增强网站对查找引擎的威望性。如卢松松博客创建初期只要一个网站设计关键词。 
   6：节目分类尽量运用目录方式。如：不是 
   7：可以在页面底部加上站点地图HTML名目是给用户看的，XML花式是给查找引擎看的。 
   8：斗劲首要文章的URL可以运用拼音、英文和朋分线等网址构造。 
   9：外部连接扶植很重要，新博客推荐运用东西 
   10：废物留言一定要删去，很是影响排行。 
   11：记住给每个博文插图加上和文章内容有关的alt信息，并在图像附近添加有关信息。 
   12：文章中不异的关键字不能过多，如果非要堆砌关键字，可恰当运用长尾关键字。 
   13：每篇文章的结尾处可干预“自创文章如G标签可以增强主题的有关性和被查找的概率。 
   15：文章的Title最佳以“文章疑问-博客称号”方式呈现。 
   16：文章标题最佳能泛起一次关键字。 
   17：关键字最佳在第一段或最终一段可以呈现。 
   18：不要选择极端热门的关键字。 
   19：不要一次性添加很多毗邻，更不要一次性删减很多毗邻。 
   20：坚持! 
   SEO到今朝停止，最威望的定义为： 
   查找引擎优化engine 简称查找引擎优化指遵循查找引擎的查找事理，对网站机关、页面文字说话和站点间互动交际略等进行合理计划布置，以改进网站在查找引擎的查找默示，进而添加客户发现并访谒网站的可能性的这样一个进程. 查找引擎优化也是一种科学的成长不美观和编制论，它跟着查找引擎的开展而开展, 一起也促进了查找引擎的开展。','0','<p>SEO优化也即是查找引擎优化，SEO查找引擎优化也即是博客内容被查找引擎录入及优先排序，以此添加博客的点击率和曝光度，终究提升博客的归纳能力。写博客的人，内容不只要对用户友爱，让大部门人都能看懂，并且也要对查找引擎友爱。这儿首要介绍下卢松松常用的博客SEO优化窍门。&nbsp;</p><div>&nbsp; &nbsp;1：博客要经常连接更新，文字一直紧紧盘绕关头字，环绕上彀站主题。&nbsp;</div><div>&nbsp; &nbsp;2：SEO优化重点以文章内容页优化为主。&nbsp;</div><div>&nbsp; &nbsp;3：恰当给每个页面添加环节词页面描绘索引擎抓取器标签。&nbsp;</div><div>&nbsp; &nbsp;4：在新文章中恰当添加一些老文章的连接，文章的内部连接必定要天然。&nbsp;</div><div>&nbsp; &nbsp;5：新博客可以建立单一纽带词战略，以增强网站对查找引擎的威望性。如卢松松博客创建初期只要一个网站设计关键词。&nbsp;</div><div>&nbsp; &nbsp;6：节目分类尽量运用目录方式。如：不是&nbsp;</div><div>&nbsp; &nbsp;7：可以在页面底部加上站点地图HTML名目是给用户看的，XML花式是给查找引擎看的。&nbsp;</div><div>&nbsp; &nbsp;8：斗劲首要文章的URL可以运用拼音、英文和朋分线等网址构造。&nbsp;</div><div>&nbsp; &nbsp;9：外部连接扶植很重要，新博客推荐运用东西&nbsp;</div><div>&nbsp; &nbsp;10：废物留言一定要删去，很是影响排行。&nbsp;</div><div>&nbsp; &nbsp;11：记住给每个博文插图加上和文章内容有关的alt信息，并在图像附近添加有关信息。&nbsp;</div><div>&nbsp; &nbsp;12：文章中不异的关键字不能过多，如果非要堆砌关键字，可恰当运用长尾关键字。&nbsp;</div><div>&nbsp; &nbsp;13：每篇文章的结尾处可干预&ldquo;自创文章如G标签可以增强主题的有关性和被查找的概率。&nbsp;</div><div>&nbsp; &nbsp;15：文章的Title最佳以&ldquo;文章疑问-博客称号&rdquo;方式呈现。&nbsp;</div><div>&nbsp; &nbsp;16：文章标题最佳能泛起一次关键字。&nbsp;</div><div>&nbsp; &nbsp;17：关键字最佳在第一段或最终一段可以呈现。&nbsp;</div><div>&nbsp; &nbsp;18：不要选择极端热门的关键字。&nbsp;</div><div>&nbsp; &nbsp;19：不要一次性添加很多毗邻，更不要一次性删减很多毗邻。&nbsp;</div><div>&nbsp; &nbsp;20：坚持!&nbsp;</div><div>&nbsp; &nbsp;SEO到今朝停止，最威望的定义为：&nbsp;</div><div>&nbsp; &nbsp;查找引擎优化engine 简称查找引擎优化指遵循查找引擎的查找事理，对网站机关、页面文字说话和站点间互动交际略等进行合理计划布置，以改进网站在查找引擎的查找默示，进而添加客户发现并访谒网站的可能性的这样一个进程. 查找引擎优化也是一种科学的成长不美观和编制论，它跟着查找引擎的开展而开展, 一起也促进了查找引擎的开展。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:48:03','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('50','15','0','大理石台面耐用不','','','admin','1','0','','0','0','','0','','','','','2307','2014-10-11 16:48:53','admin','','/upload/images/201304/2307.jpg','1','1','现在在网站优化这个行业中，已经有越来越多的站长认识到了内链的重要性，可是一些新手站长还是对内链这个概念模模糊糊的，其实随着现在搜索引擎算法的不段改进，内链和外链已经到了一个同等重要性的位置了，对于内链来说不同角度不同方向的人会有不同的看法，下面就给大家说一说从不同的方向看内链都有哪些不同的作用。
　　一、利于增加网站收录量蜘蛛爬行网站是按超链接的，其实蜘蛛在爬行时就你用户点击网站中的超链接来进入内容页，咱们可以把蜘蛛当成是一个用户，而这个用户往往是每天来访都是全站访问的。但是有一个缺点就是它并不具备感情。而且还要站长设置好网站的内链，让它顺畅的绕着网站内容爬行。许多的网站收录不给力原因在哪里?其实最基本的一点就是无法给蜘蛛提供高速爬行通道，这里出现了断路，那里出现了死胡同，这就让蜘蛛爬行网站时浪费很多时间，而且每次进入死胡同时，蜘蛛都要重新回到首页去，这样一来蜘蛛又要重新爬行网站了，进而就会造成网站被重复收录这是常规现象。有了合理的内链就不会造成这种情况的发生，当站长把每篇内容下面左右都设置好相关的内容版块时，自然就可以引导蜘蛛更有效的爬行完整站，自然收录也会涨起来的。而且对于利用内链来提升网站的收录量并不是什么稀奇的事，一般收录高的网站内链都是做得特别到位的。
　　二、利于提升关键词排名外链可以有效的提升关键词排名而内链就是加已巩固排名最好的方法之一。对于内链的作用，其实最基本一点也是可以提升关键词排名的。而且通过内链优化来提升关键词排名，可以使自己在与对手竞争时，更有稳定性，因为同样的方法，取胜之处就在于细节方面的处理，而内链往往是细节中最重要的一环，所以内链的实际作用就目前来说，跟外链的作用是不相上下的。而且要让搜索引挚重视自己的网站，自然通过内链可以更好的使网站的内容相关性更强，自然搜索引挚对于具有文不离题内容的网站适当的照顾一下的。所以，而且内链中的关键词还可以提升网站关键词的整体密度，进而对提升关键词排名起到一定的帮助。所以说内链的最根本的一个作用就是可以帮助网站提升关键词排名，要不然站长也不会越来越重视内链优化了。
　　三、利于提升用户体验内链最为关键词的一个作用就是可以提用户的访问深度，也就是打造良好的用户体验，对于用户体验可谓是让所有站长又爱又恨。但是很多网站流量很高，却留不住用户，无法缔造出良好的用户体验归其原因就是出现在内链不够强大，鄙人的淘宝热卖','0','<p>现在在网站优化这个行业中，已经有越来越多的站长认识到了内链的重要性，可是一些新手站长还是对内链这个概念模模糊糊的，其实随着现在搜索引擎算法的不段改进，内链和外链已经到了一个同等重要性的位置了，对于内链来说不同角度不同方向的人会有不同的看法，下面就给大家说一说从不同的方向看内链都有哪些不同的作用。</p><div>　　一、利于增加网站收录量蜘蛛爬行网站是按超链接的，其实蜘蛛在爬行时就你用户点击网站中的超链接来进入内容页，咱们可以把蜘蛛当成是一个用户，而这个用户往往是每天来访都是全站访问的。但是有一个缺点就是它并不具备感情。而且还要站长设置好网站的内链，让它顺畅的绕着网站内容爬行。许多的网站收录不给力原因在哪里?其实最基本的一点就是无法给蜘蛛提供高速爬行通道，这里出现了断路，那里出现了死胡同，这就让蜘蛛爬行网站时浪费很多时间，而且每次进入死胡同时，蜘蛛都要重新回到首页去，这样一来蜘蛛又要重新爬行网站了，进而就会造成网站被重复收录这是常规现象。有了合理的内链就不会造成这种情况的发生，当站长把每篇内容下面左右都设置好相关的内容版块时，自然就可以引导蜘蛛更有效的爬行完整站，自然收录也会涨起来的。而且对于利用内链来提升网站的收录量并不是什么稀奇的事，一般收录高的网站内链都是做得特别到位的。</div><div>　　二、利于提升关键词排名外链可以有效的提升关键词排名而内链就是加已巩固排名最好的方法之一。对于内链的作用，其实最基本一点也是可以提升关键词排名的。而且通过内链优化来提升关键词排名，可以使自己在与对手竞争时，更有稳定性，因为同样的方法，取胜之处就在于细节方面的处理，而内链往往是细节中最重要的一环，所以内链的实际作用就目前来说，跟外链的作用是不相上下的。而且要让搜索引挚重视自己的网站，自然通过内链可以更好的使网站的内容相关性更强，自然搜索引挚对于具有文不离题内容的网站适当的照顾一下的。所以，而且内链中的关键词还可以提升网站关键词的整体密度，进而对提升关键词排名起到一定的帮助。所以说内链的最根本的一个作用就是可以帮助网站提升关键词排名，要不然站长也不会越来越重视内链优化了。</div><div>　　三、利于提升用户体验内链最为关键词的一个作用就是可以提用户的访问深度，也就是打造良好的用户体验，对于用户体验可谓是让所有站长又爱又恨。但是很多网站流量很高，却留不住用户，无法缔造出良好的用户体验归其原因就是出现在内链不够强大，鄙人的淘宝热卖</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:48:53','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('51','15','0','大理石橱柜多少钱一平米','','','admin','1','0','','0','0','','0','','','','','2306','2014-10-11 16:51:51','admin','','/upload/images/201304/2306.jpg','1','1','一、赋有弹性的出色心态做优化便是用自己的才智与阅历和查找引擎“斗智斗法”，面对查找引擎的调整，无论是站长仍是SEOER都处于被逼的境地，特别像baidu常常运用 人工ganyu查找效果，对于算法系统常常性的调整使得网站优化效果常常会出现不稳定改变的表象。面对这种实力不对等的境况和查找引擎改变 的特征，作为专业从事SEO的工作者而言，需要首要练就的便是一副赋有弹性的出色心态，优良的SEOER需要坚持淡定 不紧张的心态，能够做到从容应对。
　　二、堆集各种优化可用的本钱专业的SEO需要运用到林林总总的本钱，从高质量的内容来历到优质的外链发布本钱，都是在打开网站优化进程中有必要用到的。网站的优化工作是一 项涉及到内容、关键词、外链、内链等各个元素的系统化工作，因此在打开有关的工作时需要堆集有满足丰厚的本钱，才有利于能够快速地按照既定的优化方案实 施。优良的SEOER应当在优化打开之前和往常的工作进程中留意搜集和堆集各种今后能够运用的本钱，前进工作的功率和有效性。
　　三、需要出色的沟通和展示诀窍作为专业的SEOER，无论是在接单时仍是在优化进程中与客户的沟通进程中，都需要向客户介绍自己**的优化方案，在施行SEO进程中还需要 及时向客户通报工作进展，以及展示现已到达的优化效果等，这些既是增强接单才干，能够抢夺获得更多客户的才干，也是获得客户的进一步信任与一定，保护好客 情联络，做好后续的客户服务工作的必要技能，因此应当是优良的SEOER必备的才干。
　　四、勇于活泼进行优化检验和立异在具体的优化方法上，虽然有很多咱们所熟知和堆集出来的优化阅历与方法，但是由于查找引擎的算法不断地进行改动，所以要想能够及时捉住查找引 擎最新的算法，做到在优化进程中及时迎合其算法标准，以期获得更佳的效果。因此，要获得最新的查找引擎算法改变状况，优良的SEOER应当勇于活泼进行大 胆的检验，按照自己的阅历运用一些优化措施，来检验查找引擎对于这些优化方法的反响，极力走在同行的前列。
　　五、善用对优化效果进行监控和总结每一个网站的优化项目对于SEOER而言都是一次优化技能的检查和前进，在不一样期间的优化进程中，总能让咱们得到全新的阅历，特别是对于查找 引擎不断改变的算法都能够有更多的知道与掌握。因此，在打开优化的进程中，优良的SEOER要长于对每一次的优化项目进行必要而及时的监控，及时知道和掌 握优化方法所获得的效果，对于效果和缺少做及时的总结，从而在总结和反思之中完善和前进SEO的优化技能。','0','<p>一、赋有弹性的出色心态做优化便是用自己的才智与阅历和查找引擎&ldquo;斗智斗法&rdquo;，面对查找引擎的调整，无论是站长仍是SEOER都处于被逼的境地，特别像baidu常常运用 人工ganyu查找效果，对于算法系统常常性的调整使得网站优化效果常常会出现不稳定改变的表象。面对这种实力不对等的境况和查找引擎改变 的特征，作为专业从事SEO的工作者而言，需要首要练就的便是一副赋有弹性的出色心态，优良的SEOER需要坚持淡定 不紧张的心态，能够做到从容应对。</p><div>　　二、堆集各种优化可用的本钱专业的SEO需要运用到林林总总的本钱，从高质量的内容来历到优质的外链发布本钱，都是在打开网站优化进程中有必要用到的。网站的优化工作是一 项涉及到内容、关键词、外链、内链等各个元素的系统化工作，因此在打开有关的工作时需要堆集有满足丰厚的本钱，才有利于能够快速地按照既定的优化方案实 施。优良的SEOER应当在优化打开之前和往常的工作进程中留意搜集和堆集各种今后能够运用的本钱，前进工作的功率和有效性。</div><div>　　三、需要出色的沟通和展示诀窍作为专业的SEOER，无论是在接单时仍是在优化进程中与客户的沟通进程中，都需要向客户介绍自己**的优化方案，在施行SEO进程中还需要 及时向客户通报工作进展，以及展示现已到达的优化效果等，这些既是增强接单才干，能够抢夺获得更多客户的才干，也是获得客户的进一步信任与一定，保护好客 情联络，做好后续的客户服务工作的必要技能，因此应当是优良的SEOER必备的才干。</div><div>　　四、勇于活泼进行优化检验和立异在具体的优化方法上，虽然有很多咱们所熟知和堆集出来的优化阅历与方法，但是由于查找引擎的算法不断地进行改动，所以要想能够及时捉住查找引 擎最新的算法，做到在优化进程中及时迎合其算法标准，以期获得更佳的效果。因此，要获得最新的查找引擎算法改变状况，优良的SEOER应当勇于活泼进行大 胆的检验，按照自己的阅历运用一些优化措施，来检验查找引擎对于这些优化方法的反响，极力走在同行的前列。</div><div>　　五、善用对优化效果进行监控和总结每一个网站的优化项目对于SEOER而言都是一次优化技能的检查和前进，在不一样期间的优化进程中，总能让咱们得到全新的阅历，特别是对于查找 引擎不断改变的算法都能够有更多的知道与掌握。因此，在打开优化的进程中，优良的SEOER要长于对每一次的优化项目进行必要而及时的监控，及时知道和掌 握优化方法所获得的效果，对于效果和缺少做及时的总结，从而在总结和反思之中完善和前进SEO的优化技能。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:51:51','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('52','15','0','地砖鼓起是什么原因','','','admin','1','0','','0','0','','0','','','','','2305','2014-10-11 16:52:42','admin','','/upload/images/201304/2305.jpg','1','1','序言：标题里的标准化的需求其实是为了吸引大家的，它是不可能有标准化的，我们要追求标题个性化，但也可以做标准化的，因为很多的人不知道该怎么做。
　　一、标题应该怎么做怎么样来选择标题，标题要求很简单，他需要有几个特性，大的行业靠长尾关键词，小的行业靠目标关键词，而淘宝客严格意义来说是大的行业，这里说大指的是行业的受众。淘宝客可以做任何行业的受众，它是一个大的行业。同样旅游也是大的行业。而中小型企业点的行业就是小的行业。所以说目标和长尾是一个相对的概念。比如说云南旅游，它的受众很大，可以做目标词，而去云南旅游的注意事项就是长尾词，它是相对的。
　　1、标题应该去找寻有转换率的而关注度较少的长尾词(竞争度非常少所指的是目录页和内页，目录页可以寄居到一些大型站点下面，比如很多的企业去阿里巴巴开一个二级域名的店铺等。
　　它是一个目录页或者是二级域名。现在有一个问题就是它没有流量，或者有流量没有转换率。而我们seo是要解决这个问题的。流量和转换率是由关键词产生的。关键词有转换率的很多，不能每个都做，大家都认为可以做的词，我们就不要去做的，商业竞争是非常残酷的。
　　我们要选择的词就是大伙还没有发现或者有少数人发现的我们可以去竞争得过人家的词。怎么知道这个词有转换呢?这就一定要做关键词词库，词库就是我们知道有一些词有流量，这种词会大量存在的，而且有规律的，是可以进行推理和推导的，这个词库的统计是一个长期且漫长的过程，通过词库就可以淘汰很多的词。
　　这里举个例子，比如一个做医药类网站，化此类网站，首先就是有规律的更新一些白癜风原创文章，文章的标题很重要，它体现你这篇文章的中心内容，文章内容最好原创，再加上河南白癜风医院的关键词，而河南白癜风医院的密度就需要自己把握;其次就是去一些与白癜风相关的医药健康类网站发外链，比如BBS论坛、Blog博客和B2B分类信息平台，外链内容与白癜风相关，加上河南白癜风医院的锚链最好;最后就是一些友情链接的交换了，要知道，网站优化比不是一朝一夕的是，三天打鱼两天晒网是不可取的，站长们一定要勤劳才可以见效果的。','0','<p>序言：标题里的标准化的需求其实是为了吸引大家的，它是不可能有标准化的，我们要追求标题个性化，但也可以做标准化的，因为很多的人不知道该怎么做。</p><div>　　一、标题应该怎么做怎么样来选择标题，标题要求很简单，他需要有几个特性，大的行业靠长尾关键词，小的行业靠目标关键词，而淘宝客严格意义来说是大的行业，这里说大指的是行业的受众。淘宝客可以做任何行业的受众，它是一个大的行业。同样旅游也是大的行业。而中小型企业点的行业就是小的行业。所以说目标和长尾是一个相对的概念。比如说云南旅游，它的受众很大，可以做目标词，而去云南旅游的注意事项就是长尾词，它是相对的。</div><div>　　1、标题应该去找寻有转换率的而关注度较少的长尾词(竞争度非常少所指的是目录页和内页，目录页可以寄居到一些大型站点下面，比如很多的企业去阿里巴巴开一个二级域名的店铺等。</div><div>　　它是一个目录页或者是二级域名。现在有一个问题就是它没有流量，或者有流量没有转换率。而我们seo是要解决这个问题的。流量和转换率是由关键词产生的。关键词有转换率的很多，不能每个都做，大家都认为可以做的词，我们就不要去做的，商业竞争是非常残酷的。</div><div>　　我们要选择的词就是大伙还没有发现或者有少数人发现的我们可以去竞争得过人家的词。怎么知道这个词有转换呢?这就一定要做关键词词库，词库就是我们知道有一些词有流量，这种词会大量存在的，而且有规律的，是可以进行推理和推导的，这个词库的统计是一个长期且漫长的过程，通过词库就可以淘汰很多的词。</div><div>　　这里举个例子，比如一个做医药类网站，化此类网站，首先就是有规律的更新一些白癜风原创文章，文章的标题很重要，它体现你这篇文章的中心内容，文章内容最好原创，再加上河南白癜风医院的关键词，而河南白癜风医院的密度就需要自己把握;其次就是去一些与白癜风相关的医药健康类网站发外链，比如BBS论坛、Blog博客和B2B分类信息平台，外链内容与白癜风相关，加上河南白癜风医院的锚链最好;最后就是一些友情链接的交换了，要知道，网站优化比不是一朝一夕的是，三天打鱼两天晒网是不可取的，站长们一定要勤劳才可以见效果的。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:52:42','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('53','15','0','橙绿点缀,现代简约装修','','','admin','1','0','','0','0','','0','','','','','2304','2014-10-11 16:53:47','admin','','/upload/images/201304/2304.jpg','1','1','“怎样做有效的点击链接?”有朋侪在我博客内留言发问，我想这正是我们各人在以后搜刮引擎优化实践中不绝积极探索的标题，但要想管理“怎样做有效的点击链接”的标题，A5悦怀营销()唐世军以为，起首必须改变看法。
　　在翻译的《搜刮引擎优化艺术》书中，作者将我们所说的“做外链(发外链)”称为“基于网站内容基础之上”的“外链营销”。
　　在云云的外链营销中，我们渴望通过外链方法营销推广的东西就是外链页面内容(或服务)，它必须是值得通过其他网站站长故意识地用链接情势保举的内容页面——百度《搜刮引擎优化指南2.0》中说：“我们经常说的超链，就是(用户)保举的一种(情势)”。
　　《搜刮引擎优化艺术》书中则说：“人们不会链接向低质量内容或用户体验差的网站(除非得到某种利益作为补偿)，除非你荣幸地拥有一个着名品牌，否则人们也不会链接向一个纯粹的贸易网站。你必须为用户提供有代价的东西，也要提供奇特的东西”——你所链接的内面内容必须赐与别人一些东西。
　　而且，既然是“外链营销”，在网站外链建计划谋订定与实行历程中，就必须充实思量营销受众的生理，由于只有捉住营销受众生理的营销举动才大概得到预期的乐成——时下最有说服力的例子是，当大陆扫货者在香港想购置低利润产物时，洞悉大陆客生理的香港卖家一句“我们香港人才不消谁人牌子呢”，结果大陆客就乖乖地被香港卖家牵着鼻子走了。
　　外链营销也不例外，《搜刮引擎优化艺术》书中说：“有些东西天生能吸引链接，由于能触发(读者)生理和情感回声——自负、分享、消息性等。充实利用这些触发性因素，为那些能影响网站内容的访问者(作家、站长、博客作者)制造一个有说服力的来由来引用你的作品，你的链接创建就将会乐成”。
　　因此，作为一个企业网站外链营销专员，我们必须思索，本行业用户存眷的话题是什么?而我网站能赐与别人的奇特内容有些什么呢?海内站长每每缺乏这方面的战略考量，横竖“发外链”呗，能留下外链、被搜刮引擎收录就是乐成，基础不思量受众感觉(这不能完全怪外链专员，很多公司就是以数目考核外链专员的)，从他们的角度来说，如许的外链乐成了，但很难到达“产生高点击率”的外链营销结果。
　　《搜刮引擎优化艺术》作者提示我们，在确定网站外链建计划谋时，起首必须“摸清家底”，晓得本身网站如今有什么内容，可以增长什么内容，我网站特色在那边，用户需求是什么，扬长避短，来确定我们本身“基于网站内容的链接建计划谋”。
　　好比，提问那位朋侪做的是打扮网站，网站内容很难出新，但面对同样标题，淘宝一些女装店家本身做模特儿，展示本身打扮格局的特点，取得较好的营销结果。假如在如许别开生面的内容基础之上，在一些女性消耗者居多的论坛(或微博)挑选出两幅良好图片做“外链营销”，就能很好地收到点击外链的结果。
　　而且如许基于高质量内容的链接，很容易成为“链接诱饵”，被更多用户、网站站长保举，到达“真正的搜刮引擎优化能手只晓得本身外链到处都有，但却不晓得是谁帮创建的”田地。
　　这阐发白内容大概雷同，但由于体现情势的差别，内容受众的生理感觉也肯定差别，以致美学家对美的界说都是“美是故意味的情势”——紧急的是“探求更能引起受众共鸣的内容体现情势”，而不是你体现的东西与众差别。
　　必须指出的是，如许“探求更能引起受众共鸣的内容体现情势”，不但对网站内容构建有启示作用，对“外链营销”也同样。《搜刮引擎优化艺术》中说：“可以用差别种类的内容(同一内容的差别体现情势)吸引链接。文章、有吸引力的图片、视频、东西、以致开辟线上游戏”。好比一些民营医院举行网络手术视频直播，一段时间内直播地点不绝地被各大网站管理员及网友自觉保举分享。
　　别的，敷衍内容大同小异的企业网站来说，无论是网站内容构建还是外链营销环节，捉住“时效性话题”做文章是一个“拓展内家”的好要领。任何时间网络上都不缺乏热门的“时效性话题”，只要我们本身的网站可以大概不绝地捉住具有干系性的“时效性话题”做文章，只要实时奇妙地从中掘客到本身网站的奇特卖点(肯定要有本身新意，而且不能委曲)，借势营销，不难想象，这类盛行话题带来的外链点击率肯定不会低——好比做女装的网站，前些日子就不应该放过不胫而走的“齐B小短裙”话题。
　　末了，就是坚持，不要怕累，不要怕被模拟，不要怕一段时间内结果不显着，以致不如“内容只是偶尔义穿插关键字”的传统“发外链，引蜘蛛”本领。坚持下去。由于任何营销本领都必须坚持才气收效——外链营销也不例外。
　　特殊要提示列位搜刮引擎优化ER的是，不要为本身找放弃的捏词来由，好比“海内网站都是复制收罗伪原创”。这简直是毕竟，但我们不能等待情况好了再做。只要降服困难坚持下去，就肯定会有效果。
　　而且，将如许“基于内容的外链建计划谋”坚持下去，再辅以其他宣传营销本领(好比消息营销等)，一段时间以后，就能有效拉开与其他同类网站的隔断，真正实现网站品牌化的终极营销目的。
　　末了，《搜刮引擎优化艺术》将“外链营销”总结为：“良好的链接创建来自于简单的观点：创建好的内容，陈诉其他人，鼓励他们分享”。
　　这阐发，包罗外链营销在内的统统营销推广实质上都是内容营销，不能将网站内容与网站外链营销破碎开来，网站内容质量与外链质量密切干系——这才是链接干系性的真实寄义。假如你网站内容(服务)真的很优质，你的外链质量肯定不会差，肯定能产生无数赢得更多点击的优质外链;而一个用户体验良好，让人产生点击激动的外链，它所指向页面的内容质量也不会低。','0','<p>&ldquo;怎样做有效的点击链接?&rdquo;有朋侪在我博客内留言发问，我想这正是我们各人在以后搜刮引擎优化实践中不绝积极探索的标题，但要想管理&ldquo;怎样做有效的点击链接&rdquo;的标题，A5悦怀营销()唐世军以为，起首必须改变看法。</p><div>　　在翻译的《搜刮引擎优化艺术》书中，作者将我们所说的&ldquo;做外链(发外链)&rdquo;称为&ldquo;基于网站内容基础之上&rdquo;的&ldquo;外链营销&rdquo;。</div><div>　　在云云的外链营销中，我们渴望通过外链方法营销推广的东西就是外链页面内容(或服务)，它必须是值得通过其他网站站长故意识地用链接情势保举的内容页面&mdash;&mdash;百度《搜刮引擎优化指南2.0》中说：&ldquo;我们经常说的超链，就是(用户)保举的一种(情势)&rdquo;。</div><div>　　《搜刮引擎优化艺术》书中则说：&ldquo;人们不会链接向低质量内容或用户体验差的网站(除非得到某种利益作为补偿)，除非你荣幸地拥有一个着名品牌，否则人们也不会链接向一个纯粹的贸易网站。你必须为用户提供有代价的东西，也要提供奇特的东西&rdquo;&mdash;&mdash;你所链接的内面内容必须赐与别人一些东西。</div><div>　　而且，既然是&ldquo;外链营销&rdquo;，在网站外链建计划谋订定与实行历程中，就必须充实思量营销受众的生理，由于只有捉住营销受众生理的营销举动才大概得到预期的乐成&mdash;&mdash;时下最有说服力的例子是，当大陆扫货者在香港想购置低利润产物时，洞悉大陆客生理的香港卖家一句&ldquo;我们香港人才不消谁人牌子呢&rdquo;，结果大陆客就乖乖地被香港卖家牵着鼻子走了。</div><div>　　外链营销也不例外，《搜刮引擎优化艺术》书中说：&ldquo;有些东西天生能吸引链接，由于能触发(读者)生理和情感回声&mdash;&mdash;自负、分享、消息性等。充实利用这些触发性因素，为那些能影响网站内容的访问者(作家、站长、博客作者)制造一个有说服力的来由来引用你的作品，你的链接创建就将会乐成&rdquo;。</div><div>　　因此，作为一个企业网站外链营销专员，我们必须思索，本行业用户存眷的话题是什么?而我网站能赐与别人的奇特内容有些什么呢?海内站长每每缺乏这方面的战略考量，横竖&ldquo;发外链&rdquo;呗，能留下外链、被搜刮引擎收录就是乐成，基础不思量受众感觉(这不能完全怪外链专员，很多公司就是以数目考核外链专员的)，从他们的角度来说，如许的外链乐成了，但很难到达&ldquo;产生高点击率&rdquo;的外链营销结果。</div><div>　　《搜刮引擎优化艺术》作者提示我们，在确定网站外链建计划谋时，起首必须&ldquo;摸清家底&rdquo;，晓得本身网站如今有什么内容，可以增长什么内容，我网站特色在那边，用户需求是什么，扬长避短，来确定我们本身&ldquo;基于网站内容的链接建计划谋&rdquo;。</div><div>　　好比，提问那位朋侪做的是打扮网站，网站内容很难出新，但面对同样标题，淘宝一些女装店家本身做模特儿，展示本身打扮格局的特点，取得较好的营销结果。假如在如许别开生面的内容基础之上，在一些女性消耗者居多的论坛(或微博)挑选出两幅良好图片做&ldquo;外链营销&rdquo;，就能很好地收到点击外链的结果。</div><div>　　而且如许基于高质量内容的链接，很容易成为&ldquo;链接诱饵&rdquo;，被更多用户、网站站长保举，到达&ldquo;真正的搜刮引擎优化能手只晓得本身外链到处都有，但却不晓得是谁帮创建的&rdquo;田地。</div><div>　　这阐发白内容大概雷同，但由于体现情势的差别，内容受众的生理感觉也肯定差别，以致美学家对美的界说都是&ldquo;美是故意味的情势&rdquo;&mdash;&mdash;紧急的是&ldquo;探求更能引起受众共鸣的内容体现情势&rdquo;，而不是你体现的东西与众差别。</div><div>　　必须指出的是，如许&ldquo;探求更能引起受众共鸣的内容体现情势&rdquo;，不但对网站内容构建有启示作用，对&ldquo;外链营销&rdquo;也同样。《搜刮引擎优化艺术》中说：&ldquo;可以用差别种类的内容(同一内容的差别体现情势)吸引链接。文章、有吸引力的图片、视频、东西、以致开辟线上游戏&rdquo;。好比一些民营医院举行网络手术视频直播，一段时间内直播地点不绝地被各大网站管理员及网友自觉保举分享。</div><div>　　别的，敷衍内容大同小异的企业网站来说，无论是网站内容构建还是外链营销环节，捉住&ldquo;时效性话题&rdquo;做文章是一个&ldquo;拓展内家&rdquo;的好要领。任何时间网络上都不缺乏热门的&ldquo;时效性话题&rdquo;，只要我们本身的网站可以大概不绝地捉住具有干系性的&ldquo;时效性话题&rdquo;做文章，只要实时奇妙地从中掘客到本身网站的奇特卖点(肯定要有本身新意，而且不能委曲)，借势营销，不难想象，这类盛行话题带来的外链点击率肯定不会低&mdash;&mdash;好比做女装的网站，前些日子就不应该放过不胫而走的&ldquo;齐B小短裙&rdquo;话题。</div><div>　　末了，就是坚持，不要怕累，不要怕被模拟，不要怕一段时间内结果不显着，以致不如&ldquo;内容只是偶尔义穿插关键字&rdquo;的传统&ldquo;发外链，引蜘蛛&rdquo;本领。坚持下去。由于任何营销本领都必须坚持才气收效&mdash;&mdash;外链营销也不例外。</div><div>　　特殊要提示列位搜刮引擎优化ER的是，不要为本身找放弃的捏词来由，好比&ldquo;海内网站都是复制收罗伪原创&rdquo;。这简直是毕竟，但我们不能等待情况好了再做。只要降服困难坚持下去，就肯定会有效果。</div><div>　　而且，将如许&ldquo;基于内容的外链建计划谋&rdquo;坚持下去，再辅以其他宣传营销本领(好比消息营销等)，一段时间以后，就能有效拉开与其他同类网站的隔断，真正实现网站品牌化的终极营销目的。</div><div>　　末了，《搜刮引擎优化艺术》将&ldquo;外链营销&rdquo;总结为：&ldquo;良好的链接创建来自于简单的观点：创建好的内容，陈诉其他人，鼓励他们分享&rdquo;。</div><div>　　这阐发，包罗外链营销在内的统统营销推广实质上都是内容营销，不能将网站内容与网站外链营销破碎开来，网站内容质量与外链质量密切干系&mdash;&mdash;这才是链接干系性的真实寄义。假如你网站内容(服务)真的很优质，你的外链质量肯定不会差，肯定能产生无数赢得更多点击的优质外链;而一个用户体验良好，让人产生点击激动的外链，它所指向页面的内容质量也不会低。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:53:47','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('54','15','0','提醒您装修房子的注意事项','','','admin','1','0','','0','0','','0','','','','','2303','2014-10-11 16:54:56','admin','','/upload/images/201304/2303.jpg','1','1','做网站优化必须要有收录，而且一定要收录快，所以说这是一个整体过程，从网站建设到网站的运营，这个过程都离不了优化策略，每个环节都必需有优化思惟。
　　1.内容最好是原创。一个新站点，文章质量非常重要，蜘蛛是喜新厌旧的东西，对一个站点内容质量越高，抓取你网站的次数也会越高。可是有些新站长实在写不出丰富原创内容，可以选择伪原创，切忌不要完全的采集别人的文章，伪原创是指看别人写的原创文章，结合几个人所写同类型的文章，在结合自己的观点，用自己的话描述出来。别以为调换一下文章顺序，替换一些关键词就是一篇新文章，现在的百度算法越来越精准，这种采集方式已经是过去式了，还是倡导原创内容。
　　2.要迎合用户需求来写。在做网站内容是，要分析用户的需求，迎合用户的需求去写网站内容。因为在互联网上有大量相似的文章，你再去写类似的文章，搜索引擎为什么要收录你的文章给予排名呢?所以做网站内容的时候要考虑到是否用户需要的，网站内容是否新颖。可以登入商标注册网站都是很专业的商标资讯文章3.文章定时更新。每日准时更新网站内容，每天都能让蜘蛛有东西吃，满意而归。假如蜘蛛今天有东西吃，明天没东西吃，后天也没东西吃，没准蜘蛛不来你的网站了。发完一篇文章后，最好到百度站长平台抓取诊断一下，看文章抓取是否显示正常。
　　4.网站地图。一般蜘蛛要来抓取你的网站首先看的你的网站地图Sitemap，再以它为导航爬行你的网站，一个新站最容易忽视网站地图，网站地图能更好的引导蜘蛛来抓取我们的网站，提高网站收录速度。每更新一篇文章之后，立刻生成地图传到网站根目录。
　　5.发布外链。到各大高权重外链平台(达到秒收效果最佳)发布外链，例如搜外SEO论坛，A5站长，28推等平台，吸引蜘蛛来抓取网站的文章，也是能加快网站文章收录速度。发外链每天要平稳，不能大跌大增，某某大牛说，一天最少要发10-30条外链。
　　6.文章内链。一个页面要被收录，首先要能够被搜索引擎蜘蛛爬行到，蜘蛛的爬行轨迹是顺着一个链接到另一个链接，想让搜索引擎蜘蛛更好地爬行，在你在文章适当位置增加些文章的锚文本链接，这样能有效缩短蜘蛛的抓取网站内容时间，有效提高文章的收录率。如果是新站长建议不要做内链，一个不注意形成死链断链，蜘蛛就无从爬起，那就更别谈网站文章收录了。
　　7.提交Sitemap地图。可以到各大搜索引擎站长平台提交网站地图URL，使搜索引擎更好的对网站页面进行收录。千万要记住在robots里面写上你网站Sitemap的地址，因为蜘蛛来抓取网站时，首先看robots，这样更好的让搜索引擎蜘蛛抓取我们网站。
　　坚持这7项，想不获得百度收录都难了，这就是让你网站在排名中靠前的7大技巧。','0','<p>做网站优化必须要有收录，而且一定要收录快，所以说这是一个整体过程，从网站建设到网站的运营，这个过程都离不了优化策略，每个环节都必需有优化思惟。</p><div>　　1.内容最好是原创。一个新站点，文章质量非常重要，蜘蛛是喜新厌旧的东西，对一个站点内容质量越高，抓取你网站的次数也会越高。可是有些新站长实在写不出丰富原创内容，可以选择伪原创，切忌不要完全的采集别人的文章，伪原创是指看别人写的原创文章，结合几个人所写同类型的文章，在结合自己的观点，用自己的话描述出来。别以为调换一下文章顺序，替换一些关键词就是一篇新文章，现在的百度算法越来越精准，这种采集方式已经是过去式了，还是倡导原创内容。</div><div>　　2.要迎合用户需求来写。在做网站内容是，要分析用户的需求，迎合用户的需求去写网站内容。因为在互联网上有大量相似的文章，你再去写类似的文章，搜索引擎为什么要收录你的文章给予排名呢?所以做网站内容的时候要考虑到是否用户需要的，网站内容是否新颖。可以登入商标注册网站都是很专业的商标资讯文章3.文章定时更新。每日准时更新网站内容，每天都能让蜘蛛有东西吃，满意而归。假如蜘蛛今天有东西吃，明天没东西吃，后天也没东西吃，没准蜘蛛不来你的网站了。发完一篇文章后，最好到百度站长平台抓取诊断一下，看文章抓取是否显示正常。</div><div>　　4.网站地图。一般蜘蛛要来抓取你的网站首先看的你的网站地图Sitemap，再以它为导航爬行你的网站，一个新站最容易忽视网站地图，网站地图能更好的引导蜘蛛来抓取我们的网站，提高网站收录速度。每更新一篇文章之后，立刻生成地图传到网站根目录。</div><div>　　5.发布外链。到各大高权重外链平台(达到秒收效果最佳)发布外链，例如搜外SEO论坛，A5站长，28推等平台，吸引蜘蛛来抓取网站的文章，也是能加快网站文章收录速度。发外链每天要平稳，不能大跌大增，某某大牛说，一天最少要发10-30条外链。</div><div>　　6.文章内链。一个页面要被收录，首先要能够被搜索引擎蜘蛛爬行到，蜘蛛的爬行轨迹是顺着一个链接到另一个链接，想让搜索引擎蜘蛛更好地爬行，在你在文章适当位置增加些文章的锚文本链接，这样能有效缩短蜘蛛的抓取网站内容时间，有效提高文章的收录率。如果是新站长建议不要做内链，一个不注意形成死链断链，蜘蛛就无从爬起，那就更别谈网站文章收录了。</div><div>　　7.提交Sitemap地图。可以到各大搜索引擎站长平台提交网站地图URL，使搜索引擎更好的对网站页面进行收录。千万要记住在robots里面写上你网站Sitemap的地址，因为蜘蛛来抓取网站时，首先看robots，这样更好的让搜索引擎蜘蛛抓取我们网站。</div><div>　　坚持这7项，想不获得百度收录都难了，这就是让你网站在排名中靠前的7大技巧。</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:54:56','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('55','15','0','基础装修多少钱？看看这些就一目了然','','','admin','1','0','','0','0','','0','','','','','2302','2014-10-11 16:55:54','admin','','/upload/images/201304/2302.jpg','1','1','用户体验一直是我们网站的核心数据，网站没有用户那么网站也会被百度抛弃，所以我么一定要去努力提升用户体验度，这一直是百度所传递给我们的意思，一直让我们只要做好用户体验，那么你就一定能得到百度的喜欢，然而我们却这么相信了百度的片面之词。因为网站出了用户体验还有一个很重要的本心就是网站关键词排名。
　　如果我们网站关键词没有一个好的排名，去强调用户体验显然有些枉然，因为我们的用户还是需要通过百度搜索引擎进入我们的网站，如果你连这个通道口都放弃了，那么你的网站将会是一个没有活力的网站，所以今天，在这里给大家介绍关键词排名的相关因素。
　　一、发外链说到发外链，相信seo最熟悉不过了，笔者曾光红从2007年做个人站长，也一直过着发外链的生活，但如今百度搜索引擎对于外链的管制是非常的严格，有些论坛和网站也都杜绝带外链，导致很多很多的外链专员都无法下手，后来转到投稿给chinaz等大网站。当然发外链的难处并非如此，详情以下：
　　1、 页面权重的影响。
　　我们都知道网站的每一个页面都是有一定的权重值，所以我们所发的外链的权重值是根据页面的权重值来衡量的。所以我们在发外链一定要选择高权重的页面。
　　2、 页面导出值。
　　当外链页面的权重值为0.2时，算法是要以0.2在计算出该页面的内链和外链后剩下的权重值才可能会导入你所发的外链。所以说你所发的外链权重值是非常的小。因为内链和外链都会瓜分我们的权重，所以一般一个页面内链最好不多为5条。比如：我在chinaz投稿一文章后，我只带了一条3u推论坛的外链。那么我这一条外链绝对要比带5条外链所导出的权重要高的多。
　　二、网站内链页面内链的插入主要还是以用户的求为主要的。当我们写完一篇文章后，我们在插入内链推荐的时候就要想到用户看到这里的时候还会想去看什么内容，这就要我们去琢磨用户的心理。对于用户比较有价值推荐我们可以加上锚文本链接。这样能提升用户体验度的同时还能增加关键词的内链权重。
　　三、网站内容内容是一个比较常聊到的话题，因为我们也总是在强调说要怎么去写原创文章，今天我所说的内容不单单是指文字内容。更是包括网站所有内容。接下来我就简单的说几点。
　　1、 页面速度。网站的浏览速度是一个非常重要的因素，这关系到用户体验问题，更是关系到网站关键词排名的一个问题。所以网站打开速度一定要快。
　　2、 页面设计。通常对于我们中国人来说，我们看网页都是喜欢从上往下，从左往右，所以我们要把网站的特色更好的展现给用户。
　　3、 页面无限制。这种情况多数于论坛，3u推论坛支持访客评论，但有些论坛看贴都是需要回复内容的，这个限制其实是让人反感。
　　4、 图文并茂。纯文字可能已经过去了，为了用户更好的浏览你的页面，所以你要在文中合理增加图片或者是视频什么的。
　　最后总结：尤其是我们是新站的站长们一定要遵守搜索引擎的原则才会有自己的出路，我们在做用户体验的同时更不能忘记我们需要的更是网站关键词排名！','0','<p>用户体验一直是我们网站的核心数据，网站没有用户那么网站也会被百度抛弃，所以我么一定要去努力提升用户体验度，这一直是百度所传递给我们的意思，一直让我们只要做好用户体验，那么你就一定能得到百度的喜欢，然而我们却这么相信了百度的片面之词。因为网站出了用户体验还有一个很重要的本心就是网站关键词排名。</p><div>　　如果我们网站关键词没有一个好的排名，去强调用户体验显然有些枉然，因为我们的用户还是需要通过百度搜索引擎进入我们的网站，如果你连这个通道口都放弃了，那么你的网站将会是一个没有活力的网站，所以今天，在这里给大家介绍关键词排名的相关因素。</div><div>　　一、发外链说到发外链，相信seo最熟悉不过了，笔者曾光红从2007年做个人站长，也一直过着发外链的生活，但如今百度搜索引擎对于外链的管制是非常的严格，有些论坛和网站也都杜绝带外链，导致很多很多的外链专员都无法下手，后来转到投稿给chinaz等大网站。当然发外链的难处并非如此，详情以下：</div><div>　　1、 页面权重的影响。</div><div>　　我们都知道网站的每一个页面都是有一定的权重值，所以我们所发的外链的权重值是根据页面的权重值来衡量的。所以我们在发外链一定要选择高权重的页面。</div><div>　　2、 页面导出值。</div><div>　　当外链页面的权重值为0.2时，算法是要以0.2在计算出该页面的内链和外链后剩下的权重值才可能会导入你所发的外链。所以说你所发的外链权重值是非常的小。因为内链和外链都会瓜分我们的权重，所以一般一个页面内链最好不多为5条。比如：我在chinaz投稿一文章后，我只带了一条3u推论坛的外链。那么我这一条外链绝对要比带5条外链所导出的权重要高的多。</div><div>　　二、网站内链页面内链的插入主要还是以用户的求为主要的。当我们写完一篇文章后，我们在插入内链推荐的时候就要想到用户看到这里的时候还会想去看什么内容，这就要我们去琢磨用户的心理。对于用户比较有价值推荐我们可以加上锚文本链接。这样能提升用户体验度的同时还能增加关键词的内链权重。</div><div>　　三、网站内容内容是一个比较常聊到的话题，因为我们也总是在强调说要怎么去写原创文章，今天我所说的内容不单单是指文字内容。更是包括网站所有内容。接下来我就简单的说几点。</div><div>　　1、 页面速度。网站的浏览速度是一个非常重要的因素，这关系到用户体验问题，更是关系到网站关键词排名的一个问题。所以网站打开速度一定要快。</div><div>　　2、 页面设计。通常对于我们中国人来说，我们看网页都是喜欢从上往下，从左往右，所以我们要把网站的特色更好的展现给用户。</div><div>　　3、 页面无限制。这种情况多数于论坛，3u推论坛支持访客评论，但有些论坛看贴都是需要回复内容的，这个限制其实是让人反感。</div><div>　　4、 图文并茂。纯文字可能已经过去了，为了用户更好的浏览你的页面，所以你要在文中合理增加图片或者是视频什么的。</div><div>　　最后总结：尤其是我们是新站的站长们一定要遵守搜索引擎的原则才会有自己的出路，我们在做用户体验的同时更不能忘记我们需要的更是网站关键词排名！</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:55:54','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('56','15','0','75平米3万装修预算 一点没超支','','','admin','1','4','','0','0','','0','','','','','2301','2014-10-11 16:56:57','admin','','/upload/images/201304/2301.jpg','1','1','随着互联网的越来越成熟，网络营销的风头逐渐开始盖过传统营销了，一个普通的日子居然成了电商一年中成交最多的节日，这无疑是电商们的成功。在企业利用网站营销的今天，数据分析变得越来越重要，包括认知企业的主要用户群体、优化品牌的曝光率，提升产品转化等，今天笔者分享下网站常见的数据分析。
　　一、网站来路的有效流量    信息来源：
　　一个营销类型的网站，流量来源包括了新闻资讯的流量，产品页面的流量等。一般情况下我们的资讯页面的流量转化率要比产品页面流量转化率低，这一个可以直接使用站长统计在后台看。对企业来说，产品页的流量就是有效的，还有企业的产品留言板，一般对你产品没兴趣也就不会问你的产品，这部分流量转化率也不低。
　　二、网站创造什么样的内容才能让用户更关注在以用户体验为主的今天，各个主流引擎都在更新算法鼓励原创的做法，并且严厉地打击垃圾网站。做站长的都应该扪心自问，检查下自己网站的内容，大概参考方法如下，看看整站内容中哪些页面有收录哪些没收录，再从没收录页面总结出一定特征，这个就是用户不太关注需要优化的部分了。    信息来源：
　　三、网站该做些什么活动来催化成交用户不买你产品是因为你页面描述不精细还是产品太陌生，这些我们需要提高下认知。我们的主要目的就是卖出产品，比如把排名做上第一名这也是我们为卖出产品做出的宣传，还有在别的网站投放的专题活动，间接性地为网站引流。又或者公司在新浪的某栏目投放了硬广，并做了来路记录，做seo的此时需要为网站的多种活动流量做分析，比较哪一种产生的订单多和单价高，砍掉那些效率低的活动，节省成本留着投入别的项目。','0','<p>&nbsp;　　三亚，地处北纬18度，位于中国海南岛最南端，是地球上迷人的风景地带，四季如夏，鲜花盛开，素有“东方夏威夷”之称，堪称中国最好的旅游城市之一。</p><p>　　三亚以美丽的海上风光出名，亚龙湾、大东海、三亚湾这三大海湾是三亚主要的滨海胜地。许多海湾边椰树成林，椰梦长廊就是其中著名的观光景点。蜈支洲岛、西岛则是潜水爱好者的天堂。除了滨海风光，三亚还有丰富的热带雨林资源，亚龙湾热带天堂森林公园，呀诺达雨林文化旅游区和南湾猴岛都是三亚雨林资源的集中景区。三亚也有很多人文古迹景区，比如南山寺、大小洞天、天涯海角、鹿回头山顶公园、槟榔谷、崖州古城等。三亚还有一些科学文化展馆和园区，例如亚龙湾贝壳馆、亚龙湾蝴蝶谷、亚龙湾海底世界、三亚奇幻艺术体验馆等。</p><p>　　最佳旅行时间</p><p>　　三亚寒暑变化不大，一年四季均适合旅游，最佳旅游时间是10月到次年3月。因为这个季节北方已开始变冷，而三亚却依旧温暖宜人，你仍可以穿着夏装、沙滩鞋在阳光充沛的海滩悠闲漫步，浸润在暖暖的海水中，吃着热带水果，享受着天涯海角的浪漫。每年12月，三亚的天涯海角还会举办“国际婚庆节”，那时来到三亚，可能经历一场终生难忘的旅程。</p><p>　　穿衣指南</p><p>　　三亚气候属热带海洋季风气候。年平均气温25.4℃。不管哪个季节到三亚，都只需穿轻薄的短款棉质衣裤或长裙，冬季可以准备一件长袖外套。比基尼泳衣自然是女生们必不可少的装备。5月至11月是台风季节，建议准备好雨具。三亚常年日照强烈，防晒措施一定要做好。由于阳光强烈，太阳镜、帽子为必带物品，出门之前至少搽SPF30以上防晒霜，下海之前最好再抹一次，而且要注意一定是防水的。回去后，如果皮肤发红发痒还要擦点晒后镇定修护露，保湿喷雾、美白面膜等都可以用上。黄瓜和酸奶都属于紧急保护品，晒伤后可以抹上</p><p>　　历史</p><p>　　三亚古称“崖州”，历史悠久，人文璀灿，早在秦始皇时期设置南方三郡，崖州是其中之一的象郡的“外檄”(边界)。崖州城在宋以前为土城，南宋庆元四年(1198年)始砌砖墙，后经元、明、清三代扩建，成为一座规模较大的坚固城池。因其远离帝京、孤悬海外，自古以来三亚一直被称为“天涯海角”。唐代宰相韩瑗、名僧鉴真，宋代名相赵鼎、大臣胡铨和纺织家黄道婆等先后来过崖州，对本地区的经济文化交流和发展作出了重要的贡献。</p><p>　　装备</p><p>　　1、背囊尽量选取透气性好的。衣服最好带吸汗的、透气、快干的，不要带太多，晚上可以洗衣服，第二天一定干。如果是冬天，尽管天气暖和，最好也带件外套。</p><p>　　2、游泳用具泳衣、泳帽、水镜一定别忘了带。</p><p>　　3、现金，在三亚很少见ATM机的，现金的多少根据个人情况而定吧</p><p>　　4、相机，这个不用多说。</p><p>　　5、防晒霜：特别要带防晒指数高、防水性好的防晒霜。</p><p>　　6、带上墨镜以及帽子吧，一是为了防晒，二是拍照的时候也多个道具嘛，呵呵</p><p>　　7、至于说药品，可带些氟哌酸，罗红霉素，眼药水，酒精棉球，金嗓子，白加黑，云南白药创可贴，晕车药，开瑞坦，具体情况还是各位自己斟酌考虑，仅供参考。</p><p>　　必游景点</p><p>　　亚龙湾</p><p>　　三亚最美的海湾，水清沙白，被誉为“天下第一湾”</p><p>　　蜈支洲岛</p><p>　　可体验30余项海上和沙滩娱乐项目，是中国第一潜水基地 这里还包含景点 情人桥 白沙滩 观日岩 情人岛 《私人订制》淡水泳池 观鱼平台 生命井</p><p>　　南山文化旅游区(南山寺)</p><p>　　108米高的“南山海上观音”，是三亚礼佛必去之处 这里还包含景点 南天生态大观园 长寿谷 三十三观音堂 金玉观音 三亚南山海上观音</p><p>　　呀诺达雨林文化旅游区</p><p>　　三亚的热带雨林景点之一，保护的很好，是一处天然的巨型氧吧</p><p>　　大东海</p><p>　　三亚最早被开发，离市中心最近，最具规模的热带滨海度假区</p><p>　　景区分布图</p><p>　　行 程 推 荐</p><p>　　海岸风情6日之旅</p><p>　　行程特色：</p><p>　　临海而居：三亚连住四晚近海精品酒店180°海景房</p><p>　　聚焦热点：亚龙湾热带天堂、天涯海角、南山、蜈支洲岛、大东海、玫瑰谷一天两个点，行程多彩不劳累;</p><p>　　海岛滋味：100%全程自助餐，特别赠送价值68元/人素斋禅食(荣获全国金厨奖)</p><p>　　超值赠送：天堂森林公园观光车票、海南火山岩矿泉水1瓶/人/天</p><p>　　线路设计：</p><p>　　D1：乘坐飞机抵达三亚凤凰机场</p><p>　　D2：蜈支洲岛、亚龙湾热带天堂森林公园</p><p>　　D3：南山文化旅游区、天涯海角</p><p>　　D4：大东海、亚龙湾国家旅游度假区玫瑰谷</p><p>　　D5：自由活动</p><p>　　D6：乘坐飞机返回温馨家园</p><p>　　第 1天出发地机场 >>>> 三亚凤凰机场</p><p>　　乘机飞抵三亚，专人专车在机场接机(车程约40分钟)，赴酒店休息，海岛的迷人海岸像美人揭开了神秘的面纱，期待第二天的惊艳。</p><p>　　第 2天三亚一地</p><p>　　自助早餐后，前往《私人订制》取景拍摄地【蜈支洲岛】(车程约90分钟，游览时间不少于210分钟，含上下岛时间)，这里海岸线蜿蜒绵长，零污染的海水清澈见底，沙质洁白细腻，恍若玉带天成，尽情享受这片把明星大腕都宠坏的绝美海岸吧(岛上午餐自理);--再前往电影《非诚勿扰II》拍摄地【亚龙湾热带天堂森林公园】(车程约50分钟，游览时间不少于120分钟)，在山顶俯瞰，航母基地和南中国海一览无余，一座座鸟巢星罗棋布，雨林与海岸碰撞，只在独特的“热带天堂”;晚餐后可体验三亚不夜城丰富的夜生活。</p><p>　　第 3天三亚一地</p><p>　　自助早餐后，前往国家5A级景区【南山文化旅游区】(车程约90分钟，游览时间不少于180分钟)，108米海上观音慈悲注视着这片海岸，传递福寿文化的精深与宇宙空间的深邃;游览著名的4A级景区【天涯海角】(车程约30分钟，游览时间不少于120分钟)，在天之涯、海之角，椰林婆娑、帆影点点，烟波浩瀚、水天一色，感受奇石林立、峥嵘壮观的海岸风情;晚餐后，尽情体验三亚不夜城丰富的夜生活。</p><p>　　第 4天三亚一地</p><p>　　自助早餐后，前往三亚湾集零售、餐饮、休闲娱乐于一体的大型综合性国际滨海度假商业娱乐主题街区“美丽汇” 。随后游览【大东海】(车程约40分钟，游览时间不少于150分钟)，享受一片“水暖沙白滩平”的纯净海岸。前往【亚龙湾国家旅游度假区玫瑰谷】(车程约40分钟，游览时间不少于40分钟)，尽情感受玫瑰花海、浪漫婚庆、七彩游乐、精油养生、国际风情等游览主题，品读浪漫休闲、感悟美丽人生。晚餐后可体验三亚不夜城丰富的夜生活。</p><p>　　第 5天三亚</p><p>　　睡到自然醒(请勿错过自助早餐时间)，尽情享受自由时空;(自由活动期间不含车餐及导游)</p><p>　　第 6天三亚凤凰机场 >>>> 出发地机场</p><p>　　睡到自然醒(请勿错过早餐时间)，尽情享受自由时空，结束本次愉快的 “国际旅游岛”之旅，专人送机，乘机返回温馨家园(酒店退房时间为中午12点前，可将行李寄存酒店行李部)。</p><p>　　新春快乐</p><p>　　三亚亮点</p><p>　　在第一市场做海鲜</p><p>　　第一市场每天晚上都是人山人海。这里价格实惠，而且你吃到的都是亲自挑选的新鲜海产。游客们通常会先到海鲜市场挑选，然后再找一家大排档让店家加工;或者店家也可以游客去采买海鲜，再进行加工。除了海鲜，在这里还可以吃到好多海南的特色小吃，比如炒冰、糯米糕、椰子饭、山兰酒等等。</p><p>　　喝一捧新鲜椰子汁</p><p>　　三亚有太多的椰子树，那种刚刚掉下来的椰子，直接劈开就能喝到清爽的椰汁，然后吃完里面的椰肉，才够鲜美。在这里的街道上走，只要你看到谁家小店的门口有一大堆青椰子，就说明店里面卖椰子水。你可以让店家帮你挑，然后帮你打开，每个6块钱左右，很是清凉解渴;还有已经冰镇好的椰子，是去壳的，来一份保证更加透心凉。</p><p>　　来一份抱罗粉当早餐</p><p>　　这里最受欢迎的早餐应该就算是抱罗粉了，基本上都是本地人经营，本地人光顾。因为那些正宗的老铺子看起来都不那么好看，一般游客看见了也不会去试。但一定要去尝尝，这才算是正宗的海南美味小吃。河西路上有一家其貌不扬的小店(河西路第一市场旁)是全三亚最正宗的抱罗粉食店，离第一市场很近。其实，抱罗汤粉，贵在汤好。看上去很清鲜、爽口、香甜、麻辣。很早以前，抱罗粉的汤主要是以牛骨汤为主配成的。现在，用多种原料熬汤，味道比原来鲜美得多。用这种汤，加上牛肉干、花生仁、竹笋、酸菜骨、辣椒等配料，说起来就想去吃。很过瘾。这里有人说“海鲜可以错过，抱罗粉不能少”。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2014-10-11 16:56:57','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('90','20','0','课程质量','','','admin','1','0','#000000','0','0','','0','','','','','0','2015-07-31 14:39:03','admin','','','-1','1','比同行业水平','0','<p>&nbsp;<span style=\"color: rgb(170, 170, 170);-- font-family: \'Microsoft YaHei\', simsun, \'Helvetica Neue\', Arial, Helvetica, sans-serif; font-size: 14px; line-height: 21px;\">比同行业水平</span></p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2015-07-31 14:39:03','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('91','20','0','师资队伍','','','admin','1','0','#000000','0','0','','0','','','','','0','2015-07-31 14:40:52','admin','','','1','1','比同行也水平','0','<p>&nbsp;比同行也水平</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','高 38.50%','','','1','2015-07-31 14:40:52','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('92','20','0','通过率','','','admin','1','0','#000000','0','0','','0','','','','','0','2015-07-31 14:41:45','admin','','','1','1','比同行水平','0','<p>&nbsp;比同行水平</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','高 38.50%','','','1','2015-07-31 14:41:45','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('93','20','0','服务态度','','','admin','1','0','#000000','0','0','','0','','','','','0','2015-07-31 14:42:13','admin','','','1','1','比同行水平','0','<p>&nbsp;比同行水平</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','高 38.50%','','','1','2015-07-31 14:42:13','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('94','20','0','课程质量','','','admin','1','0','#000000','0','0','','0','','','','','0','2015-07-31 14:42:32','admin','','','1','1','比同行水平','0','<p>&nbsp;比同行水平</p>','0','','0','','0','0','','','','','0','','','0','a:0:{}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','高 38.50%','','','1','2015-07-31 14:42:32','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('95','12','0','现代时尚欧美家居氛围产品','','','admin','1','0','','0','0','','0','','','','','3306','2015-09-24 15:06:06','admin','','/upload/images/201304/3306.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777031178.jpg\" style=\"\" title=\"14711777031178.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777031092.jpg\" style=\"\" title=\"14711777031092.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777031017.jpg\" style=\"\" title=\"14711777031017.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY2PvAH7VhsRncNfJ420','','','','1','2015-09-24 15:06:06','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('96','12','0','城市美式家居氛围产品','','','admin','1','0','','0','0','','0','','','','','3307','2015-09-24 15:07:34','admin','','/upload/images/201304/3307.jpg','1','1','','0','<p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777654767.jpg\" style=\"\" title=\"14711777654767.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777652039.jpg\" style=\"\" title=\"14711777652039.jpg\"/></p><p style=\"text-align: center\"><img src=\"/upload/images/201608/14711777655666.jpg\" style=\"\" title=\"14711777655666.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY3aWMPBmJdFBNULF287','','','','1','2015-09-24 15:07:34','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('97','12','0','内容二十四','','','admin','1','0','','0','0','','0','','','','','3308','2015-09-24 15:08:13','admin','','/upload/images/201304/3308.jpg','1','1','说起排行安稳的要素，信任不少站长朋友都有自己的发言权，比如说：服务器安稳、网站结构安稳、网站内容更新和外链发布频率安稳等；网站的主次明白，主页一定表现主题；网站是不是在处理用户疑问而不是制造疑问；把一些可有可无的东西去掉，不要想着做大而全；当然毕竟少不了一个词：坚持。
SEO是一个长期的工作，是一个统管大局的工作，对于排行安稳、对于流量前进、对于转化率前进都成为我们的焦点。而玩SEO的朋友都能说出自己的一些观念观念。可是为何自己的SEO工作便是做欠好，网站优化便是不安稳呢？','0','<p>说起排行安稳的要素，信任不少站长朋友都有自己的发言权，比如说：服务器安稳、网站结构安稳、网站内容更新和外链发布频率安稳等；网站的主次明白，主页一定表现主题；网站是不是在处理用户疑问而不是制造疑问；把一些可有可无的东西去掉，不要想着做大而全；当然毕竟少不了一个词：坚持。</p>
<div>SEO是一个长期的工作，是一个统管大局的工作，对于排行安稳、对于流量前进、对于转化率前进都成为我们的焦点。而玩SEO的朋友都能说出自己的一些观念观念。可是为何自己的SEO工作便是做欠好，网站优化便是不安稳呢？</div>
<div>&nbsp;</div>
<div>&nbsp; &nbsp; 网站的SEO优化效果欠好，我们先看看自己的悉数工作流程有没有出现疑问。</div>
<div>SEO的进程：</div>
<div>一、最基本的网站三要素域名、空间和程序；</div>
<div>二、网站关键词的分析与选定；</div>
<div>三、网站结构和代码分析；</div>
<div>四、网站节目和页面优化；</div>
<div>五、内容发布与衔接安置；</div>
<div>六、与搜索引擎对话；</div>
<div>七、流量核算东西分析。</div>
<div>&nbsp;</div>
<div>&nbsp; &nbsp; 信任大多数从事SEO的朋友都是半路出家，因为没有参加过系统的学习和实战，我们只知道更新内容、发外链，查看搜索引擎成果。特别是网站排行出现不坚定的时分，一定要去站长论坛、QQ群去吐槽，寻求我们的处理方案。然后得到的答案是什么呢？更新独创高质量内容，发布高质量外链。</div>
<div>&nbsp;</div>
<div>&nbsp; &nbsp; 对于SEO优化效果欠好的缘由已经给我们简略分析了，我们是不是真实处理了这些疑问？假设没处理这些疑问，那么先处理这些疑问吧。网站内部要素能够找安稳的服务商、运用官方的程序、内容更新和外链发布频率更需要安稳。</div>
<div>&nbsp; &nbsp;</div>
<div>&nbsp; &nbsp; 不少站长和SEO工作者最喜欢的便是访问站长有关网站和论坛，特别是排行不坚定的时分喜欢病急乱投医，然后得到千人一面的答案。历来不喜欢自己思考是最大的疑问，当然公司老板不明白是最大的疑问，建议SEO工作者一定要有抉择方案权，毕业作为SEO工作者有时太被动了。</div>
<div>&nbsp;</div>
<div>&nbsp; &nbsp; 我们不知道SEO的方向，假设只研讨多变的规则，多变的算法，做SEO基本上累死也很难做好。看看哪些东西是不变的，做到极致。做SEO优化如此，做其他事何曾不是如此？</div>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY5Bzs7b83hThAb8w122','','','','1','2015-09-24 15:08:13','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('100','7','0','业务经理','','','admin','1','3','','0','0','','0','','','','','7002','2015-09-24 15:29:32','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','人事部','1','热爱本职工作','2','1','无','3','20-40','不限','3000-5000','董先生','','0','CMSEASYjuzOUOgQmYsUpva458','','','','1','2015-09-24 15:29:32','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('101','7','0','活动推销员','','','admin','1','3','','0','0','','0','','','','','7003','2015-09-24 15:30:58','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','销售部','2','热爱本职工作','2','2','吃苦耐劳','2','20-40','不限','5000-8000','董先生','','0','CMSEASYmk6neJp3jDgbKWr353','','','','1','2015-09-24 15:30:58','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('104','8','0','轻型钢结构别墅','','','admin','1','1','','0','0','','0','','','','','0','2016-01-22 17:01:50','admin','','/upload/images/201601/14534533625989.gif','-1','1','建房施工过程中，将轻型钢架焊接固定在地基上，然后，用普通锯条在板材上把门窗开好，再把各种板材依次镶嵌在钢架上，进行胶合固定，一幢建筑面积600多平方米的三层中型别墅，只需要12个工人，用不到一个月的时间就可完成房屋主体建筑，并且完成大部分外墙装饰和室内装饰。建造施工只需要普通建筑施工工期的六分之一，并且在整个施工建造过程中，由于建筑材料的集合利用，加上材质轻，简化了烦琐的施工工序，不必使用大型施工机械，大大减轻了工人的劳动强度。
','0','<p>1、轻钢结构别墅建筑过程</p><p><br/>建房施工过程中，将轻型钢架焊接固定在地基上，然后，用普通锯条在板材上把门窗开好，再把各种板材依次镶嵌在钢架上，进行胶合固定，一幢建筑面积600多平方米的三层中型别墅，只需要12个工人，用不到一个月的时间就可完成房屋主体建筑，并且完成大部分外墙装饰和室内装饰。建造施工只需要普通建筑施工工期的六分之一，并且在整个施工建造过程中，由于建筑材料的集合利用，加上材质轻，简化了烦琐的施工工序，不必使用大型施工机械，大大减轻了工人的劳动强度。</p><p><br/>2、轻钢结构别墅的部件</p><p><br/>生产建造房屋所用的主要部品部件，有4大结构：轻型钢架结构、墙体结构、楼板结构和屋面结构。轻型钢架结构：在工厂加工后，在现场组装，具有强度高、抗震性能好、组装施工简单快捷等特点。采用高效防腐剂对钢构件表面进行防锈处理，保证了钢构件的经久耐用。由于钢架结构包裹在保温墙体内，不会产生热桥。用钢量少，重量轻，每平方米用钢20到30公斤，用钢量只有普通钢架结构房屋的60%左右，节省用钢量至少1/3。</p><p><br/>墙体结构：有外墙板、内墙板、隔墙板、保温砌块4类品种。可根据不同地区的气候温度，组合成不同的墙体。 寒冷地区组合成既保温由隔热的复合墙体，保证室内热量不被墙体吸收或渗漏，节能效果达到80%，也就是说，只需要普通建筑1/5的能源消耗就可达到室内保温需求。 在炎热地区则采用具有中空对流作用的外墙板组合成复合墙体，太阳辐射热被墙体内流动的空气带走，从而可以保持室内舒适凉爽。<br/>屋面结构：同样采取墙体板材原理设计，具有高标准的保温、隔热、隔声、防水、防潮性能，还可以根据房屋设计随意造型。<br/>楼板结构：重量轻，强度高，独有的密闭微孔结构和空气隔音层，使隔声效果达到41分贝，而且安装简便，承载力每平方米超过200公斤，远远超过普通楼板每平方米承载力150公斤的国家标准！</p><p><br/>3、轻钢结构别墅主要性能</p><p><br/>环保性：钢材及大部分材料可再生利用，符合生态建筑的要求。节能性能好（保温、隔热、隔音）先进的技术使耗能仅相当于传统住宅体系的40%，大大减少耗能费用。<br/>防腐、防虫：采用镀锌钢材，无原生木材，既防腐又免受虫蛀蚁蚀。<br/>耐火、耐久性：所有材料均为不可燃，同时考虑防火构造，达到国家防火规范。<br/>抗震、防风性：自重轻，抗震性能好，设计时充分考虑风荷载和雪荷载，可抵御暴风暴雪。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYwrgOFYej1X9wByu777','','','','1','2016-01-22 17:01:50','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('115','60','0','简介内容一','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:32:59','admin','','/upload/images/201607/14694320252253.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2016-07-25 15:32:59','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('116','60','0','简介内容而','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:33:49','admin','','/upload/images/201607/1469432042723.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','','1','2016-07-25 15:33:49','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('119','62','0','团队成员一','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:49:59','admin','','/upload/images/201607/14694330961832.jpg','1','1','教师的职业特点，既带有历史遗传的色彩，又反映时代变迁的影响。综合二者，当代中国教师的职业特点主要有：
其一，职业形象的准公共性。教师虽然不像政治家、演艺人员那样是完全的公共性人物。但也相当多的时候暴露于学生、家长、社区的注视之下，因此必须善于塑造并维护自己的积极形象。
其二，职业环境的相对封闭性。
其三，工作绩效的模糊性。
其四，职业待遇的福利性。教师的劳动成果不能以经济指标衡量，教师的劳动待遇也带有相当的福利性，所谓福利性。一指教师的待遇相对不高，一指教师的待遇相对稳定。
其五，师生关系的隐蔽不平等性。虽然从法律角度来讲，师生是平等的权利义务主体；从教育的理想追求来看，师生也应该成为平等的对话者。然而在实际中，由于传统观念的影响，尤其是教师在体力、智力、学识、社会地位等方面的优势，师生关系具有天然的不平等性。这种不平等性可能是许多人所不敢承认、不愿承认的，但它又是极其隐蔽而顽固地存在着的。','0','<p>教师的职业特点，既带有历史遗传的色彩，又反映时代变迁的影响。综合二者，当代中国教师的职业特点主要有：</p><p>其一，职业形象的准公共性。教师虽然不像政治家、演艺人员那样是完全的公共性人物。但也相当多的时候暴露于学生、家长、社区的注视之下，因此必须善于塑造并维护自己的积极形象。</p><p>其二，职业环境的相对封闭性。</p><p>其三，工作绩效的模糊性。</p><p>其四，职业待遇的福利性。教师的劳动成果不能以经济指标衡量，教师的劳动待遇也带有相当的福利性，所谓福利性。一指教师的待遇相对不高，一指教师的待遇相对稳定。</p><p>其五，师生关系的隐蔽不平等性。虽然从法律角度来讲，师生是平等的权利义务主体；从教育的理想追求来看，师生也应该成为平等的对话者。然而在实际中，由于传统观念的影响，尤其是教师在体力、智力、学识、社会地位等方面的优势，师生关系具有天然的不平等性。这种不平等性可能是许多人所不敢承认、不愿承认的，但它又是极其隐蔽而顽固地存在着的。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','创办人','1','2016-07-25 15:49:59','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('120','62','0','团队成员二','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:51:42','admin','','/upload/images/201607/14694331410117.jpg','1','1','“教师”最初指年老资深的学者，如《史记·孟子荀卿列传》：“齐襄王时，而荀卿最为老师。”后来把教学生的人也称为“老师”。如金代元好问《示侄孙伯安》一诗：“伯安入小学，颖悟非凡儿。属句有夙性，说字
教师授课
教师授课
惊老师。”中国有悠久的尊师重道的传统，古代就有“人有三尊，君、父、师”的说法。《吕氏春秋·尊师》云：“生则谨养，死则敬祭，此尊师之道也。”古人席地而坐，以西边为尊，故尊称家庭教师为“西席”和“西宾”。
尊称
中国有悠久的尊师重道的传统，中国古代教师的称谓很多，其中尊称有以下五种：
老师：原是宋元时代对地方小学教师的称谓。金代文学家元好问《示侄孙伯安》诗云：“伯安入小学，颖悟非凡貌。属句有夙性，说字惊老师。”后专指学生对教师的尊称。
明清以来，一般称教师为“先生”。直至19世纪末20世纪初，辛亥革命元老、中国现代教育奠基人何子渊、丘逢甲等人将西学（美式教育）引入中国，创办新式学校后，便开始在“学生操行规范”里面明确将“教师”称谓定义为“老师”。但绝大部分学生约定俗成将“先生”改称为“老师”，则是从国民政府时代开始，并一直沿用至今。','0','<p>“教师”最初指年老资深的学者，如《史记·孟子荀卿列传》：“齐襄王时，而荀卿最为老师。”后来把教学生的人也称为“老师”。如金代元好问《示侄孙伯安》一诗：“伯安入小学，颖悟非凡儿。属句有夙性，说字</p><p>教师授课</p><p>惊老师。”中国有悠久的尊师重道的传统，古代就有“人有三尊，君、父、师”的说法。《吕氏春秋·尊师》云：“生则谨养，死则敬祭，此尊师之道也。”古人席地而坐，以西边为尊，故尊称家庭教师为“西席”和“西宾”。</p><p>尊称</p><p>中国有悠久的尊师重道的传统，中国古代教师的称谓很多，其中尊称有以下五种：</p><p>老师：原是宋元时代对地方小学教师的称谓。金代文学家元好问《示侄孙伯安》诗云：“伯安入小学，颖悟非凡貌。属句有夙性，说字惊老师。”后专指学生对教师的尊称。</p><p>明清以来，一般称教师为“先生”。直至19世纪末20世纪初，辛亥革命元老、中国现代教育奠基人何子渊、丘逢甲等人将西学（美式教育）引入中国，创办新式学校后，便开始在“学生操行规范”里面明确将“教师”称谓定义为“老师”。但绝大部分学生约定俗成将“先生”改称为“老师”，则是从国民政府时代开始，并一直沿用至今。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','首席设计师','1','2016-07-25 15:51:42','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('121','62','0','团队成员三','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:52:31','admin','','/upload/images/201607/14694331924675.jpg','1','1','1. 教授歌曲、戏曲、武术等技艺的人。 元 张国宾 《罗李郎》第三折：“人都道你是教师，人都道你是浪子。上
教师节
教师节
长街百十样风流事，到家中一千场 五代 史。”《金瓶梅词话》第九十回：“ 月娘 众人躧着高阜，把眼观看，看见人山人海围着，都看教师走马耍解的。” 清 王夫之 《姜斋诗话》卷二：“诗文立门庭使人学已，人一学即似者，自诩为‘大家’，为‘才子’，亦艺苑教师而已。”
2. 向学生传授知识、执行教学任务的人。王力《推广普通话的三个问题》：“学校里教师必须用普通话讲课。','0','<p>1. 教授歌曲、戏曲、武术等技艺的人。 元 张国宾 《罗李郎》第三折：“人都道你是教师，人都道你是浪子。上</p><p>教师节</p><p>长街百十样风流事，到家中一千场 五代 史。”《金瓶梅词话》第九十回：“ 月娘 众人躧着高阜，把眼观看，看见人山人海围着，都看教师走马耍解的。” 清 王夫之 《姜斋诗话》卷二：“诗文立门庭使人学已，人一学即似者，自诩为‘大家’，为‘才子’，亦艺苑教师而已。”</p><p>2. 向学生传授知识、执行教学任务的人。王力《推广普通话的三个问题》：“学校里教师必须用普通话讲课。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','首席设计师','1','2016-07-25 15:52:31','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('122','62','0','团队成员四','','','admin','1','0','','0','0','','0','','','','','0','2016-07-25 15:53:21','admin','','/upload/images/201607/14694332400206.jpg','1','1','教师一词有两重含义，既指一种社会角色，又指这一角色的承担者。 广义的教师是泛指传授知识、经验的人，狭义的教师是指受过专门教育和训练的人，并在教育（学校）中担任教育、教学工作的人。（履行教育教学的专业人员。承担教书育人，培养社会主义事业建设者和接班人，提高民族素质的使命——来源于《中华人民共和国教师法》）','0','<p>教师一词有两重含义，既指一种社会角色，又指这一角色的承担者。 广义的教师是泛指传授知识、经验的人，狭义的教师是指受过专门教育和训练的人，并在教育（学校）中担任教育、教学工作的人。（履行教育教学的专业人员。承担教书育人，培养社会主义事业建设者和接班人，提高民族素质的使命——来源于《中华人民共和国教师法》）</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','','','','设计师','1','2016-07-25 15:53:21','','','0','1','0','0.00','0.00','');-- 

INSERT INTO `cmseasy_b_category` VALUES('1','0','关于我们','','','10','/upload/images/201304/1000guanyu.jpg','','','','<p>家居有限公司是一家集设计，生产，销售于一体的现代化家具企业，主要生产布艺沙发，布艺床，布艺椅等。公司成立之初就秉承欧美现代主义设计理念以中高，端市场为定位，以人性化设计为导向，通过对最新人体工程学和家具美学的研究，推出了一系列高品质，人性化的布艺，沙发，传承了时尚，简约舒适，自然的北欧居家文化。</p><p>高品质的材料，时尚的设计款式，完美的做工，造就出卓尔不凡的贵族家具，一经推出就深受消费者的喜爱，成为时尚一族彰显品质的象征。</p><p>家居有限公司拥有上万平米的现代化厂房，环境优美，在生产过程中，完全采用德国全自动化设备来生产，公司一贯高度重视环保材料，内架结构调整设计和填充材料都考虑到产品的舒适度。</p><p>高品质的材料，时尚的设计款式，完美的做工，造就出卓尔不凡的贵族家具，一经推出就深受消费者的喜爱，成为时尚一族彰显品质的象征。</p><p>以崭新的姿态，放眼于全球，走品牌战略之路，创世界时尚家具品质！</p><p><br/></p>','about','archive/list_page.html','archive/list_page.html','0','0','archive/list_page.html','archive/list_page.html','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('2','0','新闻栏目','','','30','/upload/images/201304/2000xinwen.jpg','','','','<p>最权威的新闻资讯</p>','news','archive/list.html','archive/list.html','archive/show.html','0','archive/list.html','archive/list.html','archive/show.html','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('3','0','产品展示','','','40','/upload/images/201304/3000chanpin.jpg','','','','<p>产品是指能够提供给市场，被人们使用和消费，并能满足人们某种需求的任何东西，包括有形的物品、无形的服务、组织、观念或它们的组合。产品一般可以分为三个层次，即核心产品、形式产品、延伸产品。核心产品是指整体</p>','products','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('79','76','复古式装修','','','0','','','','','<p>复式房是受跃层式住宅的设计构思启发，由香港建筑师李鸿仁创造设计的一种经济型住宅。复式房在概念上是一层，并不具备完整的两层空间，单层高较普通住宅（通常层高2.8米）高，可在局部增建出一个夹层，安排卧室或书房等，用楼梯联系上下，其目的是在有限的空间里增加使用面积，提高住宅的空间利用率。复式住宅是一种经济型房屋。在建造上仍每户占有上下两层，实际是在层高较高的一层楼中增建一个1.2米的夹层，两层合计的层高要大大低于跃层式住宅（李氏设计为3.3米，而一般跃层式为5.6米），复式住宅的下层供起居用，炊事、进餐、洗浴等，上层供休息睡眠用，户内设多处墙式壁柜和楼梯，中间楼板也即上层地板。一层的厨房高2米，上层贮藏让高1.2米，上层直接作为卧室床面，人可坐起但无法直立。</p>','fu-gu-shi-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('5','0','联系我们','','','50','/upload/images/201304/5000lianxiwomen.jpg','','','','<p>如果你想拥有一份自由有趣的工作，如果你对界面设计拥有一份热情和动力，那么请与我们联系。在这里你能发现一群志同道合的年轻人，并为了实践理想而努力！</p><p>我们的团队为自己的理想奋斗，我们互补性强，分工明确，目标一致，我们艰苦奋斗，坚持不辍！因为我们坚信，一个好的理念和一个优秀的团队势必会成就一个远大的理想！<br/>&nbsp;</p><p>联系我们：<br/>售前咨询客服QQ-01：<br/>售前咨询客服QQ-02：<br/>客户售前咨询热线：<br/>客户售后服务热线：<br/>客服信箱：</p><p>&nbsp;</p><p>&nbsp;</p>','contact','archive/list_ditu.html','archive/list_page.html','0','0','archive/list_ditu.html','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('7','0','职位招聘','','','60','/upload/images/201304/7000zhiweizhaopin.jpg','','','','<p>&nbsp;易通企业网站系统是九州易通科技开发的中国首套免费提供模板的营销型企业网站管理系统，系统前台生成html、完全符合SEO、同时有在线客服、潜在客户跟踪、便捷的企业网站管理、搜索引擎推广等功能。</p>
<p>九州易通科技开发的核心产品易通企业网站系统(CmsEasy3.0)是充分按照SEO最佳标准来开发，营销实用性非常强企业建站系统。灵活的静态化控制，可以自定义字段，自定义模板，自定义表单，自定义URL，交叉绑定分类，地区，专题等多元化定制大大增加了企业网站的各种需求空间。强大的模板自定义可以轻松打造出个性的栏目封面，文章列表，图片列表，下载列表，分类列表，地区列表等等。</p>
<p>&nbsp;</p>','Recruitment','archive/list_job.html','archive/list_job.html','archive/show_job.html','0','archive/list_job.html','archive/list_job.html','archive/show_job.html','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('8','3','家居装修','','','31','/upload/images/201304/3100chanpin.jpg','','','','<p>水果是指多汁且大多数有甜味可直接生吃的植物果实，不但含有丰富的营养且能够帮助消化。水果有降血压、减缓衰老、减肥瘦身、皮肤保养、 明目、抗癌、降低胆固醇补充维生素等保健作用。</p><p><br/></p><p><br/></p><p>浆果类：草莓，蓝莓，黑莓，桑葚，覆盆子，葡萄　</p><p><br/></p><p>浆果类&nbsp;(6张)</p><p><br/></p><p>柑橘类：蜜橘，砂糖橘，金橘，蜜柑，甜橙，脐橙，西柚，柚子，葡萄柚，柠檬，文旦，莱姆</p><p><br/></p><p>柑橘类&nbsp;(12张)</p><p><br/></p><p>核果类：桃（油桃，蟠桃，水蜜桃，黄桃），李子，樱桃，杏，梅子，杨梅，</p><p><br/></p><p>核果类&nbsp;(6张)</p><p>&nbsp;西梅，乌梅，大枣，沙枣，海枣，蜜枣，橄榄，荔枝，龙眼（桂圆），槟榔</p><p><br/></p><p>仁果类：苹果（红富士，红星，国光，秦冠，黄元帅），梨（砂糖梨，黄金梨，</p><p><br/></p><p>　莱阳梨，香梨，雪梨，香蕉梨），蛇果，海棠果，沙果，柿子，山竹，黑布林，<br/>　　枇杷，杨桃，山楂，圣女果，无花果，白果，罗汉果，火龙果，猕猴桃<br/>　　瓜类：西瓜，美人瓜，甜瓜，香瓜，黄河蜜，哈密瓜，木瓜，乳瓜<br/>　　其他：菠萝，芒果，栗子，椰子，奇异果，芭乐，榴莲，香蕉，甘蔗，莲子，石榴，核桃，拐枣</p><p><br/></p>','OFFICE','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('12','3','写字楼装修','','','33','/upload/images/201304/3300chanpin.jpg','','','','<p>蔬菜，是指可以做菜、烹饪成为食品的一类植物或菌类，蔬菜是人们日常饮食中必不可少的食物之一，是一种绿色食品。蔬菜可提供人体所必需的多种维生素和矿物质等营养物质。据国际物质粮农组织1990年统计，人体必需的VC的90%、VA的60%来自蔬菜。此外，蔬菜中还有多种多样的植物化学物质，是人们公认的对健康有效的成分，目前果蔬中的营养素可以有效预防慢性、退行性疾病的多种物质，正在被人们研究发现。</p><p><br/></p><p>有机蔬菜：有机蔬菜是指来自于有机农业生产体系，根据国际有机农业的生产技术标准生产出来的，经独立的有机食品认证机构认证允许使用有机食品标志的蔬菜。有机蔬菜在整个的生产过程中都必须按照有机农业的生产方式进行，也就是在整个生产过程中必须严格遵循有机食品的生产技术标准，即生产过程中完全不使用农药、化肥、生长调节剂等化学物质，不使用基因工程技术，同时还必须经过独立的有机食品认证机构全过程的质量控制和审查。所以有机蔬菜的生产必须按照有机食品的生产环境质量要求和生产技术规范来生产，以保证它的无污染、低能耗和高质量的特点。</p><p><br/></p><p><br/></p><p><br/></p><p>绿色蔬菜：按照绿色食品的概念，绿色蔬菜是指遵循可持续发展的原则，在产地生态环境良好的前提下，按照特定的质量标准体系生产，并经专门机构认定，允许使用绿色食品标志的无污染的安全、优质、营养类蔬菜的总称。</p><p><br/></p><p>无公害蔬菜：所谓无公害蔬菜是指蔬菜中有害物质（如农药残留、重金属、亚硝酸盐等）的含量，控制在国家规定的允许范围内，人们食用后对人体健康不造成危害的蔬菜。指产地生态环境清洁，按照特定的技术操作规程生产，将有害物含量控制在规定标准内，并由授权部门审定批准，允许使用无公害标志的食品。适合我国当前的农业生产发展水平和国内消费者的需求，对于多数生产者来说，达到这一要求不是很难。当代农产品生产需要由普通农产品发展到无公害农产品，再发展至绿色食品或有机食品，绿色食品跨接在无公害食品和有机食品之间，无公害食品是绿色食品发展的初级阶段，有机食品是质量更高的绿色食品。</p><p><br/></p>','WORKSHOP','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('10','3','酒店装修','','','32','/upload/images/201304/3200chanpin.jpg','','','','<p>谷物”涵盖的范围较广，包括大米、小麦、小米、大豆等及其它杂粮。谷类包括大米、小麦、小米、大豆等，主要是植物种子和果实。是许多亚洲人民的传统主食。</p><p><br/></p><p>“五谷”这一名词的最早记录，见于《论语》。根据《论语》的记载：二千四百多年以前，孔子带着学生出门远行，子路掉队在后面，遇见一位用杖挑着竹筐的老农，问他：“你看见夫子吗？”老农说：“四肢不劳动，五谷分不清，谁是夫子？” 在此前的《诗经》、《尚书》之中，只有“百谷”，而无“五谷”的提法。但对五谷究竟指哪五种作物，则出现在汉朝时的著作。</p><p>谷类主要是指禾本科植物的种子。五谷主要包括稻米、小麦、大豆等及其他杂粮，比如小米、黑米、荞麦、燕麦、薏仁米、高粱等。谷物通过加工为主食，为人类提供了50%~80%的热能、40%~70%的蛋白质、60%以上的维生素B1。谷类可因种类、品种、产地、生长条件和加工方法的不同，其营养素的含量有很大的差别。</p><p>谷类作为中国人的传统饮食，几千年来一直是老百姓餐桌上不可缺少的食物之一，在我国的膳食中占有重要的地位，被当作传统的主食。</p><p><br/></p>','EXHIBITION','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('11','9','iPhone','','','0','','','','','','iPhone','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','','','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('13','2','企业新闻','','','21','/upload/images/201304/2100qiyexinwen.jpg','','','','<p>&nbsp;WAP的诞生同时亦为商务缔造无穷商机。商户便可透过WA P技术接通庞大的手机用户市场，拓展无限的业务空间。CmsEasy易通免费企业网站系统推出了手机浏览功能，方便了企业在移动互联网上争夺自己的一片战场，为自己在移动互联网上的营销，您可以通过WAP手机浏览网站功能让您的客户无论身在何处，都可以轻松便捷的访问您的网站。</p>','Enterprise_News','archive/list_text.html','archive/list_text.html','0','0','archive/list_text.html','archive/list_text.html','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('14','2','行业新闻','','','22','/upload/images/201304/2200xinwendongtai.jpg','','','','<p>&nbsp;网站建设入门难点就在模板制作和设置，CmsEasy易通免费企业网站系统为建站用户提供了中文标签设置，您在后台简单的鼠标设置下标签内容，网站前台内容就随之变化，用户操作使用极为方便，而且简单易懂。</p><div>&nbsp;</div>','News_Information','archive/list_text_pic.html','archive/list_text_pic.html','0','0','archive/list_text_pic.html','archive/list_text_pic.html','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('15','2','新闻动态','','','23','/upload/images/201304/2300hangyexinwen.jpg','','','','<p>&nbsp;对于营销型企业网站，最重要的是和客户的及时沟通以及回访，CmsEasy易通免费企业网站系统这点做的非常完美，从订单到客户留言，到web直接咨询都可以给您和您的客户带来极为方便的沟通方式。客户可以选择web对话、短信、留言一系列方式进行沟通。</p>','Industry_News','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('23','22','售前咨询','','','0','','','','','<p>&nbsp;易通企业网站系统是九州易通科技开发的中国首套免费提供模板的营销型企业网站管理系统，系统前台生成html、完全符合SEO、同时有在线客服、潜在客户跟踪、便捷的企业网站管理、搜索引擎推广等功能。</p>','shou-qian-zi-xun','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('24','22','送货流程','','','0','','','','','<p>&nbsp;九州易通科技开发的核心产品易通企业网站系统(CmsEasy3.0)是充分按照SEO最佳标准来开发，营销实用性非常强企业建站系统。灵活的静态化控制，可以自定义字段，自定义模板，自定义表单，自定义URL，交叉绑定分类，地区，专题等多元化定制大大增加了企业网站的各种需求空间。强大的模板自定义可以轻松打造出个性的栏目封面，文章列表，图片列表，下载列表，分类列表，地区列表等等。</p>','song-huo-liu-cheng','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('25','22','安装服务','','','0','','','','','<p>&nbsp;CMSEasy根据当前广为流行的敏捷开发方式，实现了基于ROR模型框架，能够快速高效的完成各种应用的开发和扩展。</p>
<p>&nbsp;</p>','an-zhuang-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('26','22','售后服务','','','0','','','','','<p>&nbsp;CmsEasy易通免费企业网站系统自带国内企业CMS首创的推广链模块，通过推广链接让客户和生意自己找上门！这点是CmsEasy易通免费企业网站系统独有的优势和长处，在这里推荐各位企业建站用户体验下。</p>
<div>&nbsp;</div>','shou-hou-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('66','0','我们的优势','','','0','','','','','<p>采用模块化方式开发，功能易用便于扩展，可面向大中型站点提供重量级网站建设解决方案。</p>','wo-men-de-you-shi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('67','66','创新的设计理念优势','','','0','','','','','<p><span style=\"font-family: &#39;Calibri&#39;;font-size: 14px\"><span style=\"font-family:宋体\"><span style=\"font-family: 宋体; font-size: 14px;\">本</span>装饰公司拥有专业高水平的设计团队，以追求时尚、与众不同、风格迥异、力求完美、独特创新的设计理念，为客户设计出人与空间、实用与艺术、品质与成本完美融洽相互组合的场所。每一位设计师都是专业、时尚、创新、诚信、经验丰富的公装设计师。　</span></span></p>','chuang-xin-de-she-ji-li-nian-you-shi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('68','66','环保、优质的材料','','','0','','','','','<p><span style=\"font-family: &#39;Calibri&#39;;font-size: 14px\"><span style=\"font-family:宋体\">与国内外许多知名品牌材料厂商有长期合作，如科勒卫浴、美标、澳斯曼洁具、金牌洁具、圣象强化木地板、安信地板、乐洋洋地板、锁先生、华耀玻璃、诺贝雨磁砖、蒙娜丽莎、雷士照明、康彩、马可波罗等各种全国知名材料厂商。公司建立了专业的装饰材料展厅，所有主材，应有尽有，完美的为您呈现。装饰材料均可出具合作厂家提供的质量和环保检测报告，质优价廉、环保健康。</span></span></p>','huan-bao--you-zhi-de-cai-liao','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('69','66','精湛的施工','','','0','','','','','<p><span style=\"font-family: &#39;Calibri&#39;;font-size: 14px\"><span style=\"font-family:宋体\">拥有来自苏、皖等具有多年专业施工经验的施工工程团队。他们技术精湛，专业知识丰富，严格按照国家装饰《装修施工标准》施工，同时，公司工程部会根据装饰材料和市场需求，不断进行材料升级和工艺创新，力争做到让每一项工程均以一流的工艺完美展现。</span></span></p>','jing-zhan-de-shi-gong','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('70','66','完善的售后','','','0','','','','','<p><span style=\"font-family: &#39;Calibri&#39;;font-size: 14px\"><span style=\"font-family:宋体\">为了解决客户对场所装修后期会出现的质量问题等种种顾虑，公司建立了完善的售前、售中和售后服务体系。建立了专业化的服务小组，配备了现代化完善的网络办公系统，并配备专业的客服人员，无论是通过在线网络，还是公司</span><span style=\"font-family:Calibri\">24</span><span style=\"font-family:宋体\">小时客服电话，都能对客户反映问题迅速回应并及时解决。</span></span></p>','wan-shan-de-shou-hou','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('57','56','商业授权','','','0','','','','','','shang-ye-shou-quan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('58','56','建站套餐','','','0','','','','','','jian-zhan-tao-can','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('59','56','模板定制','','','0','','','','','','mo-ban-ding-zhi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('80','76','店面装修','','','0','','','','','<p>网店的店铺装修与实体店的装修是一个意思，都是让店铺变的更美，更吸引人。甚至对于网店来讲，一个好的店铺设计更为至关重要，因为咱们的客户只能从网上的文字和图片来了解我们，了解产品，所以做得好能增加用户的信任感，甚至还能对自己店铺品牌的树立起到关键作用。　“普通店铺”结构很固定，只能做一小点装饰，功能性不强。而“旺铺”自由度非常大，功能也很强，关键就看你自己的创意和技术了，一般大家装修，一是自己会做平面设计，会编网页程序的，自己来设计，或者为了让店铺更专业漂亮，请专业人员来设计。有的加入声音装修，去魅力造音录制自己的有声店铺宣传等等，最好自己是一个专业网页设计师。一般，店铺装修是最让掌柜们头疼的事情，是不是专业店铺，看装修就能分辨。</p>','dian-mian-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('40','39','初步洽谈','','','0','','','','','','chu-bu-qia-tan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('41','39','设计意向','','','0','','','','','','she-ji-yi-xiang','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('42','39','签订协议','','','0','','','','','','qian-ding-xie-yi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('43','39','设计阶段','','','0','','','','','','she-ji-jie-duan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('44','39','预算阶段','','','0','','','','','','yu-suan-jie-duan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('45','39','签订施工合同','','','0','','','','','','qian-ding-shi-gong-he-tong','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('46','39','选购主材','','','0','','','','','','xuan-gou-zhu-cai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('47','39','施工现场确认','','','0','','','','','','shi-gong-xian-chang-que-ren','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('48','39','完工','','','0','','','','','','wan-gong','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('49','39','软装配饰服务','','','0','','','','','','ruan-zhuang-pei-shi-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('53','50','完成项目展示','','','0','','','','','','wan-cheng-xiang-mu-zhan-shi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('54','50','预约参观','','','0','','','','','','yu-yue-can-guan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('60','1','企业简介','','','0','/upload/images/201608/14701255480562.jpg','','','','<div style=\"white-space: normal;\">CmsEasy是一款基于 PHP+Mysql 架构的网站内容管理系统，也是一个 PHP 开发平台。 采用模块化方式开发，功能易用便于扩展，可面向大中型站点提供重量级网站建设解决方案。2年来，凭借 团队长期积累的丰富的Web开发及数据库经验和勇于创新追求完美的设计理念，使得 CmsEasy v1.0 得到了众多网站的认可，并且越来越多地被应用到大中型商业网站。</div><p>&nbsp;</p><div style=\"white-space: normal;\">CmsEasy是一款基于 PHP+Mysql 架构的网站内容管理系统，也是一个 PHP 开发平台。 采用模块化方式开发，功能易用便于扩展，可面向大中型站点提供重量级网站建设解决方案。2年来，凭借 团队长期积累的丰富的Web开发及数据库经验和勇于创新追求完美的设计理念，使得 CmsEasy v1.0 得到了众多网站的认可，并且越来越多地被应用到大中型商业网站。</div><div style=\"white-space: normal; color: rgb(102, 102, 102);-- font-family: tahoma, Helvetica, arial, 宋体, sans-serif; font-size: 14px; line-height: 28px;\">&nbsp;</div><p><br/></p>','qi-ye-jian-jie','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('62','1','我们的团队','','','0','','','','','<div style=\"white-space: normal;\">CmsEasy是一款基于 PHP+Mysql 架构的网站内容管理系统，也是一个 PHP 开发平台。 采用模块化方式开发，功能易用便于扩展，可面向大中型站点提供重量级网站建设解决方案。2年来，凭借 团队长期积累的丰富的Web开发及数据库经验和勇于创新追求完美的设计理念，使得 CmsEasy v1.0 得到了众多网站的认可，并且越来越多地被应用到大中型商业网站。</div><div style=\"white-space: normal; color: rgb(102, 102, 102);-- font-family: tahoma, Helvetica, arial, 宋体, sans-serif; font-size: 14px; line-height: 28px;\">&nbsp;</div><p><br/></p>','wo-men-de-jiao-shi','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('64','63','我们的服务','','','0','','','','','','wo-men-de-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('78','76','别墅装修','','','0','','','','','<p>别墅装修，是一种以别墅为主题参与设计装饰的当代新生活设计理念。别墅，象征着是有身份的人的居家住宅理念。它相较于一般的居家住宅，不仅在于“大”，还在于是否与之相适应的“环境、配套”的特殊性。因而，别墅装修设计不仅仅是对别墅室内空间的合理规划，还要对室内外环境的结合做一个整体的思考和设计，从而达成一个内外兼修的和谐人居环境。</p><p>别墅装修突出的特点在于，他能体现一个人生活水平和艺术涵养，别墅装修是近年来突起的家装设计领域，他是家装与艺术的结合体，也是室内装饰细化的突出点之一。</p><p><br/></p>','bie-shu-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('76','0','我们的服务','','','0','','','','','','wo-men-de-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('77','76','家庭装修','','','0','','','','','<p>家庭装修是把生活的各种情形“物化”到房间之中，买的一般房间的设计业已完成，不能做大的调整了，所以剩下可以动的就是装修装点（大的装修概念包括房间设计、装修、家具布置、富有情趣的小装点）。因为生活是自己的，所以自己必须亲自介入到装修过程中，不仅在装修设计施工期间，还包括住进去之后的长期的不断改进。是件浩大而琐碎的工程，无论是大到地板、家具的定制还是几颗镙丝钉的购买，办理开工手续到组织水电、木工等多个工种的协调工作，都需要业主用智慧去整合。</p>','jia-ting-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','0','','0','0','','0','1','0.00','0.00');-- 

