DROP TABLE IF EXISTS `cmseasy_a_attachment`;-- 
CREATE TABLE `cmseasy_a_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT NULL,
  `path` varchar(150) NOT NULL,
  `thumb` varchar(100) DEFAULT NULL,
  `intro` varchar(100) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_a_comment`;-- 
CREATE TABLE `cmseasy_a_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL,
  `content` text NOT NULL,
  `telphone` varchar(50) DEFAULT '',
  `zannum` int(11) DEFAULT '0',
  `rid` int(11) DEFAULT '0',
  `userid` int(11) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `checked` tinyint(1) DEFAULT '0',
  `reply` text,
  `issee` int(11) DEFAULT NULL COMMENT '仅自己可见',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_a_rank`;-- 
CREATE TABLE `cmseasy_a_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT NULL,
  `catid` int(11) DEFAULT NULL,
  `typeid` int(11) DEFAULT NULL,
  `ranks` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_a_vote`;-- 
CREATE TABLE `cmseasy_a_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT NULL,
  `titles` text,
  `votes` text,
  `users` text,
  `images` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_activity`;-- 
CREATE TABLE `cmseasy_activity` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `timestamp` int(255) DEFAULT NULL,
  `operatorid` varchar(255) NOT NULL DEFAULT '',
  `departmentid` int(10) NOT NULL DEFAULT '0',
  `status` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_announcement`;-- 
CREATE TABLE `cmseasy_announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `content` mediumtext NOT NULL,
  `adddate` datetime DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_app_config`;-- 
CREATE TABLE `cmseasy_app_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '公用插件表id',
  `name` varchar(50) NOT NULL COMMENT '配置名称',
  `value` varchar(255) NOT NULL COMMENT '配置数据',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `conent` varchar(255) DEFAULT NULL COMMENT '提示',
  `type` int(11) NOT NULL DEFAULT '1' COMMENT '类型（1/文本框 2/下拉框 3/单选）',
  `othervalue` text COMMENT '下拉，单选内容',
  `appname` varchar(50) NOT NULL COMMENT '绑定的插件名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_apps`;-- 
CREATE TABLE `cmseasy_apps` (
  `id` varchar(200) NOT NULL COMMENT '文件夹名称',
  `name` varchar(50) NOT NULL COMMENT '插件名称',
  `version` varchar(20) NOT NULL COMMENT '插件版本',
  `desc` varchar(200) DEFAULT NULL COMMENT '插件说明',
  `installed` int(1) NOT NULL DEFAULT '0' COMMENT '安装状态',
  `admin_url` varchar(200) DEFAULT NULL COMMENT '插件安装后跳转路径',
  `iscorp` int(1) NOT NULL DEFAULT '0' COMMENT '是否商业版',
  `icon` varchar(200) DEFAULT NULL COMMENT '插件图标',
  `static` int(1) NOT NULL DEFAULT '0' COMMENT '显示状态',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '插件单价',
  `isbuy` int(1) DEFAULT '0' COMMENT '是否支付',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_archive`;-- 
CREATE TABLE `cmseasy_archive` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(6) NOT NULL,
  `typeid` int(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `tag` varchar(255) DEFAULT NULL,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `view` int(11) NOT NULL DEFAULT '0',
  `color` char(20) DEFAULT NULL,
  `strong` tinyint(1) DEFAULT '0',
  `toppost` tinyint(1) DEFAULT '0',
  `font` char(6) DEFAULT NULL,
  `spid` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `mtitle` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `description` text,
  `listorder` int(11) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `author` varchar(20) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `checked` tinyint(2) DEFAULT '0',
  `introduce` text,
  `introduce_len` int(5) NOT NULL,
  `content` mediumtext,
  `template` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `linkto` varchar(100) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(255) DEFAULT NULL,
  `attr3` varchar(20) DEFAULT NULL,
  `comment_num` int(11) DEFAULT '0',
  `attachment_id` varchar(50) DEFAULT NULL,
  `attachment_path` varchar(150) DEFAULT NULL,
  `grade` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pics` text,
  `type` char(10) NOT NULL,
  `province_id` int(3) NOT NULL,
  `city_id` int(3) DEFAULT NULL,
  `section_id` int(3) DEFAULT NULL,
  `outtime` date NOT NULL,
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `iscomment` tinyint(1) DEFAULT '1',
  `updatedate` datetime DEFAULT NULL COMMENT '修改时间',
  `praise` varchar(255) DEFAULT NULL,
  `my_field` varchar(255) DEFAULT NULL COMMENT '商品信息字段',
  `salesnum` int(11) DEFAULT NULL,
  `langid` int(11) DEFAULT NULL,
  `inventory` int(11) NOT NULL DEFAULT '0',
  `my_tagone` mediumtext,
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  `combined` varchar(500) DEFAULT NULL COMMENT '组合商品',
  `buyurl` text COMMENT '购买链接',
  `my_shopping_model` text,
  `my_shopping_color` text,
  `my_pingjunjiage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`),
  KEY `keyword` (`keyword`),
  KEY `title` (`title`),
  KEY `type` (`type`),
  KEY `catid` (`typeid`),
  KEY `typeid` (`catid`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM AUTO_INCREMENT=552 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_assigns`;-- 
CREATE TABLE `cmseasy_assigns` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `departmentid` int(255) NOT NULL DEFAULT '0',
  `operatorid` int(255) NOT NULL DEFAULT '0',
  `poll` int(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_atlasmap`;-- 
CREATE TABLE `cmseasy_atlasmap` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mapy` varchar(100) NOT NULL COMMENT '经度',
  `mapx` varchar(100) NOT NULL COMMENT '维度',
  `mapname` varchar(255) DEFAULT NULL COMMENT '名称',
  `mapurl` varchar(255) NOT NULL COMMENT '地址',
  `maptel` varchar(20) DEFAULT NULL COMMENT '电话',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_b_arctag`;-- 
CREATE TABLE `cmseasy_b_arctag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `tagid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `arctag` (`aid`,`tagid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=316 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_b_category`;-- 
CREATE TABLE `cmseasy_b_category` (
  `catid` int(6) NOT NULL AUTO_INCREMENT,
  `parentid` int(6) NOT NULL,
  `catname` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `scategory` varchar(50) DEFAULT NULL,
  `listorder` int(11) DEFAULT NULL,
  `image` varchar(150) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `keyword` varchar(150) DEFAULT NULL,
  `description` text,
  `categorycontent` mediumtext,
  `htmldir` varchar(50) NOT NULL,
  `template` varchar(50) DEFAULT NULL,
  `listtemplate` varchar(50) DEFAULT NULL,
  `showtemplate` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `listtemplatewap` varchar(50) DEFAULT NULL,
  `showtemplatewap` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `listhtmlrule` varchar(100) DEFAULT NULL,
  `showhtmlrule` varchar(100) DEFAULT NULL,
  `module` varchar(16) NOT NULL DEFAULT 'article',
  `isshow` tinyint(2) DEFAULT '1',
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `ispages` tinyint(2) DEFAULT NULL,
  `includecatarchives` tinyint(2) DEFAULT '0',
  `addarcenable` tinyint(2) DEFAULT NULL,
  `linkto` varchar(150) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(20) DEFAULT NULL,
  `thumb` varchar(100) DEFAULT NULL,
  `thumb_width` int(3) DEFAULT NULL,
  `thumb_height` int(3) DEFAULT NULL,
  `isnav` tinyint(1) DEFAULT NULL,
  `ismobilenav` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `isscreening` tinyint(1) NOT NULL DEFAULT '0',
  `nofollow` tinyint(1) NOT NULL COMMENT '控制nofollow',
  `isblank` tinyint(1) NOT NULL COMMENT '设置新窗口打开',
  `contentrank` varchar(255) DEFAULT '',
  `isshopping` tinyint(1) NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  PRIMARY KEY (`catid`),
  UNIQUE KEY `category` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=170 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_b_special`;-- 
CREATE TABLE `cmseasy_b_special` (
  `spid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `meta_title` varchar(255) DEFAULT '',
  `specialcontent` mediumtext,
  `banner` varchar(100) NOT NULL,
  `description` text,
  `template` varchar(30) NOT NULL,
  `adddate` int(10) unsigned NOT NULL DEFAULT '0',
  `listorder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `keyword` varchar(255) DEFAULT NULL,
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` int(6) DEFAULT NULL,
  `ishtml` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isscreening` tinyint(1) NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  `htmldir` varchar(50) DEFAULT NULL COMMENT '目录名',
  `htmlrule` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`spid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_b_tag`;-- 
CREATE TABLE `cmseasy_b_tag` (
  `tagid` int(11) NOT NULL AUTO_INCREMENT,
  `tagname` varchar(255) DEFAULT NULL,
  `langid` int(11) DEFAULT NULL COMMENT '语言绑定',
  `htmldir` varchar(50) DEFAULT NULL COMMENT '静态页面名称',
  `txtsize` int(11) DEFAULT NULL COMMENT '文字大小',
  `txtcolor` varchar(50) DEFAULT NULL COMMENT '文字颜色',
  `listorder` int(11) DEFAULT '0' COMMENT '排序',
  `htmlrule` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`tagid`),
  UNIQUE KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_ballot`;-- 
CREATE TABLE `cmseasy_ballot` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `type` set('radio','checkbox') NOT NULL DEFAULT 'radio',
  `num` int(11) unsigned NOT NULL DEFAULT '0',
  `listorder` int(11) unsigned NOT NULL DEFAULT '0',
  `enddate` date DEFAULT NULL,
  `votegroupid` varchar(255) DEFAULT NULL,
  `viewgroupid` varchar(255) DEFAULT NULL,
  `resgroupid` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_buytemplate`;-- 
CREATE TABLE `cmseasy_buytemplate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL COMMENT '编号',
  `iscorp` int(1) DEFAULT '0' COMMENT '是否商业版',
  `isview` int(1) NOT NULL DEFAULT '0' COMMENT '是否支持可视化',
  `url` varchar(255) DEFAULT NULL COMMENT '预览地址',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '价格  0的话为免费',
  `img` varchar(255) DEFAULT NULL COMMENT '模板缩略图',
  `static` int(1) DEFAULT '0' COMMENT '是否发布',
  `installed` int(1) DEFAULT '0' COMMENT '是否安装',
  `desc` varchar(255) DEFAULT NULL COMMENT '备注',
  `isbuy` int(1) DEFAULT '0' COMMENT '是否支付',
  `serviceid` int(11) DEFAULT '0' COMMENT '服务端模板ID',
  `makeredbili` decimal(10,2) DEFAULT '0.00' COMMENT '分红比例',
  `makereduser` int(11) DEFAULT NULL COMMENT '分红用户',
  PRIMARY KEY (`id`,`code`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_chat`;-- 
CREATE TABLE `cmseasy_chat` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `sessionid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL,
  `email` varchar(30) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `message` varchar(200) DEFAULT NULL,
  `timestamp` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL,
  `departmentid` int(10) DEFAULT NULL,
  `operatorid` int(10) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `admin_status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_consumption`;-- 
CREATE TABLE `cmseasy_consumption` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(100) NOT NULL COMMENT '订单号',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `adddate` datetime DEFAULT NULL COMMENT '新增日期',
  `status` int(3) NOT NULL DEFAULT '0',
  `s_status` tinyint(1) NOT NULL DEFAULT '0',
  `trade_no` varchar(255) NOT NULL DEFAULT '' COMMENT '支付编号',
  `mid` int(11) NOT NULL COMMENT '用户id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_coupon`;-- 
CREATE TABLE `cmseasy_coupon` (
  `couponid` int(11) NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `coupontitle` varchar(100) DEFAULT NULL COMMENT '优惠劵标题',
  `couponuse` varchar(255) DEFAULT NULL COMMENT '用途',
  `couponrange` varchar(100) DEFAULT NULL COMMENT '使用范围',
  `overlay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否叠加劵',
  `satisfy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '满多少可用',
  `moeny` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '用劵金额',
  `quantity` int(11) NOT NULL DEFAULT '0' COMMENT '数量',
  `usedquantity` int(11) NOT NULL DEFAULT '0' COMMENT '已使用数量',
  `overduedate` date DEFAULT NULL COMMENT '过期时间',
  `adddatatime` date DEFAULT NULL COMMENT '添加时间',
  `couponyard` varchar(50) DEFAULT NULL COMMENT '优惠码',
  `isexchange` tinyint(1) NOT NULL DEFAULT '1' COMMENT '可否积分兑换',
  `exchangepoints` int(11) DEFAULT '0' COMMENT '积分兑换',
  `statu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（默认生效）',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`couponid`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_departments`;-- 
CREATE TABLE `cmseasy_departments` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `visible` int(1) NOT NULL DEFAULT '1',
  `order` int(255) NOT NULL DEFAULT '1',
  `email` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_detail`;-- 
CREATE TABLE `cmseasy_detail` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `chatid` int(255) NOT NULL DEFAULT '0',
  `detail` text NOT NULL,
  `who_witter` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_event`;-- 
CREATE TABLE `cmseasy_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `event` varchar(30) DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `user` (`uid`,`username`,`ip`),
  KEY `time` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_expresscompany`;-- 
CREATE TABLE `cmseasy_expresscompany` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `companyid` varchar(50) NOT NULL COMMENT '快递公司编码',
  `companyname` varchar(200) NOT NULL COMMENT '快递公司名称',
  `companytrack` tinyint(1) NOT NULL DEFAULT '0' COMMENT '轨迹查询',
  `companynoodle` tinyint(1) NOT NULL DEFAULT '0' COMMENT '电子面单',
  `companysubscribe` tinyint(1) NOT NULL DEFAULT '0' COMMENT '预约取件',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=418 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_expressconfig`;-- 
CREATE TABLE `cmseasy_expressconfig` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ebusinessid` varchar(255) NOT NULL COMMENT '电商ID',
  `appkey` varchar(255) NOT NULL COMMENT '电商加密私钥，快递鸟提供，注意保管，不要泄漏',
  `requrl` varchar(255) NOT NULL COMMENT '快递鸟请求url',
  `userid` varchar(255) NOT NULL COMMENT '用户id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_friendlink`;-- 
CREATE TABLE `cmseasy_friendlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linktype` tinyint(2) DEFAULT NULL,
  `typeid` tinyint(2) DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `listorder` int(11) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `introduce` text,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(60) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `hits` int(11) DEFAULT NULL,
  `state` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_g_cate`;-- 
CREATE TABLE `cmseasy_g_cate` (
  `catid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catname` varchar(255) NOT NULL DEFAULT '',
  `cattype` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `num` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_g_reply`;-- 
CREATE TABLE `cmseasy_g_reply` (
  `rid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` int(11) unsigned NOT NULL DEFAULT '0',
  `replycontent` mediumtext,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL DEFAULT '',
  `replytime` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_guestbook`;-- 
CREATE TABLE `cmseasy_guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `userid` int(11) NOT NULL,
  `adddate` datetime NOT NULL,
  `state` tinyint(2) NOT NULL DEFAULT '1',
  `guesttel` varchar(50) NOT NULL,
  `guestemail` varchar(255) NOT NULL,
  `guestqq` varchar(50) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `reply` text,
  `ip` varchar(20) DEFAULT NULL,
  `checked` tinyint(2) NOT NULL DEFAULT '0',
  `issee` int(11) DEFAULT NULL COMMENT '仅自己可见',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_guestbookfield`;-- 
CREATE TABLE `cmseasy_guestbookfield` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `listorder` int(20) NOT NULL DEFAULT '0' COMMENT '排序',
  `name` varchar(50) NOT NULL COMMENT '字段名称',
  `showname` varchar(255) NOT NULL COMMENT '字段显示名称',
  `message` varchar(100) NOT NULL COMMENT '提示信息',
  `isnull` tinyint(1) DEFAULT '0' COMMENT '是否必填',
  `isshow` tinyint(1) DEFAULT '1' COMMENT '字段是否显示',
  `type` varchar(100) NOT NULL COMMENT '字段类型',
  `leng` int(20) DEFAULT NULL COMMENT '字段长度',
  `fieldvalue` text COMMENT '字段内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_invite`;-- 
CREATE TABLE `cmseasy_invite` (
  `inviteid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `invitecode` varchar(255) DEFAULT NULL,
  `ctuid` int(11) unsigned DEFAULT NULL,
  `ctname` varchar(255) DEFAULT NULL,
  `reguid` int(11) DEFAULT NULL,
  `cttime` datetime DEFAULT NULL,
  `regtime` datetime DEFAULT NULL,
  `isuse` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`inviteid`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_lang`;-- 
CREATE TABLE `cmseasy_lang` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `listorder` int(11) DEFAULT '0' COMMENT '排序',
  `langurlname` varchar(20) NOT NULL COMMENT '语言文件夹名称  唯一',
  `langname` varchar(50) DEFAULT NULL COMMENT '语言名称',
  `langimg` varchar(255) DEFAULT NULL COMMENT '图标',
  `static` tinyint(1) DEFAULT '1' COMMENT '语言状态',
  `isdefault` tinyint(1) DEFAULT '0' COMMENT '默认语言  第二个开其他就关',
  `domain` varchar(255) DEFAULT NULL COMMENT '域名',
  `istemplate` tinyint(1) NOT NULL DEFAULT '0',
  `isadmin` tinyint(1) NOT NULL DEFAULT '0',
  `adminlangid` int(11) DEFAULT '0' COMMENT '后台语言设置ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_license`;-- 
CREATE TABLE `cmseasy_license` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned DEFAULT '0',
  `uid` int(11) unsigned DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  `pay` decimal(10,2) unsigned DEFAULT '0.00',
  `domain` varchar(50) DEFAULT '',
  `cate` varchar(255) NOT NULL DEFAULT 'product',
  `timelong` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6275 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_linkword`;-- 
CREATE TABLE `cmseasy_linkword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linkword` varchar(255) NOT NULL,
  `linkurl` varchar(255) DEFAULT NULL,
  `linkorder` int(11) DEFAULT NULL,
  `linktimes` int(3) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `word` (`linkword`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_my_yingpin`;-- 
CREATE TABLE `cmseasy_my_yingpin` (
  `fid` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT NULL,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `adddate` datetime DEFAULT NULL,
  `view` int(11) DEFAULT '0',
  `state` tinyint(2) DEFAULT '1',
  `checked` tinyint(2) DEFAULT '0',
  `ip` varchar(20) DEFAULT NULL,
  `my_xingming` varchar(255) DEFAULT NULL,
  `my_xingbie` varchar(10) DEFAULT NULL,
  `my_shouji` varchar(255) DEFAULT NULL,
  `my_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `fid` (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_newconfig`;-- 
CREATE TABLE `cmseasy_newconfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT 'config名称',
  `value` varchar(255) NOT NULL COMMENT 'config值',
  `showname` varchar(50) NOT NULL COMMENT '显示的名称',
  `remark` varchar(255) DEFAULT NULL COMMENT '提示-html代码',
  `type` varchar(255) DEFAULT 'text' COMMENT '类型  默认文本类型',
  PRIMARY KEY (`id`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_notification`;-- 
CREATE TABLE `cmseasy_notification` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '通知表ID',
  `userid` varchar(50) DEFAULT NULL COMMENT '通知用户ID',
  `title` varchar(100) NOT NULL COMMENT '通知标题',
  `note` varchar(255) NOT NULL COMMENT '通知内容',
  `titleurl` varchar(255) DEFAULT NULL COMMENT '通知跳转的链接',
  `adddatatime` datetime NOT NULL COMMENT '通知时间',
  `static` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_operators`;-- 
CREATE TABLE `cmseasy_operators` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `departmentid` int(10) NOT NULL DEFAULT '0',
  `level` int(1) NOT NULL DEFAULT '0',
  `timestamp` int(255) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_option`;-- 
CREATE TABLE `cmseasy_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `num` int(11) unsigned NOT NULL DEFAULT '0',
  `order` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `bid` (`bid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_p_ologin`;-- 
CREATE TABLE `cmseasy_p_ologin` (
  `ologin_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `ologin_code` varchar(20) NOT NULL DEFAULT '',
  `ologin_name` varchar(120) NOT NULL DEFAULT '',
  `ologin_desc` text NOT NULL,
  `ologin_config` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ologin_id`),
  UNIQUE KEY `ologin_code` (`ologin_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_p_orders`;-- 
CREATE TABLE `cmseasy_p_orders` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `oid` varchar(100) NOT NULL,
  `aid` varchar(255) NOT NULL,
  `somecoupon` varchar(255) DEFAULT NULL COMMENT '使用优惠劵',
  `status` int(3) NOT NULL DEFAULT '0',
  `mid` int(10) NOT NULL DEFAULT '0',
  `adddate` int(10) NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `telphone` varchar(50) NOT NULL,
  `pnums` varchar(50) NOT NULL DEFAULT '0',
  `pname` char(80) NOT NULL,
  `address` varchar(200) NOT NULL,
  `postcode` char(20) NOT NULL,
  `content` text NOT NULL,
  `courier_number` varchar(100) NOT NULL,
  `s_status` tinyint(1) NOT NULL DEFAULT '0',
  `trade_no` varchar(255) NOT NULL DEFAULT '',
  `menoy` decimal(10,2) DEFAULT '0.00' COMMENT '支付金额',
  `finalkey` varchar(255) DEFAULT '',
  `expresstype` varchar(255) DEFAULT '',
  `admindiscounts` decimal(10,2) NOT NULL DEFAULT '0.00',
  `pay_fee` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`,`mid`),
  KEY `adddate` (`adddate`)
) ENGINE=MyISAM AUTO_INCREMENT=112 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_p_pay`;-- 
CREATE TABLE `cmseasy_p_pay` (
  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `pay_code` varchar(20) NOT NULL DEFAULT '',
  `pay_name` varchar(120) NOT NULL DEFAULT '',
  `pay_image` varchar(255) DEFAULT NULL,
  `pay_fee` varchar(10) NOT NULL DEFAULT '0',
  `pay_desc` text NOT NULL,
  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pay_config` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`pay_id`),
  UNIQUE KEY `pay_code` (`pay_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_p_shipping`;-- 
CREATE TABLE `cmseasy_p_shipping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `overweight` int(10) NOT NULL,
  `cashondelivery` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `insure` tinyint(1) NOT NULL DEFAULT '0',
  `insureproportion` smallint(6) NOT NULL DEFAULT '0',
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_pay_exchange`;-- 
CREATE TABLE `cmseasy_pay_exchange` (
  `exchangeid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL DEFAULT '',
  `type` enum('money','point','time','credit') NOT NULL DEFAULT 'money',
  `value` float NOT NULL DEFAULT '0',
  `unit` enum('','y','m','d') NOT NULL DEFAULT '',
  `note` text NOT NULL,
  `addtime` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `authid` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`exchangeid`),
  KEY `username` (`username`,`type`),
  KEY `authid` (`authid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_reply`;-- 
CREATE TABLE `cmseasy_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '回复表ID·',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '对应回复ID',
  `conent` varchar(255) DEFAULT NULL COMMENT '回复内容',
  `uid` int(11) NOT NULL COMMENT '回复的用户id',
  `productid` int(11) NOT NULL COMMENT '对应的产品id',
  `producttype` int(11) NOT NULL COMMENT '产品类型（1/工单 2/暂未做）',
  `adddate` int(11) NOT NULL COMMENT '回复时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_sessionox`;-- 
CREATE TABLE `cmseasy_sessionox` (
  `PHPSESSID` varchar(50) NOT NULL,
  `update_time` int(10) NOT NULL,
  `client_ip` varchar(15) NOT NULL,
  `data` text,
  PRIMARY KEY (`PHPSESSID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_sessions`;-- 
CREATE TABLE `cmseasy_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `email` varchar(30) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `departmentid` int(10) NOT NULL DEFAULT '0',
  `timestamp` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_settings`;-- 
CREATE TABLE `cmseasy_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL,
  `tag` varchar(30) NOT NULL DEFAULT '',
  `value` mediumtext NOT NULL,
  `array` mediumtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_stats`;-- 
CREATE TABLE `cmseasy_stats` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `bot` varchar(50) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_type`;-- 
CREATE TABLE `cmseasy_type` (
  `typeid` int(6) NOT NULL AUTO_INCREMENT,
  `parentid` int(6) NOT NULL,
  `typename` varchar(30) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `stype` varchar(50) DEFAULT NULL,
  `listorder` int(11) DEFAULT '0',
  `image` varchar(150) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `keyword` varchar(150) DEFAULT NULL,
  `description` text,
  `typecontent` mediumtext,
  `htmldir` varchar(50) NOT NULL,
  `template` varchar(50) DEFAULT NULL,
  `listtemplate` varchar(50) DEFAULT NULL,
  `showtemplate` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `listhtmlrule` varchar(100) DEFAULT NULL,
  `showhtmlrule` varchar(100) DEFAULT NULL,
  `module` varchar(16) NOT NULL DEFAULT 'article',
  `isshow` tinyint(2) DEFAULT '1',
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `ispages` tinyint(2) DEFAULT NULL,
  `includecatarchives` tinyint(2) DEFAULT '0',
  `addarcenable` tinyint(2) DEFAULT NULL,
  `linkto` varchar(150) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(20) DEFAULT NULL,
  `thumb` varchar(100) DEFAULT NULL,
  `thumb_width` int(3) DEFAULT NULL,
  `thumb_height` int(3) DEFAULT NULL,
  `isNavigation` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否在导航显示',
  `isscreening` tinyint(1) NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  PRIMARY KEY (`typeid`),
  UNIQUE KEY `type` (`typeid`)
) ENGINE=MyISAM AUTO_INCREMENT=409 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_union`;-- 
CREATE TABLE `cmseasy_union` (
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `payaccount` varchar(30) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `visits` int(10) unsigned NOT NULL DEFAULT '0',
  `registers` int(10) unsigned NOT NULL DEFAULT '0',
  `settleexpendamount` float unsigned NOT NULL DEFAULT '0',
  `totalexpendamount` float unsigned NOT NULL DEFAULT '0',
  `totalpayamount` float unsigned NOT NULL DEFAULT '0',
  `lastpayamount` float unsigned NOT NULL DEFAULT '0',
  `lastpaytime` float unsigned NOT NULL DEFAULT '0',
  `profitmargin` float unsigned NOT NULL DEFAULT '0',
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  `regip` varchar(15) NOT NULL DEFAULT '',
  `passed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_union_pay`;-- 
CREATE TABLE `cmseasy_union_pay` (
  `payid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `payaccount` varchar(100) NOT NULL DEFAULT '',
  `amount` float NOT NULL DEFAULT '0',
  `expendamount` float unsigned NOT NULL DEFAULT '0',
  `profitmargin` float unsigned NOT NULL DEFAULT '0',
  `inputer` varchar(30) NOT NULL DEFAULT '',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`payid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_union_visit`;-- 
CREATE TABLE `cmseasy_union_visit` (
  `visitid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL DEFAULT '0',
  `visittime` int(10) unsigned NOT NULL DEFAULT '0',
  `visitip` varchar(15) NOT NULL DEFAULT '',
  `referer` varchar(255) NOT NULL DEFAULT '',
  `regusername` varchar(30) NOT NULL DEFAULT '',
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`visitid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_user`;-- 
CREATE TABLE `cmseasy_user` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `nickname` varchar(20) DEFAULT NULL,
  `groupid` int(2) NOT NULL DEFAULT '0',
  `checked` tinyint(2) DEFAULT NULL,
  `qqlogin` varchar(255) DEFAULT NULL,
  `alipaylogin` varchar(255) DEFAULT NULL,
  `wechatlogin` varchar(255) DEFAULT NULL,
  `avatar` varchar(100) DEFAULT NULL,
  `userip` varchar(20) DEFAULT NULL,
  `state` tinyint(4) DEFAULT '1',
  `qq` int(15) DEFAULT NULL,
  `e_mail` varchar(60) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `tel` varchar(100) DEFAULT NULL,
  `question` varchar(255) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `intro` text,
  `point` smallint(5) unsigned DEFAULT '0',
  `introducer` int(10) unsigned DEFAULT NULL,
  `regtime` int(10) DEFAULT '0',
  `sex` varchar(10) DEFAULT '',
  `isblock` tinyint(1) DEFAULT '0',
  `isdelete` tinyint(1) DEFAULT '0',
  `headimage` varchar(255) DEFAULT NULL COMMENT '用户头像',
  `integration` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分',
  `couponidnum` varchar(255) DEFAULT NULL COMMENT '优惠劵',
  `collect` varchar(255) DEFAULT NULL COMMENT '收藏',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '积分',
  `adddatetime` datetime DEFAULT NULL,
  `notifiid` varchar(255) DEFAULT '',
  `templatelang` varchar(20) NOT NULL DEFAULT 'cn' COMMENT '前台语言包',
  `adminlang` varchar(20) NOT NULL DEFAULT 'cn' COMMENT '后台语言包',
  `buyarchive` varchar(255) NOT NULL COMMENT '购买的内容或者下载',
  `adminlangdomain` varchar(100) DEFAULT NULL,
  `templatelangdomain` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`userid`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `tel` (`tel`),
  UNIQUE KEY `e_mail` (`e_mail`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_user_history`;-- 
CREATE TABLE `cmseasy_user_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表自增id',
  `userid` int(11) NOT NULL COMMENT '用户id',
  `urlname` varchar(50) NOT NULL COMMENT '记录的名称',
  `url` text NOT NULL COMMENT '记录的地址',
  `static` int(1) NOT NULL DEFAULT '0' COMMENT '是否打开的状态',
  `langid` int(11) DEFAULT '1' COMMENT '语言包ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_usergroup`;-- 
CREATE TABLE `cmseasy_usergroup` (
  `groupid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `discount` float(2,1) unsigned NOT NULL DEFAULT '0.0',
  `powerlist` text,
  `fpwlist` text,
  `integrationclaim` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '积分要求',
  `isadministrator` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否管理组',
  `isint` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_vote_logs`;-- 
CREATE TABLE `cmseasy_vote_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `bid` int(11) unsigned DEFAULT NULL,
  `oid` varchar(255) DEFAULT NULL,
  `addtime` int(10) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_webscan`;-- 
CREATE TABLE `cmseasy_webscan` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `var` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `ext1` varchar(100) DEFAULT NULL,
  `ext2` varchar(100) DEFAULT NULL,
  `state` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_webscan360`;-- 
CREATE TABLE `cmseasy_webscan360` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `var` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `ext1` varchar(100) DEFAULT NULL,
  `ext2` varchar(100) DEFAULT NULL,
  `state` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_weixin`;-- 
CREATE TABLE `cmseasy_weixin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `oldid` varchar(255) DEFAULT NULL,
  `weixinid` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `appid` varchar(255) DEFAULT NULL,
  `appsecret` varchar(255) DEFAULT NULL,
  `checksuc` tinyint(1) unsigned DEFAULT '1',
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_weixinmenu`;-- 
CREATE TABLE `cmseasy_weixinmenu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wid` int(11) unsigned DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `typeid` int(11) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sort` int(11) unsigned DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `txt` text,
  `imgtext` text,
  `intro` text,
  `catid` text,
  `num` int(11) DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_weixinreply`;-- 
CREATE TABLE `cmseasy_weixinreply` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wid` int(11) unsigned DEFAULT NULL,
  `typeid` int(11) unsigned DEFAULT NULL,
  `msgtype` int(11) DEFAULT '0',
  `word` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `txt` text,
  `imgtext` text,
  `intro` text,
  `catid` text,
  `num` int(11) DEFAULT '0',
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_xfconsumption`;-- 
CREATE TABLE `cmseasy_xfconsumption` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(255) NOT NULL COMMENT '消费订单',
  `content` varchar(255) DEFAULT NULL COMMENT '消费内容',
  `menoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '消费金额',
  `adddate` datetime DEFAULT NULL COMMENT '消费日期',
  `status` int(3) NOT NULL DEFAULT '0',
  `mid` int(11) DEFAULT NULL COMMENT '用户id',
  `trade_no` varchar(255) DEFAULT '' COMMENT '支付编号',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;-- 
DROP TABLE IF EXISTS `cmseasy_zanlog`;-- 
CREATE TABLE `cmseasy_zanlog` (
  `zlid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned DEFAULT NULL,
  `cid` int(11) unsigned DEFAULT NULL,
  `uid` int(11) unsigned DEFAULT NULL,
  `addtime` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`zlid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;-- 





INSERT INTO `cmseasy_announcement` VALUES('1','热烈庆祝本公司网站构建成立！','<p>热烈庆祝本公司网站构建成立！</p>','2010-07-07 07:07:07','1','1');-- 
INSERT INTO `cmseasy_announcement` VALUES('2','公告演示标题','<p>公告</p>','2019-07-23 20:16:55','1','1');-- 
INSERT INTO `cmseasy_announcement` VALUES('3','公告标题演示','<p>公告</p>','2019-07-23 20:17:17','1','1');-- 
INSERT INTO `cmseasy_announcement` VALUES('4','English bulletin information title','<p>English bulletin content information, more text can be added by oneself</p>','2019-08-17 02:24:39','1','2');-- 
INSERT INTO `cmseasy_announcement` VALUES('6','韓国語の公告のタイトルテキスト','<p>韓国語の公告内容のテキストデモンストレーション、韓国語の公告内容のテキストデモンストレーション</p>','2019-08-22 20:23:15','1','4');-- 
INSERT INTO `cmseasy_announcement` VALUES('5','日本語の掲示板','<p>日本語の公示デモの内容テキスト、日本語の公告デモの内容テキスト</p>','2019-08-22 20:06:18','1','3');-- 



INSERT INTO `cmseasy_archive` VALUES('9','12','0','CH-17 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:22:11','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要','0','<p>从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器</p><p>。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要比只查看数据包物理地址的交换机慢。但是，对于那些结构复杂的网络，使用路由器可以提高网络的整体效率。路由器的另外一个明显优势就是可以自动过滤网络广播。总体上说，在网络中添加路由器的整个安装过程要比即插即用的交换机复杂很多。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">有的路由器仅支持单一协议，但大部分路由器可以支持多种协议的传输，即多协议路由器。由于每一种协议都有自己的规则，要在一个路由器中完成多种协议的算法，势必会降低路由器的性能。路由器的主要工作就是为经过路由器的每个数据帧寻找一条最佳传输路径，并将该数据有效地传送到目的站点。由此可见，选择最佳路径的策略即路由算法是路由器的关键所在。为了完成这项工作，在路由器中保存着各种传输路径的相关数据－－路径表（Routing Table），供路由选择时使用。路径表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路径表可以是由系统管理员固定设置好的。</span><br/></p><p>静态路由表：由系统管理员事先设置好固定的路径表称之为静态（static）路径表。</p><p>动态路由表：动态（Dynamic）路径表是路由器根据网络系统的运行情况而自动调整的路径表。</p><p>路由器是一种多端口设备，它可以连接不同传输速率并运行于各种环境的局域网和广域网，也可以采用不同的协议。路由器属于O S I 模型的第三层--网络层。指导从一个网段到另一个网段的数据传输，也能指导从一种网络向另一种网络的数据传输。&nbsp;</p><p>第一，网络互连：路由器支持各种局域网和广域网接口，主要用于互连局域网和广域网，实现不同网络互相通信；<br/>　　第二，数据处理：提供包括分组过滤、分组转发、优先级、复用、加密、压缩和防火墙等功能；<br/>　　第三，网络管理：路由器提供包括路由器配置管理、性能管理、容错管理和流量控制等功能。<br/>　　所谓“路由”，是指把数据从一个地方传送到另一个地方的行为和动作，而路由器，正是执行这种行为动作的机器，它的英文名称为Router,是一种连接多个网络或网段的网络设备，它能将不同网络或网段之间的数据信息进行“翻译”，以使它们能够相互“读懂”对方的数据，从而构成一个更大的网络。<br/>　　为了完成“路由”的工作，在路由器中保存着各种传输路径的相关数据－－路由表（Routing Table），供路由选择时使用。路由表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路由表可以是由系统管理员固定设置好的，也可以由系统动态修改，可以由路由器自动调整，也可以由主机控制。在路由器中涉及到两个有关地址的名字概念，那就是：静态路由表和动态路由表。由系统管理员事先设置好固定的路由表称之为静态（static）路由表，一般是在系统安装时就根据网络的配置情况预先设定的，它不会随未来网络结构的改变而改变。动态（Dynamic）路由表是路由器根据网络系统的运行情况而自动调整的路由表。路由器根据路由选择协议（Routing Protocol）提供的功能，自动学习和记忆网络运行情况，在需要时自动计算数据传输的最佳路径。</p><p><br/></p><p><br/></p>','0','0','0','','0','0','','','998','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYwYXTmVmdpkOSDhl727','1','2020-01-16 22:22:11','','my_shopping_model,my_shopping_color','0','1','585','','0.00','0.00','','{}','1:300M,+,5,2:450M,+,10,3:500M,+,15,4:600M,+,20,5:700M,+,25,6:800M,+,30,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('8','12','0','CH-18 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:30:10','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS','0','<p>路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。&nbsp;</p><p>同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS可以使我们在路由器的FLASH中不存在ISO时，先引导起来，进入恢复模式，来使用TFTP或X-MODEM等方式去给FLASH中导入ISO文件。所以，路由器的启动过程应该是这样的：</p><p>路由器在加电后首先会进行POST。Power On Self Test (上电自检，对硬件进行检测的过程)。</p><p>POST完成后，首先读取ROM里的BootStrap程序进行初步引导。</p><p>初步引导完成后，尝试定位并读取完整的ISO镜像文件。在这里，路由器将会首先在FLASH中查找ISO文件，如果找到了ISO文件的话，那么读取ISO文件，引导路由器。</p><p>如果在FLASH中没有找到ISO文件的话，那么路由器将会进入BOOT模式，在BOOT模式下可以使用TFTP上的ISO文件。或者使用TFTP/X-MODEM来给路由器的FLASH中传一个ISO文件(一般我们把这个过程叫做灌ISO)。传输完毕后重新启动路由器，路由器就可以正常启动到CLI模式。</p><p>当路由器初始化完成ISO文件后，就会开始在NVRAM中查找STARTUP-CONFIG文件，STARTUP-CONFIG叫做启动配置文件。该文件里保存了我们对路由器所做的所有的配置和修改。当路由器找到了这个文件后，路由器就会加载该文件里的所有配置，并且根据配置来学习、生成、维护路由表，并将所有的配置加载到RAM(路由器的内存)里后，进入用户模式，最终完成启动过程。</p><p>如果在NVRAM里没有STARTUP-CONFIG文件，则路由器会进入询问配置模式，也就是俗称的问答配置模式，在该模式下所有关于路由器的配置都可以以问答的形式进行配置。不过一般情况下我们基本上是不用这样的模式的。我们一般都会进入CLI&nbsp;[1]&nbsp;&nbsp;(Comman Line Interface)命令行模式后对路由器进行配置。</p><p><br/></p><p>工作原理示例</p><p>（1）工作站A将工作站B的地址12.0.0.5连同数据信息以数据包的形式发送给路由器1。</p><p>（2）路由器1收到工作站A的数据包后，先从包头中取出地址12.0.0.5，并根据路径表计算出发往工作站B的最佳路径：R1-&gt;R2-&gt;R5-&gt;B；并将数据包发往路由器2。</p><p>（3）路由器2重复路由器1的工作，并将数据包转发给路由器5。</p><p>（4）路由器5同样取出目的地址，发现12.0.0.5就在该路由器所连接的网段上，于是将该数据包直接交给工作站B。</p><p>（5）工作站B收到工作站A的数据包，一次通信过程宣告结束。</p><p><br/></p>','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9nOCjsT6XTOiGFs105','1','2020-01-16 22:30:10','','my_shopping_model,my_shopping_color','0','1','88','','0.00','0.00','','{}','1:100M,+,5,2:150M,+,10,3:200M,+,15,','1:蓝,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('7','12','0','CH-19 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:28:57','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，交通警察。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即','0','<p>路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，&quot;交通警察&quot;。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即网络层。这一区别决定了路由和交换机在移动信息的过程中需使用不同的控制信息，所以说两者实现各自功能的方式是不同的。</p><p>路由器（Router）又称网关设备（Gateway）是用于连接多个逻辑上分开的网络，所谓逻辑网络是代表一个单独的网络或者一个子网。当数据从一个子网传输到另一个子网时，可通过路由器的路由功能来完成。因此，路由器具有判断网络地址和选择IP路径的功能，它能在多网络互联环境中，建立灵活的连接，可用完全不同的数据分组和介质访问方法连接各种子网，路由器只接受源站或其他路由器的信息，属网络层的一种互联设备。</p><p>路由器分本地路由器和远程路由器，本地路由器是用来连接网络传输介质的，如光纤、同轴电缆、双绞线；远程路由器是用来连接远程传输介质，并要求相应的设</p><p>模拟器中的路由器&nbsp;</p><p>备，如电话线要配调制解调器，无线要通过无线接收机、发射机。</p><p>路由器是互联网的主要结点设备。路由器通过路由决定数据的转发。转发策略称为路由选择（routing），这也是路由器名称的由来（router，转发者）。作为不同网络之间互相连接的枢纽，路由器系统构成了基于TCP/IP 的国际互联网络Internet&nbsp;的主体脉络，也可以说，路由器构成了Internet的骨架。它的处理速度是网络通信的主要瓶颈之一，它的可靠性则直接影响着网络互连的质量。因此，在园区网、地区网、乃至整个Internet研究领域中，路由器技术始终处于核心地位，其发展历程和方向，成为整个Internet研究的一个缩影。在当前我国网络基础建设和信息建设方兴未艾之际，探讨路由器在互连网络中的作用、地位及其发展方向，对于国内的网络技术研究、网络建设，以及明确网络市场上对于路由器和网络互连的各种似是而非的概念，都有重要的意义。</p><p>出现了交换路由器产品，从本质上来说它不是什么新技术，而是为了提高通信能力，把交换机的原理组合到路由器中，使数据传输能力更快、更好。</p><p><br/></p>','0','0','0','','0','0','','','280','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhC2dWvXrEcx0C74295','1','2020-01-16 22:28:57','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','{}','1:500M,+,100,2:1000M,+,200,','1:黑,+,0,2:白,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('10','12','0','U-ART气动式高音','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:20:32','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','音响特指电器设备组合发出声音的一套音频系统音响系统大体包含：1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭','0','<p>音响特指电器设备组合发出声音的一套音频系统</p><p>音响系统大体包含：</p><p>1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）</p><p>2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）</p><p>3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）&nbsp;</p><p>4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭、低音炮等等）。技术的的发展历史可以分为电子管、晶体管、集成电路、场效应管四个阶段。</p><p><br/></p><p>音响是一个简化后的日常词语，是音响系统的简称。即代指一整套可以还原播放音频信号的设备。</p><p>随着社会的进步，人们向往生活更多姿多彩。歌舞作为一种流传数千年的娱乐形式，深入各族人民的生活。但是随着科技的发展和进步，人们对于歌舞的表演形式和场地要求越来越多、越来越高。音响系统随着人们的需求不断改进和完善。大到满足上万人演唱会现场扩声需求，小到满足个人家庭弹奏乐器、K歌的需要。</p><p><br/></p>','0','0','0','','0','0','','','1600','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHX6gF0nEoJyFagO648','1','2020-01-16 22:20:32','','my_shopping_model,my_shopping_color','0','1','88','','0.00','0.00','','{}','1:高音,+,0,2:中音,+,0,3:普音,+,0,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('11','12','0','电热水壶','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:06:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随','0','<p>电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。</p><p>电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随着生活的需要，现在的电水壶也正在向多功能方向发展，如防漏、防烫、锁水等。电水壶具有加热速度快，保温效果好，过滤功能强，式样多等优点。</p><p>电热水壶的使用功能虽然基本相同，但从内在电路结构设计可以分为鸣笛式电水壶、防干烧鸣笛电水壶、塑胶电热水壶等几大类。</p><p>（1）鸣笛式电热水壶。</p><p>由铝制板经拉伸制成，电热元件采用浸水式镀镍钢密封式电热管。电热管安装在水壶底部，和壶体结合部垫有耐热密封圈以防止漏水。该类型电热水壶壶盖上设置有一个条状振动簧片自鸣器（气流振动式鸣笛装置），当水温达到100℃以上时气流鸣笛即会鸣响。由于该类水壶一般没有设置限温控制器，必须人为地手动切断电源。该类电热水壶结构简单、价格低廉，居民家庭中使用相当广泛。</p><p>（2）防干烧鸣笛式电热水壶。&nbsp;</p><p>在鸣笛式电水壶设计原理基础上，增设了限温自动控制器（主要是双金属恒温控制器或者磁控恒温自动开关），当水沸腾时，产生的水蒸气使感温元件的双金属片变形，驱动微型开关切断电源，极大地提高了电热水壶的安全性能。一些高品质的电热水壶中的限温控制器采用一种类似记忆合金的新型热敏材料（自动恒温控制开关），当壶内水面低于电热管（电热管温度超过100℃以上）时，自动恒温控制开关便会自动切断电源，保护电热水壶不被烧毁。</p><p>（3）塑胶型电热水壶。</p><p>塑胶型电热水壶最大的特点是携带方便、安全性能可靠。壶体设置的电源信号指示灯可方便观察通电状态，上下分体式结构可以3600旋转，壶体采用的食品级卫生塑质材料熔点在200℃以上。这种新型电热水壶采用隐藏式不锈钢电发热盘，并设置有蒸汽感应控制开关，具有自动断电、防干烧断电、热熔断电保护、接地保护等多重保护功能。&nbsp;</p><p><br/></p>','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYof911iYjQMp1JA5768','1','2020-01-16 22:06:48','','my_shop_model,my_shoppingcolor','5','1','88','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东\",\"buyurls\":\"https://www.jd.com\"}}','1:电子,+,10,2:机械,+,5,','1:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('12','12','0','智能吸顶灯','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:21:38','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目','0','<p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。</p><p>目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。</p><p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的就是led吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。&nbsp;&nbsp;</p><p>它起源于1995年-1996年间，由于形似太阳，因此当时行业人士称之为“太阳灯”， 2000年前的吸顶灯款式单一、材料单一，大多采用中低档材料，光源一般采用节能灯管和灯泡，并以电感吸顶灯为主。</p><p>LED吸顶灯是吸附或嵌入屋顶天花板上的灯饰，它和吊灯一样，也是室内的主体照明设备，是家庭、办公室、娱乐场所等各种场所经常选用的灯具。LED吸顶灯一</p><p><br/></p><p>般直径在200mm左右的吸顶灯适宜在走道、浴室内使用，而直径400mm的则装在不小于16平方米的房间顶部为宜。 市面上的LED吸顶灯常见有D形管和环形管两种还有大小管区别。选购LED吸顶灯时要三看。一看产品标识是否齐全，正规产品的标识往往比较规范，应标识：商标和厂名、产品型号规格、额定电压、额定频率、额定功率。二看灯具电源线是否有CCC安全认证标志，外部导线截面积应≥0.75平方毫米。三看灯具带电体是否外露，光源装入灯座后，手指应不能触及带电的金属灯头。</p><p>1)功能细分。吸顶灯传统的照明功能已不够满足消费者，将客厅吸顶灯与日常用品相组合也日趋流行。</p><p>2)造型豪华。随着生活的日益富足，消费者审美需求增加，客厅吸顶灯日趋豪华、高档。</p><p>3)崇尚自然。为迎合都市消费者返朴归真、崇尚自然的心理，很多吸顶灯采用了自然化的造型。另外，灯罩的选材也广泛采用纸质、木质、纱质等自然材质。</p><p>4)色彩丰富。为与丰富多彩的生活同步，现如今很多吸顶灯披起了“七彩”外衣。&nbsp;</p><p>5)高技术化。随着科学技术的发展，电子科技被广泛应用于客厅吸顶灯设计，如适应不同电压的吸顶灯，可调节亮度的吸顶灯，放射远的红外红光吸顶灯等等。</p><p>6)节能化。目前节能吸顶灯很受消费者欢迎，如采用3LED芯电的长寿节能灯，既节约能源，又可以根据需要选择亮度。</p><p>7)环保化。环保是吸顶灯设计不变的话题，这与我们栖息的地球有关，已经引起广大消费者重视，这将会成为未来家居照明的主要发展方向。</p><p><br/></p>','0','0','0','','0','0','','','13','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9WBOPjG6dQeIfDn585','1','2020-01-17 09:21:38','','my_shopping_model,my_shopping_color','0','1','0','','0.00','0.00','','{}','1:节能,+,0,2:普通,+,0,','1:黑,+,5,2:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('13','12','0','智能加湿器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:15:29','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿','0','<p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。&nbsp;<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。&nbsp;</p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p><br/></p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','460','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1V2E0Sx8DFX8ODz935','1','2020-01-16 22:15:29','','my_shopping_model,my_shopping_color','0','1','0','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/729828.html\"},\"1\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.26.1c04a98aZGJnlP&id=605208384141&skuId=4245337065638&user_id=3919645743&cat_id=2&is_b=1&rn=73570d905a6017c54c1e28ca58978061\"}}','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('14','12','0','智能洗衣机','','','admin','1','13','','0','0','','1','','','','','0','2020-01-16 22:12:24','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超','0','<p>洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。</p><p>中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。&nbsp;&nbsp;</p><p>从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超过了96%，农村市场也已经超过了53%;随着国家开展家电下乡、扩大内需的政策，洗衣机企业将目光均投向了拥有较大消费潜力的农村市场。未来几年，我国洗衣机市场需求增长空间将主要来自于：以城镇化和农村市场为主的首次需求，以及以城镇市场消费升级为主的更新需求;整个洗衣机市场需求在未来几年将继续保持温和增长态势。</p><p>2010年，我国洗衣机总销量约5000多万台，同比增长接近30%，增长幅度创历史最高水平;其中内销实现3300多万台，同比增长约28%，出口实现1600多万台，同比增长30%以上，均创历史最高增长速度。</p><p>从不同产品来看，2010年我国滚筒洗衣机总销量达到1100多万台，同比增长50%以上，占洗衣机市场销量比重由上年的不足20%上升至20%以上。其中，第四季度各月销量均超过110万台，所占洗衣机市场总销量的份额均超过21%。</p><p>节水将成未来洗衣机重点发展方向，洗衣机产业目标主要涵盖节电节水、产品功能、绿色设计三大方向。在中国家用电器协会编制的冰箱、空调、洗衣机的技术路线图中，就节电节水方面，制定了到 2015年，波轮式双桶洗衣机达到国家能效2级，波轮式全自动洗衣机达到国家能效1级，能效1级的滚筒式全自动洗衣机要达到欧盟A+等级耗电、耗水要求， 滚筒式洗干一体机要达到GB/T23118国标A级耗电、耗水要求。到2020年，滚筒洗衣机达到欧盟A+++等级耗电、耗水要求，波轮式全自动洗衣机达到国标A+等级耗电、耗水要求，滚筒式洗干一体机达到国标A+等级耗电、耗水要求。在产品功能方面，洗衣机的发展方向是大容量，低噪声、低振动。</p><p><br/></p><p>机械力、洗涤液、水是洗衣机洗涤过程中的三要素。洗衣机运动部件产生的机械力和洗涤液的作用使污垢与衣物纤维脱离。加热洗涤液，可增强去污效果。织物不同，适宜液温也不同，反映洗衣机洗涤性能（即洗净衣物的能力）的主要指标是洗净率（或洗净比）和织物磨损率。洗净率是洗衣机在额定洗涤状态下，利用光电反射率计（或白度仪）测定洗涤前后人工污染布及其原布的反射率。洗衣机发展史　从古到今，洗衣服都是一项难于逃避的家务劳动，而在洗衣机出现以前，对于许多人而言，它并不像田园诗描绘的那样充满乐趣，手搓、棒击、冲刷、甩打…这些不断重复的简单的体力劳动，留给人的感受常常是：辛苦劳累。&nbsp;</p><p>1858年，一个叫汉密尔顿·史密斯的美国人在匹茨堡制成了世界上第一台洗衣机，该洗衣机的主件是一只圆桶，桶内装有一根带有桨状叶子的直轴，轴是通过摇动和它相连的曲柄转动的。同年史密斯取得了这台洗衣机的专利权。但这台洗衣机使用费力，且损伤衣服，因而没被广泛使用，但这却标志了用机器洗衣的开端。次年在德国出现了一种用捣衣杵作为搅拌器的洗衣机，当捣衣杵上下运动时，装有弹簧的木钉便连续作用于衣服。19世纪末期的洗衣机已发展到一只用手柄转动的八角形洗衣缸，洗衣时缸内放入热肥皂水，衣服洗净后，由轧液装置把衣服挤干。</p><p>1874年，“手洗时代”受到了前所未有的挑战，美国人比尔·布莱克斯发明了木制手摇洗衣机。布莱克斯的洗衣机构造极为简单，是在木筒里装上6块叶片，用手柄和齿轮传动，使衣服在筒内翻转，从而达到“净衣”的目的。这套装置的问世，让那些为提高生活效率而冥思苦想的人士大受启发，洗衣机的改进过程开始大大加快.</p><p>1880年，美国又出现了蒸气洗衣机，蒸气动力开始取代人力。经历了上百年的发展改进，现代蒸汽洗衣机较早期有了无与伦与的提高，但原理是相同的。现代蒸汽洗衣机的功能包括蒸汽洗涤和蒸汽烘干，采用了智能水循环系统，可将高浓度洗涤液与高温蒸气同时对衣物进行双重喷淋，贯穿全部洗涤过程，实现了全球独创性的“蒸汽洗”全新洗涤方式。与普通滚筒洗衣机在洗涤时需要加热整个滚筒的水不同，蒸汽洗涤是以深层清洁衣物为目的，当少量的水进入蒸汽发生盒并转化为蒸汽后，通过高温喷射分解衣物污渍。蒸汽洗涤快速、彻底，只需要少量的水，同时可节约时间。对于放在衣柜很长时间产生褶皱、异味的冬季衣物，能让其自然舒展，抚平褶皱。“蒸汽烘干”的工作原理则是把恒定的蒸汽喷洒在衣物上，将衣物舒展开之后，再进行恒温冷凝式烘干。通过这种方式，厚重衣物不仅干得更快，并且具有舒展和熨烫的效果。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYITUdOO4dafAhtdr232','1','2020-01-16 22:12:24','','my_shopping_model,my_shopping_color','5','1','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/100004652001.html\"}}','1:智能,+,10,2:机械,+,5,3:全自动,+,15,','1:白,+,10,2:黑,+,5,','');-- 
INSERT INTO `cmseasy_archive` VALUES('15','19','0','国际海上运输','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:22:38','admin','','/html/upload/images/201907/15590101902500.jpg','1','1','国际海上货物运输是指承运人按照海上货物运输合同的约定，以海运船舶作为运载工具，以收取运费作为报酬，将托运人托运的货物经海路由一国港口运送至另一国港口的行为。国际海运（International Ocean Freight）是国际贸易中最主要的运输方式，国际贸易总运量中的三分之二以上，我国绝大部分进出口货物，都是通过海洋运输方式运输的。当中国海运业在世界海运中占据一席之地时，它的优、劣势也在全球化竞','0','<p>国际海上货物运输是指承运人按照海上货物运输合同的约定，以海运船舶作为运载工具，以收取运费作为报酬，将托运人托运的货物经海路由一国港口运送至另一国港口的行为。</p><p>国际海运（International Ocean Freight）是国际贸易中最主要的运输方式，国际贸易总运量中的三分之二以上，我国绝大部分进出口货物，都是通过海洋运输方式运输的。</p><p>当中国海运业在世界海运中占据一席之地时，它的优、劣势也在全球化竞争洪流中暴露无遗，而这正是中国港航企业发展模式进行战略性转变需正视和重视的现实。我国海运业在世界海运发展中的优势</p><p>根据国际货币基金组织预测，2006年国际经济走势仍将保持平稳增长，美国和全球将分别有3.6%和4.3%的增长率，而我国GDP增长速度也将保持在8.5%以上。<br/></p><p>经济强势带动了世界贸易量的上升。2003年国际贸易总值为15.35万亿美元，而2004年就上升到18.58万亿美元，提高了21%。2005年达21.1462万亿美元。在国际贸易中，“中国因素”是最大亮点。2004年我国进出口、出口和进口值分别为11547.4亿美元、5933.6亿美元和5613.8亿美元，分别增长了35.7%、35.4%和36%，进出口总值首次超过了1万亿美元的水平。2005年货物进出口贸易额达到14221亿美元，进口和出口值均占世界第三位。另外，中国占世界贸易的比重有所上升，出口比重由2004年的6.5%上升到7.3%，增加了0.8个百分点；进口比重由5.9%上升到6.1%，增加0.2个百分点。我国进出口外贸呈现良好的增长势头，在国际贸易中继续扮演着重要角色。</p><p>国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。由于全球经济发展对于大宗基础原材料需求很大，像铁矿石、煤炭等运量增长很快，而其中中国作为全球经济发展最快的国家之一，起了非常大的作用。近10年我国大宗干散货海运量年均增长率为17%，大大高于国际市场水平，而世界干散货航运市场70%的增量来自于中国。以铁矿石为例，2003年我国进口量达到1.48亿吨，占全球海运量的28.5%。2004年全球铁矿石海运量为6亿吨，我国进口了2.08亿吨，占34.6%。2005年受国家调控影响，增长速度有所下降，但仍有新增需求6000万吨，全年进口量达到2.48亿吨，增长率为20%左右。可以预计，在中国这个巨大引擎的带动下，国际干散货航运市场2006年仍将保持持续增长，年平均增长率将达到6%。</p><p>石油运输方面，世界经济对于石油依存度很高。据专家计算，全球经济每增长1%，将每天需要40万桶石油的支持。而作为石油运输的主要方式，水路运输完成了92%的油品贸易。2003年全球原油海运量为16亿吨，2004年进一步提高，预计2005-2007年国际原油海运量平均增长速度为3%左右。我国近几年石油需求大幅上升，2004年已经成为世界第二大石油消费国和进口国。2003年我国进口原油9112万吨，占全球原油贸易量的5.4%，2004年进口原油1.22亿吨，首次突破了1亿吨大关。2005年原油消费量超过3亿吨，供需缺口将进一步拉大，2005年原油进口量达到1.27亿吨。预计未来几年我国对于石油的需求将保持较高速度增长，对于国际石油海运将起到越来越大的影响。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRPI6bOuaP6K4Q7v182','1','2019-05-28 10:22:38','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('16','18','0','国内海上运输','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:25:13','admin','','/html/upload/images/201907/15590103415339.jpg','1','1','国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。','0','<p>国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。由于全球经济发展对于大宗基础原材料需求很大，像铁矿石、煤炭等运量增长很快，而其中中国作为全球经济发展最快的国家之一，起了非常大的作用。近10年我国大宗干散货海运量年均增长率为17%，大大高于国际市场水平，而世界干散货航运市场70%的增量来自于中国。以铁矿石为例，2003年我国进口量达到1.48亿吨，占全球海运量的28.5%。2004年全球铁矿石海运量为6亿吨，我国进口了2.08亿吨，占34.6%。2005年受国家调控影响，增长速度有所下降，但仍有新增需求6000万吨，全年进口量达到2.48亿吨，增长率为20%左右。可以预计，在中国这个巨大引擎的带动下，国际干散货航运市场2006年仍将保持持续增长，年平均增长率将达到6%。</p><p>石油运输方面，世界经济对于石油依存度很高。据专家计算，全球经济每增长1%，将每天需要40万桶石油的支持。而作为石油运输的主要方式，水路运输完成了92%的油品贸易。2003年全球原油海运量为16亿吨，2004年进一步提高，预计2005-2007年国际原油海运量平均增长速度为3%左右。我国近几年石油需求大幅上升，2004年已经成为世界第二大石油消费国和进口国。2003年我国进口原油9112万吨，占全球原油贸易量的5.4%，2004年进口原油1.22亿吨，首次突破了1亿吨大关。2005年原油消费量超过3亿吨，供需缺口将进一步拉大，2005年原油进口量达到1.27亿吨。预计未来几年我国对于石油的需求将保持较高速度增长，对于国际石油海运将起到越来越大的影响。</p><p>集装箱运输方面，在太平洋航线和亚欧航线的带动下，从2002年开始集装箱贸易量有了快速增长。2003年国际集装箱贸易总量为7900万TEU，同比增长8.2%，2004年增长幅度上升到11%，为8770万TEU。2005年太平洋航线运量将上升12%，亚欧航线增长15%，而大西洋航线保持稳定，增幅不大，2005年整体集装箱运量将在原有基础上提高10%左右。我国集装箱海运量占世界总量的20%左右，在太平洋东行航线和亚欧西行航线上更是占有60%以上的运量。我国2005年集装箱吞吐量达到7580万TEU，增长率达到23.7%，高于世界平均水平。</p><p>从船队建设看</p><p>全球1000总吨以上干散货船5700艘，共29634.8万载重吨，分布在数百个船公司。中国船公司拥有579艘，2440.5万载重吨；香港地区船公司拥有261艘，1819万载重吨。中国和香港地区共有运力4259.6万载重吨，占世界14.4%。我国从事国际航运的船公司已达231家，总运力达到2210多万载重吨，居世界第九位。我国航运企业在国外设立的独资、合资航运企业和办事机构已达数百家，承运的第三国货物比重日益提高。。</p><p>在国际海运中运输的货物，种类繁多，针对不同类型的货物而采用运输货物的船舶类型、装卸设备也就不同。七海针对具体货物从船型、装卸设备两方面介绍如何运送超大件货物。</p><p>1． 卡车。卡车的运输采用PCTC（PURE CAR TRUCK CARRIER），其主要特点是采用单层甲板（一般高度在3－4米之间）舱内可以容纳大型卡车，其船舶尾跳最大载重量可达45吨，每平方米载重量可达3吨，因此可以允许超重卡车通过船舶尾跳进入船舱。</p><p>2． 大型设备。一般来讲，大型设备的运输比较复杂，有些部件体积较大，吨位较大，不能采用一般的集装箱运输，而有些零配件可采用集装箱运输。这种设备一般采用RORO AND CONTAINER 这种船型，可以同时装载大型部件和集装箱，因此是众多大型设备运输所选择的理想船型。</p><p>那么这种船型配备哪些装卸设备比较合理呢？</p><p>BOLSTER FLATBED 这种设备适用于长4米以内、重28吨以内的大型部件。由吊车将货物吊到平板上，起吊高度不超过一米，（可避免货物在起吊过程中因摆动、翻转所引起的货物损坏），然后用特制尼龙带（其刚性等同于钢丝绳，但相对于钢丝绳来说可大大减轻其对货物表面的磨损）或钢丝绳加垫片，将货物固定在平板上，由叉车通过船舶尾跳将货物运进船舱。</p><p>ROLLTRAILER 这种设备适用于运输超重、超大货物，理论上可以承载25米长、重达120吨的货物，但由于受到尾跳承载能力与拖头的运输能力的限制，实际的承载能力会偏小一些。ROLLTRAILER由自代拖头通过船舶尾跳运进舱内，可以实现货物的零破损。</p><p>3． 火车车厢。由于火车车箱较长，有40米长所以采用一般的ROLLTRAILER运输会由于舱口的限制，车身无法旋转装进舱内。SPECIALDESIGNED TRAILERS（特殊轮胎转向架）可以解决这个问题，该设备轮胎可以实现360度旋转，可通过船舶尾跳进舱时掉头运进舱内。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJ0PSRBqIjOIqxyh942','1','2019-05-28 10:25:13','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('17','18','0','国际航空运输','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:28:37','admin','','/html/upload/images/201907/15590105447904.jpg','1','1','航空运输是指使用飞机、直升机及其他航空器运送人员、货物、邮件的一种运输方式。旅客、行李、货物和邮件的始发、中途和终点站 有一点在一国境外的航空运输。主要在国际航线上 进行。国际航线是通过政府间的双边航空运输协定 建立的。在运输过程中为保证国际航行的安全和效 益，必须按统一的程序和规则进行广泛的国际合作 和协调。国际民用航空组织和地区性民用航空组织 在国际航空运输中发挥了重要作用。中国的国际航 空运','0','<p>航空运输是指使用飞机、直升机及其他航空器运送人员、货物、邮件的一种运输方式。旅客、行李、货物和邮件的始发、中途和终点站 有一点在一国境外的航空运输。主要在国际航线上 进行。国际航线是通过政府间的双边航空运输协定 建立的。在运输过程中为保证国际航行的安全和效 益，必须按统一的程序和规则进行广泛的国际合作 和协调。国际民用航空组织和地区性民用航空组织 在国际航空运输中发挥了重要作用。中国的国际航 空运输始于1950年7&#39;月，当时和前苏联合办的中苏 民用航空公司开辟了北京为始发点到前苏联赤塔、 伊尔库茨克和阿拉木图三条国际航线。&nbsp;</p><p>航空运输始于1871年。当时普法战争中的法国人用气球把政府官员和物资、邮件等运出被普军围困的巴黎。1918年5月5日，飞机运输首次出现，航线为纽约-华盛顿-芝加哥。同年6月8日，伦敦与巴黎之间开始定期邮政航班飞行。30年代有了民用运输机，各种技术性能不断改进，航空工业的发展促进航空运输的发展。第二次世界大战结束后，在世界范围内逐渐建立了航线网，以各国主要城市为起讫点的世界航线网遍及各大洲。1990年，世界定期航班完成总周转量达2356.7亿吨千米。</p><p>1．托运人托运货物应向承运人填交货物运输单，并根据国家主管部门规定随附必要的有效证明文件。托运人应对运输单填写内容的真实性和正确性负责。托运人填交的货物运输单经承运人接受，并由承运人填发货物运输单后，航空货物运输合同即告成立。</p><p>2．托运人要求包用飞机运输货物，应填交包机申请书，经承运人同意接受并签订包机运输协议书以后，航空包机货物运输合同即告成立，签订协议书的当个人，均应遵守民航主管机关有关包机运输的规定。</p><p>3．托运人对运输的货物，应当按照国家主管部门规定的包装标准包装；没有统一规定包装标准的，托运人应当根据保证运输安全的原则，按货物的性质和承载飞机等条件包装。凡不符合上述包装要求的，承运人有权拒绝承运不符合规格的货物。</p><p>4．托运人必须在托运的货物上标明发站、到站和托运人、收货人的单位。姓名和地址，按照国家规定标明包装储运指标标志。</p><p>5．国家规定必须保险的货物，托运人应在托运时投保货物运输险。</p><p>6．托运人托运货物，应按照民航主管机关规定的费率缴付运费和其他费用。除托运人和承运人另有协议外，运费及其他费用一律于承运入开具货物运单时一次付清。</p><p>7．承运人应于货物运达到货地点后二十四小时内向收货人发出到货通知、收货人应及时凭提货证明到指定地点提取货物，货物从发出到货通知的次日起，免费保管三月。收货人逾期提取，应按运输规则缴讨保管费。</p><p>8．收货人在提取货物时，对货物半途而废或重量无异议，并在货物运输单上签收，承运人即解除运输责任。</p><p>9．因承运入的过失或故意造成托运人或收货人损失，托运人或收货人要求赔偿，应在填写货物运输事故记录的次日起一百八十日内，以书面形式向承运人提出，并附有关证明文件。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJPOyTpq0T4pOqGr804','1','2019-05-28 10:28:37','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('18','17','0','国内航空运输','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:29:49','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地面导航设施建立的走廊式保护空域，是飞机航线飞行的领域。其划定是以连接各个地面导航设施的直线为中心线，在航路范围内规定上限高度、下限高度和宽度。对在其范围内飞行的飞机，要实施空中交通管制。航空港是民用飞机场及有关服务设施构成的整体，是飞机安全起降的基地，也是旅客、货物、邮件的集散地。飞机是主要载运工具。机型选用','0','<p>技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地面导航设施建立的走廊式保护空域，是飞机航线飞行的领域。其划定是以连接各个地面导航设施的直线为中心线，在航路范围内规定上限高度、下限高度和宽度。对在其范围内飞行的飞机，要实施空中交通管制。航空港是民用飞机场及有关服务设施构成的整体，是飞机安全起降的基地，也是旅客、货物、邮件的集散地。飞机是主要载运工具。机型选用根据所飞航线的具体情况和考虑整体经济技术性能而定。通信导航设施是沟通信息、引导飞机安全飞行并到达目的地安全着陆（见航空领航）的设施。</p><p>基于航空运输对发展国民经济和促进国际交往的重要意义，多数国家都很重视发展航空运输事业。政府设立专门机构进行管理，如中国设立民用航空总局，美国设联邦航空局，前苏联设民用航空部等；实行多种优惠政策支持航空运输企业的发展，如政府直接投资、贷款、减免捐税、给予财政补贴等。</p><p>航空运输企业经营的形式主要有班期运输、包机运输和专机运输。通常以班期运输为主，后两种是按需要临时安排。班期运输是按班期时刻表，以固定的机型沿固定航线、按固定时间执行运输任务。当待运客货量较多时，还可组织沿班期运输航线的加班飞行。航空运输的经营质量主要从安全水平、经济效益和服务质量3方面予以评价。<br/></p><p>航空运输始于1871年。当时普法战争中的法国人用气球把政府官员和物资、邮件等运出被普军围困的巴黎。1918年5月5日，飞机运输首次出现，航线为纽约-华盛顿-芝加哥。同年6月8日，伦敦与巴黎之间开始定期邮政航班飞行。30年代有了民用运输机，各种技术性能不断改进，航空工业的发展促进航空运输的发展。第二次世界大战结束后，在世界范围内逐渐建立了航线网，以各国主要城市为起讫点的世界航线网遍及各大洲。1990年，世界定期航班完成总周转量达2356.7亿吨千米。<br/></p><p>货物重量按毛重计算。计算单位为公斤。重量不足1公斤，按1公斤算，超过1公斤的尾数四舍五入。<br/></p><p>非宽体飞机装载的每件货物重量一般不超过80公斤，体积一般不超过40*60*100米。宽体飞机装载每件货物重量一般不超过250公斤。体积一般不超过250*200*160厘米。超过以上重量和体积的货物，由西北公司依据具体条件确定可否收运。<br/></p><p>每件货物的长、宽、高之和不得少于40厘米．<br/></p><p>每公斤的体积超过6000立方厘米的货物按轻泡货物计重。轻泡货物以每6000立方厘米折合1公斤计量。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQtzTbjowanLdwNF405','1','2019-05-28 10:29:49','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('19','17','0','国际陆运','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:20','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','运输是指用特定的设备和工具，将物品从一个地点向另一个地点运送的物流活动，它是在不同地域范围内，以改变物的空间位置为目的对物进行的空间位移。通过这种位移创造商品的空间效益，实现其使用价值,满足社会的不同需要。运输是物流的中心环节之一，也是现代物流活动最重要的一个功能。运输是一个汉语词汇，意思是yùn shū，意思是用交通工具把物资运到另一地方，是实现人和物空间位置变化的活动。物流的运输则专指“物”的','0','<p>运输是指用特定的设备和工具，将物品从一个地点向另一个地点运送的物流活动，它是在不同地域范围内，以改变物的空间位置为目的对物进行的空间位移。通过这种位移创造商品的空间效益，实现其使用价值,满足社会的不同需要。运输是物流的中心环节之一，也是现代物流活动最重要的一个功能。&nbsp;</p><p>运输是一个汉语词汇，意思是yùn shū，意思是用交通工具把物资运到另一地方，是实现人和物空间位置变化的活动。</p><p>物流的运输则专指“物”的载运及输送。它是在不同地域范围间（如两个城市.两个工厂之间，或一大企业内相距较远的两车之间），以改变“物”的空间位置为目的的活动，是对“物”进行的空间位移。</p><p>运输一般分为运输和配送。关于运输和配送的区分，有许多不同的观点，可以这样来说，所有物品的移动都是运输，而配送则专指短距离、小批量的运输。因此，可以说运输是指整体，配送则是指其中的一部分，而且配送的侧重点在于一个&#39;&#39;配&#39;&#39;字，它的主要意义也体现在&#39;&#39;配&#39;&#39;字上；而&#39;&#39;送&#39;&#39;是为最终实现资源配置的&#39;&#39;配&#39;&#39;而服务的。</p><p>运输功能要素。包括供应及销售物流中的车、船、飞机等方式的运输，生产物流中的管道、传送带等方式的运输。</p><p>运输是指把人.财.物由一个地方转移到另外一个地方的过程.运输又被认为是国民经济的根本．</p><p>运输的主要工具有自行车.板车.三轮车.摩托车.汽车.火车.飞机.轮船.宇宙飞船.火箭.等等</p><p>运输按服务对象不同分为客运和货运</p><p>公共运输,泛指所有收费提供交通服务的运输方式。</p><p>轿车托运:(轿车运输)是指将汽车做为商品出厂后,通过大型汽车运输工具,到达指定地方的运输方式&lt;/CN&gt;</p><p>运输运价的构成</p><p>发到基价，运行基价构成，货物运输杂费</p><p>零担货物年车运价=每吨运价×计费重量</p><p>整车货物每吨运价= 发到基价+运行基价×运价里程</p><p>集装箱货物每箱运价= 发到基价+运行基价×运价里程</p><p>货物运输有保值作用。也就是说，任何产品从生产出来到最终消费，都必须经过一段时间、一段距离，在这段时间和距离过程中，都要经过运输、保管、包装、装卸搬运等多环节、多次数的货物运输活动。在这个过程中，产品可能会淋雨受潮、水浸、生锈、破损、丢失等。货物运输的使命就是防止上述现象的发生，保证产品从生产者到消费者移动过程中的质量和数量，起到产品的保值作用，即保护产品的存在价值，使该产品在到达消费者时使用价值不变。</p><p><br/></p><p>搞好运输，能够节约自然资源、人力资源和能源，同时也能够节约费用。比如，集装箱化运输，可以简化商品包装，节省大量包装用纸和木材；实现机械化装卸作业，仓库保管自动化，能节省大量作业人员，大幅度降低人员开支。重视货物运输可节约费用的事例比比皆是。被称为&quot;中国货物运输管理觉醒第一人&quot;的海尔企业集团，加强运输管理，建设起现代化的国际自动化货物运输中心，一年时间将库存占压资金和采购资金，从15亿元降低到7亿元，节省了8亿元开支。<br/></p><p>货物运输可以克服时间间隔、距离间隔和人的间隔，这自然也是货物运输的实质。现代化的货物运输在缩短<br/></p><p>距离方面的例证不胜枚举。在北京可以买到世界各国的新鲜水果，全国各地的水果也常年不断；邮政部门改善了货物运输，使信件大大缩短了时间距离，全国快递两天内就到美国联邦快递，能做到隔天送达亚洲15个城市；日本的配送中心可以做到，上午10点前订货、当天送到。这种运输速度，把人们之间的地理距离和时间距离一下子拉得很近。随着货物运输现代化的不断推进，国际运输能力大大加强，极大地促进了国际贸易，使人们逐渐感到这个地球变小了，各大洲的距离更近了。<br/></p><p>城市里的居民不知不觉地享受到货运进步的成果。南方产的香蕉全国各大城市一年四季都能买到；新疆的哈密瓜、宁夏的白兰瓜、东北大米、天津小站米等都不分季节地供应市场；则是国际运输业发达，国际运费降低的缘故。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYwWEC936lN5EomYR935','1','2019-05-28 10:30:20','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('20','17','0','国内陆运','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:47','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','一、运输具有生产的本质属性运输的生产过程是以一定的生产关系联系起来的、具有劳动技能的人们使用劳动工具（如车、船、飞机及其他设施）和劳动对象（货物和旅客）进行生产，并创造产品的生产过程。运输的产品，对旅客运输来说，是人的空间位移；对货物运输来说，是货物的空间位移。显然，运输是以改变“人和物”的空间位置为目的的生产活动，这一点和通常意义下以改变劳动对象物理、化学、生物属性为主的工农业生产不同。二、运输','0','<p>一、运输具有生产的本质属性</p><p>运输的生产过程是以一定的生产关系联系起来的、具有劳动技能的人们使用劳动工具（如车、船、飞机及其他设施）和劳动对象（货物和旅客）进行生产，并创造产品的生产过程。运输的产品，对旅客运输来说，是人的空间位移；对货物运输来说，是货物的空间位移。显然，运输是以改变“人和物”的空间位置为目的的生产活动，这一点和通常意义下以改变劳动对象物理、化学、生物属性为主的工农业生产不同。</p><p><br/></p><p>二、运输生产是在流通过程中完成的</p><p>运输是把产品从生产地运往消费地的活动，因此从整个社会生产过程来说，运输是在流通领域内继续的生产过程，并在其中完成。</p><p><br/></p><p>三、运输产品是无形的</p><p>运输生产不像工农业生产那样改变劳动对象的物理、化学性质和形态，而只改变劳动对象的空间位置，并不创造新的实物形态产品。因此，在满足社会运输需求的情况下，多余的运输产品或运输支出，都是一种浪费。</p><p><br/></p><p>四、运输产品属于边生产边消费</p><p>工农业产品的生产和消费在时间和空间上可以完全分离，而运输产品的生产和消费不论在时间和空间上都是不可分离地结合在一起的，属于边生产边消费。</p><p><br/></p><p>五、运输产品的非储存性</p><p>由于运输产品是无形的，不具有物质实体，又由于它的边生产边消费属性。因此运输产品既不能调拨，也不能存储。</p><p><br/></p><p>六、运输产品的同一性</p><p>对不同的运输方式来说，虽然他们使用不同的运输工具，具有不同的技术经济特征，在不同的线路上进行运输生产活动，但它们对社会具有相同的效用，即都实现了物品的空间位移。运输产品的同一性使得各种运输方式之间可以相互补充、协调、替代，形成一个有效的综合运输系统。</p><p><br/></p><p>1、运输是物流的主要功能要素之一</p><p>按物流的概念，物流是“物”的物理性运动，这种运动不但改变了物的时间状态，也改变了物的空间状态。而运输承担了改变空间状态的主要任务，运输是改变空间状态的主要手段，运输再配以搬运、配送等活动，就能圆满完成改变空间状态的全部任务。</p><p>2、运输是社会物质生产的必要条件之一</p><p>3、运输可以创造“场所效用”</p><p>场所效用的含义是：同种“物”由于空间场所不同，其使用价值的实现程度则不同，其效益的实现也不同。由于改变场所而最大发挥使用价值，最大限度提高了投入产出比，这就称之为“场所效用”。通过运输，将“物”运到场所效用最高的地方，就能发挥“物”的潜力，实现资源的优化配置。从这个意义来讲，也相当于通过运输提高了物的使用价值。</p><p>4、运输是“第三利润源”的主要源泉。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYlfHdT9Fr4Gubi5g482','1','2019-05-28 10:30:47','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('21','23','0','无人便利店风口正当时，“便利家”获联创永宣冯涛数百万元天使投资','','','admin','1','27','','0','0','','0','','','','','0','2020-01-16 23:39:17','admin','','/html/upload/images/201907/14360803742226.jpg','1','1','6氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、Easy Go等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。“便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。便利家的“微型无人便利店”，最小单位占地面积不到1平方','0','<p>6氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。</p><p>无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、E<a href=\"#\" target=\"_blank\">a</a>sy Go等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。&nbsp;</p><p>“便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。&nbsp;</p><p>便利家的“微型无人便利店”，最小单位占地面积不到1平方米（0.68平方米），投放地点更加灵活，包括地铁站、写字楼、高校等，一个最小单位便利店的成本约为1.3万元（批量化生产后可能更低）。最小单位的无人便利店，可以根据人流量的分布，“拼”起来更大单位面积的便利店。低于100人，可放置一个；100人左右，可以拼两个；大于500人，可以拼四个。便利家的“中型无人便利店”，是由6个微型便利店拼起来的，同时在空间里增设桌椅，为消费者提供休憩区间，可放置在地理位置相对开阔的小区、公园等。</p><p>技术上，便利家在每一层货架中设置了RFID，并在各个角落缝隙做了密封屏蔽，让识别率更高。流程很简单，用支付宝扫码开门，拿完即走，支付宝自动扣款（微信正在洽谈中）。未来，便利家希望在门把手上做掌纹识别，当消费者进行“拉开门”这个动作的时候，就能够进行识别。<br/></p><p>概念上，便利家其实更接近于售货机，创始人范韶伟认为，便利家是对传统售货机的一个改进。一方面，传统售货机的经营品类大多以饮料和固定包装零食为主，而便利家将以符合健康趋势的“鲜食类”为主；另一方面，传统售货机的出货流程是先付款、再出货，管道的陈列方式使得空间利用率低，如果是鲜食类商品，还有可能在掉下来的过程中发生变形。而便利家为先拿货、再扣款，可以叠放、密集排列，使得空间利用率更高。“同等面积下，我们的放货率比传统售货机多一倍。”</p><p>便利家的选品逻辑是，根据不同的场地，选择不同的商品，比如在写字楼满足白领的早午餐需求，提供便当、三明治、沙拉等等；在高校提供零食、卤味、面包等等。比照全家的平均客单价（14元），便利家将平均客单价设定在10元左右。此外，通过小程序，消费者可以反馈自己想吃的食物，根据数据反向指导品类的选择。<br/></p><p>微型、中型便利店之外，便利家还有第三个方面的业务——对于传统夫妻店的改造。线下夫妻店的特点在于大小不一、面积不一，便利家提供的无人便利店改造方案，一是夫妻店共享场地资源，进行销售分成；二是加盟方式，收益比例更高。一方面，小店店主不需要一天十几个小时守着门店，另一方面，在无人售卖之外，还可以延展其它的生意获得更多利润，比如奶茶、咖啡等。</p><p>“不管是无人零售还是有人零售，本质上还是零售的生意。”范韶伟说。既然是零售的生意，在网点的布局上，需要站在全局的角度，“最怕东一榔头、西一棒子。”</p><p>点、线、面的合理布局，才能最大程度的降低运营成本和物流成本。这其中需要考虑两个重要因素：人流量以及铺设点位的协同。便利家的思路是，在人流量密集的地方布一个中型无人便利店，再在周围100米的范围内，去布局10个微型无人便利店，形成“最小补货单元”， 1个人可以负责20台设备的补货。</p><p>至于RFID贴标签的成本问题，范韶伟持有乐观的态度，目前标签成本在0.5-0.6元，但随着RFID在零售市场的普及，RFID标签的价格一定会降低。</p><p>本轮融资后，便利家将在上海建立试运营点，中型+微型无人便利店，预期铺设20个网点。目前，便利家正在寻求Pre-A轮融资，用于扩大量产和投放运营。</p><p>团队方面，CEO范韶伟毕业于哈尔滨工业大学，曾任商派软件渠道部北部大区经理，是一位连续创业者。COO吴威为上海交通大学硕士，在快消品领域连续创业；CTO彭庚庚毕业于上海大学计算机工程专业，曾任腾讯OMG事业群广告平台部高级工程师。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYCJzxtWrGrENvlKX557','1','2020-01-16 23:39:17','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('22','23','0','500万美元领投AI创企ObEN，进一步布局社交AI','','','admin','1','41','','0','0','','0','','','','','0','2020-01-16 23:39:03','admin','','','1','1','除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。尤其是在社交领域，去年扎克伯格曾表示要推出VR版的Facebook，并展示了虚拟人物形象工具Oculus Avatars；今年7月，Facebook表示Facebook AR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也','0','<p>除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。</p><p>结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。</p><p>尤其是在社交领域，去年扎克伯格曾表示要推出VR版的F<a href=\"#\" target=\"_blank\">a</a>cebook，并展示了虚拟人物形象工具Oculus Avatars；今年7月，Facebook表示Facebook AR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也要有所行动了。</p><p>7月18日晚间，人工智能初创公司ObEN宣布获得500万美元战略投资。该轮融资由腾讯领投，CMC董事长黎瑞刚及峰尚资本跟投。投融资信息平台crunchbase的数据显示，目前ObEN共完成四轮融资，总金额达到1370万美元。此前的投资人还包括S如山资本、软银韩国风险投资公司和HTC VIVE X等。</p><p>公开资料介绍，ObEN创办于2014年，可以通过构建个性化的虚拟声音、形象和个性来创造用户的人工智能虚拟形象，并帮助用户在新兴的数字世界中存储、管理、运营他们的虚拟形象。也就是说，ObEN可以利用人工智能工具，根据用户的照片和声音创建虚拟形象，从而让用户有不同的AR、VR社交体验。</p><p>以前ObEN主要帮助游戏玩家创建虚拟形象，如今公司将重点转向于帮助明星打造虚拟形象。通过该虚拟形象，明星可以与粉丝进行实时互动。未来某一天，也许粉丝还可以向明星寻求建议并得到相应的反馈。另外，这一虚拟形象不仅与明星长的非常像，而且说话的方式也是一样的。总的来说，这样一个虚拟形象总好过于一个聊天机器人。</p><p>据介绍，ObEN还首次融合了语音、计算视觉以及自然语言处理技术，研发了全栈式虚拟明星所需要的虚拟声音、三维形象及个性化技术。如今ObEN正在打造一个全新的商业平台。在这里，明星和粉丝可以通过个性化的人工智能在移动端、增强现实、虚拟现实以及智能设备、物联网等平台上直接互动。ObEN的个性化的人工智能产品预计将在今年晚些时候发布。</p><p>而最新一轮融资，将被用于加速ObEN的产品开发，并帮助推动其明星人工智能版权平台广泛应用到各类数字平台上。对于这次合作，腾讯投资的执行董事姚磊文说道，ObEN将带来由明星人工智能驱动的全新娱乐方式和内容。</p><p>早前，ObEN就曾表示要做“每个人的人工智能社交平台”。在这方面，公司已经先后进行过多次布局。</p><p>在今年3月的HTC Vive生态圈大会上，ObEN宣布与HTC Vive合作，开发了一个让用户一起VR游玩、VR“K歌”的微信小程序。在这一程序中，VR用户可以向好友发送邀请；接到邀请的好友可以上传自拍和音频，最终使用建成的形象与邀请者一起漫步海滩，或者参观景点。</p><p>随后的4月底，ObEN推出了一个整合有VR社交体验的微信聊天服务短片，当然用户需要戴上HTC Vive头显。在短片中，用户需要先拍一张自拍，上传到微信制作虚拟形象，然后带上HTC Vive，就可以接收微信好友发来的信息，并可以用语音直接进行回复。未来，拥有VR、AR功能的微信或许又可以收割大量亚洲用户。</p><p>6月底，ObEN又宣布与韩国SM娱乐成立合资公司幻星有限公司（AI Stars）。据悉，ObEN要利用人工智能技术为SM娱乐旗下的知名艺人制作AI虚拟形象，而幻星有限公司正是管理这些”AI明星“的经纪公司。<br/></p><p>这次腾讯领投ObEN，是否可以进一步推动公司社交业务的人工智能化。如今，各大公司不仅在忙于建立人工智能实验室，而且像Facebook这样的公司已经成立了更具象的Facebook AR实验室。另外，据说苹果很快就会推出ARKit平台。未来，腾讯是否还会成立单独的AR实验室，进一步布局社交AI业务？</p><p><br/></p>','0','0','0','','0','0','','','','','3','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIqsBlQGO2vpH41p972','1','2020-01-16 23:39:03','','','0','1','0','','1.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('23','22','0','美业信息化规模将现，门庭管店为他们提供了一套SaaS管理软件','','','admin','1','11','','0','0','','0','','','','','0','2020-01-16 22:36:32','admin','','/html/upload/images/201907/15590951812642.jpg','1','1','数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度','0','<p>数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度低、管理效率低。</p><p>美业现在的主要管理方式是纸质账本和简单的收银、结算软件，纸质管理约占行业客户的90%，功能简单只能用于管理会员卡的单机版管理软件约占9%。美业的客户与店面的粘性比较高，虽然是低频次消费，但是一旦用户选择一家店，在接收到较好服务之后很难再转向其它店，因此美业在预约管理、客户管理等需求上要高于餐饮和零售，应用的软件形态并不一定以结算收银为主，重点是CRM系统、收银、绩效考核、预约为一体的管理软件。</p><p>36氪近日了解的门庭管店是一款美业 S<a href=\"#\" target=\"_blank\">a</a>aS 产品，主要功能有&nbsp;SCRM 会员管理、智能预约、绩效工资、 营销卡券、全能收银等。门庭管店产品在客户方是微信公众号和小程序；美容师端是用于客户关系维系、工资查询和预约的移动端；前台端是 Upad，主要是收银和预约；还有一个店长用的总后台，主要是 PC 或者一体化智能机，做整体的数据管理。</p><p>其实管理的过程也是沉淀数据的过程，也是开发闭环和生态的过程，CEO 孟凡刚告知记者，门庭管店现在先用营销工具+SaaS 系统，切入线下美业门店，建立强关系，然后通过收银系统嵌入微信、支付宝支付，将门店的线上流水导入平台沉垫大量资金，最后在基于 SaaS 交易数据、消费行为数据进行大数据分析延伸美业产品、项目供应链。比如门庭管店最近正在做韩国的皮肤检测仪，检测完之后放在客户档案里，综合到智能管理平台，这样顾客再来的时候就可以针对个人特点进行服务。</p><p>美业的变革形成了两个阵营，一个阵营是大型会所，积累了很多老顾客，老顾客随着年龄的增长对养生的需求越来越强烈，一旦切入了养生，就和80、90这些互联网主力军有些脱离；还有一类是近两年新开的店，新开的店没有老会员的资源，那么如何针对80、90人群做服务就变成了主要任务 ，年轻人属于互联网使用场景人群，因此新店更容易植入 SaaS 软件。门庭管店更偏向于年轻化的店，在积累了一段时间的经验和资金之后再做老店。</p><p>对于没有信息化的店，前期的数据录入是最麻烦的，门庭管店会派客服帮助整理数据，时间大概是2-3天。其次就是软件使用的普及，关于这一点，门庭管店有专门的培训，包括音视频的远程培训。收费模式上分为私有云部署和公有云，公有云不过万元，之后每年有1000元维护费用。整个软件的安装大概能为门店省下一个人的成本。</p><p>门庭管店的客户包括克丽缇娜、丝域养发、庆熙美学、千禧鸟、自然美等。</p><p>行业竞品方面，美业 SaaS 提供商还包括博卡、喔噻、美约汇、美丽加、点美、美业邦等。</p><p>孟凡刚认为做美业 SaaS 的一个门槛就是软件研发能力，只有有比较强的研发能力才能开发出页面简洁、功能齐全、适用于管理的产品，客户与公司粘性才会提高，所以门庭管店来的想法是以做出更智能化的产品；其次一点就是销售能力，门庭管店现在采用合伙人方式，代理渠道可以发展自己的客户，目前门庭合伙人有100多个。</p><p>团队现在30人，一半以上为技术人员，CEO 孟凡刚曾任会友科技 CEO、随车记 CEO，有8年的互联网及移动互联网运营管理经验。公司已经完成了天使轮融资，计划进行下一轮融资。</p><p><br/></p>','0','0','0','','0','0','','','','本网站','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYEEg44pdjX3k5GMP332','1','2020-01-16 22:36:32','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('24','22','0','点击在线求助，应答的却都是机器人，这样真的好吗？','','','admin','1','8','','0','0','','0','','','','','0','2020-01-16 23:38:44','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。2016年4月，马克·扎克伯格在Facebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像和朋友一','0','<p>人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。</p><p>2016年4月，马克·扎克伯格在F<a href=\"#\" target=\"_blank\">a</a>cebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像和朋友一样与机器人聊天”的新时代。世界各地的开发人员，这些开发人员都拥有Facebook、Google和Microsoft等大公司的认证，都声称独立移动应用程序的时代结束了，并一起庆祝新的方式的到来——对话商务（Conversational Commerce）和聊天机器人（Chatbots）。11个月前，Facebook宣布其官方开发的聊天机器人“M”的beta测试中AI失败率为70％，随后便更新了其平台，并建议开发人员在Messenger中开发更轻量级的应用程序，同时禁用会话输入。</p><p>关于Wordhop.io，一直以来我们都知道两件事。第一件事就是，AI真的很难，要实现让机器人100％像朋友一样与人类交流还需要很多年。毕竟，机器人不能像人一样产生共鸣。第二，Facebook消费者不会因为他们想购物或对天气感兴趣而给一个企业发送消息。这些体验是以具备聊天机器人为前提条件的，并且还需要已从信息传递领域拓展到社交网络领域的行业数据的支撑。</p><p>Facebook用户真正想要的就是，在有问题的时候可以迅速得到商家的回复。</p><p>消费者在Facebook上给商家发送消息的主要原因是想要获得服务。其他的一切都是浮云。这样的交互式预售可能从客户的发问开始，及时的答复可以推进交易的进行。如果客户联系销售客服，通常是因为他们真的有问题需要请教客服。一些答案可以由机器人回答，而更复杂的问题可以交给人来解决，在有得力工具的情况下，人类的回复速度可以媲美机器人。</p><p>然而许多机器人开发者没有将注意力集中在最有需求的那部分上，而是寻求创造新的用户体验，或重新开发升级旧的关于chatbot的概念。如果机器人开发者觉得参与率低，这可能不是因为AI失败了，而是因为他们把消费者往一条最开始就不想走的路上引。没有利用已存在的消费者行为模式，也没有训练机器人回应客户的需求，AI的作用只是，实现机器人开发商想象中的创造性体验并指导消费者通过该体验来进行交互。</p><p>Facebook现在建议机器人开发人员完全禁用会话输入。</p><p>我个人并不认为，像Facebook建议的那样禁用聊天输入是针对AI和NLP的技术限制的正确解决方案。无对话能力的通信机器人对于新闻机器人是可以接受的，这其中的体验由通知和内容消费驱动。但是，如果是以服务为基础的业务的话，则需要为用户提供一个可以与你友好互动的平台。如果文字输入是Messenger的主要方式，那么就会限制客户的沟通意愿和能动性，并迫使他们寻求你能想象到的其他方式的客户服务，又或者只是延迟回复都会让客户更加失望。想一想IVR吧，每次听完菜单选项后，你要按几下“0”。</p><p>商界应该采用自动和人工相结合的方式，这样才能满足Facebook用户的需求。</p><p>中国的微信的小程序是整合于消息互动的，这满足了开发者对聊天机器人的期待，但是这是东方的文化现象，而西方企业则应该首先利用已有的消费者行为，并且要更好地利用这样的行为数据。如果你不是“聊天机器人会取代人工服务”这一概念的拥趸，只是坚守开业之初对顾客的承诺，那么引入这样的科技就可以帮助你加强与客户间的交流。如果你能够实现现在Facebook消费者们的期望，那么随着时间的推移，你也可以增加新的功能，并将消费者往你所期待的方向引领。最终你很可能会满足他们的需求。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBch1stLWGqmFhze909','1','2020-01-16 23:38:44','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('25','22','0','传滴滴即将接入ofo，共享单车大战格局或生变','','','admin','1','20','','0','0','','0','','','','','0','2020-01-16 23:38:30','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的App上，届时用户可以直接在滴滴上面使用ofo的服务。“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用','0','<p>36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的<a href=\"#\" target=\"_blank\">a</a>pp上，届时用户可以直接在滴滴上面使用ofo的服务。</p><p>“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。</p><p>ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用户看到车就用，整个逻辑跟滴滴平台打车的逻辑不太一样，但近期我们会跟滴滴联合推出一些东西。”</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590115762957.jpg\" title=\"15590115762957.jpg\" alt=\"57.jpg\"/></p><p><br/></p><p>不过类似的接入并非没有先例。今年2月，微信联合摩拜单车宣布，用户通过微信“扫一扫”扫描摩拜单车车身上的二维码，就可直接进入摩拜单车微信小程序，点击开锁即可用车。</p><p>这并不是第一次传出ofo会接入滴滴的消息，也不是两个平台的第一次深度绑定。此前，滴滴参与了ofo最近三轮的融资。根据腾讯科技的报道，一位共享单车投资人透露，ofo经过多轮融资以后，滴滴已经成为ofo最大股东，占股超过30%。“这意味着，滴滴在ofo的话语权更强了，同时，ofo的成与败，滴滴将是最大利息相关方。”</p><p>这也不难理解，滴滴将ofo接入之后，将作为巨大的用户流量入口为其导流，而ofo则进一步巩固生意体量，在滴滴的加持下提高行业地位和想象空间。</p><p>而且，如果真的将ofo接入进来，也意味着滴滴及其背后的资本在进一步弥补自己在出行领域的缺口。</p><p>有知情人向36氪透露，曾经滴滴也想做共享单车，但是出于某些原因没能实现，最终只能作为ofo的投资方。不过这并不意味着滴滴不会更进一步涉足这个市场。</p><p>滴滴投资ofo，无非是瞄准了“最后三公里”的机会。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590106398663.jpg\" title=\"15590115918734.jpg\" alt=\"58.jpg\"/></p><p><br/></p><p>当前国内在“最后三公里”领域仍是一个非常初级的阶段，也没有系统性服务商。而在北上广的一线城市，交通的繁复令各大出行平台对“最后三公里”争夺日趋激烈。</p><p>“从出发地到目的地3公里，到底是打车还是骑车，这对于用户来说是可以选择的，选哪一个都说得过去。”一名ofo内部员工说，而滴滴的做法就是自己要把不同的选项全部覆盖。</p><p>在滴滴和ofo及其投资人看来，共享单车领域已经迎来了一个快速增长期。Ofo的一名公关曾对媒体表示，以专车和快车为例，2012 年之后的这几年，发展速度是非常快的。ofo 则是在 1 年的时间里，把日订单量从 200 单做到了50万单，“过去的专车快车，现在的 ofo 都是经历着高速的增长，这个势头是类似的”。上述公关人员说。</p><p>去年12月末，ofo联合滴滴推出红包活动，这是ofo被滴滴战略投资后双方首次进行大规模合作。而活动采取的红包策略，也被认为是滴滴历来进行市场推广的利器之一。</p><p>按照滴滴方的说法，2017年仍旧会将主要精力放在出行领域，希望能够打通每个人的出行。这意味着所有的出行方式都将会被覆盖到，共享单车也会是滴滴发力的方向之一。</p><p>36氪认为，滴滴进一步接入共享单车还有一个重要的原因在于，与“苛刻”的互联网专车规定相比，共享单车发展初期便受到了政策鼓励，约束条件也颇为合理。而去年至今一直受网约车新政影响的滴滴出行无论是从政策角度，还是从新的业务增长角度来看，都有可能会更进一步从共享单车的风口上分得一杯羹。</p><p>不过，36氪还有疑问，没有导航的ofo要怎么接入滴滴，以及接入之后到底会给用户带来哪些影响？</p><p>“据我了解到的情况是，滴滴可能会把技术和导航这快的事情承包给第三方公司。”上述ofo内部员工说，接入滴滴之后的ofo可能依旧没有导航，用户在页面上主要行使扫码开锁和支付功能。</p><p>至于用户体验方面，上述内部员工表示，“本来ofo的主体功能就比较单一，操作起来非常的简单，相信可以无缝对接到滴滴平台上，”他强调，“毕竟未来的趋势是，人们手机上装载的app数量将会越来越少”。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcRxhJAQONfzQgBi372','1','2020-01-16 23:38:30','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('26','24','0','我们的客户六','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:17','admin','','/html/upload/images/201907/15590119613906.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYrFFP2HJK6dqK3EO405','1','2019-05-28 10:52:17','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('27','24','0','我们的客户五','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:49','admin','','/html/upload/images/201907/15590119824821.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJfXqRGA5YldmUTW569','1','2019-05-28 10:52:49','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('28','24','0','我们的客户四','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:10','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYhwXJUQSS037urC592','1','2019-05-28 10:53:10','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('29','24','0','我们的客户三','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:53','admin','','/html/upload/images/201907/15590120451192.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIzPvDiJ69VLjNGR766','1','2019-05-28 10:53:53','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('30','24','0','我们的客户二','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:16','admin','','/html/upload/images/201907/15590120684878.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9GqCQFgFQyglQj7360','1','2019-05-28 10:54:16','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('31','24','0','我们的客户一','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:32','admin','','/html/upload/images/201907/15590120844373.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYAQclj7YrB9fd0zB432','1','2019-05-28 10:54:32','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('32','33','0','2000','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:54:51','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1982年公司成立。','0','<p>2000年公司发生的事。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYHm0xy8DUB1nvRaR236','1','2019-05-29 08:54:51','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('33','33','0','1995','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:17','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1995年公司发生的事。','0','<p>1995年公司发生的事。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRNotaOXnvroS1LX687','1','2019-05-29 08:55:17','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('34','33','0','1987','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1987年公司发生的事。','0','<p>1987年公司发生的事。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9iSxLUYzDOVbMek325','1','2019-05-29 08:55:40','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('35','33','0','1983','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:19','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1983年公司发生的事。','0','<p>1983年公司发生的事。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYqaGTtWY1GuaBar1334','1','2019-05-29 08:56:19','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('36','33','0','1982','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1982年公司成立。','0','<p>1982年公司成立。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYpCNyNaObllf1WLH124','1','2019-05-29 08:56:40','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('37','34','0','“激情之夏”篮球比赛圆满结束！','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:02','admin','','/html/upload/images/201907/15590951812642.jpg','1','1','2018年8月1日，世纪天鸿“激情之夏”篮球比赛落下帷幕。最终，经过激烈的角逐，由世纪天鸿系统事业部、行政部组成的系统梦之队和由世纪天鸿大客户事业部、电商事业部、集团总裁办组成的传奇队分别获得了冠、亚军。世纪天鸿常务副总编兼系统事业部总经理杨凯为冠亚军队伍颁奖。   通过此次篮球比赛，拉近了各部门之间的距离，增进了彼此之间的沟通与了解。丰富了员工的文化生活，增强了员工团队意识和集体荣誉感，达到了以','0','<p>&nbsp;2018年8月1日，世纪天鸿“激情之夏”篮球比赛落下帷幕。最终，经过激烈的角逐，由世纪天鸿系统事业部、行政部组成的系统梦之队和由世纪天鸿大客户事业部、电商事业部、集团总裁办组成的传奇队分别获得了冠、亚军。世纪天鸿常务副总编兼系统事业部总经理杨凯为冠亚军队伍颁奖。</p><p>&nbsp; &nbsp; &nbsp; 通过此次篮球比赛，拉近了各部门之间的距离，增进了彼此之间的沟通与了解。丰富了员工的文化生活，增强了员工团队意识和集体荣誉感，达到了以球会友、增进友谊，促进和谐的公司氛围、凝聚人心的目的2018年8月1日，世纪天鸿“激情之夏”篮球比赛落下帷幕。最终，经过激烈的角逐，由世纪天鸿系统事业部、行政部组成的系统梦之队和由世纪天鸿大客户事业部、电商事业部、集团总裁办组成的传奇队分别获得了冠、亚军。世纪天鸿常务副总编兼系统事业部总经理杨凯为冠亚军队伍颁奖。</p><p>&nbsp; &nbsp; &nbsp; 通过此次篮球比赛，拉近了各部门之间的距离，增进了彼此之间的沟通与了解。丰富了员工的文化生活，增强了员工团队意识和集体荣誉感，达到了以球会友、增进友谊，促进和谐的公司氛围、凝聚人心的目的。 2018年8月1日，世纪天鸿“激情之夏”篮球比赛落下帷幕。最终，经过激烈的角逐，由世纪天鸿系统事业部、行政部组成的系统梦之队和由世纪天鸿大客户事业部、电商事业部、集团总裁办组成的传奇队分别获得了冠、亚军。世纪天鸿常务副总编兼系统事业部总经理杨凯为冠亚军队伍颁奖。</p><p>&nbsp; &nbsp; &nbsp; 通过此次篮球比赛，拉近了各部门之间的距离，增进了彼此之间的沟通与了解。丰富了员工的文化生活，增强了员工团队意识和集体荣誉感，达到了以球会友、增进友谊，促进和谐的公司氛围、凝聚人心的目的。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYVxCBeWGRDWucvRm347','1','2019-05-29 09:59:02','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('38','34','0','梦想起航，拥抱未来——2019创业孵化平台年会','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:57','admin','','/html/upload/images/201907/15590952222752.jpg','1','1','2019年1月23日，世纪天鸿创业孵化平台年会在淄博举办，本次年会以“梦想起航，拥抱未来”为主题。世纪天鸿所有孵化平台的创始人、员工欢聚一堂，共襄盛典。  世纪天鸿董事长任志鸿、轮值总经理于宝增也参加了年会。年会由世纪天鸿常务副总经理张学军主持。在会中，山东优易练图书有限公司、山东佰鸿壹铭教育科技有限公司、山东志鸿超仁图书有限公司、山东先德睿图书有限公司、山东尚鸿升学帮教育咨询有限公司、北京小鸿文','0','<p>2019年1月23日，世纪天鸿创业孵化平台年会在淄博举办，本次年会以“梦想起航，拥抱未来”为主题。世纪天鸿所有孵化平台的创始人、员工欢聚一堂，共襄盛典。<br/>&nbsp; &nbsp; 世纪天鸿董事长任志鸿、轮值总经理于宝增也参加了年会。年会由世纪天鸿常务副总经理张学军主持。在会中，山东优易练图书有限公司、山东佰鸿壹铭教育科技有限公司、山东志鸿超仁图书有限公司、山东先德睿图书有限公司、山东尚鸿升学帮教育咨询有限公司、北京小鸿文化传媒有限公司、淄博鸿书坊文化传播有限责任公司、山东瓜二文化传媒有限公司、北京触学科技有限公司、山东天易鸿图教育科技有限公司等项目负责人分别与大家分享了自己的创业故事并带领自己的团队进行了团队展示。先德睿动感十足的舞蹈、佰鸿壹铭改编的创业版《沙漠骆驼》，尚鸿升学帮充满力量的《奔跑》等节目，都让人印象深刻。随后，世纪天鸿董事长任志鸿为到场的创业公司颁发了纪念金牌并为先德睿、佰鸿壹铭颁发了“优秀创业团队”的表彰，并在年会上发表了讲话。<br/>世纪天鸿创业孵化平台，是一个充满着挑战且蕴藏着机遇的环境，各创业公司以脚踏实地的作风、百折不挠的精神、坚韧不拔的毅力，在创业的路上散发着自己的光芒。告别2018，面对崭新的2019，让我们心怀希望，憧憬世纪天鸿创业孵化平台2019新的辉煌。<br/>&nbsp; &nbsp; 如果你有创业梦想，千万别犹豫，抓住机遇，来创业孵化平台，活出属于你的精彩。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYLGJWgkXGdDceA8172','1','2019-05-29 09:59:57','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('39','34','0','2019年太极拳比赛活动拉开序幕','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 10:00:40','admin','','/html/upload/images/201907/15590952834831.jpg','1','1','  为弘扬中华传统文化，丰富天鸿阳光体育活动，培养广大员工团队协作、积极进取的优良品质，4月22日，世纪天鸿首届太极拳比赛活动在公司园区正式启动。  对于此次太极拳比赛，公司首先进行内容为陈式洪派太极拳八十一式的培训。经过宣传动员，使员工充分认识到太极拳对于强身健体、团队协作的重要性，并有效调动了各部门的积极性。参赛员工分为系统事业部团队、大客户事业部团队、业务部门联队、职能部门联队四个方队。各部','0','<p>&nbsp; &nbsp; 为弘扬中华传统文化，丰富天鸿阳光体育活动，培养广大员工团队协作、积极进取的优良品质，4月22日，世纪天鸿首届太极拳比赛活动在公司园区正式启动。</p><p>&nbsp; &nbsp; 对于此次太极拳比赛，公司首先进行内容为陈式洪派太极拳八十一式的培训。经过宣传动员，使员工充分认识到太极拳对于强身健体、团队协作的重要性，并有效调动了各部门的积极性。参赛员工分为系统事业部团队、大客户事业部团队、业务部门联队、职能部门联队四个方队。各部门员工积极配合，按时参加培训，为在以后的太极比赛中取得佳绩奠定基础。<br/></p><p></p><p>&nbsp; &nbsp; 此次培训活动，特邀陈氏洪派太极拳传人李玉福老师进行指导教学。在培训现场，李老师与员工认真交流、精心指导，“太极起式、野马分鬃、白鹤亮翅、左右搂膝拗步”等一招一式，似行云悠悠，如流水绵长，着实充满美感。各部门员工每天按时列成方阵进行学习，在公司园区构成了一道亮丽的风景线。</p><p></p><p>&nbsp; &nbsp; 太极拳作为武术的重要组成部分，历史悠久，博大精深，是中华民族的瑰宝。此次太极拳走进天鸿园活动，既能使员工们强身健体，也将进一步推动世纪天鸿企业文化的广泛深入开展。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYzzOpkeWefOxetiy687','1','2019-05-29 10:00:40','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('40','13','0','路由器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:23:27','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地','0','','0','0','0','','0','0','','','999','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYNfW06Lofg2dRM52677','1','2020-01-17 09:23:27','','my_shop_model,my_shoppingcolor','0','1','188','','0.00','0.00','','{}','1:300M,+,10,2:500M,+,20,','1:蓝,+,0,2:黑,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('41','15','0','产品名称三十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:05:27','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','560','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJz9tU0sEFmG4jYr924','1','2019-08-16 23:05:27','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('42','15','0','产品名称三十','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:13:43','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYoqRcqqx04wOaAxg150','1','2019-05-29 13:13:43','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('43','15','0','产品名称二十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:11','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYdpBjq9drwOlW0lf664','1','2019-08-16 23:06:11','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('44','15','0','产品名称二十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:10','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYbM6nNh7Q3yzd5ea383','1','2019-08-16 23:06:10','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('45','15','0','产品名称二十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:13','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYYcWihLq5Dgx5rzO811','1','2019-08-16 23:06:13','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('46','15','0','产品名称二十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:33:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYOPdjHvE4Pn4u0dk942','1','2019-08-16 23:33:48','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('47','15','0','产品名称二十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:02','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY7g8BajgqgwA2LsQ659','1','2019-08-17 00:02:02','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('48','15','0','产品名称二十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:03','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYm8MzExt0fTjru5P101','1','2019-08-17 00:02:03','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('49','15','0','产品名称二十三','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:05','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','120','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYXDCS4WRJNTKkc4P113','1','2019-08-17 00:02:05','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('50','15','0','产品名称二十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:04','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','166','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYo9eP29z3HPIgb4V659','1','2019-08-17 00:02:04','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('51','14','0','产品名称二十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:34','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','177','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYVUKHL6UcJ7fOOHT585','1','2019-08-17 00:18:34','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('52','14','0','产品名称二十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:35','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','','0','','0','0','0','','0','0','','','199','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYBkQvDdHVOAUgwxb296','1','2019-08-17 00:18:35','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('53','14','0','产品名称十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJfx8fl6qGjFjhRB691','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('54','14','0','产品名称十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590080664809.jpg','1','1','','0','','0','0','0','','0','0','','','1600','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590080664809.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYpkR2pX6G54WXOpL136','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('55','14','0','产品名称十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','210','','0','','','0','a:1:{i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHmUFxBzunoBf4U0359','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('56','14','0','产品名称十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','220','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYjzChf9aIGI4b0p9136','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('62','14','0','产品名称十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:42','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','','0','','0','0','0','','0','0','','','270','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhgNcxGA33CN0WVG368','1','2019-08-17 00:18:42','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('58','14','0','产品名称十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:40','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY6IDNvIpFJj5HxMg820','1','2019-08-17 00:18:40','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('59','14','0','产品名称十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:41','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','250','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYteUoUOdnEtJQ5DO966','1','2019-08-17 00:18:41','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('61','14','0','产品名称十三','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:36:10','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','260','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYu8jmokWatEiOQek651','1','2019-05-29 13:36:10','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('63','13','0','产品名称十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:44','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYURynpBhTaiRU1ms696','1','2019-08-17 00:18:44','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('64','13','0','产品名称十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:45','admin','','/html/upload/images/201907/15506330561844.jpg','1','1','','0','','0','0','0','','0','0','','','330','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330561844.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY521mO3OWstsuJvy507','1','2019-08-17 00:18:45','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('65','13','0','产品名称九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:52','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','','0','','0','0','0','','0','0','','','340','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGXyVs7sVq5KE1nj376','1','2019-08-17 00:18:52','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('66','13','0','产品名称八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:53','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','360','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhuFUlRzDbrQ1jM3690','1','2019-08-17 00:18:53','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('67','13','0','产品名称七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:54','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','380','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY0BCt9KtrTRtjv6L213','1','2019-08-17 00:18:54','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('68','13','0','产品名称六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:55','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1TiXfBUr5DbqEzS249','1','2019-08-17 00:18:55','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('69','13','0','产品名称五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:56','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','4050','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGrWKMWNt9VGjomF275','1','2019-08-17 00:18:56','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('70','13','0','产品名称四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:57','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHTxk1P8OSnxGsGI140','1','2019-08-17 00:18:57','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('71','13','0','产品名称三','','','admin','1','0','','0','0','','0','','','','','0','2019-07-22 15:38:36','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRwbmVb35BbAF4uT843','1','2019-07-22 15:38:36','','my_shop_model,my_shoppingcolor','0','1','99','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('72','12','0','产品名称二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 02:11:03','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；产品标识应当清晰、牢固，易于识别；','0','<p>产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。</p><p>产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；<br/></p><p>产品标识应当清晰、牢固，易于识别；</p><p>产品名称包含中英文全程，或者中文拼音。另有对应于全称的企业或产品简称，如：中兴通讯股份有限公司，简称：中兴通讯，英文简称：ZTE。</p><p>企业或品牌名称具备统一的标准字体、标准色、标准大小以区别于同类企业或产品。企业和产品名称应用于企业日常产品、服务、办公、营销行为等公司运作的各个方面，形成完整统一的企业CI系统。所以产品名称是企业识别系统中最重要的一个要素。</p><p><br/></p><p>产品名称应当表明产品的真实属性，并符合下列要求：</p><p>（一）国家标准、行业标准对产品名称有规定的，应当采用国家标准、行业标准规定的名称；</p><p>（二）国家标准、行业标准对产品名称没有规定的，应当使用不会引起用户及消费者误解和混淆的常用名称或者俗名。</p><p>产品名称可以作为注册商标，但应符合商标法的规定。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYTReKg1pr3crT8CO456','1','2019-08-17 02:11:03','','my_shop_model,my_shoppingcolor','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('73','12','0','产品名称一','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:11:39','admin','','/html/upload/images/201907/15591115606261.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/html/upload/images/201907/15591115599626.jpg\"/></p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115606261.jpg\"/></center><p><br/></p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115602093.jpg\"/></center><p><br/></p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','2','10','html/upload/attachment/201908/1566304174297.png','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','1','CMSEASYOK2nysJX2XzMN7X248','1','2020-01-17 09:11:39','admin','my_shopping_model,my_shopping_color','18','1','996','<p>详细说明</p><p><img src=\"/html/upload/images/201908/15662076301300.jpg\" title=\"15662076301300.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076302696.jpg\" title=\"15662076302696.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076306969.jpg\" title=\"15662076306969.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076314121.jpg\" title=\"15662076314121.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076318531.jpg\" title=\"15662076318531.jpg\"/></p><p><br/></p>','0.00','0.00','83,1#my_shopping_model,2:便携,jia,155;my_shopping_color,6:金,jia,0-73,1#my_shopping_model,2:I7,jia,10;my_shopping_color,1:金,jia,88','{}','1:I5,+,5,/html/upload/images/201908/15662076314121.jpg2:I7,+,10,/html/upload/images/201908/15662076301300.jpg3:I9,+,15,/html/upload/images/201908/15662076318531.jpg','1:金,+,88,/html/upload/images/201907/15590079031945.jpg2:黑,+,8,/html/upload/images/201907/15506336226893.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('74','37','0','520家售后网点','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:03','admin','','/html/upload/images/201907/15591169541800.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYztbAWrIud1FqAwM189','1','2019-05-29 16:02:03','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('75','37','0','满150元包邮','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:43','admin','','/html/upload/images/201907/15591169739359.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYXe8jxOmWqQ070gQ904','1','2019-05-29 16:02:43','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('76','37','0','15天免费换货','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:01','admin','','/html/upload/images/201907/15591169933799.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYLDoNiWI7NO4xBfM994','1','2019-05-29 16:03:01','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('77','37','0','7天无理由退货','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:22','admin','','/html/upload/images/201907/15591170149117.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYmDaJUfapbwNpp7x939','1','2019-05-29 16:03:22','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('78','37','0','预约维修服务','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:41','admin','','/html/upload/images/201907/15591170337490.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcGhrO1KVcIWghek879','1','2019-05-29 16:03:41','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('81','29','0','项目经理','','','admin','1','12','','0','0','','0','','','','','0','2019-06-13 16:23:39','admin','','','1','1','业务经理业务经理 “AE”的职责是：对外，与客户进行谈判、联络、提案、收款等；对内，制定策略、协调资源、分派工作、监督进程等。由此可知，一个真正的 “AE”，并不象“拉业务”的业务员那么简单，他要熟悉销售、市调、企划、设计、制作、媒体等方面的专业知识，也要有一定的人际关系处理能力。','0','<p>业务经理业务经理 “AE”的职责是：对外，与客户进行谈判、联络、提案、收款等；对内，制定策略、协调资源、分派工作、监督进程等。由此可知，一个真正的 “AE”，并不象“拉业务”的业务员那么简单，他要熟悉销售、市调、企划、设计、制作、媒体等方面的专业知识，也要有一定的人际关系处理能力。</p>','archive/show_job.html','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQucDYsG9O6OUqzO569','1','2019-06-13 16:23:39','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('82','24','0','合作伙伴八','','','admin','1','0','','0','0','','0','','','','','0','2019-06-14 14:51:13','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBlFncAe0iLoY9Qf261','1','2019-06-14 14:51:13','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('83','12','0','MackBook','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:12:27','admin','','/html/upload/images/201907/15591115599626.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','0','CMSEASYJTEFwo7JfLxlhul232','1','2020-01-17 09:12:27','','my_shopping_model,my_shopping_color','999','1','97','','0.00','0.00','73,1#-72,1#','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://www.jd.com\"},\"1\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://www.tmall.com\"}}','1:台式,+,55,2:便携,+,155,','1:黑,+,0,/html/upload/images/201907/15590080664809.jpg2:白,+,0,/html/upload/images/201907/15591115599626.jpg3:蓝,+,0,/html/upload/images/201907/15590079031945.jpg4:紫,+,0,/html/upload/images/201907/15591115602093.jpg5:灰,+,0,/html/upload/images/201907/15506335969988.jpg6:金,+,0,/html/upload/images/201907/15506335904260.jpg7:银,+,0,/html/upload/images/201908/15662076306969.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('85','35','0','某某荣誉','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 20:51:26','admin','','/html/upload/images/201907/1201.jpg','1','1','荣誉说明文字。。。','0','<p style=\"text-align: center;\"><br/><img src=\"/html/upload/images/201907/1201.jpg\"/></p><p><br/></p><p>荣誉说明文字。。。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYO70f2XfrUVxUUz6867','1','2019-08-16 20:51:26','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('86','8','0','解决方案二','','','admin','1','2','','0','0','','0','','','','','0','2019-07-09 18:33:20','admin','','','1','1','解决方案二文字描述。。。','0','<p>解决方案二文字描述。。。</p>','0','0','0','','0','0','','','','','0','5','html/upload/attachment/201905/15579676979434.zip','0','N;','','0','0','0','0000-00-00','0','CMSEASYQN2pfl790LO5Ouo231','1','2019-07-09 18:33:20','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('87','8','0','解决方案一','','','admin','1','33','','0','0','','0','','','','','0','2019-07-30 07:48:46','admin','','/html/upload/images/201907/14360857154349.jpg','1','1','解决方案文字说明。。。','0','<p>解决方案</p><p style=\"page-break-after:always; border:1px dashed #000;\"><br/></p><p>文字说明</p>','0','0','0','','0','0','','','','','0','7','html/upload/attachment/201907/15628273460708.gif','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360807979603.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360854145721.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14363453760256.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYQ7C6mNjnb3EPO0p724','1','2019-07-30 07:48:46','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('88','8','0','解决方案三','','','admin','1','0','','0','0','','0','','','','','0','2019-07-09 18:41:44','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYH6rFJkqJoC5fDzk552','1','2019-07-09 18:41:44','','','0','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('100','68','0','Domestic maritime transport','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:25:13','admin','','/html/upload/images/201907/15590103415339.jpg','1','1','In October 2001, the BDI index of the international dry bulk market dropped to 845, the lowest level in the whole year. The index rose slightly in 2002, but not much, closing at 1731 at the end of the year. In the second half of 2003, there was a sharp increase, which soared to 4470 in October and closed at 4467 at the end of the year. In 2004, it maintained a good momentum of growth, reaching a year-round peak of 6101 points and closing at 4438 points at the end of the year. March 2005 was the highest point of the year, 4956, and ended at 2321 at the end of the year. Since 2002, the overall volume of dry bulk cargo has shown an accelerated upward trend.','0','<p>In October 2001, the BDI index of the international dry bulk market dropped to 845, the lowest level in the whole year. The index rose slightly in 2002, but not much, closing at 1731 at the end of the year. In the second half of 2003, there was a sharp increase, which soared to 4470 in October and closed at 4467 at the end of the year. In 2004, it maintained a good momentum of growth, reaching a year-round peak of 6101 points and closing at 4438 points at the end of the year. March 2005 was the highest point of the year, 4956, and ended at 2321 at the end of the year. Since 2002, the overall volume of dry bulk cargo has shown an accelerated upward trend. As the global economic development has a great demand for large quantities of basic raw materials, the volume of transportation such as iron ore and coal has grown rapidly, and China, as one of the fastest growing countries in the global economy, has played a very important role. In the past 10 years, the average annual growth rate of bulk dry bulk shipping volume in China is 17%, which is much higher than that in the international market, while 70% of the increase in the world dry bulk shipping market comes from China. Taking iron ore as an example, China imported 148 million tons of iron ore in 2003, accounting for 28.5% of the world\'s shipping volume. In 2004, the global iron ore shipping volume was 600 million tons, and China imported 208 million tons, accounting for 34.6%. Influenced by the state regulation and control, the growth rate declined in 2005, but there was still an additional demand of 60 million tons. The annual import volume reached 248 million tons, with a growth rate of about 20%. It can be predicted that, driven by China\'s huge engine, the international dry bulk shipping market will continue to grow in 2006, with an average annual growth rate of 6%.</p><p>In terms of oil transportation, the world economy is highly dependent on oil. Experts calculate that for every 1% growth in the global economy, 400,000 barrels of oil will be needed every day. As the main mode of oil transportation, water transportation completes 92% of the oil trade. The global crude oil shipping volume in 2003 was 1.6 billion tons, which was further increased in 2004. It is estimated that the average growth rate of international crude oil shipping volume in 2005-2007 will be about 3%. China\'s oil demand has increased dramatically in recent years, and has become the second largest oil consumer and importer in the world in 2004. In 2003, China imported 91.12 million tons of crude oil, accounting for 5.4% of global crude oil trade. In 2004, China imported 122 million tons of crude oil, breaking through the 100 million tons barrier for the first time. In 2005, crude oil consumption exceeded 300 million tons, and the gap between supply and demand will be further widened, with crude oil imports reaching 127 million tons in 2005. It is expected that China\'s demand for oil will maintain a relatively high growth rate in the next few years, which will have a greater and greater impact on international oil shipping.</p><p>In container transport, driven by Pacific and Eurasian routes, container trade has grown rapidly since 2002. In 2003, the total volume of international container trade was 79 million TEU, an increase of 8.2% compared with the same period last year. In 2004, the growth rate rose to 11% to 87.7 million TEU. In 2005, Pacific routes will increase by 12%, Asia-Europe routes will increase by 15%, while Atlantic routes will remain stable and increase slightly. In 2005, the overall container volume will increase by about 10% on the original basis. China\'s container shipping volume accounts for about 20% of the world\'s total, and more than 60% of the world\'s container shipping volume is on the Eastern Pacific Route and the Western Asia-Europe Route. China\'s container throughput reached 75.8 million TEU in 2005, with a growth rate of 23.7%, higher than the world average.</p><p>From the perspective of fleet construction, </p><p> there are 5700 dry bulk carriers with a total capacity of 29,634.8 million tons, which are distributed in hundreds of shipping companies. China Shipping Company has 579 vessels with 24.405 million tonnes of load; Hong Kong Shipping Company has 261 vessels with 18.19 million tonnes of load. China and Hong Kong have a total capacity of 42.596 million tons, accounting for 14.4% of the world\'s total. China has 231 shipping companies engaged in international shipping, with a total capacity of 22.1 million tons, ranking ninth in the world. China\'s shipping enterprises have set up hundreds of wholly-owned, joint-venture shipping enterprises and offices abroad, and the proportion of cargo transported by third countries is increasing day by day.</p><p>There are many kinds of cargo transported by international sea, so different types of ships and handling equipments are adopted for different types of cargo. For specific cargo, Qihai introduces how to transport super large cargo from ship type and loading and unloading equipment.</p><p>1. Trucks. The truck is transported by PCTC (PURE CAR TRUCK CARRIER). Its main feature is that it can accommodate large trucks on single deck (generally between 3 and 4 meters in height). Its maximum weight of stern jump can reach 45 tons, and its weight per square meter can reach 3 tons. Therefore, overweight trucks can be allowed to jump into the cabin through stern. 。</p><p>2． Large equipment. Generally speaking, the transportation of large-scale equipment is more complex. Some parts are larger and tonnage is larger. They can not be transported by general containers, while some spare parts can be transported by containers. RORO and CONTAINER are generally used in this type of ship, which can load large components and containers at the same time. Therefore, it is the ideal ship type for transportation of many large equipment.</p><p>So what kind of handling equipment is more reasonable for this type of ship?</p><p>BOLSTER FLATBED This equipment is suitable for large components less than 4 meters long and weighing less than 28 tons. The crane lifts the cargo to a flat plate with a lifting height not exceeding one meter (which can avoid cargo damage caused by swing and turnover during lifting). Then it uses special nylon belt (whose rigidity is equivalent to steel wire rope, but it can greatly reduce the wear and tear on the surface of cargo compared with steel wire rope) or steel wire rope padding. The cargo is fixed on a flat plate, and the forklift truck carries the cargo into the cabin through the stern jump of the ship.</p><p>ROLLTRAILER This kind of equipment is suitable for transporting overweight and oversize cargo. In theory, it can carry cargo of 25 meters long and 120 tons. However, due to the limitation of the carrying capacity of tail jump and tow, the actual carrying capacity will be smaller. ROLLTRAILER can be transported into the cabin by self-propelled tow through the stern of the ship, thus achieving zero damage to the cargo.</p><p>3． Train compartment. Because the train boxes are long and 40 meters long, the general ROLLTRAILER transport will not be able to rotate into the cabin due to the restrictions of hatches. SPECIALDESIGNED TRAILERS (Special Tire Bogie) can solve this problem. The tires of this equipment can rotate 360 degrees and can be transported back into the cabin when the ship\'s stern jumps into the cabin.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJ0PSRBqIjOIqxyh942','1','2019-05-28 10:25:13','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('101','68','0','International Air Transport','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:28:37','admin','','/html/upload/images/201907/15590105447904.jpg','1','1','Air transport refers to the use of aircraft, helicopters and other aircraft to transport personnel, goods and mail. Passengers, luggage, cargo and mail are transported by air outside a country at their departure, transit and terminal points. Mainly on international routes. International routes are established through bilateral air transport agreements between governments. In order to ensure the safety and efficiency of international navigation, extensive international cooperation and coordination must be carried out in accordance with unified procedures and rules. The International Civil Aviation Organization and the Regional Civil Aviation Organization have played an important role in international air transport.China\'s International Air Transport','0','<p>Air transport refers to the use of aircraft, helicopters and other aircraft to transport personnel, goods and mail. Passengers, luggage, cargo and mail are transported by air outside a country at their departure, transit and terminal points. Mainly on international routes. International routes are established through bilateral air transport agreements between governments. In order to ensure the safety and efficiency of international navigation, extensive international cooperation and coordination must be carried out in accordance with unified procedures and rules. The International Civil Aviation Organization and the Regional Civil Aviation Organization have played an important role in international air transport.China\'s international air transport began in July and March 1950, when the Sino-Soviet Civil Airlines co-operated with the former Soviet Union opened three international routes from Beijing to Chita, Irkutsk and Almaty of the former Soviet Union.&nbsp;</p><p>Air transportation began in 1871. At that time, the French in the Franco-Prussian War used balloons to transport government officials, materials, mail and other goods out of Paris besieged by the Prussian army. On May 5, 1918, air transport first appeared, with routes from New York to Washington to Chicago. On June 8 of the same year, regular postal flights began between London and Paris. In the 1930s, there were civil transport planes, and various technical performances were constantly improved. The development of the aviation industry promoted the development of air transport. After the end of the Second World War, the world has gradually established a network of routes. The network of world routes, starting from the major cities of various countries, covers all continents. In 1990, the total turnover of world scheduled flights reached 235.67 billion tons per kilometer.</p><p>1. The shipper shall fill in the cargo transport form to the carrier and attach the necessary valid supporting documents in accordance with the provisions of the competent national authorities. The shipper shall be responsible for the authenticity and correctness of the contents of the transport form. A contract for the carriage of goods by air shall be established when the cargo transport document submitted by the shipper is accepted by the carrier and the cargo transport document is filled out by the carrier.</p><p>2. When the shipper requests to transport goods by chartered aircraft, he shall fill in the application for charter flights. After the carrier agrees to accept and sign the charter flights agreement, the contract for the carriage of goods by charter flights shall be established. The individual signing the agreement shall abide by the provisions of the competent civil aviation authority concerning charter flights.</p><p>3. The shipper shall pack the goods transported in accordance with the packaging standards stipulated by the competent state authorities; if there is no uniform stipulation on the packaging standards, the shipper shall pack the goods according to the nature of the goods and the conditions such as carrying aircraft, in accordance with the principle of ensuring transport safety. The carrier has the right to refuse to carry goods that do not meet the above packing requirements.</p><p>4. The shipper must mark the departure, arrival, shipper and consignee on the consigned goods. Names and addresses shall be marked with indicators of packaging, storage and transportation in accordance with the provisions of the State. </p><p>5. For goods that must be insured by the State, the shipper shall insure the goods for transport at the time of shipment.</p><p>6. The shipper shall pay the freight and other charges at the rates prescribed by the competent civil aviation authority for the consignment of goods. Unless otherwise agreed by the shipper and the carrier, freight and other charges shall be paid in one lump sum at the time of issuance of the bill of lading for the goods.</p><p>7. The carrier shall issue a notice of arrival to the consignee within 24 hours after the arrival of the goods at the place of delivery. The consignee shall promptly withdraw the goods at the designated place on the basis of the certificate of delivery. The goods shall be kept free of charge for March from the day after the notice of arrival is issued. The consignee shall pay the custody fee in accordance with the transport rules when the withdrawal is overdue. </p><p>8. When the consignee withdraws the goods, he has no objection to the abandonment or weight of the goods halfway and signs the receipt on the cargo waybill, the carrier is discharged from the liability for carriage. </p><p>9. If the shipper or consignee seeks compensation for the loss of the shipper or consignee due to the fault or intentional cause of the shipment, the shipper or consignee shall submit the claim in writing to the carrier within 180 days after the date of filling in the record of the accident in the carriage of goods, accompanied by relevant supporting documents.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJPOyTpq0T4pOqGr804','1','2019-05-28 10:28:37','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('102','67','0','Domestic Air Transport','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:29:49','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','technical equipment is the material basis for realizing air transportation. It mainly includes routes, airports, aircraft and communication and navigation facilities. Route is a corridor protected airspace based on ground navigation facilities, and it is the field of aircraft flight. Its delimitation is centered on the line connecting each ground navigation facility, and the upper limit height, the lower limit height and the width are stipulated in the range of the route. For aircraft flying within its scope, air traffic control should be implemented. Airport is an integral part of civil airport and related service facilities. It is the base for safe take-off and landing of aircraft, and also the gathering and distributing center for passengers, cargo and mail. Aircraft is the main carrier. Model Selection','0','<p>Technical equipment is the material basis for realizing air transportation. It mainly includes routes, airports, aircraft and communication and navigation facilities. Route is a corridor protected airspace based on ground navigation facilities, and it is the field of aircraft flight. Its delimitation is centered on the line connecting each ground navigation facility, and the upper limit height, the lower limit height and the width are stipulated in the range of the route. For aircraft flying within its scope, air traffic control should be implemented. Airport is an integral part of civil airport and related service facilities. It is the base for safe take-off and landing of aircraft, and also the gathering and distributing center for passengers, cargo and mail. Aircraft is the main carrier. The selection of aircraft type depends on the specific situation of the flight route and the overall economic and technological performance. Communication and navigation facilities are facilities for communicating information, guiding aircraft to fly safely and landing safely at their destination (see aviation pilot).</p><p>Because of the importance of air transport to the development of national economy and the promotion of international exchanges, most countries attach great importance to the development of air transport. The government has set up special agencies to manage such enterprises as the General Administration of Civil Aviation in China, the Federal Aviation Administration in the United States and the Ministry of Civil Aviation in the former Soviet Union. Various preferential policies have been implemented to support the development of air transport enterprises, such as government direct investment, loans, tax relief and financial subsidies.</p><p>Air transport enterprises mainly operate in the form of shift transport, charter transport and special aircraft transport. The latter two are temporary arrangements as needed. Duration transportation is to carry out transportation tasks along fixed routes and at fixed time according to schedule and fixed type of aircraft. When there are more passengers and cargo to be transported, overtime flights along the regular transport routes can also be organized. The operational quality of air transport is mainly evaluated from three aspects: safety level, economic benefit and service quality.<br/></p><p>Air transportation began in 1871. At that time, the French in the Franco-Prussian War used balloons to transport government officials, materials, mail and other goods out of Paris besieged by the Prussian army. On May 5, 1918, air transport first appeared, with routes from New York to Washington to Chicago. On June 8 of the same year, regular postal flights began between London and Paris. In the 1930s, there were civil transport planes, and various technical performances were constantly improved. The development of the aviation industry promoted the development of air transport. After the end of the Second World War, the world has gradually established a network of routes. The network of world routes, starting from the major cities of various countries, covers all continents. In 1990, the total turnover of world scheduled flights reached 235.67 billion tons per kilometer.<br/></p><p>The weight of the goods is calculated by gross weight. The unit of calculation is kilograms. Weight less than 1 kilogram, according to 1 kilogram, more than 1 kilogram of the tail rounded.<br/></p><p>The weight of each cargo loaded by a non-wide-body aircraft does not exceed 80 kg and the volume does not exceed 40*60*100 M. The weight of each cargo loaded by a wide-body aircraft generally does not exceed 250 kg. Volume generally does not exceed 250*200*160 cm. Goods exceeding the above weight and volume shall be accepted and transported by Northwest Company on the basis of specific conditions.<br/></p><p>The length, width and height of each cargo shall not be less than 40 cm. <br/> </p> <p> cargo with a volume exceeding 6000 cubic centimeters per kilogram shall be weighed in light bubble cargo. Light bubble cargo is measured in kilograms per 6000 cubic centimeters.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQtzTbjowanLdwNF405','1','2019-05-28 10:29:49','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('103','67','0','International Land Transport','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:20','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','transportation refers to the logistics activities that use specific equipment and tools to transport goods from one place to another. It is the spatial displacement of objects in different geographical areas for the purpose of changing the spatial location of objects. Through this kind of displacement, the space benefit of commodities can be created, their use value can be realized, and the different needs of society can be met. Transportation is one of the central links of logistics and the most important function of modern logistics activities.Transport is a Chinese vocabulary, meaning yn sh_. It means to transport goods to another place by means of transportation. It is an activity to realize the change of space position of people and objects. Logistics transportation refers specifically to \"material\"','0','<p>Transportation refers to the logistics activities that use specific equipment and tools to transport goods from one place to another. It is the spatial displacement of objects in different geographical areas for the purpose of changing the spatial location of objects. Through this kind of displacement, the space benefit of commodities can be created, their use value can be realized, and the different needs of society can be met. Transportation is one of the central links of logistics and the most important function of modern logistics activities.&nbsp;</p><p>Transport is a Chinese vocabulary, meaning yn sh_. It means to transport goods to another place by means of transportation. It is an activity to realize the change of space position of people and objects.</p><p>Logistics transportation refers to the transportation and transportation of \"goods\". It is an activity aimed at changing the spatial position of \"thing\" in different geographical areas (such as between two cities, two factories or two cars far apart in a large enterprise), and it is a spatial displacement of \"thing\".</p><p>Transportation is generally divided into transportation and distribution. There are many different opinions on the distinction between transportation and distribution. It can be said that the movement of all goods is transportation, while distribution refers to short-distance, small-batch transportation. Therefore, it can be said that transportation refers to the whole, while distribution refers to a part of it, and distribution focuses on one.&#39;&#39;match&#39;&#39;Character, its main meaning is also reflected in&#39;&#39;match&#39;&#39;On the word；and&#39;&#39;give&#39;&#39;For the ultimate realization of resource allocation&#39;&#39;match&#39;&#39;And service.</p><p>Transportation functional elements. Including the supply and sale of logistics vehicles, ships, aircraft and other modes of transport, production logistics pipelines, conveyor belts and other modes of transport.</p><p>Transport refers to the process of transferring people, money and things from one place to another. Transport is also considered as the foundation of the national economy.</p><p>The main means of transportation are bicycles, scooters, tricycles, motorcycles, cars, trains, planes, ships, spaceships, rockets, etc.</p><p>Transportation can be divided into passenger and freight transport </p><p> public transport according to the different service objects, which generally refers to the mode of transportation that all fees provide transportation services. </p><p> Car consignment: (Car transportation) refers to the mode of transportation that takes a car as a commodity after it leaves the factory and arrives at a designated place by means of large-scale vehicle transportation.&lt;/CN&gt;</p><p>Composition of Transport Price</p><p>The basic price, the composition of the operating basic price and the incidental expenses of freight transportation</p><p>The annual freight rate of the zero-load cargo = freight per ton x billed weight< p > < p > freight rate per ton of vehicle goods = base price + operating base price * freight mileage < / P > < p > container freight per container = base price + operating base price * freight mileage</p><p>Freight transport has a value-preserving effect. That is to say, any product from production to final consumption must go through a period of time, a distance, in this period and a distance process, must go through transport, storage, packaging, handling, handling and other links, many times of cargo transport activities. In this process, products may be wet, waterlogged, rusted, damaged, lost, etc. The mission of cargo transportation is to prevent the above phenomena, ensure the quality and quantity of products in the process of moving from producers to consumers, and play a role in preserving the value of products, that is, to protect the existing value of products, so that the value of products will not change when they reach consumers.</p><p><br/></p><p>Good transportation can save natural resources, human resources and energy, but also save costs. For example, container transportation can simplify commodity packaging, save a lot of paper and wood for packaging; realize mechanized loading and unloading operations, warehouse storage automation, can save a large number of operators, greatly reduce personnel costs. There are many examples of cost savings in cargo transportation. Go by the name of&quot;The First Awakening of China\'s Freight Transport Management&quot;Haier Enterprise Group has strengthened its transportation management and built a modern international automated freight transportation center. In one year, it has reduced the stock-holding funds and purchasing funds from 1.5 billion yuan to 700 million yuan, saving 800 million yuan in expenditure.<br/></p><p>Freight transportation can overcome the time interval, distance interval and human interval, which is also the essence of freight transportation. Modern cargo transport is shortening<br/></p><p>There are numerous examples of distance. Fresh fruits from all over the world can be purchased in Beijing, and fruits from all over the country are constantly growing all the year round. The postal department has improved the transportation of goods, greatly shortened the time distance of letters. The National Express service will go to the United States FedEx within two days, and can reach 15 cities in Asia the next day. The distribution center in Japan can do this, at 10 a.m. Order before the order and deliver on the same day. This kind of transportation speed brings people\'s geographical distance and time distance very close at once. With the continuous advancement of the modernization of freight transport, international transport capacity has been greatly strengthened, which has greatly promoted international trade, making people gradually feel that the earth has become smaller and the continents are closer.<br/></p><p>Citizens in the city unconsciously enjoy the fruits of freight progress. Bananas produced in the South can be purchased in all major cities of the country all year round; Hami melon in Xinjiang, brandy melon in Ningxia, rice in Northeast China and rice in Tianjin Xiaozhan all supply the market seasonally; this is the reason why the international transportation industry is developed and international freight is reduced.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYwWEC936lN5EomYR935','1','2019-05-28 10:30:20','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('104','67','0','Domestic Land Transport','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:47','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','1. Transportation has the essential attributes of production. The production process of transportation is linked by certain production relations. People with labor skills use labor tools (such as vehicles, ships, aircraft and other facilities) and labor objects (goods and passengers) to produce and create the production process of products. For passenger transport, the products transported are the spatial displacement of human beings; for cargo transport, they are the spatial displacement of cargo. Obviously, transportation is a production activity aiming at changing the spatial location of \"people and things\", which is different from the industrial and agricultural production which mainly changes the physical, chemical and biological attributes of the object of labor. Transport','0','<p>1. Transportation has the essential attribute of production</p><p>Transportation production process is a process of production in which people with labor skills use labor tools (such as vehicles, ships, aircraft and other facilities) and labor objects (goods and passengers) to produce and create products. For passenger transport, the products transported are the spatial displacement of human beings; for cargo transport, they are the spatial displacement of cargo. Obviously, transportation is a production activity aiming at changing the spatial location of \"people and things\", which is different from the industrial and agricultural production which mainly changes the physical, chemical and biological attributes of the object of labor.</p><p><br/></p><p>2. Transportation production is completed in the process of circulation</p><p>Transportation is the activity of transporting products from production to consumption. Therefore, in terms of the whole social production process, transportation is a continuous production process in the field of circulation and is completed in it.</p><p><br/></p><p>3. Transportation products are invisible</p><p>Transport production does not change the physical and chemical properties and forms of labor objects as industrial and agricultural production does, but only changes the spatial position of labor objects, and does not create new physical products. Therefore, in order to meet the needs of social transport, excessive transport products or transport expenditures are a waste.</p><p><br/></p><p>4. Transportation products belong to consumption while production</p><p>The production and consumption of industrial and agricultural products can be completely separated in time and space, while the production and consumption of transport products are inseparably combined in time and space, belonging to the consumption while production.</p><p><br/></p><p>5. Non-Storage of Transport Products</p><p>Because the transportation product is invisible, does not have the material entity, but also because it produces while consumes the attribute. Therefore, transport products can neither be allocated nor stored.</p><p><br/></p><p>6. Identity of Transport Products</p><p>For different modes of transport, although they use different means of transport, have different technical and economic characteristics, and carry out transportation and production activities on different routes, they have the same effect on society, that is, they have realized the spatial displacement of goods. The identity of transport products enables various modes of transport to complement, coordinate and replace each other to form an effective integrated transport system.</p><p><br/></p><p>1. Transportation is one of the main functional elements of logistics</p><p>According to the concept of logistics, logistics is a physical movement of \"things\", which not only changes the temporal state of things, but also changes the spatial state of things. Transportation undertakes the main task of changing the spatial state. Transportation is the main means of changing the spatial state. Transportation combined with transportation, distribution and other activities can successfully complete all the tasks of changing the spatial state.</p><p>2. Transportation is one of the necessary conditions for social material production.</p><p>3. Transportation can create \"place utility\"</p><p>The meaning of place utility is that the same kind of \"thing\" has different degree of realization of its use value and benefits because of different space places. As a result of changing the place to maximize the use value and maximize the input-output ratio, it is called \"place utility\". By means of transportation, the potential of \"material\" can be brought into full play and the optimal allocation of resources can be realized if \"material\" is transported to the place with the highest utility. In this sense, it is also equivalent to improving the use value of goods through transportation.</p><p>4. Transportation is the main source of \"the third profit source\".</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYlfHdT9Fr4Gubi5g482','1','2019-05-28 10:30:47','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('105','73','1','When the outlet of unmanned convenience stores is right, \"Convenience Home\" has been invested by millions of angels by Lianchuang Yongxuan Feng Tao.','','','admin','1','27','','0','0','','1','','','','','0','2019-07-09 14:22:11','admin','','/html/upload/images/201907/14360803742226.jpg','1','1','6 krypton learns that \"Convenient Home\" has received millions of RMB angel rounds of investment, and the management is Lenovo Yongxuan Feng Tao. When the outlet of no-one convenience store is right, a crowd of players gather, such as Fruit Box, F5 Future Store, Shenlan Science and Technology, Easy Go and so on. Amazon, Rosen, Alibaba, Wal-Mart and other giants are also experimenting with water. Convenient Home was founded in March 2017 in Shanghai. Convenience home has two kinds of products: mini-unmanned convenience store and medium-sized unmanned convenience store. Compared with many players, the difference of convenience home lies in its flexibility. Convenient home \"mini-unmanned convenience store\", the smallest unit covers less than 1 square meter','0','<p>6 krypton learns that \"Convenient Home\" has received millions of RMB angel rounds of investment, and the management is Lenovo Yongxuan Feng Tao.</p><p>Nobody convenience store outlet is right, fruit box, F5 future store, Shenlan technology, E<a href=\"#\" target=\"_blank\">a</a>sy GoAs players gathered, Amazon, Rosen, Alibaba, Wal-Mart and other giants also tried water.&nbsp;</p><p>Convenient Home was founded in March 2017 in Shanghai. Convenience home has two kinds of products: mini-unmanned convenience store and medium-sized unmanned convenience store. Compared with many players, the difference of convenience home lies in its flexibility.&nbsp;</p><p>Convenient home \"mini-unmanned convenience store\", the smallest unit covers less than 1 square metre (0.68 square metre), more flexible places, including subway stations, office buildings, colleges and universities, a smallest unit convenience store costs about 13,000 yuan (batch production may be lower). The smallest unit of unmanned convenience stores, according to the distribution of the flow of people, \"together\" up a larger unit of convenience stores. For less than 100 people, one can be placed; for about 100 people, two can be spelled; for more than 500 people, four can be spelled. Convenient home\'s \"medium-sized unmanned convenience store\" is a combination of six mini-convenience stores. At the same time, tables and chairs are added in the space to provide consumers with a rest area, which can be placed in relatively open areas, parks and so on.</p><p>Technically, the convenience home has set up RFID in each shelf, and sealed and shielded the cracks in each corner, so that the recognition rate is higher. The process is very simple, using Alipay sweep code to open the door, take it away, Alipay automatically deduct money (WeChat is negotiating). In the future, convenience home hopes to do palmprint recognition on the door handle, when consumers \"open the door\" this action, it can be recognized.<br/></p><p>Conceptually, the facilitator is actually closer to the vending machine. Fan Shaowei, the founder, believes that the facilitator is an improvement on the traditional vending machine. On the one hand, most of the traditional vending machines are based on drinks and fixed packaged snacks, while the convenience home will be based on \"fresh food\" which meets the health trend; on the other hand, the delivery process of traditional vending machines is to pay first and then ship. The display of pipelines makes the space utilization rate low, if it is fresh food commodities. It is also possible to deform in the process of falling. Convenient home for the first to take goods, then deduct money, can be stacked, dense arrangement, so that the space utilization rate is higher. \"In the same area, our delivery rate is twice as high as that of traditional vending machines.\"</p><p>Convenient home selection logic is to choose different goods according to different venues, such as meeting the needs of white-collar breakfast in the office building, providing convenience, sandwiches, salad and so on, and providing snacks, brine, bread and so on in universities. Comparing with the average unit price of the whole family (14 yuan), the average unit price of the convenience family will be set at about 10 yuan. In addition, through small programs, consumers can feed back what they want to eat, and guide the selection of categories in reverse according to the data.<br/></p><p>In addition to micro and medium convenience stores, convenience home has a third aspect of business - the transformation of traditional couple stores. Off-line couple stores are characterized by different sizes and areas. Convenient home provides unmanned convenience stores renovation scheme. First, couple stores share site resources and share sales; second, franchise mode, the income ratio is higher. On the one hand, small shopkeepers don\'t need to be there for more than ten hours a day. On the other hand, they can extend other businesses to get more profits, such as milk tea, coffee and so on.</p><p>\"Whether it\'s no one retailing or someone retailing, it\'s essentially a retail business.\" Fan Shaowei said. Since it is a retail business, in the layout of the site, we need to stand in the overall perspective, \"most afraid of a hammer in the east, a stick in the west.\"</p><p>The reasonable layout of points, lines and surfaces can reduce the operation cost and logistics cost to the greatest extent. Two important factors need to be considered: the flow of people and the coordination of laying points. Convenient home\'s idea is to lay out a medium-sized unmanned convenience store in a densely populated area, and then to lay out 10 mini-unmanned convenience stores within a circumference of 100 meters to form a \"minimum replenishment unit\", one person can be responsible for the replenishment of 20 equipment.</p><p>As for the cost of RFID tagging, Fan Shaowei holds an optimistic attitude. At present, the cost of tagging is between 0.5 and 0.6 yuan, but with the popularity of RFID in the retail market, the price of RFID tagging will certainly decrease.</p><p>After this round of financing, Convenient Home will set up a pilot operation point in Shanghai, medium-sized + mini-unmanned convenience stores, with 20 outlets expected to be laid. At present, facilitators are seeking Pre-A round of financing to expand production and put into operation.</p><p>On the team side, CEO Fan Shaowei graduated from Harbin University of Technology and was a manager of the northern region of the business software channel department. He is a continuous entrepreneur. COO Wu Wei is a master of Shanghai Jiaotong University. He has been working continuously in the field of fast-food products. CTO Peng Genggeng graduated from Shanghai University with a major in Computer Engineering and was a senior engineer in advertising platform Department of Tencent OMG business group.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYCJzxtWrGrENvlKX557','1','2019-07-09 14:22:11','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('106','73','0','Five million dollars to lead AI startup ObEN to further lay out social AI','','','admin','1','39','','0','0','','0','','','','','0','2020-01-18 21:39:37','admin','','/html/upload/images/201907/14360803742226.jpg','1','1','In addition to basic technology research, Tencent has expressed its intention to promote the artificial intelligence of various application scenarios through business-driven. Combined with Tencent&#039;s main business, it is not difficult to guess that the company will work in the four application directions of games, social networking, content and platform tools in the future. Especially in the social sphere, Zuckerberg said last year that he would launch a VR version of Facebook and show off Oculus Avatars, a virtual persona tool; in July, Facebook said that Facebook AR studio would work with Atlas to provide three AR camera effects. Today, Tencent is','0','<p>In addition to basic technology research, Tencent has expressed its intention to promote the artificial intelligence of various application scenarios through business-driven.</p><p>Combined with Tencent&#39;s main business, it is not difficult to guess that the company will work in the four application directions of games, social networking, content and platform tools in the future.</p><p>Especially in the social sphere, Zuckerberg said last year that he would launch the VR version of F.<a href=\"#\" target=\"_blank\">a</a>cebook，It also shows the virtual character image tools Oculus Avatars；In July, Facebook said that Facebook AR Studio would work with Atlas to provide three AR cameras with special effects. Now, Tencent is going to do something about it.</p><p>On the evening of July 18, AI startup ObEN announced a $5 million strategic investment. This round of financing is led by Tencent, CMC Chairman Li Ruigang and Fengshan Capital follow-up investment. According to crunchbase, the investment and financing information platform, ObEN has completed four rounds of financing, totaling $13.7 million. Previous investors include S Rushan Capital, Softbank Korea Venture Capital Corporation and HTC VIVE X.</p><p>According to public information, ObEN, founded in 2014, can create user&#39;s AI virtual image by building personalized virtual voice, image and personality, and help users store, manage and operate their virtual image in the emerging digital world. That is to say, ObEN can use AI tools to create virtual images based on users&#39;photos and voices, thus allowing users to have different AR and VR social experience.</p><p>In the past, ObEN mainly helped gamers create virtual images, but now the company is focusing on helping stars create virtual images. Through this virtual image, stars can interact with fans in real time. In the future, fans may also be able to seek advice from stars and get feedback accordingly. In addition, this virtual image is not only very similar to the star, but also the same way of speaking. Generally speaking, such a virtual image is better than a chat robot.</p><p>According to reports, ObEN also integrated voice, computational vision and natural language processing technology for the first time, and developed the virtual sound, three-dimensional image and personalization technology needed by the whole stack of virtual stars. Now ObEN is building a new business platform. Here, stars and fans can interact directly on mobile, augmented reality, virtual reality, intelligent devices, Internet of Things and other platforms through personalized artificial intelligence. ObEN&#39;s personalized AI products are expected to be released later this year.</p><p>The latest round of financing will be used to accelerate ObEN&#39;s product development and help promote its star AI copyright platform to be widely applied to various digital platforms. For this cooperation, Yao Leiwen, executive director of Tencent Investment, said that ObEN will bring new entertainment methods and content driven by star AI.</p><p>Earlier, ObEN said it would be &quot;everyone&#39;s artificial intelligence social networking platform&quot;. In this regard, the company has carried out several layouts.</p><p>At the HTC Vive Ecosphere Conference in March this year, ObEN announced that in cooperation with HTC Vive, he had developed a micro-program for users to play with VR and &quot;K Song&quot; of VR. In this program, VR users can send invitations to their friends; friends who receive invitations can upload self-portraits and audio, and ultimately use the built image to walk along the beach with the invitees, or visit scenic spots.</p><p>At the end of April, ObEN launched a short video of a micro-Chat service that integrates VR social experience, and of course users need to wear HTC Vive headlights. In the short film, users need to take a self-timer first, upload it to Wechat to create a virtual image, and then bring HTC Vive to receive the information sent by Wechat friends, and can respond directly by voice. In the future, Wechat, which has VR and AR functions, may be able to harvest a large number of Asian users.</p><p>At the end of June, ObEN announced the establishment of a joint venture company with South Korean SM Entertainment, AI Stars. It is reported that ObEN will use artificial intelligence technology to create AI virtual images for famous artists of SM Entertainment, and Phantom Star Limited is the brokerage company that manages these &quot;AI stars&quot;.<br/></p><p>This time Tencent leads the investment in ObEN, whether it can further promote the artificial intelligence of the company&#39;s social business. Today, not only are companies busy building artificial intelligence labs, but companies like Facebook have established more like Facebook AR labs. In addition, it is said that Apple will soon launch the ARKit platform. In the future, will Tencent set up a separate AR laboratory to further lay out its social AI business？</p><p><br/></p>','0','0','0','','0','0','','','','','3','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIqsBlQGO2vpH41p972','1','2020-01-18 21:39:37','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('107','72','0','With the scale of information technology coming, Menting Management Store provides them with a set of SaaS management software.','','','admin','1','11','','0','0','','0','','','','','0','2019-07-09 14:19:48','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','The data show that in 2015, China\'s service industry grew by 8.3% year-on-year, which is higher than 1.4 and 2.3 percentage points of GDP and added value of secondary industry, accounting for 50.5% of GDP. For the first time, it is more than half. Compared with developed countries, China\'s service industry still has 20% - 30% room for development. Aesthetic industry belongs to the entity service industry, the whole market has a scale of hundreds of billions, but the degree of informatization is relatively low compared with the retail catering industry. The reason for this is that the flow of catering and retail customers is large, reaching a wide range of people, while the flow of American customers is relatively small, and the quality of employees leads to the degree of informatization.','0','<p>The data show that in 2015, China\'s service industry grew by 8.3% year-on-year, which is higher than 1.4 and 2.3 percentage points of GDP and secondary industry added value, accounting for 50.5% of GDP. For the first time, it is more than half. Compared with developed countries, China\'s service industry still has 20% - 30% room for development. Aesthetic industry belongs to the entity service industry, the whole market has a scale of hundreds of billions, but the degree of informatization is relatively low compared with the retail catering industry. One of the reasons is that the catering and retail passenger flow is large, reaching a wide range of people, while the American industry passenger flow is relatively small, coupled with the quality of employees, resulting in low degree of informatization and low management efficiency.</p><p>At present, the main management mode of American is paper account book and simple cash register and settlement software. Paper management accounts for 90% of industry customers, and single version management software with simple functions can only be used to manage membership cards accounts for 9%. The stickiness between customers and stores is relatively high. Although it is low-frequency consumption, once a user chooses a store, it is difficult to turn to other stores after receiving better service. Therefore, the demand of appointment management and customer management of American is higher than that of catering and retailing. The software form of application does not necessarily depend on settlement and cash collection. The main focus is CRM system, cash register, performance appraisal and appointment management software.</p><p>36 krypton recently learned that the courtyard management shop is a beautiful industry S<a href=\"#\" target=\"_blank\">a</a>aS Products, the main functions are&nbsp;SCRM Membership management, intelligent booking, performance pay, marketing card vouchers, all-round cash register, etc. The products of Menting Store are Wechat Public Number and Small Procedures on the client side; the beautician end is a mobile end for customer relationship maintenance, salary inquiry and reservation; the front end is Upad, mainly for cash and reservation; and there is also a general backstage used by the store manager, mainly PC or Integrative Intelligent Machine, for overall data management.</p><p>In fact, the process of management is also the process of precipitating data, and also the process of developing closed-loop and ecology. Meng Fangang, CEO, told reporters that Menting Guandian Store is now using marketing tools + SaaS system to cut into the off-line American stores and establish strong relations. Then, through the cashier system embedded in Weixin and Alipay payment, it will channel the stores online. Finally, based on SaaS transaction data and consumer behavior data, large data analysis extends the supply chain of American products and projects. For example, Menting Mansion Store is currently working on Korean skin tester. After testing, it is placed in the customer files and integrated into the intelligent management platform, so that customers can come back and serve according to their personal characteristics.</p><p>The transformation of American industry has formed two camps, one is a large club, which has accumulated a lot of old customers. With the growth of age, old customers have more and more strong demand for health care. Once they enter into health care, they are separated from the main forces of the Internet, such as 80 and 90. Another is the new stores opened in the past two years, and the new stores are not old. Membership resources, then how to serve 80, 90 people has become the main task, young people belong to the use of the Internet scene crowd, so the new store is easier to implant SaaS software. Menting stores tend to be younger stores. After a period of experience and money, they become old stores.</p><p>For stores without information technology, the previous data entry is the most troublesome, and the patio store will send customer service to help organize the data, the time is about 2-3 days. Secondly, the popularization of software usage. In this regard, courtyard stores have special training, including audio and video remote training. The charging model is divided into private cloud deployment and public cloud, public cloud is less than 10,000 yuan, after which there is 1,000 yuan maintenance cost every year. Installation of the entire software will probably save the store a person\'s cost.</p><p>The customers of Menting Store include Krittina, Silk Regions Hair Raising, Qingxi Aesthetics, Millennium Birds, Natural Beauty, etc.</p><p>In terms of industry competition, SaaS providers also include Boca, Ohio, JOY, Mega, Dianmei, Meibang, etc.</p><p>Meng Fangang thinks that the threshold of SaaS is the ability of software research and development. Only with strong research and development ability can we develop products with concise pages, complete functions and suitable for management. The stickiness of customers and companies will be improved. So the idea of the courtyard store is to make more intelligent products; the second point is that the courtyard store can make more intelligent products. Sales ability, the courtyard management shop now uses the partnership way, the agent channel can develop their own customers, at present there are more than 100 courtyard partners.</p><p>The team now has 30 people, more than half of them are technicians. CEO Meng Fangang was a member of the CEO of Science and Technology and CEO of Car Record. He has 8 years of Internet and mobile Internet operation and management experience. The company has completed the angel round of financing and plans to carry out the next round of financing.</p><p><br/></p>','0','0','0','','0','0','','','','this website','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYEEg44pdjX3k5GMP332','1','2019-07-09 14:19:48','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('108','72','1','Click on online help, but all the answers are robots. Is that really good?','','','admin','1','8','','0','0','','1','','','','','0','2019-07-09 14:19:46','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','the development of artificial intelligence technology is constantly changing people\'s life and working methods, which to a certain extent promotes the development and progress of society, which is beyond doubt. But artificial intelligence is not omnipotent, because machines do not have human thinking and emotions. I\'m afraid you\'ll be disappointed when you open the online help window on the website and find that the only answer is a cold robot. In April 2016, Mark Zuckerberg described a bright future for Messenger developers at Facebook\'s F8 conference and announced that he would enter \"Like and Friends One.\"','0','<p>The development of artificial intelligence technology is constantly changing people\'s life and working methods, which to a certain extent promotes the development and progress of society, which is beyond doubt. But artificial intelligence is not omnipotent, because machines do not have human thinking and emotions. I\'m afraid you\'ll be disappointed when you open the online help window on the website and find that the only answer is a cold robot.</p><p>In April 2016, Mark Zuckerberg was in F<a href=\"#\" target=\"_blank\">a</a>cebookThe F8 conference described a bright future for developers on Messenger and announced that they would enter a new era of \"chatting with robots like friends\". Developers all over the world, who are certified by companies such as Facebook, Google and Microsoft, claim that the era of stand-alone mobile applications is over and celebrate the arrival of new ways - Conversational Commerce and Chatbots. Eleven months ago, Facebook announced that its official chat robot, M, had a 70% AI failure rate in beta tests, and then updated its platform, suggesting that developers develop lighter applications in M essenger and disable session input.</p><p>As far as Wordhop.io is concerned, we all know two things. The first thing is that AI is really hard. It will take many years for robots to communicate with humans 100% like friends. After all, robots can\'t resonate like humans. Second, Facebook consumers don\'t send messages to an enterprise because they want to shop or are interested in the weather. These experiences are based on the premise of chat robots, and also need the support of industry data that has expanded from the field of information transmission to the field of social networks.</p><p>What Facebook users really want is to get a quick response from the merchant when there is a problem.</p><p>The main reason consumers send messages to businesses on Facebook is to get services. Everything else is clouds. Such interactive pre-sale may start with customer questions and prompt replies can facilitate the transaction. If customers contact sales customer service, it is usually because they really have problems and need to consult customer service. Some of the answers can be answered by robots, and more complex questions can be left to people to solve. With powerful tools, humans can respond as quickly as robots.</p><p>Many robotic developers, however, do not focus on the most demanding part, but rather seek to create new user experiences or redevelop and upgrade old Chatbot concepts. If robotic developers feel that the participation rate is low, it may not be because AI failed, but because they led consumers to a path they didn\'t want to take in the first place. Without using existing consumer behavior patterns or training robots to respond to customers\'needs, AI\'s role is simply to realize the creative experience imaginary by robotic developers and guide consumers to interact through the experience.</p><p>Facebook now recommends that robotic developers completely disable session input.</p><p>Personally, I don\'t think that banning chat input, as Facebook suggests, is the right solution to the technical limitations of AI and NLP. Communication robots without conversational capabilities are acceptable to news robots, where experience is driven by notification and content consumption. However, if you are a service-based business, you need to provide a platform for users to interact with you in a friendly way. If text input is the main way of Messenger, it will limit customers\'willingness and motivation to communicate, and force them to seek other ways of customer service that you can imagine, or just delaying replies will make customers even more disappointed. Think about IVR. After listening to the menu options, you need to press \"0\" several times.</p><p>Businesses should adopt a combination of automation and manpower in order to meet the needs of Facebook users.</p><p>China\'s Wechat apps are integrated into message interaction, which meets developers\'expectations for chat robots, but this is a cultural phenomenon in the East, while Western companies should first make use of existing consumer behavior and make better use of such behavior data. If you\'re not a fan of the concept that chat robots will replace manual services, but just stick to your initial commitment to customers, then introducing such technology can help you strengthen your communication with customers. If you can live up to the expectations of Facebook consumers, over time, you can add new features and lead consumers in the direction you expect. In the end, you are likely to meet their needs.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBch1stLWGqmFhze909','1','2019-07-09 14:19:46','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('109','72','1','Droplets will soon be connected to ofo, sharing bicycle battle patterns or changes','','','admin','1','20','','0','0','','1','','','','','0','2019-07-09 14:19:45','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','36 krypton gets information from within ofo, which may be accessed to drip-drip apps in April, when users can use ofo services directly on drip-drip apps. \"This has been on the agenda frequently recently, and internal information is likely to be accessed next month.\" An ofo insider said. Twenty-six krypton confirmed the news to the official and ofo authorities, but neither company confirmed or denied it at the time of publication. Dai Wei, founder of ofo, said in December last year that there was no clear timetable for when to access drip APP. \"There is no GPS in the ofo mode.','0','<p>36 krypton gets information from inside ofo, which may be connected to drip travel in April this year.<a href=\"#\" target=\"_blank\">a</a>On pp, users can use ofo services directly on droplets.</p><p>\"This has been on the agenda frequently recently, and internal information is likely to be accessed next month.\" An ofo insider said. Twenty-six krypton confirmed the news to the official and ofo authorities, but neither company confirmed or denied it at the time of publication.</p><p>Dai Wei, founder of ofo, said in December last year that there was no clear timetable for when to access drip APP. \"There is no GPS in ofo mode. Users can use it when they see the car. The whole logic is not the same as that of the drip platform taxi, but in the near future we will launch something together with the drip platform taxi.\"</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590115762957.jpg\" title=\"15590115762957.jpg\" alt=\"57.jpg\"/></p><p><br/></p><p>But similar access is not without precedent. In February this year, Wechat and MobyCar announced that users can directly enter the MobyCar Wechat applet by scanning the two-dimensional code on the body of the MobyCar through Wechat \"Sweep\" and click on the unlock to use the car.</p><p>This is not the first time that ofo will be able to access droplets of information, nor is it the first time that the two platforms are deeply bound. Before that, drip participated in the latest three rounds of ofo financing. According to Tencent Technologies, a bicycle-sharing investor revealed that after several rounds of financing, ofo has become the largest shareholder of ofo, accounting for more than 30% of the shares. \"This means that the voice of droplets in ofo is stronger, while the success or failure of ofo, droplets will be the biggest stakeholder.\"</p><p>It is not difficult to understand that drops of ofo access, will be as a huge user traffic entrance for its diversion, while ofo further consolidate business volume, with drops of support to improve the status of the industry and imagination space.</p><p>Moreover, if ofo is really brought in, it also means that drops of capital and the underlying capital are further filling the gap in the field of travel.</p><p>A person familiar with the situation disclosed to 36 krypton that he once wanted to be a sharing bicycle, but for some reasons he failed to achieve it, and finally he could only be an investor in ofo. But that doesn\'t mean that drip won\'t step further into the market.</p><p>Investing in ofo is nothing more than aiming at the \"last three kilometers\" opportunity.</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590106398663.jpg\" title=\"15590115918734.jpg\" alt=\"58.jpg\"/></p><p><br/></p><p>At present, the \"last three kilometers\" in China is still a very preliminary stage, and there is no systematic service provider. In the first-tier cities of North Shangguang, the traffic complexity makes the competition for the \"last three kilometers\" increasingly fierce among the major travel platforms.</p><p>\"Whether to take a taxi or ride a bicycle is 3 kilometers from the place of departure to the destination. It\'s optional for users, and it makes sense to choose either one.\" An ofo insider said that the trickle-down approach is to cover all the different options.</p><p>In the eyes of DDT, ofo and its investors, the shared bicycle sector has entered a period of rapid growth. A public relations official at Ofo once told the media that in the years after 2012, for example, the development of private cars and express cars has been very rapid. In one year\'s time, ofo has achieved 500,000 orders from 200 orders per day. \"Past express cars, now ofo is experiencing high-speed growth, the momentum is similar.\" The above public relations officer said.</p><p>At the end of December last year, ofo jointly launched a red envelope campaign, which was the first large-scale cooperation between the two sides after ofo was invested by the drop strategy. The red envelope strategy adopted by the campaign is also considered to be one of the most powerful tools for market promotion.</p><p>According to the dripping side, in 2017, we will still focus on the field of travel, hoping to get through everyone\'s travel. This means that all modes of travel will be covered, and sharing bicycles will be one of the directions of dripping power.</p><p>Thirty-six krypton believes that another important reason why drip-drip further access to shared bicycles is that compared with the \"harsh\" Internet regulations, shared bicycles have been encouraged by policies in the early stages of development, and the constraints are quite reasonable. And last year, drip trips, which have been affected by the new policy of online car-sharing, are likely to get a better share of the bike-sharing tuyere, either from a policy point of view or from a new business growth point of view.</p><p>However, there are still questions about how ofo without navigation can access droplets, and what impact will it bring to users after access?</p><p>\"As far as I know, droplets may contract fast things like technology and navigation to third-party companies.\" The above-mentioned ofo internal staff said that after access to droplets ofo may still have no navigation, users on the page mainly exercise code-scanning unlocking and payment functions.</p><p>As for user experience, the internal staff said that \"the main function of ofo is relatively single, and it is very simple to operate, and I believe it can be seamlessly connected to the drip platform,\" he stressed, \"After all, the trend in the future is that people will load fewer and fewer apps on their mobile phones.\"</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcRxhJAQONfzQgBi372','1','2019-07-09 14:19:45','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('110','74','0','Our Customer 6','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:17','admin','','/html/upload/images/201907/15590119613906.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYrFFP2HJK6dqK3EO405','1','2019-05-28 10:52:17','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('111','74','0','Our Customer 5','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:49','admin','','/html/upload/images/201907/15590119824821.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJfXqRGA5YldmUTW569','1','2019-05-28 10:52:49','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('112','74','0','Our Customer 4','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:10','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYhwXJUQSS037urC592','1','2019-05-28 10:53:10','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('113','74','0','Our Customer 3','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:53','admin','','/html/upload/images/201907/15590120451192.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIzPvDiJ69VLjNGR766','1','2019-05-28 10:53:53','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('114','74','0','Our Customer 2','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:16','admin','','/html/upload/images/201907/15590120684878.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9GqCQFgFQyglQj7360','1','2019-05-28 10:54:16','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('115','74','0','Our Customer 1','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:32','admin','','/html/upload/images/201907/15590120844373.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYAQclj7YrB9fd0zB432','1','2019-05-28 10:54:32','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('116','83','0','2000','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:54:51','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','the company was founded in 1982.','0','<p>What happened to the company in 2000.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYHm0xy8DUB1nvRaR236','1','2019-05-29 08:54:51','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('117','83','0','1995','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:17','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','What happened to the company in 1995.','0','<p>What happened to the company in 1995.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRNotaOXnvroS1LX687','1','2019-05-29 08:55:17','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('118','83','0','1987','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','What happened to the company in 1987.','0','<p>What happened to the company in 1987.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9iSxLUYzDOVbMek325','1','2019-05-29 08:55:40','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('119','83','0','1983','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:19','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','What happened to the company in 1983.','0','<p>What happened to the company in 1983.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYqaGTtWY1GuaBar1334','1','2019-05-29 08:56:19','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('120','83','0','1982','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','the company was founded in 1982.','0','<p>The company was founded in 1982.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYpCNyNaObllf1WLH124','1','2019-05-29 08:56:40','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('121','84','0','Summer of Passion basketball match has come to a successful end','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:02','admin','','/html/upload/images/201907/15590951812642.jpg','1','1','On August 1, 2018, Century Tianhong\'s \"Summer of Passion\" basketball game came to an end. Finally, after fierce competition, the team of Systematic Dream composed of Century Tianhong Systems Department and Administration Department and the legendary team composed of Century Tianhong Client Department, Electronic Commerce Department and Group President won the first and second place respectively. Yang Kai, Executive Vice President and General Manager of Systems Business Department of Century Tianhong, presented the award to the Guanya Army.   Through this basketball match, the distance between various departments has been narrowed and the communication and understanding between them have been enhanced. It enriches the cultural life of employees, strengthens their sense of team work and collective honor, and achieves the goal of','0','<p>&nbsp;On August 1, 2018, Century Tianhong\'s \"Summer of Passion\" basketball game came to an end. Finally, after fierce competition, the team of Systematic Dream composed of Century Tianhong Systems Department and Administration Department and the legendary team composed of Century Tianhong Client Department, Electronic Commerce Department and Group President won the first and second place respectively. Yang Kai, Executive Vice President and General Manager of Systems Business Department of Century Tianhong, presented the award to the Guanya Army.</p><p>&nbsp; &nbsp; &nbsp; Through this basketball match, the distance between various departments has been narrowed and the communication and understanding between them have been enhanced. It enriches the staff\'s cultural life, strengthens the staff\'s team consciousness and sense of collective honor, and achieves the goal of promoting harmonious company atmosphere and people\'s minds by playing ball with friends, enhancing friendship. On August 1, 2018, Century Tianhong\'s \"summer of passion\" basketball game came to an end. Finally, after fierce competition, the team of Systematic Dream composed of Century Tianhong Systems Department and Administration Department and the legendary team composed of Century Tianhong Client Department, Electronic Commerce Department and Group President won the first and second place respectively. Yang Kai, Executive Vice President and General Manager of Systems Business Department of Century Tianhong, presented the award to the Guanya Army.</p><p>&nbsp; &nbsp; &nbsp; Through this basketball match, the distance between various departments has been narrowed and the communication and understanding between them have been enhanced. It enriches the staff\'s cultural life, strengthens the staff\'s team consciousness and sense of collective honor, and achieves the goal of promoting a harmonious corporate atmosphere and cohesion of the people with club friends, friendship and friendship. On August 1, 2018, Century Tianhong\'s \"Summer of Passion\" basketball game came to an end. Finally, after fierce competition, the team of Systematic Dream composed of Century Tianhong Systems Department and Administration Department and the legendary team composed of Century Tianhong Client Department, Electronic Commerce Department and Group President won the first and second place respectively. Yang Kai, Executive Vice President and General Manager of Systems Business Department of Century Tianhong, presented the award to the Guanya Army.</p><p>&nbsp; &nbsp; &nbsp; Through this basketball match, the distance between various departments has been narrowed and the communication and understanding between them have been enhanced. It enriches the staff\'s cultural life, strengthens the staff\'s team consciousness and sense of collective honor, and achieves the goal of promoting a harmonious corporate atmosphere and cohesion of the people with club friends, friendship and friendship.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYVxCBeWGRDWucvRm347','1','2019-05-29 09:59:02','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('122','84','0','Dream of Starting, Embrace the Future --- Annual Conference of Business Incubation Platform, 2019','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:57','admin','','/html/upload/images/201907/15590952222752.jpg','1','1','On January 23, 2019, the annual meeting of Century Tianhong Business Incubation Platform was held in Zibo. The theme of this annual meeting is \"Dream to Start, Embrace the Future\". The founders and employees of all incubation platforms of Century Tianhong gathered together for a grand ceremony. Chairman Ren Zhihong and General Manager Yu Baozeng also attended the annual meeting. The annual meeting is presided over by Zhang Xuejun, the executive vice president of Century Tianhong. In the meeting, Shandong Youyi Training Books Co., Ltd., Shandong Baihong Yiming Education Technology Co., Ltd., Shandong Zhihong Chaoren Books Co., Ltd., Shandong Xianderui Books Co., Ltd., Shandong Shanghong Shengsheng Education Consulting Co., Ltd., Beijing Xiaohongwen Education Consulting Co., Ltd.','0','<p>On January 23, 2019, the annual meeting of Century Tianhong Business Incubation Platform was held in Zibo. The theme of this annual meeting is \"Dream to Start, Embrace the Future\". The founders and employees of all incubation platforms of Century Tianhong gathered together for a grand ceremony.<br/>&nbsp; &nbsp; Chairman Ren Zhihong and General Manager Yu Baozeng also attended the annual meeting. The annual meeting is presided over by Zhang Xuejun, the executive vice president of Century Tianhong. In the meeting, Shandong Youyi Training Books Co., Ltd., Shandong Baihong Yiming Education Technology Co., Ltd., Shandong Zhihong Chaoren Books Co., Ltd., Shandong Xianderui Books Co., Ltd., Shandong Shanghong Shengsheng Education Consulting Co., Ltd., Beijing Xiaohong Culture Media Co., Ltd., Zibohong Bookstore Cultural Communication Co., Ltd. are responsible for the limited public. The project managers of the Division, Shandong Guaer Culture and Media Co., Ltd., Beijing Touxue Technology Co., Ltd. and Shandong Tianyi Hongtu Education Technology Co., Ltd. shared their own business stories with you and led their team to carry out team demonstrations. The dynamic dancing of Xian Derui, the startup edition of Desert Camel adapted by Bai Hongyi, and the powerful \"Running\" of Shang Hongsheng\'s school group are all impressive. Subsequently, Ren Zhihong, chairman of Century Tianhong, awarded the commemorative gold medal for the entrepreneurship company and the award of \"excellent entrepreneurship team\" for Xian Derui and Bai Hongyi, and delivered a speech at the annual meeting.<br/>Century Tianhong entrepreneurship incubation platform is full of challenges and opportunities. With down-to-earth style, indomitable spirit and perseverance, the entrepreneurship companies radiate their own light on the road of entrepreneurship. Farewell to 2018 and face the brand-new 2019, let us hope for the new brilliance of Tianhong entrepreneurship Incubation Platform in the 21st century.<br/>&nbsp; &nbsp; If you have a dream of starting a business, don\'t hesitate to seize the opportunity to start a business incubation platform and live up to your splendor.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYLGJWgkXGdDceA8172','1','2019-05-29 09:59:57','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('123','84','0','taijiquan Competition kicked off in 2019','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 10:00:40','admin','','/html/upload/images/201907/15590952834831.jpg','1','1','  In order to promote Chinese traditional culture, enrich Tianhong Sunshine Sports Activities, and cultivate the excellent quality of teamwork and positive progress of employees, the first Taijiquan Competition of Century Tianhong was officially launched in the company Park on April 22. For this Taijiquan competition, the company first carries out training for Chen Hongpai Taijiquan 81. Through propaganda and mobilization, employees are fully aware of the importance of Taijiquan for physical fitness and teamwork, and effectively mobilize the enthusiasm of various departments. The participants are divided into four teams: system division team, key account division team, business division team and functional department team. Ministries','0','<p>&nbsp; &nbsp; In order to promote Chinese traditional culture, enrich Tianhong Sunshine Sports Activities, and cultivate the excellent quality of teamwork and positive progress of employees, the first Taijiquan Competition of Century Tianhong was officially launched in the company Park on April 22.</p><p>&nbsp; &nbsp; For this Taijiquan competition, the company first carries out training for Chen Hongpai Taijiquan 81. Through propaganda and mobilization, employees are fully aware of the importance of Taijiquan for physical fitness and teamwork, and effectively mobilize the enthusiasm of various departments. The participants are divided into four teams: system division team, key account division team, business division team and functional department team. Employees from all departments actively cooperate and attend training on time, which lays the foundation for achieving good results in the future Taiji competitions.<br/></p><p></p><p>&nbsp; &nbsp; In this training activity, Mr. Li Yufu, Chen\'s Hongpai Taijiquan successor, was invited to direct the teaching. At the training site, Mr. Li and his staff carefully communicated and carefully guided, \"Tai Chi Rise, Wild Horse Bristle, White Crane Bright Wings, Left and Right Knee Pacing\" and other moves, like a long, flowing water, full of aesthetic feeling. Every day, employees of all departments form a square array to study on time, which forms a beautiful scenery line in the company park.</p><p></p><p>&nbsp; &nbsp; As an important part of Wushu, Taijiquan has a long history, extensive and profound, and is the treasure of the Chinese nation. This Taijiquan activity into Tianhongyuan will not only make employees strong and healthy, but also further promote the extensive and in-depth development of the enterprise culture of Tianhong in the century.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYzzOpkeWefOxetiy687','1','2019-05-29 10:00:40','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('156','87','0','520 after-sales outlets','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:03','admin','','/html/upload/images/201907/15591169541800.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYztbAWrIud1FqAwM189','1','2019-05-29 16:02:03','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('157','87','0','A full package of 150 yuan','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:43','admin','','/html/upload/images/201907/15591169739359.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYXe8jxOmWqQ070gQ904','1','2019-05-29 16:02:43','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('158','87','0','Free exchange for 15 days','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:01','admin','','/html/upload/images/201907/15591169933799.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYLDoNiWI7NO4xBfM994','1','2019-05-29 16:03:01','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('159','87','0','7 days no reason to return goods','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:22','admin','','/html/upload/images/201907/15591170149117.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYmDaJUfapbwNpp7x939','1','2019-05-29 16:03:22','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('160','87','0','Reservation Maintenance Service','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:41','admin','','/html/upload/images/201907/15591170337490.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcGhrO1KVcIWghek879','1','2019-05-29 16:03:41','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('161','79','0','project manager','','','admin','1','11','','0','0','','0','','','','','0','2019-06-13 16:23:39','admin','','','1','1','the responsibilities of business manager \"AE\" are: negotiating, contacting, proposing and collecting money with customers; formulating strategies, coordinating resources, assigning work and supervising the process. From this we can see that a real \"AE\" is not as simple as a \"pull business\" salesman. He should be familiar with sales, marketing, planning, design, production, media and other professional knowledge, but also have a certain interpersonal skills.','0','<p>The responsibilities of business manager \"AE\" are: negotiating, contacting, proposing and collecting money with customers; formulating strategies, coordinating resources, assigning work and supervising the process. From this we can see that a real \"AE\" is not as simple as a \"pull business\" salesman. He should be familiar with sales, marketing, planning, design, production, media and other professional knowledge, but also have a certain interpersonal skills.</p>','archive/show_job.html','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQucDYsG9O6OUqzO569','1','2019-06-13 16:23:39','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('164','85','0','A certain honor','','','admin','1','0','','0','0','','0','','','','','0','2019-07-03 14:27:51','admin','','/html/upload/images/201907/gushi.jpg','1','1','Honour Explanation Text...','0','<p style=\"text-align: center;\"><br/><img src=\"/html/upload/images/201907/gushi.jpg\"/></p><p><br/></p><p>Honour Explanation Text...</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYO70f2XfrUVxUUz6867','1','2019-07-03 14:27:51','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('165','58','0','solution 2','','','admin','1','2','','0','0','','0','','','','','0','2019-07-09 18:33:20','admin','','','1','1','solutions are described in two words.','0','<p>Solutions are described in two words.</p>','0','0','0','','0','0','','','','','0','5','html/upload/attachment/201905/15579676979434.zip','0','N;','','0','0','0','0000-00-00','0','CMSEASYQN2pfl790LO5Ouo231','1','2019-07-09 18:33:20','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('166','58','0','solution 1','','','admin','1','30','','0','0','','0','','','','','0','2019-07-25 16:23:16','admin','','/html/upload/images/201907/14360857154349.jpg','1','1','text description of the solution...','0','<p>Text description of the solution...</p><p>二</p>','0','0','0','','0','0','','','','','0','7','html/upload/attachment/201907/15628273460708.gif','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360807979603.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360854145721.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14363453760256.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYQ7C6mNjnb3EPO0p724','1','2019-07-25 16:23:16','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('167','58','0','solution 3','','','admin','1','0','','0','0','','0','','','','','0','2019-07-09 18:41:44','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYH6rFJkqJoC5fDzk552','1','2019-07-09 18:41:44','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('168','72','0','News 1','','','admin','1','0','','0','0','','0','','','','','0','2019-07-15 08:22:23','admin','','','-1','1','News /p','0','<p>News </p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYjRpay6916R4orui585','1','2019-07-15 08:22:23','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('169','62','0','Ah!','','','admin','1','0','','0','0','','0','','','','','0','2019-07-17 16:10:15','admin','','','-1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYDXXd2Gnc7oq8yrr534','1','2019-07-17 16:10:15','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('170','62','0','MackBook','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 21:53:42','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','As a lightweight Mac, apple offers two distinct types of laptops that vary in weight and size, but differ in size and price. So whats the difference between MacBook and MacBook Air? How can I choose t…','0','<p>As a lightweight Mac, apple offers two distinct types of laptops that vary in weight and size, but differ in size and price. So what&#39;s the difference between MacBook and MacBook Air? How can I choose the Mac that suits me best between them.</p><p><br/></p><p>Should I choose MacBook Air (2018) or 12 inch MacBook?</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15506336226893.jpg\"/></p><p><br/></p><p>If you&#39;re sure you want the lightest and smallest Mac, buy a MacBook. But remember, the MacBook Air will give you a bigger screen, and it really won&#39;t be too big.</p><p><br/></p><p>MacBook doesn&#39;t have many advantages, except for more storage at the entry level.</p><p><br/></p><p>Since Apple updated the MacBook Air in 2018, we can recommend it wholeheartedly. For a typical consumer, it&#39;s powerful enough to get the best battery life on a Mac laptop, and it supports egpu and additional displays, so it&#39;s more to choose from.</p><p><br/></p><p>MacBook Air (2018) vs 12 inch macbook</p><p><br/></p><p>When buying a MacBook, it&#39;s hard to make a decision between a 13 inch MacBook Air and a 12 inch MacBook if you don&#39;t think you&#39;re a professional user. Both are thin, light and powerful machines with many things in common, but which one suits you best?</p><p><br/></p><p>Before Apple launched the new MacBook Air in October 2018, we uncompressed and recommended MacBook as a better choice for aging air. But the new MacBook Air changed in October 2018. Now that there are cheaper, more powerful MAC laptops, the question of which MacBook is the best has changed.</p><p><br/></p>','0','0','0','','0','0','','','8688','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:0:\"\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:0:\"\";}}','','0','0','0','0000-00-00','0','CMSEASYUuGuOdypfvk3j5i200','1','2020-01-18 21:53:42','','my_shopping_model,my_shopping_color','5','2','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"Joybuy\",\"buyurls\":\"https://www.joybuy.com/384087.html\"}}','1:Frivolous,+,100,2:Pro,+,500,','1:powder,+,50,/html/upload/images/201907/15506335969988.jpg2:gold,+,0,/html/upload/images/201907/15590079031945.jpg3:silver,+,0,/html/upload/images/201907/15506335969988.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('171','62','0','Iphone11','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 21:53:56','admin','','/html/upload/images/201907/15506330655517.jpg','1','1','As a lightweight Mac, apple offers two distinct types of laptops that vary in weight and size, but differ in size and price. So whats the difference between MacBook and MacBook Air? How can I choose t…','0','<p>Camera</p><p><br/></p><p>The iPhone 11 uses a 12 million ultra wide angle camera + 12 million pixel wide angle camera. The ultra wide angle lens supports twice the optical zoom, and the viewing angle reaches 120 degrees. It supports 4K @ 60 frame video shooting, slow motion, HDR video shooting, and short video shooting. In front of the camera, apple uses a 12 megapixel truedepth camera, which supports 4K @ 60 and slow motion shooting. [4]</p><p><br/></p><p>processor</p><p><br/></p><p>The iPhone 11 processor uses A13 bionic third-generation neural network engine [5], and Apple claims that its CPU and GPU are more than the industry&#39;s flagship chips. [6]</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15506330655517.jpg\"/></p><p><br/></p><p>Battery aspect</p><p><br/></p><p>The iPhone 11 has an extra hour of endurance compared to the iPhone XR. In terms of charging, apple said that it can charge up to 50% of the electricity in 30 minutes, but it needs to use a power adapter with 18 watts or more (to be purchased separately). [4]</p><p><br/></p><p>Display</p><p><br/></p><p>Liquid retina HD display</p><p><br/></p><p>Pixel density 326ppi</p><p><br/></p><p>6.1 inch (diagonal) LCD full screen</p><p><br/></p><p>Multi touch display with iPS technology</p><p><br/></p><p>1792 x 828 pixel resolution, 326 PPI</p><p><br/></p><p>1400:1 contrast (typical)</p><p><br/></p><p>Original color display</p><p><br/></p><p>Wide gamut display (P3)</p><p><br/></p><p>Touch touch</p><p><br/></p><p>625 nit maximum brightness (typical)</p><p><br/></p><p>Oil and fingerprint resistant coating</p><p><br/></p><p>Support simultaneous display of multi language text</p><p><br/></p><p>The iPhone 11 display uses a curvy rounded design with four rounded corners in a standard rectangle. When measured according to the standard rectangle, the diagonal length of the screen is 6.06 inches (the actual viewing area is small).</p><p><br/></p><p>Splash, water and dust proof</p><p><br/></p><p>The effect reaches IP68 level under IEC 60529 standard (the maximum underwater residence time of 2 meters can be up to 30 minutes)</p><p><br/></p>','0','0','0','','0','0','','','8688','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:0:\"\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:0:\"\";}}','','0','0','0','0000-00-00','0','CMSEASYgO22B3EqLutte4W722','1','2020-01-18 21:53:56','','my_shopping_model,my_shopping_color','5','2','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"Joybuy\",\"buyurls\":\"https://www.joybuy.com/662374129.html\"}}','1:Se,+,100,2:Plus,+,500,','1:powder,+,50,/html/upload/images/201907/15506335969988.jpg2:gold,+,0,/html/upload/images/201907/15590079031945.jpg3:silver,+,0,/html/upload/images/201907/15506335969988.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('334','62','0','CH-17','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:22:11','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要','0','<p>从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器</p><p>。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要比只查看数据包物理地址的交换机慢。但是，对于那些结构复杂的网络，使用路由器可以提高网络的整体效率。路由器的另外一个明显优势就是可以自动过滤网络广播。总体上说，在网络中添加路由器的整个安装过程要比即插即用的交换机复杂很多。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">有的路由器仅支持单一协议，但大部分路由器可以支持多种协议的传输，即多协议路由器。由于每一种协议都有自己的规则，要在一个路由器中完成多种协议的算法，势必会降低路由器的性能。路由器的主要工作就是为经过路由器的每个数据帧寻找一条最佳传输路径，并将该数据有效地传送到目的站点。由此可见，选择最佳路径的策略即路由算法是路由器的关键所在。为了完成这项工作，在路由器中保存着各种传输路径的相关数据－－路径表（Routing Table），供路由选择时使用。路径表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路径表可以是由系统管理员固定设置好的。</span><br/></p><p>静态路由表：由系统管理员事先设置好固定的路径表称之为静态（static）路径表。</p><p>动态路由表：动态（Dynamic）路径表是路由器根据网络系统的运行情况而自动调整的路径表。</p><p>路由器是一种多端口设备，它可以连接不同传输速率并运行于各种环境的局域网和广域网，也可以采用不同的协议。路由器属于O S I 模型的第三层--网络层。指导从一个网段到另一个网段的数据传输，也能指导从一种网络向另一种网络的数据传输。&nbsp;</p><p>第一，网络互连：路由器支持各种局域网和广域网接口，主要用于互连局域网和广域网，实现不同网络互相通信；<br/>　　第二，数据处理：提供包括分组过滤、分组转发、优先级、复用、加密、压缩和防火墙等功能；<br/>　　第三，网络管理：路由器提供包括路由器配置管理、性能管理、容错管理和流量控制等功能。<br/>　　所谓“路由”，是指把数据从一个地方传送到另一个地方的行为和动作，而路由器，正是执行这种行为动作的机器，它的英文名称为Router,是一种连接多个网络或网段的网络设备，它能将不同网络或网段之间的数据信息进行“翻译”，以使它们能够相互“读懂”对方的数据，从而构成一个更大的网络。<br/>　　为了完成“路由”的工作，在路由器中保存着各种传输路径的相关数据－－路由表（Routing Table），供路由选择时使用。路由表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路由表可以是由系统管理员固定设置好的，也可以由系统动态修改，可以由路由器自动调整，也可以由主机控制。在路由器中涉及到两个有关地址的名字概念，那就是：静态路由表和动态路由表。由系统管理员事先设置好固定的路由表称之为静态（static）路由表，一般是在系统安装时就根据网络的配置情况预先设定的，它不会随未来网络结构的改变而改变。动态（Dynamic）路由表是路由器根据网络系统的运行情况而自动调整的路由表。路由器根据路由选择协议（Routing Protocol）提供的功能，自动学习和记忆网络运行情况，在需要时自动计算数据传输的最佳路径。</p><p><br/></p><p><br/></p>','0','0','0','','0','0','','','998','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYwYXTmVmdpkOSDhl727','1','2020-01-16 22:22:11','','my_shopping_model,my_shopping_color','0','2','585','','0.00','0.00','','{}','1:300M,+,5,2:450M,+,10,3:500M,+,15,4:600M,+,20,5:700M,+,25,6:800M,+,30,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('335','62','0','CH-18','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:30:10','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS','0','<p>路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。&nbsp;</p><p>同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS可以使我们在路由器的FLASH中不存在ISO时，先引导起来，进入恢复模式，来使用TFTP或X-MODEM等方式去给FLASH中导入ISO文件。所以，路由器的启动过程应该是这样的：</p><p>路由器在加电后首先会进行POST。Power On Self Test (上电自检，对硬件进行检测的过程)。</p><p>POST完成后，首先读取ROM里的BootStrap程序进行初步引导。</p><p>初步引导完成后，尝试定位并读取完整的ISO镜像文件。在这里，路由器将会首先在FLASH中查找ISO文件，如果找到了ISO文件的话，那么读取ISO文件，引导路由器。</p><p>如果在FLASH中没有找到ISO文件的话，那么路由器将会进入BOOT模式，在BOOT模式下可以使用TFTP上的ISO文件。或者使用TFTP/X-MODEM来给路由器的FLASH中传一个ISO文件(一般我们把这个过程叫做灌ISO)。传输完毕后重新启动路由器，路由器就可以正常启动到CLI模式。</p><p>当路由器初始化完成ISO文件后，就会开始在NVRAM中查找STARTUP-CONFIG文件，STARTUP-CONFIG叫做启动配置文件。该文件里保存了我们对路由器所做的所有的配置和修改。当路由器找到了这个文件后，路由器就会加载该文件里的所有配置，并且根据配置来学习、生成、维护路由表，并将所有的配置加载到RAM(路由器的内存)里后，进入用户模式，最终完成启动过程。</p><p>如果在NVRAM里没有STARTUP-CONFIG文件，则路由器会进入询问配置模式，也就是俗称的问答配置模式，在该模式下所有关于路由器的配置都可以以问答的形式进行配置。不过一般情况下我们基本上是不用这样的模式的。我们一般都会进入CLI&nbsp;[1]&nbsp;&nbsp;(Comman Line Interface)命令行模式后对路由器进行配置。</p><p><br/></p><p>工作原理示例</p><p>（1）工作站A将工作站B的地址12.0.0.5连同数据信息以数据包的形式发送给路由器1。</p><p>（2）路由器1收到工作站A的数据包后，先从包头中取出地址12.0.0.5，并根据路径表计算出发往工作站B的最佳路径：R1-&gt;R2-&gt;R5-&gt;B；并将数据包发往路由器2。</p><p>（3）路由器2重复路由器1的工作，并将数据包转发给路由器5。</p><p>（4）路由器5同样取出目的地址，发现12.0.0.5就在该路由器所连接的网段上，于是将该数据包直接交给工作站B。</p><p>（5）工作站B收到工作站A的数据包，一次通信过程宣告结束。</p><p><br/></p>','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9nOCjsT6XTOiGFs105','1','2020-01-16 22:30:10','','my_shopping_model,my_shopping_color','0','2','88','','0.00','0.00','','{}','1:100M,+,5,2:150M,+,10,3:200M,+,15,','1:蓝,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('336','62','0','CH-19','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:28:57','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，交通警察。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即','0','<p>路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，&quot;交通警察&quot;。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即网络层。这一区别决定了路由和交换机在移动信息的过程中需使用不同的控制信息，所以说两者实现各自功能的方式是不同的。</p><p>路由器（Router）又称网关设备（Gateway）是用于连接多个逻辑上分开的网络，所谓逻辑网络是代表一个单独的网络或者一个子网。当数据从一个子网传输到另一个子网时，可通过路由器的路由功能来完成。因此，路由器具有判断网络地址和选择IP路径的功能，它能在多网络互联环境中，建立灵活的连接，可用完全不同的数据分组和介质访问方法连接各种子网，路由器只接受源站或其他路由器的信息，属网络层的一种互联设备。</p><p>路由器分本地路由器和远程路由器，本地路由器是用来连接网络传输介质的，如光纤、同轴电缆、双绞线；远程路由器是用来连接远程传输介质，并要求相应的设</p><p>模拟器中的路由器&nbsp;</p><p>备，如电话线要配调制解调器，无线要通过无线接收机、发射机。</p><p>路由器是互联网的主要结点设备。路由器通过路由决定数据的转发。转发策略称为路由选择（routing），这也是路由器名称的由来（router，转发者）。作为不同网络之间互相连接的枢纽，路由器系统构成了基于TCP/IP 的国际互联网络Internet&nbsp;的主体脉络，也可以说，路由器构成了Internet的骨架。它的处理速度是网络通信的主要瓶颈之一，它的可靠性则直接影响着网络互连的质量。因此，在园区网、地区网、乃至整个Internet研究领域中，路由器技术始终处于核心地位，其发展历程和方向，成为整个Internet研究的一个缩影。在当前我国网络基础建设和信息建设方兴未艾之际，探讨路由器在互连网络中的作用、地位及其发展方向，对于国内的网络技术研究、网络建设，以及明确网络市场上对于路由器和网络互连的各种似是而非的概念，都有重要的意义。</p><p>出现了交换路由器产品，从本质上来说它不是什么新技术，而是为了提高通信能力，把交换机的原理组合到路由器中，使数据传输能力更快、更好。</p><p><br/></p>','0','0','0','','0','0','','','280','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhC2dWvXrEcx0C74295','1','2020-01-16 22:28:57','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','{}','1:500M,+,100,2:1000M,+,200,','1:黑,+,0,2:白,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('337','62','0','U-ART','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:20:32','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','音响特指电器设备组合发出声音的一套音频系统音响系统大体包含：1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭','0','<p>音响特指电器设备组合发出声音的一套音频系统</p><p>音响系统大体包含：</p><p>1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）</p><p>2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）</p><p>3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）&nbsp;</p><p>4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭、低音炮等等）。技术的的发展历史可以分为电子管、晶体管、集成电路、场效应管四个阶段。</p><p><br/></p><p>音响是一个简化后的日常词语，是音响系统的简称。即代指一整套可以还原播放音频信号的设备。</p><p>随着社会的进步，人们向往生活更多姿多彩。歌舞作为一种流传数千年的娱乐形式，深入各族人民的生活。但是随着科技的发展和进步，人们对于歌舞的表演形式和场地要求越来越多、越来越高。音响系统随着人们的需求不断改进和完善。大到满足上万人演唱会现场扩声需求，小到满足个人家庭弹奏乐器、K歌的需要。</p><p><br/></p>','0','0','0','','0','0','','','1600','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHX6gF0nEoJyFagO648','1','2020-01-16 22:20:32','','my_shopping_model,my_shopping_color','0','2','88','','0.00','0.00','','{}','1:高音,+,0,2:中音,+,0,3:普音,+,0,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('338','62','0','电热水壶','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:06:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随','0','<p>电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。</p><p>电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随着生活的需要，现在的电水壶也正在向多功能方向发展，如防漏、防烫、锁水等。电水壶具有加热速度快，保温效果好，过滤功能强，式样多等优点。</p><p>电热水壶的使用功能虽然基本相同，但从内在电路结构设计可以分为鸣笛式电水壶、防干烧鸣笛电水壶、塑胶电热水壶等几大类。</p><p>（1）鸣笛式电热水壶。</p><p>由铝制板经拉伸制成，电热元件采用浸水式镀镍钢密封式电热管。电热管安装在水壶底部，和壶体结合部垫有耐热密封圈以防止漏水。该类型电热水壶壶盖上设置有一个条状振动簧片自鸣器（气流振动式鸣笛装置），当水温达到100℃以上时气流鸣笛即会鸣响。由于该类水壶一般没有设置限温控制器，必须人为地手动切断电源。该类电热水壶结构简单、价格低廉，居民家庭中使用相当广泛。</p><p>（2）防干烧鸣笛式电热水壶。&nbsp;</p><p>在鸣笛式电水壶设计原理基础上，增设了限温自动控制器（主要是双金属恒温控制器或者磁控恒温自动开关），当水沸腾时，产生的水蒸气使感温元件的双金属片变形，驱动微型开关切断电源，极大地提高了电热水壶的安全性能。一些高品质的电热水壶中的限温控制器采用一种类似记忆合金的新型热敏材料（自动恒温控制开关），当壶内水面低于电热管（电热管温度超过100℃以上）时，自动恒温控制开关便会自动切断电源，保护电热水壶不被烧毁。</p><p>（3）塑胶型电热水壶。</p><p>塑胶型电热水壶最大的特点是携带方便、安全性能可靠。壶体设置的电源信号指示灯可方便观察通电状态，上下分体式结构可以3600旋转，壶体采用的食品级卫生塑质材料熔点在200℃以上。这种新型电热水壶采用隐藏式不锈钢电发热盘，并设置有蒸汽感应控制开关，具有自动断电、防干烧断电、热熔断电保护、接地保护等多重保护功能。&nbsp;</p><p><br/></p>','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYof911iYjQMp1JA5768','1','2020-01-16 22:06:48','','my_shop_model,my_shoppingcolor','5','2','88','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东\",\"buyurls\":\"https://www.jd.com\"}}','1:电子,+,10,2:机械,+,5,','1:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('339','62','0','智能吸顶灯','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:21:38','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目','0','<p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。</p><p>目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。</p><p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的就是led吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。&nbsp;&nbsp;</p><p>它起源于1995年-1996年间，由于形似太阳，因此当时行业人士称之为“太阳灯”， 2000年前的吸顶灯款式单一、材料单一，大多采用中低档材料，光源一般采用节能灯管和灯泡，并以电感吸顶灯为主。</p><p>LED吸顶灯是吸附或嵌入屋顶天花板上的灯饰，它和吊灯一样，也是室内的主体照明设备，是家庭、办公室、娱乐场所等各种场所经常选用的灯具。LED吸顶灯一</p><p><br/></p><p>般直径在200mm左右的吸顶灯适宜在走道、浴室内使用，而直径400mm的则装在不小于16平方米的房间顶部为宜。 市面上的LED吸顶灯常见有D形管和环形管两种还有大小管区别。选购LED吸顶灯时要三看。一看产品标识是否齐全，正规产品的标识往往比较规范，应标识：商标和厂名、产品型号规格、额定电压、额定频率、额定功率。二看灯具电源线是否有CCC安全认证标志，外部导线截面积应≥0.75平方毫米。三看灯具带电体是否外露，光源装入灯座后，手指应不能触及带电的金属灯头。</p><p>1)功能细分。吸顶灯传统的照明功能已不够满足消费者，将客厅吸顶灯与日常用品相组合也日趋流行。</p><p>2)造型豪华。随着生活的日益富足，消费者审美需求增加，客厅吸顶灯日趋豪华、高档。</p><p>3)崇尚自然。为迎合都市消费者返朴归真、崇尚自然的心理，很多吸顶灯采用了自然化的造型。另外，灯罩的选材也广泛采用纸质、木质、纱质等自然材质。</p><p>4)色彩丰富。为与丰富多彩的生活同步，现如今很多吸顶灯披起了“七彩”外衣。&nbsp;</p><p>5)高技术化。随着科学技术的发展，电子科技被广泛应用于客厅吸顶灯设计，如适应不同电压的吸顶灯，可调节亮度的吸顶灯，放射远的红外红光吸顶灯等等。</p><p>6)节能化。目前节能吸顶灯很受消费者欢迎，如采用3LED芯电的长寿节能灯，既节约能源，又可以根据需要选择亮度。</p><p>7)环保化。环保是吸顶灯设计不变的话题，这与我们栖息的地球有关，已经引起广大消费者重视，这将会成为未来家居照明的主要发展方向。</p><p><br/></p>','0','0','0','','0','0','','','13','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9WBOPjG6dQeIfDn585','1','2020-01-17 09:21:38','','my_shopping_model,my_shopping_color','0','2','0','','0.00','0.00','','{}','1:节能,+,0,2:普通,+,0,','1:黑,+,5,2:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('340','62','0','智能加湿器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:15:29','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿','0','<p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。&nbsp;<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。&nbsp;</p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p><br/></p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','460','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1V2E0Sx8DFX8ODz935','1','2020-01-16 22:15:29','','my_shopping_model,my_shopping_color','0','2','0','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/729828.html\"},\"1\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.26.1c04a98aZGJnlP&id=605208384141&skuId=4245337065638&user_id=3919645743&cat_id=2&is_b=1&rn=73570d905a6017c54c1e28ca58978061\"}}','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('341','62','0','智能洗衣机','','','admin','1','13','','0','0','','1','','','','','0','2020-01-16 22:12:24','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超','0','<p>洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。</p><p>中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。&nbsp;&nbsp;</p><p>从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超过了96%，农村市场也已经超过了53%;随着国家开展家电下乡、扩大内需的政策，洗衣机企业将目光均投向了拥有较大消费潜力的农村市场。未来几年，我国洗衣机市场需求增长空间将主要来自于：以城镇化和农村市场为主的首次需求，以及以城镇市场消费升级为主的更新需求;整个洗衣机市场需求在未来几年将继续保持温和增长态势。</p><p>2010年，我国洗衣机总销量约5000多万台，同比增长接近30%，增长幅度创历史最高水平;其中内销实现3300多万台，同比增长约28%，出口实现1600多万台，同比增长30%以上，均创历史最高增长速度。</p><p>从不同产品来看，2010年我国滚筒洗衣机总销量达到1100多万台，同比增长50%以上，占洗衣机市场销量比重由上年的不足20%上升至20%以上。其中，第四季度各月销量均超过110万台，所占洗衣机市场总销量的份额均超过21%。</p><p>节水将成未来洗衣机重点发展方向，洗衣机产业目标主要涵盖节电节水、产品功能、绿色设计三大方向。在中国家用电器协会编制的冰箱、空调、洗衣机的技术路线图中，就节电节水方面，制定了到 2015年，波轮式双桶洗衣机达到国家能效2级，波轮式全自动洗衣机达到国家能效1级，能效1级的滚筒式全自动洗衣机要达到欧盟A+等级耗电、耗水要求， 滚筒式洗干一体机要达到GB/T23118国标A级耗电、耗水要求。到2020年，滚筒洗衣机达到欧盟A+++等级耗电、耗水要求，波轮式全自动洗衣机达到国标A+等级耗电、耗水要求，滚筒式洗干一体机达到国标A+等级耗电、耗水要求。在产品功能方面，洗衣机的发展方向是大容量，低噪声、低振动。</p><p><br/></p><p>机械力、洗涤液、水是洗衣机洗涤过程中的三要素。洗衣机运动部件产生的机械力和洗涤液的作用使污垢与衣物纤维脱离。加热洗涤液，可增强去污效果。织物不同，适宜液温也不同，反映洗衣机洗涤性能（即洗净衣物的能力）的主要指标是洗净率（或洗净比）和织物磨损率。洗净率是洗衣机在额定洗涤状态下，利用光电反射率计（或白度仪）测定洗涤前后人工污染布及其原布的反射率。洗衣机发展史　从古到今，洗衣服都是一项难于逃避的家务劳动，而在洗衣机出现以前，对于许多人而言，它并不像田园诗描绘的那样充满乐趣，手搓、棒击、冲刷、甩打…这些不断重复的简单的体力劳动，留给人的感受常常是：辛苦劳累。&nbsp;</p><p>1858年，一个叫汉密尔顿·史密斯的美国人在匹茨堡制成了世界上第一台洗衣机，该洗衣机的主件是一只圆桶，桶内装有一根带有桨状叶子的直轴，轴是通过摇动和它相连的曲柄转动的。同年史密斯取得了这台洗衣机的专利权。但这台洗衣机使用费力，且损伤衣服，因而没被广泛使用，但这却标志了用机器洗衣的开端。次年在德国出现了一种用捣衣杵作为搅拌器的洗衣机，当捣衣杵上下运动时，装有弹簧的木钉便连续作用于衣服。19世纪末期的洗衣机已发展到一只用手柄转动的八角形洗衣缸，洗衣时缸内放入热肥皂水，衣服洗净后，由轧液装置把衣服挤干。</p><p>1874年，“手洗时代”受到了前所未有的挑战，美国人比尔·布莱克斯发明了木制手摇洗衣机。布莱克斯的洗衣机构造极为简单，是在木筒里装上6块叶片，用手柄和齿轮传动，使衣服在筒内翻转，从而达到“净衣”的目的。这套装置的问世，让那些为提高生活效率而冥思苦想的人士大受启发，洗衣机的改进过程开始大大加快.</p><p>1880年，美国又出现了蒸气洗衣机，蒸气动力开始取代人力。经历了上百年的发展改进，现代蒸汽洗衣机较早期有了无与伦与的提高，但原理是相同的。现代蒸汽洗衣机的功能包括蒸汽洗涤和蒸汽烘干，采用了智能水循环系统，可将高浓度洗涤液与高温蒸气同时对衣物进行双重喷淋，贯穿全部洗涤过程，实现了全球独创性的“蒸汽洗”全新洗涤方式。与普通滚筒洗衣机在洗涤时需要加热整个滚筒的水不同，蒸汽洗涤是以深层清洁衣物为目的，当少量的水进入蒸汽发生盒并转化为蒸汽后，通过高温喷射分解衣物污渍。蒸汽洗涤快速、彻底，只需要少量的水，同时可节约时间。对于放在衣柜很长时间产生褶皱、异味的冬季衣物，能让其自然舒展，抚平褶皱。“蒸汽烘干”的工作原理则是把恒定的蒸汽喷洒在衣物上，将衣物舒展开之后，再进行恒温冷凝式烘干。通过这种方式，厚重衣物不仅干得更快，并且具有舒展和熨烫的效果。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYITUdOO4dafAhtdr232','1','2020-01-16 22:12:24','','my_shopping_model,my_shopping_color','5','2','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/100004652001.html\"}}','1:智能,+,10,2:机械,+,5,3:全自动,+,15,','1:白,+,10,2:黑,+,5,','');-- 
INSERT INTO `cmseasy_archive` VALUES('416','62','0','路由器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:23:27','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地','0','','0','0','0','','0','0','','','999','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYNfW06Lofg2dRM52677','1','2020-01-17 09:23:27','','my_shop_model,my_shoppingcolor','0','2','188','','0.00','0.00','','{}','1:300M,+,10,2:500M,+,20,','1:蓝,+,0,2:黑,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('417','65','0','产品名称三十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:05:27','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','560','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJz9tU0sEFmG4jYr924','1','2019-08-16 23:05:27','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('418','65','0','产品名称三十','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:13:43','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYoqRcqqx04wOaAxg150','1','2019-05-29 13:13:43','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('419','65','0','产品名称二十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:11','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYdpBjq9drwOlW0lf664','1','2019-08-16 23:06:11','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('420','65','0','产品名称二十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:10','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYbM6nNh7Q3yzd5ea383','1','2019-08-16 23:06:10','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('421','63','0','产品名称二十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:13','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYYcWihLq5Dgx5rzO811','1','2019-08-16 23:06:13','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('422','63','0','产品名称二十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:33:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYOPdjHvE4Pn4u0dk942','1','2019-08-16 23:33:48','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('423','63','0','产品名称二十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:02','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY7g8BajgqgwA2LsQ659','1','2019-08-17 00:02:02','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('424','63','0','产品名称二十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:03','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYm8MzExt0fTjru5P101','1','2019-08-17 00:02:03','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('425','63','0','产品名称二十三','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:05','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','120','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYXDCS4WRJNTKkc4P113','1','2019-08-17 00:02:05','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('426','63','0','产品名称二十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:04','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','166','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYo9eP29z3HPIgb4V659','1','2019-08-17 00:02:04','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('427','65','0','产品名称二十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:34','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','177','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYVUKHL6UcJ7fOOHT585','1','2019-08-17 00:18:34','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('428','65','0','产品名称二十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:35','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','','0','','0','0','0','','0','0','','','199','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYBkQvDdHVOAUgwxb296','1','2019-08-17 00:18:35','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('429','65','0','产品名称十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJfx8fl6qGjFjhRB691','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('430','65','0','产品名称十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590080664809.jpg','1','1','','0','','0','0','0','','0','0','','','1600','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590080664809.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYpkR2pX6G54WXOpL136','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('431','64','0','产品名称十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','210','','0','','','0','a:1:{i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHmUFxBzunoBf4U0359','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('432','64','0','产品名称十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','220','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYjzChf9aIGI4b0p9136','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('433','64','0','产品名称十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:42','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','','0','','0','0','0','','0','0','','','270','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhgNcxGA33CN0WVG368','1','2019-08-17 00:18:42','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('434','64','0','产品名称十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:40','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY6IDNvIpFJj5HxMg820','1','2019-08-17 00:18:40','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('435','64','0','产品名称十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:41','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','250','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYteUoUOdnEtJQ5DO966','1','2019-08-17 00:18:41','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('436','65','0','产品名称十三','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:36:10','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','260','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYu8jmokWatEiOQek651','1','2019-05-29 13:36:10','','','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('437','64','0','产品名称十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:44','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYURynpBhTaiRU1ms696','1','2019-08-17 00:18:44','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('438','64','0','产品名称十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:45','admin','','/html/upload/images/201907/15506330561844.jpg','1','1','','0','','0','0','0','','0','0','','','330','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330561844.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY521mO3OWstsuJvy507','1','2019-08-17 00:18:45','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('439','64','0','产品名称九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:52','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','','0','','0','0','0','','0','0','','','340','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGXyVs7sVq5KE1nj376','1','2019-08-17 00:18:52','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('440','64','0','产品名称八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:53','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','360','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhuFUlRzDbrQ1jM3690','1','2019-08-17 00:18:53','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('441','64','0','产品名称七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:54','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','380','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY0BCt9KtrTRtjv6L213','1','2019-08-17 00:18:54','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('442','63','0','产品名称六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:55','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1TiXfBUr5DbqEzS249','1','2019-08-17 00:18:55','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('443','63','0','产品名称五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:56','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','4050','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGrWKMWNt9VGjomF275','1','2019-08-17 00:18:56','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('444','63','0','产品名称四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:57','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHTxk1P8OSnxGsGI140','1','2019-08-17 00:18:57','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('445','62','0','产品名称三','','','admin','1','0','','0','0','','0','','','','','0','2019-07-22 15:38:36','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRwbmVb35BbAF4uT843','1','2019-07-22 15:38:36','','my_shop_model,my_shoppingcolor','0','1','99','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('446','63','0','产品名称二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 02:11:03','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；产品标识应当清晰、牢固，易于识别；','0','<p>产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。</p><p>产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；<br/></p><p>产品标识应当清晰、牢固，易于识别；</p><p>产品名称包含中英文全程，或者中文拼音。另有对应于全称的企业或产品简称，如：中兴通讯股份有限公司，简称：中兴通讯，英文简称：ZTE。</p><p>企业或品牌名称具备统一的标准字体、标准色、标准大小以区别于同类企业或产品。企业和产品名称应用于企业日常产品、服务、办公、营销行为等公司运作的各个方面，形成完整统一的企业CI系统。所以产品名称是企业识别系统中最重要的一个要素。</p><p><br/></p><p>产品名称应当表明产品的真实属性，并符合下列要求：</p><p>（一）国家标准、行业标准对产品名称有规定的，应当采用国家标准、行业标准规定的名称；</p><p>（二）国家标准、行业标准对产品名称没有规定的，应当使用不会引起用户及消费者误解和混淆的常用名称或者俗名。</p><p>产品名称可以作为注册商标，但应符合商标法的规定。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYTReKg1pr3crT8CO456','1','2019-08-17 02:11:03','','my_shop_model,my_shoppingcolor','0','2','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('447','62','0','产品名称一','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:11:39','admin','','/html/upload/images/201907/15591115606261.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/html/upload/images/201907/15591115599626.jpg\"/></p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115606261.jpg\"/></center><p><br/></p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115602093.jpg\"/></center><p><br/></p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','2','10','html/upload/attachment/201908/1566304174297.png','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','1','CMSEASYOK2nysJX2XzMN7X248','1','2020-01-17 09:11:39','admin','my_shopping_model,my_shopping_color','18','2','996','<p>详细说明</p><p><img src=\"/html/upload/images/201908/15662076301300.jpg\" title=\"15662076301300.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076302696.jpg\" title=\"15662076302696.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076306969.jpg\" title=\"15662076306969.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076314121.jpg\" title=\"15662076314121.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076318531.jpg\" title=\"15662076318531.jpg\"/></p><p><br/></p>','0.00','0.00','83,1#my_shopping_model,2:便携,jia,155;my_shopping_color,6:金,jia,0-73,1#my_shopping_model,2:I7,jia,10;my_shopping_color,1:金,jia,88','{}','1:I5,+,5,/html/upload/images/201908/15662076314121.jpg2:I7,+,10,/html/upload/images/201908/15662076301300.jpg3:I9,+,15,/html/upload/images/201908/15662076318531.jpg','1:金,+,88,/html/upload/images/201907/15590079031945.jpg2:黑,+,8,/html/upload/images/201907/15506336226893.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('267','145','0','500만 달러를 들여 AI 창업 ObEN에 투자했고, 사회적 AI를 더 배치했습니다.','','','admin','1','39','','0','0','','0','','','','','0','2020-01-18 21:46:00','admin','','/html/upload/images/201907/14360803742226.jpg','1','1','기초기술에 대한 연구외에도 텐센트는 업무구동을 통해 각종 응용장면의 인공지능화를 추동할것이라고 표시했다.텐센트의 메인 비즈니스를 결합하면, 미래 회사가 게임, 사교, 콘텐츠, 플랫폼 도구형 등 4대 응용 방향에 힘을 보낼지 예상하기 어렵지 않다.특히 소셜네트워크서비스 분야에서 지난해 빅버그는 VR 버전의 페이스북을 내놓겠다고 선언하고 가상 인물 이미지 도구 Oculus Avatars를 선보였으며,올해 7월 페이스북에서는 페이스북 AR 스튜디오가 미국 이미지와 함께 세 종류의 AR 카메라 특효 서비스를 제공한다고 밝혔다.오늘날, 텐센트는','0','<p>기초기술에 대한 연구외에도 텐센트는 업무구동을 통해 각종 응용장면의 인공지능화를 추동할것이라고 표시했다.</p><p>텐센트의 메인 비즈니스를 결합하면, 미래 회사가 게임, 사교, 콘텐츠, 플랫폼 도구형 등 4대 응용 방향에 힘을 보낼지 예상하기 어렵지 않다.</p><p>특히 소셜네트워크에 관한 한 작년엔 재커버그가 VR 버전의 F를 출시하겠다고 밝힌 바 있다.<a href=\"#\" target=\"_blank\">a</a>cebook，그리고 가상인물형상도구 Oculus Avatars를 전시하였다.올해 7월 페이스북에서는 페이스북 AR 스튜디오가 미국 이미지와 함께 세 종류의 AR 카메라 특효 서비스를 제공한다고 밝혔다.이제 텐센트도 움직여야 합니다.</p><p>인공지능 초창사인 ObEN은 18일 밤 500만 달러 규모의 전략적 투자를 선언했다.이번 융자는 텐센트가 인수하고 CMC 리사장 리루이강과 펑샹자본이 뒤를 이어 투자한다.투융자정보플랫폼인 crunchbase의 데이터에 따르면 ObEN은 현재 4차 융자를 완료했는데 총금액은 1370만 달러에 이른다.S 산타캐피탈, 소프트뱅크코리아 벤처캐피털, HTC VIVE X 등도 투자했다.</p><p>공개 자료에 따르면 ObEN은 2014년 개성적인 가상의 사운드, 이미지, 개성을 구축함으로써 사용자의 인공지능 가상이미지를 창조할 수 있으며, 사용자들이 신흥 디지털 세계에서 그들의 가상이미지를 저장, 관리, 운영할 수 있도록 도와준다.ObEN은 인공지능 도구를 이용해 사용자의 사진과 음성에 따라 가상 이미지를 만들어 가입자들이 각기 다른 AR, VR 소셜 경험을 할 수 있게 한다는 것.</p><p>오븐은 주로 게이머들이 가상 이미지를 만드는 데 도움을 줬지만, 최근에는 스타들의 가상 이미지를 돕는 데 초점을 맞췄다.이 가상 이미지를 통해 스타는 팬들과 실시간으로 소통할 수 있다.언젠가는 팬들은 스타에게 조언을 구하고 피드백을 받을 수도 있을 것이다.또한,이 가상 이미지는 스타 얼굴뿐만 아니라 말하는 방식도 똑같습니다.한마디로 말하면 이런 가상형상은 대화형로보트보다 훨씬 낫다.</p><p>오븐은 또한 처음으로 음성, 계산시각, 자연언어처리기술을 융합시켜 풀 스택형 가상스타가 필요로 하는 가상 사운드, 3차원 이미지 및 개성화 기술을 개발했다고 소개했다.오븐은 이제 완전히 새로운 비즈니스 플랫폼을 만들고 있습니다.스타와 팬들은 개인화된 인공지능을 통해 모바일 하드, 보강 현실, 가상 현실, 스마트 장비, 사물네트워크 등 플랫폼에서 직접 소통할 수 있다.ObEN의 개성화된 인공지능 제품은 올해 뒤늦게 출시될 예정이다.</p><p>최신 융자는 ObEN의 제품 개발을 가속화하고, 그 스타들의 인공지능 포맷 플랫폼이 다양한 디지털 플랫폼에 광범위하게 응용될 수 있도록 돕는 데 사용될 것이다.이번 합작에 대해 텐센트 투자의 야오레이원 집행이사는 ObEN은 스타들의 인공지능을 동원한 새로운 엔터테인먼트 방식과 내용을 가져올 것이라고 말했다.</p><p>오븐은 일찍이 인간의 인공지능 소셜 플랫폼을 만들겠다고 선언했다.이 방면에 있어서, 회사는 이미 잇따라 여러 차례 배치를 진행하였다.</p><p>올해 3월 HTC Vive 생태권 총회에서 ObEN은 HTC Vive와 함께 VR, VR K 송을 함께 즐길 수 있는 위신 애플리케이션을 개발했다고 발표했다.이 프로그람에서 VR 사용자는 친한 친구에게 초청장을 발송할수 있다.초청받은 지인은 셀카와 오디오를 올리고, 완성된 이미지로 초대자와 함께 해변을 산책하거나 명소를 둘러볼 수 있다.</p><p>이어 4월 말 ObEN은 VR 사교 체험을 통합한 웨이신 채팅 서비스를 출시했다. 당연히 사용자는 HTC Vive 헤드셋을 착용해야 한다.단편 영상에서 사용자는 먼저 한 장의 셀카를 찍어 위챗으로 가상형상을 만들어 올린 뒤 HTC Vive를 휴대하면 위챗친구로부터 보내온 정보를 접수할수 있으며 음성메시지로 직접 회답할수 있다.앞으로 VR, AR 기능을 갖춘 위챗 서비스는 아시아 사용자를 대거 흡수할 수 있을지도 모른다.</p><p>오븐은 6월 말 한국 SM 엔터테인먼트와 합작한&#39;AI 스타즈&#39;를 설립한다고 발표했다.오븐은 인공지능을 이용해 SM 엔터테인먼트 소속 유명 연예인들을 위해 AI 가상이미지를 만들기로 했으며, 유령별유한공사는 이들을 관리하는&#39;AI 스타&#39;소속사인 것으로 알려졌다.<br/></p><p>이번 텐센트가 ObEN을 영입하면서 회사 소셜네트워크서비스 인공지능화를 더욱 촉진시킬 수 있을까.현재 대기업들은 인공지능 실험실 건립을 서두르고 있을 뿐 아니라, 페이스북 같은 기업들도 좀 더 구체적인 페이스북 AR 실험실을 만들고 있다.또 애플은 곧 아르키트 플랫폼을 내놓을 것으로 알려졌다.텐센트는 앞으로 별도의 AR 실험실을 설립하여 사회적 AI 업무를 한층 더 전개할 것인가?</p><p><br/></p>','0','0','0','','0','0','','','','','3','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIqsBlQGO2vpH41p972','1','2020-01-18 21:46:00','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('268','144','0','미국 산업 정보화 규모가 곧 나타날 예정인데, 게이트 관리소는 그들에게 SaaS 관리 소프트웨어 한 세트를 제공하였다','','','admin','1','11','','0','0','','0','','','','','0','2019-07-09 14:19:48','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','데이터에 따르면 2015년, 우리 나라 봉사업 동기대비 8.3% 성장해 각각 국내총생산과 2차산업의 증가치 증가속도 1.4포인트와 2.3% 포인트를 초과했으며 국내총생산에서 차지하는 비중이 50.5%에 달해 처음으로 절반 정도에 달했으며 선진국과 비교할 때 우리 나라 봉사업의 발전공간은 여전히 20~30%에 달한다.미국 산업은 오프라인 서비스업에 속한다. 전체 시장 규모가 수천억 달러에 달한다.그 이유는 음식과 소매의 여객 유동량이 많고, 접촉의 여지가 넓은 반면, 미국 업계의 여객 유동량은 상대적으로 적은 데다 종사자의 자질이 정보화를 초래했기 때문이다','0','<p>데이터에 따르면 2015년, 우리 나라 봉사업 동기대비 8.3% 성장해 각각 국내총생산과 2차산업의 증가치 증가속도 1.4포인트와 2.3% 포인트를 초과했으며 국내총생산에서 차지하는 비중이 50.5%에 달해 처음으로 절반 정도에 달했으며 선진국과 비교할 때 우리 나라 봉사업의 발전공간은 여전히 20~30%에 달한다.미국 산업은 오프라인 서비스업에 속한다. 전체 시장 규모가 수천억 달러에 달한다.그 원인은 음식과 소매 여객 유동량이 많고 접촉하는 사람이 많은 데 반해, 미국 업계의 여객 유동량은 상대적으로 적은 데다 종사자의 자질이 정보화 정도와 관리 효율이 낮기 때문이다.</p><p>현재 미국계 주요 관리방식은 종이장부와 간단한 수은, 결제 소프트웨어이다. 종이 관리는 업계 고객의 약 90%를 차지하고, 간단한 기능을 회원카드 관리에만 사용하는 단기판 관리프로그램은 약 9%를 차지한다.미 업계 의 고객 과 업소 들 의 점성 이 높 은 低频 차 소비 했 지만 일단 가입자 선택 한 점 으로 가 접수 되 는 비교적 좋 은 서비스 가 더욱 어 려 워 질 것 이기 때문에 미 전향 다른 점 업 (사진) 씨 가 예약 고객 관리, 관리 등 수요 에 보다 외 식비, 소매 를 응용 소프트웨어 적 행태 일정 으로 결제 收银 위 주로 초점 은 CRM 시스템, 收银, 성과급 을 검증, 예약 을 모두 아우 르 는 관리 소프트웨어 다.</p><p>36 크립톤이 최근에 알고 있는 노점상은 미국의 직업이다 S<a href=\"#\" target=\"_blank\">a</a>aS 제품, 주요 기능은&nbsp;SCRM 회원관리, 스마트예약, 성과급, 마케팅카드, 전능수은.게이트웨이 관리점 제품은 고객측에서 위챗공중번호와 소형프로그람이다.미용사 플래너는 고객 관계 유지, 임금 조회, 예약 이동용 플래너를 말한다.앞의 대단은 Upad 인데 주로 은수금과 예약이다.또 다른 판매장용 프론트 데스크로는 주로 PC나 스마트폰으로 전체적인 데이터 관리를 합니다.</p><p>사실 관리 의 과 정도 침전 데이터 의 과정 을 闭环 도 개발 과 생태 의 과정 을 알 리 CEO 孟凡刚 기자, 파리 튜브 점 일단 용 마케팅 도구 + SaaS 시스템, 모서리 오프 라인 업 을 미 덕수궁 건립 강 관계 를 통 해 마이크로 시스템 收银 본체 편지, 지급 보 지급 을 턱걸이 물 든 종이컵 도입 플랫폼 진정하다 매트 는 막 대한 돈 을 마지막 에 기반 SaaS 거래 데이터베이스, 소비 행위 자료 로 활용 한 데이터 분석 확장 미 익 제품, 프로그램 공급 망 했 다.예를 들어, 최근 한국의 피부 모니터링 시스템의 경우, 테스트 후에 고객 파일에 저장하고, 스마트 관리 플랫폼에 통합하여, 고객은 다시 올 때 개인의 특징에 맞추어 서비스를 할 수 있습니다.</p><p>미국업계의 변혁은 두개 진영을 형성했다. 한개 진영은 대형회관으로서 많은 오랜 고객을 축적했다.또 최근 2년 새 문을 연 점포에서 기존 회원들의 자원을 받지 못한 신규 점포를 운영할 경우 어떻게 하면 80, 90명을 대상으로 서비스를 할 수 있겠다는게 주 사업이었다. 젊은 층이 인터넷 정경 사용자이기 때문에 새 점포에는 SaaS 소프트웨어가 쉽게 도입된다.문전소는 년소화상점에 더 편중되 여있는데 일정한 기간 경 력과 자금을 축적한 다음에 로점포를 꾸린다.</p><p>정보화가 되지 않은 매장에서는 전기 데이터 입력이 가장 번거로울 수 있습니다. 게이트 관리소에서 고객들을 보내 데이터를 정리하는 데 도움을 줄 것입니다. 시간은 2-3일 정도로 예상됩니다.그다음은 소프트웨어사용의 보급이다.이 점에 관해서는 거점관리소에서 전문 양성하는데 여기에는 음향, 영상 원격강습이 포함된다.수금모식은 사적구름배치와 공유구름으로 나뉘는데 공유구름은 만원 밖에 안되고 그뒤로 해마다 1,000원의 보수비용이 들게 된다.모든 소프트웨어의 설치로 점포에서 한 사람의 비용을 절약할 수 있을 것이다.</p><p>파리 튜브 점 의 고객 은 克丽缇娜, 스 역 은 발, 경 희 미학, 밀 레 니 엄 새 자연미 등 이다.</p><p>업종별 경쟁업종에서는 미국의 사스공급업체가 보카, 오티오, 메이요베, 메이리카, 뎬메이, 메이예방 등을 판매했다.</p><p>미국 SaaS 가 되기 위한 문구 중 하나는 소프트웨어 개발 능력이다. 페이지가 간결하고 기능이 구전하며 관리에 적합한 제품을 개발하려면 고객과 회사의 점성이 높아져야 한다.둘째, 판매능력이다. 비영리영업소는 현재 사원의 방식을 채용하고 대리경로로 자기의 고객을 발전시킬수 있다. 현재 비전문사원은 100여명이다.</p><p>팀은 현재 30명, 절반 이상이 기술자이고 맹범강 CEO는 회우과학기술 CEO, 카풀에 CEO를 역임했으며 8년간의 인터넷 및 모바일 인터넷 운영관리 경험이 있다.회사는 이미 엔젤론 융자를 마쳤으며, 다음 라운드 융자를 진행할 계획이다.</p><p><br/></p>','0','0','0','','0','0','','','','본 사이트','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYEEg44pdjX3k5GMP332','1','2019-07-09 14:19:48','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('269','144','1','인터넷에 접속해 도움을 요청하면 응답은 모두 로봇입니다. 정말 좋을까요?','','','admin','1','8','','0','0','','1','','','','','0','2019-07-09 14:19:46','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','인공지능기술의 발전은 사람들의 생활과 작업방식을 끊임없이 개변시키고있으며 일정한 정도에서 사회의 발전과 진보를 추동하고있다는것은 의심할 여지가 없다.그러나 인공지능은 만능이 아니다. 기계가 인간의 사고와 감정을 갖고 있지 않기 때문이다.웹사이트의 온라인구조창구를 열었을 때 동무가 차디찬 로보트만 갖고있는것을 발견하면 아마 실망할것이다.2016년 4월, 마크 자크버그는 페이스북 F8회의에서 메신저 개발자들에게 밝은 미래를 제시하면서','0','<p>인공지능기술의 발전은 사람들의 생활과 작업방식을 끊임없이 개변시키고있으며 일정한 정도에서 사회의 발전과 진보를 추동하고있다는것은 의심할 여지가 없다.그러나 인공지능은 만능이 아니다. 기계가 인간의 사고와 감정을 갖고 있지 않기 때문이다.웹사이트의 온라인구조창구를 열었을 때 동무가 차디찬 로보트만 갖고있는것을 발견하면 아마 실망할것이다.</p><p>2016년 4월 에 마크 자크버그가F<a href=\"#\" target=\"_blank\">a</a>cebookF8회의에서 메신저 개발자들에게 밝은 미래를 제시하면서\'친구처럼 로봇과 이야기한다\'는 새로운 시대로 접어들겠다고 선언했다.세계 각지 개발자들은 페이스북 · 구글 · 마이크로소프트 등 대기업들의 인증을 받아 독자적인 모바일 애플리케이션 (응용프로그램)의 시대가 끝났다며 함께 축하하는 새로운 방식의 비즈니스 (Conversational Commerce)와 채팅로봇 (Chatbots)을 갖추고 있다.페이스북은 11개월 전 메신저 (Messenger)에서 더 경량급 애플리케이션을 개발하고 세션 입력을 금지한\'M\'의 베타 테스트에서 AI 실패율을 70%로 발표했다고 밝혔다.</p><p>wordhop.io에 대해 우리는 줄곧 두가지 사실을 알고있었다.첫 번째는 AI 가 정말 어렵기 때문이다. 로봇이 100% 친구처럼 인간과 교류하려면 몇 년이 더 걸린다.로봇은 인간처럼 공감할 수 없기 때문입니다.둘째, 페이스북 소비자들은 쇼핑을 하거나 날씨에 관심이 있다고 해서 기업에 정보를 보내지 않는다.이러한 체험은 채팅로보트를 갖추는것을 전제조건으로하고 정보전달령역에서 소셜네트워크령역으로 확장된 업종데터의 지지를 필요로 한다.</p><p>페이스북 이용자들이 진정으로 원하는 것은 문제가 있을 때 신속하게 사업가의 회답을 받을 수 있다는 것이다.</p><p>소비자들이 페이스북에 메신저를 보내는 주된 이유는 서비스를 받기 위해서다.다른 모든 것은 뜬구름이다.이러한 교차식예매는 고객의 질문으로부터 시작되여 제때에 답복하면 거래를 추진할수 있다.고객님께서 고객님에 문의하셔서 고객님들과 연결하여 판매하시면, 고객님들께 물어봐야 할 것이 대부분입니다.일부 답안은 로보트가 대답할수 있지만 더욱 복잡한 문제는 사람에게 주어 해결하게 할수 있다. 유력도구가 있는 상황에서 로보트의 답복속도는 로보트를 비길수 있다.</p><p>하지만 많은 로봇 개발자들은 가장 요구되는 부분에 집중하지 않고 새로운 사용자 체험을 창출하거나, 새로운 업그레이드 (chatbot)에 대한 개념을 재개발한다.로봇 개발자가 참여율이 낮다고 느낀다면 이는 AI 가 실패했기 때문이 아니라 소비자를 애당초 걷지 않으려는 길로 인도했기 때문일 것이다.이미 존재하는 소비자 행동 패턴을 이용하거나 고객의 요구에 응답하도록 로봇을 훈련시키지도 않는다. AI의 역할은 단지 로봇 개발자가 상상하는 창조적 체험을 실현시켜 소비자가 상호 작용을 할 뿐이다.</p><p>페이스북은 현재 로봇 개발자들에게 세션 입력 사용을 완전히 금지할 것을 권장하고 있습니다.</p><p>개인적으로는 페이스북이 권하는 것처럼 채팅 입력 금지가 AI와 NLP의 기술 제한에 대한 올바른 해결책이라고 생각하지 않는다.대화력이 없는 통신로봇은 뉴스로봇을 활용할 수 있다. 그 체험은 알림 · 콘텐츠 소비로 이뤄진다.서비스를 기본으로 하는 서비스라면 고객들에게 친선 커뮤니티의 장을 제공해야 합니다.만약 문자입력이 메신저 (Messenger)의 주요 방식이라면 고객의 의사소통 의사와 능동성을 제한할 수 있으며, 그들이 상상할 수 있는 다른 방식의 고객 서비스를 찾도록 강요할 수 있다. 또, 단지 답변을 지연시킬 수 있다 하더라도 고객에게 더욱 실망시킬 수 있다.아이비는 메뉴를 듣고 0을 몇 번 눌러야 한다.</p><p>사업계는 Facebook 사용자들의 욕구를 충족시키기 위해 자동과 인공이 결합된 방식을 채택해야 한다.</p><p>중국의 웨이신 (we信)의 작은 프로그램은 뉴스의 상호 작용을 통합하여 개발자들의 채팅로봇에 대한 기대를 만족시켰다. 하지만 이는 동양의 문화 현상이고, 서방 기업들은 기존의 소비자 행위를 먼저 이용해야 하며, 이러한 행위 데이터는 더욱 잘 활용해야 한다.채팅로봇이 인공서비스를 대신한다는 개념의 뭉치 팬이 아니라 개업 초기 약속을 지킨다면 이런 기술을 도입해 고객과의 교류를 강화할 수 있다.현재 페이스북 소비자들이 원하는 바를 실행할 수 있다면, 시간이 지날수록 당신은 새로운 기능을 추가하고, 소비자를 원하는 방향으로 이끌 수 있습니다.결국 너는 그들의 요구를 만족시킬 수 있을 것이다.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBch1stLWGqmFhze909','1','2019-07-09 14:19:46','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('270','144','1','팩스, 곧 ofo에 접속, 차량 대전 공유 혹은 변화','','','admin','1','20','','0','0','','1','','','','','0','2019-07-09 14:19:45','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','36 크립톤은 ofo 내부에서 정보를 입수하여 올해 4월이면 ofo 가 디디추출 App에 접속하여 사용자들이 직접 디디에 ofo 서비스를 사용할 수 있게 될 것이라고 한다.\"최근 일정이 부쩍 늘었다.한 ofo 내부 직원이 말했다.36 크립톤이 디디에 관변측이나 ofo 관측에이 소식을 확인하여 증명하였지만, 투고할 때까지는 두 회사가 모두이 사실을 확인하거나 부인하지 않았다.ofo 설립자인 데이비드는 지난해 12월 디디애플에 언제 접속할 것인지에 대해 명확한 시간표가 없다고 밝힌 바 있다.\"ofo 모델은 GPS 가 없습니다.','0','<p>36 크립톤이 ofo 내부에서 정보를 얻어 올 4월이면 ofo 가 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍 째깍<a href=\"#\" target=\"_blank\">a</a>pp에서 그때에 사용자는 직접 디적에 ofo 서비스를 사용할수 있다.</p><p>\"최근 일정이 부쩍 늘었다.한 ofo 내부 직원이 말했다.36 크립톤이 디디에 관변측이나 ofo 관측에이 소식을 확인하여 증명하였지만, 투고할 때까지는 두 회사가 모두이 사실을 확인하거나 부인하지 않았다.</p><p>ofo 설립자인 데이비드는 지난해 12월 디디애플에 언제 접속할 것인지에 대해 명확한 시간표가 없다고 밝힌 바 있다.\"ofo 모델은 GPS 가 없고, 사용자는 차량만 보면 사용합니다. 모든 논리는 디적플랫폼에서 타는것과 다르죠.</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590115762957.jpg\" title=\"15590115762957.jpg\" alt=\"57.jpg\"/></p><p><br/></p><p>그러나 비슷한 접속사례가 없는 것은 아니다.올해 2월, 웨이신 (微信) 연합모배 (mobay) 단일 차량에서 사용자는 웨이신 (微信)\'스캔\'을 통해 모베이 (moby) 한 차량 몸체의 2차원 코드를 스캔하면 바로 모바이 단일 차량인 웨이신 (微信) 소프로그램으로 들어가 자물쇠를 누르면 바로 차량을 사용할 수 있다고 선포했다.</p><p>ofo의 점적 연결 소식이 처음 나온 것도 아니고, 양 플랫폼의 첫 번째 깊숙한 바인딩도 아니다.이에 앞서 디디는 ofo의 최근 3 라운드 융자에 참여했다.텐센트테크놀러지의 보도에 따르면 한 공유차량투자자가 피로한데 따르면 ofo 여러차례의 융자를 거친후 디적은 이미 ofo 최대주주로 되였으며 점한 주식이 30%를 초과했다.\"이것은 디디가 ofo에 있는 발언권이 더욱 강화됨과 동시에, ofo의 성패, 디디가 최대 이자와 관련이될 것이다.\"</p><p>이 또한 이해하기 어렵지 않다. 디디가 ofo를 접목한 후 거대한 사용자 유량 입구로 그 흐름을 선도하게 될 것이다. 반면 ofo는 사업 체량을 더욱 공고히 하여 업계 지위와 상상공간을 높일 것이다.</p><p>그리고 만약 정말 ofo를 접목시킨다면 디적과 그 배후의 자본이 자신의 출행령역에서 부족점을 진일보 미봉하고있다는것을 의미한다.</p><p>크립톤은 36 크립톤에 대해 디디도 공유용 차량으로 만들려고 했지만 어떤 이유에서든 실현되지 못해 결국 ofo 투자자로 전락할 수밖에 없었다고 털어놓았다.그러나 이것은 더 이상 시장에 발을 들여놓지 않는다는 것을 의미하지는 않는다.</p><p>디디의 ofo 투자는\'마지막 3km\'의 기회를 노린 것이다.</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590106398663.jpg\" title=\"15590115918734.jpg\" alt=\"58.jpg\"/></p><p><br/></p><p>현재 국내에는\'마지막 3 킬로미터\'영역이 여전히 매우 초보적인 단계이며, 체계적인 서비스 업체도 없다.그러나 북상광의 일선도시에서는 교통의 복잡함과 동시에 각 큰 출행명령의\"마지막 3 킬로메터\"에 대한 쟁탈도 날따라 치렬해졌다.</p><p>출발지에서 목적지까지 3km를 달리면 택시를 탈 수 있고 탈 수 있다.한 ofo 내부 직원은 다음과 같이 말했다. 디적의 방법은 바로 자신이 부동한 옵션을 전부 덮어쓰는것이다.</p><p>디디와 ofo 및 그 투자자들은 공유단차령역에서 이미 쾌속성장기를 맞이했다고 보고있다.Ofo의 한 공공관리는 일찍 매체에 전용차량과 급행차량을 례로 들면 2012년 이후의 몇년간 발전속도가 아주 빠르다고 말했다.오보는 1년 동안 하루 주문량을 200건에서 50만 건으로 늘렸다.\"과거 전속 급행열차, 지금의 ofo는 고속 성장을 했다.말했습니다.</p><p>지난해 12월 말, ofo는 공동으로 디디를 출범했다. 이는 ofo 가 디디에 투자된 후 처음 진행한 대규모 합작이다.활동이 취한 축의금책략도 줄곧 디디가 시장에 보급한 훌륭한 도구중의 하나로 인정되였다.</p><p>디디방의 설명에 따르면 2017년에도 여전히 주요 정력을 외출 분야에 집중할 것이며 모든 사람의 외행을 원활하게 하길 희망한다.이는 모든 출행방식이다 덮이게 될것이고 공유자전거도 점적거리력방향의 하나이다.</p><p>36 크립톤은 디디가 공유 차량과 더 많은 연계 이유는 또 다른 중요한 이유가 크립톤,\"엄격한\"인터넷 전용 차량 규정과 비교할 때 공유의 차량 발전 초기에 정책적 장려 및 제약 조건 또한 매우 합리적.지난해 이후 지금까지 인터넷 약정 뉴딜의 영향을 받아 온 디디출행은 정책적 측면에서도, 새로운 업무성장 측면에서도 한걸음 더 나아가 공유한 차량 바람막이로 인해 한몫 챙길 수 있다.</p><p>그러나 36 크립톤은 또 다른 의문을 가지고 있다. 내비게이션이 없는 ofo 가 어떻게 점적립톤을 투과할 수 있으며 투과후 사용자들에게 어떤 영향을 미칠까?</p><p>\"제가 아는 한, 디디가 기술과 네비게이션을 제3자 회사에 맡길 수 있습니다.\"상술한 ofo 내부 직원은 다음과 같이 말했다. 디적에 접속한후의 ofo는 여전히 네비게이션이 없으며 사용자는 페지에서 주로 코드를 긁어 열고 자물쇠를 여는 기능을 행사한다.</p><p>이 회사 임직원들은\"원래 ofo의 주체 기능이 단순하고, 조작이 간단해 이음매 없이 접착 플랫폼에 접속할 수 있을 것으로 믿는다\"며\"결국 휴대전화에 장착되는 앱 수는 점점 줄어드는 추세\"라고 강조했다.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcRxhJAQONfzQgBi372','1','2019-07-09 14:19:45','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('271','146','0','우리 고객님 6','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:17','admin','','/html/upload/images/201907/15590119613906.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYrFFP2HJK6dqK3EO405','1','2019-05-28 10:52:17','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('272','146','0','우리 고객님5','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:49','admin','','/html/upload/images/201907/15590119824821.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJfXqRGA5YldmUTW569','1','2019-05-28 10:52:49','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('273','146','0','우리 고객님4','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:10','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYhwXJUQSS037urC592','1','2019-05-28 10:53:10','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('274','146','0','우리 고객님3','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:53','admin','','/html/upload/images/201907/15590120451192.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIzPvDiJ69VLjNGR766','1','2019-05-28 10:53:53','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('275','146','0','우리 고객님2','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:16','admin','','/html/upload/images/201907/15590120684878.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9GqCQFgFQyglQj7360','1','2019-05-28 10:54:16','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('276','146','0','우리 고객님1','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:32','admin','','/html/upload/images/201907/15590120844373.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYAQclj7YrB9fd0zB432','1','2019-05-28 10:54:32','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('278','153','0','2000','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:54:51','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','이 회사는 1982년에 설립되였다.','0','<p>2000년에 회사에서 일어난 일.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYHm0xy8DUB1nvRaR236','1','2019-05-29 08:54:51','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('279','153','0','1995','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:17','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1995년 회사에서 일어난 일.','0','<p>1995년 회사에서 일어난 일.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRNotaOXnvroS1LX687','1','2019-05-29 08:55:17','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('280','153','0','1987','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1987년 회사에 일어난 일.','0','<p>1987년 회사에 일어난 일.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9iSxLUYzDOVbMek325','1','2019-05-29 08:55:40','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('281','153','0','1983','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:19','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1983년 회사에 일어난 일.','0','<p>1983년 회사에 일어난 일.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYqaGTtWY1GuaBar1334','1','2019-05-29 08:56:19','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('282','153','0','1982','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','이 회사는 1982년에 설립되였다.','0','<p>이 회사는 1982년에 설립되였다.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYpCNyNaObllf1WLH124','1','2019-05-29 08:56:40','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('283','154','0','열정의 여름 농구 대미를 장식했다.','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:02','admin','','/html/upload/images/201907/15590951812642.jpg','1','1','2018년 8월 1일, 세기 천홍의\'열정의 여름 \'농구 경기가 막을 내렸다.결국 치열한 각축을 거쳐 세기천홍체계사업부, 행정부 구성된 시스템 꿈의 팀과 세기천홍대 대고객사업부, 전자상사업부, 그룹 총재로 구성된 전설팀은 각각 우승, 준우승을 차지했다.천홍 상무부 부총장 겸 시스템 사업부 사장 양케가 관준우승 팀으로 시상했다.   이번 농구 경기를 통해 각 부서 사이의 거리를 가까이하여 서로의 소통과 이해를 증진시켰다.직원 의 문화 생활 을 풍성하게 하여 직원 의 팀 의식 과 집단 의 영예감 을 증강시켰다','0','<p>&nbsp;2018년 8월 1일, 세기 천홍의\'열정의 여름 \'농구 경기가 막을 내렸다.결국 치열한 각축을 거쳐 세기천홍체계사업부, 행정부 구성된 시스템 꿈의 팀과 세기천홍대 대고객사업부, 전자상사업부, 그룹 총재로 구성된 전설팀은 각각 우승, 준우승을 차지했다.천홍 상무부 부총장 겸 시스템 사업부 사장 양케가 관준우승 팀으로 시상했다.</p><p>&nbsp; &nbsp; &nbsp; 이번 농구 경기를 통해 각 부서 사이의 거리를 가까이하여 서로의 소통과 이해를 증진시켰다.직원 의 문화 생활 을 풍성하 고 직원 팀 의식 과 집단 영예감 을 증강 하 고 구 회우 를 증진 우정 을 촉진 하 고 조화로운 회사 분위기 를 촉진 한 2018년 8월 1일 세기 천홍 의\'격정 의 여름 \'농구 시합 이 막을 내렸다.결국 치열한 각축을 거쳐 세기천홍체계사업부, 행정부 구성된 시스템 꿈의 팀과 세기천홍대 대고객사업부, 전자상사업부, 그룹 총재로 구성된 전설팀은 각각 우승, 준우승을 차지했다.천홍 상무부 부총장 겸 시스템 사업부 사장 양케가 관준우승 팀으로 시상했다.</p><p>&nbsp; &nbsp; &nbsp; 이번 농구 경기를 통해 각 부서 사이의 거리를 가까이하여 서로의 소통과 이해를 증진시켰다.직원 의 문화 생활 을 풍성하 고 직원 팀 의식 과 집단 영예감 을 증강 하 고 구 회우 와 우정 을 증진 하 고 조화로운 회사 분위기 를 촉진 하 고 마음 을 응집하는 목적 이다. 2018년 8월 1일, 세기 천홍의\'열정의 여름 \'농구 경기가 막을 내렸다.결국 치열한 각축을 거쳐 세기천홍체계사업부, 행정부 구성된 시스템 꿈의 팀과 세기천홍대 대고객사업부, 전자상사업부, 그룹 총재로 구성된 전설팀은 각각 우승, 준우승을 차지했다.천홍 상무부 부총장 겸 시스템 사업부 사장 양케가 관준우승 팀으로 시상했다.</p><p>&nbsp; &nbsp; &nbsp; 이번 농구 경기를 통해 각 부서 사이의 거리를 가까이하여 서로의 소통과 이해를 증진시켰다.직원 의 문화 생활 을 풍성하 고 직원 팀 의식 과 집단 영예감 을 증강 하 고 구 회우 와 우정 을 증진 하 고 조화로운 회사 분위기 를 촉진 하 고 마음 을 응집하는 목적 이다.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYVxCBeWGRDWucvRm347','1','2019-05-29 09:59:02','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('284','154','0','꿈을 꾸며 미래를 포옹하는 2019 창업부화 플랫폼 연회','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:57','admin','','/html/upload/images/201907/15590952222752.jpg','1','1','2019년 1월 23일, 세기 천홍 창업부화 플랫폼 연회 치박에서 개최, 이번 해에는\'꿈 출항, 미래 포옹\'을 주제로 했다.세기의 천홍은 모든 부화 플랫폼의 창시자, 직원들이 한자리에 모여 성전을 돕는다.  세기 천홍 회장 임지홍, 윤번치 사장도 연회에 참가했다.연회는 세기 천홍 상무 부사장 장학군이 주관한다.재회에서 산동 우역 도서 유한 회사, 산동홍일 교육 과학 기술 유한 회사, 산동 지홍 초인도서, 산동 선덕 예서 도서 유한 회사, 산동상홍 진학 교육 상담 유한회사, 베이징 소홍문','0','<p>2019년 1월 23일, 세기 천홍 창업부화 플랫폼 연회 치박에서 개최, 이번 해에는\'꿈 출항, 미래 포옹\'을 주제로 했다.세기의 천홍은 모든 부화 플랫폼의 창시자, 직원들이 한자리에 모여 성전을 돕는다.<br/>&nbsp; &nbsp; 세기 천홍 회장 임지홍, 윤번치 사장도 연회에 참가했다.연회는 세기 천홍 상무 부사장 장학군이 주관한다.재회에서 산동 우이련 도서 유한회사, 산동 우이홍일 교육 과학기술 유한회사, 산동 지홍 초인도서 유한회사, 산동 선덕 선덕 예도서 유한회사, 산동상홍 진학방 교육상담 유한회사, 베이징 소홍문화 전매회사, 치박서방 문화전파 유한책임공사, 산동 오이 2문화 미디어 유한회사, 베이징 터치 과학 기술 유한회사, 산동 천이홍도 교육과학기술 유한회사 등 프로젝트 책임자는 각각 자신의 창업 이야기를 나눠 자신의 팀을 이끌고 전시했다.선덕 예동감 넘치는 춤, 백 홍일각의 창업판\'사막낙타\', 상홍진학방의 힘찬\'달려라 \'등 프로그램이 인상적이다.이후 천홍 회장 임지홍 회장은 이곳에 도착한 창업업체에 기념금메달을 수여하고 선덕예일에게 백홍일이\'우수창업팀\'이라는 표창을 수여해 연회에서 발표했다.<br/>세기 천홍 창업 부화 플랫폼 은 도전 과 기회 를 품고 있 는 환경 을 각 창업 회사 는 발 디딜 의 작풍, 백절불굴 의 정신, 강인한 의지 를 창업 하는 길 에서 자신 의 빛 을 발산 했 다.고별 2018, 새로운 2019, 우리의 희망, 세기 천홍 창업 플랫폼 2019 새로운 눈부신 플랫폼을 동경한다.<br/>&nbsp; &nbsp; 만약 창업의 꿈이 있다면 절대 망설이지 말고 기회를 잡고, 창업플랫폼을 만들어 당신의 멋진 인생을 살아야 한다.</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYLGJWgkXGdDceA8172','1','2019-05-29 09:59:57','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('285','154','0','2019년 태극권 대회 이벤트 서막','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 10:00:40','admin','','/html/upload/images/201907/15590952834831.jpg','1','1','  중화전통문화를 선양하기 위해 천홍 햇볕 체육 활동, 많은 직원들 팀워크, 적극적인 우량 품질, 4월 22일, 세기 천홍 제1차 태극권대회가 회사 정원에서 본격적으로 시작된다.  이번 태극권대회에 대해 회사는 먼저 진식홍파 태극권 801식 훈련을 진행했다.홍보 동원을 거쳐 직원들은 강제 헬스, 팀워크에 대한 중요성을 충분히 인식하고 각 부문의 적극성을 효과적으로 동원했다.참가 사원은 시스템 사업부 팀, 대고객사업부 팀, 업무 부문, 직능 부문 4개 팀으로 나뉜다.각 부','0','<p>&nbsp; &nbsp; 중화전통문화를 선양하기 위해 천홍 햇볕 체육 활동, 많은 직원들 팀워크, 적극적인 우량 품질, 4월 22일, 세기 천홍 제1차 태극권대회가 회사 정원에서 본격적으로 시작된다.</p><p>&nbsp; &nbsp; 이번 태극권 경기에 대해 회사는 우선 천식홍파 태극권 81가지 훈련을 실시한다.홍보동원을 통해 직원들은 태극권이 몸을 튼튼히하고 팀워크는 물론 각 부서의 적극성도 효과적으로 발휘하도록 하였다.참가 인원은 시스템사업부팀, 그랜드바이어 사업부팀, 업무부문연대, 직능부문연합 등 4개 팀으로 나뉜다.각 부서 직원들은 태극마크를 달기 위한 훈련에 적극 협조하고 있다.<br/></p><p></p><p>&nbsp; &nbsp; 이번 양성활동에서는 진씨홍이 태극권전도자 리옥복선생을 특별히 초청하여 지도교수하게 하였다.\"태극기, 말갈기, 두루미 날개가르기, 좌우 무릎부둥이를 끌어안고 구부리는\"등 한 수 한 수, 한 수면에 흐르는 물처럼 미감이 넘쳤다.각 부서 직원들이 매일 정해진 시간에 방진을 치고 공부해 회사 단지에 아름다운 자태를 뽐냈다.</p><p></p><p>&nbsp; &nbsp; 태극권은 무술의 중요한 구성부분으로서 력사가 유구하고 박대하고 심오하여 중화민족의 진귀한 보물이다.이번 태극권 행사인 천홍원에 입장하면 직원들이 몸을 건강하게 만들 수 있을 뿐만 아니라, 세기천홍기업문화의 폭넓은 확산을 추진하게 될 것이다.</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYzzOpkeWefOxetiy687','1','2019-05-29 10:00:40','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('318','157','0','520개 애프터망','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:03','admin','','/html/upload/images/201907/15591169541800.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYztbAWrIud1FqAwM189','1','2019-05-29 16:02:03','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('319','157','0','150원 상당 무료우편','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:43','admin','','/html/upload/images/201907/15591169739359.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYXe8jxOmWqQ070gQ904','1','2019-05-29 16:02:43','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('320','157','0','15일 무료교환','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:01','admin','','/html/upload/images/201907/15591169933799.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYLDoNiWI7NO4xBfM994','1','2019-05-29 16:03:01','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('321','157','0','7일 무이유 반품','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:22','admin','','/html/upload/images/201907/15591170149117.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYmDaJUfapbwNpp7x939','1','2019-05-29 16:03:22','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('322','157','0','예약 수리 서비스','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:41','admin','','/html/upload/images/201907/15591170337490.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcGhrO1KVcIWghek879','1','2019-05-29 16:03:41','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('323','149','0','프로젝트 매니저','','','admin','1','11','','0','0','','0','','','','','0','2019-06-13 16:23:39','admin','','','1','1','업무경리 업무경리 AE의 직책은 대외로 고객과 협상, 련락, 제안, 수금 등을 진행하고대내적으로는 전략 수립, 자원 조정, 업무 할당, 진행 감시 등이 있다.진정한 AE는 영업사원처럼 단순하지 않다. 판매, 시조, 기획, 디자인, 제작, 미디어 등에 대한 전문지식을 익히고 인맥을 다루는 능력이 있어야 한다.','0','<p>업무경리 업무경리 AE의 직책은 대외로 고객과 협상, 련락, 제안, 수금 등을 진행하고대내적으로는 전략 수립, 자원 조정, 업무 할당, 진행 감시 등이 있다.진정한 AE는 영업사원처럼 단순하지 않다. 판매, 시조, 기획, 디자인, 제작, 미디어 등에 대한 전문지식을 익히고 인맥을 다루는 능력이 있어야 한다.</p>','archive/show_job.html','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQucDYsG9O6OUqzO569','1','2019-06-13 16:23:39','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('324','146','0','협력 동반자 8','','','admin','1','0','','0','0','','0','','','','','0','2019-06-14 14:51:13','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBlFncAe0iLoY9Qf261','1','2019-06-14 14:51:13','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('326','155','0','모모의 영예','','','admin','1','0','','0','0','','0','','','','','0','2019-07-03 14:27:51','admin','','/html/upload/images/201907/gushi.jpg','1','1','명예 설명 텍스트 …','0','<p style=\"text-align: center;\"><br/><img src=\"/html/upload/images/201907/gushi.jpg\"/></p><p><br/></p><p>명예 설명 텍스트 …</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYO70f2XfrUVxUUz6867','1','2019-07-03 14:27:51','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('327','130','0','솔루션 2','','','admin','1','2','','0','0','','0','','','','','0','2019-07-09 18:33:20','admin','','','1','1','솔루션 이중 텍스트 설명 …','0','<p>솔루션 이중 텍스트 설명 …</p>','0','0','0','','0','0','','','','','0','5','html/upload/attachment/201905/15579676979434.zip','0','N;','','0','0','0','0000-00-00','0','CMSEASYQN2pfl790LO5Ouo231','1','2019-07-09 18:33:20','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('328','130','0','솔루션 1','','','admin','1','30','','0','0','','0','','','','','0','2019-07-25 16:23:16','admin','','/html/upload/images/201907/14360857154349.jpg','1','1','솔루션 텍스트 설명 …','0','<p>솔루션 텍스트 설명 …</p><p>2</p>','0','0','0','','0','0','','','','','0','7','html/upload/attachment/201907/15628273460708.gif','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360807979603.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360854145721.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14363453760256.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYQ7C6mNjnb3EPO0p724','1','2019-07-25 16:23:16','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('329','130','0','솔루션 3','','','admin','1','0','','0','0','','0','','','','','0','2019-07-09 18:41:44','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYH6rFJkqJoC5fDzk552','1','2019-07-09 18:41:44','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('330','144','0','뉴스 1','','','admin','1','0','','0','0','','0','','','','','0','2019-07-15 08:22:23','admin','','','-1','1','p뉴스/p','0','<p>뉴스</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYjRpay6916R4orui585','1','2019-07-15 08:22:23','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('331','134','0','아아','','','admin','1','0','','0','0','','0','','','','','0','2019-07-17 16:10:15','admin','','','-1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYDXXd2Gnc7oq8yrr534','1','2019-07-17 16:10:15','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('332','134','0','MackBook','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 22:27:32','admin','','/html/upload/images/201907/15591115599626.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','0','CMSEASYJTEFwo7JfLxlhul232','1','2020-01-18 22:27:32','','my_shopping_model,my_shopping_color','999','4','97','','0.00','0.00','73,1#-72,1#','{\"0\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://www.tmall.com\"},\"1\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://www.jd.com\"}}','1:유형 a,+,55,2:유형 b,+,155,','1:색깔 a,+,0,/html/upload/images/201907/15590080664809.jpg2:색깔 b,+,0,/html/upload/images/201907/15591115599626.jpg3:색깔 c,+,0,/html/upload/images/201907/15590079031945.jpg4:색깔 d,+,0,/html/upload/images/201907/15591115602093.jpg5:색깔 e,+,0,/html/upload/images/201907/15506335969988.jpg6:색깔 f,+,0,/html/upload/images/201907/15506335904260.jpg7:색깔 g,+,0,/html/upload/images/201908/15662076306969.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('333','134','0','Iphone','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 22:28:25','admin','','/html/upload/images/201907/15591115599626.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','8620','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','0','CMSEASYJTEFwo7JfLxlhul232','1','2020-01-18 22:28:25','','my_shopping_model,my_shopping_color','999','4','978','','0.00','0.00','73,1#-72,1#','{\"0\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://www.tmall.com\"},\"1\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://www.jd.com\"}}','1:유형 a,+,55,2:유형 b,+,155,','1:색깔 a,+,0,/html/upload/images/201907/15590080664809.jpg2:색깔 b,+,0,/html/upload/images/201907/15591115599626.jpg3:색깔 c,+,0,/html/upload/images/201907/15590079031945.jpg4:색깔 d,+,0,/html/upload/images/201907/15591115602093.jpg5:색깔 e,+,0,/html/upload/images/201907/15506335969988.jpg6:색깔 f,+,0,/html/upload/images/201907/15506335904260.jpg7:색깔 g,+,0,/html/upload/images/201908/15662076306969.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('531','134','0','CH-17 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:22:11','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要','0','<p>从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器</p><p>。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要比只查看数据包物理地址的交换机慢。但是，对于那些结构复杂的网络，使用路由器可以提高网络的整体效率。路由器的另外一个明显优势就是可以自动过滤网络广播。总体上说，在网络中添加路由器的整个安装过程要比即插即用的交换机复杂很多。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">有的路由器仅支持单一协议，但大部分路由器可以支持多种协议的传输，即多协议路由器。由于每一种协议都有自己的规则，要在一个路由器中完成多种协议的算法，势必会降低路由器的性能。路由器的主要工作就是为经过路由器的每个数据帧寻找一条最佳传输路径，并将该数据有效地传送到目的站点。由此可见，选择最佳路径的策略即路由算法是路由器的关键所在。为了完成这项工作，在路由器中保存着各种传输路径的相关数据－－路径表（Routing Table），供路由选择时使用。路径表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路径表可以是由系统管理员固定设置好的。</span><br/></p><p>静态路由表：由系统管理员事先设置好固定的路径表称之为静态（static）路径表。</p><p>动态路由表：动态（Dynamic）路径表是路由器根据网络系统的运行情况而自动调整的路径表。</p><p>路由器是一种多端口设备，它可以连接不同传输速率并运行于各种环境的局域网和广域网，也可以采用不同的协议。路由器属于O S I 模型的第三层--网络层。指导从一个网段到另一个网段的数据传输，也能指导从一种网络向另一种网络的数据传输。&nbsp;</p><p>第一，网络互连：路由器支持各种局域网和广域网接口，主要用于互连局域网和广域网，实现不同网络互相通信；<br/>　　第二，数据处理：提供包括分组过滤、分组转发、优先级、复用、加密、压缩和防火墙等功能；<br/>　　第三，网络管理：路由器提供包括路由器配置管理、性能管理、容错管理和流量控制等功能。<br/>　　所谓“路由”，是指把数据从一个地方传送到另一个地方的行为和动作，而路由器，正是执行这种行为动作的机器，它的英文名称为Router,是一种连接多个网络或网段的网络设备，它能将不同网络或网段之间的数据信息进行“翻译”，以使它们能够相互“读懂”对方的数据，从而构成一个更大的网络。<br/>　　为了完成“路由”的工作，在路由器中保存着各种传输路径的相关数据－－路由表（Routing Table），供路由选择时使用。路由表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路由表可以是由系统管理员固定设置好的，也可以由系统动态修改，可以由路由器自动调整，也可以由主机控制。在路由器中涉及到两个有关地址的名字概念，那就是：静态路由表和动态路由表。由系统管理员事先设置好固定的路由表称之为静态（static）路由表，一般是在系统安装时就根据网络的配置情况预先设定的，它不会随未来网络结构的改变而改变。动态（Dynamic）路由表是路由器根据网络系统的运行情况而自动调整的路由表。路由器根据路由选择协议（Routing Protocol）提供的功能，自动学习和记忆网络运行情况，在需要时自动计算数据传输的最佳路径。</p><p><br/></p><p><br/></p>','0','0','0','','0','0','','','998','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYwYXTmVmdpkOSDhl727','1','2020-01-16 22:22:11','','my_shopping_model,my_shopping_color','0','4','585','','0.00','0.00','','{}','1:300M,+,5,2:450M,+,10,3:500M,+,15,4:600M,+,20,5:700M,+,25,6:800M,+,30,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('532','134','0','CH-18 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:30:10','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS','0','<p>路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。&nbsp;</p><p>同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS可以使我们在路由器的FLASH中不存在ISO时，先引导起来，进入恢复模式，来使用TFTP或X-MODEM等方式去给FLASH中导入ISO文件。所以，路由器的启动过程应该是这样的：</p><p>路由器在加电后首先会进行POST。Power On Self Test (上电自检，对硬件进行检测的过程)。</p><p>POST完成后，首先读取ROM里的BootStrap程序进行初步引导。</p><p>初步引导完成后，尝试定位并读取完整的ISO镜像文件。在这里，路由器将会首先在FLASH中查找ISO文件，如果找到了ISO文件的话，那么读取ISO文件，引导路由器。</p><p>如果在FLASH中没有找到ISO文件的话，那么路由器将会进入BOOT模式，在BOOT模式下可以使用TFTP上的ISO文件。或者使用TFTP/X-MODEM来给路由器的FLASH中传一个ISO文件(一般我们把这个过程叫做灌ISO)。传输完毕后重新启动路由器，路由器就可以正常启动到CLI模式。</p><p>当路由器初始化完成ISO文件后，就会开始在NVRAM中查找STARTUP-CONFIG文件，STARTUP-CONFIG叫做启动配置文件。该文件里保存了我们对路由器所做的所有的配置和修改。当路由器找到了这个文件后，路由器就会加载该文件里的所有配置，并且根据配置来学习、生成、维护路由表，并将所有的配置加载到RAM(路由器的内存)里后，进入用户模式，最终完成启动过程。</p><p>如果在NVRAM里没有STARTUP-CONFIG文件，则路由器会进入询问配置模式，也就是俗称的问答配置模式，在该模式下所有关于路由器的配置都可以以问答的形式进行配置。不过一般情况下我们基本上是不用这样的模式的。我们一般都会进入CLI&nbsp;[1]&nbsp;&nbsp;(Comman Line Interface)命令行模式后对路由器进行配置。</p><p><br/></p><p>工作原理示例</p><p>（1）工作站A将工作站B的地址12.0.0.5连同数据信息以数据包的形式发送给路由器1。</p><p>（2）路由器1收到工作站A的数据包后，先从包头中取出地址12.0.0.5，并根据路径表计算出发往工作站B的最佳路径：R1-&gt;R2-&gt;R5-&gt;B；并将数据包发往路由器2。</p><p>（3）路由器2重复路由器1的工作，并将数据包转发给路由器5。</p><p>（4）路由器5同样取出目的地址，发现12.0.0.5就在该路由器所连接的网段上，于是将该数据包直接交给工作站B。</p><p>（5）工作站B收到工作站A的数据包，一次通信过程宣告结束。</p><p><br/></p>','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9nOCjsT6XTOiGFs105','1','2020-01-16 22:30:10','','my_shopping_model,my_shopping_color','0','4','88','','0.00','0.00','','{}','1:100M,+,5,2:150M,+,10,3:200M,+,15,','1:蓝,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('493','134','0','CH-19 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:28:57','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，交通警察。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即','0','<p>路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，&quot;交通警察&quot;。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即网络层。这一区别决定了路由和交换机在移动信息的过程中需使用不同的控制信息，所以说两者实现各自功能的方式是不同的。</p><p>路由器（Router）又称网关设备（Gateway）是用于连接多个逻辑上分开的网络，所谓逻辑网络是代表一个单独的网络或者一个子网。当数据从一个子网传输到另一个子网时，可通过路由器的路由功能来完成。因此，路由器具有判断网络地址和选择IP路径的功能，它能在多网络互联环境中，建立灵活的连接，可用完全不同的数据分组和介质访问方法连接各种子网，路由器只接受源站或其他路由器的信息，属网络层的一种互联设备。</p><p>路由器分本地路由器和远程路由器，本地路由器是用来连接网络传输介质的，如光纤、同轴电缆、双绞线；远程路由器是用来连接远程传输介质，并要求相应的设</p><p>模拟器中的路由器&nbsp;</p><p>备，如电话线要配调制解调器，无线要通过无线接收机、发射机。</p><p>路由器是互联网的主要结点设备。路由器通过路由决定数据的转发。转发策略称为路由选择（routing），这也是路由器名称的由来（router，转发者）。作为不同网络之间互相连接的枢纽，路由器系统构成了基于TCP/IP 的国际互联网络Internet&nbsp;的主体脉络，也可以说，路由器构成了Internet的骨架。它的处理速度是网络通信的主要瓶颈之一，它的可靠性则直接影响着网络互连的质量。因此，在园区网、地区网、乃至整个Internet研究领域中，路由器技术始终处于核心地位，其发展历程和方向，成为整个Internet研究的一个缩影。在当前我国网络基础建设和信息建设方兴未艾之际，探讨路由器在互连网络中的作用、地位及其发展方向，对于国内的网络技术研究、网络建设，以及明确网络市场上对于路由器和网络互连的各种似是而非的概念，都有重要的意义。</p><p>出现了交换路由器产品，从本质上来说它不是什么新技术，而是为了提高通信能力，把交换机的原理组合到路由器中，使数据传输能力更快、更好。</p><p><br/></p>','0','0','0','','0','0','','','280','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhC2dWvXrEcx0C74295','1','2020-01-16 22:28:57','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','{}','1:500M,+,100,2:1000M,+,200,','1:黑,+,0,2:白,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('494','134','0','U-ART气动式高音','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:20:32','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','音响特指电器设备组合发出声音的一套音频系统音响系统大体包含：1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭','0','<p>音响特指电器设备组合发出声音的一套音频系统</p><p>音响系统大体包含：</p><p>1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）</p><p>2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）</p><p>3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）&nbsp;</p><p>4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭、低音炮等等）。技术的的发展历史可以分为电子管、晶体管、集成电路、场效应管四个阶段。</p><p><br/></p><p>音响是一个简化后的日常词语，是音响系统的简称。即代指一整套可以还原播放音频信号的设备。</p><p>随着社会的进步，人们向往生活更多姿多彩。歌舞作为一种流传数千年的娱乐形式，深入各族人民的生活。但是随着科技的发展和进步，人们对于歌舞的表演形式和场地要求越来越多、越来越高。音响系统随着人们的需求不断改进和完善。大到满足上万人演唱会现场扩声需求，小到满足个人家庭弹奏乐器、K歌的需要。</p><p><br/></p>','0','0','0','','0','0','','','1600','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHX6gF0nEoJyFagO648','1','2020-01-16 22:20:32','','my_shopping_model,my_shopping_color','0','4','88','','0.00','0.00','','{}','1:高音,+,0,2:中音,+,0,3:普音,+,0,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('530','134','0','电热水壶','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:06:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随','0','<p>电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。</p><p>电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随着生活的需要，现在的电水壶也正在向多功能方向发展，如防漏、防烫、锁水等。电水壶具有加热速度快，保温效果好，过滤功能强，式样多等优点。</p><p>电热水壶的使用功能虽然基本相同，但从内在电路结构设计可以分为鸣笛式电水壶、防干烧鸣笛电水壶、塑胶电热水壶等几大类。</p><p>（1）鸣笛式电热水壶。</p><p>由铝制板经拉伸制成，电热元件采用浸水式镀镍钢密封式电热管。电热管安装在水壶底部，和壶体结合部垫有耐热密封圈以防止漏水。该类型电热水壶壶盖上设置有一个条状振动簧片自鸣器（气流振动式鸣笛装置），当水温达到100℃以上时气流鸣笛即会鸣响。由于该类水壶一般没有设置限温控制器，必须人为地手动切断电源。该类电热水壶结构简单、价格低廉，居民家庭中使用相当广泛。</p><p>（2）防干烧鸣笛式电热水壶。&nbsp;</p><p>在鸣笛式电水壶设计原理基础上，增设了限温自动控制器（主要是双金属恒温控制器或者磁控恒温自动开关），当水沸腾时，产生的水蒸气使感温元件的双金属片变形，驱动微型开关切断电源，极大地提高了电热水壶的安全性能。一些高品质的电热水壶中的限温控制器采用一种类似记忆合金的新型热敏材料（自动恒温控制开关），当壶内水面低于电热管（电热管温度超过100℃以上）时，自动恒温控制开关便会自动切断电源，保护电热水壶不被烧毁。</p><p>（3）塑胶型电热水壶。</p><p>塑胶型电热水壶最大的特点是携带方便、安全性能可靠。壶体设置的电源信号指示灯可方便观察通电状态，上下分体式结构可以3600旋转，壶体采用的食品级卫生塑质材料熔点在200℃以上。这种新型电热水壶采用隐藏式不锈钢电发热盘，并设置有蒸汽感应控制开关，具有自动断电、防干烧断电、热熔断电保护、接地保护等多重保护功能。&nbsp;</p><p><br/></p>','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYof911iYjQMp1JA5768','1','2020-01-16 22:06:48','','my_shop_model,my_shoppingcolor','5','4','88','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东\",\"buyurls\":\"https://www.jd.com\"}}','1:电子,+,10,2:机械,+,5,','1:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('495','134','0','智能吸顶灯','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:21:38','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目','0','<p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。</p><p>目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。</p><p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的就是led吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。&nbsp;&nbsp;</p><p>它起源于1995年-1996年间，由于形似太阳，因此当时行业人士称之为“太阳灯”， 2000年前的吸顶灯款式单一、材料单一，大多采用中低档材料，光源一般采用节能灯管和灯泡，并以电感吸顶灯为主。</p><p>LED吸顶灯是吸附或嵌入屋顶天花板上的灯饰，它和吊灯一样，也是室内的主体照明设备，是家庭、办公室、娱乐场所等各种场所经常选用的灯具。LED吸顶灯一</p><p><br/></p><p>般直径在200mm左右的吸顶灯适宜在走道、浴室内使用，而直径400mm的则装在不小于16平方米的房间顶部为宜。 市面上的LED吸顶灯常见有D形管和环形管两种还有大小管区别。选购LED吸顶灯时要三看。一看产品标识是否齐全，正规产品的标识往往比较规范，应标识：商标和厂名、产品型号规格、额定电压、额定频率、额定功率。二看灯具电源线是否有CCC安全认证标志，外部导线截面积应≥0.75平方毫米。三看灯具带电体是否外露，光源装入灯座后，手指应不能触及带电的金属灯头。</p><p>1)功能细分。吸顶灯传统的照明功能已不够满足消费者，将客厅吸顶灯与日常用品相组合也日趋流行。</p><p>2)造型豪华。随着生活的日益富足，消费者审美需求增加，客厅吸顶灯日趋豪华、高档。</p><p>3)崇尚自然。为迎合都市消费者返朴归真、崇尚自然的心理，很多吸顶灯采用了自然化的造型。另外，灯罩的选材也广泛采用纸质、木质、纱质等自然材质。</p><p>4)色彩丰富。为与丰富多彩的生活同步，现如今很多吸顶灯披起了“七彩”外衣。&nbsp;</p><p>5)高技术化。随着科学技术的发展，电子科技被广泛应用于客厅吸顶灯设计，如适应不同电压的吸顶灯，可调节亮度的吸顶灯，放射远的红外红光吸顶灯等等。</p><p>6)节能化。目前节能吸顶灯很受消费者欢迎，如采用3LED芯电的长寿节能灯，既节约能源，又可以根据需要选择亮度。</p><p>7)环保化。环保是吸顶灯设计不变的话题，这与我们栖息的地球有关，已经引起广大消费者重视，这将会成为未来家居照明的主要发展方向。</p><p><br/></p>','0','0','0','','0','0','','','13','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9WBOPjG6dQeIfDn585','1','2020-01-17 09:21:38','','my_shopping_model,my_shopping_color','0','4','0','','0.00','0.00','','{}','1:节能,+,0,2:普通,+,0,','1:黑,+,5,2:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('496','134','0','智能加湿器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:15:29','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿','0','<p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。&nbsp;<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。&nbsp;</p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p><br/></p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','460','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1V2E0Sx8DFX8ODz935','1','2020-01-16 22:15:29','','my_shopping_model,my_shopping_color','0','4','0','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/729828.html\"},\"1\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.26.1c04a98aZGJnlP&id=605208384141&skuId=4245337065638&user_id=3919645743&cat_id=2&is_b=1&rn=73570d905a6017c54c1e28ca58978061\"}}','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('497','134','0','智能洗衣机','','','admin','1','13','','0','0','','1','','','','','0','2020-01-16 22:12:24','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超','0','<p>洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。</p><p>中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。&nbsp;&nbsp;</p><p>从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超过了96%，农村市场也已经超过了53%;随着国家开展家电下乡、扩大内需的政策，洗衣机企业将目光均投向了拥有较大消费潜力的农村市场。未来几年，我国洗衣机市场需求增长空间将主要来自于：以城镇化和农村市场为主的首次需求，以及以城镇市场消费升级为主的更新需求;整个洗衣机市场需求在未来几年将继续保持温和增长态势。</p><p>2010年，我国洗衣机总销量约5000多万台，同比增长接近30%，增长幅度创历史最高水平;其中内销实现3300多万台，同比增长约28%，出口实现1600多万台，同比增长30%以上，均创历史最高增长速度。</p><p>从不同产品来看，2010年我国滚筒洗衣机总销量达到1100多万台，同比增长50%以上，占洗衣机市场销量比重由上年的不足20%上升至20%以上。其中，第四季度各月销量均超过110万台，所占洗衣机市场总销量的份额均超过21%。</p><p>节水将成未来洗衣机重点发展方向，洗衣机产业目标主要涵盖节电节水、产品功能、绿色设计三大方向。在中国家用电器协会编制的冰箱、空调、洗衣机的技术路线图中，就节电节水方面，制定了到 2015年，波轮式双桶洗衣机达到国家能效2级，波轮式全自动洗衣机达到国家能效1级，能效1级的滚筒式全自动洗衣机要达到欧盟A+等级耗电、耗水要求， 滚筒式洗干一体机要达到GB/T23118国标A级耗电、耗水要求。到2020年，滚筒洗衣机达到欧盟A+++等级耗电、耗水要求，波轮式全自动洗衣机达到国标A+等级耗电、耗水要求，滚筒式洗干一体机达到国标A+等级耗电、耗水要求。在产品功能方面，洗衣机的发展方向是大容量，低噪声、低振动。</p><p><br/></p><p>机械力、洗涤液、水是洗衣机洗涤过程中的三要素。洗衣机运动部件产生的机械力和洗涤液的作用使污垢与衣物纤维脱离。加热洗涤液，可增强去污效果。织物不同，适宜液温也不同，反映洗衣机洗涤性能（即洗净衣物的能力）的主要指标是洗净率（或洗净比）和织物磨损率。洗净率是洗衣机在额定洗涤状态下，利用光电反射率计（或白度仪）测定洗涤前后人工污染布及其原布的反射率。洗衣机发展史　从古到今，洗衣服都是一项难于逃避的家务劳动，而在洗衣机出现以前，对于许多人而言，它并不像田园诗描绘的那样充满乐趣，手搓、棒击、冲刷、甩打…这些不断重复的简单的体力劳动，留给人的感受常常是：辛苦劳累。&nbsp;</p><p>1858年，一个叫汉密尔顿·史密斯的美国人在匹茨堡制成了世界上第一台洗衣机，该洗衣机的主件是一只圆桶，桶内装有一根带有桨状叶子的直轴，轴是通过摇动和它相连的曲柄转动的。同年史密斯取得了这台洗衣机的专利权。但这台洗衣机使用费力，且损伤衣服，因而没被广泛使用，但这却标志了用机器洗衣的开端。次年在德国出现了一种用捣衣杵作为搅拌器的洗衣机，当捣衣杵上下运动时，装有弹簧的木钉便连续作用于衣服。19世纪末期的洗衣机已发展到一只用手柄转动的八角形洗衣缸，洗衣时缸内放入热肥皂水，衣服洗净后，由轧液装置把衣服挤干。</p><p>1874年，“手洗时代”受到了前所未有的挑战，美国人比尔·布莱克斯发明了木制手摇洗衣机。布莱克斯的洗衣机构造极为简单，是在木筒里装上6块叶片，用手柄和齿轮传动，使衣服在筒内翻转，从而达到“净衣”的目的。这套装置的问世，让那些为提高生活效率而冥思苦想的人士大受启发，洗衣机的改进过程开始大大加快.</p><p>1880年，美国又出现了蒸气洗衣机，蒸气动力开始取代人力。经历了上百年的发展改进，现代蒸汽洗衣机较早期有了无与伦与的提高，但原理是相同的。现代蒸汽洗衣机的功能包括蒸汽洗涤和蒸汽烘干，采用了智能水循环系统，可将高浓度洗涤液与高温蒸气同时对衣物进行双重喷淋，贯穿全部洗涤过程，实现了全球独创性的“蒸汽洗”全新洗涤方式。与普通滚筒洗衣机在洗涤时需要加热整个滚筒的水不同，蒸汽洗涤是以深层清洁衣物为目的，当少量的水进入蒸汽发生盒并转化为蒸汽后，通过高温喷射分解衣物污渍。蒸汽洗涤快速、彻底，只需要少量的水，同时可节约时间。对于放在衣柜很长时间产生褶皱、异味的冬季衣物，能让其自然舒展，抚平褶皱。“蒸汽烘干”的工作原理则是把恒定的蒸汽喷洒在衣物上，将衣物舒展开之后，再进行恒温冷凝式烘干。通过这种方式，厚重衣物不仅干得更快，并且具有舒展和熨烫的效果。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYITUdOO4dafAhtdr232','1','2020-01-16 22:12:24','','my_shopping_model,my_shopping_color','5','4','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/100004652001.html\"}}','1:智能,+,10,2:机械,+,5,3:全自动,+,15,','1:白,+,10,2:黑,+,5,','');-- 
INSERT INTO `cmseasy_archive` VALUES('498','134','0','路由器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:23:27','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地','0','','0','0','0','','0','0','','','999','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYNfW06Lofg2dRM52677','1','2020-01-17 09:23:27','','my_shop_model,my_shoppingcolor','0','4','188','','0.00','0.00','','{}','1:300M,+,10,2:500M,+,20,','1:蓝,+,0,2:黑,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('499','137','0','产品名称三十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:05:27','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','560','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJz9tU0sEFmG4jYr924','1','2019-08-16 23:05:27','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('500','137','0','产品名称三十','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:13:43','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYoqRcqqx04wOaAxg150','1','2019-05-29 13:13:43','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('501','137','0','产品名称二十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:11','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYdpBjq9drwOlW0lf664','1','2019-08-16 23:06:11','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('502','137','0','产品名称二十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:10','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYbM6nNh7Q3yzd5ea383','1','2019-08-16 23:06:10','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('503','136','0','产品名称二十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:13','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYYcWihLq5Dgx5rzO811','1','2019-08-16 23:06:13','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('504','136','0','产品名称二十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:33:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYOPdjHvE4Pn4u0dk942','1','2019-08-16 23:33:48','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('505','136','0','产品名称二十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:02','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY7g8BajgqgwA2LsQ659','1','2019-08-17 00:02:02','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('506','136','0','产品名称二十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:03','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYm8MzExt0fTjru5P101','1','2019-08-17 00:02:03','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('507','136','0','产品名称二十三','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:05','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','120','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYXDCS4WRJNTKkc4P113','1','2019-08-17 00:02:05','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('508','136','0','产品名称二十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:04','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','166','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYo9eP29z3HPIgb4V659','1','2019-08-17 00:02:04','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('509','135','0','产品名称二十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:34','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','177','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYVUKHL6UcJ7fOOHT585','1','2019-08-17 00:18:34','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('510','135','0','产品名称二十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:35','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','','0','','0','0','0','','0','0','','','199','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYBkQvDdHVOAUgwxb296','1','2019-08-17 00:18:35','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('511','135','0','产品名称十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJfx8fl6qGjFjhRB691','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('512','135','0','产品名称十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590080664809.jpg','1','1','','0','','0','0','0','','0','0','','','1600','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590080664809.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYpkR2pX6G54WXOpL136','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('513','135','0','产品名称十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','210','','0','','','0','a:1:{i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHmUFxBzunoBf4U0359','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('514','135','0','产品名称十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','220','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYjzChf9aIGI4b0p9136','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('515','137','0','产品名称十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:42','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','','0','','0','0','0','','0','0','','','270','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhgNcxGA33CN0WVG368','1','2019-08-17 00:18:42','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('516','137','0','产品名称十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:40','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY6IDNvIpFJj5HxMg820','1','2019-08-17 00:18:40','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('517','137','0','产品名称十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:41','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','250','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYteUoUOdnEtJQ5DO966','1','2019-08-17 00:18:41','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('518','137','0','产品名称十三','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:36:10','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','260','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYu8jmokWatEiOQek651','1','2019-05-29 13:36:10','','','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('519','137','0','产品名称十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:44','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYURynpBhTaiRU1ms696','1','2019-08-17 00:18:44','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('520','137','0','产品名称十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:45','admin','','/html/upload/images/201907/15506330561844.jpg','1','1','','0','','0','0','0','','0','0','','','330','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330561844.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY521mO3OWstsuJvy507','1','2019-08-17 00:18:45','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('521','137','0','产品名称九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:52','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','','0','','0','0','0','','0','0','','','340','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGXyVs7sVq5KE1nj376','1','2019-08-17 00:18:52','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('522','135','0','产品名称八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:53','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','360','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhuFUlRzDbrQ1jM3690','1','2019-08-17 00:18:53','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('523','135','0','产品名称七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:54','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','380','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY0BCt9KtrTRtjv6L213','1','2019-08-17 00:18:54','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('524','135','0','产品名称六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:55','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1TiXfBUr5DbqEzS249','1','2019-08-17 00:18:55','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('525','135','0','产品名称五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:56','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','4050','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGrWKMWNt9VGjomF275','1','2019-08-17 00:18:56','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('526','136','0','产品名称四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:57','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHTxk1P8OSnxGsGI140','1','2019-08-17 00:18:57','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('527','134','0','产品名称三','','','admin','1','0','','0','0','','0','','','','','0','2019-07-22 15:38:36','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRwbmVb35BbAF4uT843','1','2019-07-22 15:38:36','','my_shop_model,my_shoppingcolor','0','1','99','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('528','136','0','产品名称二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 02:11:03','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；产品标识应当清晰、牢固，易于识别；','0','<p>产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。</p><p>产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；<br/></p><p>产品标识应当清晰、牢固，易于识别；</p><p>产品名称包含中英文全程，或者中文拼音。另有对应于全称的企业或产品简称，如：中兴通讯股份有限公司，简称：中兴通讯，英文简称：ZTE。</p><p>企业或品牌名称具备统一的标准字体、标准色、标准大小以区别于同类企业或产品。企业和产品名称应用于企业日常产品、服务、办公、营销行为等公司运作的各个方面，形成完整统一的企业CI系统。所以产品名称是企业识别系统中最重要的一个要素。</p><p><br/></p><p>产品名称应当表明产品的真实属性，并符合下列要求：</p><p>（一）国家标准、行业标准对产品名称有规定的，应当采用国家标准、行业标准规定的名称；</p><p>（二）国家标准、行业标准对产品名称没有规定的，应当使用不会引起用户及消费者误解和混淆的常用名称或者俗名。</p><p>产品名称可以作为注册商标，但应符合商标法的规定。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYTReKg1pr3crT8CO456','1','2019-08-17 02:11:03','','my_shop_model,my_shoppingcolor','0','4','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('529','134','0','产品名称一','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:11:39','admin','','/html/upload/images/201907/15591115606261.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/html/upload/images/201907/15591115599626.jpg\"/></p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115606261.jpg\"/></center><p><br/></p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115602093.jpg\"/></center><p><br/></p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','2','10','html/upload/attachment/201908/1566304174297.png','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','1','CMSEASYOK2nysJX2XzMN7X248','1','2020-01-17 09:11:39','admin','my_shopping_model,my_shopping_color','18','4','996','<p>详细说明</p><p><img src=\"/html/upload/images/201908/15662076301300.jpg\" title=\"15662076301300.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076302696.jpg\" title=\"15662076302696.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076306969.jpg\" title=\"15662076306969.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076314121.jpg\" title=\"15662076314121.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076318531.jpg\" title=\"15662076318531.jpg\"/></p><p><br/></p>','0.00','0.00','83,1#my_shopping_model,2:便携,jia,155;my_shopping_color,6:金,jia,0-73,1#my_shopping_model,2:I7,jia,10;my_shopping_color,1:金,jia,88','{}','1:I5,+,5,/html/upload/images/201908/15662076314121.jpg2:I7,+,10,/html/upload/images/201908/15662076301300.jpg3:I9,+,15,/html/upload/images/201908/15662076318531.jpg','1:金,+,88,/html/upload/images/201907/15590079031945.jpg2:黑,+,8,/html/upload/images/201907/15506336226893.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('179','106','0','国際海上輸送','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:22:38','admin','','/html/upload/images/201907/15590101902500.jpg','1','1','国際海上貨物運送とは、運送人が海上貨物運送契約の約定に従い、海上船舶を運送道具として、運賃を報酬として受け取り、託送人が託送する貨物を海路を経由して一国の港から別の国の港に運送する行為です。国際海運（International Ocean Freght）は国際貿易の中で最も主要な運送方式で、国際貿易の総運送量の中の三分の二以上、我が国のほとんどの輸出入貨物は海洋運送方式で運送されます。中国の海運業が世界海運の中で地位を占める時、その優、劣勢もグローバル競争にあります。','0','<p>国際海上貨物運送とは、運送人が海上貨物運送契約の約定に従い、海上船舶を運送道具として、運賃を報酬として受け取り、託送人が託送する貨物を海路を経由して一国の港から別の国の港に運送する行為です。</p><p>国際海運（International Ocean Freight）国際貿易の中で一番主要な運送方式です。国際貿易の総運送量の中の三分の二以上です。我が国のほとんどの輸出入貨物は海洋運送方式で運送します。</p><p>中国の海運業が世界の海運の中で地位を占める時、その優、劣勢もグローバル競争の洪水の中で暴露して余すところがなくて、これはまさに中国の港航企業の発展パターンが戦略的に転換して正視して重視する現実を行うのです。我が国の海運業は世界海運の発展の中の優位にあります。</p><p>国際通貨基金の予測によると、2006年の国際経済の動きは依然として穏やかな成長を維持しており、アメリカと全世界はそれぞれ3.6%と4.3%の成長率を有し、中国のGDP成長速度も8.5%以上を維持するという。<br/></p><p>経済の強さが世界貿易量の上昇を牽引した。2003年の国際貿易総額は15.35兆ドルだったが、2004年には18.58兆ドルに達し、21%上昇した。2005年は21.1462兆ドルに達しました。国際貿易の中で、「中国要因」は最大のハイライトです。2004年の中国の輸出入、輸出と輸入はそれぞれ1147.4億ドル、5933.6億ドルと5613.8億ドルで、それぞれ35.7%、35.4%と36%伸びて、輸出入総額は初めて1兆ドルの水準を超えました。2005年の輸出入貿易額は14221億ドルに達し、輸入と輸出の値はいずれも世界第3位を占めています。また、中国は世界貿易に占める比重が上昇し、輸出比重は2004年の6.5%から7.3%に上昇し、0.8ポイント増加した。輸入比重は5.9%から6.1%に上昇し、0.2ポイント増加した。わが国の輸出入貿易は良好な伸びを見せ、国際貿易の中で引き続き重要な役割を果たしています。</p><p>国際乾物市場は2001年10月のBD指数は845ポイントまで下落し、通年の最低点となった。2002年指数はやや上昇しましたが、上げ幅は大きくなく、年末は1731ポイントで終了しました。2003年下半期には大幅な上昇があり、10月には4470ポイントまで上昇し、年末には4467ポイントで終了しました。2004年は良好な成長を維持し、通年の最高点は6101点に達し、年末は4438点で終了しました。2005年3月は通年最高点の4956点で、年末は2321点で終了しました。2002年からは、バルク全体の運送量が加速的に上昇しています。世界経済の発展は大量の基礎原材料の需要に対してとても大きいため、鉄鉱石、石炭などの運送量の増加はとても速くて、その中の中国は全世界の経済発展の最も速い国家の一つとして、とても大きな役割を果たしました。ここ10年のバルク貨物の海運量の年平均成長率は17%で、国際市場の水準を大幅に上回っています。一方、世界の乾物海運市場の70%の増加は中国から来ています。鉄鉱石を例にとると、2003年の中国の輸入量は1.48億トンに達し、世界の海運量の28.5%を占めています。2004年の世界の鉄鉱石の海運は6億トンで、我が国は2.08億トンを輸入して、34.6%を占めます。2005年には国の規制の影響で成長速度が低下しましたが、6000万トンの新規需要があり、年間の輸入量は2.48億トンに達し、成長率は20%ぐらいです。中国のこの巨大なエンジンのおかげで、国際乾バルク航空市場は2006年も持続的に成長し、年間平均成長率は6%に達すると予想されます。</p><p>石油輸送において、世界経済は石油に対する依存度が高い。専門家の計算によると、世界経済は1%成長するごとに、毎日40万バレルの石油の支持を必要とします。石油運送の主要な方式として、水路運送は92%の石油製品貿易を完成しました。2003年の世界原油海運量は16億トンで、2004年にはさらに上昇し、2005-2007年の国際原油海運量の平均成長速度は3%前後を見込む。わが国はここ数年、石油需要が大幅に上昇し、2004年には世界第二の石油消費国と輸入国となっています。2003年の原油輸入は9112万トンで、世界の原油貿易量の5.4%を占め、2004年の原油輸入は1.22億トンで、初めて1億トンの大台を突破しました。2005年の原油消費量は3億トンを超え、需給ギャップはさらに拡大し、2005年の原油輸入量は1.27億トンに達する。今後数年間、わが国の石油需要はより高いスピードで成長することが予想され、国際石油海運にはますます大きな影響を及ぼすことになります。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRPI6bOuaP6K4Q7v182','1','2019-05-28 10:22:38','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('180','105','0','国内海上运输','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:25:13','admin','','/html/upload/images/201907/15590103415339.jpg','1','1','国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。','0','<p>国際乾物市場は2001年10月のBD指数は845ポイントまで下落し、通年の最低点となった。2002年指数はやや上昇しましたが、上げ幅は大きくなく、年末は1731ポイントで終了しました。2003年下半期には大幅な上昇があり、10月には4470ポイントまで上昇し、年末には4467ポイントで終了しました。2004年は良好な成長を維持し、通年の最高点は6101点に達し、年末は4438点で終了しました。2005年3月は通年最高点の4956点で、年末は2321点で終了しました。2002年からは、バルク全体の運送量が加速的に上昇しています。世界経済の発展は大量の基礎原材料の需要に対してとても大きいため、鉄鉱石、石炭などの運送量の増加はとても速くて、その中の中国は全世界の経済発展の最も速い国家の一つとして、とても大きな役割を果たしました。ここ10年のバルク貨物の海運量の年平均成長率は17%で、国際市場の水準を大幅に上回っています。一方、世界の乾物海運市場の70%の増加は中国から来ています。鉄鉱石を例にとると、2003年の中国の輸入量は1.48億トンに達し、世界の海運量の28.5%を占めています。2004年の世界の鉄鉱石の海運は6億トンで、我が国は2.08億トンを輸入して、34.6%を占めます。2005年には国の規制の影響で成長速度が低下しましたが、6000万トンの新規需要があり、年間の輸入量は2.48億トンに達し、成長率は20%ぐらいです。中国のこの巨大なエンジンのおかげで、国際乾バルク航空市場は2006年も持続的に成長し、年間平均成長率は6%に達すると予想されます。</p><p>石油輸送において、世界経済は石油に対する依存度が高い。専門家の計算によると、世界経済は1%成長するごとに、毎日40万バレルの石油の支持を必要とします。石油運送の主要な方式として、水路運送は92%の石油製品貿易を完成しました。2003年の世界原油海運量は16億トンで、2004年にはさらに上昇し、2005-2007年の国際原油海運量の平均成長速度は3%前後を見込む。わが国はここ数年、石油需要が大幅に上昇し、2004年には世界第二の石油消費国と輸入国となっています。2003年の原油輸入は9112万トンで、世界の原油貿易量の5.4%を占め、2004年の原油輸入は1.22億トンで、初めて1億トンの大台を突破しました。2005年の原油消費量は3億トンを超え、需給ギャップはさらに拡大し、2005年の原油輸入量は1.27億トンに達する。今後数年間、わが国の石油需要はより高いスピードで成長することが予想され、国際石油海運にはますます大きな影響を及ぼすことになります。</p><p>コンテナ運送については、太平洋航路とユーラシア航路に牽引されて2002年からコンテナ貿易量が急速に増加しました。2003年の国際コンテナ貿易の総量は7900万TEUで、同8.2%伸び、2004年の成長幅は11%まで上昇し、8770万TEUとなった。2005年の太平洋航路の運送量は12%上昇し、ユーラシア航路は15%増加しますが、大西洋航路は安定しています。増幅は大きくないです。2005年に全体コンテナ運送量は元の基礎の上で10%ぐらい上げます。中国のコンテナの海運量は世界の総量の20%ぐらいを占めて、太平洋東行航路とユーラシア西行航路の上で更に60%以上の運送量を占有します。中国の2005年のコンテナ取扱量は7580万TEUに達し、成長率は23.7%に達し、世界平均を上回った。</p><p>船団の建設から見ると</p><p>全世界の1000トン以上の貨物船5700隻は全部で29634.8万トンで、数百の船会社に分布しています。中国の船会社は579隻を持っています。244.5万トンの積載量があります。香港地区の船会社は261隻を持っています。1819万トンの積載量があります。中国と香港地区の輸送力は4259.6万トンで、世界の14.4%を占めています。我が国は国際航運に従事している船会社はもう231社に達しました。総運送力は2210万トン以上に達して、世界第9位になりました。中国の航空輸送企業が海外に設立した独資、合弁会社とサービス機構はすでに数百社に達しており、運送を引き受ける第三国の貨物の比重は日増しに高まっています。</p><p>国際海運で運送する貨物は種類が多く、貨物に対して運送貨物を採用する船舶のタイプ、積み下ろし設備も違います。七海さんは具体的な貨物について、船型、荷役設備の両面から、超大型貨物の運送方法を紹介しています。</p><p>1． トラック。トラックの輸送採用PCTC（PURE CAR TRUCK CARRIERは、その主な特徴は、単層甲板（普通は高さ3～4メートルの間）を採用して、大型トラックを収容できます。その船尾跳の最大積載量は45トンにも達しています。1平方メートルあたりの積載量は3トンにも達するので、重量オーバーのトラックが船尾を通って船室に飛び込むことができます。</p><p>2． 大型設備一般的には、大型設備の輸送は比較的複雑で、一部の部品は体積が大きく、トンの位が大きいので、一般的なコンテナ運送を採用できません。一部の部品はコンテナ運送を採用できます。このような設備は一般的にRORO AND CONTAINERという船形を採用しており、大型部品とコンテナを同時に搭載することができ、多くの大型設備輸送に理想的な船形となっています。</p><p>この船形にはどのような荷役設備が合理的ですか？</p><p>BOLSTER FLATBEDは、長さ4メートル以内の重さ28トン以内の大型部品に適しています。クレーンで貨物をスラブに吊り上げ、高さが一メートルを超えないように吊り上げます。（吊り上げ中に揺動、反転による貨物の損傷を避けることができます。）そして特製のナイロンテープを使います。プレートに貨物を固定し、フォークリフトで船尾を通って貨物を船室に運びます。</p><p>ROLLTRAILERこのような設備は運送の重量が超過して、超大型貨物に適しています。理論的には25メートルの長さと重さは120トンの貨物を積載できますが、最後の跳躍能力と牽引能力の制限を受けて、実際の積載能力はやや小さいです。ROLLTRAILERはリードから船尾を通して船内に飛び込み、貨物の破損ゼロを実現します。</p><p>3．汽車の車両列車の車両は長いので、40メートルの長さがありますので、普通のROLLTRAILERを採用して運送します。ハッチの制限のため、車体は回転して船内に入れることができません。SPECIALDESIGNED TRAILERS（特殊タイヤステアリング）はこの問題を解決できます。この設備のタイヤは360度回転できます。船尾から船内に飛び込む時にUターンして船内に搬入できます。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJ0PSRBqIjOIqxyh942','1','2019-05-28 10:25:13','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('181','105','0','国際航空輸送','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:28:37','admin','','/html/upload/images/201907/15590105447904.jpg','1','1','航空輸送とは、飛行機、ヘリコプター、その他の航空機を使って人員、貨物、郵便物を運ぶ運送方法のことです。旅客、荷物、貨物と郵便の始発、途中と終点は一つの国の外の航空輸送があります。主に国際線で行われます。国際線は政府間の二国間航空輸送協定で結ばれた。輸送の過程で国際航行の安全と利益を保証するために、統一的な手順と規則によって広範な国際協力と協調を行わなければなりません。国際民間航空機関と地域民間航空組織は国際航空輸送において重要な役割を果たしました。中国の国際航空輸送','0','<p>航空輸送とは、飛行機、ヘリコプター、その他の航空機を使って人員、貨物、郵便物を運ぶ運送方法のことです。旅客、荷物、貨物と郵便の始発、途中と終点は一つの国の外の航空輸送があります。主に国際線で行われます。国際線は政府間の二国間航空輸送協定で結ばれた。輸送の過程で国際航行の安全と利益を保証するために、統一的な手順と規則によって広範な国際協力と協調を行わなければなりません。国際民間航空機関と地域民間航空組織は国際航空輸送において重要な役割を果たしました。中国の国際航空輸送は1950年7月から始まりました。当時、元ソビエト連邦と共同で運営していた中国の蘇民用航空会社は北京を起点として元ソビエト連邦の赤塔、イルクーツク、アルマトイの3つの国際路線を開発しました。&nbsp;</p><p>航空輸送は1871年に始まった。当時のフランス人は、普軍に包囲されたパリを風船で送った。1918年5月5日、航空機輸送は初めてニューヨーク-ワシントン-シカゴとなりました。同年6月8日、ロンドンとパリの間で定期郵便便が運航された。30年代に民間輸送機があって、各種の技術性能は絶えず改善して、航空工業の発展は航空輸送の発展を促進します。第二次世界大戦が終わってから、世界中に航路網ができました。各国の主要都市を出発点とする世界航路網が各州に広がりました。1990年、世界定期便の総回転量は2356.7億トンに達しました。</p><p>1.託送人の貨物は運送人に貨物運送状を記入し、国家主管部門の規定に従って必要な有効証明書を添付します。託送人は運送状の記入内容の真実性と正確性に対して責任を負います。託送人が記入した貨物の運送状は運送人が受け取り、運送人が貨物の運送状を記入して発送した後、航空貨物の運送契約は成立しました。</p><p>2.託送人は飛行機をチャーターして貨物を運送するように要求します。チャーター機申請書に記入し、運送人の同意を得てチャーター機の運送契約書を締結した後、航空チャーター機の貨物運送契約は成立します。契約書を締結した当事者は、すべて民間航空主管機関のチャーター機輸送に関する規定を遵守しなければなりません。</p><p>3.託送人は輸送の貨物に対して、国家主管部門が規定する包装標準に従って包装しなければならない。統一的に包装基準を規定していない場合、託送人は輸送の安全を保証する原則に基づき、貨物の性質と飛行機の積載などの条件によって包装しなければならない。上記の包装要求に合致しない場合、運送人は規格に合わない貨物の運送を拒否する権利があります。</p><p>4.託送人は必ず託送荷物に駅、駅と託送人、受取人の単位を明記しなければなりません。氏名と住所は国の規定に従って包装・貯蔵・運輸指標の標識を明示する。</p><p>5.国の規定で保険に加入しなければならない貨物は、託送人が託送時に貨物運送保険をかけるべきです。</p><p>6.託送人が貨物を託送する場合は、民間航空の主管機関が規定する料金で運賃とその他の費用を支払うべきです。託送人と運送人は別途協議がありますが、運賃とその他の費用は全部積み込みをして貨物の運送状を発行する時に一回で支払います。</p><p>7.運送人は貨物が到着した場所に到着した後、24時間以内に受取人に商品到着の通知を出して、受取人は適時に貨物引換証を持って指定の場所に貨物を取りに行きます。貨物は到着通知を出した翌日から無料で3月を保管します。受取人は期限を過ぎて受け取って、運送規則に従って保管料を納めてください。</p><p>8.受取人は貨物を引き出す時、貨物の中途半端または重量に対して異議がなく、そして貨物運送証にサインして、運送人は運送責任を解除します。</p><p>9.積み込みの過失または故意に託送人または受取人の損失を引き起こしたため、託送人または受取人は賠償を要求し、貨物運輸事故記録を記入した翌日から180日以内に、書面で運送人に提出し、関連証明書を添付しなければならない。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJPOyTpq0T4pOqGr804','1','2019-05-28 10:28:37','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('182','104','0','国内航空輸送','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:29:49','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','技術設備は航空輸送を実現する物質の基礎である。主に航路、航空港、飛行機、通信ナビゲーション施設などがあります。航路は地上ナビゲーション施設によって作られた回廊式保護空域で、飛行機の航路が飛ぶ領域です。それぞれの地上ナビゲーション施設を結ぶ直線を中心に、航路の範囲内で上限高さ、下限高さ、幅を定めています。その範囲で飛行する飛行機に対しては、航空交通管制を実施します。航空港は民間空港と関連サービス施設の構成の全体で、飛行機の安全発着基地であり、旅客、貨物、郵便の集散地でもあります。飛行機は主に運搬道具です。機種選択','0','<p>技術設備は航空輸送を実現する物質の基礎である。主に航路、航空港、飛行機、通信ナビゲーション施設などがあります。航路は地上ナビゲーション施設によって作られた回廊式保護空域で、飛行機の航路が飛ぶ領域です。それぞれの地上ナビゲーション施設を結ぶ直線を中心に、航路の範囲内で上限高さ、下限高さ、幅を定めています。その範囲で飛行する飛行機に対しては、航空交通管制を実施します。航空港は民間空港と関連サービス施設の構成の全体で、飛行機の安全発着基地であり、旅客、貨物、郵便の集散地でもあります。飛行機は主に運搬道具です。機種は飛んでいる航路の具体的な状況と全体の経済技術性能を考慮して選択します。通信ナビゲーション施設は情報をつなぎ、飛行機を安全に飛行させて目的地に安全に着陸させる施設です。</p><p>航空輸送は国民経済の発展と国際交流の促進に重要な意義を持っており、多くの国は航空輸送事業の発展を重視している。政府は民間航空総局を設立し、アメリカに連邦航空局を設置し、旧ソビエト連邦に民生航空部を設置するなど、さまざまな優遇政策を実施して航空輸送企業の発展をサポートしています。政府の直接投資、ローン、税金の減免、財政補助金などです。</p><p>航空運送企業の経営形式は主に定期運送とチャーター便運送と専用機輸送があります。普通クラスの運送を主として、後の二つは必要に応じて臨時的に手配します。定期運送はクラスの時刻表によって、固定の機種で固定航路に沿って、固定時間で運送任務を実行します。待機客数が多い場合は、便に沿った残業飛行も可能です。航空輸送の経営品質は主に安全水準、経済効果とサービス品質の3つの面から評価されます。<br/></p><p>航空輸送は1871年に始まった。当時のフランス人は、普軍に包囲されたパリを風船で送った。1918年5月5日、航空機輸送は初めてニューヨーク-ワシントン-シカゴとなりました。同年6月8日、ロンドンとパリの間で定期郵便便が運航された。30年代に民間輸送機があって、各種の技術性能は絶えず改善して、航空工業の発展は航空輸送の発展を促進します。第二次世界大戦が終わってから、世界中に航路網ができました。各国の主要都市を出発点とする世界航路網が各州に広がりました。1990年、世界定期便の総回転量は2356.7億トンに達しました。<br/></p><p>荷物の重さは毛の重さで計算します。単位はキロです。重さが一キロ未満で、一キロの端数を超えると四捨五入します。<br/></p><p>広い飛行機ではない貨物の重さは普通80キロを超えません。体積は普通40*60*100メートルを超えません。広体飛行機は貨物ごとに積載します。重さは普通250キロを超えません。体積は普通250＊200＊160センチを超えません。以上の重さと体積を超えた貨物は西北会社が具体的な条件によって運送できるかどうかを確定します。<br/></p><p>荷物ごとの長さ、幅、高さの和は40センチ以下でなければなりません。<br/></p><p>キロあたりの体積は6000立方センチメートルを超える貨物は軽い泡の貨物によって重さを計算します。軽く泡立てた貨物は6000立方センチメートルごとに1キロに換算して測定します。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQtzTbjowanLdwNF405','1','2019-05-28 10:29:49','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('183','104','0','国際陸上輸送','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:20','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','輸送とは、特定の設備と道具を用いて、物を一つの場所から別の場所に運ぶ物流活動を指し、それは異なる地域の範囲内で、物の空間位置を変えることを目的として、物に対して行う空間シフトである。このシフトによって商品の空間的効果を創造し、その使用価値を実現し、社会の異なる需要を満たす。輸送は物流の中心的な一環の一つであり、現代物流活動の最も重要な機能でもある。輸送は中国語の語彙で、交通手段で物資を別のところに運ぶという意味で、人と物の空間位置の変化を実現する活動です。物流の運送はもっぱら「物」を指す。','0','<p>輸送とは、特定の設備と道具を用いて、物を一つの場所から別の場所に運ぶ物流活動を指し、それは異なる地域の範囲内で、物の空間位置を変えることを目的として、物に対して行う空間シフトである。このシフトによって商品の空間的効果を創造し、その使用価値を実現し、社会の異なる需要を満たす。輸送は物流の中心的な一環の一つであり、現代物流活動の最も重要な機能でもある。&nbsp;</p><p>輸送は中国語の語彙で、交通手段で物資を別のところに運ぶという意味で、人と物の空間位置の変化を実現する活動です。</p><p>物流の運送はもっぱら「物」の運送と運送を指します。二つの都市、二つの工場の間、あるいは一つの大きな企業の中で離れている二つの車の間で、「物」の空間位置を変えることを目的とした活動であり、「物」に対して空間シフトを行う。</p><p>運送は普通運送と配送に分けられます。運送と配送の区別については、いろいろな観点があります。このように言えば、すべての商品の移動は運送で、配送は短距離、小ロットの運送を指します。そのため、輸送とは全体を指し、配送とはその一部を指しています。そして配送の重点は一つです。&#39;&#39;配合する&#39;&#39;字、その主要な意義も体現しています。&#39;&#39;配合する&#39;&#39;文字に；に対する&#39;&#39;送ります&#39;&#39;最終的にリソース構成を実現するためのものです。&#39;&#39;配合する&#39;&#39;サービスです。</p><p>輸送機能要素物流の中の車、船、飛行機などの運送を提供して販売して、物流の中のパイプ、コンベヤーなどの方式の運送を生産します。</p><p>輸送とは、人・財・物を一つのところから別のところに移す過程をいう。</p><p>輸送の主な手段は自転車、板車、三輪車、バイク、汽車、飛行機、船、宇宙船、ロケットなどです。</p><p>輸送はサービス対象によって異なり、旅客輸送と貨物輸送に分けられます。</p><p>公共輸送とは、すべての有料で交通サービスを提供する輸送方式を指す。</p><p>乗用車託送：（乗用車輸送）自動車を商品として出荷した後、大型自動車運搬具を通じて指定の場所に行く運送方式です。&lt;/CN&gt;</p><p>運送運賃の構成</p><p>基本価格まで送って、運行基本価格構成、貨物運送雑費</p><p>ゼロ荷の年間運賃=トン当たりの運賃×計算重量</p><p>完成車貨物の1トン当たりの運賃=基本価格+運行基本価格×運賃マイル</p><p>コンテナ貨物の一箱の運賃=基本価格+運行基本価格×運賃マイル</p><p>貨物の運送には価値保証の役割がある。つまり、どの製品も生産から最終消費まで、一定の時間、距離を経なければなりません。この時間と距離の中で、運送、保管、包装、荷役運搬などの多段階、多回数の貨物運送活動を経なければなりません。この過程で、製品は雨にぬれて湿気、浸水、錆、破損、紛失などを受けるかもしれません。商品の輸送の使命は上述の現象の発生を防止して、生産者から消費者まで移動する過程の中の品質と数量を保証して、製品の価値保証の作用を果たすことができて、つまり製品の存在価値を保護して、この製品を消費者に到着する時使う価値を不変させます。</p><p><br/></p><p>輸送をうまくやると、自然資源、人力資源とエネルギーが節約できます。同時に費用も節約できます。例えば、コンテナ化輸送は、商品の包装を簡略化し、大量の包装用紙と木材を節約することができます。機械化の積み卸し作業、倉庫保管の自動化を実現し、大量の作業員を節約できます。荷物の運送を重視して費用を節約できる事例がたくさんあります。と呼ばれる&quot;中国貨物輸送管理の覚醒第一人者&quot;ハイアールの企業グループは、輸送管理を強化し、近代化した国際自動化貨物輸送センターを建設し、年間在庫の占圧資金と調達資金を15億元から7億元に引き下げ、8億元の出費を節約した。<br/></p><p>貨物の運送は時間の間隔、距離の間隔と人の間隔を克服することができます。これも貨物の運送の本質です。近代的な貨物輸送は短縮されている。<br/></p><p>距離の方面の例証は枚挙にいとまがない。北京では世界各国の新鮮な果物が買えます。全国各地の果物も一年中絶えません。郵便部門は貨物運送を改善して、手紙の距離を大幅に短縮しました。全国の速達は二日間でアメリカのフェデックスに届きます。翌日にはアジアの15都市に配達できます。日本の配送センターは午前10時までできます。時までに注文して、当日に届けます。この輸送速度は人々の地理的距離と時間的距離を一気に近くに引き寄せる。貨物輸送の近代化が進むにつれて、国際輸送能力が大いに強化され、国際貿易がますます促進され、この地球が小さくなったことを人々に感じさせました。<br/></p><p>都市の住民はいつの間にか貨物輸送の進歩の成果を享受しています。南方産のバナナは全国の大都市で一年中買うことができます。新疆のメロン、寧夏の白蘭瓜、東北米、天津小駅米などは季節を問わず市場に供給されます。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYwWEC936lN5EomYR935','1','2019-05-28 10:30:20','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('184','104','0','国内陆运','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:30:47','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','一、輸送は生産の本質的な属性を持っています。輸送の生産過程は一定の生産関係で結ばれています。労働技能を持っている人たちは労働道具（例えば車、船、飛行機及びその他の施設）と労働対象（貨物と旅客）を使って生産し、製品の生産過程を創造します。輸送する製品は旅客輸送にとって、人間の空間的な変位です。貨物輸送にとって、貨物の空間的な変位です。明らかに、輸送は「人と物」の空間位置を変えることを目的とする生産活動であり、この点は通常の意味で労働対象の物理、化学、生物属性を変えることを主とする工業農業生産とは異なる。二、運送する','0','<p>一、輸送は生産の本質的性質を持っている。</p><p>輸送の生産過程は一定の生産関係で結ばれ、労働技能を持つ人々は労働道具（例えば車、船、飛行機及びその他の施設）と労働対象（貨物と旅客）を使って生産し、製品の生産過程を創造します。輸送する製品は旅客輸送にとって、人間の空間的な変位です。貨物輸送にとって、貨物の空間的な変位です。明らかに、輸送は「人と物」の空間位置を変えることを目的とする生産活動であり、この点は通常の意味で労働対象の物理、化学、生物属性を変えることを主とする工業農業生産とは異なる。</p><p><br/></p><p>二、輸送生産は流通の過程で完成したのです。</p><p>輸送は生産地から消費地に製品を運ぶ活動であり、社会全体の生産過程から言えば、運送は流通分野で継続的な生産過程であり、その中で完成します。</p><p><br/></p><p>三、輸送製品は無形です。</p><p>輸送生産は工業農業生産のように労働対象の物理、化学的性質と形態を変えず、労働対象の空間位置だけを変えて、新たな実物形態製品を創造しない。そのため、社会の運送の需要を満たす下に、余分な運送の製品あるいは運送の支出、すべて1種の浪費です。</p><p><br/></p><p>四、輸送製品は生産しながら消費する</p><p>工業農業製品の生産と消費は時間と空間で完全に分離できますが、輸送製品の生産と消費は時間と空間の両方に分けられないで結合されています。生産しながら消費しています。</p><p><br/></p><p>五、輸送製品の非保存性</p><p>輸送する製品は無形で、物質の実体を持たないし、また生産しながら消費する属性のためです。したがって、輸送製品は調達できないし、保存もできない。<></p><p><br/></p><p>六、輸送製品の同一性</p><p>異なった輸送方式にとって、彼らは異なる輸送手段を使って、異なる技術経済特徴を持ち、異なる路線で輸送生産活動を行っていますが、それらは社会に対して同じ効果を持っています。つまり、物品の空間シフトを実現しました。輸送製品の同一性により、各種の輸送方式の間で相互補完、協調、代替ができ、有効な総合運送システムが形成される。</p><p><br/></p><p>1、運送は物流の主要な機能要素の一つである。</p><p>物流の概念によって、物流は「物」の物理的な運動です。このような運動は物の時間状態を変えるだけでなく、物の空間状態も変えました。運送は空間の状態を変える主要な任務を引き受けて、運送は空間の状態を変える主要な手段で、運送は更に運送、配送などの活動に割り当てて、円満に空間の状態の全部の任務を完成することができます。</p><p>2、輸送は社会物質の生産に必要な条件の一つである。</p><p>3、輸送は社会物質の生産に必要な条件の一つである。”</p><p>場所の効用という意味は、同じ種類の「物」は空間の場所によって、その使用価値の実現度合いが違って、その効果の実現も違っています。場所を変えることで使用価値を最大限に発揮し、投入出力比を最大限に高めたことを「場所効用」といいます。輸送を通じて、「物」を場所の一番効果的なところに運び、「物」の潜在力を発揮し、資源の最適化配置を実現することができます。この意味では、輸送によって物の使用価値が向上したということにもなります。</p><p>4、輸送は「第三利潤源」の主な源泉である。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYlfHdT9Fr4Gubi5g482','1','2019-05-28 10:30:47','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('185','110','1','無人のコンビニの風口は当時、「コンビニ」は連創永宣の馮濤数百万元の天使に投資されました。','','','admin','1','27','','0','0','','1','','','','','0','2019-07-09 14:22:11','admin','','/html/upload/images/201907/14360803742226.jpg','1','1','6クリプトンによると、無人のコンビニ「コンビニ」はすでに数百万人民元のエンジェルホイール投資を獲得しており、資本家は共同で馮濤を創立したという。無人のコンビニの風の口はちょうどその時、キャンバスの箱、F 5未来の商店、深い蘭の科学技術、Easy Goなどの1群のプレーヤーは雲のように集まって、アマゾン、ローソン、アリババ、ウォルマートなどの大手も続々と試水します。「コンビニ」は2017年3月に創立され、上海にあります。小型無人コンビニと中型無人コンビニの2つの商品があり、多くのユーザーと比べて、コンビニの違いは柔軟さにある。コンビニの「ミニ無人コンビニ」は、最小単位の敷地面積が1平方メートル未満です。','0','<p>6クリプトンによると、無人のコンビニ「コンビニ」はすでに数百万人民元のエンジェルホイール投資を獲得しており、資本家は共同で馮濤を創立したという。</p><p>無人のコンビニの風の口はちょうどその時、キャンバスの箱、F 5未来の商店、深蘭の科学技術、E<a href=\"#\" target=\"_blank\">a</a>sy Goアマゾン、ローソン、アリババ、ウォルマートなどの大手が続々と試水しています。&nbsp;</p><p>「コンビニ」は2017年3月に創立され、上海にあります。小型無人コンビニと中型無人コンビニの2つの商品があり、多くのユーザーと比べて、コンビニの違いは柔軟さにある。&nbsp;</p><p>コンビニの「ミニ無人コンビニ」は、最小単位の敷地面積が1平方メートル未満（0.68平方メートル）で、投入場所がより柔軟であり、地下鉄駅、オフィスビル、高校などを含み、最小単位のコンビニのコストは約1.3万元（量産後はより低いかもしれない）である。最小単位の無人コンビニは、人の流れの分布によって、より大きな単位面積のコンビニを「つなぎ合わせる」ことができます。100人以下で、一つ置いてもいいです。100人ぐらいで、二つを合わせてもいいです。500人以上で、四つを合わせてもいいです。コンビニの「中型無人コンビニ」は、6つの小型コンビニが協力して、スペースにテーブルと椅子を増設し、消費者のために休憩区間を提供し、地理的な場所が比較的広い団地や公園などに置くことができます。</p><p>技術的には、各階の棚にRFIDを設置し、各隅の隙間に密閉して、識別率を高めています。プロセスはとても簡単です。アリペイの支払いでドアを開けて、持って行って、アリペイの自動差し引き（WeChatは交渉中です）を払います。将来、コンビニはドアの取っ手に手相の識別をしたいと考えています。消費者がドアを開けるという動作をすると、識別できます。<br/></p><p>概念上、コンビニは実は更に販売機に近くて、創始者の范韶偉は、コンビニは伝統の販売機に対する改善だと思っています。一方、伝統的な販売機の経営品目は飲み物と固定包装のお菓子を主とし、コンビニは健康傾向に合う「新鮮な食品類」を主とする。一方、伝統的な販売機の出荷プロセスは先払い、再出荷であり、パイプの陳列方式は空間利用率が低い。落ちていく過程で変形することもあります。便利な家は先に商品を取って、更に差し引いて、積み重ねて置いて、密集して並べることができて、空間の利用率を更に高くならせます。同じ面積の下で、私達の出荷率は伝統の販売機の倍以上です。</p><p>コンビニの選品ロジックは、場所によって異なる商品を選んで、例えばオフィスビルでホワイトカラーのブランチの需要を満たして、弁当、サンドイッチ、サラダなどを提供します。高校では間食、ハロゲン味、パンなどを提供します。家族の平均客単価（14元）を比べて、コンビニは平均客単価を10元ぐらいに設定します。また、小さなプログラムで、消費者は自分の食べたいものをフィードバックして、データによって、逆に種類の選択を指導します。<br/></p><p>小型、中型のコンビニ以外に、コンビニは第三の方面の業務があります。線の下で夫婦の店の特徴は大きさが違っています。面積が違っています。コンビニが提供している無人のコンビニの改造案です。一つは夫婦の店が場所の資源を共有して販売して分けます。二つは加盟方式で、収益の割合がもっと高いです。一方、小さな店の店主は一日十数時間で店を守っている必要はありません。一方、無人販売以外に、他の商売を延期してもっと多くの利益を得ることができます。例えば、ミルクティー、コーヒーなどです。</p><p>“無人小売であれ、小売であれ、本質的には小売の商売である」范韶偉は言います。小売業である以上、店舗の配置上、全体の立場に立つ必要がある。「東一の金づち、西一の棒が一番怖い」。</p><p>点、線、面の合理的な配置は、運営コストと物流コストを最大限に低減することができる。この中で二つの重要な要素を考慮する必要があります。人の流れとポイントを敷設する協同。コンビニの考えは、人の流れが密集しているところに中型無人のコンビニを配置して、周りの100メートルの範囲で10個の小型無人コンビニを配置して、「最小貨物補充ユニット」を形成して、一人で20台の設備の補充を担当することができます。</p><p>RFIDタグのコスト問題に関しては、范韶偉は楽観的な態度を持っています。現在のタグのコストは0.5-0.6元ですが、RFIDが小売市場で普及するにつれて、RFIDタグの価格はきっと下がります。</p><p>今回の融資後、コンビニは上海に試験運営拠点を設立し、中型＋小型無人コンビニは20の店舗を展開する予定です。現在、コンビニでは、量産と投入運営を拡大するため、Pr-Aラウンドの融資を求めています。</p><p>チームの面では、CEOの范韶偉さんはハルビン工業大学を卒業して、商派ソフトウェアチャネル部の北部大区マネージャーを務めました。COO呉威は上海交通大学の修士で、快消品の分野で連続的に創業します。CTO彭庚は上海大学のコンピュータ工学科を卒業しました。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYCJzxtWrGrENvlKX557','1','2019-07-09 14:22:11','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('186','110','1','500万ドルを受け取ってAIの創始企業ObENを投資して、更に社交AIを配置します。','','','admin','1','39','','0','0','','1','','','','','0','2019-07-09 14:22:12','admin','','','1','1','基礎技術の研究に加えて、テンセントは業務駆動によって各種の応用シーンの人工知能化を推進すると表明しました。テンセントの主な業務を結び付けて、未来の会社がゲーム、社交、内容とプラットフォームのツール型の四大応用の方向で力を出すことをも推測するのは難しくありません。特にソーシャルメディア分野では、昨年ザックバーグがVR版のフェイスブックを発売すると発表し、仮想キャラクターツールのOculus Avatarsを展示した。今年7月、Facebook ARスタジオは美図と協力し、ARカメラの3つの特効を提供すると発表した。今、テンセントも','0','<p>基礎技術の研究に加えて、テンセントは業務駆動によって各種の応用シーンの人工知能化を推進すると表明しました。</p><p>テンセントの主な業務を結び付けて、未来の会社がゲーム、社交、内容とプラットフォームのツール型の四大応用の方向で力を出すことをも推測するのは難しくありません。</p><p>特に社交分野では、去年ザックバーグがVR版の発売を表明しました。F<a href=\"#\" target=\"_blank\">a</a>cebook，今年7月にはフェイスブックARスタジオが米図と提携し、ARカメラの3つの特効を提供すると発表した。今は、テンセントも行動します。</p><p>7月18日夜、人工知能創始会社ObENは500万ドルの戦略投資を獲得すると発表しました。この融資は騰訊が投資を受け取り、CMC会長の黎瑞剛と峰尚資本と投資。投融資情報プラットフォームのCrunchbaseのデータによると、ObENは現在4ラウンドの融資を完了し、総額は1370万ドルに達している。これまでの投資者はS如山資本、ソフトバンク韓国リスク投資会社、HTC VIVE Xなどが含まれていました。</p><p>公開資料によると、ObENは2014年に創設され、個性的な仮想音声、イメージと個性を構築することによって、ユーザーの人工知能仮想イメージを創造し、ユーザーが新興のデジタル世界において、彼らの仮想イメージを記憶、管理、運営することができます。つまり、ObENは人工知能ツールを利用して、ユーザの写真と音声に基づいてバーチャルイメージを作成し、ユーザーに異なるAR、VR社交体験をさせることができる。</p><p>以前はObENが主にゲームプレイヤーに仮想イメージを作成するのを手伝っていましたが、今は会社が重点的にスターに仮想イメージを作るのを手伝っています。この仮想イメージを通じて、スターはファンとリアルタイムで対話することができる。未来のある日、ファンはスターにアドバイスを求め、フィードバックを得ることができるかもしれません。また、このアバターはスター長と非常に似ているだけでなく、話し方も同じです。全体としては、このような仮想イメージは、チャットロボットよりも良いです。</p><p>紹介によると、ObENは音声、視覚、自然言語処理技術を初めて融合し、桟全式仮想スターに必要な仮想音声、三次元イメージ、個性化技術を開発した。ObENは今新しいビジネスプラットフォームを作っています。ここでは、スターとファンは、個人化された人工知能を通じてモバイル端末、現実の強化、仮想現実及びスマート機器、モノのインターネットなどのプラットフォームで直接対話することができます。ObENのパーソナライズされた人工知能商品は今年後半にリリースされる予定です。</p><p>最新の融資はObENの製品開発を加速させ、そのスターの人工知能著作権プラットフォームを様々なデジタルプラットフォームに広く応用するように推進します。今回の提携について、テンセント投資の姚磊文執行役員は、ObENがスターの人工知能によって駆動される全く新しい娯楽方式と内容を持ってくると述べました。</p><p>ObENは以前、「一人当たりの人工知能社交プラットフォーム」を作ると言っていました。この方面で、会社はすでに相前後して何度も配置を行いました。</p><p>今年3月のHTC Vive生態圏大会では、ObENがHTC Viveとの提携を発表し、ユーザーが一緒にVRで遊んだり、VRの「K歌」を歌ったりするミニチュアプログラムを開発しました。このプログラムではVRユーザーは友達に招待状を送ることができます。招待された友達は自分撮りとオーディオをアップロードできます。最終的には完成したイメージを使って招待者と一緒にビーチを散歩したり、観光スポットを見学したりします。</p><p>その後の4月末に、ObENはVR社交体験を統合したWeChatチャットサービスの短編を発表しました。もちろん、ユーザーはHTC Viveヘッダを着用する必要があります。ショートフィルムでは、ユーザーは先に自分撮りを撮り、WeChatにアップロードして仮想イメージを作り、HTC Viveを持参すると、WeChatの友達からのメッセージを受信し、音声で直接返事をすることができます。将来はVRやARの機能を持つWeChatが多くのアジアユーザーを獲得できるかもしれません。</p><p>6月末、ObENはまた韓国のSMエンターテインメントと合弁会社の幻星有限公司を設立すると発表しました。聞くところによると、ObENは人工知能技術を利用してSMエンターテインメント傘下の有名な芸能人のためにAIバーチャルイメージを作ります。<br/></p><p>今回のテンセントはObENを投資して、更に会社の社交業務の人工知能化を推進することができますか？今では、大手各社は人工知能実験室の建設に忙しいだけでなく、Facebookのような会社で、より具体的なFacebook AR実験室を設立しました。また、アップルはまもなくARKitプラットフォームを発売すると言われています。将来、テンセントはまた単独のAR実験室を創立するかどうか、更に社交AI業務を配置します。？</p><p><br/></p>','0','0','0','','0','0','','','','','3','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIqsBlQGO2vpH41p972','1','2019-07-09 14:22:12','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('187','109','0','美業情報化の規模は現在、門庭管理店は彼らのためにSaaS管理ソフトセットを提供しています。','','','admin','1','11','','0','0','','0','','','','','0','2019-07-09 14:19:48','admin','','/html/upload/images/201907/15590106398663.jpg','1','1','データによると、2015年、我が国のサービス業は前年同期比8.3%伸び、それぞれ国内総生産と第二産業の増加値を上回って1.4%増と2.3%増となり、国内総生産に占める割合は50.5%に達し、初めて半過ぎました。美業は実体サービス業に属し、市場全体で千億の規模がありますが、情報化の程度は小売飲食業に比べてかなり低いです。その原因は、飲食と小売客の流量が多く、人の群れに触れて、美業客の流量が比較的少ないことと、従業員の素質に加えて情報化の程度を招いていることです。','0','<p>データによると、2015年、我が国のサービス業は前年同期比8.3%伸び、それぞれ国内総生産と第二産業の増加値を上回って1.4%増と2.3%増となり、国内総生産に占める割合は50.5%に達し、初めて半過ぎました。美業は実体サービス業に属し、市場全体で千億の規模がありますが、情報化の程度は小売飲食業に比べてかなり低いです。その原因は、飲食と小売客の流量が多く、人の群れに触れて、美業客の流量が比較的少ないことと、従業員の素質に加えて情報化レベルが低く、管理効率が低いことです。</p><p>米業界の現在の主な管理方式は紙の帳簿と簡単な銀、決済ソフトで、紙の管理は業界の顧客の90%を占めています。機能は簡単で、会員カードを管理する単独版の管理ソフトは約9%を占めています。アメリカの顧客と店の粘りが高く、低周波の消費ですが、一度ユーザーがより良いサービスを受けてから他の店に転向するのは難しいです。だから、予約管理、顧客管理などの需要は飲食と小売より高いです。主に、CRMシステム、レジ、パフォーマンス審査、予約が一体化した管理ソフトを重点としています。</p><p>36クリプトンが最近知っている玄関管のお店は美業です。 S<a href=\"#\" target=\"_blank\">a</a>aS 製品、主要機能有&nbsp;SCRM 会員管理、スマート予約、パフォーマンス給与、マーケティングカード券、万能会計など。ドアの管理店の製品はお客様の中でWeChat公衆番号と手続きです。美容師の端末はお客様の関係維持、給与の照会と予約のモバイル端末です。フロントはUpadで、主にレジと予約です。また、店長用のバックグラウンドは主にPCと一体化したスマートフォンで、全体のデータ管理をしています。</p><p>実は管理の過程もデータを沈殿する過程で、閉ループと生態を開発する過程で、CEOの孟凡剛は記者に教えて、門庭管店は今先にマーケティングツール+SaaSシステムを使って、線の下の米業の店に切り込み、強い関係を創立して、それから銀行システムを収めて微信、支付宝を埋め込みますを通じて(通って)支払って、店のオンライン流水を導きます。プラットフォームに大量の資金を沈殿し、最後にSaaS取引データ、消費行動データに基づいて大データ分析を行い、米業製品、プロジェクトのサプライチェーンを拡張する。例えば、门庭管店は最近韩国の皮肤検査器を作っています。検査が终わったら、お客様のファイルに入れて、知能管理プラットフォームに総合して、お客様が来たら、个人の特徴に対してサービスを行うことができます。</p><p>米業界の変革は二つの陣営を形成しました。一つの陣営は大規模な会所で、多くのお客さんを蓄積しました。お年寄りは年齢とともに養生に対する需要がますます強くなってきました。一旦養生に切り込むと、80、90のようなインターネットの主力軍とは少し離れています。もう一つは2年近く新しくオープンした店です。会員の資源は80、90人のグループに対してどのようにサービスをするかが主要な任務となり、若者はインターネット利用シーンの人達に属しているので、新店はSaaSソフトを導入しやすいです。門前屋は若年化した店に偏り、経験と資金を積んでから老舗になる。</p><p>情報化されていない店に対しては、前の段階のデータ入力が一番面倒です。玄関管理店はカスタマーサービスを派遣してデータの整理を手伝っています。時間は2-3日間ぐらいです。第二に、ソフトウェアの普及です。この点については、専門的なトレーニングがあります。音声ビデオの遠隔トレーニングも含まれています。有料モードでは私有雲の配置と公有雲に分けられ、公有雲は万元にすぎない。その後、毎年1000元のメンテナンス費用がある。ソフト全体のインストールは、店舗ごとに次の人のコストを節約することができます。</p><p>門庭管店のお客様はクレティナ、シルクドメイン養発、慶熙美学、ミレニアム、自然美などを含みます。</p><p>業界の競争品については、米産業SaaSプロバイダーは、博カード、おうチア、米約為替、美しい加、点美、米業邦なども含まれています。</p><p>孟凡剛は美業SaaSの一つの敷居を作るのはソフトウェア開発能力であり、強い研究開発能力があってこそ、ページの簡潔さ、機能がそろっていて、管理に適した製品を開発することができ、お客様と会社の粘りが高まると考えています。販売能力、店舗管理店は現在パートナー方式を採用しており、代理ルートは自分の顧客を発展させることができます。</p><p>チームは現在30人で、半分以上は技術者で、CEOの孟凡剛はかつて会友科技CEO、車に従ってCEOを務めていました。8年間のインターネットとモバイルインターネットの運営管理経験があります。会社はすでにエンジェルローンを完成しました。次の融資を計画しています。</p><p><br/></p>','0','0','0','','0','0','','','','当サイト','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYEEg44pdjX3k5GMP332','1','2019-07-09 14:19:48','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('188','109','1','オンラインをクリックして助けを求めて、応答のはすべてロボットで、このように本当に良いですか？','','','admin','1','95','','0','0','','1','','','','','0','2019-07-09 14:19:46','admin','','/html/upload/images/201907/15590106116481.jpg','1','1','人工知能技術の発展は人々の生活と仕事のやり方を絶えず変えています。それはある程度社会の発展と進歩を促しました。人工知能は万能ではないです。機械は人間の思考と情緒を備えていないからです。ウェブサイト上のオンラインヘルプの窓口を開けてみたら、あなたの答えは冷たいロボットだけだったと気づき、がっかりするでしょう。2016年4月には、FacebookのF 8会議でMessengerの開発者たちの明るい未来を描いたマーク・ザッカーバーガーが、「友達と一緒のように」と宣言しました。','0','<p>人工知能技術の発展は人々の生活と仕事のやり方を絶えず変えています。それはある程度社会の発展と進歩を促しました。人工知能は万能ではないです。機械は人間の思考と情緒を備えていないからです。ウェブサイト上のオンラインヘルプの窓口を開けてみたら、あなたの答えは冷たいロボットだけだったと気づき、がっかりするでしょう。</p><p>2016年4月、マーク・ザックバーグはF<a href=\"#\" target=\"_blank\">a</a>cebookのF 8会議では、Messengerの開発者たちが明るい未来を描き、「友達と同じようにロボットと話したい」と宣言しました。これらの開発者は、Facebook、Google、Microsoftなどの大手企業の認証を持ち、独立したモバイルアプリケーションの時代が終わったと主張し、新しい方式の到来を祝います。11ヶ月前にFacebookが公式に開発したチャットロボット「M」のベータテストでAIの失敗率が70%だったと発表した後、プラットフォームを更新しました。そして、開発者にMessengerでより軽量なアプリケーションを開発し、会話入力を無効にするよう提案しました。</p><p>Wordhop.ioについては、これまで2つのことを知っています。一つ目のことは、AIが本当に難しいです。ロボットを100%友達のように人間と交流するにはまだ長い年月が必要です。ロボットは人間のように共感できないからです。第二に、Facebookの消費者は買い物や天気に興味があると企業にメッセージを送ることはない。これらの体験は、チャットマシンを前提とした条件であり、情報伝達の分野からソーシャルネットワークの分野に広がった業界データのサポートも必要である。</p><p>Facebookユーザーが本当に欲しいのは、問題がある時にすぐに業者からの返信が得られます。</p><p>消費者がFacebook上で事業者にメッセージを送る主な理由はサービスを獲得したいからです。他のものは全部浮雲です。このようなインタラクティブ前売りはお客様の質問から始まるかもしれません。タイムリーな返答は取引を進めることができます。顧客が顧客サービスの販売に連絡すれば、彼らは本当に問題がありますので、顧客サービスを教えてください。いくつかの答えはロボットで答えられますが、もっと複雑な問題は人に任せて解決できます。便利な道具がある場合、人間の回復速度はロボットに匹敵します。</p><p>しかし、多くのロボット開発者は、最も必要な部分に集中していないで、新たなユーザー体験を創出したり、古いchatbotに関する概念を再開発したりすることを求めています。ロボット開発者が参加率が低いと思ったら、AIが失敗したのではなく、消費者を最初から行きたくない道に導いてくれたからです。既存の消費者行動パターンを利用していないし、ロボットが顧客のニーズに応えるトレーニングもしていません。AIの役割は、ロボット開発者が想像する創造的体験を実現し、消費者がこの体験を通じて相互作用するように指導するだけです。</p><p>Facebookは現在、ロボット開発者にセッション入力を完全に無効にするよう提案しています。</p><p>個人的にはFacebookが提案しているようにチャット入力を無効にすることはAIとNLPの技術制限に対する正しい解決策だとは思いません。会話能力のない通信ロボットは、ニュースロボットにとって受け入れられます。この体験は通知とコンテンツ消費によって駆動されます。しかし、サービスをベースとした業務であれば、ユーザーに友好的なインタラクティブなプラットフォームを提供する必要があります。文字入力がMessengerの主要な方式であれば、お客様の意思と能動性を制限し、想像できる他の方法のカスタマーサービスを求めさせられます。あるいは返事を遅くするだけで、お客様を失望させます。IVRを考えてみてください。メニューのオプションを聞くたびに、「0」を押してください。</p><p>業界は自動的に人工的に結合する方式を採用しなければならない。</p><p>中国のWeChatの手続きはメッセージとインタラクティブに統合され、開発者のチャットロボットに対する期待を満たしていますが、これは東洋の文化現象です。西洋企業はまず既存の消費者行動を利用し、このような行動データをより良く利用しなければなりません。もしあなたが「チャットロボットは人工サービスに取って代わる」という概念のファンではなく、開業当初の顧客に対する承諾を守るだけで、このような技術を導入すれば、お客様との交流を強化することができます。今のフェイスブックの消費者の期待を実現できれば、時間が経つにつれて、あなたも新しい機能を追加して、消費者をあなたの期待の方向に導くことができます。最終的には彼らの需要を満たすかもしれません。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBch1stLWGqmFhze909','1','2019-07-09 14:19:46','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('189','109','1','滴滴は間もなくoffに接続して、単独の車の大戦の構造を共有しますかます生んで変わります','','','admin','1','20','','0','0','','1','','','','','0','2019-07-09 14:19:45','admin','','/html/upload/images/201907/15590106644556.jpg','1','1','36クリプトンはoffの内部から情報を得て、今年の4月に、offは滴滴の旅のアプリに接続します。その時、ユーザーは直接滴滴の上でoffのサービスを使うことができます。この件は最近頻繁にスケジュールを上げられています。内部情報は来月にはアクセス可能です。オフィスの内部スタッフが言った。36クリプトンは滴滴オフィシャル、off公式にこのニュースを確認しましたが、投稿を締め切る時、両社はこれを確認したり、否定したりしませんでした。off創始者のドビー氏は昨年12月に、いつ滴滴アプリに接続するかは明確なスケジュールがないと述べました。「オフモードはGPSがないので、使います。','0','<p>36クリプトンはoffの内部から情報を得て、今年の4月に、offは滴滴の旅につながるかもしれません。<a href=\"#\" target=\"_blank\">a</a>ppその時、ユーザーは直接滴の上でoffのサービスを使うことができます。</p><p>この件は最近頻繁にスケジュールを上げられています。内部情報は来月にはアクセス可能です。オフィスの内部スタッフが言った。36クリプトンは滴滴オフィシャル、off公式にこのニュースを確認しましたが、投稿を締め切る時、両社はこれを確認したり、否定したりしませんでした。</p><p>off創始者のドビー氏は昨年12月に、いつ滴滴アプリに接続するかは明確なスケジュールがないと述べました。offのモードはGPSがないので、ユーザーが車を見たらすぐ使います。全体のロジックは滴滴プラットフォームとタクシーを打つロジックは違いますが、近いうちに滴滴と一緒に何かを出します。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590115762957.jpg\" title=\"15590115762957.jpg\" alt=\"57.jpg\"/></p><p><br/></p><p>ただし、同様のアクセスは前例がないわけではない。今年2月、微信連合モービルは、ユーザーが微信「掃一掃」を通じてバイクの車体の二次元コードをスキャンすると、直接にモービルの微信小プログラムに入ることができると発表しました。</p><p>これは初めてoffが滴滴にアクセスするというメッセージを伝えたのではなく、両プラットフォームの初めての深さ結合でもない。この前、滴はoffの最近の三輪の融資に参加しました。騰訊科技の報道によると、1台のシェアマイカー投資者によると、offは多輪融資を経て、滴滴はすでにoffの最大株主となり、株の30%を超えた。これは、滴滴のoffでの発言力がより強くなったことを意味しています。同時に、offの成敗は、滴滴が最大の利息関係者になります。</p><p>これは、滴滴がoffにアクセスした後、巨大なユーザー流量の入口としてその流れを導き、offはさらに商売の体を固め、滴滴の加持の下で業界の地位と想像空間を高めることが理解できる。</p><p>また、本当にoffを入れたら、滴滴とその背後にある資本がいっそう自分のモビリティ分野でのギャップを補っているという意味もあります。</p><p>ある事情を知っている人は36クリプトンに対して、以前は滴滴も共同の自転車を作りたかったが、いくつかの原因で実現できず、最終的にはオフの投資先として働くしかないと漏らしました。しかし、これは滴滴が更にこの市場に足を踏み入れることはないという意味ではない。</p><p>滴滴投資offは、「最後の三キロ」を狙ったチャンスにほかならない。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201907/15590106398663.jpg\" title=\"15590115918734.jpg\" alt=\"58.jpg\"/></p><p><br/></p><p>現在の国内は「最後の3キロ」の分野でまだ非常に初級の段階です。北上広域の一线都市では、交通の混雑によって、各大モビリティプラットフォームが「最后の3キロ」の争奪戦が激化しています。</p><p>「出発地から目的地まで3キロ、タクシーに乗るかそれとも自転車に乗るかはユーザーにとって選ぶことができます。どれを選んでも大丈夫です。」一人のoffの内部の従业员は、滴滴の方法は自分で异なっているオプションをすべて覆いますと言います。</p><p>滴滴とoffと投資家から見ると、シェアバイクの分野はすでに急速な成長期を迎えています。Ofoの広報担当者はかつてメディアに対し、専用車と快速車を例にとって、2012年以降のこの数年間、発展速度は非常に速いと語っていました。offは1年間で、日本からの注文量を200票から50万本に達成した。「過去の専用車の快速は、今のoffはいずれも高速成長を経験しています。この勢いは似ています」。広報担当者によると。</p><p>昨年12月末、offは共同でおひねりを出しました。これはoffが滴滴戦略に投資された後、双方が初めて大規模な協力を行いました。活動のとったおひねりの策略、同じく滴滴がかねてから市場の普及を行う利器の1つだと見なされます。</p><p>滴滴方の話によると、2017年は相変わらず主要な精力を旅行分野に置いて、一人一人の旅を通じたいです。これはすべての移動手段がカバーされることを意味しています。自転車を共有するのも滴滴発力の方向の一つです。</p><p>36クリプトンは、滴滴がさらに自転車に接続して共有するのはもう一つの重要な原因があると考えています。「過酷」なインターネット専用車の規定に比べて、自転車の共有は初期に政策奨励を受け、制約条件もかなり合理的です。去年からずっとネット予約車の新政の影響を受けています。政策の角度から見ても、新しい業務の成長の角度から見ても、さらに自転車を共有する風口からスプーンをもらえるかもしれません。</p><p>でも、36クリプトンはまだ疑問があります。ナビゲーションのないoffはどうやって滴滴に接続しますか？そしてアクセスしたら、ユーザーにどのような影響を与えますか？</p><p>「私が知っている限りでは、滴滴は技術とナビゲーションのこの速いことを第三者の会社に請け負うかもしれません。」上記off内部の従業員は、滴滴に接続した後のoffは依然としてナビゲーションがないかもしれないと言っています。ユーザーはページ上で主にスキャンコードのロックと支払い機能を使います。</p><p>ユーザー体験については、上記の内部スタッフは「もともとオフの本体機能は単一で、操作が非常に簡単で、シームレスに滴滴プラットフォームに接続できると信じています」と述べ、「将来の傾向は、携帯に搭載されるアプリの数が少なくなることです」と強調しました。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcRxhJAQONfzQgBi372','1','2019-07-09 14:19:45','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('190','111','0','私たちの取引先6','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:17','admin','','/html/upload/images/201907/15590119613906.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYrFFP2HJK6dqK3EO405','1','2019-05-28 10:52:17','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('191','111','0','私たちの取引先5','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:52:49','admin','','/html/upload/images/201907/15590119824821.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJfXqRGA5YldmUTW569','1','2019-05-28 10:52:49','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('192','111','0','私たちの取引先4','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:10','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYhwXJUQSS037urC592','1','2019-05-28 10:53:10','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('193','111','0','私たちの取引先3','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:53:53','admin','','/html/upload/images/201907/15590120451192.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIzPvDiJ69VLjNGR766','1','2019-05-28 10:53:53','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('194','111','0','私たちの取引先2','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:16','admin','','/html/upload/images/201907/15590120684878.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9GqCQFgFQyglQj7360','1','2019-05-28 10:54:16','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('195','111','0','私たちの取引先1','','','admin','1','0','','0','0','','0','','','','','0','2019-05-28 10:54:32','admin','','/html/upload/images/201907/15590120844373.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYAQclj7YrB9fd0zB432','1','2019-05-28 10:54:32','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('196','118','0','2000','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:54:51','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1982年に会社が設立されました。','0','<p>2000年に会社で起こったこと。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYHm0xy8DUB1nvRaR236','1','2019-05-29 08:54:51','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('197','118','0','1995','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:17','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1995年に会社で起こったこと。','0','<p>1995年に会社で起こったこと。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRNotaOXnvroS1LX687','1','2019-05-29 08:55:17','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('198','118','0','1987','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:55:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1987年に会社で起こったこと。','0','<p>1987年に会社で起こったこと。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY9iSxLUYzDOVbMek325','1','2019-05-29 08:55:40','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('199','118','0','1983','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:19','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1983年に会社で起こったこと。','0','<p>1983年に会社で起こったこと。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYqaGTtWY1GuaBar1334','1','2019-05-29 08:56:19','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('200','118','0','1982','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 08:56:40','admin','','/html/upload/images/201907/15590908078262.jpg','1','1','1982年に会社が設立されました。','0','<p>1982年に会社が設立されました。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYpCNyNaObllf1WLH124','1','2019-05-29 08:56:40','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('201','119','0','“情熱の夏”バスケットボールの試合は円満に終わりました。','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:02','admin','','/html/upload/images/201907/15590951812642.jpg','1','1','2018年8月1日、世紀天鴻「情熱の夏」バスケットボール試合が終わりました。最終的に、激しい競争を経て、世紀天鴻システム事業部、行政部からなるシステム夢のチームと世紀天鴻大取引先事業部、電気商取引事業部、グループ総裁からなる伝奇チームがそれぞれ優勝、準優勝を獲得しました。世紀天鴻常務副編集長兼システム事業部総経理の楊凱さんが優勝準優勝チームに選ばれました。今回のバスケットボールの試合を通じて、各部門の間の距離を縮めて、お互いの交流と理解を深めました。社員の文化生活を豊かにし、社員のチームワーク意識と集団栄誉感を強めました。','0','<p>&nbsp;2018年8月1日、世紀天鴻「情熱の夏」バスケットボール試合が終わりました。最終的に、激しい競争を経て、世紀天鴻システム事業部、行政部からなるシステム夢のチームと世紀天鴻大取引先事業部、電気商取引事業部、グループ総裁からなる伝奇チームがそれぞれ優勝、準優勝を獲得しました。世紀天鴻常務副編集長兼システム事業部総経理の楊凱さんが優勝準優勝チームに選ばれました。</p><p>&nbsp; &nbsp; &nbsp; 今回のバスケットボールの試合を通じて、各部門の間の距離を縮めて、お互いの交流と理解を深めました。従業員の文化生活を豊かにし、従業員のチーム意識と集団栄誉感を強め、ボールで友達を作って、友情を増進し、調和のとれた会社雰囲気を促進し、人々の心を凝集する目的を達成しました。2018年8月1日、世紀天鴻の「情熱の夏」バスケットボール試合は幕を閉じました。最終的に、激しい競争を経て、世紀天鴻システム事業部、行政部からなるシステム夢のチームと世紀天鴻大取引先事業部、電気商取引事業部、グループ総裁からなる伝奇チームがそれぞれ優勝、準優勝を獲得しました。世紀天鴻常務副編集長兼システム事業部総経理の楊凱さんが優勝準優勝チームに選ばれました。</p><p>&nbsp; &nbsp; &nbsp; 今回のバスケットボールの試合を通じて、各部門の間の距離を縮めて、お互いの交流と理解を深めました。従業員の文化生活を豊かにし、従業員の団体意識と集団栄誉感を強め、ボールで友達を集め、友情を増進し、調和の取れた会社の雰囲気を促進し、人々の心を凝集させる目的を達成しました。 2018年8月1日、世紀天鴻「情熱の夏」バスケットボール試合が終わりました。最終的に、激しい競争を経て、世紀天鴻システム事業部、行政部からなるシステム夢のチームと世紀天鴻大取引先事業部、電気商取引事業部、グループ総裁からなる伝奇チームがそれぞれ優勝、準優勝を獲得しました。世紀天鴻常務副編集長兼システム事業部総経理の楊凱さんが優勝準優勝チームに選ばれました。</p><p>&nbsp; &nbsp; &nbsp; 今回のバスケットボールの試合を通じて、各部門の間の距離を縮めて、お互いの交流と理解を深めました。従業員の文化生活を豊かにし、従業員の団体意識と集団栄誉感を強め、ボールで友達を集め、友情を増進し、調和の取れた会社の雰囲気を促進し、人々の心を凝集させる目的を達成しました。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYVxCBeWGRDWucvRm347','1','2019-05-29 09:59:02','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('202','119','0','出航を夢見、未来を抱きしめます。2019創業孵化プラットフォーム年会。','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 09:59:57','admin','','/html/upload/images/201907/15590952222752.jpg','1','1','2019年1月23日、世紀天鴻創業孵化プラットフォーム年はシ博で開催されます。今回は「夢は航海を開始し、未来を抱擁する」というテーマで開催されます。世紀の天鴻のすべての孵化プラットフォームの創始者、従業員が一堂に会して、共に盛典に襄をする。世紀天鴻会長の任志鴻、輪値総経理の于宝増も年会に参加しました。年会は世紀天鴻常務副総経理張学軍が主宰します。会議の中で、山東優易練図書有限公司、山東佰鴻壹銘教育科学技術有限公司、山東志鴻超仁図書有限公司、山東先徳叡図書有限公司、山東尚鴻進学援助教育コンサルティング有限公司、北京小鴻文','0','<p>2019年1月23日、世紀天鴻創業孵化プラットフォーム年はシ博で開催されます。今回は「夢は航海を開始し、未来を抱擁する」というテーマで開催されます。世紀の天鴻のすべての孵化プラットフォームの創始者、従業員が一堂に会して、共に盛典に襄をする。<br/>&nbsp; &nbsp; 世紀天鴻会長の任志鴻、輪値総経理の于宝増も年会に参加しました。年会は世紀天鴻常務副総経理張学軍が主宰します。会の中で、山東優易練図書有限公司、山東佰鴻壹銘教育科学技術有限公司、山東志鴻超仁図書有限公司、山東先徳叡図書有限公司、山東尚鴻進学援助教育コンサルティング有限公司、北京小鴻文化メディア有限公司、シ博鴻書坊文化伝播有限責任公社会社、山東瓜二文化メディア有限公司、北京触学科技有限公司、山東天易鴻図教育科学技術有限公司などのプロジェクト責任者はそれぞれ自分の創業物語を共有し、自分のチームを率いて展示しました。先独英明の躍動感あふれるダンス、百鴻壹銘の創業版「砂漠ラクダ」、尚鴻進学組の力強さが印象的な「走る」などがあります。その後、世紀天鴻会長の任志鴻さんは来場した創業会社に金メダルを記念して、先徳叡さん、百鴻壹銘さんに「優秀な創業チーム」の表彰を行いました。<br/>世紀の天鴻創業孵化プラットフォームは挑戦とチャンスを秘めた環境であり、各創業会社は着実な作風、粘り強い精神で、創業の道に自分の光芒を放っています。2018に別れを告げて、新しい2019に直面して、私達に希望を持って、世紀の天鴻創業孵化プラットフォーム2019の新しい光り輝きに憧れます。<br/>&nbsp; &nbsp; もしあなたが起業の夢を持っているなら、ためらうことなく、チャンスを掴んで、起業して、プラットフォームを孵化して、あなたの素晴らしい人生を生きてください。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYYLGJWgkXGdDceA8172','1','2019-05-29 09:59:57','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('203','119','0','2019年太極拳競技活動が始まりました。','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 10:00:40','admin','','/html/upload/images/201907/15590952834831.jpg','1','1','  中華伝統文化を発揚し、天鴻陽光スポーツ活動を豊かにするために、広範な従業員のチームワークを育成し、積極的に進取する優良品質を育成します。今回の太極拳の試合について、会社はまず陳式洪派太極拳八十一式のトレーニングを行います。宣伝動員を経て、太極拳はトレーニング、チームワークの重要性を十分に認識させ、各部門の積極性を有効に引き出しました。参加社員はシステム事業部チーム、大顧客事業部チーム、業務部門連隊、機能部門連隊の四つのチームに分けられます。各部','0','<p>&nbsp; &nbsp; 中華伝統文化を発揚し、天鴻陽光スポーツ活動を豊かにするために、広範な従業員のチームワークを育成し、積極的に進取する優良品質を育成します。今度の太極拳の試合について、会社はまず陳式洪派太極拳八十一式の訓練を行います。宣伝動員を経て、太極拳はトレーニング、チームワークの重要性を十分に認識させ、各部門の積極性を有効に引き出しました。参加社員はシステム事業部チーム、大顧客事業部チーム、業務部門連隊、機能部門連隊の四つのチームに分けられます。各部門の従業員は積極的に協力して、時間通りにトレーニングに参加して、今後の太極試合でいい成績を取るために基礎を作ります。<br/></p><p></p><p>&nbsp; &nbsp; 今回の研修活動は陳氏洪派太極拳の後継者である李玉福先生を招いて指導教育を行う。研修現場で、李先生は従業員と真剣に交流し、心をこめて指導しました。「太極起式、野馬はたてがみ、白鶴の翼、左右に膝を抱えて拗ねて歩く」などの一芸は雲のように悠々と流れていて、実に美感に満ちています。各部門の従業員は毎日時間通りに列を作って勉強しています。</p><p></p><p>&nbsp; &nbsp; 太極拳は武術の重要な構成部分として、歴史が長くて、広くて深いです。中華民族の至宝です。今回の太極拳は天鴻園に入って活動して、従業員達に体を丈夫にすることができます。世紀の天鴻企業文化の広範な発展をさらに推進します。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYzzOpkeWefOxetiy687','1','2019-05-29 10:00:40','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('237','122','0','520軒のアフターサービスネットワーク','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:03','admin','','/html/upload/images/201907/15591169541800.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYztbAWrIud1FqAwM189','1','2019-05-29 16:02:03','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('238','122','0','150元いっぱいで郵送します','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:02:43','admin','','/html/upload/images/201907/15591169739359.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYXe8jxOmWqQ070gQ904','1','2019-05-29 16:02:43','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('239','122','0','15日間無料で交換します','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:01','admin','','/html/upload/images/201907/15591169933799.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYLDoNiWI7NO4xBfM994','1','2019-05-29 16:03:01','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('240','122','0','7日間の返品は無料です','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:22','admin','','/html/upload/images/201907/15591170149117.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYmDaJUfapbwNpp7x939','1','2019-05-29 16:03:22','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('241','122','0','修理の予約','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 16:03:41','admin','','/html/upload/images/201907/15591170337490.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYcGhrO1KVcIWghek879','1','2019-05-29 16:03:41','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('242','113','0','プロジェクトマネージャー','','','admin','1','11','','0','0','','0','','','','','0','2019-06-13 16:23:39','admin','','/html/upload/images/201907/15590120844373.jpg','1','1','業務経理業務マネージャーの「AE」の職責は対外、取引先と交渉、連絡、提案、入金などです。これから分かるように、本物の「AE」は、「業務を引っ張る」業務員ほど簡単ではない。彼は販売、市場調査、企画、設計、制作、メディアなどの専門知識を熟知し、人間関係の処理能力も必要である。','0','<p>業務経理業務マネージャーの「AE」の職責は対外、取引先と交渉、連絡、提案、入金などです。これから分かるように、本物の「AE」は、「業務を引っ張る」業務員ほど簡単ではない。彼は販売、市場調査、企画、設計、制作、メディアなどの専門知識を熟知し、人間関係の処理能力も必要である。</p>','archive/show_job.html','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYQucDYsG9O6OUqzO569','1','2019-06-13 16:23:39','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('243','111','0','パートナー8','','','admin','1','0','','0','0','','0','','','','','0','2019-06-14 14:51:13','admin','','/html/upload/images/201907/15590120124140.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYBlFncAe0iLoY9Qf261','1','2019-06-14 14:51:13','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('246','120','0','某某の栄誉','','','admin','1','0','','0','0','','0','','','','','0','2019-07-03 14:27:51','admin','','/html/upload/images/201907/gushi.jpg','1','1','名誉は文字を説明する。','0','<p style=\"text-align: center;\"><br/><img src=\"/html/upload/images/201907/gushi.jpg\"/></p><p><br/></p><p>名誉は文字を説明する。</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYO70f2XfrUVxUUz6867','1','2019-07-03 14:27:51','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('247','95','0','ソリューション2','','','admin','1','2','','0','0','','0','','','','','0','2019-07-09 18:33:20','admin','','','1','1','ソリューション2文字で説明します。','0','<p>ソリューション2文字で説明します。</p>','0','0','0','','0','0','','','','','0','5','html/upload/attachment/201905/15579676979434.zip','0','N;','','0','0','0','0000-00-00','0','CMSEASYQN2pfl790LO5Ouo231','1','2019-07-09 18:33:20','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('248','95','0','ソリューション1','','','admin','1','30','','0','0','','0','','','','','0','2019-07-25 16:23:16','admin','','/html/upload/images/201907/14360857154349.jpg','1','1','ソリューションテキスト説明。','0','<p>ソリューションテキスト説明。</p><p>二</p>','0','0','0','','0','0','','','','','0','7','html/upload/attachment/201907/15628273460708.gif','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360807979603.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14360854145721.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/14363453760256.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYQ7C6mNjnb3EPO0p724','1','2019-07-25 16:23:16','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('249','95','0','ソリューション3','','','admin','1','0','','0','0','','0','','','','','0','2019-07-09 18:41:44','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYH6rFJkqJoC5fDzk552','1','2019-07-09 18:41:44','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('250','109','0','ニュース1','','','admin','1','0','','0','0','','0','','','','','0','2019-07-15 08:22:23','admin','','','-1','1','pニュース/p','0','<p>ニュース</p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYjRpay6916R4orui585','1','2019-07-15 08:22:23','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('251','99','0','ああ','','','admin','1','0','','0','0','','0','','','','','0','2019-07-17 16:10:15','admin','','','-1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYDXXd2Gnc7oq8yrr534','1','2019-07-17 16:10:15','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('252','99','0','Iphone11','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 22:59:51','admin','','/html/upload/images/201907/15506330655517.jpg','1','1','','0','','0','0','0','','0','0','','','8868','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYm02IQJaO4SVAQbd387','1','2020-01-18 22:59:51','','my_shopping_model,my_shopping_color','50','3','999','','0.00','0.00','','{}','1:A,+,5,2:B,+,10,','1:A,+,20,','');-- 
INSERT INTO `cmseasy_archive` VALUES('253','99','0','MackBook','','','admin','1','0','','0','0','','0','','','','','0','2020-01-18 23:01:04','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','9989','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYnD6OigXegiRSDHi278','1','2020-01-18 23:01:04','','my_shopping_model,my_shopping_color','5','3','999','','0.00','0.00','','{}','1:A,+,10,2:B,+,20,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('375','99','0','CH-17 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:22:11','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要','0','<p>从过滤网络流量的角度来看，路由器的作用与交换机和网桥非常相似路由器</p><p>。但是与工作在网络数据链路层，从物理上划分网段的交换机不同，路由器使用专门的软件协议从逻辑上对整个网络进行划分。例如，一台支持IP协议的路由器可以把网络划分成多个子网段，只有指向特殊IP地址的网络流量才可以通过路由器。对于每一个接收到的数据包，路由器都会重新计算其校验值，并写入新的物理地址。因此，使用路由器转发和过滤数据的速度往往要比只查看数据包物理地址的交换机慢。但是，对于那些结构复杂的网络，使用路由器可以提高网络的整体效率。路由器的另外一个明显优势就是可以自动过滤网络广播。总体上说，在网络中添加路由器的整个安装过程要比即插即用的交换机复杂很多。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">有的路由器仅支持单一协议，但大部分路由器可以支持多种协议的传输，即多协议路由器。由于每一种协议都有自己的规则，要在一个路由器中完成多种协议的算法，势必会降低路由器的性能。路由器的主要工作就是为经过路由器的每个数据帧寻找一条最佳传输路径，并将该数据有效地传送到目的站点。由此可见，选择最佳路径的策略即路由算法是路由器的关键所在。为了完成这项工作，在路由器中保存着各种传输路径的相关数据－－路径表（Routing Table），供路由选择时使用。路径表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路径表可以是由系统管理员固定设置好的。</span><br/></p><p>静态路由表：由系统管理员事先设置好固定的路径表称之为静态（static）路径表。</p><p>动态路由表：动态（Dynamic）路径表是路由器根据网络系统的运行情况而自动调整的路径表。</p><p>路由器是一种多端口设备，它可以连接不同传输速率并运行于各种环境的局域网和广域网，也可以采用不同的协议。路由器属于O S I 模型的第三层--网络层。指导从一个网段到另一个网段的数据传输，也能指导从一种网络向另一种网络的数据传输。&nbsp;</p><p>第一，网络互连：路由器支持各种局域网和广域网接口，主要用于互连局域网和广域网，实现不同网络互相通信；<br/>　　第二，数据处理：提供包括分组过滤、分组转发、优先级、复用、加密、压缩和防火墙等功能；<br/>　　第三，网络管理：路由器提供包括路由器配置管理、性能管理、容错管理和流量控制等功能。<br/>　　所谓“路由”，是指把数据从一个地方传送到另一个地方的行为和动作，而路由器，正是执行这种行为动作的机器，它的英文名称为Router,是一种连接多个网络或网段的网络设备，它能将不同网络或网段之间的数据信息进行“翻译”，以使它们能够相互“读懂”对方的数据，从而构成一个更大的网络。<br/>　　为了完成“路由”的工作，在路由器中保存着各种传输路径的相关数据－－路由表（Routing Table），供路由选择时使用。路由表中保存着子网的标志信息、网上路由器的个数和下一个路由器的名字等内容。路由表可以是由系统管理员固定设置好的，也可以由系统动态修改，可以由路由器自动调整，也可以由主机控制。在路由器中涉及到两个有关地址的名字概念，那就是：静态路由表和动态路由表。由系统管理员事先设置好固定的路由表称之为静态（static）路由表，一般是在系统安装时就根据网络的配置情况预先设定的，它不会随未来网络结构的改变而改变。动态（Dynamic）路由表是路由器根据网络系统的运行情况而自动调整的路由表。路由器根据路由选择协议（Routing Protocol）提供的功能，自动学习和记忆网络运行情况，在需要时自动计算数据传输的最佳路径。</p><p><br/></p><p><br/></p>','0','0','0','','0','0','','','998','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYwYXTmVmdpkOSDhl727','1','2020-01-16 22:22:11','','my_shopping_model,my_shopping_color','0','3','585','','0.00','0.00','','{}','1:300M,+,5,2:450M,+,10,3:500M,+,15,4:600M,+,20,5:700M,+,25,6:800M,+,30,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('376','99','0','CH-18 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:30:10','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS','0','<p>路由器里也有软件在运行，典型的例如微软(Microsoft)公司的Windows、苹果(Apple)公司的IOS与Mac OS、谷歌(Google)公司的Android，可以等同地认为它就是路由器的操作系统，像PC上使用的Windows操作系统一样。路由器的操作系统完成路由表的生成和维护。&nbsp;</p><p>同样的，作为路由器来讲，也有一个类似于我们PC系统中BIOS一样作用的部分，叫做MiniIOS。MiniIOS可以使我们在路由器的FLASH中不存在ISO时，先引导起来，进入恢复模式，来使用TFTP或X-MODEM等方式去给FLASH中导入ISO文件。所以，路由器的启动过程应该是这样的：</p><p>路由器在加电后首先会进行POST。Power On Self Test (上电自检，对硬件进行检测的过程)。</p><p>POST完成后，首先读取ROM里的BootStrap程序进行初步引导。</p><p>初步引导完成后，尝试定位并读取完整的ISO镜像文件。在这里，路由器将会首先在FLASH中查找ISO文件，如果找到了ISO文件的话，那么读取ISO文件，引导路由器。</p><p>如果在FLASH中没有找到ISO文件的话，那么路由器将会进入BOOT模式，在BOOT模式下可以使用TFTP上的ISO文件。或者使用TFTP/X-MODEM来给路由器的FLASH中传一个ISO文件(一般我们把这个过程叫做灌ISO)。传输完毕后重新启动路由器，路由器就可以正常启动到CLI模式。</p><p>当路由器初始化完成ISO文件后，就会开始在NVRAM中查找STARTUP-CONFIG文件，STARTUP-CONFIG叫做启动配置文件。该文件里保存了我们对路由器所做的所有的配置和修改。当路由器找到了这个文件后，路由器就会加载该文件里的所有配置，并且根据配置来学习、生成、维护路由表，并将所有的配置加载到RAM(路由器的内存)里后，进入用户模式，最终完成启动过程。</p><p>如果在NVRAM里没有STARTUP-CONFIG文件，则路由器会进入询问配置模式，也就是俗称的问答配置模式，在该模式下所有关于路由器的配置都可以以问答的形式进行配置。不过一般情况下我们基本上是不用这样的模式的。我们一般都会进入CLI&nbsp;[1]&nbsp;&nbsp;(Comman Line Interface)命令行模式后对路由器进行配置。</p><p><br/></p><p>工作原理示例</p><p>（1）工作站A将工作站B的地址12.0.0.5连同数据信息以数据包的形式发送给路由器1。</p><p>（2）路由器1收到工作站A的数据包后，先从包头中取出地址12.0.0.5，并根据路径表计算出发往工作站B的最佳路径：R1-&gt;R2-&gt;R5-&gt;B；并将数据包发往路由器2。</p><p>（3）路由器2重复路由器1的工作，并将数据包转发给路由器5。</p><p>（4）路由器5同样取出目的地址，发现12.0.0.5就在该路由器所连接的网段上，于是将该数据包直接交给工作站B。</p><p>（5）工作站B收到工作站A的数据包，一次通信过程宣告结束。</p><p><br/></p>','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9nOCjsT6XTOiGFs105','1','2020-01-16 22:30:10','','my_shopping_model,my_shopping_color','0','3','88','','0.00','0.00','','{}','1:100M,+,5,2:150M,+,10,3:200M,+,15,','1:蓝,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('377','99','0','CH-19 路由器','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:28:57','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，交通警察。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即','0','<p>路由器（Router），是连接因特网中各局域网、广域网的设备，它会根据信道的情况自动选择和设定路由，以最佳路径，按前后顺序发送信号。 路由器是互联网络的枢纽，&quot;交通警察&quot;。目前路由器已经广泛应用于各行各业，各种不同档次的产品已成为实现各种骨干网内部连接、骨干网间互联和骨干网与互联网互联互通业务的主力军。路由和交换机之间的主要区别就是交换机发生在OSI参考模型第二层（数据链路层），而路由发生在第三层，即网络层。这一区别决定了路由和交换机在移动信息的过程中需使用不同的控制信息，所以说两者实现各自功能的方式是不同的。</p><p>路由器（Router）又称网关设备（Gateway）是用于连接多个逻辑上分开的网络，所谓逻辑网络是代表一个单独的网络或者一个子网。当数据从一个子网传输到另一个子网时，可通过路由器的路由功能来完成。因此，路由器具有判断网络地址和选择IP路径的功能，它能在多网络互联环境中，建立灵活的连接，可用完全不同的数据分组和介质访问方法连接各种子网，路由器只接受源站或其他路由器的信息，属网络层的一种互联设备。</p><p>路由器分本地路由器和远程路由器，本地路由器是用来连接网络传输介质的，如光纤、同轴电缆、双绞线；远程路由器是用来连接远程传输介质，并要求相应的设</p><p>模拟器中的路由器&nbsp;</p><p>备，如电话线要配调制解调器，无线要通过无线接收机、发射机。</p><p>路由器是互联网的主要结点设备。路由器通过路由决定数据的转发。转发策略称为路由选择（routing），这也是路由器名称的由来（router，转发者）。作为不同网络之间互相连接的枢纽，路由器系统构成了基于TCP/IP 的国际互联网络Internet&nbsp;的主体脉络，也可以说，路由器构成了Internet的骨架。它的处理速度是网络通信的主要瓶颈之一，它的可靠性则直接影响着网络互连的质量。因此，在园区网、地区网、乃至整个Internet研究领域中，路由器技术始终处于核心地位，其发展历程和方向，成为整个Internet研究的一个缩影。在当前我国网络基础建设和信息建设方兴未艾之际，探讨路由器在互连网络中的作用、地位及其发展方向，对于国内的网络技术研究、网络建设，以及明确网络市场上对于路由器和网络互连的各种似是而非的概念，都有重要的意义。</p><p>出现了交换路由器产品，从本质上来说它不是什么新技术，而是为了提高通信能力，把交换机的原理组合到路由器中，使数据传输能力更快、更好。</p><p><br/></p>','0','0','0','','0','0','','','280','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhC2dWvXrEcx0C74295','1','2020-01-16 22:28:57','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','{}','1:500M,+,100,2:1000M,+,200,','1:黑,+,0,2:白,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('378','99','0','U-ART气动式高音','','','admin','1','0','','0','0','','0','','','','','0','2020-01-16 22:20:32','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','音响特指电器设备组合发出声音的一套音频系统音响系统大体包含：1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭','0','<p>音响特指电器设备组合发出声音的一套音频系统</p><p>音响系统大体包含：</p><p>1、声源设备：（列如：DVD、CD、MP3、MP4、电脑、手机、麦克风等声源输出设备）</p><p>2、音频信号动态处理设备（压限器、效果器、调音台、音频处理器、均衡器等音频信号处理设备）</p><p>3、音频信号放大设备（前级功率放大器、后级功率放大器、数字功率放大器等模拟功率放大器、设备）&nbsp;</p><p>4、声音还原设备（全频音箱、吸顶喇叭、音柱、线阵音箱、阵列式音箱、高音喇叭、低音炮等等）。技术的的发展历史可以分为电子管、晶体管、集成电路、场效应管四个阶段。</p><p><br/></p><p>音响是一个简化后的日常词语，是音响系统的简称。即代指一整套可以还原播放音频信号的设备。</p><p>随着社会的进步，人们向往生活更多姿多彩。歌舞作为一种流传数千年的娱乐形式，深入各族人民的生活。但是随着科技的发展和进步，人们对于歌舞的表演形式和场地要求越来越多、越来越高。音响系统随着人们的需求不断改进和完善。大到满足上万人演唱会现场扩声需求，小到满足个人家庭弹奏乐器、K歌的需要。</p><p><br/></p>','0','0','0','','0','0','','','1600','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHX6gF0nEoJyFagO648','1','2020-01-16 22:20:32','','my_shopping_model,my_shopping_color','0','3','88','','0.00','0.00','','{}','1:高音,+,0,2:中音,+,0,3:普音,+,0,','','');-- 
INSERT INTO `cmseasy_archive` VALUES('379','99','0','电热水壶','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:06:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随','0','<p>电热水壶的工作原理为，水沸腾时产生的水蒸汽使蒸汽感温元件的双金属片变形，这种变形通过杠杆原理推动电源开关断电。其断电是不可自复位的，故断电后水壶不会自动再加热。</p><p>电水壶在1891年诞生于芝加哥。随着科技的发展，快捷、安全、便利、充分利用能源日渐成为了水壶的主要特点，嗜茶的英国人从此便爱上它了。到了二十一世纪便成为全球的畅销品。电水壶采用的是蒸气智能感应控温，具有水沸腾后自动断电、防干烧断电的功能。随着生活的需要，现在的电水壶也正在向多功能方向发展，如防漏、防烫、锁水等。电水壶具有加热速度快，保温效果好，过滤功能强，式样多等优点。</p><p>电热水壶的使用功能虽然基本相同，但从内在电路结构设计可以分为鸣笛式电水壶、防干烧鸣笛电水壶、塑胶电热水壶等几大类。</p><p>（1）鸣笛式电热水壶。</p><p>由铝制板经拉伸制成，电热元件采用浸水式镀镍钢密封式电热管。电热管安装在水壶底部，和壶体结合部垫有耐热密封圈以防止漏水。该类型电热水壶壶盖上设置有一个条状振动簧片自鸣器（气流振动式鸣笛装置），当水温达到100℃以上时气流鸣笛即会鸣响。由于该类水壶一般没有设置限温控制器，必须人为地手动切断电源。该类电热水壶结构简单、价格低廉，居民家庭中使用相当广泛。</p><p>（2）防干烧鸣笛式电热水壶。&nbsp;</p><p>在鸣笛式电水壶设计原理基础上，增设了限温自动控制器（主要是双金属恒温控制器或者磁控恒温自动开关），当水沸腾时，产生的水蒸气使感温元件的双金属片变形，驱动微型开关切断电源，极大地提高了电热水壶的安全性能。一些高品质的电热水壶中的限温控制器采用一种类似记忆合金的新型热敏材料（自动恒温控制开关），当壶内水面低于电热管（电热管温度超过100℃以上）时，自动恒温控制开关便会自动切断电源，保护电热水壶不被烧毁。</p><p>（3）塑胶型电热水壶。</p><p>塑胶型电热水壶最大的特点是携带方便、安全性能可靠。壶体设置的电源信号指示灯可方便观察通电状态，上下分体式结构可以3600旋转，壶体采用的食品级卫生塑质材料熔点在200℃以上。这种新型电热水壶采用隐藏式不锈钢电发热盘，并设置有蒸汽感应控制开关，具有自动断电、防干烧断电、热熔断电保护、接地保护等多重保护功能。&nbsp;</p><p><br/></p>','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYof911iYjQMp1JA5768','1','2020-01-16 22:06:48','','my_shop_model,my_shoppingcolor','5','3','88','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东\",\"buyurls\":\"https://www.jd.com\"}}','1:电子,+,10,2:机械,+,5,','1:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('380','99','0','智能吸顶灯','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:21:38','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目','0','<p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。</p><p>目前市场上最流行的吸顶灯就是LED 吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。</p><p>吸顶灯是灯具的一种，顾名思义是由于灯具上方较平，安装时底部完全贴在屋顶上所以称之为吸顶灯。光源有普通白灯泡，荧光灯、高强度气体放电灯、卤钨灯、LED等。目前市场上最流行的就是led吸顶灯，是家庭、办公室、文娱场所等各种场所经常选用的灯具。&nbsp;&nbsp;</p><p>它起源于1995年-1996年间，由于形似太阳，因此当时行业人士称之为“太阳灯”， 2000年前的吸顶灯款式单一、材料单一，大多采用中低档材料，光源一般采用节能灯管和灯泡，并以电感吸顶灯为主。</p><p>LED吸顶灯是吸附或嵌入屋顶天花板上的灯饰，它和吊灯一样，也是室内的主体照明设备，是家庭、办公室、娱乐场所等各种场所经常选用的灯具。LED吸顶灯一</p><p><br/></p><p>般直径在200mm左右的吸顶灯适宜在走道、浴室内使用，而直径400mm的则装在不小于16平方米的房间顶部为宜。 市面上的LED吸顶灯常见有D形管和环形管两种还有大小管区别。选购LED吸顶灯时要三看。一看产品标识是否齐全，正规产品的标识往往比较规范，应标识：商标和厂名、产品型号规格、额定电压、额定频率、额定功率。二看灯具电源线是否有CCC安全认证标志，外部导线截面积应≥0.75平方毫米。三看灯具带电体是否外露，光源装入灯座后，手指应不能触及带电的金属灯头。</p><p>1)功能细分。吸顶灯传统的照明功能已不够满足消费者，将客厅吸顶灯与日常用品相组合也日趋流行。</p><p>2)造型豪华。随着生活的日益富足，消费者审美需求增加，客厅吸顶灯日趋豪华、高档。</p><p>3)崇尚自然。为迎合都市消费者返朴归真、崇尚自然的心理，很多吸顶灯采用了自然化的造型。另外，灯罩的选材也广泛采用纸质、木质、纱质等自然材质。</p><p>4)色彩丰富。为与丰富多彩的生活同步，现如今很多吸顶灯披起了“七彩”外衣。&nbsp;</p><p>5)高技术化。随着科学技术的发展，电子科技被广泛应用于客厅吸顶灯设计，如适应不同电压的吸顶灯，可调节亮度的吸顶灯，放射远的红外红光吸顶灯等等。</p><p>6)节能化。目前节能吸顶灯很受消费者欢迎，如采用3LED芯电的长寿节能灯，既节约能源，又可以根据需要选择亮度。</p><p>7)环保化。环保是吸顶灯设计不变的话题，这与我们栖息的地球有关，已经引起广大消费者重视，这将会成为未来家居照明的主要发展方向。</p><p><br/></p>','0','0','0','','0','0','','','13','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY9WBOPjG6dQeIfDn585','1','2020-01-17 09:21:38','','my_shopping_model,my_shopping_color','0','3','0','','0.00','0.00','','{}','1:节能,+,0,2:普通,+,0,','1:黑,+,5,2:白,+,10,','');-- 
INSERT INTO `cmseasy_archive` VALUES('381','99','0','智能加湿器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-16 22:15:29','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿','0','<p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。&nbsp;<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p>纯净型加湿器</p><p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。&nbsp;</p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p><br/></p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','460','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1V2E0Sx8DFX8ODz935','1','2020-01-16 22:15:29','','my_shopping_model,my_shopping_color','0','3','0','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/729828.html\"},\"1\":{\"buyurlname\":\"天猫购买\",\"buyurls\":\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.26.1c04a98aZGJnlP&id=605208384141&skuId=4245337065638&user_id=3919645743&cat_id=2&is_b=1&rn=73570d905a6017c54c1e28ca58978061\"}}','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('382','99','0','智能洗衣机','','','admin','1','13','','0','0','','1','','','','','0','2020-01-16 22:12:24','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超','0','<p>洗衣机是利用电能产生机械作用来洗涤衣物的清洁电器，按其额定洗涤容量分为家用和集体用两类。</p><p>中国规定洗涤容量在6千克以下的属于家用洗衣机：家用洗衣机主要由箱体、洗涤脱水桶（有的洗涤和脱水桶分开）、传动和控制系统等组成，有的还装有加热装置。洗衣机一般专指使用水作为主要的清洗液体，有别于使用特制清洁溶液，及通常由专人负责的干洗。&nbsp;&nbsp;</p><p>从全国范围来看，目前我国洗衣机市场普及程度已经超过了76%，其中城镇市场已经超过了96%，农村市场也已经超过了53%;随着国家开展家电下乡、扩大内需的政策，洗衣机企业将目光均投向了拥有较大消费潜力的农村市场。未来几年，我国洗衣机市场需求增长空间将主要来自于：以城镇化和农村市场为主的首次需求，以及以城镇市场消费升级为主的更新需求;整个洗衣机市场需求在未来几年将继续保持温和增长态势。</p><p>2010年，我国洗衣机总销量约5000多万台，同比增长接近30%，增长幅度创历史最高水平;其中内销实现3300多万台，同比增长约28%，出口实现1600多万台，同比增长30%以上，均创历史最高增长速度。</p><p>从不同产品来看，2010年我国滚筒洗衣机总销量达到1100多万台，同比增长50%以上，占洗衣机市场销量比重由上年的不足20%上升至20%以上。其中，第四季度各月销量均超过110万台，所占洗衣机市场总销量的份额均超过21%。</p><p>节水将成未来洗衣机重点发展方向，洗衣机产业目标主要涵盖节电节水、产品功能、绿色设计三大方向。在中国家用电器协会编制的冰箱、空调、洗衣机的技术路线图中，就节电节水方面，制定了到 2015年，波轮式双桶洗衣机达到国家能效2级，波轮式全自动洗衣机达到国家能效1级，能效1级的滚筒式全自动洗衣机要达到欧盟A+等级耗电、耗水要求， 滚筒式洗干一体机要达到GB/T23118国标A级耗电、耗水要求。到2020年，滚筒洗衣机达到欧盟A+++等级耗电、耗水要求，波轮式全自动洗衣机达到国标A+等级耗电、耗水要求，滚筒式洗干一体机达到国标A+等级耗电、耗水要求。在产品功能方面，洗衣机的发展方向是大容量，低噪声、低振动。</p><p><br/></p><p>机械力、洗涤液、水是洗衣机洗涤过程中的三要素。洗衣机运动部件产生的机械力和洗涤液的作用使污垢与衣物纤维脱离。加热洗涤液，可增强去污效果。织物不同，适宜液温也不同，反映洗衣机洗涤性能（即洗净衣物的能力）的主要指标是洗净率（或洗净比）和织物磨损率。洗净率是洗衣机在额定洗涤状态下，利用光电反射率计（或白度仪）测定洗涤前后人工污染布及其原布的反射率。洗衣机发展史　从古到今，洗衣服都是一项难于逃避的家务劳动，而在洗衣机出现以前，对于许多人而言，它并不像田园诗描绘的那样充满乐趣，手搓、棒击、冲刷、甩打…这些不断重复的简单的体力劳动，留给人的感受常常是：辛苦劳累。&nbsp;</p><p>1858年，一个叫汉密尔顿·史密斯的美国人在匹茨堡制成了世界上第一台洗衣机，该洗衣机的主件是一只圆桶，桶内装有一根带有桨状叶子的直轴，轴是通过摇动和它相连的曲柄转动的。同年史密斯取得了这台洗衣机的专利权。但这台洗衣机使用费力，且损伤衣服，因而没被广泛使用，但这却标志了用机器洗衣的开端。次年在德国出现了一种用捣衣杵作为搅拌器的洗衣机，当捣衣杵上下运动时，装有弹簧的木钉便连续作用于衣服。19世纪末期的洗衣机已发展到一只用手柄转动的八角形洗衣缸，洗衣时缸内放入热肥皂水，衣服洗净后，由轧液装置把衣服挤干。</p><p>1874年，“手洗时代”受到了前所未有的挑战，美国人比尔·布莱克斯发明了木制手摇洗衣机。布莱克斯的洗衣机构造极为简单，是在木筒里装上6块叶片，用手柄和齿轮传动，使衣服在筒内翻转，从而达到“净衣”的目的。这套装置的问世，让那些为提高生活效率而冥思苦想的人士大受启发，洗衣机的改进过程开始大大加快.</p><p>1880年，美国又出现了蒸气洗衣机，蒸气动力开始取代人力。经历了上百年的发展改进，现代蒸汽洗衣机较早期有了无与伦与的提高，但原理是相同的。现代蒸汽洗衣机的功能包括蒸汽洗涤和蒸汽烘干，采用了智能水循环系统，可将高浓度洗涤液与高温蒸气同时对衣物进行双重喷淋，贯穿全部洗涤过程，实现了全球独创性的“蒸汽洗”全新洗涤方式。与普通滚筒洗衣机在洗涤时需要加热整个滚筒的水不同，蒸汽洗涤是以深层清洁衣物为目的，当少量的水进入蒸汽发生盒并转化为蒸汽后，通过高温喷射分解衣物污渍。蒸汽洗涤快速、彻底，只需要少量的水，同时可节约时间。对于放在衣柜很长时间产生褶皱、异味的冬季衣物，能让其自然舒展，抚平褶皱。“蒸汽烘干”的工作原理则是把恒定的蒸汽喷洒在衣物上，将衣物舒展开之后，再进行恒温冷凝式烘干。通过这种方式，厚重衣物不仅干得更快，并且具有舒展和熨烫的效果。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/html/upload/images/201907/15590081993243.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYITUdOO4dafAhtdr232','1','2020-01-16 22:12:24','','my_shopping_model,my_shopping_color','5','3','999','','0.00','0.00','','{\"0\":{\"buyurlname\":\"京东购买\",\"buyurls\":\"https://item.jd.com/100004652001.html\"}}','1:智能,+,10,2:机械,+,5,3:全自动,+,15,','1:白,+,10,2:黑,+,5,','');-- 
INSERT INTO `cmseasy_archive` VALUES('448','99','0','路由器','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:23:27','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地','0','','0','0','0','','0','0','','','999','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYNfW06Lofg2dRM52677','1','2020-01-17 09:23:27','','my_shop_model,my_shoppingcolor','0','3','188','','0.00','0.00','','{}','1:300M,+,10,2:500M,+,20,','1:蓝,+,0,2:黑,+,0,','');-- 
INSERT INTO `cmseasy_archive` VALUES('449','102','0','产品名称三十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:05:27','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','560','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330655517.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJz9tU0sEFmG4jYr924','1','2019-08-16 23:05:27','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('450','102','0','产品名称三十','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:13:43','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYoqRcqqx04wOaAxg150','1','2019-05-29 13:13:43','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('451','102','0','产品名称二十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:11','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYdpBjq9drwOlW0lf664','1','2019-08-16 23:06:11','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('452','102','0','产品名称二十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:10','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYbM6nNh7Q3yzd5ea383','1','2019-08-16 23:06:10','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('453','102','0','产品名称二十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:06:13','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYYcWihLq5Dgx5rzO811','1','2019-08-16 23:06:13','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('454','102','0','产品名称二十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-16 23:33:48','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','2300','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYOPdjHvE4Pn4u0dk942','1','2019-08-16 23:33:48','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('456','100','0','产品名称二十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:02','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','2200','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY7g8BajgqgwA2LsQ659','1','2019-08-17 00:02:02','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('457','100','0','产品名称二十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:03','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','998','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYm8MzExt0fTjru5P101','1','2019-08-17 00:02:03','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('458','100','0','产品名称二十三','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:05','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','120','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYXDCS4WRJNTKkc4P113','1','2019-08-17 00:02:05','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('459','100','0','产品名称二十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:02:04','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','166','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYo9eP29z3HPIgb4V659','1','2019-08-17 00:02:04','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('460','100','0','产品名称二十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:34','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','177','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYVUKHL6UcJ7fOOHT585','1','2019-08-17 00:18:34','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('461','100','0','产品名称二十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:35','admin','','/html/upload/images/201907/15590079031945.jpg','1','1','','0','','0','0','0','','0','0','','','199','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590079031945.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYBkQvDdHVOAUgwxb296','1','2019-08-17 00:18:35','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('462','100','0','产品名称十九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYJfx8fl6qGjFjhRB691','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('463','100','0','产品名称十八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:37','admin','','/html/upload/images/201907/15590080664809.jpg','1','1','','0','','0','0','0','','0','0','','','1600','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590080664809.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYpkR2pX6G54WXOpL136','1','2019-08-17 00:18:37','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('464','100','0','产品名称十七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15590081376621.jpg','1','1','','0','','0','0','0','','0','0','','','210','','0','','','0','a:1:{i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590081376621.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHmUFxBzunoBf4U0359','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('467','100','0','产品名称十六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:39','admin','','/html/upload/images/201907/15506336226893.jpg','1','1','','0','','0','0','0','','0','0','','','220','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506336226893.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYjzChf9aIGI4b0p9136','1','2019-08-17 00:18:39','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('468','101','0','产品名称十二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:42','admin','','/html/upload/images/201907/15506330653551.jpg','1','1','','0','','0','0','0','','0','0','','','270','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330653551.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhgNcxGA33CN0WVG368','1','2019-08-17 00:18:42','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('469','101','0','产品名称十五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:40','admin','','/html/upload/images/201907/15506335969988.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335969988.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY6IDNvIpFJj5HxMg820','1','2019-08-17 00:18:40','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('470','101','0','产品名称十四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:41','admin','','/html/upload/images/201907/15506335904260.jpg','1','1','','0','','0','0','0','','0','0','','','250','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506335904260.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYteUoUOdnEtJQ5DO966','1','2019-08-17 00:18:41','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('480','102','0','产品名称十三','','','admin','1','0','','0','0','','0','','','','','0','2019-05-29 13:36:10','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','260','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYu8jmokWatEiOQek651','1','2019-05-29 13:36:10','','','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('481','101','0','产品名称十一','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:44','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','','0','','0','0','0','','0','0','','','230','','0','','','0','a:2:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYURynpBhTaiRU1ms696','1','2019-08-17 00:18:44','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('482','101','0','产品名称十','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:45','admin','','/html/upload/images/201907/15506330561844.jpg','1','1','','0','','0','0','0','','0','0','','','330','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330561844.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY521mO3OWstsuJvy507','1','2019-08-17 00:18:45','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('483','101','0','产品名称九','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:52','admin','','/html/upload/images/201907/15396893757731.jpg','1','1','','0','','0','0','0','','0','0','','','340','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893757731.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGXyVs7sVq5KE1nj376','1','2019-08-17 00:18:52','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('484','101','0','产品名称八','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:53','admin','','/html/upload/images/201907/15396893572202.jpg','1','1','','0','','0','0','0','','0','0','','','360','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396893572202.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYhuFUlRzDbrQ1jM3690','1','2019-08-17 00:18:53','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('485','101','0','产品名称七','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:54','admin','','/html/upload/images/201907/15396892522391.jpg','1','1','','0','','0','0','0','','0','0','','','380','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892522391.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY0BCt9KtrTRtjv6L213','1','2019-08-17 00:18:54','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('486','101','0','产品名称六','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:55','admin','','/html/upload/images/201907/15396892048357.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396892048357.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY1TiXfBUr5DbqEzS249','1','2019-08-17 00:18:55','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('487','101','0','产品名称五','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:56','admin','','/html/upload/images/201907/15396889737483.jpg','1','1','','0','','0','0','0','','0','0','','','4050','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15396889737483.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGrWKMWNt9VGjomF275','1','2019-08-17 00:18:56','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('489','102','0','产品名称四','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 00:18:57','admin','','/html/upload/images/201907/15590078646183.jpg','1','1','','0','','0','0','0','','0','0','','','660','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15590078646183.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYHTxk1P8OSnxGsGI140','1','2019-08-17 00:18:57','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('490','99','0','产品名称三','','','admin','1','0','','0','0','','0','','','','','0','2019-07-22 15:38:36','admin','','/html/upload/images/201907/15590081993243.jpg','1','1','','0','','0','0','0','','0','0','','','550','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYRwbmVb35BbAF4uT843','1','2019-07-22 15:38:36','','my_shop_model,my_shoppingcolor','0','1','99','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('491','102','0','产品名称二','','','admin','1','0','','0','0','','0','','','','','0','2019-08-17 02:11:03','admin','','/html/upload/images/201907/15506330608258.jpg','1','1','产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；产品标识应当清晰、牢固，易于识别；','0','<p>产品名称即“品牌名称（brand name）”。好的品牌名称必须简洁、易读、易记、易写。美国有为产品取名的专业机构，他们利用电脑，把26个英文字母搭配成各种名称。有些品牌著名于世界，如克宁奶粉（Klim）、柯达（Kodak）等。</p><p>产品标识所用文字应当为规范中文。可以同时使用汉语拼音或者外文，汉语拼音和外文应当小于相应中文。产品标识使用的汉字、数字和字母，其字体高度应大于或等于1.8毫米；<br/></p><p>产品标识应当清晰、牢固，易于识别；</p><p>产品名称包含中英文全程，或者中文拼音。另有对应于全称的企业或产品简称，如：中兴通讯股份有限公司，简称：中兴通讯，英文简称：ZTE。</p><p>企业或品牌名称具备统一的标准字体、标准色、标准大小以区别于同类企业或产品。企业和产品名称应用于企业日常产品、服务、办公、营销行为等公司运作的各个方面，形成完整统一的企业CI系统。所以产品名称是企业识别系统中最重要的一个要素。</p><p><br/></p><p>产品名称应当表明产品的真实属性，并符合下列要求：</p><p>（一）国家标准、行业标准对产品名称有规定的，应当采用国家标准、行业标准规定的名称；</p><p>（二）国家标准、行业标准对产品名称没有规定的，应当使用不会引起用户及消费者误解和混淆的常用名称或者俗名。</p><p>产品名称可以作为注册商标，但应符合商标法的规定。</p><p><br/></p>','0','0','0','','0','0','','','980','','0','','','0','a:1:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15506330608258.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYTReKg1pr3crT8CO456','1','2019-08-17 02:11:03','','my_shop_model,my_shoppingcolor','0','3','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('492','99','0','产品名称一','','','admin','1','0','','0','0','','1','','','','','0','2020-01-17 09:11:39','admin','','/html/upload/images/201907/15591115606261.jpg','1','1','直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。','0','<p>直接蒸发型加湿器通常也被称为纯净型加湿器。纯净型的加湿技术则是加湿领域刚刚采用的新技术，通过分子筛蒸发技术，除去水中的钙、镁离子，彻底解决“白粉”问题。通过水幕洗涤空气，在加湿的同时还能对空气中的病菌、粉尘、颗粒物进行过滤净化，再经风动装置将湿润洁净的空气送到室内，从而提高环境湿度和洁净度。所以非常适用于有老人和小孩的家庭使用，还可以预防冬季流感病菌。<br/></p><p>超声波加湿器和纯净型加湿器是建议给儿童购买的首选产品，安全系数高，净化空气，除菌加湿能力强，增进健康，给孩子一个舒适的环境。</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/html/upload/images/201907/15591115599626.jpg\"/></p><p><br/></p><p>电加热式加湿器</p><p>热蒸发型加湿器也叫电加热式加湿器，其工作原理是将水在加热体中加热到100℃，产生蒸汽，用电机将蒸汽送出。电加热式加湿器是技术最简单的加湿方式。</p><p>加湿器是一种增加房间湿度的家用电器。加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。</p><p><br/></p><p>加湿器行业在中国的发展有近20年的历史，经过多年的空气质量概念普及、产品研发、市场培育，加湿器这一相对陌生的小家电产品的功能和作用逐渐被接受。</p><p>加湿器是一种可以增加房间湿度的家用电器，加湿器可以给指定房间加湿，也可以与锅炉或中央空调系统相连给整栋建筑加湿。根据热、湿交换理论，在实际工程中将加湿器分为以下两种：</p><p>1、等焓加湿器：即利用水吸收空气的显热进行蒸发加湿，其在焓、湿图上的变化为近似等焓过程。<br/></p><p>2、等温加湿器：即利用热能将液态水转化成蒸汽与空气混合进行加湿，其在焓、湿图上的变化为近似等温过程。</p><p>加湿器从使用范围来讲可分为工业用加湿器、商用加湿器和家用加湿器三个大的类别。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115606261.jpg\"/></center><p><br/></p><p><br/></p><p>超声波加湿器</p><p>已被广泛应用在各种领域。超声波加湿器采用每秒200万次的超声波高频震荡，将水雾化为1微米到5微米的超微粒子和负氧离子，从而实现均匀加湿，清新空气，增进健康的，去除冬季暖气的燥热，营造舒适的生活环境。</p><p><br/></p><p><br/></p><center><img src=\"/html/upload/images/201907/15591115602093.jpg\"/></center><p><br/></p><p><br/></p><p>纯净型加湿器</p><p>浸入式电极加湿器</p><p>浸入式电极式加湿器（immersed Electrode humidifier）是利用浸入水中的大面积的电极作为端子，以水作为加热媒介，当电流经由水转移电能时，产生热量，使水沸腾，产生蒸汽。其特点是成本低,便于安装和使用.但是精度较低，而且需要定期更换加湿桶维护。</p><p><br/></p>','0','0','0','','0','0','','','1620','','2','10','html/upload/attachment/201908/1566304174297.png','0','a:3:{i:1;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115599626.jpg\";s:3:\"alt\";s:8:\"1004.jpg\";}i:2;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115606261.jpg\";s:3:\"alt\";s:8:\"1002.jpg\";}i:3;a:2:{s:3:\"url\";s:45:\"/html/upload/images/201907/15591115602093.jpg\";s:3:\"alt\";s:8:\"1003.jpg\";}}','','0','0','0','0000-00-00','1','CMSEASYOK2nysJX2XzMN7X248','1','2020-01-17 09:11:39','admin','my_shopping_model,my_shopping_color','18','3','996','<p>详细说明</p><p><img src=\"/html/upload/images/201908/15662076301300.jpg\" title=\"15662076301300.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076302696.jpg\" title=\"15662076302696.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076306969.jpg\" title=\"15662076306969.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076314121.jpg\" title=\"15662076314121.jpg\"/></p><p><img src=\"/html/upload/images/201908/15662076318531.jpg\" title=\"15662076318531.jpg\"/></p><p><br/></p>','0.00','0.00','83,1#my_shopping_model,2:便携,jia,155;my_shopping_color,6:金,jia,0-73,1#my_shopping_model,2:I7,jia,10;my_shopping_color,1:金,jia,88','{}','1:I5,+,5,/html/upload/images/201908/15662076314121.jpg2:I7,+,10,/html/upload/images/201908/15662076301300.jpg3:I9,+,15,/html/upload/images/201908/15662076318531.jpg','1:金,+,88,/html/upload/images/201907/15590079031945.jpg2:黑,+,8,/html/upload/images/201907/15506336226893.jpg','');-- 
INSERT INTO `cmseasy_archive` VALUES('533','164','0','页底小图标5','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 16:44:53','admin','','/cn/upload/images/202004/15864219155785.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYf23GOWrUjFqV31R566','1','2020-04-09 16:44:53','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('534','164','0','页底小图标4','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 16:45:20','admin','','/cn/upload/images/202004/15864219272428.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYAf6vPPll3ihGH11868','1','2020-04-09 16:45:20','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('535','164','0','页底小图标3','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 16:45:31','admin','','/cn/upload/images/202004/15864219407013.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYIvhNHEI8MALoOhc187','1','2020-04-09 16:45:31','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('536','164','0','页底小图标2','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 16:45:44','admin','','/cn/upload/images/202004/15864219653202.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASY8O35UopvMOd9pRL178','1','2020-04-09 16:45:44','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('537','164','0','页底小图标1','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 16:46:09','admin','','/cn/upload/images/202004/15864219762661.png','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYiSHFBq6TMpvLo9W174','1','2020-04-09 16:46:09','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('538','158','0','简所 | JANESO','青岛市北区海信绍兴路66号','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:04:29','admin','','/cn/upload/images/202004/15864231206850.jpg','1','1','','0','<p>早安北京是福泰地产开发的，小区有住宅和，人民大学大厂，房子今年明年6月交房，住宅户型89南北两居和109平米三居，户型38-82平米都有，，70年大产权，机不可失，失不再来。</p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246693237.jpg\" title=\"15864246693237.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246691112.jpg\" title=\"15864246691112.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246692121.jpg\" title=\"15864246692121.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246695032.jpg\" title=\"15864246695032.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246707638.jpg\" title=\"15864246707638.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864246707233.jpg\" title=\"15864246707233.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246707638.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246695032.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246693237.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246692121.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246691112.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864246707233.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYSs3B6MpXrrgy3b0879','1','2020-04-09 17:29:43','','','','1','0','','0.00','0.00','','','','','1280');-- 
INSERT INTO `cmseasy_archive` VALUES('539','158','0','地铁口温馨大床','杭州江干区东宁路与天城路交叉口','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:31:38','admin','','/cn/upload/images/202004/15864247602871.jpg','1','1','项目周边配套齐全，距离项目3公里，就是延庆康庄镇，这里有医院、华联超市、休闲购物等一系配套，可以满足日常各种生活所需。所有孔雀城都会建立幸福与幸福医院，名医就在家门口，在北京担心孩子的、、、借读费等','0','<p>项目周边配套齐全，距离项目3公里，就是延庆康庄镇，这里有医院、华联超市、休闲购物等一系配套，可以满足日常各种生活所需。所有孔雀城都会建立幸福与幸福医院，名医就在家门口，在北京担心孩子的、、、借读费等各种烦恼，在孔雀城则完全不用担心。交通便利：高速 京藏、京新、京礼三高速到康庄65号出口下；双轨：1.京张高铁，北京北站到东花园北站，2.S2号线，黄土店站到延庆康庄站。公交线路880路：直达北京地铁朱辛庄站，公交919路：直达马甸、德胜门，公交Y21路：从项目可直达延庆。项目周边景点多达85处，也是个游山玩水的好地方</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247503376.jpg\" title=\"15864247503376.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247504876.jpg\" title=\"15864247504876.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247506970.jpg\" title=\"15864247506970.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247506056.jpg\" title=\"15864247506056.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247506017.jpg\" title=\"15864247506017.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864247515691.jpg\" title=\"15864247515691.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247602871.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247515691.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247503376.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247504876.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247506017.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864247506056.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYGyXOqOMcjqO7zl7490','1','2020-04-09 17:34:26','','','','1','0','','0.00','0.00','','','','','1128');-- 
INSERT INTO `cmseasy_archive` VALUES('540','158','0','钱塘江投影巨幕全透明','杭州滨江区在别处等帆过精品酒店','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:33:04','admin','','/cn/upload/images/202004/15864248486377.jpg','1','1','森林新都孔雀城隶属于孔雀城品牌旗下产品，是孔雀城品牌盛誉之上的又一升级力作。项目地处北京南中轴，位于天安门正南50公里，三环南38公里，首都新机场南15公里处的北京亦庄永清产业园区。项目所在区域承接','0','<p>森林新都孔雀城隶属于孔雀城品牌旗下产品，是孔雀城品牌盛誉之上的又一升级力作。项目地处北京南中轴，位于天安门正南50公里，三环南38公里，首都新机场南15公里处的北京亦庄永清产业园区。项目所在区域承接轨道高速交通以及首都空港经济圈辐射利好，是城南发展计划中的重要规划核心区。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248374444.jpg\" title=\"15864248374444.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248373006.jpg\" title=\"15864248373006.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248378686.jpg\" title=\"15864248378686.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248377695.jpg\" title=\"15864248377695.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248372902.jpg\" title=\"15864248372902.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864248383505.jpg\" title=\"15864248383505.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248486377.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248383505.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248372902.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248373006.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248374444.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864248377695.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYLWoQhmQSpO4eXjQ762','1','2020-04-09 17:34:34','','','','1','0','','0.00','0.00','','','','','1128');-- 
INSERT INTO `cmseasy_archive` VALUES('541','158','0','近国贸三里屯欢乐谷','北京朝阳区百子湾东里','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:34:54','admin','','/cn/upload/images/202004/15864249783605.jpg','1','1','大运河智慧街区。总建筑面积441823平米，占地面积55810平方米，绿化率28%.4# 1#  2# 已经售尽，现在在售9#.平层面积43.  45  47 平。;48  50  63  75 平','0','<p>大运河智慧街区。总建筑面积441823平米，占地面积55810平方米，绿化率28%.4# &nbsp;1# &nbsp; 2# &nbsp;已经售尽，现在在售9#.平层面积43. &nbsp; 45 &nbsp; 47 平。;48 &nbsp; 50 &nbsp; 63 &nbsp; 75 平 &nbsp;米 &nbsp;开盘价格8300起。现在在售孔雀城智慧中心 &nbsp;类住宅，商水，通燃气，均价8500起，在售户型 &nbsp; 66平两居 &nbsp;88平三居，适合，是不限够，不需要资质，外地直接网签。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249697041.jpg\" title=\"15864249697041.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249693193.jpg\" title=\"15864249693193.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249704744.jpg\" title=\"15864249704744.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249701765.jpg\" title=\"15864249701765.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249708925.jpg\" title=\"15864249708925.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864249709072.jpg\" title=\"15864249709072.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249783605.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249701765.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249708925.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249709072.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249693193.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864249697041.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYirDmHt7IjCQi2xp955','1','2020-04-09 17:40:44','','','','1','0','','0.00','0.00','','','','','2180');-- 
INSERT INTO `cmseasy_archive` VALUES('542','158','0','古北水镇豌豆私邸','北京密云区古北水镇国际旅游景区','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:38:51','admin','','/cn/upload/images/202004/15864252146686.jpg','1','1','香河高速出口200米，小区班车直达地铁7号线。北三县香河，70年大产权住宅，外地可以贷款，首付；30%---50%.只有这个楼盘可以贷款。4万平米的大爱书院养老中心，以居家养老社区照顾机构养老三位一','0','<p>香河高速出口200米，小区班车直达地铁7号线。<br/>北三县香河，70年大产权住宅，外地可以贷款，首付；30%---50%.<br/>只有这个楼盘可以贷款。<br/>4万平米的大爱书院养老中心，以居家养老社区照顾机构养老三位一体的养老体系，200亩大爱农场；集生态观光果蔬菜采摘等功能与一体。<br/></p><p>千亩主题公园；包括大爱克丽丝北京景山大爱城，大爱书院。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252044755.jpg\" title=\"15864252044755.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252045735.jpg\" title=\"15864252045735.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252041860.jpg\" title=\"15864252041860.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252043683.jpg\" title=\"15864252043683.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252049306.jpg\" title=\"15864252049306.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864252052056.jpg\" title=\"15864252052056.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252146686.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252052056.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252041860.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252043683.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252045735.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864252044755.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYQ1b3lNEw66wEmjE280','1','2020-04-09 17:40:49','','','','1','0','','0.00','0.00','','','','','2180');-- 
INSERT INTO `cmseasy_archive` VALUES('543','158','0','麻将长租家庭房','北京石景山区鲁谷大街与京源路交叉口','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:41:01','admin','','/cn/upload/images/202004/15864253392041.jpg','1','1','大厂潮白河孔雀城-雅韵园--逸翠园项目位置：走通燕高速（宋庄出口）、103国道（甘棠大厂方向左转）经过友谊大桥即到达本项目。潮白河河岸东侧无缝对接地铁六号线延长线潞城站。开发商：华夏幸福基业物业公司','0','大厂潮白河孔雀城-雅韵园--逸翠园<br/>项目位置：走通燕高速（宋庄出口）、103国道（甘棠大厂方向左转）经过友谊大桥即到达本项目。潮白河河岸东侧无缝对接地铁六号线延长线潞城站。<br/>开发商：华夏幸福基业<br/>物业公司：幸福基业物业服务有限公司<br/>建筑类型：高层板楼<br/>产权:70年产权（）<br/>物业费：1.9/平米/月<br/>：2.9米<br/>绿化率：35%<br/>容积率：2.0<br/>装修：毛坯<br/>供暖方式：市政<br/>建筑风格：新古典主义<br/>在售房源：5.9号楼剩余房源，加推4.16号楼<br/><p>交房时间：2021年9月</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253329852.jpg\" title=\"15864253329852.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253323102.jpg\" title=\"15864253323102.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253323286.jpg\" title=\"15864253323286.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253326217.jpg\" title=\"15864253326217.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253329950.jpg\" title=\"15864253329950.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864253338523.jpg\" title=\"15864253338523.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:6:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253392041.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253338523.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253323102.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253323286.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:5;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253326217.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:6;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864253329852.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY8XbsfqOiHBBVC8e384','1','2020-04-09 17:41:01','','','','1','0','','0.00','0.00','','','','','1433');-- 
INSERT INTO `cmseasy_archive` VALUES('544','160','0','北京金茂府二期','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:55:14','admin','','/cn/upload/images/202004/15864262141003.jpg','1','1','北京金茂府二期产品价格待定。容积率3。660-5#预计2021年交房。带装修交房。项目为多层,高层板楼。物业费：平层物业费11.8元/㎡月，别墅物业费14.8元/㎡月。北京金茂府二期项目距离5号线,','0','<p>北京金茂府二期产品价格待定。容积率3。660-5#预计2021年交房。带装修交房。项目为多层,高层板楼。物业费：平层物业费11.8元/㎡月，别墅物业费14.8元/㎡月。北京金茂府二期项目距离5号线,10号线,亦庄线宋家庄站493米。敬请关注。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262007181.png\" title=\"15864262007181.png\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262018666.jpg\" title=\"15864262018666.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262015018.jpg\" title=\"15864262015018.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262028249.jpg\" title=\"15864262028249.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262141003.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262015018.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262028249.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262007181.png\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYCt7vDhYJuWqPjn1346','1','2020-04-09 17:55:14','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('545','160','0','北京城建·宽院·国誉府','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:57:12','admin','','/cn/upload/images/202004/15864262865136.jpg','1','1','北京城建·宽院·国誉府首推楼栋为10、11、14、15、18、19、22、23#东南区8栋，项目均价：31136元/平米。项目秉承“国誉府系”高端品质，精心雕琢，以国誉建墅十八方略，传承盛唐风仪，是','0','<p>北京城建·宽院·国誉府首推楼栋为10、11、14、15、18、19、22、23#东南区8栋，项目均价：31136元/平米。<br/>项目秉承“国誉府系”高端品质，精心雕琢，以国誉建墅十八方略，传承盛唐风仪，是北京新机场墅区中创新别墅代表之作。项目西邻凤河，天然偏东南15°采光，1.05容积率，仅436席宽院别墅，畅享人生大雅，项目绿化率30%。主力户型为152平-240平4居，分为首院、中院、上院。项目建筑规划北高南低，由北向南共6排建筑。最北排建筑层数为4.5至6.5层，其余各排建筑层数为3.5层。以地块南侧大门、售楼处、中央景观为轴线东西对称，除最北排为3栋建筑外，其余各排均是4栋，小计23栋建筑。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262779798.jpg\" title=\"15864262779798.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262773566.jpg\" title=\"15864262773566.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262779849.jpg\" title=\"15864262779849.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864262777914.jpg\" title=\"15864262777914.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262865136.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262773566.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262777914.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864262779798.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYoqxmjSNQFQRyS0F588','1','2020-04-09 17:57:12','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('546','160','0','和悦春风','','','admin','1','0','','0','0','','0','','','','','0','2020-04-09 17:58:18','admin','','/cn/upload/images/202004/15864263218165.jpg','1','1','和悦春风总占地8.84万平米，总建面17.32万平米，容积率2.0，规划36栋，1914套房源，是一个规模较大的小区。项目规划76-107㎡二到四居全线优质户型，奢想高定美宅。','0','<p>和悦春风总占地8.84万平米，总建面17.32万平米，容积率2.0，规划36栋，1914套房源，是一个规模较大的小区。</p><p>项目规划76-107㎡二到四居全线优质户型，奢想高定美宅。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864263596428.jpg\" title=\"15864263596428.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864263599184.jpg\" title=\"15864263599184.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864263604299.jpg\" title=\"15864263604299.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864263604299.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864263596428.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864263599184.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASY4t2CFOoffcgNo6t849','1','2020-04-09 17:58:18','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('547','160','0','京能｜电建·洺悦湾','','','admin','1','10','','0','0','','0','','','','','0','2020-04-09 17:59:38','admin','','/cn/upload/images/202004/15864264356127.jpg','1','1','京能｜电建·洺悦湾项目，四环外2.7公里上新，举步地铁。89平米三居俩卫，133平米四居俩卫，一梯俩户，南北通透，全明户型。一期即将开盘，具体开盘时间待定，敬请期待。','0','<p>京能｜电建·洺悦湾项目，四环外2.7公里上新，举步地铁。89平米三居俩卫，133平米四居俩卫，一梯俩户，南北通透，全明户型。一期即将开盘，具体开盘时间待定，敬请期待。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864264258554.jpg\" title=\"15864264258554.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864264254006.jpg\" title=\"15864264254006.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864264256341.jpg\" title=\"15864264256341.jpg\"/></p><p style=\"text-align: center\"><img src=\"/cn/upload/images/202004/15864264264626.jpg\" title=\"15864264264626.jpg\"/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864264356127.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864264264626.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864264254006.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:43:\"/cn/upload/images/202004/15864264256341.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','0','CMSEASYgdKG3gGUwVbr2AR284','1','2020-04-09 17:59:38','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('548','166','0','发时达法师地方','','','admin','1','0','','0','0','','0','','','','','0','2020-04-10 16:29:11','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYJUsacs6enD5eMPu217','1','2020-04-10 16:29:11','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('549','165','0','阿斯蒂芬阿斯蒂芬阿斯蒂芬','','','admin','1','0','','0','0','','0','','','','','0','2020-04-10 16:29:19','admin','','','-1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYwIg9OXt7oVJIx9B117','1','2020-04-10 16:29:19','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('550','168','0','很反感h','','','admin','1','0','','0','0','','0','','','','','0','2020-04-10 16:34:35','admin','','','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYzpdQjJGnOFkufYo455','1','2020-04-10 16:34:35','','','','1','0','','0.00','0.00','','','','','');-- 
INSERT INTO `cmseasy_archive` VALUES('551','169','0','与就有雨页头玩','','','admin','1','0','','0','0','','0','','','','','0','2020-04-10 16:34:43','admin','','/cn/upload/images/202004/15864264264626.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','0','CMSEASYacWLBMdjypg1alz520','1','2020-04-10 16:36:30','','','','1','0','','0.00','0.00','','','','','');-- 



INSERT INTO `cmseasy_b_arctag` VALUES('288','533','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('289','534','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('290','535','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('291','536','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('292','537','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('295','538','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('298','539','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('299','540','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('304','541','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('305','542','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('306','543','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('307','544','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('308','545','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('309','546','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('310','547','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('311','548','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('312','549','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('313','550','0');-- 
INSERT INTO `cmseasy_b_arctag` VALUES('315','551','0');-- 

INSERT INTO `cmseasy_b_category` VALUES('164','0','页底小图片','','','0','','','','','','ye-di-xiao-tu-pian','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','0','0','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('163','0','联系我们','','','1000','/cn/upload/images/202004/15864216356572.jpg','','','','<p>如果你想拥有一份自由有趣的工作，如果你对界面设计拥有一份热情和动力，那么请与我们联系。在这里你能发现一群志同道合的年轻人，并为了实践理想而努力！</p><p>我们的团队为自己的理想奋斗，我们互补性强，分工明确，目标一致，我们艰苦奋斗，坚持不辍！因为我们坚信，一个好的理念和一个优秀的团队势必会成就一个远大的理想！<br/>&nbsp;</p><p>联系我们：<br/>售前咨询客服QQ-01：<br/>售前咨询客服QQ-02：<br/>客户售前咨询热线：<br/>客户售后服务热线：<br/>客服信箱：</p><p><br/></p>','Contactus','archive/list_ditu.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('161','0','我们的理念','融创 臻享','','4000','/cn/upload/images/202004/15864215169940.jpg','','','','<p>卧室的整体色调是暖暖的米黄色，家具也是干净的白色系，遮光材质的窗帘、舒适的25公分厚的席梦思，保证睡眠质量睡眠。每个卧室，都配置了一个大衣柜，满足储物需求。</p><p>1.供给相对过剩，竞争激烈，今后发展速度降低。 1996年到2000年旅游酒店业共增加35.4万间客房，平均年增长率为12.39%，而同期的客源增长率为4.0%。由于供大于求，导致酒店企业之间过度竞争。从1996年到1998年全国酒店的平均出租率和利润率逐年下降，1998年开始出现全行业亏损。1998.</p><p>1999.2000年三年亏损额分别为45.56亿、53.64亿和26.43亿元。这种态势。遏制了新的投资，迫使酒店产业的规模扩张速度降低，同时提出控制酒店总量、提高酒店质量等战略性问题。</p><p>2.酒店业新的发展投资点将逐步西移并优化地域结构。</p><p>由于中国中西部地区具有较为丰富的旅游资源，同时，国家又先后出台了一系列开发中西部的措施，一部分酒店投资将有可能从东部、南部地区转向中西部地区。随着中西部经济的进一步发展以及旅游资源的进一步开发，中西部的酒店业将会进一步发展，成为中国酒店业新的、最有希望的增长区域。从总体来看，沿海发达地区各个城市旅游酒店的总量和档次都达到了很高的水平，中部地区发展迅速，有望在近3年内就可达到一个较高的水平，瓶颈主要是西部地区。</p><p>3.高档酒店的经营管理水平将继续与国际接轨，努力发展具有国际水准的经济性酒店将成为新的趋势。 就竞争领域来看，在高档酒店领域，外资酒店将继续保持优势，内资酒店大多集中在中低档领域。而在中低档领域，外资酒店还未采取行动。具有国际水准的经济性酒店将成为未来竞争和建设的重点。经济型酒店是外国酒店集团的关注点。据旅游局作的中国旅游业发展预测，到2020年，入境过夜旅游者为9500—13900万人次，年平均增长率为5.7%—7.75%。国际旅游组织进行前景预测，认为到2020年，全球将有16亿国际游客，中国将有1.3亿游客入境，成为世界上第一大入境国。就这个趋势，外国酒店集团看准了中国的经济性酒店是个有潜力的增长点。随着有薪假期的实施、交通条件的改善、民众收入水平的提高，国内旅游迅速发展，国内客人已经成为酒店不可忽视的客源。未来需求趋势是装修朴素、干净卫生、设施便利、价位适中的经济型酒店将成为国内游客所看重的酒店业类型。在质量、服务上，高档酒店基本满足需求，而中低档酒店数量虽然很多，但和国际标准相差很远。这种态势，和国际、国内的经济性客源的增长趋势不相吻合。中国拥有24万多个大中小酒店、宾馆、招待所等住宿设施，其中1万左右是星级酒店，占4%。有23万多家、96%以上的住宿设施未进入星级评定范围。这里，多数是中、小酒店。所以，改造现存的中、小酒店，使其符合国际标准，这是将来酒店行业建设上的重点。</p><p>4.国有酒店脱离原投资部门，转制问题增多，防范风险的工作越来越重要。</p><p>入世后，国际酒店更容易地进入中国酒店市场，中国酒店行业竞争加剧。由于体制原因和改革动力不足，国有酒店处于劣势地位，而且越来越被动。国有酒店面临着竞争、改组、兼并、破产的压力。国有酒店在压力面前不得不改革，在改革中就有可能被改组、出售或破产。随着改革的深入，党、政，军、警及商业银行与自己投资持有的酒店脱钩，不再经营酒店投资业务。由于所有者的转换和由此引起的体制、位置的变化。会引起酒店人心浮动，经营失衡、管理失调，以至于业绩失败。酒店的兼并、破产，会导致大量职工下岗等社会震荡。对此，防范国有酒店转制过程中出现的社会风险将越来越重要。</p><p>5.酒店行业的发展水平与人力资源开发程度的相关性越来越强。</p><p>中国酒店行业刚开始形成时，因酒店比较少，在需求增长的情况下，竞争重心是数量。所以，中国酒店业初期的发展水平与酒店设施的数量规模有关。在酒店的数量规模增大、设施档次提高、竞争激烈的情况下，行业的数量竞争转向质量竞争，行业的发展水平就和人力资源的开发水平密切相关了。因为质量竞争主要是服务竞争，服务竞争的核心是人员素质的竞争。酒店业人员的敬业精神、技术水平、职业心理素质、高级管理人才和技术人才的组合效应，以及形成一支训练有素的人才队伍等，都影响酒店业的竞争力。中国内资酒店竞争力不强，关键因素不是技术问题，而是人员素质问题。</p><p>6.酒店的集团化进程在逐渐加强，国际集团更是大举进入中国市场。</p><p>近几年来，中国酒店业开始注意集团化问题。截止到2002年底，中国共有110余家酒店管理公司，管理酒店700余家，星级酒店集团化程度达7.2%。在中国酒店业集团20强中，国际著名酒店集团入选12家，中国酒店集团入选8家。令人可喜的是，中国入选的8家酒店管理公司经营规模均已达到国际饭店集团300强的标准，反映出中国饭店集团化进程有了实质性的发展。但中国酒店业集团化的状态和国际酒店集团相比，仍有很大差距。据2000年的资料，名列中国第一位，名列全球第57位的上海锦江酒店集团仅拥有酒店50家，仅为圣达特集团的0.77%。客房13598间，仅为圣达特集团的2.5%。排行第十位的美国凯悦集团(Hyatt Hotels/HyattIntemational，USA)拥有酒店201家，拥有客房86711间。总的来说，中国的酒店集团未形成大的联合舰队：未形成规模化、一体化的集约经营；酒店集团成本高，机构臃肿，层次多，效率低；知名度不高，集团优势不明显。从发展态势来看，中国的酒店集团在短时期内很难与国外大型酒店集团形成有力的竞争，因而，中国酒店集团的发展将制约着中国酒店在国际市场的地位 。</p><p><br/></p>','Philosophy','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('162','0','关于我们','','','6000','','','','','<p>全屋装修设计风格是简约美式，整体色调是淡淡的米黄色，清新优雅，亮黄色、蓝绿色的点缀让整个空间温暖舒适又不失活力。屋内选用环保耐用的装修材料，全套的美式实木家具，舒适性和实用性都非常好。&nbsp;</p><p>酒店（又称为宾馆、旅馆、旅店、旅社、商旅、客店、客栈，中国作饭店、酒店等，马来西亚、新加坡等作酒店）其基本定义是提供安全、舒适，令利用者得到短期的休息或睡眠的空间的商业机构。</p><p>一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</p><p>中国引领亚洲地区旅游及酒店行业的快速发展，且商务休闲收入增长势头强劲。与一线城市相比，中国二、三线城市的酒店客房价格增长较为明显。由于二、三线城市新酒店陆续开业，政府投资兴建新的交通设施，这将进一步促进中国酒店客房价格稳步增长。中外酒店品牌继续扩张其营业版图，未来酒店的供需平衡将会是一项备受关注议题。全球各类连锁酒店所占的比重分别为：豪华型5%，高档30%，中档37%，经济型20%，适用型8%。不过，经济型和适用型的酒店仅占28%，发展潜力较大。截至2012年，全国住宿餐饮企业近330万家，年营业收入超过2万亿，占当年GDP的5%左右。2011年全国餐饮收入20543亿元，同比增长16.9%，从业人员2200多万人。在住宿业，全国住宿企业超过28万家，其中，全国住宿业限额以上企业达1.6万家，同比增长8.4%;营业收入2184亿元，同比增长23.3%;营业利润1603亿元，同比增长22%。行业的增长幅度有所放缓，说明过去若干年的高利润时代已经过去，进入微利时代。</p><p></p><p>发展趋势</p><p>随着酒店行业竞争的不断加剧，大型酒店企业间并购整合与资本运作日趋频繁，国内优秀的酒店企业愈来愈重视对行业市场的研究，特别是对企业发展环境和客户需求趋势变化的深入研究。正因为如此，一大批国内优秀的酒店品牌迅速崛起，逐渐成为酒店行业中的翘楚。</p><p>生产力的发展促进了酒店行业的发展。首先是货币的产生，商品交易及商人的商业活动，这种活动的产生是酒店开端的必备条件，后来随着商品活动使人类扩大活动的范围，从而产生居住等更多的需求，也就使酒店的基本功能日益增加，这从酒店的四个发展阶段不难发现。</p><p>客栈时期</p><p>产生于十八世纪前，当时名称是客栈，设备简陋，安全性差，仅能提供住、吃，服务质量差。</p><p>豪华酒店时期</p><p>产生于十九世纪初，当时英国的产业革命促进了生产力的发展，使人类社会进入工业时代。第一家豪华旅馆别墅在法国建成。此时酒店的接待对象主要是王公贵族、达官显贵、商人、上流社会度假者，接待目的为非盈利，常建于城市，铁路沿线。</p><p>同时由于蒸汽机的出现，商品的进一步丰富，交通也开始发达，从而导致酒店的开设位置有所变化。</p><p>商业酒店时期</p><p>在20世纪初至二战期间，第一家商业酒店在美国出现，其位置在于城市中心或公路旁，此时的酒店已能提供舒适、便利、清洁的服务，安全为服务宗旨，价格合理。此时汽车酒店已开始出现。</p><p>现代酒店时期</p><p>始于20世纪40年代，直到现在。此时的酒店具有一些明显的特点，如酒店连锁经营</p><p>用高科技（在客房装上互联网、使用新型的装饰材料等）；同时宾客要求酒店提供更为个性化的服务。酒店的市场定位更为专业化、各类型酒店充分。</p><p></p><p>中国与外国</p><p>中国旅游酒店的产生和发展：</p><p>最早殷商时代的驿站（官）逆旅（民）——（周）馆舍——（秦汉）旅馆——（魏晋）四夷馆（外宾）——（唐元）蕃坊、四方馆、会同馆——（鸦片战争后）现代饭店。</p><p>国外酒店的产生和发展：</p><p>商业发展促进酒店业的发展。</p><p>客栈&lt;古希腊、罗马&gt;——饭店&lt;十九世纪&gt;</p><p><br/></p>','aboutus','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('160','0','优惠活动','','','2000','','','','','','Discount','archive/list_text_pic.html','0','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('159','0','品牌理念','','','5000','/cn/upload/images/202004/15864209173396.png','','','','<p>每一间餐厅、酒吧和酒廊都独具特色在各自领域大放光彩因此只要您入住您就能轻松体验最佳城市生活当您想要宠溺一下自己时这里系列有效的天然护理疗程为您提供。</p><p>按国家统计局口径，至2007年底，中国本土星级酒店已经达到了14326家，其中包括：白金五星4家，五星361家，四星1631家，三星5534家，二星6158家。星级饭店直接从业人员超过160万人。全国共有饭店及旅游住宿单位超过30万个，从业人员超过500万人。</p><p>2007年底，全国星级饭店数量是1978年全国饭店总数的100倍；2006年全国星级饭店实现利润33亿元人民币，与上年同比增长了两倍多；全国已经拥有绿色旅游饭店2000多家；有41家国际饭店管理集团、67个饭店品牌进入中国市场，管理了516家饭店，世界排名前10位的国际饭店管理集团均已进入中国市场。</p><p>2007年的假期调整政策让酒店业绷紧了每一根敏感神经。带薪休假的出台更是激活了旅游酒店板块。带薪休假的出台，无疑是给予酒店和旅游业的一块特大蛋糕。这让酒店旅游行业进入“价量齐升”的黄金投资期。同时国内消费升级推动国内游的游客人次与人均花费同步增长，现代交通工具提供的更为快捷舒适的运输服务，使交通对旅游的瓶颈约束效应越来越小，这使观光游得以继续发展，而休闲度假游也将逐步兴起。旅游市场针对此纷纷推出相关产品，很多度假型酒店更是看准了商机，针对这个市场的变换进行着相关的调节。而对于深处大都市的商务型酒店而言这一消息同样令其拍手叫好，由于“五一”黄金周的取消，商务型酒店免去了多年来由于假期造成的“空房”甚至是“降价”的尴尬，“五一”的正常工作，让商务型酒店拥有了正常的“商务”价值。</p><p>2008年金融危机的爆发从金融界一路波及到实业界，酒店业作为与金融实体关系最为密集的产业，影响在所难免。全球经济危机的影响已蔓延至亚太地区，酒店经营者在08年下半年已开始感到经营压力。持续了数月的金融危机，通胀、油价上升导致的交通成本上涨，让不论是消费旅游还是商旅出行的人们都压紧开支。消费旅游和商旅客人的减少使得在这条产业链条上的酒店业切实感受到了冬天般的寒冷。但是，中国商务部将在三方面大力发展酒店餐饮行业，首先，大力发展大众化餐饮。其次，重点关注和解决酒店行业的放心消费问题，严把食品原料进货关。第三，积极推进节能环保工作，推动行业节能减排纵深发展。商务部高度重视中国的酒店与餐饮业，在扩大内需、拉动消费方面，将大力发展酒店与餐饮业。</p><p>酒店业应顺应国家扩大内需的号召，各大酒店尤其是高档酒店，应调整客源结构，瞄准内需市场，以度过危机。应缩减开支、降低成本，练好内功。酒店消费需求有一定的刚性，总有一部分人得住酒店，所以应抓牢商务市场，开发散客旅游市场。从长远来看，酒店业的发展前景依然是光明的。</p><p><br/></p>','DISCOVER','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('158','0','我们的产品','','','3000','','','','','<p>每家酒店意向独特，氛围温暖迷人，极具个性。每家酒店都设有极致属实的客房和绝佳的特色餐厅，陪衬迷人的艺术，总会有些意外的惊喜让您乐趣无穷</p><p><br/></p>','product','archive/list_pic.html','0','archive/show_pic.html','0','0','0','0','','','','article','1','0','0','1','1','','','','','','','','','1','1','0','','0','0','0','updatedate DESC','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('51','0','About us','','','10','/html/upload/images/201907/guanyu.jpg','','','','<p>Enterprises generally refer to legal persons or other socioeconomic organizations that use various factors of production (land, labor, capital, technology and entrepreneurship) to provide goods or services to the market for profit, and operate independently, bear their own profits and losses, and account independently.</p><p>Within the scope of commodity economy, as one of the various modes of organizational unit, according to certain organizational rules, economic entities that are organically constituted generally aim at making profits, with the mission of maximizing the interests of investors, customers, employees and the general public as well as gaining income by providing products or services. It is the product of social development, growing and growing with the development of social division of labor. Enterprises are the main participants in market economic activities. Under the socialist economic system, various enterprises coexist to form the micro-foundation of the socialist market economy. There are three basic forms of organization in enterprises: sole proprietorship, partnership and corporation. Corporate enterprise is the most important and typical form of organization in modern enterprises.</p><p>Modern economic theory holds that enterprises are essentially \"a mechanism of resource allocation\", which can optimize the allocation of social and economic resources and reduce the \"transaction costs\" of the whole society.</p><p><br/></p>','ABOUT-US','archive/list_about.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','0','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('52','0','Involving industry','','','5','','','','','','Industryinvolved','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('53','52','Automobile Manufacturing','','','0','/html/upload/images/201907/15590026854077.png','','','','<p>In the early 1980s, Germany first made cars (cars) of practical value. The automobile industry was the first to develop in France because of the wide roads and luxurious social atmosphere in Paris at that time. Later, in Europe and the United States, there were thousands of workshop-style automobile manufacturers, producing more than 3,000 models. But early automobiles had gorgeous decorations and were scattered in small batches in many small factories. The cost was high, the price was high, and the sales volume increased slowly. As a result, many small factories have been closed, and only some factories that have manufactured such products as carriages, bicycles, sewing machines and gas engines can continue to produce in small batches. In 1905, Waltz Motor Company produced 6,500 commercial cars annually, which was the largest company at that time.</p><p>At the beginning of the 20th century, H. Ford, an American, believed that cars should remove unnecessary decorations and simplify the organization. He adopted the principle of \"small profits and high sales\", and drastically reduced the price of cars, so that cars could be transformed from luxury goods of the rich into practical means of transportation of the ordinary people, so as to expand sales. He also advocated reducing the number of models, concentrating on the production of single models and adopting mass production methods. In 1907, he introduced effective processing methods and technical management measures for standardization and interchangeability of parts in industries such as light weapons, clocks and watches. In 1908, he put the simple, simple, practical and easy-to-repair T-car into the market and achieved great success. By the end of 1909, sales of T-cars had reached 150,000. In 1913, Ford first established the assembly line of automobile, changed the whole production process of automobile manufacturing, and implemented planned production, synchronous production and continuous production. This mass production technology further reduces the cost, thus causing another round of price reduction, further expanding sales, adopting advanced technology suitable for larger batch production, and further accelerating the turnover of funds. In 1923, he sold nearly two million cars. From 1908 to 1927, 15 million T-cars were produced. At that time, Ford Motor Company produced almost half of the world\'s production of cars. T-car has had a great impact on the development of automobile and automobile industry, machinery industry and mass production technology. During this period, the automobile industry has become the largest sector in the machinery manufacturing industry, and mass production technology has taken root in the machinery industry, and has been promoted and developed.</p><p>Ford\'s success has prompted American and European auto companies to change their car designs, adopt mass production technologies, reduce costs and sell prices, thus expanding their sales. In 1929, the annual output of automobiles in the United States was 5 million, and that of Britain, France and Germany was also close to 200,000 to 300,000. During the period of great development of automobile, many small and medium-sized automobile manufacturing enterprises were eliminated or merged because of lack of funds, unable to adopt advanced mass production methods, low output and high price. By the beginning of 1930, there were only 44 automobile manufacturers in the United States and 41 in Europe. During this period, General Motors and Ford Motor Company in the United States began to build or buy automobile factories in Europe, forming multinational corporations.</p><p>The world economic crisis in the early 1930s in the monopoly stage hit automobile production. However, in the mid-1930s, the automobile industry recovered and developed ahead of other machinery industries, and many small and medium-sized automobile manufacturing companies went bankrupt or merged. In several major automobile producing countries, large companies monopolized the situation. The cars produced by GM, Ford and Chrysler in the United States account for more than 70% of the American market and more than 30% of the world market. France\'s Reynolds, Berlusconi and Citroen, Germany\'s Mercedes-Benz, Mann and Opel, Britain\'s Austin, Morris and Standard, and Italy\'s Fiat all have monopolies in their own automotive industry and occupy a certain international market. During the Second World War, the automobile industry of all countries in the world devoted themselves to their wartime production, and the production of civil automobiles was in a standstill.</p><p><br/></p>','Automobile','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('54','52','energy management','','','0','/html/upload/images/201907/15590035782297.png','','','','<p>Energy is a resource that can provide energy. The energy here usually refers to thermal energy, electrical energy, light energy, mechanical energy, chemical energy, etc. Energy sources can be divided into three categories: (1) energy from the sun. Including energy directly from the sun (such as solar photothermal radiation energy) and indirectly from the sun (such as coal, oil, natural gas, oil shale and other combustible minerals and fuels, such as biomass energy, water energy and wind energy). (2) Energy from the Earth itself. One is the geothermal energy stored in the earth, such as geothermal water, underground steam and dry-hot rock mass; the other is the atomic nuclear energy stored in nuclear fuels such as uranium and thorium in the earth\'s crust. (3) The energy produced by the gravitational pull of celestial bodies such as the moon and the sun on the earth, such as tidal energy.&nbsp;</p><p>The term \"energy\" was seldom discussed in the past. It was the two oil crises that made it a hot topic for discussion. Today, with the rapid development of the global economy, international energy security has risen to the national level, and all countries have formulated energy policies with energy supply security as the core.</p><p>So what is energy? There are about 20 definitions of energy. For example, \"Energy is a resource from which energy can be obtained, such as heat, light and power\"; Encyclopedia Britannica says, \"Energy is a term that includes all fuels, running water, sunshine and wind, and human beings can make it provide the energy they need by appropriate means of conversion\"; Encyclopedia Japan \"In all kinds of production activities, we use thermal energy, mechanical energy, light energy, electric energy and so on to do work, which can be used as the natural carriers of these energy sources, called energy\"; China\'s \"Encyclopedia of Energy\" said: \"Energy can directly or through conversion to provide the light, heat and movement needed by human beings.\" Force is the carrier resource of any form of energy. It can be seen that energy is a source of energy in many forms and can be converted to each other. To be exact and simple, energy is a material resource in nature that can provide some form of energy for human beings.</p><p>Energy is also called energy resource or energy resource. It refers to the material that can produce various kinds of energy (such as heat, electric energy, light energy, mechanical energy, etc.) or work. It refers to all kinds of resources that can obtain useful energy directly or through processing and conversion, including primary energy such as coal, crude oil, natural gas, coal bed methane, water, nuclear energy, wind energy, solar energy, geothermal energy, biomass energy, secondary energy such as electricity, heat, oil products, and other new energy and renewable possibilities. Source.</p><p>energy（Energy Source ）Also known as energy resources or energy resources, is an important material basis of the national economy, the future fate of the country depends on the control of energy. The development and effective utilization of energy resources and per capita consumption are important indicators of production technology and living standards.</p><p><br/></p><p><br/></p>','Energy','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('55','52','Battery production','','','0','/html/upload/images/201907/15590037014790.png','','','','<p>Battery is a device that converts chemical energy into electrical energy by holding electrolyte solutions and metal electrodes in part of the space of cups, tanks or other containers or composite containers that generate electric current. It can be divided into positive pole and negative pole. With the progress of science and technology, batteries generally refer to small devices that can generate electricity. Such as solar cells. The main performance parameters of the battery are electromotive force, capacity, specific energy and resistance. Using batteries as energy source, we can get the current with stable voltage, stable current, stable power supply for a long time, little influence from the outside world, and the battery is simple in structure, easy to carry, easy to charge and discharge operation, not affected by the outside climate and temperature, stable and reliable in modern social life. All aspects play a very important role.</p><p>In chemical batteries, the direct conversion of chemical energy to electrical energy is the result of spontaneous oxidation and reduction reactions within the batteries, which are carried out on two electrodes respectively. The negative active material is composed of reductants with negative potential and stable in electrolyte, such as active metals such as zinc, cadmium, lead and hydrogen or hydrocarbons. Positive active substances consist of oxidants with positive potential and stable in electrolyte, such as manganese dioxide, lead dioxide, nickel oxide, oxygen or air, halogen and its salts, oxyacid and its salts, etc. Electrolytes are materials with good ionic conductivity, such as acid, alkali, salt aqueous solution, organic or inorganic non-aqueous solution, molten salt or solid electrolyte. When the external circuit is disconnected, although there is a potential difference (open circuit voltage) between the two poles, there is no current, and the chemical energy stored in the battery is not converted into electricity. When the external circuit is closed, the current flows through the external circuit under the action of the potential difference between the two electrodes. At the same time, because there are no free electrons in the electrolyte, the charge transfer is bound to be accompanied by the oxidation or reduction reaction between the active substance and the electrolyte interface, as well as the material transfer of reactants and reaction products. The transfer of charge in electrolyte is also accomplished by ion transfer. Therefore, the normal charge transfer and material transfer process inside the battery is the necessary condition to ensure the normal output of electric energy. When charging, the direction of the transmission and mass transfer process inside the battery is exactly opposite to that of discharge; the electrode reaction must be reversible to ensure the normal operation of the reverse mass transfer and mass transfer process. Therefore, reversible electrode reaction is a necessary condition for battery formation. G is Gibbs reaction free energy increment (focal), F is Faraday constant = 96500 Library = 26.8 an. h, and N is the equivalent of battery reaction. This is the basic thermodynamic relationship between the cell electromotive force and the cell reaction. It is also the basic thermodynamic equation for calculating the energy conversion efficiency of the cell. In fact, when the current flows through the electrode, the potential of the electrode will deviate from the potential of the thermodynamic equilibrium. This phenomenon is called polarization. The greater the current density (the current passing through the area of the unit electrode), the more serious the polarization is. Polarization is one of the important reasons for energy loss of batteries.</p><p>There are three reasons for polarization:</p><p>①The polarization caused by the resistance of each part of the battery is called ohmic polarization.</p><p>②The polarization caused by the retardation of charge transfer process in the electrode-electrolyte interface layer is called activation polarization, and the polarization caused by the retardation of charge transfer process in the electrode-electrolyte interface layer is called activation polarization.</p><p>③The polarization caused by the slow mass transfer in the electrode-electrolyte interface layer is called concentration polarization. The methods to reduce polarization are to increase the reaction area, decrease the current density, increase the reaction temperature and improve the catalytic activity of the electrode surface.</p><p><br/></p>','Battery','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('75','52','Chemical Industry','','','0','/html/upload/images/201907/15590039175444.png','','','','<p>Chemical industry is the abbreviation of \"chemical technology\", \"chemical industry\" and \"chemical engineering\". Any technology that uses chemical methods to change the composition, structure of substances or synthesize new substances belongs to chemical production technology, that is, chemical process. The products obtained are called chemicals or chemical products. Initially, handicraft workshops were used to produce this kind of products, but later they evolved into factories and gradually formed a specific production industry, namely chemical industry. Chemical engineering is a science to study the common law of chemical product production process. The relationship between mankind and chemical industry is very close. Some chemical products play an epoch-making role in the history of human development. Their production and application even represent a certain historical stage of human civilization.</p><p>In order to survive and develop, human beings constantly struggle with nature and gradually deepen their understanding of the surrounding world, thus mastering the ability to conquer nature and transform the world. After a long historical practice, human beings are more and more good at utilizing natural conditions and creating a rich material world for themselves.</p><p>Ancient people&#39;s lives depended more on direct use or extracting what they needed from it. Because the inherent properties of these substances can not meet people&#39;s needs, a variety of processing technologies have been developed to transform natural substances into new substances with various properties, and gradually put into practice on the scale of industrial production. Initially, handicraft workshops were used to produce such products, but later they became factories and gradually formed a specific production sector, namely, the chemical industry. With the development of productive forces, some production sectors, such as metallurgy, oil refining, paper making and leather making, have been separated from the chemical industry as independent production sectors. With the vigorous development of large-scale petroleum refining industry and petrochemical industry, chemical engineering, which is a discipline to solve many engineering and technical problems in large-scale enlargement and enlargement, has been further improved by studying the common law of chemical production process on the basis of chemistry, physics and mathematics and combining with other engineering technologies. It raises the production of chemical industry to a new level and enters a new stage of theory and prediction from an empirical or semi-empirical state (see the history of chemical engineering development). It enables chemical industry to add a lot of material wealth to mankind and accelerate the process of human social development with its creative ability of larger-scale production.</p><p>In modern Chinese, chemical industry, chemical engineering and chemical technology are abbreviated as chemical industry. They appear in different historical periods and have different meanings, but they are closely related and permeate each other. In people&#39;s minds, the term \"chemical industry\" has traditionally become a synonym for a general knowledge category and cause. Its significance in national economy and engineering technology has aroused widespread interest, attracted thousands of people and devoted their lives to it. Following is a brief description of the colorful content of chemical industry and its important contribution from all aspects of human social life.</p><p>According to the data, from January to April 2013, China&#39;s crude oil processing capacity was 158.683 million tons, an increase of 3.2%, ethylene production was 5.298 million tons, an increase of 3.0%, synthetic resin production was 18.518 million tons, an increase of 9.8%, synthetic fiber monomer production was 7.368 million tons, an increase of 14%, and synthetic rubber production was 1.321 million tons, the same as the previous year. The increase was 7.4%. Ethylene production reversed negative growth, but the growth rate was very low, and the three major syntheses also grew at a low rate. </p><p> The profit situation of the main sub-sectors of petrochemical industry basically showed a small rebound. Among them, the main business income of organic chemical raw material manufacturing industry reached 43.2218 billion yuan, an increase of 15.2% over the previous year, and the total profit reached 11.100 billion yuan, an increase of 2.3% over the previous year; the main business income of synthetic resin manufacturing industry reached 24.27 billion yuan, an increase of 13.5% over the previous year, and the total profit reached 8.031 billion yuan, an increase of 11.9% over the previous year; The main business income of the industry reached 38.833 billion yuan, an increase of 24.9% year on year, and the total profit reached 2.170 billion yuan, an increase of 17.2% year on year. The main business income of synthetic fiber monomer (aggregation) manufacturing industry reached 94.06 billion yuan, a decrease of 4.4% year on year, and the total profit reached 620 million yuan.</p><p>From the point of view of the main sub-industries, synthetic fiber monomer (polymerization) manufacturing industry suffered losses due to factors such as the dramatic decline in cotton prices. Profit levels of the two largest sub-industries, organic chemical raw material manufacturing and synthetic resin manufacturing, have also rebounded weakly, which largely reflects the cold economic fundamentals.</p><p>From the perspective of 2013, although crude oil prices remain stable at around $100 per barrel (Brent), which is beneficial to the whole petrochemical industry chain, the downward trend of demand side caused by the sustained weakening of the real economy will impact the whole industry. The growth rate of fixed assets investment will decline, the rate of start-up will decline, the economic activity of the industry will decline, and the decline cycle of chemical industry will become long and the bottom can not be clear.</p><p><br/></p>','Chemical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('56','52','Chemical Industry','','','0','/html/upload/images/201907/15590039175444.png','','','','<p>Chemical industry is the abbreviation of \"chemical technology\", \"chemical industry\" and \"chemical engineering\". Any technology that uses chemical methods to change the composition, structure of substances or synthesize new substances belongs to chemical production technology, that is, chemical process. The products obtained are called chemicals or chemical products. Initially, handicraft workshops were used to produce this kind of products, but later they evolved into factories and gradually formed a specific production industry, namely chemical industry. Chemical engineering is a science to study the common law of chemical product production process. The relationship between mankind and chemical industry is very close. Some chemical products play an epoch-making role in the history of human development. Their production and application even represent a certain historical stage of human civilization.</p><p>In order to survive and develop, human beings constantly struggle with nature and gradually deepen their understanding of the surrounding world, thus mastering the ability to conquer nature and transform the world. After a long historical practice, human beings are more and more good at utilizing natural conditions and creating a rich material world for themselves.</p><p>Ancient people\'s lives depended more on direct use or extracting what they needed from it. Because the inherent properties of these substances can not meet people\'s needs, a variety of processing technologies have been developed to transform natural substances into new substances with various properties, and gradually put into practice on the scale of industrial production. Initially, handicraft workshops were used to produce such products, but later they became factories and gradually formed a specific production sector, namely, the chemical industry. With the development of productive forces, some production sectors, such as metallurgy, oil refining, paper making and leather making, have been separated from the chemical industry as independent production sectors. With the vigorous development of large-scale petroleum refining industry and petrochemical industry, chemical engineering, which is a discipline to solve many engineering and technical problems in large-scale enlargement and enlargement, has been further improved by studying the common law of chemical production process on the basis of chemistry, physics and mathematics and combining with other engineering technologies. It raises the production of chemical industry to a new level and enters a new stage of theory and prediction from an empirical or semi-empirical state (see the history of chemical engineering development). It enables chemical industry to add a lot of material wealth to mankind and accelerate the process of human social development with its creative ability of larger-scale production.</p><p>In modern Chinese, chemical industry, chemical engineering and chemical technology are abbreviated as chemical industry. They appear in different historical periods and have different meanings, but they are closely related and permeate each other. In people\'s minds, the term \"chemical industry\" has traditionally become a synonym for a general knowledge category and cause. Its significance in national economy and engineering technology has aroused widespread interest, attracted thousands of people and devoted their lives to it. Following is a brief description of the colorful content of chemical industry and its important contribution from all aspects of human social life.</p><p>According to the data, from January to April 2013, China\'s crude oil processing capacity was 158.683 million tons, an increase of 3.2%, ethylene production was 5.298 million tons, an increase of 3.0%, synthetic resin production was 18.518 million tons, an increase of 9.8%, synthetic fiber monomer production was 7.368 million tons, an increase of 14%, and synthetic rubber production was 1.321 million tons, the same as the previous year. The increase was 7.4%. Ethylene production reversed negative growth, but the growth rate was very low, and the three major syntheses also grew at a low rate.</p><p>The profitability of the main sub-sectors of petrochemical industry has basically rebounded slightly. Among them, the main business income of organic chemical raw material manufacturing industry reached 43.2218 billion yuan, an increase of 15.2% over the previous year, and the total profit reached 11.100 billion yuan, an increase of 2.3% over the previous year; the main business income of synthetic resin manufacturing industry reached 24.27 billion yuan, an increase of 13.5% over the previous year, and the total profit reached 8.031 billion yuan, an increase of 11.9% over the previous year; The main business income of the industry reached 38.833 billion yuan, an increase of 24.9% year on year, and the total profit reached 2.170 billion yuan, an increase of 17.2% year on year. The main business income of synthetic fiber monomer (aggregation) manufacturing industry reached 94.06 billion yuan, a decrease of 4.4% year on year, and the total profit reached 620 million yuan.</p><p>From the point of view of the main sub-industries, synthetic fiber monomer (polymerization) manufacturing industry suffered losses due to factors such as the dramatic decline in cotton prices. Profit levels of the two largest sub-industries, organic chemical raw material manufacturing and synthetic resin manufacturing, have also rebounded weakly, which largely reflects the cold economic fundamentals.</p><p>From the perspective of 2013, although crude oil prices remain stable at around $100 per barrel (Brent), which is beneficial to the whole petrochemical industry chain, the downward trend of demand side caused by the sustained weakening of the real economy will impact the whole industry. The growth rate of fixed assets investment will decline, the rate of start-up will decline, the economic activity of the industry will decline, and the decline cycle of chemical industry will become long and the bottom can not be clear.</p><p><br/></p>','Chemical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('57','0','solution','','','7','','','','','','solution','archive/list_down.html','archive/list_down.html','archive/show_down.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('58','57','Industry Solutions','At the same time, it can ensure its fast and effective implementation.','','0','/html/upload/images/201907/15590055325938.jpg','','','','<p>Video conference service outsourcing business is relying on China Telecom\'s professional advantages in telecommunication technology and operation management, integrating other telecommunication products on the basis of existing video platform resources, providing customers with video conference terminal equipment maintenance, system network fault handling, video conference system operation maintenance and video conference guarantee. Many outsourcing services, such as barrier services, can provide video outsourcing solutions and system integration services according to the specific needs of enterprises.</p><p><br/></p><p>1. Video Terminal Rental or Integration</p><p>2. Operational Maintenance of Video Conference System</p><p>3. Installation and debugging of new video conference terminal.</p><p>4. Operation and Maintenance of Video Conference System</p><p>5. Video conferencing system troubleshooting; Video conferencing system operation analysis; Video conferencing system network and performance optimization recommendations; establish a complete video conferencing fault management file.</p><p>6. Video conference guarantee means that China Telecom provides conference guarantee services at all levels to meet customers\'needs, aiming at different levels and coverage of videoconferencing held on the user\'s videoconferencing system.</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\"><br/></span></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">Video Conference Communication between Headquarters and Branches</span></p><p>1. Cost savings: Compared with self-built video conferencing, using China Telecom video conferencing outsourcing business, users do not need to build and maintain their own video conferencing network, especially save investment in MCU, GK and other equipment, just install video terminals anywhere the network extends to hold video conferencing.</p><p>2. Wide coverage: Customer terminals can be spread all over the country, but also can be held abroad, domestic and international video conference. By accessing the video conferencing network built by customers, customers can communicate freely with customers who are also accessing the \"New Video\" platform of China Telecom to expand the scope of enterprise video conferencing.</p><p>3. Supporting various types of terminals: Users can benefit the old terminals, including dedicated conference room terminal, boss terminal, videophone, PC-based software desktop terminal, and compatible with both H.320 and H.323 formats.</p><p>4. Provide one-stop service: provide the whole service from consulting, pre-sale, installation and debugging, maintenance, key conference guarantee, and make full use of local operation and maintenance personnel of China Telecom to provide services, reduce service costs and improve response speed.</p><p><br/></p>','Industry','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('59','57','technical Solutions','A Solution to the Whole Problem','','0','/html/upload/images/201907/15590056384652.jpg','','','','<p>Solution is a solution (proposal, schedule) that addresses the overall problem (problems, shortcomings, needs, etc.) and ensures its rapid and effective implementation. Usually refers to the way to solve the problem.</p><p>From the traditional point of view, the solution only includes the generation phase of the solution, and the specific execution phase is separated.</p><p>However, from a unified process point of view, solutions directly serve the execution level, they are not simple linear relationships and a single interface. Therefore, to some extent, solutions and implementation interact with each other, and the effect of implementation should be timely feedback, and make corrective reference and suggestions to the original scheme.</p><p>This interaction is multiple and repetitive. A solution that can constantly improve itself can really improve the situation and make it more efficient to implement.</p><p>On the contrary, in some complex realities, problems involve more elements, and there are also complex links between them. If we expect to solve all the problems at once with a perfect solution. Putting forward the plan can rest easy and watch the actual progress of the executive level. In practice, this is not very realistic, and may produce inappropriate effects.</p><p>In the field of market economy, especially in customer-oriented cases, it is easier to be recognized and favored by customers to provide implementation reference, or even to personally participate in specific implementation solutions. In short, customers are more likely to get a complete set of solutions than to get a complete proposal or plan.</p><p>The solution must be objective and rational analysis, grasp the essence of the problem as much as possible, and grasp every detail element. Emergency emotions or perceptual factors should not be introduced into solutions, which may be counterproductive.</p><p>In fact, in practice, solutions involve few elements of creativity, more from existing success stories.</p><p>On the other hand, if there is a good analysis of the problems and an objective analysis of successful cases, it is also the basis for producing better solutions.</p><p>There is no perfect permanent solution to the problem. Designers and decision makers need to be aware of the limitations, strengths and weaknesses of solutions, as well as the uncertainties under changing conditions.</p><p><br/></p>','technical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('60','0','Contact us','','','3','','','','','<p>If you want to have a free and interesting job, if you have a passion and motivation for interface design, please contact us. Here you can find a group of like-minded young people, and strive to practice their ideals!</p><p>Our team strives for their ideals. We have strong complementarity, clear division of labor, and the same goals. We work hard and persevere! Because we firmly believe that a good idea and an excellent team will surely achieve a lofty ideal!<br/>&nbsp;</p><p>Contact us:<br/>QQ-01:<br/>Pre-sale Consulting Customer ServiceQQ-02：<br/>Customer Pre-sale Consultation Hotline:<br/>Customer service hotline:<br/>Customer Service Mailbox:</p><p><br/></p>','Contact-us','archive/list_ditu.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('61','0','Shopping','','','8','','','','','','products','archive/list_loop_products.html','archive/list_products.html','archive/show_products.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','1','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('62','61','Intelligent products','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Intelligent','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','updatedate DESC','1','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('63','61','Home Appliance Products','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','Appliances','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('64','61','Intelligent Wearing','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','smart-wearer','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('65','61','Healthy children','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Children','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('66','0','Group Industry','','','9','','','','','','Group-industry','archive/list_text_pic.html','archive/list_text_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('67','66','Warehousing Logistics','','','0','','','','','','storage','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('68','66','Vehicle transportation','','','0','','','','','','vehicle-transport','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('69','66','Integrated Transport','','','0','','','','','','Comprehensive','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('70','0','Job Recruitment','','','2','','','','','','Job-recruitment','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('71','0','News','','','6','','','','','','News','archive/list.html','archive/list_text_pic.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('72','71','Enterprise News','','','0','','','','','','Industry-news','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('73','71','Industry News','','','0','','','','','','Corporate-news','archive/list_text.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('74','0','Our customers','','','1','','','','','','Our-customers','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('78','77','Employee Development','','','0','/html/upload/images/201907/15590305077365.jpg','','','','<p>Employee development content...</p><p><br/></p>','yuan-gong-fa-zhan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('79','77','Employment opportunities','','','0','/html/upload/images/201907/15590305335789.jpg','','','','<p>Employment opportunities...</p><p><br/></p>','jiu-ye-ji-hui','archive/list_job.html','archive/list_job.html','archive/show_job.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('80','77','Fashion figures','','','0','/html/upload/images/201907/15590305596900.jpg','','','','<p>Fashion character content...</p>','feng-shang-ren-wu','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('77','0','Job','We see the world and the bright future of your career. The world is a place of increasingly complex challenges, and it expects us to address them. Do you have vision and ambition for this challenge?','','4','','','','','<p>We see the world and the bright future of your career. The world is a place of increasingly complex challenges, and it expects us to address them. Do you have vision and ambition for this challenge?</p>','HUMAN-RESOURCES','archive/list_HR.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('81','51','Address by the Chairman','Group Chairman：','','0','/html/upload/images/201907/15590892414438.jpg','','','','<p>We build innovative solutions to address today\'s environmental challenges and thus stimulate economic growth. Health Creation promises to make more people healthier. We create a healthier world through imaginative ideas and mature solutions.</p>','CHAIRMANS-SPEECH','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('82','51','Brief Introduction to the Group','','','0','/html/upload/images/201907/15590892812276.jpg','','','','<p>The company is a global digital industry company, which creates software-defined machines, integrates the wisdom of interconnection, response and prediction, and is committed to transforming traditional industries. The Global Knowledge Exchange System enables all businesses to share technology, markets, structures and intelligence, and each invention promotes cross-border innovative applications. GE understands the needs of the industry, describes the industrial language, and creates exceptional performance for customers with global talent, service, technology and scale.</p><p><br/></p><p><br/></p>','GROUPPROFILE','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('83','51','development history','','','0','','','','','','DEVELOPMEN-THISTORY','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('84','51','Cultural Activity','','','0','','','','','','CULTURAL-ACTIVITY','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('85','51','honor','','','0','','','','','','rong-yu-zi-zhi','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('86','51','Leadership Care','','','0','','','','','<p>Leadership care content...</p>','ling-dao-guan-huai','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('87','0','Mall Content Page 5 Commitment','','','0','','','','','','shang-cheng-nei-rong-ye-5-cheng-nuo','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','2','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('123','0','우리가 어떻게','','','10','/html/upload/images/201907/guanyu.jpg','','','','<p>기업은 일반적으로 영리를 목적으로 각종 생산요소 (토지, 노동력, 자본, 기술과 기업가 재능 등)를 운용하여 시장에 상품이나 서비스를 제공하고, 자주경영, 손익의 독립채산을 실시하는 법인이나 기타 사회경제조직을 가리킨다.</p><p>상품경제 범주 내에, 조직 유형의 다양한 모델의 하나로서, 일정한 조직 규율에 따라 유기적으로 구성된 경제 실체는 일반적으로 영리를 목적으로, 투자자, 고객, 직원, 사회 대중의 이익 극대화를 사명으로 달성하고, 제품 또는 서비스를 제공하여 수입을 얻을 수 있습니다.그것은 사회발전의 산물로서 사회분업의 발전에 따라 성장, 장대해진다.기업은 시장경제활동의 주요참여자이다.사회주의시장경제체제하에 각종 기업들이 병존하여 공동으로 사회주의시장경제의 미시적토대를 이루고있습니다.기업에는 세가지 기본조직형식이 존재한다. 독자기업, 합명기업과 회사, 회사제기업은 현대기업중에서 가장 주요하고 가장 전형적인 조직형식이다.</p><p>현대 경제학 이론에 따르면, 기업은 본질적으로\"자원 배분의 메커니즘\"으로 사회 경제 자원의 최적의 배분을 실현, 전체 사회의\"거래 비용\"을 낮출 수 있습니다.</p><p><br/></p>','ABOUT-US','archive/list_about.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('124','0','산업과 관련되다','','','5','','','','','','Industryinvolved','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('125','124','자동차 제조','','','0','/html/upload/images/201907/15590026854077.png','','','','<p>개척단계 19세기 80년대에 독일에서 처음으로 실용가치가 있는 자동차 (승용차)를 제조하였다.당시 빠리는 넓은 도로와 사치스러운 사회풍기로 말미암아 프랑스에서 자동차공업이 제일 먼저 발전하였다.이후 유럽과 미국에는 수많은 작업장 형태의 자동차 제작소가 생겨났고 3000개 이상의 차종이 생산됐다.그러나 초기의 자동차는 화려한 장식이 있을뿐만아니라 많은 작은 공장들에 분산되여 생산원가가 높고 판매가가 비쌌으며 판매량 증가가 아주 느렸다.이 때문에 많은 소공장들이 문을 닫게 되였고 마차, 자전거, 재봉틀, 가스기 등을 생산한 일부 공장들만이 소량생산을 계속할수 있게 되였다.1905년 미국 오츠자동차회사의 연간 생산품 자동차는 6500대. 당시 연간 생산량이 가장 많은 회사였다.</p><p>발전단계 20세기초에 미국의 H. 포드는 자동차는 반드시 불필요한 장식을 없애고 기구를 간소화해야 한다고 인정하였다. 그는 박리다매의 경영방침을 채용하고 판매가격을 대폭 낮추어 부자의 사치품에서 일반인의 실용적인 교통수단으로 전환시켜 판매량을 확대하였다.또 차종을 줄이고 단일 차종을 집중 생산하며 대량생산을 주장했다.1907년에는 경무기, 시계 등 공업에 효과적인 부품 표준화와 교환가공 방법과 기술관리 조치를 도입했다.그는 1908년 간소하고 실용적이며 수리가 쉬운 T 형 승용차를 시장에 내놓아 큰 성공을 거뒀다.1909년말 T 형승용차의 판매량은 15만대에 달하였다.1913년, 포드는 먼저 자동차의 라인 (lind)을 세우고 자동차 제조의 전 과정을 바꾸어 계획생산, 동시생산, 련속생산을 실시하였다.이러한 대량적생산기술은 원가를 가일층 낮추게 하며 따라서 또 한차례의 가격인하를 초래하며 판매량을 가일층 확대하고보다 대량적생산에 적합한 선진기술을 도입하여 자금회전을 가일층 가속화한다.1923년, 그의 자동차 판매량은 200만 대에 가까웠다.1908-1927년 사이에 T 형승용차 도합 1,500만대를 생산하였다.당시 포드자동차가 생산한 자동차는 세계생산량의 거의 절반을 차지하였다.T 형승용차는 자동차와 자동차공업의 발전, 기계공업과 대량생산기술에 중대한 영향을 일으켰다.이 기간에 자동차공업은 기계제조공업의 가장 큰 부문으로 되였으며 대량의 생산기술은 기계공업에 뿌리를 내리고 보급과 발전을 가져왔다.</p><p>포드의 성공은 미국과 유럽의 자동차회사들을 잇따라 자동차 설계로 바꿔 대량생산 기술을 도입하고, 원가와 가격을 낮추면서 판로를 넓히고 있다.1929년 미국 자동차의 연간 생산량은 500만 대였고, 영국 · 프랑스 · 독일 등의 연간 생산량도 20만~30만 대에 육박했다.자동차가 크게 발전하는이 시기에 많은 중소형자동차제조기업은 자금이 부족하여 선진적인 대량생산방식을 채용할수 없었으며 생산량이 낮고 판매가가 높아 륙속 도태되거나 합병되였다.1930년대 초 미국의 자동차 제조업체는 44개사, 유럽의 자동차 제조업체는 90개에서 41개로 줄었다.이 시기에 미국의 제너럴모터스 (gm)와 포드자동차가 유럽에 공장을 짓거나 자동차공장을 사들여 다국적기업으로 성장하기 시작했다.</p><p>독점단계인 1930년대초의 세계적인 경제위기는 자동차생산에 타격을 주었다.그러나 30년대 중기에 자동차공업이 기타 기계공업보다 먼저 회복되고 발전하였으며 적지 않은 중소형자동차제조회사가 파산되거나 합병되여 몇개 주요자동차생산국들에서 모두 대형회사가 독점하는 국면이 나타났다.미국의 gm · 포드 · 크라이슬러 3 사가 생산하는 승용차는 미국 시장의 70% 이상, 세계 시장의 30% 이상을 차지하고 있다.프랑스의 르노 · 베루 · 시트로앵 등 3개사, 독일의 벤츠 ·만 · 오페 3개사, 영국의 오스틴 · 모리스 · 스탠더드 3개사, 이탈리아의 피아트는 자국 자동차 산업에서 독점적 지위를 차지하면서 국제시장을 형성하고 있다.제2차세계대전기간에 세계 각국의 자동차공업이 모두 본국의 전시생산에 투입되여 민용자동차생산이 정체상태에 처하였다.</p><p><br/></p>','Automobile','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('126','124','에너지 관리','','','0','/html/upload/images/201907/15590035782297.png','','','','<p>에너지는 에너지를 제공할 수 있는 자원이다.여기서 말하는 에너지는 보통 열에너지, 전기에너지, 광에너지, 기계에너지, 화학에너지 등을 가리킨다.에네르기원천은 그 래원에 따라 3가지 류형으로 나눌수 있다. (1) 태양으로부터 온 에네르기.태양으로부터 직접 오는 에너지 (태양광열복사에네르기)와 태양으로부터 간접적으로 오는 에너지 (석탄, 석유, 천연가스, 유혈암 등 가연성 광물 및 봉재 등 바이오매스 에너지, 물에네르기와 풍력에너지 등) 가 포함된다.(2) 지구 자체로부터 오는 에네르기.하나는 지구내부에 매장되여있는 지열에네르기이다. 례를 들면 지하온수, 지하증기, 건열암체이다.다른 하나는 지각 내 우라늄 · 토리움 등의 핵연료에 매장된 원자핵에너지다.(3) 달과 태양 등 천체가 지구에 대한 만력, 이를테면 조력에네르기.&nbsp;</p><p>\'에너지\'라는 용어는 과거 사람들이 드물게 사용하던 용어다. 두 차례의 오일쇼크가 이를 이슈로 만들었다.세계경제가 고속발전하고있는 오늘날 국제에너지안전은 이미 국가의 높이에 올라섰으며 각국은 모두 에너지공급안전을 핵심으로 하는 에너지정책을 제정하였다.</p><p>그렇다면 무엇이\'에너지\'일까.에너지에 대한 정의는 약 20가지가 있다.\"에너지는 열, 빛, 동력 같은 에너지를 얻을 수 있는 자원이다.\"≪ 대영백과사전 ≫은\"에네르기란 모든 연료, 흐르는 물, 해빛과 바람을 포함한 술어로서 인류는 적당한 전환수단으로 자기에게 필요한 에네르기를 제공할수 있다.\"고 하였다.≪ 일본대백과전서 ≫는\"각종 생산활동에서 열에네르기, 력학적에네르기, 빛에네르기, 전기에네르기 등을 리용하여 일을 하는데 이런 에네르기원천으로 리용될수 있는 자연계의 각종 담체를 에네르기원천이라고 한다.\"고 하였다.우리 에너지 백과사전은 에너지는 인류가 필요로 하는 빛, 열, 동력 등 어떤 형태의 에너지를 직접 또는 전환을 통해 제공해 주는 에너지원이라고 했다.이로부터 알수 있는바 에네르기원천은 여러가지 형태로 서로 전환할수 있는 에네르기의 원천이다.정확하고도 간단하게 말하면 에네르기원천은 자연계에서 인류를 위해 모종 형태의 에네르기를 제공하는 물질자원이다.</p><p>에네르기원천은 에네르기자원 또는 에네르기자원이라고도 한다.여러가지 에네르기 (례하면 열량, 전기에네르기, 빛에네르기, 력학적에네르기 등)를 산생할수 있거나 일을 할수 있는 물질을 통칭하는것을 말한다.이란 직접 취득 하 거나 유 가공 · 전환 로 취득 유용 할 수 있 는 각종 자원 을 포함, 원유 와 천연가스, 석탄, 가스 수력, 원자력 · 풍력 · 태양광 · 지열에너지, 생물 질능 등 1 차 에너지 와 전력, 热力, 연료 유 등 2 차 에너지, 기타 신 · 재생 에너지 다.</p><p>에너지（Energy Source ) 에네르기자원 또는 에네르기자원이라고도 하는데 국민경제의 중요한 물질적기초이며 미래의 국가운명은 에네르기의 장악에 달려있다.동력자원의 개발과 효과적인 리용정도 및 일인당 소비량은 생산기술과 생활수준의 중요한 표징으로 됩니다.</p><p><br/></p><p><br/></p>','Energy','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('127','124','전지 생산','','','0','/html/upload/images/201907/15590037014790.png','','','','<p>전지（Battery）전해질 용액과 금속 전극을 담아 전류를 발생시키는 컵, 홈통 또는 다른 용기 또는 복합용기의 일부 공간, 즉 화학에너지를 전기에너지로 바꿀 수 있는 장치를 말한다.양극과 음극의 구분을 가지고 있다.과학기술의 발전과 더불어 전지는 전기에네르기를 산생할수 있는 소형장치를 통칭한다.례하면 태양에네르기전지이다.전지의 성능 변수는 주로 전동력, 용량, 비에너지와 저항이 있다.이용 해 배터리 을 에너지원 출처 를 받 을 수 있 는 안정 전압 을 안정 전류 장시간 안정 전기 공급 을 외부 영향 작다 는 전류 가 흐 르 고 배터리 구조를 단순 해 휴대 가 간편, 충 · 방전 모두 조작 간편하다 사업 을 받 지 않 고 외부 기후 와 온도 의 영향 으로 성능 안정 믿 을 현대 사회 생활 속 의 여러 측면 에서 큰 역할 을 했 다.</p><p>화학전지 중 화학에너지가 직접 전기에너지로 전환하는 것은 배터리 내부의 자발적인 산화 · 환원 등 화학반응에 의한 것으로,이 반응은 각각 두 전극에서 진행된다.음극활성물질은 아연, 카드미움, 연 등 활발하고 활발한 금속과 수소 또는 탄화수소 등 전기위치가 비교적 부하를 갖고있고 전해질가운데서 안정된 환원제로 구성되였다.양극활성물질은 이산화망간, 이산화연, 산화니켈 등 금속산화물, 산소나 공기, 할로겐 및 그 염류, 산소산과 그 염류 등을 포함한 전위가 비교적 긍정적이고 전해질속에서 안정된 산화제로 구성되였다.전해질은 우수한 이온이 전기를 전도하는 재료인데, 예를 들면 산, 염기, 염의 수용액, 유기 혹은 무기비수용액, 용융염 혹은 고체전해질 등이다.외부회로가 끊어졌을 때 량극사이에는 비록 전위차 (개통전압) 가 있지만 전류가 없고 전지에 저장된 화학에네르기는 전기에네르기로 전환되지 않는다.외회로가 닫힐 때 량극전위차의 작용하에 전류가 외회로를 흐른다.동시에 전지내부에는 전해질속에 자유전자가 없기때문에 전하는 량극활성물질과 전해질계면의 산화 또는 환원반응 및 반응반응물의 물질이동을 동반하게 된다.전해질에서의 전하의 전달도 이온의 이동에 의하여 완성된다.그러므로 건전지내부의 정상적인 전하전송 및 물질전송 과정은 정상적인 전력수출을 보장하는 필수조건이다.충전할 때 건전지내부의 전기와 질전도과정의 방향은 방전과 반대된다.전극반응은 반드시 가역적이여야 반대방향의 전질과 전기전도과정의 정상적인 진행을 보장할수 있다.그러므로 전극반응가역은 축전지를 구성하는 필수조건이다.G는 기브스의 반응의 자유에 대하여 량을 증가시킨다 (초점).F는 파라데이상수 = 96,500 쿠 =26.8 엔.n배터리 반응의 당량입니다.이는 전지의 전동력과 전지의 반응 사이의 기본열력학적관계식이며 전지의 에네르기전환효률을 계산하는 기본열력학적방정식이기도하다.사실상 전류가 전극을 흐를 때 전극전력은 모두 열력학평형의 전극전세로부터 벗어나게 되는데 이런 현상을 극화라고 한다.전류의 밀도 (단위전극면적에서 흐르는 전류) 가 클수록 극화는 더 심해진다.극화현상은 전지의 에네르기손실을 초래하는 중요한 원인의 하나이다.</p><p>극화의 원인에는 다음과 같은 세가지가 있습니다.</p><p>①전지의 각 부분의 저항에 의한 극화를 옴극화라고 한다.</p><p>②전극-전해질계면층중의 전하전달과정의 저지로 인한 극화를 활성극화라고 한다.</p><p>③전극화-전해질계면층중의 전질전도과정이 느려 조성된 극화를 농차극화라고 한다.극화 방법은 전극 반응 면적을 확대하고 전류 밀도를 줄이며 반응 온도를 높이고 전극 표면의 촉매 활성화를 개선하는 것이다.</p><p><br/></p>','Battery','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('128','124','화학공업','','','0','/html/upload/images/201907/15590039175444.png','','','','<p>화학은 화학공예 화학공업 화학공학 등의 약칭이다.화학 방법을 운용하여 물질의 구성, 구조 혹은 새로운 물질을 합성하는 기술은 모두 화학 생산 기술, 즉 화학 공예에 속하고, 획득한 제품을 화학 제품 또는 화학 제품 이라고 불리운다.처음에는 이런 제품을 생산하는 공장들이 수공업공장이였는데 후에는 공장으로 변하여 특정한 생산업종인 화학공업이 점차 형성되였다.화학공학은 화학제품생산과정의 공통성법칙을 연구하는 과학이다.인류와 화학공업의 관계는 매우 밀접한바 일부 화학공업제품은 인류발전력사에서 획기적인 중요한 역할을 놀고있으며 그 생산과 응용은 인류문명의 일정한 력사단계를 대표하고있다.</p><p>인간은 생존과 발전을 추구하기 위해 끊임없이 대자연과 투쟁하고, 주변 세계에 대한 인식을 점차적으로 심화시켜 자연을 정복하고 세계를 개조하는 능력을 장악하게 되었다.기나긴 력사적실천을 거쳐 인류는 자연조건을 더욱 잘 리용하였으며 또한 자신을 위해 풍부한 물질세계를 창조하였습니다.</p><p>고대사람들의 생활은 직접 리용하거나 또는 필요한것을 끌어내는데 더 많이 의존하였다.이러한 물질의 고유성능이 사람들의 수요를 만족시키지 못하기때문에 각종 가공기술이 산생되여 천연물질을 여러가지 성능을 가진 새로운 물질로 전변시켰으며 공업생산의 규모에서 그것을 점차 실현하게 되였다.처음에는 이런 제품을 생산하는것이 수공업공장이였으나 후에는 공장으로 변하여 일정한 생산부문, 즉 화학공업이 점차 형성되였다.생산력의 발전에 따라 야금, 정유, 제지, 제혁 등과 같은 일부 생산 부문은 이미 독립적인 생산 부문으로 화학공업에서 분류되어 나왔다.대규모 석유제련공업과 석유화학이 활발히 발전한후 화학, 물리학, 수학을 기초로 기타 공학기술을 결합하여 화공생산과정의 공동법칙을 연구하였으며 규모확대와 대형화에 나타난 많은 공정기술문제를 해결하는 학과인 화학공학이 가일층 완비되였다.화학공업생산을 새로운 수준에로 끌어올리며 경험 또는 반경험상태로부터 리론과 예측의 새로운 단계에 들어서게 하며 (화학공정의 발전사를 보라.) 화학공업으로 하여금 더 큰 규모의 생산창조능력을 갖게 함으로써 인류에 대량의 물질적부를 증가시키고 인류사회의 발전행정을 가속화한다.</p><p>현대 중국어, 화학 공업, 화학 공학과 화학 공예 모두 약칭으로 화학공업, 서로 다른 역사적 시기에, 서로 다른 함의를 가지고 있지만, 밀접하게 상호 침투한다.사람들의 머리속에서\"화학공업\"이라는 단어는 습관상에서 이미 하나의 총적인 지식분야와 사업의 대명사로 되였다. 그것이 국민경제와 공학기술 면에서 가지는 중요한 의의는 사람들의 광범위한 흥취를 불러일으켰고 수천수만의 사람들로 하여금 일생의 정력을 바치게 하였다.아래에 아름다운 화학공업 내용과 그 중요한 기여를 인류사회생활의 여러 면으로부터 요약하여 설명하겠습니다.</p><p>수치로 보면 2013년 1~4월, 우리 나라 원유가공량은 15868만 3,000톤으로 동기대비 3.2% 성장했다.에틸렌생산량은 529만 8,000톤으로 동기대비 3.0% 증가하였고합성수지의 생산량은 1,851만 8,000톤으로 동기대비 9.8% 증가하였고합성섬유의 단위당 생산량은 736만 8,000톤으로 동기대비 1.4% 증가하였고합성고무생산량은 132만 1,000톤으로 동기대비 7.4% 증가하였다.에틸렌생산량은 마이너스성장을 전환하였지만 성장속도가 아주 낮았고 3대 합성도 모두 저속성장하였다.</p><p>석유화학 각 주요 자영업 분야의 영리 상황이 기본적으로 소폭 반등세를 보였다.그중 유기화학원료제조업이 주요경영업무를 실현하여 얻은 수입은 4,322억 1,800만원으로 동기대비 15.2% 늘어났고 리윤총액은 111억 2,000만원으로 동기대비 2.3% 늘어났다.합성수지제조업은 주요경영업무수입이 2,427억 100만원으로 동기대비 13.5% 늘어났고 리윤총액은 80억 3,100만원으로 동기대비 11.9% 늘어났다.합성고무제조업은 주요경영업무수입이 388억 3,300만원으로 동기대비 24.9% 늘어났고 리윤총액은 21억 7,700만원으로 동기대비 17.2% 늘어났다.합성섬유단체 (집합) 제조업이 주요영업업무를 실현하는 수입은 946억 600만원으로 동기대비 4.4% 하락하고 리윤총액은-6억 20만원을 실현하였다.</p><p>주요 계열사별로는 합성섬유 단자 (컨버전스) 제조업이 면화 가격이 크게 떨어진 등의 영향으로 적자를 냈다.유기화학원료 제조업과 합성수지 제조업의 두 가지 가장 큰 자영업 영리 수준도 반등하지 못하고 있는데, 이것은 매우 큰 부분 경제의 기초면이 다소 춥다는 것을 반영하고 있다.</p><p>2013년의 경우 원유가격이 배럴당 100달러를 오르내리며 석유화학 산업 사슬에 비교적 유리하지만, 실물경제의 지속적인 약세로 인한 수요 감소 추세는 업계 전체에 충격을 줄 것이다.고정 자산 투자 증가 속도 이 떨 어 지고 척 臵 가동률 이 떨 어 져 업종 의 경제 活度 떨 어 지고 화공 하락 주기 는 이 길 고 바닥 못 명 확 해 졌 다.</p><p><br/></p>','Chemical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('129','0','해결 방안','','','7','','','','','','solution','archive/list_down.html','archive/list_down.html','archive/show_down.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('130','129','업계 솔루션','빠르게 실행할 수 있도록','','0','/html/upload/images/201907/15590055325938.jpg','','','','<p>화상 회의 서비스 아웃 소 싱 은 \" 2018 년 차 이나 텔레콤 은 텔레콤 기술 과 운영 관리 분야 의 전문 강점 을 기존 동영상 플랫폼 자원 을 바탕 으로 다른 제품, 통합 텔레콤 을 고객 들 에게 제공 한몸 회의 단말기 유지 · 시스템 고장 처리, 인터넷 한몸 회의 시스템 정비 와 한몸 운행 회의 보장 서비스 등 다 양 한 하청 서비스 를 제공 하 고 수 에 따 라 특정 기업 의 수요 를 동영상 으로 외주 해결 방안, 시스템 통합 (si) 서비스 를 시작 했 다.</p><p><br/></p><p>1. 비디오 터미널 임대 또는 통합</p><p>2. 화상회의 시스템 실행 유지</p><p>3. 새로 추가된 화상회의 터미널의 설치 및 성능시험.</p><p>4. 비디오 회의 시스템의 작동 유지 관리</p><p>5. 화상회의시스템의 고장 제거,화상회의시스템의 운행상황분석,화상회의시스템의 네트워크와 성능을 최적화할데 대한 건의,완벽한 화상회의 고장관리서류를 구축한다.</p><p>6. 화상회의 보장이란 사용자 화상회의 시스템에서 개최하는 각종 등급, 피복 범위의 화상회의에 대비해 중국텔레콤은 고객의 요구를 충족시키는 다양한 차원의 회의보장 서비스를 제공한다.</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\"><br/></span></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">본부와 지사가 화상회의 소통을 진행하다</span></p><p>1. 비용 절감:자체 건설 화상회의 보다는 중국 전신 화상회의 아웃소싱을 사용하며, 사용자는 자신의 화상회의 네트워크를 신축, 보수할 필요가 없다. 특히 MCU, GK 등 설비투자를 줄일 필요가 없다. 인터넷이 확대되는 어디서든 화상회의만 설치하면 된다.</p><p>2. 피복 범위 넓습니다:고객터미널은 전국, 동시에 국외에서 국내, 국제 비디오 회의를 열 수 있습니다.고객이 자체 건설한 화상회의 전문망에 접속하여 고객과 마찬가지로 중국전신\"신시통\"플랫폼에 가입한 고객간 자유로운 소통을 통하여 기업의 화상회의 범위를 확대한다.</p><p>3. 다양한 유형의 터미널 지원:사용자는 기존 터미널, 전용 회의실형, 사장형 터미널, 화상전화, PC 기반의 소프트웨어 데스크톱 터미널을 사용, h.320과 h.323 두 가지 기능을 겸용할 수 있습니다.</p><p>4. 원스톱 서비스를 제공합니다:자문, 판매 전, 설치 조정, 유지 관리, 중점 회의 보장 등 전체 서비스를 제공하고, 중국 전신 현지 운송요원을 충분히 이용하여 서비스를 제공하고, 서비스 원가를 낮추며, 호응 속도를 높입니다.</p><p><br/></p>','Industry','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('131','129','기술 해결 방안','모든 문제를 해결할 수 있는','','0','/html/upload/images/201907/15590056384652.jpg','','','','<p>해결 방안 Solution 은 어떤 것들이 이미 드러났거나 예상할 수 있는 문제, 부족, 부족, 수요 등에서 제시한 하나의 해결 방안 (건의서, 계획표), 빠른 효과적인 집행을 확보할 수 있다.일반적으로 문제를 해결하는 방법을 가리킨다.</p><p>전통적인 관점에서 해결 방안은 방안의 생성 단계만을 포함하고 구체적인 집행 단계는 따로 구분된다.</p><p>그러나 통일적인 과정으로부터 볼 때 해결방안은 직접 집행차원에서 봉사하며 간단한 선형관계나 단일한 인터페이스는 아니다.그러므로 어느 정도에서 보면 해결방안과 집행은 상호 영향주므로 집행효과가 제때에 피드백되여야 하며 또한 원 방안에 대해 수정성을 띤 참고와 건의를 해야 한다.</p><p>이런 교류는 다중적이고 중복적이다.끊임없이 자신을 완전해지게 하는 해결책만이 진정으로 상황을 개선하여 더욱 효률적으로 집행할수 있다.</p><p>반대로 일부 복잡한 현실상황을 놓고보면 문제는보다 많은 요소와 관련되며 문제들사이에도 복잡한 련관이 있다.완벽한 해결방안을 기대한다면, 모든 문제를 한꺼번에 풀어나가야 한다.방안을 내놓으면 안심하고 집행층의 실질적 진척을 방관할 수 있다.이것은 실제상 그리 현실적이 못되며 적응되지 않는 효과도 나타날수 있습니다.</p><p>시장경제령역 특히 고객을 대상으로 한 사례에서 집행에 참조를 제공할수 있고 심지어 직접 집행중의 해결방안에 참여할수 있어 더욱 쉽게 고객의 인정과 환영을 받을수 있다.간단히 말하면 완전한 건의서나 계획서를 받는것보다 고객은 문제를 해결하는 일련의 서비스를 더욱 원하는것이다.</p><p>해결책은 반드시 객관적이고 리성적인 분석이여야 하며 될수록 문제의 본질을 파악하고 매개 세부요소를 파악해야 한다.문제에 부닥친 절박한 정서나 감성적 요인을 해법에 끌어들이려 해서는 안 된다.</p><p>사실 실제 조작에서 해결방안은 창의와 관련되는 요소가 많지 않으며 더욱 많은것은 이미 존재하는 성공사례로부터 찾는다.</p><p>다른 한면으로 문제를 잘 분석하고 성공사례를 객관적으로 분석한다면 그 자체가 더욱 좋은 해결방안을 산생하는 기초이다.</p><p>완벽한 것이 없으면 반드시 문제를 해결할 수 있는 영구적인 해결 방안이다.디자이너와 의사결정자는 해결 방안의 한계성을 깨닫고 우세와 열세 그리고 변화 조건 아래 불확실성을 깨워야 한다.</p><p><br/></p>','Technical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('132','0','연락해 주세요','','','3','','','','','<p>자유로운 일자리를 갖고 싶다면 인터페이스 디자인에 대한 열정과 동력을 가지고 있다면 연락 주세요.여기에서 너는 뜻이 맞는 젊은이들을 발견할 수 있고, 그리고 이상을 실천하기 위해 노력할 수 있다!</p><p>우리 팀 은 자신 의 이상적 분투 를 우리 는 서로 보완성 이 강하 고 분업, 목표 일치, 우리들 의 고난 분투 를 견지하 고, 그치지 않 았 다!우리는 좋은 이념과 훌륭한 팀워크는 반드시 원대한 이상을 이루게 될 것이라고 믿기 때문이다.<br/>&nbsp;</p><p>연락해 주세요:<br/>판매전 고객 상담QQ-01：<br/>판매전 고객 상담QQ-02：<br/>고객 매점 문의 핫라인:<br/>고객 애프터서비스 핫라인:<br/>캐리어:</p><p><br/></p>','Contact-us','archive/list_ditu.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('133','0','정선 제품','','','8','','','','','','Products','archive/list_loop_products.html','archive/list_products.html','archive/show_products.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','1','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('134','133','스마트 제품','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Intelligent','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','updatedate DESC','1','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('135','133','가전제품','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','Appliances','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('136','133','스마트 착용','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','Smart-wearer','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('137','133','건강 아동','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Children','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('138','0','그룹 산업','','','9','','','','','','Group-industry','archive/list_text_pic.html','archive/list_text_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('139','138','물류 를 창고 에 저장하다','','','0','','','','','','Storage','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('140','138','차량 수송','','','0','','','','','','vehicle-transport','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('141','138','종합수송','','','0','','','','','','Comprehensive','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('142','0','직원 모집','','','2','','','','','','Job-recruitment','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('143','0','뉴스 정보','','','6','','','','','','News','archive/list.html','archive/list_text_pic.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('144','143','기업 뉴스','','','0','','','','','','Industry-news','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('145','143','업종 뉴스','','','0','','','','','','Corporate-news','archive/list_text.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('146','0','우리 고객','','','1','','','','','','Our-customers','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('147','0','인적 자원','우리는 세계와 너의 사업의 밝은 미래를 보았다.세계는 갈수록 복잡해지는 도전이다. 우리는 이 도전을 해결하기를 기대한다.당신은 이런 도전의 원견과 웅심을 가지고 있습니까?','','4','','','','','<p>우리는 세계와 너의 사업의 밝은 미래를 보았다.세계는 갈수록 복잡해지는 도전이다. 우리는 이 도전을 해결하기를 기대한다.당신은 이런 도전의 원견과 웅심을 가지고 있습니까?</p>','HUMAN-RESOURCES','archive/list_HR.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('148','147','종업원 발전','','','0','/html/upload/images/201907/15590305077365.jpg','','','','<p>직원 발전 내용.</p><p><br/></p>','yuan-gong-fa-zhan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('149','147','취업 기회','','','0','/html/upload/images/201907/15590305335789.jpg','','','','<p>취업 기회 내용...</p><p><br/></p>','jiu-ye-ji-hui','archive/list_job.html','archive/list_job.html','archive/show_job.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('150','147','풍조 인물','','','0','/html/upload/images/201907/15590305596900.jpg','','','','<p>풍격 인물 내용.</p>','feng-shang-ren-wu','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('151','123','회장','그룹 회장:','','0','/html/upload/images/201907/15590892414438.jpg','','','','<p>우리는 오늘날의 환경 도전을 해결하기 위해 새로운 해결 방안을 구축하여 경제성장을 이끌었다.건강한 창상 ’ 은 더 많은 사람들을 건강하게 할 것을 약속했다.우리는 상상력이 풍부한 이념과 성숙한 해결 방안을 통해 더욱 건강한 세계를 창조한다.</p>','CHAIRMANS-SPEECH','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('152','123','그룹 소개','','','0','/html/upload/images/201907/15590892812276.jpg','','','','<p>회사는 글로벌 디지털 공업회사로 소프트웨어 정의 기계를 창조하고, 호련과 예측의 지혜를 모아 전통 공업의 변혁에 힘쓰고 있다.전 세계 지식 교환 시스템 은 모든 업무 공유 기술, 시장, 구조 및 지능, 모든 발명 을 다국적 창신 응용 했 다.GE 는 업계의 수요를 이해하고, 공업언어는 글로벌 인재, 서비스, 과학 기술, 규모, 고객을 위해 비범한 업적을 창조한다.</p><p><br/></p><p><br/></p>','GROUPPROFILE','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('153','123','발전 과정','','','0','','','','','','DEVELOPMEN-THISTORY','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('154','123','문화 활동','','','0','','','','','','CULTURAL-ACTIVITY','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('155','123','명예 자질','','','0','','','','','','rong-yu-zi-zhi','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('156','123','지도자의 관심','','','0','','','','','<p>리더쉽 내용 …</p>','ling-dao-guan-huai','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('157','0','쇼핑몰 내용 페이지 5 공약','','','0','','','','','','shang-cheng-nei-rong-ye-5-cheng-nuo','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','4','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('88','0','私たちについて','','','10','/html/upload/images/201907/guanyu.jpg','','','','<p>企業は通常、収益を目的として、各種生産要素（土地、労働力、資本、技術と企業家才能など）を用いて、商品やサービスを市場に提供し、自主経営、損益、独立採算を行う法人またはその他の社会経済組織を指す。</p><p>商品経済の範疇では、組織単位の多様なモデルの一つとして、一定の組織規則に従って、有機的に構成された経済実体は、一般的に営利を目的として、投資者、取引先、従業員、社会大衆の利益を最大化することを使命として、製品またはサービスを提供することによって収入を獲得する。それは社会発展の産物で、社会分業の発展によって成長します。企業は市場経済活動の主要参加者であり、社会主義経済体制の下で、各種企業が共存して共同で社会主義市場経済を構成するミクロの基礎である。企業には三つの基本的な組織形態があります。独資企業、パートナー企業、会社制企業は現代企業の中で最も主要な典型的な組織形態です。</p><p>現代経済学の理論では、企業は本質的に「資源配置のメカニズム」であり、社会全体の経済資源の最適化配置を実現し、社会全体の「取引コスト」を低減できると考えています。</p><p><br/></p>','ABOUT-US','archive/list_about.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('89','0','産業に触れる','','','6','','','','','','Industryinvolved','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('91','89','エネルギー管理','','','0','/html/upload/images/201907/15590035782297.png','','','','<p>エネルギーはエネルギーを供給できる資源です。ここのエネルギーは通常熱エネルギー、電気エネルギー、光エネルギー、機械エネルギー、化学エネルギーなどを指します。エネルギーは源によって三つの種類に分けられます。（1）太陽からのエネルギーです。直接太陽からのエネルギー（太陽光熱放射エネルギーなど）と間接的に太陽からのエネルギー（例えば石炭、石油、天然ガス、石油頁岩などの可燃鉱物や薪材などのバイオマスエネルギー、水エネルギー、風力など）を含みます。（2）地球そのものからのエネルギー。一つは地球内部に埋蔵されている地熱エネルギーで、地下の湯、地下の蒸気、ドライ熱岩体のようです。もう一つは地殻内のウラン、トリウムなどの核燃料が埋蔵している原子力です。（3）月や太陽などの天体が地球の引力に対して発生するエネルギー、例えば潮汐エネルギー。&nbsp;</p><p>「エネルギー」という用語は、昔は議論が少なかったが、まさに2回の石油危機が話題になった。世界経済が急速に発展している今日、国際エネルギー安全はすでに国の高さまで上昇しています。各国はエネルギー供給の安全を核心とするエネルギー政策を制定しました。</p><p>一体何が「エネルギー」なのか？エネルギーの定義については、約20種類があります。例えば、「エネルギーは熱、光、動力などのエネルギーを得る資源である」と言います。「大英百科事典」では、「エネルギーはすべての燃料、流水、太陽光と風を含む用語であり、人類は適切な転換手段を使って自分のために必要なエネルギーを提供できる」と言います。「各種生産活動において、熱エネルギー、機械エネルギー、光エネルギー、電気エネルギーなどを利用して功を行い、これらのエネルギー源である自然界の各種キャリアを利用して、エネルギーと称することができる」と述べた。力などのいずれかの形式のエネルギーを持つエネルギー体資源。エネルギーは多様な形をしており、相互に変換できるエネルギーの源であることが分かります。正確で簡単に言えば、エネルギーは自然界の中で人類にある形式のエネルギーを提供できる物質資源です。</p><p>エネルギーはエネルギー資源やエネルギー資源とも呼ばれる。熱、電気エネルギー、光エネルギー、機械エネルギーなど、様々なエネルギーを発生させることができる物質の総称です。石炭、原油、天然ガス、炭層ガス、水エネルギー、原子力、風力エネルギー、太陽エネルギー、地熱エネルギー、バイオマスエネルギーなどの一次エネルギーと電力、熱力、精製油などの二次エネルギー源を含む、直接的に入手または加工、変換することができる各種資源を指す。ソース</p><p>エネルギー源（Energy Source ）エネルギー資源やエネルギー資源とも言われ、国民経済の重要な物質基盤であり、未来の国の運命はエネルギーのコントロールにかかっています。エネルギーの開発と有効利用の程度及び一人当たりの消費量は生産技術と生活水準の重要な標識である。</p><p><br/></p><p><br/></p>','Energy','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('92','89','バッテリー生産','','','0','/html/upload/images/201907/15590037014790.png','','','','<p>電池（Battery）とは、電解質溶液と金属電極を盛って電流を発生させるカップ、溝または他の容器または複合容器の部分空間を指し、化学エネルギーを電気エネルギーに変換する装置です。正極、負極の分を持つ。科学技術の進歩に伴って、電池は一般的に電気エネルギーを発生する小型装置を指す。太陽電池のようです。電池の性能パラメータは主に電気ポテンシャル、容量、比エネルギー、抵抗があります。電池をエネルギー源として利用すると、安定した電圧、安定した電流、長時間安定した電力供給が得られ、外部の影響を受けて小さい電流が流れます。また、電池の構造が簡単で、携帯に便利です。充放電操作が簡単で、外部の気候や温度の影響を受けず、性能が安定しています。各方面にわたって大きな役割を果たす。</p><p>化学電池では、化学エネルギーが直接に電気エネルギーに変換されるのは、電池の内部で自発的に酸化、還元などの化学反応が行われた結果で、この反応はそれぞれ2つの電極で行われます。負極活性物質は、電位が低く、電解質に安定した還元剤からなります。亜鉛、カドミウム、鉛などの活発な金属や水素や炭化水素などです。正極活性物質は電位が比較的良く、電解質中で安定した酸化剤からなり、例えば二酸化マンガン、二酸化鉛、酸化ニッケルなどの金属酸化物、酸素や空気、ハロゲン及び塩類、酸素酸及び塩類などが含まれる。電解質は、酸、アルカリ、塩などの良好なイオン伝導性を持つ水溶液で、有機または無機非水溶液、溶融塩または固体電解質などがあります。外回路が切り離されると、両極の間には電位差（開回路電圧）がありますが、電流がなく、電池に記憶されている化学エネルギーは電気エネルギーに変換されません。外部回路が閉じていると、2電極の電位差の作用で外部回路に電流が流れる。同時に電池の内部では、電解質に自由電子が存在しないため、電荷の伝達には必ず二極活性物質と電解質界面の酸化あるいは還元反応、及び反応物と反応産物の物質移動が伴う。電解質における電荷の移動もイオンの移動によって行われる。したがって，電池内部の正常な電荷輸送と物質伝達過程は，通常の出力電力を保証する必要条件である。充電する時、電池の内部の伝電と物質移動の過程の方向はちょうど放電と反対です。電極反応は可逆的でなければいけません。したがって、電極反応が可逆的であることは、バッテリを構成するための必要条件である。Gはギブス反応の自由エネルギー増分（焦点）であり、Fはファラデー定数=96500ライブラリ=26.8安・時間であり、nは電池反応の当量である。これは電池の電気ポテンシャルと電池の反応の基本的な熱力学関係式であり、電池のエネルギー変換効率を計算する基本的な熱力学方程式でもある。実際，電極に電流が流れると，電極電位は熱力学的に平衡した電極電位から逸脱し，この現象を分極と呼ぶ。電流密度（単位電極面積を通る電流）が大きいほど、分極がひどいです。分極現象は電池のエネルギー損失を引き起こす重要な原因の一つである。</p><p>分極の原因は三つあります。</p><p>①電池の各部分の抵抗による分極をオーム分極といいます。</p><p>②電極－電解質界面層における電荷輸送過程のヒステリシスによる分極を活性化分極と呼ぶ。</p><p>③電極－電解質界面層の物質移動の遅れによる分極を濃差分極と呼ぶ。分極を減少させる方法は、電極の反応面積を増加させ、電流密度を減少させ、反応温度を高め、電極表面の触媒活性を改善することである。</p><p><br/></p>','Battery','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('94','89','ソリューション','','','4000','','','','','','solution','archive/list_down.html','archive/list_down.html','archive/show_down.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('76','89','化学工業業界','','','0','/html/upload/images/201907/15590039175444.png','','','','<p>化学工業は「化学プロセス」、「化学工業」、「化学工程」などの略称です。化学方法を用いて物質の組成、構造または合成の新しい物質を変える技術は、化学生産技術、すなわち化学技術に属し、所得製品は化学品または化学工業製品と呼ばれています。最初は、このような製品を生産していたのは手作り工房で、その後は工場になり、特定の生産業界すなわち化学工業が形成されました。化学工学は化学工業製品の生産過程の共通性の法則を研究する一つの科学である。人類と化学工業の関係は非常に密接で、一部の化学工業製品は人類の発展の歴史の中で、画期的な重要な役割を果たしています。</p><p>人類は生存と発展を求めて、絶えず大自然と闘って、だんだん周囲の世界に対する認識を深めて、それによって自然を征服して、世界を改造する本领を掌握しました。長い歴史の実践を経て、人類はますます自然条件を利用して、しかも自分のために豊富な物質世界を創造しました。</p><p>古代の人々の生活は直接利用や必要なものを取り出すことにより多くなった。これらの物質の固有の性能が人々の需要を満足できないため、各種の加工技術が生まれ、天然物質を多種の性能を持つ新物質に転換し、工業生産の規模で徐々に実現してきました。最初は、このような製品を生産していたのは手作り工房で、その後は工場になり、特定の生産部門、すなわち化学工業が形成されました。生産力の発展に従って、一部の生産部門は冶金、製油、製紙、製革など、すでに独立した生産部門として化学工業から分離されました。大規模な石油精製工業と石油化学工業が盛んに発展した後、化学、物理学、数学を基礎として他の工程技術を結合し、化学工業の生産過程の共通の法則を研究し、規模拡大と大規模化の中で現れた多くの工事技術問題を解決する学科--化学工事はさらに完備した。それは化学工業の生産を新しいレベルに引き上げて、経験或いは半経験状態から理論と予測の新しい段階（化学工程の発展史を見てください）に入って、化学工業にもっと大規模な生産の創造能力を持たせて、人類のために大量の物質の財産を増加して、人類社会の発展の過程を加速しました。</p><p>現代中国語では、化学工業、化学工学、化学技術を総称して化学工業と呼んでいますが、それらは異なる歴史時期に現れています。人々の頭の中で、「化学工業」という言葉は、習慣の上ですでに一つの総合的な知識の種類と事業の代名詞になっています。それは国民経済と工事技術上の重要な意義を持っています。以下は簡単に人類社会生活の各方面から、化学工業の多彩な内容と重要な貢献を説明します。</p><p>データから見ると、2013年1～4月の原油加工量は15868.3万トンで、前年同期比3.2%増加した。エチレンの生産量は529.8万トンで、同3.0%増加した。合成樹脂の生産量は181.8万トンで、同9.8%増加した。合成繊維単体の生産量は736.8万トンで、前年同期比1.4%増加した。合成ゴムの生産量は132.1万トンで、同じ7.4%増加しました。エチレン生産量は負の成長を反転させたが，増加速度は低く，三大合成も低速で成長した。</p><p>石化の主要なサブ業界の収益状況はほぼ小幅な反発を示しています。このうち、有機化学原料製造業は売上高4322.18億元を実現し、前年同期比15.2%増の111.00億元の利益総額を実現し、同2.2%増の合成樹脂製造業は主要業務収入2427.01億元を実現し、同13.5%増の80.31億元の利益を実現し、同11.9%増の合成ゴム製造業。主要業務収入は388.33億元で、前年同期比24.9%増加し、利益総額は21.7億元で、同17.2%増加した。合成繊維単体（重合）製造業は主要業務収入は946.06億元で、同4.4%減少し、利益総額は6.20億元である。</p><p>主要サブ業界別にみると、合成繊維単体（重合）製造業は綿花の価格が大幅に下がるなどの影響で、業界で赤字が発生している。有機化学原料製造業と合成樹脂製造業の二つの最大のサブ業界の収益水準も反発して力がないです。これは経済の基本面が寒いということを反映しています。</p><p>2013年の状況から見ると、原油価格は100ドル/バレルで安定していますが、石油化学産業チェーン全体にとっては有利です。しかし、実体経済の持続的な低迷による需要の下落傾向は業界全体に衝撃を与えます。固定資産投資の増加速度は低下し、組立稼働率は低下し、業界の経済活性度は低下し、化学工業の低下周期は長くなり、底部が明確にできなくなります。</p><p><br/></p>','Chemical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('95','94','業界ソリューション','同時に、迅速かつ効果的な実行を確保することができます。','','0','/html/upload/images/201907/15590055325938.jpg','','','','<p>ビデオ会議サービスアウトソーシング業務は、中国電信の電気通信技術と運営管理における専門的な優位により、既存のビデオプラットフォームの資源に基づいて、他の電気通信製品を統合し、お客様にビデオ会議端末の設備メンテナンス、システムネットワークの故障処理、ビデオ会議システムの運行維持とビデオ会議の保証を提供します。障害者サービスなど多くのアウトソーシングサービスを提供し、企業の特定のニーズに応じて、ビデオアウトソーシングソリューション及びシステムインテグレーションサービスを提供します。</p><p><br/></p><p>1. ビデオターミナルのレンタルまたは統合</p><p>2. ビデオ会議システムの運行とメンテナンス</p><p>3. ビデオ会議端末のインストールとデバッグを追加します。</p><p>4. 视频会议系统的运行维护</p><p>5. 视讯会议系统的故障排除；视讯会议系统的运行情况分析；视讯会议系统的网络及性能优化建议；建立完备的视讯会议故障管理档案。</p><p>6. ビデオ会議保障とは、ユーザのビデオ会議システムで開催される様々な等級、異なるカバー範囲のビデオ会議に対して、中国電信はお客様のニーズを満たす様々なレベルの会議保障サービスを提供します。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\"><br/></span></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">总部与分支机构进行视频会议沟通</span></p><p>1. コストの節約：企業の自己構築ビデオ会議と比べて、中国電信ビデオ会議のアウトソーシング業務を利用して、ユーザーは自分のビデオ会議ネットワークを新設、維持する必要がなく、特にMCU、GKなどの設備投資を節約して、ネットワークの伸びたところにビデオ端末を設置するだけで、ビデオ会議を開催することができます。</p><p>2. カバー範囲が広い：お客様端末は全国に展開できます。また、海外でも国内、国際ニュース会議を開催できます。お客様が自分で作ったビデオ会議専用ネットワークにアクセスすることによって、お客様と同じ中国電信の「新視通」プラットフォームに接続するお客様との間で自由に交流し、企業ビデオ会議の範囲を拡大します。</p><p>3. 様々なタイプの端末をサポートします。専用の会議室型端末、ボス型端末、テレビ電話、PCベースのソフトウェアデスクトップ端末を含め、H.320とH.323の2つのタイプが対応しています。</p><p>4. ワンストップサービスを提供します。コンサルティング、販売前、セッティング、メンテナンス、重点会議保障などの全体サービスを提供し、中国電信現地のオペレータを十分利用してサービスを提供し、サービスコストを低減し、応答速度を高めます。</p><p><br/></p>','Industry','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('96','94','技術解決策','提出した一つの全体問題を解決する方案','','0','/html/upload/images/201907/15590056384652.jpg','','','','<p>解決案Solutionは、すでにいくつかの具体化されている問題、不足、欠陥、需要などに対して提出された全体的な問題を解決する方案（提案書、計画表）であり、同時に迅速かつ効果的な実行を確保することができる。問題を解決する方法を指す。</p><p>従来の観点から言えば、ソリューションはソリューションの生成段階のみを含み、具体的な実行段階は別に分かれています。</p><p>しかし，統一流れから，解は直接的に実行レベルのサービスであり，それらは単純な線形関係と単一インターフェースではない。したがって、ある程度から言えば、ソリューションと実行は相互作用の影響であり、実行の効果は適時にフィードバックし、元の方案に修正的な参考と提案を行うべきである。</p><p>このようなインタラクションは多重性であり，反復性である。一つは絶えず自己改善できる解決策で、本当に状況を改善し、より高い効率で実行させることができます。</p><p>逆に、いくつかの複雑な現実的な状況については、問題はより多くの要素に関連しており、問題の間にも複雑な関連がある。完璧な解決策を期待すれば、全ての問題を一度に解決します。提案すれば枕を高くして、執行層の実際的な進展を見ています。これは実際的にはあまり現実的ではないです。適応できない効果もあります。</p><p>市場経済分野、特にお客様向けのケースでは、実行基準を提供したり、実行中のソリューションに自ら参加したりすることができます。簡単に言えば、完全な提案書や計画書を手にするより、問題解決のためのフルコースのサービスをお客様が望んでいます。</p><p>解決案は客観的、理性的に分析し、できるだけ問題の本質を把握し、各細部要素を把握しなければならない。問題に直面する切迫した感情や感性を解決策に導入するべきではない。</p><p>実際の操作では、ソリューションは創意的な要素が少なく、既存の成功事例から探すことが多い。</p><p>一方、問題をよく分析し、成功事例を客観的に分析すれば、それ自体がより良い解決策を生み出す基礎にもなります。</p><p>完璧なものはなく、問題を解決する恒久的な解決策です。設計者と方策決定者は解決策の限界、優勢と劣勢及び変化条件における不確定性をはっきりと認識しなければならない。</p><p><br/></p>','Technical','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('97','0','連絡します','','','4','','','','','<p>もしあなたが自由で面白い仕事をしたいなら、インタフェースデザインに情熱と動力を持っているなら、私たちに連絡してください。ここでは志を同じくする若者たちを見つけて、理想を実践するために努力します。</p><p>私達のチームは自分の理想のために奮闘しています。私達は互いに補完的で、分業的に明確で、目標が一致しています。私達は良い理念と優秀なチームが必ず遠大な理想を成し遂げると信じています。<br/>&nbsp;</p><p>連絡先：<br/>售前咨询客服QQ-01：<br/>発売前にカスタマーサービスのQQ-02に問い合わせてください。<br/>お客様の販売前のホットライン：<br/>顧客アフターサービスホットライン：<br/>コールボックス:</p><p><br/></p>','Contact-us','archive/list_ditu.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('98','0','精選品','','','8','','','','','','Products','archive/list_loop_products.html','archive/list_products.html','archive/show_products.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','1','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('99','98','インテリジェント製品','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Intelligent','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','updatedate DESC','1','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('100','98','家電製品','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','Appliances','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('101','98','スマートウェア','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','Smart-wearer','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('102','98','健康な子供','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','Children','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','1','0','0','','1','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('103','0','グループ産業','','','9','','','','','','Group-industry','archive/list_text_pic.html','archive/list_text_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','updatedate DESC','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('104','103','倉庫物流','','','0','','','','','','Storage','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('105','103','車両輸送','','','0','','','','','','vehicle-transport','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('106','103','総合運送','','','0','','','','','','Comprehensive','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('107','0','職の募集','','','3','','','','','','Job-recruitment','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('108','0','ニュース','','','7','','','','','','News','archive/list.html','archive/list_text_pic.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','updatedate DESC','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('109','108','企業ニュース','','','0','','','','','','Industry-news','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('110','108','業界ニュース','','','0','','','','','','Corporate-news','archive/list_text.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('111','0','私たちの取引先','','','2','','','','','','Our-customers','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('112','111','従業員の発展','','','0','/html/upload/images/201907/15590305077365.jpg','','','','<p>従業員の発展内容。</p><p><br/></p>','yuan-gong-fa-zhan','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('113','111','就職の機会','','','0','/html/upload/images/201907/15590305335789.jpg','','','','<p>就職機会の内容。</p><p><br/></p>','jiu-ye-ji-hui','archive/list_job.html','archive/list_job.html','archive/show_job.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('114','111','気風のある人物','','','0','/html/upload/images/201907/15590305596900.jpg','','','','<p>ファッションキャラクターの内容。</p>','feng-shang-ren-wu','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('115','0','人的資源','私たちは世界とあなたの事業の明るい未来を見ました。世界はますます複雑な挑戦の場所であり、これらの課題を解決することを期待しています。このような挑戦の遠見と雄心がありますか？','','5','','','','','<p>私たちは世界とあなたの事業の明るい未来を見ました。世界はますます複雑な挑戦の場所であり、これらの課題を解決することを期待しています。このような挑戦の遠見と雄心がありますか？</p>','HUMAN-RESOURCES','archive/list_HR.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('116','88','代表取締役挨拶','グループ会長：','','0','/html/upload/images/201907/15590892414438.jpg','','','','<p>革新的解決策を構築して、今の環境挑戦を解決し、それによって経済成長を牽引します。「健康創意」はより多くの人を健康にすることを約束します。私たちは想像力豊かな理念と成熟した解決策を通じて、より健康な世界を創造します。</p>','CHAIRMANS-SPEECH','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('117','88','グループ概要','','','0','/html/upload/images/201907/15590892812276.jpg','','','','<p>会社は全世界のデジタル工業会社で、ソフトウェアによって定義された機械を創造し、相互接続、応答と予測の知恵を集め、伝統工業の変革に力を尽くしています。全世界の知識交換システムはすべての業務に技術、市場、構造と知力を共有させ、各発明はクロスセクションの革新応用を推進する。GEは業界の必要を理解して、工業言語を述べて、全世界の人材、サービス、科学技術と規模で、取引先のために非凡な業績を創造します。</p><p><br/></p><p><br/></p>','GROUPPROFILE','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('118','88','発展の歴史','','','0','','','','','','DEVELOPMEN-THISTORY','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('119','88','文化活動','','','0','','','','','','CULTURAL-ACTIVITY','archive/list_pic.html','archive/list_pic.html','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('120','88','名誉の資質','','','0','','','','','','rong-yu-zi-zhi','archive/list_pic.html','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('121','88','指導者の配慮','','','0','','','','','<p>指導者の配慮内容。</p>','ling-dao-guan-huai','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('122','0','ショッピングモールの内容ページ5承諾','','','0','','','','','','shang-cheng-nei-rong-ye-5-cheng-nuo','0','0','0','0','0','0','0','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','0','','0','0','0','','0','3','0.00','0.00');-- 

INSERT INTO `cmseasy_b_special` VALUES('1','促销专题一','','1','','/html/upload/images/201907/15590979873694.jpg','让您的产品，在互联网上普通盖地！想让更多的客户找到您吗？易通企业网站系统独创企业推广链联盟系统。通过推广链接，让客户和生意自己找上门！为您的企业营销助力，伴您轻松成功！易通企业网站系统让您客源不断、生意兴隆！','special/show_pic.html','1563520169','0','2','0','0','0','1','1','special-1','');-- 
INSERT INTO `cmseasy_b_special` VALUES('2','促销专题二','','','','/html/upload/images/201907/15591099453652.jpg','','','1562133675','0','','0','0','0','1','1','special-2','');-- 
INSERT INTO `cmseasy_b_special` VALUES('3','促销专题三','','1','','/html/upload/images/201907/15591099593550.jpg','3','','1563518777','0','2','0','0','0','1','1','special-3','');-- 
INSERT INTO `cmseasy_b_special` VALUES('4','promotion Topic I','','1','','/html/upload/images/201907/15590979873694.jpg','Let your products cover the Internet in general! Want more customers to find you? Yitong Enterprise Website System Innovative Enterprise Promotion Chain Alliance System. Through promotion links, let customers and businesses find their doors! Help your business marketing, with your easy success! Easy Tong Enterprise Website System allows you to keep a steady flow of customers and business prosperity!','special/show_pic.html','1563520169','0','2','0','0','0','1','2','special-1','');-- 
INSERT INTO `cmseasy_b_special` VALUES('5','promotion Theme II','','','','/html/upload/images/201907/15591099453652.jpg','','','1562133675','0','','0','0','0','1','2','special-2','');-- 
INSERT INTO `cmseasy_b_special` VALUES('6','promotion Theme III','','1','','/html/upload/images/201907/15591099593550.jpg','3','','1563518777','0','2','0','0','0','1','2','special-3','');-- 
INSERT INTO `cmseasy_b_special` VALUES('10','판촉특별보도 1','','1','','/html/upload/images/201907/15590979873694.jpg','당신의 제품이 인터넷에서 보통 덮이게 하십시오!더 많은 고객님께서 찾으시겠습니까?이퉁기업 웹사이트 시스템 독창적인 기업 체인 연맹 시스템을 보급하다.링크를 일반화하여 고객과 거래자가 스스로 찾아오도록 한다!당신의 기업 마케팅 조력, 당신은 쉽게 성공!이퉁기업 웹사이트 시스템으로 손님들이 끊임없이 와서 사업이 번창하게 합니다!','special/show_pic.html','1563520169','0','2','0','0','0','1','4','special-1','');-- 
INSERT INTO `cmseasy_b_special` VALUES('11','판촉특별보도 2','','','','/html/upload/images/201907/15591099453652.jpg','','','1562133675','0','','0','0','0','1','4','special-2','');-- 
INSERT INTO `cmseasy_b_special` VALUES('12','판촉특별보도 3','','1','','/html/upload/images/201907/15591099593550.jpg','3','','1563518777','0','2','0','0','0','1','4','special-3','');-- 
INSERT INTO `cmseasy_b_special` VALUES('7','プロモーションのテーマ','','1','','/html/upload/images/201907/15590979873694.jpg','あなたの製品をインターネットで普通にカバーしてください。もっと多くのお客さんに見つけてもらいたいですか？易通企業ウェブサイトシステムの独創的な企業普及チェーン連盟システム。リンクの普及を通じて、お客様とビジネスを自分で訪問してください。あなたの企業のマーケティングに協力して、あなたと一緒に気楽に成功します。易通企業のウェブサイトシステムはお客様に絶えず、商売繁盛させます。','special/show_pic.html','1563520169','0','2','0','0','0','1','3','special-1','');-- 
INSERT INTO `cmseasy_b_special` VALUES('8','プロモーションテーマ2','','','','/html/upload/images/201907/15591099453652.jpg','','','1562133675','0','','0','0','0','1','3','special-2','');-- 
INSERT INTO `cmseasy_b_special` VALUES('9','プロモーションテーマ3','','1','','/html/upload/images/201907/15591099593550.jpg','3','','1563518777','0','2','0','0','0','1','3','special-3','');-- 










INSERT INTO `cmseasy_expresscompany` VALUES('1','SF','顺丰速运','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('2','HTKY','百世快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('3','ZTO','中通快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('4','STO','申通快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('5','YTO','圆通速递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('6','YD','韵达速递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('7','YZPY','邮政快递包裹','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('8','EMS','EMS','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('9','HHTT','天天快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('10','JD','京东快递','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('11','UC','优速快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('12','DBL','德邦快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('13','ZJS','宅急送','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('14','TNT','TNT快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('15','UPS','UPS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('16','DHL','DHL','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('17','FEDEX','FEDEX联邦(国内件）','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('18','FEDEX_GJ','FEDEX联邦(国际件）','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('19','AJ','安捷快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('20','ALKJWL','阿里跨境电商物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('21','AX','安迅物流','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('22','AYUS','安邮美国','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('23','AMAZON','亚马逊物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('24','AOMENYZ','澳门邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('25','ANE','安能物流','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('26','ADD','澳多多','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('27','AYCA','澳邮专线','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('28','AXD','安鲜达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('29','ANEKY','安能快运','0','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('30','BDT','八达通  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('31','BETWL','百腾物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('32','BJXKY','北极星快运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('33','BNTWL','奔腾物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('34','BFDF','百福东方','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('35','BHGJ','贝海国际 ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('36','BFAY','八方安运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('37','BTWL','百世快运','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('38','CFWL','春风物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('39','CHTWL','诚通物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('40','CXHY','传喜物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('41','CITY100','城市100','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('42','CJKD','城际快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('43','CNPEX','CNPEX中邮快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('44','COE','COE东方快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('45','CSCY','长沙创一','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('46','CDSTKY','成都善途速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('47','CTG','联合运通','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('48','CRAZY','疯狂快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('49','CBO','CBO钏博物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('50','CND','承诺达','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('51','DSWL','D速物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('52','DLG ','到了港','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('53','DTWL','大田物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('54','DJKJWL','东骏快捷物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('55','DEKUN','德坤','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('56','DBLKY','德邦快运','0','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('57','DML','大马鹿','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('58','ETK','E特快','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('59','EWE','EWE','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('60','KFW','快服务','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('61','FKD','飞康达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('62','FTD','富腾达  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('63','FYKD','凡宇货的','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('64','FASTGO','速派快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('65','FT','丰通快运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('66','GD','冠达   ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('67','GDEMS','广东邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('68','GSD','共速达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('69','GTONG','广通       ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('70','GAI','迦递快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('71','GKSD','港快速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('72','GTSD','高铁速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('73','HFWL','汇丰物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('74','HGLL','黑狗冷链','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('75','HLWL','恒路物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('76','HOAU','天地华宇','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('77','HOTSCM','鸿桥供应链','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('78','HPTEX','海派通物流公司','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('79','hq568','华强物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('80','HQSY','环球速运  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('81','HXLWL','华夏龙物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('82','HXWL','豪翔物流 ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('83','HFHW','合肥汇文','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('84','HLONGWL','辉隆物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('85','HQKD','华企快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('86','HRWL','韩润物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('87','HTKD','青岛恒通快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('88','HYH','货运皇物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('89','HYLSD','好来运快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('90','HJWL','皇家物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('91','JAD','捷安达  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('92','JGSD','京广速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('93','JIUYE','九曳供应链','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('94','JXD','急先达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('95','JYKD','晋越快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('96','JYM','加运美','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('97','JGWL','景光物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('98','JYWL','佳怡物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('99','JDKY','京东快运','0','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('100','CNEX','佳吉快运','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('101','KYSY','跨越速运','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('102','KSDWL','快速递物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('103','KBSY','快8速运','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('104','LB','龙邦快递','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('105','LJSKD','立即送','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('106','LHT','联昊通速递','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('107','MB','民邦快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('108','MHKD','民航快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('109','MK','美快    ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('110','MDM','门对门快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('111','MRDY','迈隆递运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('112','MLWL','明亮物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('113','NF','南方','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('114','NEDA','能达速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('115','PADTF','平安达腾飞快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('116','PANEX','泛捷快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('117','PJ','品骏快递','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('118','PCA','PCA Express','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('119','QCKD','全晨快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('120','QRT','全日通快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('121','QUICK','快客快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('122','QXT','全信通','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('123','RQ','荣庆物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('124','QYZY','七曜中邮','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('125','RFD','如风达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('126','RRS','日日顺物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('127','RFEX','瑞丰速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('128','SAD','赛澳递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('129','SNWL','苏宁物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('130','SAWL','圣安物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('131','SBWL','晟邦物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('132','SDWL','上大物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('133','SFWL','盛丰物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('134','ST','速通物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('135','STWL','速腾快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('136','SUBIDA','速必达物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('137','SDEZ','速递e站','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('138','SCZPDS','速呈宅配','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('139','SURE','速尔快递','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('140','SS','闪送','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('141','STKD','盛通快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('142','SX','顺心捷达','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('143','TAIWANYZ','台湾邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('144','TSSTO','唐山申通','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('145','TJS','特急送','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('146','TYWL','通用物流','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('147','TLWL','腾林物流','0','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('148','UAPEX','全一快递','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('149','ULUCKEX','优联吉运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('150','UEQ','UEQ Express','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('151','WJK','万家康  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('152','WJWL','万家物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('153','WHTZX','武汉同舟行','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('154','WPE','维普恩','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('155','WXWL','万象物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('156','WTP','微特派','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('157','WTWL','温通物流','0','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('158','XCWL','迅驰物流  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('159','XFEX','信丰物流','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('160','XYT','希优特','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('161','XJ','新杰物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('162','YADEX','源安达快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('163','YCWL','远成物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('164','YCSY','远成快运','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('165','YDH','义达国际物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('166','YDT','易达通  ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('167','YFHEX','原飞航物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('168','YFSD','亚风快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('169','YTKD','运通快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('170','YXKD','亿翔快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('171','YUNDX','运东西网','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('172','YMDD','壹米滴答','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('173','YZBK','邮政国内标快','1','1','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('174','YZTSY','一站通速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('175','YFSUYUN','驭丰速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('176','YSDF','余氏东风','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('177','YF','耀飞快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('178','YDKY','韵达快运','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('179','YL','云路','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('180','YZT','一智通','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('181','ZENY','增益快递','1','0','1');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('182','ZHQKD','汇强快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('183','ZTE','众通快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('184','SJ','郑州速捷','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('185','ZTOKY','中通快运','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('186','ZYKD','中邮快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('187','WM','中粮我买网','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('188','ZMKM','芝麻开门','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('189','ZHWL','中骅物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('190','ZTWL','中铁物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('191','AAE','AAE全球专递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('192','ACS','ACS雅仕快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('193','ADP','ADP Express Tracking','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('194','ANGUILAYOU','安圭拉邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('195','APAC','APAC','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('196','ARAMEX','Aramex','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('197','AT','奥地利邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('198','AUSTRALIA','Australia Post Tracking','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('199','BEL','比利时邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('200','BHT','BHT快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('201','BILUYOUZHE','秘鲁邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('202','BR','巴西邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('203','BUDANYOUZH','不丹邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('204','CDEK','CDEK','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('205','CG','程光物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('206','CA','加拿大邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('207','DBYWL','递必易国际物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('208','DDWL','大道物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('209','DGYKD','德国云快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('210','DLGJ','到乐国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('211','DHL_DE','DHL德国','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('212','DHL_EN','DHL(英文版)','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('213','DHL_GLB','DHL全球','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('214','DHLGM','DHL Global Mail','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('215','DK','丹麦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('216','DPD','DPD','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('217','DPEX','DPEX','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('218','D4PX','递四方速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('219','EMSGJ','EMS国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('220','EKM','易客满','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('221','EPS','EPS (联众国际快运)','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('222','ESHIPPER','EShipper','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('223','FCWL','丰程物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('224','FX','法翔速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('225','FQ','FQ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('226','FLYZ','芬兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('227','FZGJ','方舟国际速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('228','GJEYB','国际e邮宝','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('229','GJYZ','国际邮政包裹','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('230','GE2D','GE2D','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('231','GT','冠泰','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('232','GLS','GLS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('233','IOZYZ','欧洲专线(邮政)','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('234','IADLYYZ','澳大利亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('235','IAEBNYYZ','阿尔巴尼亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('236','IAEJLYYZ','阿尔及利亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('237','IAFHYZ','阿富汗邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('238','IAGLYZ','安哥拉邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('239','IAJYZ','埃及邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('240','IALBYZ','阿鲁巴邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('241','IALYYZ','阿联酋邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('242','IASBJYZ','阿塞拜疆邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('243','IBCWNYZ','博茨瓦纳邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('244','IBDLGYZ','波多黎各邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('245','IBDYZ','冰岛邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('246','IBELSYZ','白俄罗斯邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('247','IBHYZ','波黑邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('248','IBJLYYZ','保加利亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('249','IBJSTYZ','巴基斯坦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('250','IBLNYZ','黎巴嫩邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('251','IBOLYZ','波兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('252','IBTD','宝通达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('253','IBYB','贝邮宝','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('254','ICKY','出口易','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('255','IDGYZ','德国邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('256','IWDMLYZ','危地马拉邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('257','IWGDYZ','乌干达邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('258','IWKLEMS','乌克兰EMS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('259','IWKLYZ','乌克兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('260','IWLGYZ','乌拉圭邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('261','ILKKD','林克快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('262','IWLYZ','文莱邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('263','IXGLDNYYZ','新喀里多尼亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('264','IE','爱尔兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('265','IXPWL','夏浦物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('266','IYDYZ','印度邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('267','IXPSJ','夏浦世纪','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('268','IEGDEYZ','厄瓜多尔邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('269','IELSYZ','俄罗斯邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('270','IFTWL','飞特物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('271','IGDLPDYZ','瓜德罗普岛邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('272','IGSDLJYZ','哥斯达黎加邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('273','IHGYZ','韩国邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('274','IHHWL','华翰物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('275','IHLY','互联易','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('276','IHSKSTYZ','哈萨克斯坦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('277','IHSYZ','黑山邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('278','IJBBWYZ','津巴布韦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('279','IJEJSSTYZ','吉尔吉斯斯坦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('280','IJKYZ','捷克邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('281','IJNYZ','加纳邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('282','IJPZYZ','柬埔寨邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('283','IKNDYYZ','克罗地亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('284','IKNYYZ','肯尼亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('285','IKTDWEMS','科特迪瓦EMS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('286','ILMNYYZ','罗马尼亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('287','IMEDWYZ','摩尔多瓦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('288','IMETYZ','马耳他邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('289','INRLYYZ','尼日利亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('290','ISEWYYZ','塞尔维亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('291','ISPLSYZ','塞浦路斯邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('292','IWZBKSTYZ','乌兹别克斯坦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('293','IXBYYZ','西班牙邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('294','IXJPEMS','新加坡EMS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('295','IXLYZ','希腊邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('296','IXXLYZ','新西兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('297','IYDLYZ','意大利邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('298','IYGYZ','英国邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('299','IYMNYYZ','亚美尼亚邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('300','IYMYZ','也门邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('301','IZLYZ','智利邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('302','JP','日本邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('303','JFGJ','今枫国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('304','JGZY','极光转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('305','JXYKD','吉祥邮转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('306','JLDT','嘉里国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('307','JPKD','绝配国际速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('308','SYJHE','佳惠尔','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('309','LYT','联运通','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('310','LHKDS','联合快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('311','SHLDHY','林道国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('312','NL','荷兰邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('313','NSF','新顺丰','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('314','ONTRAC','ONTRAC','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('315','OCS','OCS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('316','QQYZ','全球邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('317','POSTEIBE','POSTEIBE','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('318','PAPA','啪啪供应链','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('319','QYHY','秦远海运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('320','VENUCIA','启辰国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('321','RDSE','瑞典邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('322','SKYPOST','SKYPOST','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('323','SWCH','瑞士邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('324','SDSY','首达速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('325','SK','穗空物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('326','STONG','首通快运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('327','STO_INTL','申通快递国际单','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('328','JYSD','上海久易国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('329','TAILAND138','泰国138','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('330','USPS','USPS美国邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('331','UPU','万国邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('332','VCTRANS','中越国际物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('333','XKGJ','星空国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('334','XD','迅达国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('335','XGYZ','香港邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('336','XLKD','喜来快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('337','XSRD','鑫世锐达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('338','XYGJ','新元国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('339','XYGJSD','ADLER雄鹰国际速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('340','XYJ','西邮寄','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('341','YAMA','日本大和运输(Yamato)','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('342','YODEL','YODEL','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('343','YHXGJSD','一号线','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('344','YUEDANYOUZ','约旦邮政','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('345','YMSY','玥玛速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('346','YYSD','鹰运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('347','YJD','易境达','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('348','YBG','洋包裹','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('349','YJ','友家速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('350','AOL','AOL（澳通）','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('351','BCWELT','BCWELT   ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('352','BN','笨鸟国际','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('353','UBONEX','优邦国际速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('354','UEX','UEX   ','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('355','YDGJ','韵达国际','1','1','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('356','ZY_AG','爱购转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('357','ZY_AOZ','爱欧洲','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('358','ZY_AUSE','澳世速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('359','ZY_AXO','AXO','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('360','ZY_BH','贝海速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('361','ZY_BEE','蜜蜂速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('362','ZY_BL','百利快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('363','ZY_BM','斑马物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('364','ZY_BT','百通物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('365','ZY_CM','策马转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('366','ZY_EFS','EFS POST','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('367','ZY_ESONG','宜送转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('368','ZY_FD','飞碟快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('369','ZY_FG','飞鸽快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('370','ZY_FX','风行快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('371','ZY_FXSD','风行速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('372','ZY_FY','飞洋快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('373','ZY_HC','皓晨快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('374','ZY_HYSD','海悦速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('375','ZY_JA','君安快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('376','ZY_JD','时代转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('377','ZY_JDKD','骏达快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('378','ZY_JDZY','骏达转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('379','ZY_JH','久禾快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('380','ZY_JHT','金海淘','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('381','ZY_LBZY','联邦转运FedRoad','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('382','ZY_LX','龙象快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('383','ZY_MGZY','美国转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('384','ZY_MST','美速通','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('385','ZY_MXZY','美西转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('386','ZY_QQEX','QQ-EX','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('387','ZY_RT','瑞天快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('388','ZY_RTSD','瑞天速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('389','ZY_SDKD','速达快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('390','ZY_SFZY','四方转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('391','ZY_ST','上腾快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('392','ZY_TJ','天际快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('393','ZY_TM','天马转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('394','ZY_TN','滕牛快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('395','ZY_TPY','太平洋快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('396','ZY_TSZ','唐三藏转运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('397','ZY_TWC','TWC转运世界','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('398','ZY_RDGJ','润东国际快线','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('399','ZY_TX','同心快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('400','ZY_TY','天翼快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('401','ZY_DGHT','德国海淘之家','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('402','ZY_DYW','德运网','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('403','ZY_WDCS','文达国际DCS','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('404','ZY_TZH','同舟快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('405','ZY_UCS','UCS合众快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('406','ZY_XC','星辰快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('407','ZY_XF','先锋快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('408','ZY_YQ','云骑快递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('409','ZY_YSSD','优晟速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('410','ZY_YTUSA','运淘美国','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('411','ZY_ZCSD','至诚速递','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('412','ZYZOOM','增速海淘','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('413','ZH','中驰物流','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('414','ZO','中欧快运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('415','ZSKY','准实快运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('416','ZWSY','中外速运','1','0','0');-- 
INSERT INTO `cmseasy_expresscompany` VALUES('417','ZZJH','郑州建华','1','0','0');-- 


INSERT INTO `cmseasy_friendlink` VALUES('1','2','0','易通免费企业CMS','0','https://www.cmseasy.cn','https://www.cmseasy.cn/images/logo.png','','0','admin','2009-11-12 13:14:37','0','1');-- 
INSERT INTO `cmseasy_friendlink` VALUES('2','1','0','CmsEasy论坛','0','http://www.cmseasy.org','','','0','admin','2009-11-12 13:15:00','2','1');-- 
INSERT INTO `cmseasy_friendlink` VALUES('3','1','0','九州易通科技有限公司','0','http://www.cmseasy.net','','','0','admin','2009-11-12 13:28:53','2','1');-- 






INSERT INTO `cmseasy_lang` VALUES('1','0','cn','中文','/html/upload/images/201907/15631496836234.gif','1','1','','1','1','1');-- 
INSERT INTO `cmseasy_lang` VALUES('2','0','en','English','/html/upload/images/201907/15631498094826.gif','1','0','','0','0','2');-- 
INSERT INTO `cmseasy_lang` VALUES('4','0','sk','한국어','/html/upload/images/201907/15631498732217.gif','1','0','','0','0','4');-- 
INSERT INTO `cmseasy_lang` VALUES('3','0','jp','日本語','/html/upload/images/201907/15631497913676.gif','1','0','','0','0','3');-- 
















INSERT INTO `cmseasy_settings` VALUES('7','','table-fieldset','a:2:{s:7:\"archive\";a:4:{s:17:\"my_shopping_color\";a:21:{s:4:\"name\";s:17:\"my_shopping_color\";s:8:\"cname_cn\";s:6:\"颜色\";s:8:\"cname_en\";s:5:\"Color\";s:8:\"cname_jp\";s:3:\"色\";s:8:\"cname_sk\";s:6:\"색깔\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:5:\"catid\";s:1:\"0\";s:9:\"isshoping\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:3:\"len\";i:0;s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:17:\"my_shopping_model\";a:21:{s:4:\"name\";s:17:\"my_shopping_model\";s:8:\"cname_cn\";s:6:\"类型\";s:8:\"cname_en\";s:5:\"Model\";s:8:\"cname_jp\";s:9:\"タイプ\";s:8:\"cname_sk\";s:6:\"유형\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:5:\"catid\";s:1:\"0\";s:9:\"isshoping\";s:1:\"1\";s:4:\"type\";s:4:\"text\";s:3:\"len\";i:0;s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:9:\"my_tagone\";a:22:{s:4:\"name\";s:9:\"my_tagone\";s:8:\"cname_cn\";s:10:\"新增 Tab\";s:8:\"cname_en\";s:7:\"Add Tab\";s:8:\"cname_jp\";s:12:\"Tabを追加\";s:8:\"cname_sk\";s:10:\"신규 Tab\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:5:\"catid\";s:1:\"0\";s:6:\"istage\";s:1:\"1\";s:4:\"type\";s:10:\"mediumtext\";s:3:\"len\";i:0;s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:15:\"my_pingjunjiage\";a:24:{s:4:\"name\";s:15:\"my_pingjunjiage\";s:8:\"cname_sk\";s:0:\"\";s:8:\"cname_jp\";s:0:\"\";s:8:\"cname_en\";s:0:\"\";s:8:\"cname_cn\";s:12:\"平均价格\";s:7:\"tips_sk\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_cn\";s:12:\"平均价格\";s:8:\"catid_sk\";s:0:\"\";s:8:\"catid_jp\";s:0:\"\";s:8:\"catid_en\";s:0:\"\";s:8:\"catid_cn\";s:3:\"158\";s:4:\"type\";s:7:\"varchar\";s:3:\"len\";s:3:\"100\";s:10:\"selecttype\";s:1:\"0\";s:9:\"select_sk\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_cn\";s:0:\"\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:6:\"istage\";s:1:\"0\";s:9:\"listorder\";s:1:\"0\";}}s:10:\"my_yingpin\";a:5:{s:8:\"my_email\";a:20:{s:4:\"name\";s:8:\"my_email\";s:8:\"cname_cn\";s:6:\"邮箱\";s:8:\"cname_en\";s:5:\"Email\";s:8:\"cname_jp\";s:21:\"メールボックス\";s:8:\"cname_sk\";s:12:\"메일박스\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:4:\"type\";s:7:\"varchar\";s:3:\"len\";s:3:\"255\";s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:9:\"my_shouji\";a:20:{s:4:\"name\";s:9:\"my_shouji\";s:8:\"cname_cn\";s:6:\"手机\";s:8:\"cname_en\";s:6:\"Mobile\";s:8:\"cname_jp\";s:12:\"携帯電話\";s:8:\"cname_sk\";s:9:\"휴대폰\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:4:\"type\";s:7:\"varchar\";s:3:\"len\";s:3:\"255\";s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:10:\"my_xingbie\";a:20:{s:4:\"name\";s:10:\"my_xingbie\";s:8:\"cname_cn\";s:6:\"性别\";s:8:\"cname_en\";s:6:\"Gender\";s:8:\"cname_jp\";s:6:\"性别\";s:8:\"cname_sk\";s:6:\"성별\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:4:\"type\";s:7:\"varchar\";s:3:\"len\";i:10;s:10:\"selecttype\";s:6:\"select\";s:9:\"select_cn\";s:13:\"(1)男
(2)女\";s:9:\"select_en\";s:17:\"(1)Male
(2)Female\";s:9:\"select_jp\";s:25:\"(1)男の人
(2)女の人\";s:9:\"select_sk\";s:19:\"(1)남자
(2)여자\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:11:\"my_xingming\";a:20:{s:4:\"name\";s:11:\"my_xingming\";s:8:\"cname_cn\";s:6:\"姓名\";s:8:\"cname_en\";s:4:\"Name\";s:8:\"cname_jp\";s:6:\"名前\";s:8:\"cname_sk\";s:6:\"이름\";s:7:\"tips_cn\";s:0:\"\";s:7:\"tips_en\";s:0:\"\";s:7:\"tips_jp\";s:0:\"\";s:7:\"tips_sk\";s:0:\"\";s:4:\"type\";s:7:\"varchar\";s:3:\"len\";s:3:\"255\";s:10:\"selecttype\";s:1:\"0\";s:9:\"select_cn\";s:0:\"\";s:9:\"select_en\";s:0:\"\";s:9:\"select_jp\";s:0:\"\";s:9:\"select_sk\";s:0:\"\";s:8:\"filetype\";N;s:9:\"isshoping\";s:1:\"0\";s:8:\"issearch\";i:0;s:9:\"isnotnull\";i:0;}s:6:\"myform\";a:6:{s:8:\"cname_cn\";s:6:\"应聘\";s:8:\"cname_en\";s:7:\"Recruit\";s:8:\"cname_jp\";s:6:\"募集\";s:8:\"cname_sk\";s:14:\"초빙 하 다\";s:4:\"name\";s:10:\"my_yingpin\";s:8:\"template\";s:18:\"myform/myform.html\";}}}','array (
  \'archive\' => 
  array (
    \'my_shopping_color\' => 
    array (
      \'name\' => \'my_shopping_color\',
      \'cname_cn\' => \'颜色\',
      \'cname_en\' => \'Color\',
      \'cname_jp\' => \'色\',
      \'cname_sk\' => \'색깔\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'catid\' => \'0\',
      \'isshoping\' => \'1\',
      \'type\' => \'text\',
      \'len\' => 0,
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_shopping_model\' => 
    array (
      \'name\' => \'my_shopping_model\',
      \'cname_cn\' => \'类型\',
      \'cname_en\' => \'Model\',
      \'cname_jp\' => \'タイプ\',
      \'cname_sk\' => \'유형\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'catid\' => \'0\',
      \'isshoping\' => \'1\',
      \'type\' => \'text\',
      \'len\' => 0,
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_tagone\' => 
    array (
      \'name\' => \'my_tagone\',
      \'cname_cn\' => \'新增 Tab\',
      \'cname_en\' => \'Add Tab\',
      \'cname_jp\' => \'Tabを追加\',
      \'cname_sk\' => \'신규 Tab\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'catid\' => \'0\',
      \'istage\' => \'1\',
      \'type\' => \'mediumtext\',
      \'len\' => 0,
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_pingjunjiage\' => 
    array (
      \'name\' => \'my_pingjunjiage\',
      \'cname_sk\' => \'\',
      \'cname_jp\' => \'\',
      \'cname_en\' => \'\',
      \'cname_cn\' => \'平均价格\',
      \'tips_sk\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_en\' => \'\',
      \'tips_cn\' => \'平均价格\',
      \'catid_sk\' => \'\',
      \'catid_jp\' => \'\',
      \'catid_en\' => \'\',
      \'catid_cn\' => \'158\',
      \'type\' => \'varchar\',
      \'len\' => \'100\',
      \'selecttype\' => \'0\',
      \'select_sk\' => \'\',
      \'select_jp\' => \'\',
      \'select_en\' => \'\',
      \'select_cn\' => \'\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'istage\' => \'0\',
      \'listorder\' => \'0\',
    ),
  ),
  \'my_yingpin\' => 
  array (
    \'my_email\' => 
    array (
      \'name\' => \'my_email\',
      \'cname_cn\' => \'邮箱\',
      \'cname_en\' => \'Email\',
      \'cname_jp\' => \'メールボックス\',
      \'cname_sk\' => \'메일박스\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'type\' => \'varchar\',
      \'len\' => \'255\',
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_shouji\' => 
    array (
      \'name\' => \'my_shouji\',
      \'cname_cn\' => \'手机\',
      \'cname_en\' => \'Mobile\',
      \'cname_jp\' => \'携帯電話\',
      \'cname_sk\' => \'휴대폰\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'type\' => \'varchar\',
      \'len\' => \'255\',
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_xingbie\' => 
    array (
      \'name\' => \'my_xingbie\',
      \'cname_cn\' => \'性别\',
      \'cname_en\' => \'Gender\',
      \'cname_jp\' => \'性别\',
      \'cname_sk\' => \'성별\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'type\' => \'varchar\',
      \'len\' => 10,
      \'selecttype\' => \'select\',
      \'select_cn\' => \'(1)男
(2)女\',
      \'select_en\' => \'(1)Male
(2)Female\',
      \'select_jp\' => \'(1)男の人
(2)女の人\',
      \'select_sk\' => \'(1)남자
(2)여자\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'my_xingming\' => 
    array (
      \'name\' => \'my_xingming\',
      \'cname_cn\' => \'姓名\',
      \'cname_en\' => \'Name\',
      \'cname_jp\' => \'名前\',
      \'cname_sk\' => \'이름\',
      \'tips_cn\' => \'\',
      \'tips_en\' => \'\',
      \'tips_jp\' => \'\',
      \'tips_sk\' => \'\',
      \'type\' => \'varchar\',
      \'len\' => \'255\',
      \'selecttype\' => \'0\',
      \'select_cn\' => \'\',
      \'select_en\' => \'\',
      \'select_jp\' => \'\',
      \'select_sk\' => \'\',
      \'filetype\' => NULL,
      \'isshoping\' => \'0\',
      \'issearch\' => 0,
      \'isnotnull\' => 0,
    ),
    \'myform\' => 
    array (
      \'cname_cn\' => \'应聘\',
      \'cname_en\' => \'Recruit\',
      \'cname_jp\' => \'募集\',
      \'cname_sk\' => \'초빙 하 다\',
      \'name\' => \'my_yingpin\',
      \'template\' => \'myform/myform.html\',
    ),
  ),
)');-- 


INSERT INTO `cmseasy_type` VALUES('1','0','女装/男装/内衣','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','nvzhuang-nanzhuang-neiyi','type/list_products.html','type/list_products.html','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('2','0','鞋靴/箱包/配件','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','xiexue-xiangbao-peijian','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('3','0','童装玩家/孕产/用品','','','0','','','','','','tongzhuangwanjia-yunchan-yongpin','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('4','0','家电/数码/手机','','','0','','','','','','jiadian-shuma-shouji','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('5','0','美妆/洗护/保健品','','','0','','','','','','meizhuang-xihu-baojianpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('6','0','珠宝/眼镜/手表','','','0','','','','','','zhubao-yanjing-shoubiao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('7','0','运动/户外/乐器','','','0','','','','','','yundong-huwai-yueqi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('8','0','游戏/动漫/影视','','','0','','','','','','youxi-dongman-yingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('9','0','美食/生鲜/零食','','','0','','','','','','meishi-shegnxian-lingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('10','0','鲜花/宠物/农资','','','0','','','','','','xianhua-chongwu-nongzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('11','0','工具/装修/建材','','','0','','','','','','gongju-zhuangxiu-jiancai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('12','0','家具/家饰/家纺','','','0','','','','','','jiaju-jiashi-jiafang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('13','0','汽车/二手车/用品','','','0','','','','','','qiche-ershouche-yongpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('14','0','办公/DIY/五金电子','','','0','','','','','','bangong-diy-wujindainzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('15','0','百货/餐厨/家庭保健','','','0','','','','','','baihuo-canchu-jiatingbaojian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('16','0','学习/卡卷/本地服务','','','0','','','','','','xuexi-kajuan-bendifuwu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','1');-- 
INSERT INTO `cmseasy_type` VALUES('17','1','女装','','','0','','','','','','nvzhuang-1','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('18','1','男装','','','0','','','','','','nanzhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('19','1','内衣','','','0','','','','','','neiyi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('20','17','连衣裙','','','0','','','','','','lianyiqun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('21','17','衬衫','','','0','','','','','','chenshan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('22','17','裤子','','','0','','','','','','kuzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('23','17','牛仔裤','','','0','','','','','','niuziku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('24','17','西装','','','0','','','','','','xizhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('25','17','短外套','','','0','','','','','','duanwaitao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('26','17','时尚套装','','','0','','','','','','shishangtaozhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('27','18','衬衫','','','0','','','','','','nan-chen-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('28','18','POLO衫','','','0','','','','','','nan-plolo-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('29','18','休闲裤','','','0','','','','','','nan-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('30','18','牛仔裤','','','0','','','','','','nan-niu-zi-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('31','18','套装','','','0','','','','','','nan-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('32','18','外套','','','0','','','','','','nan-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('33','18','夹克','','','0','','','','','','nan-jia-ke','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('34','18','卫衣','','','0','','','','','','nan-wei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('35','18','风衣','','','0','','','','','','nan-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('36','18','西装','','','0','','','','','','nan-xi-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('37','18','牛仔外套','','','0','','','','','','nan-niu-zi-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('38','18','棒球服','','','0','','','','','','nan-bang-qiu-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('39','17','半身裙','','','0','','','','','','nv-ban-shen-qun ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('40','17','毛针织衫','','','0','','','','','','nv-mao-zhen-zhi-shan ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('41','17','风衣','','','0','','','','','','nv-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('42','17','休闲裤','','','0','','','','','','nv-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('43','17','卫衣绒衫','','','0','','','','','','nv-wei-yi-rong-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('44','17','大码女装','','','0','','','','','','nv-da-ma-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('45','17','蕾丝衫/雪纺衫','','','0','','','','','','nv-lei-si-shan/xue-fang-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('46','17','背心吊带','','','0','','','','','','nv-bei-xin-diao-dai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('47','17','毛衣','','','0','','','','','','nv-mao-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('48','17','毛呢外套','','','0','','','','','','nv-mao-ni-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('49','17','羽绒服','','','0','','','','','','nv-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('50','17','皮衣','','','0','','','','','','nv-pi-','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('51','18','皮衣','','','0','','','','','','nan-pi-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('52','18','针织衫/毛衣','','','0','','','','','','nan-zhen-zhi-shan/mao-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('53','18','运动裤','','','0','','','','','','nan-yun-dong-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('54','18','工装裤','','','0','','','','','','nan-gong-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('55','18','开衫','','','0','','','','','','nan-kai-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('56','18','马甲','','','0','','','','','','nan-ma-jia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('57','18','毛呢大衣','','','0','','','','','','nan-mao-ni-da-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('58','18','羽绒服','','','0','','','','','','nan-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('59','18','棉衣','','','0','','','','','','nan-mian-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('60','18','中老年','','','0','','','','','','zhong-lao-nian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('61','18','情侣装','','','0','','','','','','qing-lv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('62','18','大码','','','0','','','','','','da-ma','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('63','18','民族风','','','0','','','','','','min-zu-feng ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('64','18','专柜大牌','','','0','','','','','','zhuan-gui','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('65','17','皮草','','','0','','','','','','nv-pi-cao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('66','17','棉衣棉服','','','0','','','','','','nv-mian-yi-mian-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('67','17','马夹','','','0','','','','','','nv-maj-ia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('68','17','牛仔外套','','','0','','','','','','nv-niu-zai-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('69','17','阔腿裤','','','0','','','','','','nv-kuo-tui-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('70','17','中老年女装','','','0','','','','','','nv-zhong-lao-nian-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('71','17','婚纱礼服','','','0','','','','','','nv-hun-sha-li-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('72','17','民族服装','','','0','','','','','','nv-min-zu-fu-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('73','17','打底裤','','','0','','','','','','nv-da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('74','17','西装裤','','','0','','','','','','nv-xi-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('75','17','唐装','','','0','','','','','','nv-tang-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('76','17','汉服','','','0','','','','','','nv-han-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('77','17','旗袍','','','0','','','','','','nv-qi-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('78','19','法式内衣','','','0','','','','','','fa-shi-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('79','19','无钢圈内衣','','','0','','','','','','wu-gang-quan-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('80','19','内裤女','','','0','','','','','','nei-ku-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('81','19','文胸','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('82','19','内裤男','','','0','','','','','','nei-ku-nan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('83','19','长袖睡衣','','','0','','','','','','chang-xiu-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('84','19','睡裙','','','0','','','','','','shui-qun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('85','19','真丝睡衣','','','0','','','','','','zhen-si-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('86','19','丝袜','','','0','','','','','','si-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('87','19','船袜','','','0','','','','','','chuan-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('88','19','情侣睡衣','','','0','','','','','','qing-lv-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('89','19','抹胸','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('90','19','背心','','','0','','','','','','bei-xin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('91','19','睡袍','','','0','','','','','','shui-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('92','19','男士睡衣','','','0','','','','','','nan-shi-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('93','19','塑身衣','','','0','','','','','','su-shen-y','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('94','19','内衣套装','','','0','','','','','','nei-yi-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('95','19','打底裤','','','0','','','','','','da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('96','19','连体睡衣','','','0','','','','','','lian-ti-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('97','19','聚拢文胸','','','0','','','','','','jv-long-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('98','19','男士袜子','','','0','','','','','','nan-shi-wa-zi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('99','19','棉袜女','','','0','','','','','','mian-wa-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('100','19','卡通睡衣','','','0','','','','','','ka-tong-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('101','19','无痕内裤','','','0','','','','','','wu-hen-nei-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('102','19','少女文胸','','','0','','','','','','shao-nv-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','1');-- 
INSERT INTO `cmseasy_type` VALUES('103','0','Women\'s/Men\'s/Underwear','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','nvzhuang-nanzhuang-neiyi','type/list_products.html','type/list_products.html','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('104','0','shoes/bags/accessories','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','xiexue-xiangbao-peijian','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('105','0','Children\'s wear players/pregna','','','0','','','','','','tongzhuangwanjia-yunchan-yongpin','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('106','0','Household appliances/digital/m','','','0','','','','','','jiadian-shuma-shouji','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('107','0','Cosmetics/Nursing/Healthcare P','','','0','','','','','','meizhuang-xihu-baojianpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('108','0','Jewelry/glasses/watches','','','0','','','','','','zhubao-yanjing-shoubiao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('109','0','sports/Outdoor/Musical Instrum','','','0','','','','','','yundong-huwai-yueqi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('110','0','Game/Animation/Film and Televi','','','0','','','','','','youxi-dongman-yingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('111','0','Gourmet / Fresh / Snacks','','','0','','','','','','meishi-shegnxian-lingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('112','0','Flowers/Pets/Agriculture','','','0','','','','','','xianhua-chongwu-nongzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('113','0','tools/Decoration/Building Mate','','','0','','','','','','gongju-zhuangxiu-jiancai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('114','0','Furniture/Home Decoration/Home','','','0','','','','','','jiaju-jiashi-jiafang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('115','0','Cars/used cars/supplies','','','0','','','','','','qiche-ershouche-yongpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('116','0','Office/DIY/Hardware Electronic','','','0','','','','','','bangong-diy-wujindainzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('117','0','Department Store/Kitchen/Famil','','','0','','','','','','baihuo-canchu-jiatingbaojian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('118','0','Learning/Card/Local Service','','','0','','','','','','xuexi-kajuan-bendifuwu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','2');-- 
INSERT INTO `cmseasy_type` VALUES('119','103','Women\'s wear','','','0','','','','','','nvzhuang-1','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('120','103','Men\'s wear','','','0','','','','','','nanzhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('121','103','Underwear','','','0','','','','','','neiyi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('122','119','Dress','','','0','','','','','','lianyiqun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('123','119','shirt','','','0','','','','','','chenshan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('124','119','trousers','','','0','','','','','','kuzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('125','119','Jeans','','','0','','','','','','niuziku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('126','119','suit','','','0','','','','','','xizhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('127','119','short coat','','','0','','','','','','duanwaitao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('128','119','Fashion suit','','','0','','','','','','shishangtaozhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('129','120','shirt','','','0','','','','','','nan-chen-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('130','120','pOLOShirt','','','0','','','','','','nan-plolo-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('131','120','Casual pants','','','0','','','','','','nan-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('132','120','Jeans','','','0','','','','','','nan-niu-zi-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('133','120','suit','','','0','','','','','','nan-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('134','120','Loose coat','','','0','','','','','','nan-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('135','120','Jacket','','','0','','','','','','nan-jia-ke','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('136','120','sweater','','','0','','','','','','nan-wei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('137','120','Windbreaker','','','0','','','','','','nan-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('138','120','suit','','','0','','','','','','nan-xi-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('139','120','Chaqueta','','','0','','','','','','nan-niu-zi-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('140','120','mlb','','','0','','','','','','nan-bang-qiu-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('141','119','skirt','','','0','','','','','','nv-ban-shen-qun ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('142','119','sweater','','','0','','','','','','nv-mao-zhen-zhi-shan ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('143','119','Windbreaker','','','0','','','','','','nv-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('144','119','Casual pants','','','0','','','','','','nv-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('145','119','sweater','','','0','','','','','','nv-wei-yi-rong-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('146','119','Large-size women\'s clothes','','','0','','','','','','nv-da-ma-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('147','119','Lace shirt/chiffon shirt','','','0','','','','','','nv-lei-si-shan/xue-fang-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('148','119','Vest sling','','','0','','','','','','nv-bei-xin-diao-dai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('149','119','sweater','','','0','','','','','','nv-mao-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('150','119','Woolen coat','','','0','','','','','','nv-mao-ni-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('151','119','Down Jackets','','','0','','','','','','nv-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('152','119','Leather clothing','','','0','','','','','','nv-pi-','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('153','120','Leather clothing','','','0','','','','','','nan-pi-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('154','120','sweater/sweater','','','0','','','','','','nan-zhen-zhi-shan/mao-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('155','120','sports pants','','','0','','','','','','nan-yun-dong-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('156','120','Overalls','','','0','','','','','','nan-gong-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('157','120','Cardigan','','','0','','','','','','nan-kai-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('158','120','Vest','','','0','','','','','','nan-ma-jia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('159','120','woolen overcoat','','','0','','','','','','nan-mao-ni-da-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('160','120','Down Jackets','','','0','','','','','','nan-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('161','120','Cotton-padded clothes','','','0','','','','','','nan-mian-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('162','120','Middle and old age','','','0','','','','','','zhong-lao-nian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('163','120','Couples dress','','','0','','','','','','qing-lv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('164','120','Big code','','','0','','','','','','da-ma','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('165','120','Ethnic style','','','0','','','','','','min-zu-feng ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('166','120','special Counter Major Brand','','','0','','','','','','zhuan-gui','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('167','119','Leather and fur','','','0','','','','','','nv-pi-cao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('168','119','cotton-padded coats','','','0','','','','','','nv-mian-yi-mian-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('169','119','Vest','','','0','','','','','','nv-maj-ia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('170','119','Chaqueta','','','0','','','','','','nv-niu-zai-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('171','119','Broad-legged trousers','','','0','','','','','','nv-kuo-tui-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('172','119','Middle-aged and elderly women\'','','','0','','','','','','nv-zhong-lao-nian-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('173','119','Wedding dress','','','0','','','','','','nv-hun-sha-li-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('174','119','National Costume','','','0','','','','','','nv-min-zu-fu-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('175','119','Leggings','','','0','','','','','','nv-da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('176','119','suit pants','','','0','','','','','','nv-xi-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('177','119','tang Costume','','','0','','','','','','nv-tang-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('178','119','Hanfu','','','0','','','','','','nv-han-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('179','119','cheongsam','','','0','','','','','','nv-qi-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('180','121','French underwear','','','0','','','','','','fa-shi-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('181','121','Ring-free underwear','','','0','','','','','','wu-gang-quan-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('182','121','Girls in Underwear','','','0','','','','','','nei-ku-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('183','121','Bras','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('184','121','Men in Underwear','','','0','','','','','','nei-ku-nan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('185','121','Long sleeve pajamas','','','0','','','','','','chang-xiu-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('186','121','Nightdress','','','0','','','','','','shui-qun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('187','121','silk sleepwear','','','0','','','','','','zhen-si-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('188','121','silk stockings','','','0','','','','','','si-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('189','121','Boat socks','','','0','','','','','','chuan-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('190','121','Lovers pajamas','','','0','','','','','','qing-lv-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('191','121','undergarment covering the ches','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('192','121','vest','','','0','','','','','','bei-xin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('193','121','Robe','','','0','','','','','','shui-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('194','121','Men\'s pajamas','','','0','','','','','','nan-shi-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('195','121','Corset','','','0','','','','','','su-shen-y','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('196','121','Underwear set','','','0','','','','','','nei-yi-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('197','121','Leggings','','','0','','','','','','da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('198','121','Conjoined Pyjamas','','','0','','','','','','lian-ti-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('199','121','Gathering bras','','','0','','','','','','jv-long-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('200','121','Men\'s socks','','','0','','','','','','nan-shi-wa-zi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('201','121','Cotton Socks Woman','','','0','','','','','','mian-wa-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('202','121','Cartoon Pyjamas','','','0','','','','','','ka-tong-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('203','121','seamless underwear','','','0','','','','','','wu-hen-nei-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('204','121','Girl Bra','','','0','','','','','','shao-nv-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','2');-- 
INSERT INTO `cmseasy_type` VALUES('307','0','여장/남장/속옷','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','nvzhuang-nanzhuang-neiyi','type/list_products.html','type/list_products.html','','','','','article','127','0','0','127','1','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('308','0','신발/가방/액세서리','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','xiexue-xiangbao-peijian','0','0','','','','','article','127','0','0','127','1','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('309','0','아동복 플레이어/임신/용품','','','0','','','','','','tongzhuangwanjia-yunchan-yongpin','0','0','','','','','article','127','0','0','127','1','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('310','0','가전/디지털/핸드폰','','','0','','','','','','jiadian-shuma-shouji','0','0','','','','','article','127','0','0','127','1','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('311','0','메이크업/세정/보건품','','','0','','','','','','meizhuang-xihu-baojianpin','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('312','0','보석/안경/시계','','','0','','','','','','zhubao-yanjing-shoubiao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('313','0','운동/실외/악기','','','0','','','','','','yundong-huwai-yueqi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('314','0','게임/애니메이션/영상','','','0','','','','','','youxi-dongman-yingshi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('315','0','미식/생선/간식','','','0','','','','','','meishi-shegnxian-lingshi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('316','0','생화/애완동물/농자재','','','0','','','','','','xianhua-chongwu-nongzi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('317','0','도구/인테리어/건축자재','','','0','','','','','','gongju-zhuangxiu-jiancai','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('318','0','가구/인테리어/가재 방적','','','0','','','','','','jiaju-jiashi-jiafang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('319','0','자동차/중고차/용품','','','0','','','','','','qiche-ershouche-yongpin','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('320','0','업무/DIY/금속전자','','','0','','','','','','bangong-diy-wujindainzi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('321','0','백화점/주방장/가정건강','','','0','','','','','','baihuo-canchu-jiatingbaojian','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('322','0','학습 /카드 /로컬 서비스','','','0','','','','','','xuexi-kajuan-bendifuwu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','127','4');-- 
INSERT INTO `cmseasy_type` VALUES('323','307','여성복','','','0','','','','','','nvzhuang-1','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('324','307','남성복','','','0','','','','','','nanzhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('325','307','속옷','','','0','','','','','','neiyi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('326','323','원피스','','','0','','','','','','lianyiqun','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('327','323','셔츠','','','0','','','','','','chenshan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('328','323','바지','','','0','','','','','','kuzi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('329','323','청바지','','','0','','','','','','niuziku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('330','323','양복','','','0','','','','','','xizhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('331','323','쇼트 코트','','','0','','','','','','duanwaitao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('332','323','패션 세트','','','0','','','','','','shishangtaozhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('333','324','셔츠','','','0','','','','','','nan-chen-shan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('334','324','POLO셔츠','','','0','','','','','','nan-plolo-shan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('335','324','캐주얼 팬츠','','','0','','','','','','nan-xiu-xian-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('336','324','청바지','','','0','','','','','','nan-niu-zi-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('337','324','세트','','','0','','','','','','nan-tao-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('338','324','외투','','','0','','','','','','nan-wai-tao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('339','324','점퍼','','','0','','','','','','nan-jia-ke','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('340','324','맨투맨','','','0','','','','','','nan-wei-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('341','324','무스탕','','','0','','','','','','nan-feng-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('342','324','양복','','','0','','','','','','nan-xi-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('343','324','데님 코트','','','0','','','','','','nan-niu-zi-wai-tao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('344','324','야구복','','','0','','','','','','nan-bang-qiu-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('345','323','스커트','','','0','','','','','','nv-ban-shen-qun ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('346','323','털니트','','','0','','','','','','nv-mao-zhen-zhi-shan ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('347','323','무스탕','','','0','','','','','','nv-feng-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('348','323','캐주얼 팬츠','','','0','','','','','','nv-xiu-xian-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('349','323','맨투맨 스웨터','','','0','','','','','','nv-wei-yi-rong-shan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('350','323','여장','','','0','','','','','','nv-da-ma-nv-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('351','323','레이스 셔츠','','','0','','','','','','nv-lei-si-shan/xue-fang-shan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('352','323','나시 벨트','','','0','','','','','','nv-bei-xin-diao-dai','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('353','323','스웨터','','','0','','','','','','nv-mao-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('354','323','모직 코트','','','0','','','','','','nv-mao-ni-wai-tao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('355','323','다운 점퍼','','','0','','','','','','nv-yu-rong-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('356','323','가죽 옷','','','0','','','','','','nv-pi-','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('357','324','가죽 옷','','','0','','','','','','nan-pi-yi ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('358','324','니트 /스웨터','','','0','','','','','','nan-zhen-zhi-shan/mao-yi ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('359','324','스포츠 팬츠','','','0','','','','','','nan-yun-dong-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('360','324','바지','','','0','','','','','','nan-gong-zhuang-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('361','324','카디건','','','0','','','','','','nan-kai-shan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('362','324','조끼','','','0','','','','','','nan-ma-jia','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('363','324','모직 외투','','','0','','','','','','nan-mao-ni-da-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('364','324','다운 점퍼','','','0','','','','','','nan-yu-rong-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('365','324','솜바지','','','0','','','','','','nan-mian-yi ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('366','324','중노년','','','0','','','','','','zhong-lao-nian','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('367','324','커플룩','','','0','','','','','','qing-lv-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('368','324','대 야드','','','0','','','','','','da-ma','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('369','324','민족풍','','','0','','','','','','min-zu-feng ','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('370','324','전문 판매대','','','0','','','','','','zhuan-gui','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('371','323','모피','','','0','','','','','','nv-pi-cao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('372','323','솜옷','','','0','','','','','','nv-mian-yi-mian-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('373','323','말 집게','','','0','','','','','','nv-maj-ia','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('374','323','데님 아우터','','','0','','','','','','nv-niu-zai-wai-tao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('375','323','와이드 팬츠','','','0','','','','','','nv-kuo-tui-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('376','323','중노년 여성복','','','0','','','','','','nv-zhong-lao-nian-nv-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('377','323','웨딩드레스','','','0','','','','','','nv-hun-sha-li-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('378','323','민족 의상','','','0','','','','','','nv-min-zu-fu-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('379','323','레깅스','','','0','','','','','','nv-da-di-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('380','323','양복 바지','','','0','','','','','','nv-xi-zhuang-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('381','323','당장','','','0','','','','','','nv-tang-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('382','323','한복','','','0','','','','','','nv-han-fu','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('383','323','듭,,,,','','','0','','','','','','nv-qi-pao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('384','325','프랑스식 내의','','','0','','','','','','fa-shi-nei-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('385','325','노 와이어 란제리','','','0','','','','','','wu-gang-quan-nei-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('386','325','팬티걸','','','0','','','','','','nei-ku-nv','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('387','325','브래지어','','','0','','','','','','wen-xiong','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('388','325','팬티맨','','','0','','','','','','nei-ku-nan','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('389','325','긴 소매 잠옷','','','0','','','','','','chang-xiu-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('390','325','잠 치마','','','0','','','','','','shui-qun','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('391','325','실크 잠옷','','','0','','','','','','zhen-si-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('392','325','스타킹','','','0','','','','','','si-wa','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('393','325','배 양말','','','0','','','','','','chuan-wa','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('394','325','커플 파자마','','','0','','','','','','qing-lv-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('395','325','느낌','','','0','','','','','','wen-xiong','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('396','325','저끼','','','0','','','','','','bei-xin','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('397','325','잠옷','','','0','','','','','','shui-pao','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('398','325','남성 잠옷','','','0','','','','','','nan-shi-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('399','325','거들','','','0','','','','','','su-shen-y','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('400','325','속옷 세트','','','0','','','','','','nei-yi-tao-zhuang','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('401','325','레깅스','','','0','','','','','','da-di-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('402','325','점프슈트','','','0','','','','','','lian-ti-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('403','325','브래지어를 모으다','','','0','','','','','','jv-long-wen-xiong','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('404','325','남성 양말','','','0','','','','','','nan-shi-wa-zi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('405','325','면양말녀','','','0','','','','','','mian-wa-nv','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('406','325','잠옷을 말리다','','','0','','','','','','ka-tong-shui-yi','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('407','325','노 라인 팬티','','','0','','','','','','wu-hen-nei-ku','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('408','325','소녀 브래지어','','','0','','','','','','shao-nv-wen-xiong','0','0','','','','','article','127','0','0','0','127','0','','','','','','0','0','0','0','4');-- 
INSERT INTO `cmseasy_type` VALUES('205','0','レディース/メンズ/下着','','','0','/html/upload/images/201907/15591099593550.jpg','','','','','nvzhuang-nanzhuang-neiyi','type/list_products.html','type/list_products.html','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('206','0','靴靴/バッグ/アクセサリー','','','0','/html/upload/images/201907/15591099453652.jpg','','','','','xiexue-xiangbao-peijian','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('207','0','子供服プレイヤー/妊娠/用品','','','0','','','','','','tongzhuangwanjia-yunchan-yongpin','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('208','0','家電/デジタル/携帯電話','','','0','','','','','','jiadian-shuma-shouji','0','0','','','','','article','1','0','0','1','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('209','0','化粧品/ローション/サプリメント','','','0','','','','','','meizhuang-xihu-baojianpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('210','0','ジュエリー/メガネ/腕時計','','','0','','','','','','zhubao-yanjing-shoubiao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('211','0','スポーツ/アウトドア/楽器','','','0','','','','','','yundong-huwai-yueqi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('212','0','ゲーム/アニメ/映画','','','0','','','','','','youxi-dongman-yingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('213','0','グルメ/生鮮/おやつ','','','0','','','','','','meishi-shegnxian-lingshi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('214','0','花/ペット/農業','','','0','','','','','','xianhua-chongwu-nongzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('215','0','工具/内装/建材','','','0','','','','','','gongju-zhuangxiu-jiancai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('216','0','家具/インテリア/紡績品','','','0','','','','','','jiaju-jiashi-jiafang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('217','0','自動車/中古車/用品','','','0','','','','','','qiche-ershouche-yongpin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('218','0','オフィス/DIY/金属電子','','','0','','','','','','bangong-diy-wujindainzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('219','0','百貨店/レストラン/家庭保健','','','0','','','','','','baihuo-canchu-jiatingbaojian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('220','0','学習/カード巻/ローカルサービス','','','0','','','','','','xuexi-kajuan-bendifuwu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','1','3');-- 
INSERT INTO `cmseasy_type` VALUES('221','205','婦人服','','','0','','','','','','nvzhuang-1','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('222','205','男の身','','','0','','','','','','nanzhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('223','205','下着','','','0','','','','','','neiyi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('224','221','ワンピース','','','0','','','','','','lianyiqun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('225','221','シャツ','','','0','','','','','','chenshan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('226','221','ズボン','','','0','','','','','','kuzi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('227','221','ジーパン','','','0','','','','','','niuziku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('228','221','スーツ','','','0','','','','','','xizhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('229','221','ジャケット','','','0','','','','','','duanwaitao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('230','221','おしゃれセット','','','0','','','','','','shishangtaozhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('231','222','シャツ','','','0','','','','','','nan-chen-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('232','222','POLOシャツ','','','0','','','','','','nan-plolo-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('233','222','カジュアル？ズボン','','','0','','','','','','nan-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('234','222','ジーパン','','','0','','','','','','nan-niu-zi-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('235','222','セット','','','0','','','','','','nan-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('236','222','オーバー','','','0','','','','','','nan-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('237','222','ジャケット','','','0','','','','','','nan-jia-ke','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('238','222','衣服を守る','','','0','','','','','','nan-wei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('239','222','パーカー','','','0','','','','','','nan-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('240','222','スーツ','','','0','','','','','','nan-xi-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('241','222','デニムのコート','','','0','','','','','','nan-niu-zi-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('242','222','野球服','','','0','','','','','','nan-bang-qiu-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('243','221','スカート','','','0','','','','','','nv-ban-shen-qun ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('244','221','メリヤスのシャツ','','','0','','','','','','nv-mao-zhen-zhi-shan ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('245','221','パーカー','','','0','','','','','','nv-feng-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('246','221','カジュアル？ズボン','','','0','','','','','','nv-xiu-xian-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('247','221','カーディガン','','','0','','','','','','nv-wei-yi-rong-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('248','221','レディースサイズ','','','0','','','','','','nv-da-ma-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('249','221','レース/シフォンシャツ','','','0','','','','','','nv-lei-si-shan/xue-fang-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('250','221','タンクトップ','','','0','','','','','','nv-bei-xin-diao-dai','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('251','221','セーター','','','0','','','','','','nv-mao-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('252','221','ウールのコート','','','0','','','','','','nv-mao-ni-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('253','221','ダウンジャケット','','','0','','','','','','nv-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('254','221','毛皮の服','','','0','','','','','','nv-pi-','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('255','222','毛皮の服','','','0','','','','','','nan-pi-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('256','222','ニット/セーター','','','0','','','','','','nan-zhen-zhi-shan/mao-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('257','222','ジャージ','','','0','','','','','','nan-yun-dong-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('258','222','ジーパン','','','0','','','','','','nan-gong-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('259','222','カーディガン','','','0','','','','','','nan-kai-shan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('260','222','ベスト','','','0','','','','','','nan-ma-jia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('261','222','ラシャのコート','','','0','','','','','','nan-mao-ni-da-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('262','222','ダウンジャケット','','','0','','','','','','nan-yu-rong-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('263','222','綿入れ','','','0','','','','','','nan-mian-yi ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('264','222','中高年','','','0','','','','','','zhong-lao-nian','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('265','222','カップル？ルック','','','0','','','','','','qing-lv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('266','222','大きいサイズ','','','0','','','','','','da-ma','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('267','222','民族の気風','','','0','','','','','','min-zu-feng ','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('268','222','専門店の看板','','','0','','','','','','zhuan-gui','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('269','221','毛皮','','','0','','','','','','nv-pi-cao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('270','221','綿入れの綿入れ','','','0','','','','','','nv-mian-yi-mian-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('271','221','馬の飼い葉入れ','','','0','','','','','','nv-maj-ia','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('272','221','デニムのコート','','','0','','','','','','nv-niu-zai-wai-tao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('273','221','ワイド？ズボン','','','0','','','','','','nv-kuo-tui-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('274','221','中高年の婦人服','','','0','','','','','','nv-zhong-lao-nian-nv-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('275','221','ウエディングドレス','','','0','','','','','','nv-hun-sha-li-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('276','221','民族衣装','','','0','','','','','','nv-min-zu-fu-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('277','221','ズボンをはく','','','0','','','','','','nv-da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('278','221','洋服のズボン','','','0','','','','','','nv-xi-zhuang-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('279','221','唐装','','','0','','','','','','nv-tang-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('280','221','漢服','','','0','','','','','','nv-han-fu','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('281','221','チャイナドレス','','','0','','','','','','nv-qi-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('282','223','フレンチ？下着','','','0','','','','','','fa-shi-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('283','223','無鋼製の下着','','','0','','','','','','wu-gang-quan-nei-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('284','223','パンティーの女','','','0','','','','','','nei-ku-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('285','223','ブラジャー','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('286','223','パンツ男','','','0','','','','','','nei-ku-nan','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('287','223','長袖パジャマ','','','0','','','','','','chang-xiu-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('288','223','タイト？スカート','','','0','','','','','','shui-qun','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('289','223','シルクのパジャマ','','','0','','','','','','zhen-si-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('290','223','黒ストッキング女教师','','','0','','','','','','si-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('291','223','船足用の靴下','','','0','','','','','','chuan-wa','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('292','223','パジャマ','','','0','','','','','','qing-lv-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('293','223','胸をぬぐう','','','0','','','','','','wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('294','223','チョッキ','','','0','','','','','','bei-xin','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('295','223','ナイト？ガウン','','','0','','','','','','shui-pao','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('296','223','パジャマ','','','0','','','','','','nan-shi-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('297','223','シェイプアップ？ウエア','','','0','','','','','','su-shen-y','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('298','223','下着セット','','','0','','','','','','nei-yi-tao-zhuang','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('299','223','ズボンをはく','','','0','','','','','','da-di-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('300','223','パジャマ','','','0','','','','','','lian-ti-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('301','223','ブラジャーを集める','','','0','','','','','','jv-long-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('302','223','紳士用靴下','','','0','','','','','','nan-shi-wa-zi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('303','223','綿の靴下の女性','','','0','','','','','','mian-wa-nv','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('304','223','パジャマ','','','0','','','','','','ka-tong-shui-yi','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('305','223','ノーズパンツ','','','0','','','','','','wu-hen-nei-ku','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 
INSERT INTO `cmseasy_type` VALUES('306','223','乙女スヴィア','','','0','','','','','','shao-nv-wen-xiong','0','0','','','','','article','1','0','0','0','1','0','','','','','','0','0','0','0','3');-- 




INSERT INTO `cmseasy_user` VALUES('1','admin','21232f297a57a5a743894a0e4a801fc3','管理员','2','1','','','','','','0','1111','admin@admin.com','admin','admin','','','','0','0','0','','0','0','/html/upload/images/201907/15625455867367.png','0','17:0:1','2,4,3,46,14,73','100.07','0000-00-00 00:00:00','','cn','cn','','','');-- 

INSERT INTO `cmseasy_user_history` VALUES('76','1','客服列表','/index.php?case=config&act=system&set=customer&admin_dir=admin&site=default','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('78','1','模板标签','/index.php?case=table&act=list&table=templatetag&tagfrom=content&admin_dir=admin&site=default','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('79','1','数据管理','/index.php?case=database&act=baker&admin_dir=admin&site=default','1','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('80','1','日志管理','/index.php?case=adminlogs&act=manage&admin_dir=admin&site=default','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('73','1','内容管理','/index.php?case=table&act=list&table=archive&admin_dir=admin&site=default','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('74','1','编辑内容','/index.php?case=table&act=edit&table=archive&admin_dir=admin&site=default&dfile=&page=1&catid=160&id=551&deletestate=','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('75','1','设置','/index.php?case=config&act=index&admin_dir=admin&site=default','0','1');-- 
INSERT INTO `cmseasy_user_history` VALUES('77','1','模板','/index.php?case=config&act=system&set=template&admin_dir=admin&site=default','0','1');-- 

INSERT INTO `cmseasy_usergroup` VALUES('101','一般会员','0.0','','add_archive','0','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('3','新闻管理员','0.0','a:64:{s:6:\"config\";s:1:\"1\";s:12:\"system_image\";s:1:\"1\";s:13:\"system_upload\";s:1:\"1\";s:8:\"language\";s:1:\"1\";s:7:\"content\";s:1:\"1\";s:7:\"archive\";s:1:\"1\";s:12:\"archive_list\";s:1:\"1\";s:11:\"archive_add\";s:1:\"1\";s:12:\"archive_edit\";s:1:\"1\";s:11:\"archive_del\";s:1:\"1\";s:13:\"archive_check\";s:1:\"1\";s:15:\"archive_setting\";s:1:\"1\";s:17:\"archive_hotsearch\";s:1:\"1\";s:13:\"archive_image\";s:1:\"1\";s:11:\"archive_tag\";s:1:\"1\";s:4:\"func\";s:1:\"1\";s:12:\"func_announc\";s:1:\"1\";s:17:\"func_announc_list\";s:1:\"1\";s:16:\"func_announc_add\";s:1:\"1\";s:17:\"func_announc_edit\";s:1:\"1\";s:16:\"func_announc_del\";s:1:\"1\";s:9:\"func_book\";s:1:\"1\";s:14:\"func_book_list\";s:1:\"1\";s:15:\"func_book_reply\";s:1:\"1\";s:13:\"func_book_del\";s:1:\"1\";s:12:\"func_comment\";s:1:\"1\";s:17:\"func_comment_list\";s:1:\"1\";s:17:\"func_comment_edit\";s:1:\"1\";s:16:\"func_comment_del\";s:1:\"1\";s:11:\"func_ballot\";s:1:\"1\";s:16:\"func_ballot_list\";s:1:\"1\";s:15:\"func_ballot_add\";s:1:\"1\";s:16:\"func_ballot_edit\";s:1:\"1\";s:15:\"func_ballot_del\";s:1:\"1\";s:3:\"seo\";s:1:\"1\";s:10:\"seo_weixin\";s:1:\"1\";s:15:\"seo_weixin_list\";s:1:\"1\";s:14:\"seo_weixin_add\";s:1:\"1\";s:15:\"seo_weixin_edit\";s:1:\"1\";s:14:\"seo_weixin_del\";s:1:\"1\";s:12:\"seo_linkword\";s:1:\"1\";s:17:\"seo_linkword_list\";s:1:\"1\";s:16:\"seo_linkword_add\";s:1:\"1\";s:17:\"seo_linkword_edit\";s:1:\"1\";s:16:\"seo_linkword_del\";s:1:\"1\";s:14:\"seo_xiongzhang\";s:1:\"1\";s:5:\"cache\";s:1:\"1\";s:12:\"cache_manage\";s:1:\"1\";s:13:\"cache_content\";s:1:\"1\";s:14:\"cache_category\";s:1:\"1\";s:11:\"cache_index\";s:1:\"1\";s:10:\"cache_type\";s:1:\"1\";s:13:\"cache_special\";s:1:\"1\";s:9:\"cache_tag\";s:1:\"1\";s:11:\"cache_baidu\";s:1:\"1\";s:12:\"cache_google\";s:1:\"1\";s:16:\"cache_wap_manage\";s:1:\"1\";s:24:\"cache_manage_wap_content\";s:1:\"1\";s:25:\"cache_manage_wap_category\";s:1:\"1\";s:22:\"cache_manage_wap_index\";s:1:\"1\";s:21:\"cache_manage_wap_type\";s:1:\"1\";s:24:\"cache_manage_wap_special\";s:1:\"1\";s:20:\"cache_manage_wap_tag\";s:1:\"1\";s:12:\"cache_update\";s:1:\"1\";}','add_archive','0','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('4','部门管理员','0.0','a:5:{s:7:\"content\";s:1:\"1\";s:7:\"archive\";s:1:\"1\";s:12:\"archive_list\";s:1:\"1\";s:11:\"archive_add\";s:1:\"1\";s:12:\"archive_edit\";s:1:\"1\";}','add_archive','100','0','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('2','超级管理员','5.0','a:206:{s:6:\"config\";s:1:\"1\";s:11:\"system_site\";s:1:\"1\";s:13:\"system_extend\";s:1:\"1\";s:12:\"system_image\";s:1:\"1\";s:20:\"system_filechecksite\";s:1:\"1\";s:13:\"system_upload\";s:1:\"1\";s:15:\"system_security\";s:1:\"1\";s:11:\"system_mail\";s:1:\"1\";s:11:\"system_vote\";s:1:\"1\";s:8:\"language\";s:1:\"1\";s:10:\"system_sms\";s:1:\"1\";s:11:\"system_ditu\";s:1:\"1\";s:7:\"website\";s:1:\"1\";s:18:\"system_information\";s:1:\"1\";s:18:\"system_websitesite\";s:1:\"1\";s:14:\"system_dynamic\";s:1:\"1\";s:15:\"system_customer\";s:1:\"1\";s:19:\"system_verification\";s:1:\"1\";s:16:\"system_sitesetup\";s:1:\"1\";s:17:\"system_membersite\";s:1:\"1\";s:14:\"system_discuss\";s:1:\"1\";s:15:\"system_formsite\";s:1:\"1\";s:17:\"system_backupsite\";s:1:\"1\";s:17:\"system_spidersite\";s:1:\"1\";s:15:\"system_langsite\";s:1:\"1\";s:8:\"security\";s:1:\"1\";s:16:\"system_phonesite\";s:1:\"1\";s:16:\"system_guestbook\";s:1:\"1\";s:3:\"add\";s:1:\"1\";s:6:\"manage\";s:1:\"1\";s:11:\"interactive\";s:1:\"1\";s:7:\"content\";s:1:\"1\";s:8:\"category\";s:1:\"1\";s:13:\"category_list\";s:1:\"1\";s:12:\"category_add\";s:1:\"1\";s:13:\"category_edit\";s:1:\"1\";s:12:\"category_del\";s:1:\"1\";s:17:\"category_htmlrule\";s:1:\"1\";s:14:\"archive_import\";s:1:\"1\";s:7:\"archive\";s:1:\"1\";s:12:\"archive_list\";s:1:\"1\";s:11:\"archive_add\";s:1:\"1\";s:26:\"defined_field_category_add\";s:1:\"1\";s:12:\"archive_edit\";s:1:\"1\";s:11:\"archive_del\";s:1:\"1\";s:13:\"archive_check\";s:1:\"1\";s:15:\"archive_setting\";s:1:\"1\";s:17:\"archive_hotsearch\";s:1:\"1\";s:13:\"archive_image\";s:1:\"1\";s:11:\"archive_tag\";s:1:\"1\";s:5:\"mtype\";s:1:\"1\";s:9:\"type_list\";s:1:\"1\";s:8:\"type_add\";s:1:\"1\";s:9:\"type_edit\";s:1:\"1\";s:8:\"type_del\";s:1:\"1\";s:7:\"special\";s:1:\"1\";s:12:\"special_list\";s:1:\"1\";s:11:\"special_add\";s:1:\"1\";s:12:\"special_edit\";s:1:\"1\";s:11:\"special_del\";s:1:\"1\";s:4:\"user\";s:1:\"1\";s:11:\"user_manage\";s:1:\"1\";s:9:\"user_list\";s:1:\"1\";s:8:\"user_add\";s:1:\"1\";s:9:\"user_edit\";s:1:\"1\";s:8:\"user_del\";s:1:\"1\";s:11:\"user_ologin\";s:1:\"1\";s:11:\"user_invite\";s:1:\"1\";s:16:\"user_integration\";s:1:\"1\";s:10:\"user_group\";s:1:\"1\";s:14:\"usergroup_list\";s:1:\"1\";s:13:\"usergroup_add\";s:1:\"1\";s:14:\"usergroup_edit\";s:1:\"1\";s:13:\"usergroup_del\";s:1:\"1\";s:15:\"seo_consumption\";s:1:\"1\";s:11:\"seo_express\";s:1:\"1\";s:5:\"order\";s:1:\"1\";s:12:\"order_manage\";s:1:\"1\";s:13:\"system_orders\";s:1:\"1\";s:10:\"order_list\";s:1:\"1\";s:11:\"refund_list\";s:1:\"1\";s:9:\"order_del\";s:1:\"1\";s:10:\"order_edit\";s:1:\"1\";s:9:\"order_pay\";s:1:\"1\";s:15:\"order_logistics\";s:1:\"1\";s:4:\"func\";s:1:\"1\";s:12:\"func_announc\";s:1:\"1\";s:17:\"func_announc_list\";s:1:\"1\";s:16:\"func_announc_add\";s:1:\"1\";s:17:\"func_announc_edit\";s:1:\"1\";s:16:\"func_announc_del\";s:1:\"1\";s:9:\"func_book\";s:1:\"1\";s:14:\"func_book_list\";s:1:\"1\";s:15:\"func_book_reply\";s:1:\"1\";s:13:\"func_book_del\";s:1:\"1\";s:12:\"func_comment\";s:1:\"1\";s:17:\"func_comment_list\";s:1:\"1\";s:17:\"func_comment_edit\";s:1:\"1\";s:16:\"func_comment_del\";s:1:\"1\";s:11:\"func_ballot\";s:1:\"1\";s:16:\"func_ballot_list\";s:1:\"1\";s:15:\"func_ballot_add\";s:1:\"1\";s:16:\"func_ballot_edit\";s:1:\"1\";s:15:\"func_ballot_del\";s:1:\"1\";s:9:\"func_data\";s:1:\"1\";s:15:\"func_data_baker\";s:1:\"1\";s:17:\"func_data_restore\";s:1:\"1\";s:17:\"func_data_replace\";s:1:\"1\";s:19:\"func_data_adminlogs\";s:1:\"1\";s:14:\"func_data_safe\";s:1:\"1\";s:14:\"func_filecheck\";s:1:\"1\";s:9:\"func_scan\";s:1:\"1\";s:7:\"seo_tag\";s:1:\"1\";s:11:\"func_update\";s:1:\"1\";s:12:\"system_wxxcx\";s:1:\"1\";s:8:\"template\";s:1:\"1\";s:15:\"template_manage\";s:1:\"1\";s:15:\"system_template\";s:1:\"1\";s:15:\"template_visual\";s:1:\"1\";s:13:\"template_edit\";s:1:\"1\";s:17:\"template_downlist\";s:1:\"1\";s:12:\"system_slide\";s:1:\"1\";s:15:\"templatetag_add\";s:1:\"1\";s:23:\"templatetag_add_content\";s:1:\"1\";s:24:\"templatetag_add_category\";s:1:\"1\";s:23:\"templatetag_add_special\";s:1:\"1\";s:22:\"templatetag_add_define\";s:1:\"1\";s:26:\"templatetag_wap_add_define\";s:1:\"1\";s:16:\"templatetag_list\";s:1:\"1\";s:25:\"templatetag_list_function\";s:1:\"1\";s:23:\"templatetag_list_system\";s:1:\"1\";s:24:\"templatetag_list_content\";s:1:\"1\";s:25:\"templatetag_list_category\";s:1:\"1\";s:24:\"templatetag_list_special\";s:1:\"1\";s:23:\"templatetag_list_define\";s:1:\"1\";s:28:\"templatetag_wap_list_content\";s:1:\"1\";s:29:\"templatetag_wap_list_category\";s:1:\"1\";s:27:\"templatetag_wap_list_define\";s:1:\"1\";s:3:\"seo\";s:1:\"1\";s:10:\"seo_weixin\";s:1:\"1\";s:15:\"seo_weixin_list\";s:1:\"1\";s:14:\"seo_weixin_add\";s:1:\"1\";s:15:\"seo_weixin_edit\";s:1:\"1\";s:14:\"seo_weixin_del\";s:1:\"1\";s:10:\"seo_status\";s:1:\"1\";s:15:\"seo_status_list\";s:1:\"1\";s:14:\"seo_status_del\";s:1:\"1\";s:16:\"seo_status_clear\";s:1:\"1\";s:12:\"seo_linkword\";s:1:\"1\";s:17:\"seo_linkword_list\";s:1:\"1\";s:16:\"seo_linkword_add\";s:1:\"1\";s:17:\"seo_linkword_edit\";s:1:\"1\";s:16:\"seo_linkword_del\";s:1:\"1\";s:14:\"seo_friendlink\";s:1:\"1\";s:19:\"seo_friendlink_list\";s:1:\"1\";s:18:\"seo_friendlink_add\";s:1:\"1\";s:19:\"seo_friendlink_edit\";s:1:\"1\";s:18:\"seo_friendlink_del\";s:1:\"1\";s:22:\"seo_friendlink_setting\";s:1:\"1\";s:10:\"user_union\";s:1:\"1\";s:10:\"union_user\";s:1:\"1\";s:9:\"union_pay\";s:1:\"1\";s:11:\"union_visit\";s:1:\"1\";s:13:\"union_reguser\";s:1:\"1\";s:12:\"union_config\";s:1:\"1\";s:8:\"seo_mail\";s:1:\"1\";s:13:\"seo_mail_send\";s:1:\"1\";s:17:\"seo_mail_usersend\";s:1:\"1\";s:21:\"seo_mail_subscription\";s:1:\"1\";s:10:\"seo_coupon\";s:1:\"1\";s:14:\"seo_thirdparty\";s:1:\"1\";s:14:\"seo_xiongzhang\";s:1:\"1\";s:7:\"defined\";s:1:\"1\";s:21:\"defined_field_content\";s:1:\"1\";s:26:\"defined_field_content_list\";s:1:\"1\";s:25:\"defined_field_content_add\";s:1:\"1\";s:26:\"defined_field_content_edit\";s:1:\"1\";s:25:\"defined_field_content_del\";s:1:\"1\";s:18:\"defined_field_user\";s:1:\"1\";s:23:\"defined_field_user_list\";s:1:\"1\";s:22:\"defined_field_user_add\";s:1:\"1\";s:23:\"defined_field_user_edit\";s:1:\"1\";s:22:\"defined_field_user_del\";s:1:\"1\";s:12:\"defined_form\";s:1:\"1\";s:17:\"defined_form_list\";s:1:\"1\";s:16:\"defined_form_add\";s:1:\"1\";s:17:\"defined_form_edit\";s:1:\"1\";s:16:\"defined_form_del\";s:1:\"1\";s:5:\"cache\";s:1:\"1\";s:12:\"cache_manage\";s:1:\"1\";s:13:\"cache_content\";s:1:\"1\";s:14:\"cache_category\";s:1:\"1\";s:11:\"cache_index\";s:1:\"1\";s:10:\"cache_type\";s:1:\"1\";s:13:\"cache_special\";s:1:\"1\";s:9:\"cache_tag\";s:1:\"1\";s:11:\"cache_baidu\";s:1:\"1\";s:12:\"cache_google\";s:1:\"1\";s:16:\"cache_wap_manage\";s:1:\"1\";s:24:\"cache_manage_wap_content\";s:1:\"1\";s:25:\"cache_manage_wap_category\";s:1:\"1\";s:22:\"cache_manage_wap_index\";s:1:\"1\";s:21:\"cache_manage_wap_type\";s:1:\"1\";s:24:\"cache_manage_wap_special\";s:1:\"1\";s:20:\"cache_manage_wap_tag\";s:1:\"1\";s:12:\"cache_update\";s:1:\"1\";}','add_archive','0','1','1');-- 
INSERT INTO `cmseasy_usergroup` VALUES('1000','游客','0.0','','','0','0','1');-- 









