<?php

if (!defined('ROOT')) exit('Can\'t Access !');
class question_act extends act {

    public   $user = null;
    public   $html = "";

    function init() {
        $this->_question = new question();
        $this->_question_reply = new questionreply();
        $this->_question_like = new questionlike();
        $this->_question_type = new questiontype();
        $this->_question_tag = new questiontag();
        $this->_question_config = new questionconfig();
        $this->_question_reward = new questionreward();
        $this->_question_message = new questionmessage();
        $this->view->form = $this->_question->get_form();
        $this->view->field = $this->_question->getFields();
        $this->view->replyform = $this->_question_reply->get_form();
        $this->questionconfigdata = $this->_question_config->get_all_config(); //获取配置

        if(!$this->questionconfigdata['question_open']){
            alertinfo(lang('question_not_enabled'),url('index/index'));
        }

        if (front::get('page'))
            $page = front::get('page');
        else
            $page = 1;
        $this->view->page = $page;
        $this->pagesize = $this->questionconfigdata['question_pagesize'];
        $this->reply_pagesize = $this->questionconfigdata['reply_pagesize'];

        if (cookie::get('login_username') && session::get("username") && cookie::get('login_password')) {
            $user =user::getInstance()->getrow(array('username' => cookie::get('login_username')));
            if (cookie::get('login_password') != front::cookie_encode($user['password'])) {
                unset($user);
            }
        }
        $nologin_arr = array('questionlist','showquestion','taglist','typelist');
        $nologin_rteurn = array('likereply','reply','seemid','buyreward','banreply');
        if (!is_array($user) && !in_array(front::$act, $nologin_arr)) {
            if (in_array(front::$act, $nologin_rteurn)) {
                echo json_encode(array("state"=>0,"message"=>lang("请先登陆！"))); //删除失败
                exit;
            }
            front::redirect(url::create('user/login'));
        }else{
            $this->isadministrator=false;//当前用户是否管理员
            if (is_array($user)){
                $this->user=$user;
                $this->view->user_state=1;
                $groupisadmin=usergroup::getInstance()->getrow("groupid=".$this->user['groupid']);
            }

            if (is_array($groupisadmin))if ($groupisadmin['isadministrator'])$this->isadministrator=true;
        }
        $this->view->isadministrator=$this->isadministrator;  //当前用户是否管理员
        $this->view->questionconfigdata=$this->questionconfigdata ;  //传配置

    }
    //问题列表
    function questionlist_action(){
        if ($this->questionconfigdata['user_crossall']=="")
            $where = 'state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and (user_crossall="" or user_crossall IS NULL )';
        else
            $where = 'state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';

        //搜索
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::$post['keyword'] = trim(front::post('keyword'));
        if (front::post('keyword')) {
            $arr=array("!","@","#","$","%","^","&","*","(",")","[","]","|",",",".","<",">","{","}","=","+","-","；","'","\"","www.","http:://","https:://");
            $a=0;
            foreach($arr as $key=>$value){
                if(strpos(front::post('keyword'),$value)){
                    $a=1;
                }
            }
            if($a==1){
                echo "<script>alert(\"".lang('cannot_contain_special_characters')."！\"); location.href='".url("question/questionlist")."';</script>";
                exit;
            }
            //过滤特殊字符
            $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\\+|\/|\;|\'|\`|\-|\=|\\\|\|/";
            front::$post['keyword']=preg_replace($regex,"",front::$post['keyword']);
            $this->view->keyword=front::$post['keyword'];
            $where .= " and title like '%" . $this->view->keyword . "%'";
        }

        $ordre="topping desc";
        //排序
        if(isset(front::$get['sorting'])){
            if(front::$get['sorting'] == '0'){   //最新
                $ordre.= ",adddate desc";
            }
            else if(front::$get['sorting'] == '1'){  //热门
                $ordre.= ",browsenum desc";
            }else if(front::$get['sorting'] == '2'){  //悬赏(未做！！！)
                $where.=" and rewardmenoy>0 ";
            }
        }
        else{
            $ordre.= ",adddate desc";
        }
        //筛选分类
        if (front::get('typeid')){
            $where.=" and typeid=".front::get('typeid');
            $this->view->type =$this->_question_type->getrow('id='.front::get('typeid'));

        }
        //查询tag
        if(front::$get['tag']){
            $where.=" and FIND_IN_SET(".front::get('tag').",tag)";
            $this->view->tag =$this->_question_tag->getrow("id=".front::get('tag'),0);

        }
        if (front::$get['myquestion']){
            $where.=" and  uid=".$this->user['userid'];
        }
        if (front::$get['myseemid']){
            $where.=" and  FIND_IN_SET('".$this->user['userid']."',seemid)";
        }

        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $questiondata=$this->_question->getrows($where,$limit,$ordre);
        $userdata= user::getInstance()->getrows(null,0);
        $newuserdata=array();
        if (is_array($userdata))
            foreach ($userdata as $key=>$val){
                $newuserdata[$val['userid']]=$val;
            }
        foreach ($questiondata as $key=>$val){
            $questiondata[$key]['headimage']=$newuserdata[$val['uid']]['headimage'];
            $questiondata[$key]['username']=$newuserdata[$val['uid']]['username'];
            $questiondata[$key]['reply']=$this->_question_reply ->getrows("state=1 and  aid='".$val['id']."'", 0, 'adddate desc');
            $questiondata[$key]['reply_isadopt']=$this->_question_reply ->getrow("state=1 and  isadopt=1 and aid='".$val['id']."'");
            $questiondata[$key]['type']=$this->_question_type->getrow('id='.$val['typeid']);
            //设置了仅管理员可见
            if($val['isadminsee'] && $val['uid']!=$this->user['userid']){
                unset($questiondata[$key]);
            }
            //全局 仅会员可见
            if($this->questionconfigdata['question_vip_see'] && $this->user['groupid']=='1000' && $val['uid']!=$this->user['userid']){
                unset($questiondata[$key]);
            }
            //显示tag
            $tagid= explode(',', $val['tag']);
            $question_tagarray=array();
            if ($val['tag']!="")
                for($index=0;$index<count($tagid);$index++){
                    $question_tagarray[$index]=$this->_question_tag->getrow("id=".$tagid[$index],0);
                }
            $questiondata[$key]['tagarray']=$question_tagarray;
            //校验用户组的积分权限
            if ($val['usergroupid']){
                $usergroupintegrationclaim=usergroup::getintegrationclaim($val['usergroupid']);
                if ((!$this->view->user_state  || $usergroupintegrationclaim>$this->user['integration']) && !$this->isadministrator) {
                    unset($questiondata[$key]);
                }
            }
            //校验未回答的
            if(front::$get['sorting'] == '3'){
                if (count($questiondata[$key]['reply'])!=0){
                    unset($questiondata[$key]);
                }

            }
        }

        $questiontype=questiontype::getInstance()->getrows("state=1 and langid=".lang::getlangid(lang::getistemplate()),0);
        if (is_array($questiontype))
            foreach ($questiontype as $key=>$val){
                if ($this->isadministrator)
                    $questiontype[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and typeid=".$val['id']);
                else
                    $questiontype[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and isadminsee=0 and typeid=".$val['id']);
            }

        $this->view->questiontype =$questiontype;  //分类
        if (!front::get('typeid'))front::$get['typeid']=0;
        $this->view->typeid =front::$get['typeid'];  //分类id
        if (!front::get('sorting'))front::$get['sorting']=0;
        $this->view->sorting =front::$get['sorting'];  //最新最热
        $this->view->data =$questiondata;
        $this->view->record_count = $this->_question->rec_count($where);
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数
    }
    //tag列表----热门列表
    function taglist_action(){
        $where = 'langid = "'.lang::getlangid(lang::getistemplate()).'"';
        //搜索
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::$post['keyword'] = trim(front::post('keyword'));
        if (front::post('keyword')) {
            $arr=array("!","@","#","$","%","^","&","*","(",")","[","]","|",",",".","<",">","{","}","=","+","-","；","'","\"","www.","http:://","https:://");
            $a=0;
            foreach($arr as $key=>$value){
                if(strpos(front::post('keyword'),$value)){
                    $a=1;
                }
            }
            if($a==1){
                echo "<script>alert(\"".lang('cannot_contain_special_characters')."！\"); location.href='".url("question/taglist")."';</script>";
                exit;
            }
            //过滤特殊字符
            $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\\+|\/|\;|\'|\`|\-|\=|\\\|\|/";
            front::$post['keyword']=preg_replace($regex,"",front::$post['keyword']);
            $this->view->keyword=front::$post['keyword'];
            $where .= " and tagname like '%" . $this->view->keyword . "%'";
        }

        //排序
        $ordre = "adddate desc";
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $questiontagdata=$this->_question_tag->getrows($where,$limit,$ordre);
        foreach ($questiontagdata as $key=>$val){
            if ($this->isadministrator)
                $questiontagdata[$key]['tagnum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and FIND_IN_SET(".$val['id'].',tag)');
            else
                $questiontagdata[$key]['tagnum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and isadminsee=0 and FIND_IN_SET(".$val['id'].',tag)');
        }
        $questiontagdata=$this->arr_sort($questiontagdata,'tagnum');

        $this->view->data =$questiontagdata;
        $this->view->record_count = $this->_question_tag->rec_count($where);
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数


    }
    //专题列表
    function typelist_action(){
        $where = 'langid = "'.lang::getlangid(lang::getistemplate()).'"';
        //搜索
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::$post['keyword'] = trim(front::post('keyword'));
        if (front::post('keyword')) {
            $arr=array("!","@","#","$","%","^","&","*","(",")","[","]","|",",",".","<",">","{","}","=","+","-","；","'","\"","www.","http:://","https:://");
            $a=0;
            foreach($arr as $key=>$value){
                if(strpos(front::post('keyword'),$value)){
                    $a=1;
                }
            }
            if($a==1){
                echo "<script>alert(\"".lang('cannot_contain_special_characters')."！\"); location.href='".url("question/typelist")."';</script>";
                exit;
            }
            //过滤特殊字符
            $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\\+|\/|\;|\'|\`|\-|\=|\\\|\|/";
            front::$post['keyword']=preg_replace($regex,"",front::$post['keyword']);
            $this->view->keyword=front::$post['keyword'];
            $where .= " and typename like '%" . $this->view->keyword . "%'";
        }

        //排序
        $ordre = "adddate desc";
        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $questiontypedata=$this->_question_type->getrows($where,$limit,$ordre);
        foreach ($questiontypedata as $key=>$val){
            if ($this->isadministrator)
                $questiontypedata[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and typeid=".$val['id']);
            else
                $questiontypedata[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and isadminsee=0 and typeid=".$val['id']);
        }
        $questiontypedata=$this->arr_sort($questiontypedata,'typenum');

        $this->view->data =$questiontypedata;
        $this->view->record_count = $this->_question_type->rec_count($where);
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数


    }
    //与我相关
    function message_action(){
        $where = 'langid = "'.lang::getlangid(lang::getistemplate()).'" and uid='.$this->user['userid'].' and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';
        //搜索
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::$post['keyword'] = trim(front::post('keyword'));
        if (front::post('keyword')) {
            $arr=array("!","@","#","$","%","^","&","*","(",")","[","]","|",",",".","<",">","{","}","=","+","-","；","'","\"","www.","http:://","https:://");
            $a=0;
            foreach($arr as $key=>$value){
                if(strpos(front::post('keyword'),$value)){
                    $a=1;
                }
            }
            if($a==1){
                echo "<script>alert(\"".lang('cannot_contain_special_characters')."！\"); location.href='".url("question/questionlist")."';</script>";
                exit;
            }
            //过滤特殊字符
            $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\\+|\/|\;|\'|\`|\-|\=|\\\|\|/";
            front::$post['keyword']=preg_replace($regex,"",front::$post['keyword']);
            $this->view->keyword=front::$post['keyword'];
            $where .= " and title like '%" . $this->view->keyword . "%'";
        }

        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $messagedata=$this->_question_message->getrows($where,$limit,"see desc,adddate desc");
        foreach ($messagedata as $key=>$val){
            $userdata= user::getInstance()->getrow("userid='".$val['uid']."'");
            $messagedata[$key]['headimage']=$userdata['headimage'];
            $messagedata[$key]['username']=$userdata['username'];
        }

        $questiontype=questiontype::getInstance()->getrows("state=1 and langid=".lang::getlangid(lang::getistemplate()),0);
        if (is_array($questiontype))
            foreach ($questiontype as $key=>$val){
                if ($this->isadministrator)
                    $questiontype[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and typeid=".$val['id']);
                else
                    $questiontype[$key]['typenum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and isadminsee=0 and typeid=".$val['id']);
            }
        $this->view->questiontype =$questiontype;  //分类
        $this->view->data =$messagedata;
        $this->view->record_count = $this->_question_message->rec_count($where);
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数

    }
    //草稿箱
    function draftquestion_action(){

        if ($this->questionconfigdata['user_crossall']=="")
            $where = 'state=0 and langid = "'.lang::getlangid(lang::getistemplate()).'" and  uid='.$this->user['userid'].' and (user_crossall="" or user_crossall IS NULL )';

        else
            $where = 'state=0 and langid = "'.lang::getlangid(lang::getistemplate()).'" and  uid='.$this->user['userid'].' and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';;

        //搜索
        if (front::get('keyword') && !front::post('keyword'))
            front::$post['keyword'] = front::get('keyword');
        front::$post['keyword'] = trim(front::post('keyword'));
        if (front::post('keyword')) {
            $arr=array("!","@","#","$","%","^","&","*","(",")","[","]","|",",",".","<",">","{","}","=","+","-","；","'","\"","www.","http:://","https:://");
            $a=0;
            foreach($arr as $key=>$value){
                if(strpos(front::post('keyword'),$value)){
                    $a=1;
                }
            }
            if($a==1){
                echo "<script>alert(\"".lang('cannot_contain_special_characters')."！\"); location.href='".url("question/questionlist")."';</script>";
                exit;
            }
            //过滤特殊字符
            $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\\+|\/|\;|\'|\`|\-|\=|\\\|\|/";
            front::$post['keyword']=preg_replace($regex,"",front::$post['keyword']);
            $this->view->keyword=front::$post['keyword'];
            $where .= " and title like '%" . $this->view->keyword . "%'";
        }

        //排序
        if(isset(front::$get['sorting'])){
            if(front::$get['sorting'] == '0'){   //最新
                $ordre = "adddate desc";
            }
            else if(front::$get['sorting'] == '1'){  //热门
                $ordre = "browsenum desc";
            }else if(front::$get['sorting'] == '2'){  //悬赏
                $where.=" and rewardmenoy>0 ";
            }
        }
        else{
            $ordre = "adddate desc";
        }
        //筛选分类
        if (front::get('typeid')){
            $where.=" and typeid=".front::get('typeid');
        }
        //查询tag
        if(front::$get['tag']){
            $where.=" and FIND_IN_SET(".front::get('tag').",tag)";
        }

        $limit = (($this->view->page - 1) * $this->pagesize) . ',' . $this->pagesize;
        $questiondata=$this->_question->getrows($where,$limit,$ordre);
        $userdata= user::getInstance()->getrows(null,0);
        $newuserdata=array();
        if (is_array($userdata))
            foreach ($userdata as $key=>$val){
                $newuserdata[$val['userid']]=$val;
            }
        foreach ($questiondata as $key=>$val){
            $questiondata[$key]['headimage']=$newuserdata[$val['uid']]['headimage'];
            $questiondata[$key]['username']=$newuserdata[$val['uid']]['username'];
            $questiondata[$key]['reply']=$this->_question_reply ->getrows("state=1 and  aid='".$val['id']."'", 0, 'adddate desc');
            $questiondata[$key]['reply_isadopt']=$this->_question_reply ->getrow("state=1 and  isadopt=1 and aid='".$val['id']."'");
            $questiondata[$key]['type']=$this->_question_type->getrow('id='.$val['typeid']);
            if(front::$get['sorting'] == '3'){    //校验未回答的
                if (count($questiondata[$key]['reply'])!=0)
                    unset($questiondata[$key]);
            }
            //显示tag
            $tagid= explode(',', $val['tag']);
            $question_tagarray=array();
            for($index=0;$index<count($tagid);$index++){
                $question_tagarray[$index]=$this->_question_tag->getrow("id=".$tagid[$index],0);
            }
            $questiondata[$key]['tagarray']=$question_tagarray;
        }

        $questiontype=questiontype::getInstance()->getrows("state=1 and langid=".lang::getlangid(lang::getistemplate()),0);
        if (is_array($questiontype))
            foreach ($questiontype as $key=>$val){
                $questiontype[$key]['typenum']=$this->_question->rec_count("state=0 and user_crossall='".$this->questionconfigdata['user_crossall']."' and typeid=".$val['id']);

            }
        $this->view->questiontype =$questiontype;  //分类
        if (!front::get('typeid'))front::$get['typeid']=0;
        $this->view->typeid =front::$get['typeid'];  //分类id
        if (!front::get('sorting'))front::$get['sorting']=0;
        $this->view->sorting =front::$get['sorting'];  //最新最热
        $this->view->data =$questiondata;
        $this->view->record_count = $this->_question->rec_count($where);
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数



    }
    //新增问题
    function addquestion_action(){

        if($this->questionconfigdata['question_vip'] && $this->user['groupid']=="1000"){
            alertinfo(lang('only_members_can_publish'), url('question/questionlist'));
        }
        if(front::$post['submit']){
            //判断连续间隔
            if (front::$post['submit']==1 && $this->questionconfigdata['add_question_time']>0){
                $oldquestion = $this->_question->getrow("state=1 and uid=".$this->user['userid'],"adddate desc");
                if (is_array($oldquestion)){
                    $thisdata=date('Y-m-d H:i:s', time());
                    $oldadddate=$oldquestion['adddate'];
                    $newdata=floor((strtotime($thisdata)-strtotime($oldadddate))%86400)/60;
                    if($newdata<$this->questionconfigdata['add_question_time']){
                        alerterror(lang('frequent_operation'));
                    }
                }

            }
            if($this->questionconfigdata['question_verifycode']==1) {
                if (!session::get('verify') || front::post('verify') <> session::get('verify')) {
                    alerterror(lang('verification_code'));
                    return;
                }
            }
            else if($this->questionconfigdata['question_verifycode'] == 2){
                if (!verify::checkGee()) {
                    alerterror(lang('verification_code'));
                    return;
                }
            }
            front::$post['content'] = htmlspecialchars_decode(front::$post['content']);

            //兼容单引号
            //front::$post['content']=str_replace("'", "\'", front::$post['content']);

            front::$post['adddate']=date('Y-m-d H:i:s', time());
            front::$post['updatedate']=date('Y-m-d H:i:s', time());
            front::$post['uid']=$this->user['userid'];
            front::$post['browsenum']=0;    //浏览数
            front::$post['ip']=front::ip();    //ip
            front::$post['user_crossall']=$this->questionconfigdata['user_crossall'];    //跨域
            front::$post['langid']=lang::getlangid(lang::getistemplate());    //语言
            if($this->questionconfigdata['andswer_audit'])
                front::$post['state']=front::$post['submit']=="1"?2:0;
            else
                front::$post['state']=front::$post['submit']=="1"?1:0;

            //悬赏的时候  扣除当前用户的余额
            if (front::$post['state']==1 && front::$post['rewardmenoy']>0){
                //剩余余额 --当前用户
                if(getmenoy()<front::$post['rewardmenoy']){
                    alerterror(lang('insufficient_balance_please_recharge_first'));
                    return;
                }
                $sheyumenoy=getmenoy()-front::$post['rewardmenoy'];
                user::getInstance()->rec_update(array('menoy' => $sheyumenoy), "userid='".$this->user['userid']."'"); //剩余余额
            }


            $insert = $this->_question->rec_insert(front::$post);
            $_insertid = $this->_question->insert_id();
            //$_insertid = $this->_question->insert_id();
            if ($insert < 1) {
                front::alert(lang('public_failure'));  //发布失败
            }
            else {
                //悬赏的时候  扣除当前用户的余额
                if (front::$post['state']==1 && front::$post['rewardmenoy']>0){
                    //新增悬赏记录
                    $rewarddata=array("uid"=>$this->user['userid'],"adddate"=>date('Y-m-d H:i:s', time()),
                        "rid"=>$_insertid,"menoy"=>front::$post['rewardmenoy'],"type"=>2,"rewarduid"=>0,"state"=>0);
                    $this->_question_reward->rec_insert($rewarddata);
                }
                front::flash(lang('public_success'));
                front::redirect(url::create('question/questionlist'));
            }
        }
        $this->view->tagdata=$this->_question_tag->getrows(null,0);
    }
    //打开问题
    function showquestion_action(){
        front::$get['id'] = intval(front::get('id'));
        if(front::$get['id']){
            $questiondata=$this->_question->getrow("id=".front::$get['id']);
            //全局 仅会员可见
            if($this->questionconfigdata['question_vip_see'] && $this->user['groupid']=='1000' && $questiondata['uid']!=$this->user['userid']){
                alertinfo("仅会员可见！",url('question/questionlist'));
            }
            //校验用户组的积分权限
            if ($questiondata['usergroupid']){
                $usergroupintegrationclaim=usergroup::getintegrationclaim($questiondata['usergroupid']);
                if ((!$this->view->user_state  || $usergroupintegrationclaim>$this->user['integration']) && !$this->isadministrator) {
                    alertinfo(lang('insufficient_points_do_not_have_permission_to_open'), url('question/questionlist'));
                }
            }
            /*   $content = htmlspecialchars_decode($questiondata['content']);*/
            $content = $questiondata['content'];
            $content=$this->_question->add_a_http($content);

            $questiondata['browsenum']=$questiondata['browsenum']+1; //浏览数加1
            unset($questiondata['content']);
            $this->_question->rec_update($questiondata, "id=".front::$get['id']);
            if ($this->view->user_state) {
                $this->_question_message->rec_update(array("see" => 0), "aid=" . front::$get['id'] . ' and uid=' . $this->user['userid']);  //消息通知 改为已读
            }
            $userdata= user::getInstance()->getrow("userid='".$questiondata['uid']."'");
            $questiondata['user']=$userdata;
            $questiondata['content']=$content;
            /* $questiondata['content'] = htmlspecialchars_decode($questiondata['content']);*/
            $questiondata['reply']=$this->reply();
            $questiondata['reply_isadopt']=$this->_question_reply ->getrow(" state=1 and  isadopt=1 and aid='".front::$get['id']."'");
            if ($questiondata['typeid'])
                $questiondata['type']=$this->_question_type->getrow('id='.$questiondata['typeid']);
            //获取当前问题的tag
            if ($questiondata['tag']!=""){
                $tagwhere="";
                $tagid=explode(',',$questiondata['tag']);
                if (is_array($tagid))
                    for($index=0;$index<count($tagid);$index++){
                        $tagwhere.=$tagwhere==""?"FIND_IN_SET(".$tagid[$index].",id) ":" or FIND_IN_SET(".$tagid[$index].",id) ";
                    }
                $questiondata['tagdata']=$this->_question_tag->getrows($tagwhere,0);
            }
            //判断当前问题的赞
            if ($this->view->user_state) {
                $zanstate = $this->_question_like->getrow("aid='" . $questiondata['id'] . "' and mid=" . $this->user['userid']);
                $like_count = $this->_question_like->rec_count("aid='" . $questiondata['id'] . "'");
                if (!is_array($zanstate))
                    $questiondata['like'] = '<a class="btn btn-default btn-sm praise" onclick="likequestion(this);" data-replyid="' . $questiondata['id'] . '"><i class="glyphicon glyphicon-eject"></i>' . lang('praise') . '(' . $like_count . ')</a>';
                else
                    $questiondata['like'] = '<a class="btn btn-default btn-sm praise" onclick="nolikequestion(this);" data-replyid="' . $questiondata['id'] . '"><i class="glyphicon glyphicon-eject"></i>' . lang('cancel_praise') . '(' . $like_count . ')</a>';
            }


            //是否可以编辑 限时编辑 校验
            $thisdata=date('Y-m-d H:i:s', time());
            $oldadddate=$questiondata['adddate'];
            $newdata=floor((strtotime($thisdata)-strtotime($oldadddate))%86400)/3600;   //计算出时间差
            if($newdata<$this->questionconfigdata['question_edit'])$questiondata['edit']=true; else $questiondata['edit']=false;

            $seemid=explode(',',$questiondata['seemid']);
            $seemidstate=false; //关注状态
            if (is_array($seemid))
                for($index=0;$index<count($seemid);$index++){
                    if ($seemid[$index]==$this->user['userid'])
                        $seemidstate=true;
                }

            $this->view->seemid =$seemidstate;
            $this->view->data =$questiondata;
            $this->view->question =$questiondata;


            //相关问题
            $xswhere = 'state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and id!='.$questiondata['id'].' and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';
            if ($questiondata['tag']){
                $xswhere.=" and (";
                $tagid= explode(',', $questiondata['tag']);
                for($index=0;$index<count($tagid);$index++){
                    if ($index!=0)  $xswhere.=" or ";
                    $xswhere.="FIND_IN_SET(".$tagid[$index].",tag)";
                }
                $xswhere.=" )";
            }
            $xsquestion=$this->_question->getrows($xswhere,10,"RAND()");
            $this->view->xsquestion=$xsquestion;  //tag

        }
    }
    //编辑问题
    function editquestion_action(){
        front::$get['id'] = intval(front::get('id'));
        if(front::$get['id']){
            $questiondata=$this->_question->getrow("id=".front::$get['id']);
            if ($questiondata['uid']==$this->user['userid'] || $this->isadministrator){
                if(front::$post['submit']){
                    front::$post['content'] = htmlspecialchars_decode(front::$post['content']);
                    if($this->questionconfigdata['question_verifycode']==1) {
                        if (!session::get('verify') || front::post('verify') <> session::get('verify')) {
                            alerterror(lang('verification_code'));
                            return;
                        }
                    }else if($this->questionconfigdata['question_verifycode'] == 2){
                        if (!verify::checkGee()) {
                            alerterror(lang('verification_code'));
                            return;
                        }
                    }
                    front::$post['updatedate']=date('Y-m-d H:i:s', time());
                    unset(front::$post['id']);
                    if(front::$get['draft']){
                        front::$post['state']=1;
                        //判断悬赏的打开
                        if ($questiondata['rewardmenoy']>0 ){
                            $this->add_question_reward($questiondata);
                        }
                    }
                    $this->_question->rec_update(front::$post, "id=".front::$get['id']);
                    front::flash(lang('edit').lang('success'));
                    if(front::$get['draft']) front::redirect(url::create('question/draftquestion'));
                    else  front::redirect(url::create('question/questionlist'));
                }else{
                    $questiondata['content'] =str_replace(array("\r\n", "\r", "\n"), "",$questiondata['content']);
                    $this->view->data =$questiondata;
                    $this->view->tagdata=$this->_question_tag->getrows(null,0);
                    $this->render('question/addquestion.html');
                }
            }
        }
    }

    function add_question_reward($questiondata){
        //剩余余额 --当前用户
        $rewarduser=user::getInstance()->getrow("userid='".$questiondata['uid']."'");
        if($rewarduser['menoy']<$questiondata['rewardmenoy']){
            alerterror(lang('insufficient_balance_please_recharge_first'));
            return;
        }
        //剩余金额
        $rewardusermenoy=$rewarduser['menoy']-$questiondata['rewardmenoy'];
        user::getInstance()->rec_update(array('menoy' => $rewardusermenoy), "userid='".$questiondata['uid']."'");
        //新增悬赏记录
        $rewarddata=array("uid"=>$this->user['userid'],"adddate"=>date('Y-m-d H:i:s', time()),
            "rid"=>front::$get['id'],"menoy"=>$questiondata['rewardmenoy'],"type"=>2,"rewarduid"=>0,"state"=>0);
        $this->_question_reward->rec_insert($rewarddata);
    }
    //回复评论
    function  reply_action(){
        front::$post['aid'] = intval(front::post('aid'));
        if(front::$post['aid'] && front::$post['content_reply']){
            //编辑还是新增
            if (front::$post['reply_update']){
                $this->_question_reply->rec_update(array("content"=>htmlspecialchars_decode(front::$post['content_reply'])), "id=".front::$post['id']);
                echo json_encode(array("state"=>1,"message"=>lang("update").lang("success")));
                exit;
            }else{
                if($this->questionconfigdata['reply_verifycode']==1) {
                    if (!session::get('verify') || front::post('verify') <> session::get('verify')) {
                        echo json_encode(array("state"=>0,"message"=>lang('verification_code')));
                        exit;
                    }
                }else if($this->questionconfigdata['reply_verifycode'] == 2){
                    if (!verify::checkGee()) {
                        echo json_encode(array("state"=>0,"message"=>lang('verification_code')));
                        exit;
                    }
                }
                front::$post['mid']=$this->user['userid'];
                front::$post['pid']=intval(front::$post['id']);
                front::$post['content']=htmlspecialchars_decode(front::$post['content_reply']);
                front::$post['adddate']=date('Y-m-d H:i:s', time());
                front::$post['langid']=lang::getlangid(lang::getistemplate());    //语言
                front::$post['user_crossall']=$this->questionconfigdata['user_crossall'];    //跨域
                $floor=$this->_question_reply->rec_count("aid=".front::$post['aid'].' and langid='.lang::getlangid(lang::getistemplate()));
                front::$post['floor']=$floor+1;    //楼层
                if($this->questionconfigdata['reply_audit'])  //打开待审功能
                    front::$post['state']=2;
                else
                    front::$post['state']=1;
                unset(front::$post['id']);
                unset(front::$post['content_reply']);
                $insert = $this->_question_reply->rec_insert(front::$post);
                if ($insert) {
                    //增加通知
                    if (front::$post['state']==1){
                        questionmessage::message_add(0,front::$post['aid'],2,0,1,$this->questionconfigdata['user_crossall']);
                    }

                    echo json_encode(array("state"=>1,"message"=>lang("reply").lang("success")));
                    exit;
                }
            }

        }
        echo json_encode(array("state"=>0,"message"=>lang("reply").lang("failure")));
        exit;
    }
    //关注
    function  seemid_action(){
        front::$post['id'] = intval(front::post('id'));
        if(front::$post['id']){
            $questiondata=$this->_question->getrow("id=".front::$post['id']);
            $seemid=explode(',',$questiondata['seemid']);
            $seemidstate=false;
            $new_seemid="";
            if (is_array($seemid))
                for($index=0;$index<count($seemid);$index++){
                    if ($seemid[$index]==$this->user['userid']){
                        $seemidstate=true;
                        continue;
                    }
                    $new_seemid.=$new_seemid?','.$seemid[$index]:$seemid[$index];
                }
            if (!$seemidstate && $questiondata['seemid']!=$this->user['userid']){
                $new_seemid.=$new_seemid?','.$this->user['userid']:$this->user['userid'];
                echo json_encode(array("state"=>1,"message"=>lang("attention").lang("success")));
            }else{
                echo json_encode(array("state"=>0,"message"=>lang("giveup").lang("attention").lang("success")));
            }
            $this->_question->rec_update(array("seemid"=>$new_seemid), "id=".front::$post['id']);
            exit;

        }
    }
    //打赏
    function  buyreward_action(){
        front::$post['rewardid'] = intval(front::post('rewardid'));
        if(front::$post['rewardid']){
            $rewardmenoy=front::$post['rewardmenoy'];
            $question_reply=$this->_question_reply->getrow("id=".front::$post['rewardid']);
            if ($rewardmenoy > getmenoy()){
                echo json_encode(array("state"=>0,"message"=>lang("insufficient_balance_please_recharge_first")));
                exit;
            }
            //剩余余额 --当前用户
            $sheyumenoy=getmenoy()-$rewardmenoy;
            user::getInstance()->rec_update(array('menoy' => $sheyumenoy), "userid='".$this->user['userid']."'"); //剩余余额
            //剩余余额 --被打赏用户
            $rewarduser=user::getInstance()->getrow("userid='".$question_reply['mid']."'");
            $rewardusermenoy=$rewarduser['menoy']+$rewardmenoy;
            user::getInstance()->rec_update(array('menoy' => $rewardusermenoy), "userid='".$question_reply['mid']."'");
            //合计打赏
            $allrewardmenoy=$question_reply['rewardmenoy']+$rewardmenoy;
            $this->_question_reply->rec_update(array('rewardmenoy' => $allrewardmenoy), "id=".front::$post['rewardid']);
            //增加通知
            questionmessage::message_add($question_reply['mid'],$question_reply['aid'],4,$rewardmenoy,1,$this->questionconfigdata['user_crossall']);
            //新增消费记录
            $xfconsumption = new xfconsumption();
            $xfconsumptiondata = array();
            $xfconsumptiondata['status'] = '1';
            $payname ='yuer';
            $xfconsumptiondata['mid'] = $this->user['userid'] ? $this->user['userid'] : 0;
            $xfconsumptiondata['oid'] = date('YmdHis') . '-' . $xfconsumptiondata['mid'] . '-' . $payname;
            $xfconsumptiondata['menoy'] = $rewardmenoy;
            $xfconsumptiondata['content'] = lang('reward');
            $xfconsumptiondata['adddate'] = date('Y-m-d H:i:s', time());
            $xfconsumptiondata['xftype'] =6;  //消费类型(1/商品消费 2/充值记录 3/插件模板消费 4/阅读下载购买 5/购买授权消费 6/问答打赏 )
            $xfconsumptiondata['trade_no'] = '';
            //判断跨域
            if ($this->questionconfigdata['user_crossall_state']){
                $tbname = $xfconsumption->name;
                $sql = $xfconsumption->sql_insert($tbname, $xfconsumptiondata);
                $sql=user::lockString($sql,"sql");
                $url=$this->questionconfigdata['user_crossall']."/index.php?case=crossall&act=execupdate&sql=".$sql;
                $data= service::cmseayurl($url);
            }
            $xfconsumptiondata['user_crossall'] = $this->questionconfigdata['user_crossall'];
            $xfconsumption->rec_insert($xfconsumptiondata);


            //新增打赏记录
            $rewarddata=array("uid"=>$this->user['userid'],"adddate"=>date('Y-m-d H:i:s', time()),
                "rid"=>front::$post['rewardid'],"menoy"=>$rewardmenoy,"type"=>1,"rewarduid"=>$question_reply['mid']);
            $this->_question_reward->rec_insert($rewarddata);
            echo json_encode(array("state"=>1,"message"=>lang("reward").lang("success")));
            exit;

        }
    }
    //关闭
    function closequestion_action(){
        front::$get['id'] = intval(front::get('id'));
        if(front::$get['id']){
            $this->_question->rec_update(array("state"=>4), "id=".front::$get['id']);
            //判断悬赏的打开
            $questiondata=$this->_question->getrow("id=".front::$get['id']);
            $questionreply_isadopt=$this->_question_reply ->getrow(" state=1 and  isadopt=1 and aid='".front::$get['id']."'");
            if ($questiondata['rewardmenoy']>0 && !is_array($questionreply_isadopt)){
                //还原金额
                $rewarduser=user::getInstance()->getrow("userid='".$questiondata['uid']."'");
                $rewardusermenoy=$rewarduser['menoy']+$questiondata['rewardmenoy'];
                user::getInstance()->rec_update(array('menoy' => $rewardusermenoy), "userid='".$questiondata['uid']."'");
                //删除记录
                $this->_question_reward->rec_delete('rid='.front::$get['id']);
            }



        }
        front::flash(lang('close').lang('success'));
        front::redirect(url('question/showquestion/id/'.front::$get['id']));
    }
    //发布问题
    function draft_action(){
        front::$get['id'] = intval(front::get('id'));
        if(front::$get['id']){
            $this->_question->rec_update(array("state"=>1), "id=".front::$get['id']);

            //判断悬赏的打开
            $questiondata=$this->_question->getrow("id=".front::$get['id']);
            if ($questiondata['rewardmenoy']>0 ){
                $this->add_question_reward($questiondata);

            }
        }
        front::flash(lang('close').lang('success'));
        front::redirect(url('question/draftquestion'));
    }
    //打开
    function openquestion_action(){
        front::$get['id'] = intval(front::get('id'));
        if(front::$get['id']){
            $this->_question->rec_update(array("state"=>1), "id=".front::$get['id']);

            //判断悬赏的打开
            $questiondata=$this->_question->getrow("id=".front::$get['id']);
            $questionreply_isadopt=$this->_question_reply ->getrow(" state=1 and  isadopt=1 and aid='".front::$get['id']."'");
            if ($questiondata['rewardmenoy']>0 && !is_array($questionreply_isadopt)){
                $this->add_question_reward($questiondata);
            }
        }
        front::flash(lang('open').lang('success'));
        front::redirect(url('question/showquestion/id/'.front::$get['id']));
    }
    //全部评论
    function  reply(){
        $aid = intval(front::get('id'));
        if ($this->questionconfigdata['user_crossall']=="")
            $where = 'id="'.$aid.'" and (user_crossall="" or user_crossall IS NULL )';
        else
            $where = 'id="'.$aid.'" and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';

        $_question = $this->_question ->getrow($where);//当前问答
        $limit = (($this->view->page - 1) * $this->reply_pagesize) . ',' . $this->reply_pagesize;
        $where="(state=0 or state=1)  and aid='$aid'"." and user_crossall='".$this->questionconfigdata['user_crossall']."'";

        if (front::$get['reply_ordre']==1){
            $order="adddate asc";
        }else if (front::$get['reply_ordre']==2){
            $order="adddate desc";
        }else{
            $order="adddate asc";
        }
        $_question_reply  = $this->_question_reply ->getrows($where, $limit,$order);

        $this->view->record_count = $this->_question_reply->rec_count($where);  //总条数
        if($this->view->record_count<$this->pagesize){
            $allindex=1;
        }else{
            $allindex=ceil($this->view->record_count/$this->pagesize);
        }
        $this->view->allindex=$allindex; //总页数

        $cats=array();
        $_adoptquestion=array();
        $userdata= user::getInstance()->getrows(null,0);
        $newuserdata=array();
        if (is_array($userdata))
            foreach ($userdata as $key=>$val){
                $newuserdata[$val['userid']]=$val;
            }
        foreach($_question_reply as $key=>$questionreply){
            $questionreply['user']['headimage']=$newuserdata[$questionreply['mid']]['headimage']?$newuserdata[$questionreply['mid']]['headimage']:'/images/pic.png';
            $questionreply['user']['username']=$newuserdata[$questionreply['mid']]['username'];
            $questionreply['user']['groupid']=$userdata['groupid'];
            $questionreply['like']= $this->_question_like->getrows("rid='".$questionreply['id']."'");
            $questionreply['like_count']= $this->_question_like->rec_count("rid='".$questionreply['id']."'");
            if ($questionreply['isadopt']){ //已经被采纳的查询
                $_adoptquestion=$questionreply;
            }
            $cats[$questionreply['id']]=$questionreply;
        }

        foreach($cats as $key=>$questionreply){
            if (isset($cats[$questionreply['pid']]))
                $cats[$key]['last_reply']=&$cats[$questionreply['pid']];
        }

        $this->html='<ul>';
        if ($this->view->page==1 && is_array($_adoptquestion) && count($_adoptquestion)>0){
            $newcats[0]=$_adoptquestion;  //用于循环采纳的
            $this->reply_show($newcats,$aid,$_question['uid'],$_adoptquestion,$_question['state']); //显示采纳的
        }
        unset($cats[$_adoptquestion['id']]);
        $cats=$this->arr_sort($cats,'like_count');                      //排序点赞的
        $this->reply_show($cats,$aid,$_question['uid'],$_adoptquestion,$_question['state']);        //不采纳的
        $this->html.='</ul>';
        return $this->html;
    }
    //排序
    function arr_sort($array,$key,$order="desc"){ //asc是升序 desc是降序
        $arr_nums=$arr=array();
        foreach($array as $k=>$v){
            $arr_nums[$k]=$v[$key];
        }
        if($order=='asc'){
            asort($arr_nums);
        }else{
            arsort($arr_nums);
        }
        foreach($arr_nums as $k=>$v){
            $arr[$k]=$array[$k];
        }
        return $arr;
    }

    function  reply_show($cats,$aid,$uid,$_adoptquestion,$state){
        foreach ($cats as $key=>$val){
            $yes_caina=false;  //已经被采纳
            $no_caina=false;   //采纳

            if ($val['mid']!=$uid) {   //不可采纳自己帖子的自己的回答
                if (is_array($_adoptquestion) && $_adoptquestion['id'] == $val['id']) {
                    $yes_caina=true;
                } else
                    if (count($_adoptquestion)==0 && $uid==$this->user['userid']) {
                        $no_caina=true;
                    }
            }
            if ($yes_caina)
                $this->html.='<div class="adopt">';
            else
                $this->html.='<div class="no-adopt">';



            $this->html.='<div class="question-item">';
            $this->html.='<div class="question-item-user-info"><span class="question-user-photo">';
            $this->html.='<img src="'.$val['user']['headimage'].'" alt="..." class="img-responsive img-circle">';
            $this->html.='</span>';
            $this->html.='<span class="pull-left"><p class="username">'.$val['user']['username'].'</p>';

            $this->html.='<p class="question-date">'.$val['adddate'].'</p>';
            $this->html.='</span><span class="pull-right"><a>'.$val['floor'].lang('floor').'</a></span></div>';
            if ($val['last_reply']) {
                $val['last_reply']['content'] = htmlspecialchars_decode($val['last_reply']['content']);
                $this->html .= '<div class="clearfix"></div><blockquote>'.lang('reply') .'：'. $val['last_reply']['content'] . '</blockquote>';
            }
            //校验封禁
            if (!$val['state'] && !$this->isadministrator){
                $val['content']=lang('current_content_is_blocked');
            }
            //先剥去html代码   然后判断内容是否有链接  有的话增加标签
            $this->html.='<div class="question-reply-content" id="content_'.$val['id'].'">'.$this->_question->add_a_http( htmlspecialchars_decode($val['content'])).'</div>';
            $this->html.='<p class="question-item-info">';
            if ($yes_caina)
                $this->html.='<span class="question-adopt-ok"><a class="btn btn-default btn-sm"><i class="glyphicon glyphicon-ok"></i> <small>'.lang('adopted').'</small></a></span>';
            if ($no_caina==true){
                $this->html.='<span class="question-adopt"><a href="'.url('question/adopt/id/'.$val['id'].'/aid/'.$aid).'" class="btn btn-default btn-sm">'.lang('adopt').'</a></span>';
            }
            if ($this->view->user_state)
                $zanstate=$this->_question_like->getrow("rid='".$val['id']."' and mid=".$this->user['userid']);
            if ($state!=4)
                if (!is_array($zanstate))
                    $this->html.='<a class="btn btn-default btn-sm praise" onclick="likereply(this);" data-replyid="'.$val['id'].'"><i class="glyphicon glyphicon-eject"></i>'.lang('praise').'('.$val['like_count'].')</a>';
                else
                    $this->html.='<a class="btn btn-default btn-sm praise" onclick="nolikereply(this);" data-replyid="'.$val['id'].'"><i class="glyphicon glyphicon-eject"></i>'.lang('cancel_praise').'('.$val['like_count'].')</a>';
            if ($val['mid']!=$this->user['userid']  && $state!=4){
                if($this->questionconfigdata['question_reply_hf']){
                    if(($this->questionconfigdata['reply_vip'] && $this->user['groupid']!="1000") || !$this->questionconfigdata['reply_vip'])
                        $this->html.='<a class="btn btn-default btn-sm" data-toggle="modal" data-target="#myreplymode"onclick="$(\'[name=reply_verifycode]\').attr(\'style\',\'display: block;\');$(\'#reply_id\').val('.$val['id'].');$(\'#reply_update\').val(0);$(\'#reply-comment\').attr(\'style\',\'display:none;\');" href="#" >'.lang('take_part_in_a_discussion').'</a>';
                }
                $this->html.='<span class="question-price" data-toggle="tooltip" data-placement="top" title="'.lang_admin('reward_users_info').'">';
                if (count(pay::getInstance()->getrows(null, 0)) > 1 ||
                    (count(pay::getInstance()->getrows(null, 0)) == 1 && count(pay::getInstance()->getrows('pay_code="nopay"')) == 0)) {
                    $this->html .= '<a class="btn btn-default btn-sm" data-toggle="modal" data-target="#RewardModal" onclick="$(\'[name=rewardid]\').val(' . $val['id'] . ')">';
                }
                $this->html.='<i class="icon-present"></i>'.lang('reward');
                $this->html.='</a>';
                $this->html.='</span>';
            }
            if (($val['mid']==$this->user['userid'] || $this->isadministrator) && !$yes_caina && $state!=4){
                $thisdata=date('Y-m-d H:i:s', time());
                $oldadddate=$val['adddate'];
                $newdata=floor((strtotime($thisdata)-strtotime($oldadddate))%86400)/3600;   //计算出时间差
                if($newdata<$this->questionconfigdata['question_edit_reply']){
                    $val['content'] = str_replace(array("\r\n", "\r", "\n"), "",$val['content']);
                    $this->html.='<script>var content_'.$val['id'].'=\''.$val['content'].'\';</script>';
                    $this->html.='<a class="btn btn-default btn-sm" data-toggle="modal" data-target="#myreplymode"';
                    $this->html.=' onclick="$(\'[name=reply_verifycode]\').attr(\'style\',\'display: none;\'); editor_content_reply.txt.html(content_'.$val['id'].');$(\'#reply_update\').val(1);$(\'#reply_id\').val('.$val['id'].');$(\'#reply-comment\').attr(\'style\',\'display:none;\');" >'.lang('edit').'</a>';
                }
            }
            if ($this->isadministrator){
                $this->html.='<a class="btn btn-default btn-sm" name="deletereplyid" data-replyid="'.$val['id'].'">'.lang('delete').'</a>';
                if (!$val['state'])
                    $this->html.='<a class="btn btn-default btn-sm" name="nobanreply" data-replyid="'.$val['id'].'">'.lang('unseal').'</a>';
                else
                    $this->html.='<a class="btn btn-default btn-sm" name="banreply" data-replyid="'.$val['id'].'">'.lang('blocked').'</a>';
            }
            $this->html.=' </p></div></div>';
            /*
            if ($val['children']){
                $this->reply_son(1,$val['children']);
            }*/
        }
    }

    //新增评论
    function addreply_action(){
        if(front::$post['submit']){
            if($this->questionconfigdata['reply_verifycode']==1) {
                if (!session::get('verify') || front::post('verify') <> session::get('verify')) {
                    alerterror(lang('verification_code'));
                    return;
                }
            }else if($this->questionconfigdata['reply_verifycode'] == 2){
                if (!verify::checkGee()) {
                    alerterror(lang('verification_code'));
                    return;
                }
            }
            front::$post['content'] = htmlspecialchars_decode(front::$post['content']);

            front::$post['mid']=$this->user['userid'];
            front::$post['adddate']=date('Y-m-d H:i:s', time());
            front::$post['langid']=lang::getlangid(lang::getistemplate());    //语言
            front::$post['user_crossall']=$this->questionconfigdata['user_crossall'];    //跨域
            $floor=$this->_question_reply->rec_count("aid=".front::$post['aid'].' and langid='.lang::getlangid(lang::getistemplate()));
            front::$post['floor']=$floor+1;    //楼层
            if($this->questionconfigdata['reply_audit'])  //打开待审功能
                front::$post['state']=2;
            else
                front::$post['state']=1;
            $insert = $this->_question_reply->rec_insert(front::$post);
            //$_insertid = $this->_question->insert_id();
            if ($insert < 1) {
                front::alert(lang('comment').lang('failure'));  //评论失败
            }
            else {
                //增加通知
                if (front::$post['state']==1){
                    questionmessage::message_add(0,front::$post['aid'],2,0,1,$this->questionconfigdata['user_crossall']);
                }
                front::flash(lang('comment').lang('success'));
                front::redirect(url('question/showquestion/id/'.front::$post['aid']));
            }
        }
    }

    //采纳
    function adopt_action(){
        if(front::$get['id'] && front::$get['aid']){
            $_adoptquestion = $this->_question_reply ->getrow("state=1 and  isadopt=1 and aid='".front::$get['aid']."' ");  //已经被采纳的查询
            if (!is_array($_adoptquestion)){
                $this->_question_reply->rec_update(array("isadopt"=>1), "id=".front::$get['id']);

                //判断悬赏的打开
                $questiondata=$this->_question->getrow("id=".front::$get['aid']);
                $questionreplydata=$this->_question_reply->getrow("id=".front::$get['id']);
                //增加通知
                questionmessage::message_add($questionreplydata['mid'],front::$get['aid'],3,0,1,$this->questionconfigdata['user_crossall']);
                if ($questiondata['rewardmenoy']>0){
                    //修改悬赏记录
                    $this->_question_reward->rec_update(array("state"=>1,"rewarduid"=>$questionreplydata['mid']), "rid=".front::$get['aid']);
                    //发放悬赏金额
                    $rewarduser=user::getInstance()->getrow("userid='".$questionreplydata['mid']."'");
                    $rewardusermenoy=$rewarduser['menoy']+$questiondata['rewardmenoy'];
                    user::getInstance()->rec_update(array('menoy' => $rewardusermenoy), "userid='".$questionreplydata['mid']."'");
                    //增加通知
                    questionmessage::message_add($questionreplydata['mid'],$questionreplydata['aid'],5,$questiondata['rewardmenoy'],1,$this->questionconfigdata['user_crossall']);
                    //新增消费记录
                    $xfconsumption = new xfconsumption();
                    $xfconsumptiondata = array();
                    $xfconsumptiondata['status'] = '1';
                    $payname ='yuer';
                    $xfconsumptiondata['mid'] = $questiondata['uid'];
                    $xfconsumptiondata['oid'] = date('YmdHis') . '-' . $xfconsumptiondata['mid'] . '-' . $payname;
                    $xfconsumptiondata['menoy'] = $questiondata['rewardmenoy'];
                    $xfconsumptiondata['content'] = lang('questionreward').":".lang("questionreward")."ID为".front::$get['aid'];
                    $xfconsumptiondata['adddate'] = date('Y-m-d H:i:s', time());
                    $xfconsumptiondata['xftype'] =7;  //消费类型(1/商品消费 2/充值记录 3/插件模板消费 4/阅读下载购买 5/购买授权消费 6/问答打赏 7/问答悬赏 )
                    $xfconsumptiondata['trade_no'] = '';
                    //判断跨域
                    if ($this->questionconfigdata['user_crossall_state']){
                        $tbname = $xfconsumption->name;
                        $sql = $xfconsumption->sql_insert($tbname, $xfconsumptiondata);
                        $sql=user::lockString($sql,"sql");
                        $url=$this->questionconfigdata['user_crossall']."/index.php?case=crossall&act=execupdate&sql=".$sql;
                        $data= service::cmseayurl($url);
                    }
                    $xfconsumptiondata['user_crossall'] = $this->questionconfigdata['user_crossall'];
                    $xfconsumption->rec_insert($xfconsumptiondata);
                }
            }
        }
        front::flash(lang('adopt').lang('success'));
        front::redirect(url('question/showquestion/id/'.front::$get['aid']));
    }

    //删除评论
    function deletereply_action(){
        $aid = intval(front::post('aid'));
        $id = intval(front::post('id'));
        if ($aid){
            $_question = $this->_question ->getrow("id='$aid'");//当前问答
            if($this->isadministrator || $_question['uid']==$this->user['userid']){
                $delete = $this->_question_reply->rec_delete('id='.$id);
                if ($delete){
                    echo json_encode(array("state"=>1,"message"=>lang("delete").lang("success"))); //删除失败
                    exit;
                }
            }
        }
        echo json_encode(array("state"=>0,"message"=>lang("delete").lang("failure"))); //删除失败
        exit;
    }

    //封禁评论/解除封禁
    function banreply_action(){
        $id = intval(front::post('id'));
        if ($id){
            if (front::post('nobanreply'))
                $this->_question_reply->rec_update(array("state"=>1), "id=".$id);
            else
                $this->_question_reply->rec_update(array("state"=>0), "id=".$id);
            echo json_encode(array("state"=>1,"message"=>lang("success"))); //删除失败
            exit;
        }
        echo json_encode(array("state"=>0,"message"=>lang("failure"))); //删除失败
        exit;
    }

    //点赞评论
    function likereply_action(){
        $id = intval(front::post('id'));
        if ($id){
            if (front::post('nolikereply')){
                $where='id='.$id.' and mid='.$this->user['userid'];
                $delete = $this->_question_like->rec_delete('rid='.$id.' and mid='.$this->user['userid']);
                $like_count = $this->_question_like->rec_count('rid='.$id);
                if ($delete){
                    echo json_encode(array("state"=>1,"like_count"=>$like_count,"message"=>lang("cancel_some_praise").lang("success"))); //取消赞
                    exit;
                }
            }else{
                front::$post['mid']=$this->user['userid'];
                front::$post['rid']=$id;
                front::$post['type']=1; //点赞类型 1/评论2/问答
                front::$post['adddate']=date('Y-m-d H:i:s', time());
                unset(front::$post['id']);
                $insert = $this->_question_like->rec_insert(front::$post);
                if ($insert){
                    $like_count = $this->_question_like->rec_count('rid='.$id);
                    echo json_encode(array("state"=>1,"like_count"=>$like_count,"message"=>lang("point-like").lang("success"))); //赞
                    exit;
                }
            }

        }
        echo json_encode(array("state"=>0,"message"=>lang("failure"))); //删除失败
        exit;
    }

    //点赞问答
    function likequestion_action(){
        $id = intval(front::post('aid'));
        if ($id){
            if (front::post('nolikereply')){
                $where='id='.$id.' and mid='.$this->user['userid'];
                $delete = $this->_question_like->rec_delete('aid='.$id.' and mid='.$this->user['userid']);
                $like_count = $this->_question_like->rec_count('aid='.$id);
                if ($delete){
                    echo json_encode(array("state"=>1,"like_count"=>$like_count,"message"=>lang("cancel_some_praise").lang("success"))); //取消赞
                    exit;
                }
            }else{
                front::$post['mid']=$this->user['userid'];
                front::$post['aid']=$id;
                front::$post['type']=2; //点赞类型 1/评论2/问答
                front::$post['adddate']=date('Y-m-d H:i:s', time());
                unset(front::$post['id']);
                $insert = $this->_question_like->rec_insert(front::$post);
                if ($insert){
                    $like_count = $this->_question_like->rec_count('aid='.$id);
                    echo json_encode(array("state"=>1,"like_count"=>$like_count,"message"=>lang("point-like").lang("success"))); //赞
                    exit;
                }
            }

        }
        echo json_encode(array("state"=>0,"message"=>lang("failure"))); //删除失败
        exit;
    }

    //外链跳转
    function go_action(){
        if(front::$get['url']){
            $url=user::unlockString(front::$get['url'],"gourl");
            $this->view->url = $url;
        }
    }

    function end() {
        $nologin_arr = array('questionlist','showquestion','taglist','typelist','draftquestion');
        if (in_array(front::$act, $nologin_arr)) {
            //获取tag
            $tagdara=$this->_question_tag->getrows(array("langid"=>lang::getlangid(lang::getistemplate()),"is_to_index"=>1),0);
            foreach ($tagdara as $key=>$val){
                if ($this->isadministrator)
                    $tagdara[$key]['tagnum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and FIND_IN_SET(".$val['id'].',tag)');
                else
                    $tagdara[$key]['tagnum']=$this->_question->rec_count("user_crossall='".$this->questionconfigdata['user_crossall']."' and  state=1 and isadminsee=0 and FIND_IN_SET(".$val['id'].',tag)');
            }
            $tagdara=$this->arr_sort($tagdara,'tagnum');
            $this->view->tagdata=$tagdara;  //tag

            //热门问题
            $huoquestiondata=$this->_question->getrows('state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and user_crossall="'.$this->questionconfigdata['user_crossall'].'"',10,"browsenum desc");
            $this->view->huoquestiondata=$huoquestiondata;  //tag

            if ($this->view->user_state){
                //我关注的数量
                $seewhere = 'state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';
                $seewhere.=" and  FIND_IN_SET('".$this->user['userid']."',seemid)";
                $this->view->seemid_num=  $this->_question->rec_count($seewhere);
                //我的问题
                $mywhere = 'state=1 and langid = "'.lang::getlangid(lang::getistemplate()).'" and user_crossall="'.$this->questionconfigdata['user_crossall'].'"';
                $mywhere.=" and  uid=".$this->user['userid'];
                $this->view->myquestion_num=  $this->_question->rec_count($mywhere);
            }
        }
        $this->render();
        /* echo form::upload_image($item['name'], get($item['name'], true)); */
    }
}