<?php
namespace app\admin\controller;

use think\Controller;
use app\admin\model\Shopcate as ShopcateModel;
class Shopcate extends Common
{
    protected $beforeActionList = ['delsoncate' => ['only' => 'dels']];
    public function index()
    {
        $shopcate = new ShopcateModel();
        $gzc = $shopcate->catetree();
        $this->assign('gzc', $gzc);
        return view();
    }
    public function add()
    {
        $shopcate = new ShopcateModel();
        if (request()->isPost()) {
            $data = input('post.');
            $data['time'] = time();
            if ($shopcate->add($data)) {
                return json(array('code' => 200, 'msg' => '添加成功'));
            } else {
                return json(array('code' => 0, 'msg' => '添加失败'));
            }
        }
        $gzc = $shopcate->catetree();
        $this->assign('gzc', $gzc);
        return view();
    }
    public function edit()
    {
        $shopcate = new ShopcateModel();
        if (request()->isPost()) {
            $data = input('post.');
            if ($shopcate->edit($data)) {
                return json(array('code' => 200, 'msg' => '修改成功'));
            } else {
                return json(array('code' => 0, 'msg' => '修改失败'));
            }
        }
        $gzc = $shopcate->find(input('id'));
        $gzcs = $shopcate->catetree();
        $this->assign(array('gzcs' => $gzcs, 'gzc' => $gzc));
        return view();
    }
    public function dels()
    {
        $dels = db('shopcate')->delete(input('id'));
        if ($dels) {
            return json(array('code' => 200, 'msg' => '删除成功'));
        } else {
            return json(array('code' => 0, 'msg' => '删除失败'));
        }
    }
    public function delsoncate()
    {
        $cateid = input('id');
        $shopcate = new ShopcateModel();
        $sonids = $shopcate->getchilrenid($cateid);
        if ($sonids) {
            db('shopcate')->delete($sonids);
        }
    }
    public function changeshow()
    {
        if (request()->isAjax()) {
            $change = input('change');
            $show = db('shopcate')->field('show')->where('id', $change)->find();
            $show = $show['show'];
            if ($show == 1) {
                db('shopcate')->where('id', $change)->update(['show' => 0]);
                echo 1;
            } else {
                db('shopcate')->where('id', $change)->update(['show' => 1]);
                echo 2;
            }
        } else {
            $this->error('非法操作');
        }
    }
    public function changesidebar()
    {
        if (request()->isAjax()) {
            $change = input('change');
            $sidebar = db('shopcate')->field('sidebar')->where('id', $change)->find();
            $sidebar = $sidebar['sidebar'];
            if ($sidebar == 1) {
                db('shopcate')->where('id', $change)->update(['sidebar' => 0]);
                echo 1;
            } else {
                db('shopcate')->where('id', $change)->update(['sidebar' => 1]);
                echo 2;
            }
        } else {
            $this->error('非法操作');
        }
    }
}